/*
 * Decompiled with CFR 0.152.
 */
package flatgui.core.websocket;

import clojure.lang.RT;
import clojure.lang.Var;
import flatgui.core.FGWebContainerWrapper;
import flatgui.core.IFGContainer;
import flatgui.core.websocket.FGAppServer;
import flatgui.core.websocket.FGContainerWebSocket;
import flatgui.core.websocket.FGInputEventDecoder;
import flatgui.core.websocket.FGWebInteropUtil;
import java.awt.Font;
import java.util.Set;
import java.util.concurrent.atomic.LongAccumulator;

public class FGContainerSession {
    private static final long IDLE_MARKER = -1L;
    private static final Var strToFont_ = RT.var((String)"flatgui.awt", (String)"str->font");
    private final Object sessionId_;
    private final FGWebContainerWrapper containerWrapper_;
    private final FGInputEventDecoder parser_;
    private final LongAccumulator lastAccessTime_;
    private final FGWebInteropUtil interopUtil_;
    private volatile FGContainerWebSocket accosiatedWebSocket_;

    public FGContainerSession(IFGContainer iFGContainer, Set<String> set) {
        this.sessionId_ = iFGContainer.getId();
        this.containerWrapper_ = new FGWebContainerWrapper(iFGContainer, set);
        this.containerWrapper_.initialize();
        this.interopUtil_ = (FGWebInteropUtil)iFGContainer.getInterop();
        this.containerWrapper_.addFontStrListener(fGChangeEvent -> this.interopUtil_.setReferenceFont((String)fGChangeEvent.getNewValue(), (Font)strToFont_.invoke(fGChangeEvent.getNewValue())));
        this.parser_ = new FGInputEventDecoder();
        this.lastAccessTime_ = new LongAccumulator((l, l2) -> l2, 0L);
    }

    public FGWebContainerWrapper getContainer() {
        return this.containerWrapper_;
    }

    public FGInputEventDecoder getParser() {
        return this.parser_;
    }

    public void markIdle() {
        FGAppServer.getFGLogger().info(this.toString() + " has been marked as idle.");
        this.lastAccessTime_.accumulate(-1L);
    }

    public void markAccesed() {
        if (this.isMarkedIdle()) {
            FGAppServer.getFGLogger().info(this.toString() + " has been restored from idle state due to new activity.");
        }
        this.lastAccessTime_.accumulate(System.currentTimeMillis());
    }

    public boolean isIdle(long l) {
        boolean bl;
        boolean bl2 = bl = this.isMarkedIdle() || this.lastAccessTime_.get() + l < System.currentTimeMillis();
        if (bl) {
            if (!this.isMarkedIdle()) {
                FGAppServer.getFGLogger().info(this.toString() + " has been detected idle for more than " + l + " millis.");
            }
            this.markIdle();
        }
        return bl;
    }

    public boolean isActive() {
        return this.containerWrapper_.isActive();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.sessionId_ + "]";
    }

    Object getContainerLock() {
        return this.containerWrapper_;
    }

    void setAccosiatedWebSocket(FGContainerWebSocket fGContainerWebSocket) {
        this.accosiatedWebSocket_ = fGContainerWebSocket;
    }

    public FGContainerWebSocket getAccosiatedWebSocket() {
        return this.accosiatedWebSocket_;
    }

    private boolean isMarkedIdle() {
        return this.lastAccessTime_.get() == -1L;
    }
}

