/*
 * Decompiled with CFR 0.152.
 */
package flatgui.core.awt;

import flatgui.core.FGHostStateEvent;
import flatgui.core.IFGInteropUtil;
import flatgui.core.awt.FGAWTInteropUtil;
import flatgui.core.awt.FGDefaultPrimitivePainter;
import flatgui.core.awt.IFGPrimitivePainter;
import flatgui.core.util.Tuple;
import java.awt.Canvas;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Consumer;

public abstract class AbstractHostComponent
extends Canvas {
    private IFGPrimitivePainter primitivePainter_;
    private Image bufferImage_;
    private boolean appTriggered_ = false;
    private final FGAWTInteropUtil interopUtil_;
    private String lastUserDefinedFontStr_ = null;
    private Font lastUserDefinedFont_ = null;

    public AbstractHostComponent() {
        this.setFocusTraversalKeysEnabled(false);
        this.interopUtil_ = new FGAWTInteropUtil(64);
        this.primitivePainter_ = new FGDefaultPrimitivePainter(64.0);
        this.primitivePainter_.addFontChangeListener(fGChangeEvent -> {
            Tuple tuple = (Tuple)fGChangeEvent.getNewValue();
            this.lastUserDefinedFontStr_ = (String)tuple.getFirst();
            this.lastUserDefinedFont_ = (Font)tuple.getSecond();
            this.interopUtil_.setReferenceFont(this.lastUserDefinedFontStr_, this.lastUserDefinedFont_);
        });
        this.setFocusable(true);
        Consumer<Object> consumer = this::acceptEvolveReason;
        ActionListener actionListener = actionEvent -> this.resetPendingImage();
        this.addMouseListener(new ContainerMouseListener(consumer));
        this.addMouseMotionListener(new ContainerMouseMotionListener(consumer));
        this.addMouseWheelListener(new ContainerMouseWheelListener(consumer));
        this.addKeyListener(new ContainerKeyListener(consumer));
        this.addComponentListener(new ContainerComponentListener(consumer, actionListener));
        AbstractHostComponent.setupBlinkHelperTimer(consumer);
    }

    public final IFGInteropUtil getInterop() {
        return this.interopUtil_;
    }

    public static Timer setupBlinkHelperTimer(Consumer<Object> consumer) {
        Timer timer2 = new Timer("FlatGUI Blink Helper Timer", true);
        timer2.schedule(new TimerTask(){

            @Override
            public void run() {
            }
        }, 530L, 530L);
        return timer2;
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.appTriggered_) {
            graphics.drawImage(this.getPendingImage(), 0, 0, null);
        } else {
            graphics.drawImage(this.getPendingImage(), 0, 0, null);
        }
        this.appTriggered_ = false;
    }

    @Override
    public void update(Graphics graphics) {
        try {
            Rectangle rectangle = graphics.getClipBounds();
            double d = rectangle.getX() / 64.0;
            double d2 = rectangle.getY() / 64.0;
            double d3 = rectangle.getWidth() / 64.0;
            double d4 = rectangle.getHeight() / 64.0;
            Graphics graphics2 = this.getBufferGraphics();
            ((Graphics2D)graphics2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.lastUserDefinedFont_ != null) {
                graphics2.setFont(this.lastUserDefinedFont_);
            } else {
                this.interopUtil_.setReferenceFont(null, graphics2.getFont());
            }
            this.interopUtil_.setReferenceGraphics(graphics2);
            this.paintAll(graphics2, d, d2, d3, d4);
            this.appTriggered_ = true;
            this.paint(graphics);
            this.changeCursorIfNeeded();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected abstract void changeCursorIfNeeded() throws Exception;

    protected abstract void paintAll(Graphics var1, double var2, double var4, double var6, double var8) throws Exception;

    Image getPendingImage() {
        if (this.bufferImage_ == null) {
            this.bufferImage_ = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        }
        return this.bufferImage_;
    }

    private Graphics getBufferGraphics() {
        return this.getPendingImage().getGraphics();
    }

    private void resetPendingImage() {
        this.bufferImage_ = null;
    }

    protected abstract void acceptEvolveReason(Object var1);

    protected final IFGPrimitivePainter getPrimitivePainter() {
        return this.primitivePainter_;
    }

    private static class ContainerComponentListener
    extends ContainerListener
    implements ComponentListener {
        private final ActionListener resizeProcessor_;

        ContainerComponentListener(Consumer<Object> consumer, ActionListener actionListener) {
            super(consumer);
            this.resizeProcessor_ = actionListener;
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            this.resizeProcessor_.actionPerformed(null);
            this.eventImpl(ContainerComponentListener.parseResizeEvent(componentEvent));
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
        }

        private static FGHostStateEvent parseResizeEvent(ComponentEvent componentEvent) {
            return FGHostStateEvent.createHostSizeEvent(componentEvent.getComponent().getSize());
        }
    }

    private static class ContainerKeyListener
    extends ContainerListener
    implements KeyListener {
        ContainerKeyListener(Consumer<Object> consumer) {
            super(consumer);
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            this.eventImpl(keyEvent);
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            this.eventImpl(keyEvent);
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            this.eventImpl(keyEvent);
        }
    }

    private static class ContainerMouseWheelListener
    extends ContainerListener
    implements MouseWheelListener {
        ContainerMouseWheelListener(Consumer<Object> consumer) {
            super(consumer);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            this.eventImpl(mouseWheelEvent);
        }
    }

    private static class ContainerMouseMotionListener
    extends ContainerListener
    implements MouseMotionListener {
        ContainerMouseMotionListener(Consumer<Object> consumer) {
            super(consumer);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.eventImpl(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.eventImpl(mouseEvent);
        }
    }

    private static class ContainerMouseListener
    extends ContainerListener
    implements MouseListener {
        ContainerMouseListener(Consumer<Object> consumer) {
            super(consumer);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.eventImpl(mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.eventImpl(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.eventImpl(mouseEvent);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.eventImpl(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.eventImpl(mouseEvent);
        }
    }

    private static class ContainerListener {
        private final Consumer<Object> eventConsumer_;

        ContainerListener(Consumer<Object> consumer) {
            this.eventConsumer_ = consumer;
        }

        protected final void eventImpl(Object object) {
            this.eventConsumer_.accept(object);
        }
    }
}

