/*
 * Decompiled with CFR 0.152.
 */
package flatgui.util;

import flatgui.util.IObjectListCoder;
import java.util.List;
import java.util.Objects;

public class ObjectTree<T>
implements IObjectListCoder<T> {
    private static final int ROOT_CAPACITY = 8;
    private static final int NODE_CAPACITY = 12;
    private Node<T> root_;

    public ObjectTree(T t) {
        this.root_ = new Node<T>(t, 8);
    }

    @Override
    public int[] addPath(List<T> list) {
        if (!Objects.equals(this.root_.getObject(), list.get(0))) {
            throw new IllegalArgumentException("Cannot add path that starts with '" + list.get(0) + "' to the tree where the root is '" + this.root_.getObject() + "'");
        }
        int[] nArray = new int[list.size()];
        nArray[0] = 0;
        Node<T> node = this.root_;
        for (int i = 1; i < list.size(); ++i) {
            T t = list.get(i);
            int n = node.getChildIndexByObject(t);
            if (n >= 0) {
                node = node.getChildAt(n);
            } else {
                Node<T> node2 = new Node<T>(t, 12);
                n = node.addChild(node2);
                node = node2;
            }
            nArray[i] = n;
        }
        return nArray;
    }

    public final Node<T> getRoot() {
        return this.root_;
    }

    public static class Node<T> {
        private T object_;
        private Node<T>[] children_;
        private int size_;

        public Node(T t, int n) {
            this.object_ = t;
            this.children_ = new Node[n];
        }

        public T getObject() {
            return this.object_;
        }

        public int addChild(Node<T> node) {
            int n = this.size_++;
            this.children_[n] = node;
            return n;
        }

        public Node<T> getChildAt(int n) {
            return this.children_[n];
        }

        public Node<T> getChildByObject(T t) {
            for (int i = 0; i < this.size_; ++i) {
                Node<T> node = this.children_[i];
                if (!Objects.equals(node.getObject(), t)) continue;
                return node;
            }
            return null;
        }

        public int getChildIndexByObject(T t) {
            for (int i = 0; i < this.size_; ++i) {
                Node<T> node = this.children_[i];
                if (!Objects.equals(node.getObject(), t)) continue;
                return i;
            }
            return -1;
        }

        public int getChildCount() {
            return this.size_;
        }
    }
}

