/*
 * Decompiled with CFR 0.152.
 */
package flatgui.core.engine.ui;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.PersistentHashMap;
import clojure.lang.RT;
import clojure.lang.Var;
import flatgui.core.engine.Container;
import flatgui.core.engine.IResultCollector;
import flatgui.core.engine.ui.FGClojureContainerParser;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class FGClojureResultCollector
implements IResultCollector,
ClipboardOwner {
    private static final Keyword VISIBLE_POPUP_KW = Keyword.intern((String)"_visible-popup");
    private static final Keyword TO_CLIPBOARD_KW = Keyword.intern((String)"->clipboard");
    private static final Var rebuildLook_ = RT.var((String)"flatgui.paint", (String)"rebuild-look");
    private final int unitSizePx_;
    private final Map<Integer, Set<Integer>> parentToVisiblePopupChildCount_;
    private final Set<Integer> changedComponents_;
    private final List<List<Object>> lookVectors_;
    private final List<Object> PUSH_CURRENT_CLIP = Collections.unmodifiableList(Arrays.asList("pushCurrentClip"));
    private final List<Object> POP_CURRENT_CLIP = Collections.unmodifiableList(Arrays.asList("popCurrentClip"));
    private final List<Object> SET_CLIP = Arrays.asList("setClip", 0, 0, null, null);
    private final List<Object> CLIP_RECT = Arrays.asList("clipRect", 0, 0, null, null);
    private final List<Object> TRANSFORM = Arrays.asList("transform", null);
    private final Set<Integer> changedComponentsForRemote_ = new HashSet<Integer>();

    public FGClojureResultCollector(int n) {
        this.changedComponents_ = new HashSet<Integer>();
        this.parentToVisiblePopupChildCount_ = new HashMap<Integer, Set<Integer>>();
        this.lookVectors_ = new ArrayList<List<Object>>();
        this.unitSizePx_ = n;
    }

    @Override
    public void componentAdded(Integer n, Integer n2) {
        if (n2 >= this.lookVectors_.size()) {
            int n3 = n2 + 1 - this.lookVectors_.size();
            for (int i = 0; i < n3; ++i) {
                this.lookVectors_.add(null);
            }
        }
    }

    @Override
    public void componentRemoved(Integer n) {
        this.lookVectors_.set(n, null);
        this.parentToVisiblePopupChildCount_.remove(n);
        this.changedComponents_.remove(n);
        this.changedComponentsForRemote_.remove(n);
    }

    @Override
    public void componentInitialized(Container container, Integer n) {
    }

    @Override
    public void appendResult(Integer n, List<Object> list, Container.Node node, Object object) {
        Integer n2 = node.getComponentUid();
        Object object2 = node.getPropertyId();
        this.changedComponents_.add(n2);
        this.changedComponentsForRemote_.add(n2);
        if (object2.equals(VISIBLE_POPUP_KW)) {
            Set<Integer> set = this.parentToVisiblePopupChildCount_.get(n);
            if (set == null) {
                set = new HashSet<Integer>();
                this.parentToVisiblePopupChildCount_.put(n, set);
            }
            if (object != null && (!(object instanceof Boolean) || ((Boolean)object).booleanValue())) {
                set.add(n2);
            } else {
                set.remove(n2);
            }
        } else if (object != null && object2.equals(TO_CLIPBOARD_KW) && !GraphicsEnvironment.isHeadless()) {
            Clipboard clipboard2 = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard2.setContents((Transferable)object, this);
        }
    }

    @Override
    public void postProcessAfterEvolveCycle(Container.IContainerAccessor iContainerAccessor, Container.IContainerMutator iContainerMutator) {
        for (Integer n : this.changedComponents_) {
            Container.IComponent iComponent = iContainerAccessor.getComponent(n);
            FGClojureContainerParser.FGComponentDataCache fGComponentDataCache = (FGClojureContainerParser.FGComponentDataCache)iComponent.getCustomData();
            IPersistentMap iPersistentMap = PersistentHashMap.create((Map)iComponent);
            Object object = rebuildLook_.invoke((Object)iPersistentMap);
            List list = (List)rebuildLook_.invoke((Object)iPersistentMap);
            iContainerMutator.setValue(fGComponentDataCache.getLookVecIndex(), list);
            this.lookVectors_.set(n, list);
            this.lookVectorGenerated(n, list);
        }
        this.changedComponents_.clear();
    }

    protected void lookVectorGenerated(Integer n, List<Object> list) {
    }

    boolean hasVisiblePopupChildren(Integer n) {
        Set<Integer> set = this.parentToVisiblePopupChildCount_.get(n);
        return set != null && !set.isEmpty();
    }

    private static Double mxGet(List<List<Number>> list, int n, int n2) {
        return list.get(n).get(n2).doubleValue();
    }

    private static Double mxX(List<List<Number>> list) {
        return FGClojureResultCollector.mxGet(list, 0, 0);
    }

    private static Double mxY(List<List<Number>> list) {
        return FGClojureResultCollector.mxGet(list, 1, 0);
    }

    private final AffineTransform affineTransform(List<List<Number>> list) {
        double d = list.get(0).get(0).doubleValue();
        double d2 = list.get(1).get(0).doubleValue();
        double d3 = list.get(0).get(1).doubleValue();
        double d4 = list.get(1).get(1).doubleValue();
        double d5 = (double)this.unitSizePx_ * list.get(0).get(3).doubleValue();
        double d6 = (double)this.unitSizePx_ * list.get(1).get(3).doubleValue();
        return new AffineTransform(d, d2, d3, d4, d5, d6);
    }

    private final List<Object> setClip(Double d, Double d2) {
        this.SET_CLIP.set(3, d);
        this.SET_CLIP.set(4, d2);
        return this.SET_CLIP;
    }

    private final List<Object> clipRect(Double d, Double d2) {
        this.CLIP_RECT.set(3, d);
        this.CLIP_RECT.set(4, d2);
        return this.CLIP_RECT;
    }

    private final List<Object> transform(AffineTransform affineTransform) {
        this.TRANSFORM.set(1, affineTransform);
        return this.TRANSFORM;
    }

    void paintComponentWithChildren(Consumer<List<Object>> consumer, Container.IContainerAccessor iContainerAccessor, Container.IPropertyValueAccessor iPropertyValueAccessor, Integer n) throws NoninvertibleTransformException {
        List<Object> list = this.lookVectors_.get(n);
        if (list == null) {
            return;
        }
        Container.IComponent iComponent = iContainerAccessor.getComponent(n);
        FGClojureContainerParser.FGComponentDataCache fGComponentDataCache = (FGClojureContainerParser.FGComponentDataCache)iComponent.getCustomData();
        Object object = iPropertyValueAccessor.getPropertyValue(fGComponentDataCache.getVisibleIndex());
        if (object == null || object instanceof Boolean && !((Boolean)object).booleanValue()) {
            return;
        }
        Object object2 = iPropertyValueAccessor.getPropertyValue(fGComponentDataCache.getPositionMatrixIndex());
        AffineTransform affineTransform = this.affineTransform((List)object2);
        AffineTransform affineTransform2 = affineTransform.createInverse();
        Object object3 = iPropertyValueAccessor.getPropertyValue(fGComponentDataCache.getViewportMatrixIndex());
        AffineTransform affineTransform3 = this.affineTransform((List)object3);
        AffineTransform affineTransform4 = affineTransform3.createInverse();
        List list2 = (List)iPropertyValueAccessor.getPropertyValue(fGComponentDataCache.getClipSizeIndex());
        Double d = FGClojureResultCollector.mxX(list2);
        Double d2 = FGClojureResultCollector.mxY(list2);
        Boolean bl = (Boolean)iPropertyValueAccessor.getPropertyValue(fGComponentDataCache.getPopupIndex());
        consumer.accept(this.PUSH_CURRENT_CLIP);
        consumer.accept(this.transform(affineTransform));
        consumer.accept(bl != false ? this.setClip(d, d2) : this.clipRect(d, d2));
        consumer.accept(this.transform(affineTransform3));
        consumer.accept(list);
        Integer n2 = fGComponentDataCache.getChildrenIndex();
        if (n2 != null) {
            for (Integer n3 : iComponent.getChildIndices()) {
                try {
                    this.paintComponentWithChildren(consumer, iContainerAccessor, iPropertyValueAccessor, n3);
                }
                catch (Throwable throwable) {
                    System.out.println("ERROR painting component " + n3 + " " + iContainerAccessor.getComponent(n3).get(FGClojureContainerParser.ID_KW));
                    throw throwable;
                }
            }
        }
        consumer.accept(this.transform(affineTransform4));
        consumer.accept(this.transform(affineTransform2));
        consumer.accept(this.POP_CURRENT_CLIP);
    }

    Set<Integer> getChangedComponentsForRemote() {
        return this.changedComponentsForRemote_;
    }

    void clearChangedComponentsForWeb() {
        this.changedComponentsForRemote_.clear();
    }

    void collectPaintAllSequence(List<Object> list, Container.IContainerAccessor iContainerAccessor, Integer n) {
        Container.IComponent iComponent = iContainerAccessor.getComponent(n);
        FGClojureContainerParser.FGComponentDataCache fGComponentDataCache = (FGClojureContainerParser.FGComponentDataCache)iComponent.getCustomData();
        list.add(n);
        Integer n2 = fGComponentDataCache.getChildrenIndex();
        if (n2 != null) {
            for (Integer n3 : iComponent.getChildIndices()) {
                this.collectPaintAllSequence(list, iContainerAccessor, n3);
            }
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard2, Transferable transferable) {
    }
}

