/*
 * Decompiled with CFR 0.152.
 */
package flatgui.core.engine.ui;

import clojure.lang.Keyword;
import flatgui.core.engine.ClojureContainerParser;
import flatgui.core.engine.Container;
import java.util.List;
import java.util.Map;

public class FGClojureContainerParser
extends ClojureContainerParser {
    static final Keyword ID_KW = Keyword.intern((String)"id");
    private static final Keyword LOOK_VEC_KW = Keyword.intern((String)"look-vec");
    private static final Keyword POSITION_MATRIX_KW = Keyword.intern((String)"position-matrix");
    private static final Keyword CLIP_SIZE_KW = Keyword.intern((String)"clip-size");
    private static final Keyword POPUP_KW = Keyword.intern((String)"popup");
    private static final Keyword VIEWPORT_MATRIX_KW = Keyword.intern((String)"viewport-matrix");
    private static final Keyword CHILDREN_KW = Keyword.intern((String)"children");
    private static final Keyword VISIBLE_KW = Keyword.intern((String)"visible");
    private static final Keyword FOCUS_STATE_KW = Keyword.intern((String)"focus-state");
    private static final Keyword MODE_KW = Keyword.intern((String)"mode");
    private static final Keyword HAS_FOCUS_KW = Keyword.intern((String)"has-focus");
    private static final Keyword PARENT_OF_FOCUSED_KW = Keyword.intern((String)"parent-of-focused");
    private static final Keyword FOCUSED_CHILD_KW = Keyword.intern((String)"focused-child");
    private static final Keyword CHILDREN_Z_ORDER_KW = Keyword.intern((String)"children-z-order");

    @Override
    public void processComponentAfterIndexing(Container.IComponent iComponent) {
        FGComponentDataCache fGComponentDataCache = new FGComponentDataCache();
        fGComponentDataCache.setLookVecIndex(FGClojureContainerParser.getPropertyIndex(iComponent, LOOK_VEC_KW));
        fGComponentDataCache.setPositionMatrixIndex(FGClojureContainerParser.getPropertyIndex(iComponent, POSITION_MATRIX_KW));
        fGComponentDataCache.setClipSizeIndex(FGClojureContainerParser.getPropertyIndex(iComponent, CLIP_SIZE_KW));
        fGComponentDataCache.setPopupIndex(FGClojureContainerParser.getPropertyIndex(iComponent, POPUP_KW));
        fGComponentDataCache.setViewportMatrixIndex(FGClojureContainerParser.getPropertyIndex(iComponent, VIEWPORT_MATRIX_KW));
        fGComponentDataCache.setChildrenIndex(iComponent.getPropertyIndex(CHILDREN_KW));
        fGComponentDataCache.setVisibleIndex(iComponent.getPropertyIndex(VISIBLE_KW));
        fGComponentDataCache.setFocusStateIndex(iComponent.getPropertyIndex(FOCUS_STATE_KW));
        iComponent.setCustomData(fGComponentDataCache);
    }

    @Override
    public Object getChildOrderPropertyName() {
        return CHILDREN_Z_ORDER_KW;
    }

    @Override
    public List<Object> getChildOrder(Map<Object, Object> map) {
        List<Object> list = (List<Object>)map.get(CHILDREN_Z_ORDER_KW);
        return list != null ? list : super.getChildOrder(map);
    }

    public static Object getFocusMode(Map<Object, Object> map) {
        return map.get(MODE_KW);
    }

    public static boolean hasFocus(Object object) {
        return HAS_FOCUS_KW.equals(object);
    }

    public static boolean parentOfFocused(Object object) {
        return PARENT_OF_FOCUSED_KW.equals(object);
    }

    public static Object getFocusedChildId(Map<Object, Object> map) {
        return map.get(FOCUSED_CHILD_KW);
    }

    private static Integer getPropertyIndex(Container.IComponent iComponent, Object object) {
        Integer n = iComponent.getPropertyIndex(object);
        if (n == null) {
            throw new IllegalArgumentException(FGClojureContainerParser.class.getSimpleName() + ": requires container " + iComponent.get(ID_KW) + " to have " + object + " property");
        }
        return n;
    }

    public static class FGComponentDataCache {
        private Integer lookVecIndex_;
        private Integer positionMatrixIndex_;
        private Integer clipSizeIndex_;
        private Integer popupIndex_;
        private Integer viewportMatrixIndex_;
        private Integer childrenIndex_;
        private Integer visibleIndex_;
        private Integer focusStateIndex_;

        public Integer getLookVecIndex() {
            return this.lookVecIndex_;
        }

        public void setLookVecIndex(Integer n) {
            this.lookVecIndex_ = n;
        }

        public Integer getPositionMatrixIndex() {
            return this.positionMatrixIndex_;
        }

        public void setPositionMatrixIndex(Integer n) {
            this.positionMatrixIndex_ = n;
        }

        public Integer getClipSizeIndex() {
            return this.clipSizeIndex_;
        }

        public void setClipSizeIndex(Integer n) {
            this.clipSizeIndex_ = n;
        }

        public Integer getPopupIndex() {
            return this.popupIndex_;
        }

        public void setPopupIndex(Integer n) {
            this.popupIndex_ = n;
        }

        public Integer getViewportMatrixIndex() {
            return this.viewportMatrixIndex_;
        }

        public void setViewportMatrixIndex(Integer n) {
            this.viewportMatrixIndex_ = n;
        }

        public Integer getChildrenIndex() {
            return this.childrenIndex_;
        }

        public void setChildrenIndex(Integer n) {
            this.childrenIndex_ = n;
        }

        public Integer getVisibleIndex() {
            return this.visibleIndex_;
        }

        public void setVisibleIndex(Integer n) {
            this.visibleIndex_ = n;
        }

        public Integer getFocusStateIndex() {
            return this.focusStateIndex_;
        }

        public void setFocusStateIndex(Integer n) {
            this.focusStateIndex_ = n;
        }
    }
}

