/*
 * Decompiled with CFR 0.152.
 */
package flatgui.core.engine;

import clojure.lang.IFn;
import clojure.lang.IMeta;
import clojure.lang.Keyword;
import clojure.lang.RT;
import clojure.lang.Var;
import flatgui.core.FGClipboardEvent;
import flatgui.core.FGHostStateEvent;
import flatgui.core.FGTimerEvent;
import flatgui.core.awt.FGMouseEvent;
import flatgui.core.awt.FGMouseWheelEvent;
import flatgui.core.engine.Container;
import flatgui.core.engine.GetPropertyStaticClojureFn;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ClojureContainerParser
implements Container.IContainerParser {
    private static final Keyword ID_KEY = Keyword.intern((String)"id");
    private static final Keyword CHILDREN_KEY = Keyword.intern((String)"children");
    private static final Keyword EVOLVERS_KEY = Keyword.intern((String)"evolvers");
    private static final Keyword SOURCE_META_KEY = Keyword.intern((String)"source");
    private static final Keyword SYMBOL_META_KEY = Keyword.intern((String)"ns-qualified-sym");
    private static final Keyword INPUT_DEPENDENCIES_META_KEY = Keyword.intern((String)"input-channel-dependencies");
    private static final Keyword RELATIVE_DEPENDENCIES_META_KEY = Keyword.intern((String)"relative-dependencies");
    private static final Keyword THIS_KW = Keyword.intern((String)"this");
    private static final Keyword UP_LEVEL_KW = Keyword.intern((String)"_");
    private static final String FG_NS = "flatgui.core";
    private static final String FG_DEP_NS = "flatgui.dependency";
    private static final Var collectAllEvolverDependencies_ = RT.var((String)"flatgui.core", (String)"collect-all-evolver-dependencies");
    private static final Var compileEvolver_ = RT.var((String)"flatgui.core", (String)"compile-evolver");
    private static final Var getInputDependencies_ = RT.var((String)"flatgui.dependency", (String)"get-input-dependencies");
    private static final Keyword WILDCARD_KEY = Keyword.intern((String)"*");
    private static final Map<Class<?>, Keyword> INPUT_EVENT_KEYS;

    @Override
    public Object getComponentId(Map<Object, Object> map) {
        return map.get(ClojureContainerParser.getIdKey());
    }

    public static Object getIdKey() {
        return ID_KEY;
    }

    @Override
    public Object getChildOrderPropertyName() {
        return null;
    }

    @Override
    public List<Object> getChildOrder(Map<Object, Object> map) {
        Map map2 = (Map)map.get(this.getChildrenPropertyName());
        return map2 != null ? new ArrayList(map2.keySet()) : null;
    }

    @Override
    public Object getChildrenPropertyName() {
        return CHILDREN_KEY;
    }

    @Override
    public Collection<Container.SourceNode> processComponent(List<Object> list3, Map<Object, Object> map, Container.IPropertyValueAccessor iPropertyValueAccessor) {
        Map map2 = (Map)map.get(EVOLVERS_KEY);
        ArrayList<Container.SourceNode> arrayList = new ArrayList<Container.SourceNode>(map.size());
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.addAll(map.keySet());
        if (map2 != null) {
            hashSet.addAll(map2.keySet());
        }
        for (Object e : hashSet) {
            ArrayList<Object> arrayList2 = new ArrayList<Object>(list3.size() + 1);
            arrayList2.addAll(list3);
            arrayList2.add(e);
            boolean bl = map2 != null && map2.get(e) != null;
            Object var11_11 = map2 != null ? map2.get(e) : null;
            List list4 = null;
            Collection<Object> collection = Collections.emptySet();
            Collection<Container.DependencyInfo> collection2 = Collections.emptySet();
            if (bl) {
                IFn iFn = var11_11;
                if (iFn instanceof Var.Unbound) {
                    throw new IllegalStateException("unbound evolver fn: " + list3 + " " + e);
                }
                Map map3 = (Map)((IMeta)iFn).meta();
                if (map3 == null) {
                    throw new IllegalStateException("null meta of evolver fn: " + list3 + " " + e);
                }
                list4 = (List)map3.get(INPUT_DEPENDENCIES_META_KEY);
                collection = (Collection)map3.get(RELATIVE_DEPENDENCIES_META_KEY);
                boolean bl2 = list3.size() == 1;
                collection2 = collection.stream().filter(list -> !bl2 || list.size() > 1).map(list2 -> new Container.DependencyInfo((List<Object>)list2, ClojureContainerParser.buildAbsPath(list3, list2), list2.stream().anyMatch(object -> WILDCARD_KEY.equals(object)))).collect(Collectors.toList());
            }
            arrayList.add(new Container.SourceNode(e, this.getChildrenPropertyName().equals(e), this.getChildOrderPropertyName() != null && this.getChildOrderPropertyName().equals(e), arrayList2, bl ? collection2 : Collections.emptySet(), bl ? var11_11 : null, bl ? list4 : null));
        }
        return arrayList;
    }

    @Override
    public Function<Map<Object, Object>, Object> compileEvolverCode(Object object, Object object2, Function<List<Object>, Integer> function, List<Object> list, Container.IPropertyValueAccessor iPropertyValueAccessor) {
        if (object2 != null) {
            try {
                IFn iFn = (IFn)object2;
                return new EvolverWrapper(iFn, list, function, iPropertyValueAccessor);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return map -> {
                    throw new IllegalStateException("Could not instantiate evolver for " + list + " " + object);
                };
            }
        }
        return map -> {
            throw new IllegalStateException("No evolver for " + list + " " + object);
        };
    }

    @Override
    public boolean isInterestedIn(Collection<Object> collection, Class<?> clazz) {
        Keyword keyword = INPUT_EVENT_KEYS.get(clazz);
        return keyword != null ? collection.contains(keyword) : true;
    }

    @Override
    public boolean isWildcardPathElement(Object object) {
        return WILDCARD_KEY.equals(object);
    }

    @Override
    public void processComponentAfterIndexing(Container.IComponent iComponent) {
    }

    static List<Object> buildAbsPath(List<Object> list, List<Object> list2) {
        List<Object> list3 = new ArrayList<Object>(list);
        if (list2.isEmpty()) {
            list3.remove(list3.size() - 1);
        } else if (list2.get(0).equals(THIS_KW)) {
            ArrayList<Object> arrayList = new ArrayList<Object>(list2);
            arrayList.remove(0);
            list3.addAll(arrayList);
        } else if (list2.get(0).equals(UP_LEVEL_KW)) {
            int n;
            for (n = 0; n < list2.size() && list2.get(n).equals(UP_LEVEL_KW); ++n) {
            }
            int n2 = list.size() - n - 1;
            list3 = list3.subList(0, n2);
            list3.addAll(list2.subList(n, list2.size()));
        } else {
            list3.remove(list3.size() - 1);
            list3.addAll(list2);
        }
        return list3;
    }

    static {
        HashMap<Class, Keyword> hashMap = new HashMap<Class, Keyword>();
        hashMap.put(MouseEvent.class, Keyword.intern((String)"mouse"));
        hashMap.put(FGMouseEvent.class, Keyword.intern((String)"mouse"));
        hashMap.put(MouseWheelEvent.class, Keyword.intern((String)"mousewheel"));
        hashMap.put(FGMouseWheelEvent.class, Keyword.intern((String)"mousewheel"));
        hashMap.put(KeyEvent.class, Keyword.intern((String)"keyboard"));
        hashMap.put(FGHostStateEvent.class, Keyword.intern((String)"host"));
        hashMap.put(FGClipboardEvent.class, Keyword.intern((String)"clipboard"));
        hashMap.put(FGTimerEvent.class, Keyword.intern((String)"timer"));
        INPUT_EVENT_KEYS = Collections.unmodifiableMap(hashMap);
    }

    static class EvolverWrapper
    implements Function<Map<Object, Object>, Object> {
        private HashMap<Integer, GetPropertyDelegate> delegateByIdMap_;
        private HashMap<Integer, Map<List<Object>, GetPropertyDelegate>> delegateByIdAndPathMap_;
        private HashMap<Integer, Map<Keyword, GetPropertyDelegate>> delegateByIdAndPropertyMap_;
        private HashMap<Integer, Map<List<Object>, Map<Keyword, GetPropertyDelegate>>> delegateByIdPathAndPropertyMap_;
        private final Set<GetPropertyDelegate> allDelegates_;
        private final IFn evolverFn_;
        private final List<Object> evolvedComponentPath_;
        private final Function<List<Object>, Integer> indexProvider_;
        private final Container.IPropertyValueAccessor propertyValueAccessor_;

        public EvolverWrapper(IFn iFn, List<Object> list, Function<List<Object>, Integer> function, Container.IPropertyValueAccessor iPropertyValueAccessor) {
            this.evolverFn_ = iFn;
            this.evolvedComponentPath_ = list;
            this.indexProvider_ = function;
            this.propertyValueAccessor_ = iPropertyValueAccessor;
            this.delegateByIdMap_ = new HashMap();
            this.delegateByIdAndPathMap_ = new HashMap();
            this.delegateByIdAndPropertyMap_ = new HashMap();
            this.delegateByIdPathAndPropertyMap_ = new HashMap();
            this.allDelegates_ = new HashSet<GetPropertyDelegate>();
        }

        @Override
        public Object apply(Map<Object, Object> map) {
            GetPropertyStaticClojureFn.visit(this);
            return this.evolverFn_.invoke(map);
        }

        GetPropertyDelegate getDelegateById(Integer n) {
            GetPropertyDelegate getPropertyDelegate = this.delegateByIdMap_.get(n);
            if (getPropertyDelegate == null) {
                getPropertyDelegate = this.createDelegate();
                this.delegateByIdMap_.put(n, getPropertyDelegate);
            }
            return getPropertyDelegate;
        }

        GetPropertyDelegate getDelegateByIdAndPath(Integer n, List<Object> list) {
            GetPropertyDelegate getPropertyDelegate;
            Map<List<Object>, GetPropertyDelegate> map = this.delegateByIdAndPathMap_.get(n);
            if (map == null) {
                map = new HashMap<List<Object>, GetPropertyDelegate>();
                this.delegateByIdAndPathMap_.put(n, map);
            }
            if ((getPropertyDelegate = map.get(list)) == null) {
                getPropertyDelegate = this.createDelegate();
                map.put(list, getPropertyDelegate);
            }
            return getPropertyDelegate;
        }

        GetPropertyDelegate getDelegateByIdAndProperty(Integer n, Keyword keyword) {
            GetPropertyDelegate getPropertyDelegate;
            Map<Keyword, GetPropertyDelegate> map = this.delegateByIdAndPropertyMap_.get(n);
            if (map == null) {
                map = new HashMap<Keyword, GetPropertyDelegate>();
                this.delegateByIdAndPropertyMap_.put(n, map);
            }
            if ((getPropertyDelegate = map.get(keyword)) == null) {
                getPropertyDelegate = this.createDelegate();
                map.put(keyword, getPropertyDelegate);
            }
            return getPropertyDelegate;
        }

        GetPropertyDelegate getDelegateByIdPathAndProperty(Integer n, List<Object> list, Keyword keyword) {
            GetPropertyDelegate getPropertyDelegate;
            Map<Keyword, GetPropertyDelegate> map;
            Map<List<Object>, Map<Keyword, GetPropertyDelegate>> map2 = this.delegateByIdPathAndPropertyMap_.get(n);
            if (map2 == null) {
                map2 = new HashMap<List<Object>, Map<Keyword, GetPropertyDelegate>>();
                this.delegateByIdPathAndPropertyMap_.put(n, map2);
            }
            if ((map = map2.get(list)) == null) {
                map = new HashMap<Keyword, GetPropertyDelegate>();
                map2.put(list, map);
            }
            if ((getPropertyDelegate = map.get(keyword)) == null) {
                getPropertyDelegate = this.createDelegate();
                map.put(keyword, getPropertyDelegate);
            }
            return getPropertyDelegate;
        }

        void unlinkAllDelegates() {
            this.allDelegates_.forEach(getPropertyDelegate -> getPropertyDelegate.unlink());
        }

        private GetPropertyDelegate createDelegate() {
            GetPropertyDelegate getPropertyDelegate = new GetPropertyDelegate(this.evolvedComponentPath_, this.indexProvider_, this.propertyValueAccessor_);
            this.allDelegates_.add(getPropertyDelegate);
            return getPropertyDelegate;
        }
    }

    static class GetPropertyDelegate {
        private boolean linked_;
        private Integer accessedPropertyIndex_;
        private final List<Object> evolvedComponentPath_;
        private final Function<List<Object>, Integer> indexProvider_;
        private final Container.IPropertyValueAccessor propertyValueAccessor_;

        public GetPropertyDelegate(List<Object> list, Function<List<Object>, Integer> function, Container.IPropertyValueAccessor iPropertyValueAccessor) {
            this.evolvedComponentPath_ = list;
            this.indexProvider_ = function;
            this.propertyValueAccessor_ = iPropertyValueAccessor;
        }

        Object getProperty() {
            return this.propertyValueAccessor_.getPropertyValue(this.accessedPropertyIndex_);
        }

        boolean isLinked() {
            return this.linked_;
        }

        void link(List<Object> list, Object object) {
            List<Object> list2 = ClojureContainerParser.buildAbsPath(this.evolvedComponentPath_, list);
            list2.add(object);
            this.accessedPropertyIndex_ = this.indexProvider_.apply(list2);
            Container.log(this.evolvedComponentPath_ + " linked " + list2 + " -> " + this.accessedPropertyIndex_ + " Delegate: " + this);
            if (this.accessedPropertyIndex_ != null) {
                this.linked_ = true;
            }
        }

        void unlink() {
            this.linked_ = false;
        }
    }
}

