/*
 * Decompiled with CFR 0.152.
 */
package flatgui.core.awt;

import clojure.lang.RT;
import clojure.lang.Var;
import flatgui.core.IFGInteropUtil;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.SwingUtilities;

public class FGAWTInteropUtil
implements IFGInteropUtil {
    private static final Var strToFont_ = RT.var((String)"flatgui.awt", (String)"str->font");
    private static final Container CONTAINER = new Container();
    private final double unitSizePx_;
    private String referenceFontStr_;
    private Font referenceFont_;
    private FontMetrics referenceFontMetrics_;
    private Graphics referenceGraphics_;

    public FGAWTInteropUtil(int n) {
        this.unitSizePx_ = n;
        this.referenceFont_ = FGAWTInteropUtil.getDefaultFont();
        this.referenceFontMetrics_ = FGAWTInteropUtil.getDefaultReferenceFontMetrics(this.referenceFont_);
    }

    @Override
    public double getStringWidth(String string, String string2) {
        if (string2 != null && !string2.equals(this.referenceFontStr_)) {
            this.setReferenceFont(string2, (Font)strToFont_.invoke((Object)string2));
        }
        double d = SwingUtilities.computeStringWidth(this.referenceFontMetrics_, string);
        return d / this.unitSizePx_;
    }

    @Override
    public double getFontHeight(String string) {
        this.applyFontIfNeeded(string);
        double d = this.referenceFontMetrics_.getHeight();
        return d / this.unitSizePx_;
    }

    @Override
    public double getFontAscent(String string) {
        this.applyFontIfNeeded(string);
        double d = this.referenceFontMetrics_.getAscent();
        return d / this.unitSizePx_;
    }

    @Override
    public void setReferenceFont(String string, Font font) {
        this.referenceFontStr_ = string;
        this.referenceFont_ = font;
        this.updateReferenceFontMetrics();
    }

    @Override
    public String getReferenceFontStr() {
        return this.referenceFontStr_;
    }

    private void applyFontIfNeeded(String string) {
        if (string != null && !string.equals(this.referenceFontStr_)) {
            this.setReferenceFont(string, (Font)strToFont_.invoke((Object)string));
        }
    }

    void setReferenceGraphics(Graphics graphics) {
        this.referenceGraphics_ = graphics;
        this.updateReferenceFontMetrics();
    }

    private void updateReferenceFontMetrics() {
        this.referenceFontMetrics_ = this.referenceGraphics_ != null ? this.referenceGraphics_.getFontMetrics(this.referenceFont_) : CONTAINER.getFontMetrics(this.referenceFont_);
    }

    private static Font getDefaultFont() {
        return new Font("Tahoma", 0, 12);
    }

    private static FontMetrics getDefaultReferenceFontMetrics(Font font) {
        return CONTAINER.getFontMetrics(font);
    }
}

