/*
 * Decompiled with CFR 0.152.
 */
package flatgui.core.engine;

import clojure.lang.IPersistentMap;
import clojure.lang.PersistentHashMap;
import clojure.lang.PersistentVector;
import flatgui.core.IFGEvolveConsumer;
import flatgui.core.engine.ClojureContainerParser;
import flatgui.core.engine.IResultCollector;
import flatgui.core.util.Tuple;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class Container {
    private final IResultCollector resultCollector_;
    private final Set<Integer> vacantComponentIndices_;
    private final Set<Integer> vacantNodeIndices_;
    private final List<ComponentAccessor> components_;
    private final Map<List<Object>, Integer> componentPathToIndex_;
    private final List<Node> nodes_;
    private final List<Node> nodesWithAmbiguousDependencies_;
    private final List<Object> values_;
    private final Map<List<Object>, Integer> pathToIndex_;
    private final IContainerAccessor containerAccessor_;
    private final IPropertyValueAccessor propertyValueAccessor_;
    private final IContainerMutator containerMutator_;
    private final IContainerParser containerParser_;
    private Node[] reusableNodeBuffer_;
    private Object[] reusableReasonBuffer_;
    private int indexBufferSize_;
    private int currentCycleBufIndex_;
    private Map<Integer, Map<Object, Object>> nodeIndexToComponentCopyForConsumers_;
    private Set<Integer> initializedNodes_;
    public static boolean debug_ = false;

    public Container(IContainerParser iContainerParser, IResultCollector iResultCollector, Map<Object, Object> map) {
        this.containerParser_ = iContainerParser;
        this.resultCollector_ = iResultCollector;
        this.components_ = new ArrayList<ComponentAccessor>();
        this.componentPathToIndex_ = new HashMap<List<Object>, Integer>();
        this.vacantComponentIndices_ = new HashSet<Integer>();
        this.vacantNodeIndices_ = new HashSet<Integer>();
        this.nodes_ = new ArrayList<Node>();
        this.nodesWithAmbiguousDependencies_ = new ArrayList<Node>();
        this.values_ = new ArrayList<Object>();
        this.pathToIndex_ = new HashMap<List<Object>, Integer>();
        this.nodeIndexToComponentCopyForConsumers_ = new LinkedHashMap<Integer, Map<Object, Object>>();
        this.reusableNodeBuffer_ = new Node[0x100000];
        this.reusableReasonBuffer_ = new Object[0x100000];
        this.indexBufferSize_ = 0;
        this.containerAccessor_ = this.components_::get;
        this.propertyValueAccessor_ = this::getPropertyValue;
        this.containerMutator_ = (n, object) -> this.values_.set(n, object);
        this.addContainer(null, new ArrayList<Object>(), map);
        this.finishContainerIndexing();
        this.initializeContainer();
    }

    public Integer addComponent(Integer n, List<Object> list, ComponentAccessor componentAccessor) {
        return this.addComponentImpl(n, list, componentAccessor);
    }

    public Integer indexOfPath(List<Object> list) {
        return this.pathToIndex_.get(list);
    }

    public Integer indexOfPathStrict(List<Object> list) {
        Integer n = this.pathToIndex_.get(list);
        return n;
    }

    public void evolve(List<Object> list, Object object) {
        Integer n = this.getComponentUid(list);
        if (n == null) {
            throw new IllegalArgumentException("Component path does not exist: " + list);
        }
        this.evolve(n, object);
    }

    public void evolve(Integer n, Object object) {
        long l = System.currentTimeMillis();
        this.indexBufferSize_ = 0;
        Container.log("----------------Started evolve cycle ---- for reason: " + Container.valueToString(object));
        ComponentAccessor componentAccessor = this.components_.get(n);
        Map<Object, Integer> map = componentAccessor.getPropertyIdToIndex();
        for (Object object3 : map.keySet()) {
            Integer object22 = map.get(object3);
            Node node = this.nodes_.get(object22);
            if (object != null && (node.getEvolver() == null || !this.containerParser_.isInterestedIn(node.getInputDependencies(), object))) continue;
            this.addNodeToReusableBuffer(node, object);
        }
        for (int i = 0; i < this.indexBufferSize_; ++i) {
            Container.log(" Initial component: " + this.reusableNodeBuffer_[i].getNodePath());
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        this.currentCycleBufIndex_ = 0;
        this.nodeIndexToComponentCopyForConsumers_.clear();
        while (this.currentCycleBufIndex_ < this.indexBufferSize_) {
            Object object3;
            object3 = this.reusableNodeBuffer_[this.currentCycleBufIndex_];
            if (object3 == null) {
                ++this.currentCycleBufIndex_;
                continue;
            }
            Object object2 = this.reusableReasonBuffer_[this.currentCycleBufIndex_];
            int n2 = ((Node)object3).getNodeIndex();
            Function<Map<Object, Object>, Object> function = ((Node)object3).getEvolver();
            if (object2 != null || this.initializedNodes_ != null && !this.initializedNodes_.contains(n2)) {
                HashSet<Integer> hashSet2;
                Map map2;
                Object object42;
                Map map3;
                IPersistentMap iPersistentMap;
                Object object5;
                ComponentAccessor componentAccessor2 = this.components_.get(((Node)object3).getComponentUid());
                if (object2 == null) {
                    if (function == null) {
                        object5 = null;
                        iPersistentMap = this.values_.get(n2);
                    } else {
                        componentAccessor2.setEvolveReason(null);
                        object5 = this.values_.get(n2);
                        try {
                            iPersistentMap = function.apply(componentAccessor2);
                        }
                        catch (Exception exception) {
                            Container.logError(" Error evolving " + ((Node)object3).getNodePath() + " " + ((Node)object3).getPropertyId() + " while initializing ");
                            exception.printStackTrace();
                            throw exception;
                        }
                    }
                } else {
                    componentAccessor2.setEvolveReason(object2);
                    object5 = this.values_.get(n2);
                    try {
                        iPersistentMap = function.apply(componentAccessor2);
                    }
                    catch (Exception exception) {
                        Container.logError(" Error evolving " + ((Node)object3).getNodePath() + " " + ((Node)object3).getPropertyId() + " for reason: " + object2);
                        exception.printStackTrace();
                        throw exception;
                    }
                }
                boolean bl = this.initializedNodes_ != null && !this.initializedNodes_.contains(n2);
                HashSet<Object> hashSet3 = null;
                HashSet hashSet4 = null;
                HashSet hashSet5 = null;
                if (((Node)object3).isChildrenProperty()) {
                    hashSet3 = new HashSet<Object>();
                    hashSet4 = new HashSet();
                    hashSet5 = new HashSet();
                    map3 = (Map)iPersistentMap;
                    if (map3 == null) {
                        map3 = Collections.emptyMap();
                    }
                    iPersistentMap = new HashMap();
                    for (Object object42 : map3.keySet()) {
                        if (object42.toString().contains("_flex")) continue;
                        ((Map)iPersistentMap).put(object42, map3.get(object42));
                    }
                    iPersistentMap = PersistentHashMap.create((Map)((Map)iPersistentMap));
                    map2 = (Map)object5;
                    object42 = map2 != null ? map2 : Collections.emptyMap();
                    hashSet2 = new HashSet<Object>();
                    hashSet2.addAll(object42.keySet());
                    hashSet2.addAll(((Map)iPersistentMap).keySet());
                    for (Object e : hashSet2) {
                        if (!object42.containsKey(e)) {
                            hashSet5.add(e);
                            continue;
                        }
                        if (!((Map)iPersistentMap).containsKey(e)) {
                            hashSet3.add(e);
                            continue;
                        }
                        if (((Map)object42.get(e)).equals(((Map)iPersistentMap).get(e))) continue;
                        hashSet4.add(e);
                    }
                    if (!bl) {
                        bl = hashSet5.size() > 0 || hashSet3.size() > 0 || hashSet4.size() > 0;
                    }
                } else {
                    if (!bl) {
                        bl = !Objects.equals(object5, iPersistentMap);
                    }
                }
                if (bl) {
                    Container.log(" Evolved: " + n2 + " " + ((Node)object3).getNodePath() + " for reason: " + Container.valueToString(object2) + ": " + Container.valueToString(object5) + " -> " + Container.valueToString(iPersistentMap));
                    this.containerMutator_.setValue(n2, iPersistentMap);
                    map3 = ((Node)object3).getEvolveConsumers();
                    if (map3 != null) {
                        map2 = this.nodeIndexToComponentCopyForConsumers_.get(((Node)object3).getNodeIndex());
                        if (map2 == null) {
                            map2 = new HashMap<Object, Object>();
                            this.nodeIndexToComponentCopyForConsumers_.put(((Node)object3).getNodeIndex(), map2);
                        }
                        map2.put((Object)((Node)object3).getPropertyId(), (Object)iPersistentMap);
                    }
                    map2 = componentAccessor2.getComponentPath();
                    this.addNodeDependentsToEvolvebuffer((Node)object3);
                    if (object2 != null && ((Node)object3).isChildrenProperty()) {
                        Container.log(" Detected children change");
                        object42 = (Map)iPersistentMap;
                        hashSet2 = new HashSet(hashSet3);
                        hashSet2.addAll(hashSet4);
                        HashSet hashSet6 = new HashSet(hashSet5);
                        hashSet6.addAll(hashSet4);
                        Container.log(" Removing " + hashSet3.size() + " removed and " + hashSet4.size() + " changed children...");
                        System.out.println(" Removing " + hashSet3.size() + " (" + hashSet3 + ") removed and " + hashSet4.size() + " changed children...");
                        HashSet<Integer> hashSet7 = new HashSet<Integer>(hashSet2.size());
                        for (Object e : hashSet2) {
                            ArrayList<Object> arrayList = new ArrayList<Object>(map2.size() + 1);
                            arrayList.addAll((Collection<Object>)((Object)map2));
                            arrayList.add(e);
                            Integer n3 = this.getComponentUid(arrayList);
                            this.removeComponent(n3);
                            hashSet7.add(n3);
                        }
                        Container.log(" Adding " + hashSet4.size() + " changed and " + hashSet5.size() + " added children...");
                        System.out.println(" Adding " + hashSet4.size() + " changed and " + hashSet5.size() + " added children...");
                        HashSet hashSet8 = new HashSet(hashSet6.size());
                        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
                        hashSet6.forEach(arg_0 -> this.lambda$evolve$1((Map)object42, object3, componentAccessor2, hashSet, hashSet8, hashMap, arg_0));
                        componentAccessor2.removeChildIndices(hashSet7, hashSet3);
                        componentAccessor2.addChildIndices(hashSet8, hashMap);
                    }
                    if (((Node)object3).isChildOrderProperty() && iPersistentMap != null) {
                        object42 = (List)iPersistentMap;
                        hashSet2 = new ArrayList(object42.size());
                        for (int i = 0; i < object42.size(); ++i) {
                            ArrayList<Object> arrayList = new ArrayList<Object>(map2.size() + 1);
                            arrayList.addAll((Collection<Object>)((Object)map2));
                            arrayList.add(object42.get(i));
                            hashSet2.add(this.getComponentUid(arrayList));
                        }
                        componentAccessor2.changeChildIndicesOrder(hashSet2);
                    }
                    this.resultCollector_.appendResult(((Node)object3).getParentComponentUid(), (List<Object>)((Object)map2), (Node)object3, iPersistentMap);
                } else {
                    Container.log(" Evolved: " + n2 + " " + ((Node)object3).getNodePath() + " for reason: " + Container.valueToString(object2) + ": no change (" + object5 + ").");
                }
                if (this.initializedNodes_ != null) {
                    this.initializedNodes_.add(n2);
                }
            }
            ++this.currentCycleBufIndex_;
        }
        this.resultCollector_.postProcessAfterEvolveCycle(this.containerAccessor_, this.containerMutator_);
        this.notifyEvolverConsumers();
        Container.log("---Ended evolve cycle");
        if (!hashSet.isEmpty()) {
            boolean bl;
            this.processAllNodesOfComponents(hashSet, this::setupEvolversForNode);
            this.processAllNodesOfComponents(hashSet, this::resolveDependencyIndicesForNode);
            this.processAllNodesOfComponents(hashSet, this::markNodeAsDependent);
            for (Node node : this.nodesWithAmbiguousDependencies_) {
                Collection<Tuple> collection = node.reevaluateAmbiguousDependencies(this.components_, this.containerParser_::isWildcardPathElement);
                this.markNodeAsDependent(node, collection);
            }
            boolean bl2 = bl = this.initializedNodes_ == null;
            if (bl) {
                this.initializedNodes_ = new HashSet<Integer>();
            }
            hashSet.forEach(this::initializeAddedComponent);
            if (bl) {
                this.initializedNodes_.clear();
                this.initializedNodes_ = null;
            }
        }
        long l2 = System.currentTimeMillis() - l;
    }

    public IContainerAccessor getContainerAccessor() {
        return this.containerAccessor_;
    }

    public IPropertyValueAccessor getPropertyValueAccessor() {
        return this.propertyValueAccessor_;
    }

    public final Integer getComponentUid(List<Object> list) {
        return this.componentPathToIndex_.get(list);
    }

    public IComponent getRootComponent() {
        return this.components_.get(0);
    }

    public IComponent getComponent(Integer n) {
        return this.components_.get(n);
    }

    public Node getNode(Integer n) {
        return this.nodes_.get(n);
    }

    public int getNodeCount() {
        return this.nodes_.size();
    }

    public <V> V getPropertyValue(Integer n) {
        return (V)(n != null ? this.values_.get(n) : null);
    }

    public IResultCollector getResultCollector() {
        return this.resultCollector_;
    }

    public Collection<List<Object>> getAllIdPaths() {
        return Collections.unmodifiableSet(this.pathToIndex_.keySet());
    }

    public void addEvolveConsumer(IFGEvolveConsumer iFGEvolveConsumer) {
        List<Object> list = iFGEvolveConsumer.getTargetPath();
        Collection<Object> collection = iFGEvolveConsumer.getTargetProperties();
        for (Object object : collection) {
            ArrayList<Object> arrayList = new ArrayList<Object>(list.size() + 1);
            arrayList.addAll(list);
            arrayList.add(object);
            Integer n = this.pathToIndex_.get(arrayList);
            if (n != null) {
                this.nodes_.get(n).addEvolveConsumer(iFGEvolveConsumer);
                continue;
            }
            System.out.println("Error: node for " + list + "/" + object + " is not found.");
        }
    }

    private Integer addComponentImpl(Integer n, List<Object> list, ComponentAccessor componentAccessor) {
        Integer n2;
        if (this.vacantComponentIndices_.isEmpty()) {
            n2 = this.components_.size();
            this.components_.add(n2, componentAccessor);
        } else {
            n2 = (Integer)this.vacantComponentIndices_.stream().findAny().get();
            this.vacantComponentIndices_.remove(n2);
            this.components_.set(n2, componentAccessor);
        }
        this.componentPathToIndex_.put(list, n2);
        this.resultCollector_.componentAdded(n, n2);
        return n2;
    }

    private void removeComponent(Integer n2) {
        if (n2 >= this.components_.size()) {
            throw new IllegalArgumentException("Component does not exist: " + n2);
        }
        ComponentAccessor componentAccessor = this.components_.get(n2);
        if (componentAccessor == null) {
            throw new IllegalArgumentException("Component already removed: " + n2);
        }
        Collection<Integer> collection = componentAccessor.getPropertyIndices();
        collection.forEach(n -> {
            this.vacantNodeIndices_.add((Integer)n);
            Node node = this.nodes_.set((int)n, (Node)null);
            this.nodesWithAmbiguousDependencies_.remove(node);
            this.values_.set((int)n, null);
            this.pathToIndex_.remove(node.getNodePath());
            this.unMarkNodeAsDependent(node, node.getDependencyIndices());
            for (Integer n2 : node.getDependentIndices().keySet()) {
                Node node2 = this.nodes_.get(n2);
                if (node2 == null) continue;
                node2.forgetDependency((Integer)n);
            }
            if (this.initializedNodes_ != null) {
                this.initializedNodes_.remove(n);
            }
            for (int i = this.currentCycleBufIndex_; i < this.indexBufferSize_; ++i) {
                if (this.reusableNodeBuffer_[i] != node) continue;
                this.reusableNodeBuffer_[i] = null;
            }
        });
        this.components_.set(n2, null);
        this.componentPathToIndex_.remove(componentAccessor.getComponentPath());
        this.vacantComponentIndices_.add(n2);
        this.resultCollector_.componentRemoved(n2);
        List<Integer> list = componentAccessor.getChildIndices();
        if (list != null) {
            list.forEach(this::removeComponent);
        }
    }

    private Integer addContainer(Integer n, List<Object> list2, Map<Object, Object> map) {
        Serializable serializable;
        ArrayList<Object> arrayList = new ArrayList<Object>(list2.size() + 1);
        arrayList.addAll(list2);
        arrayList.add(this.containerParser_.getComponentId(map));
        ComponentAccessor componentAccessor = new ComponentAccessor(arrayList, this.values_, list -> this.getPropertyValue(this.indexOfPathStrict((List<Object>)list)));
        Integer n2 = this.addComponent(n, arrayList, componentAccessor);
        componentAccessor.setComponentUid(n2);
        Container.log("Added and indexed component " + arrayList + ": " + n2);
        Collection<SourceNode> collection = this.containerParser_.processComponent(arrayList, map, this.propertyValueAccessor_);
        for (SourceNode object : collection) {
            serializable = this.addNode(n, n2, object, map.get(object.getPropertyId()));
            Container.log("Indexing " + arrayList + " node " + object.getNodePath() + ": " + serializable);
            componentAccessor.putPropertyIndex(object.getPropertyId(), (Integer)serializable);
        }
        this.containerParser_.processComponentAfterIndexing(componentAccessor);
        Map map2 = (Map)map.get(this.containerParser_.getChildrenPropertyName());
        if (map2 != null) {
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>(map2.size());
            serializable = new HashMap();
            for (Map map3 : map2.values()) {
                Object object = this.containerParser_.getComponentId(map3);
                Integer n3 = this.addContainer(n2, arrayList, map3);
                arrayList2.add(n3);
                serializable.put(object, n3);
            }
            componentAccessor.setChildIndices(arrayList2, (Map<Object, Integer>)((Object)serializable));
        }
        return n2;
    }

    private void processAllNodesOfComponents(Collection<Integer> collection, Consumer<Node> consumer) {
        for (Integer n : collection) {
            ComponentAccessor componentAccessor = this.components_.get(n);
            Map<Object, Integer> map = componentAccessor.getPropertyIdToIndex();
            for (Object object : map.keySet()) {
                Integer n2 = map.get(object);
                Node node = this.nodes_.get(n2);
                consumer.accept(node);
            }
        }
    }

    private void initializeAddedComponent(Integer n) {
        this.evolve(n, null);
        ComponentAccessor componentAccessor = this.components_.get(n);
        List<Integer> list = componentAccessor.getChildIndices();
        if (list != null) {
            for (Integer n2 : list) {
                this.initializeAddedComponent(n2);
            }
        }
    }

    private static List<Object> dropLast(List<Object> list) {
        ArrayList<Object> arrayList = new ArrayList<Object>(list);
        arrayList.remove(arrayList.size() - 1);
        return arrayList;
    }

    private void setupEvolversForNode(Node node) {
        node.setEvolver(node.getEvolverCode() != null ? this.containerParser_.compileEvolverCode(node.getPropertyId(), node.getEvolverCode(), this::indexOfPath, Container.dropLast(node.getNodePath()), this.propertyValueAccessor_) : null);
    }

    private void resolveDependencyIndicesForNode(Node node) {
        node.resolveDependencyIndices(this.components_, this.containerParser_::isWildcardPathElement);
    }

    private void markNodeAsDependent(Node node) {
        this.markNodeAsDependent(node, node.getDependencyIndices());
    }

    private void markNodeAsDependent(Node node, Collection<Tuple> collection) {
        collection.forEach(tuple -> this.nodes_.get((Integer)tuple.getFirst()).addDependent(node.getNodeIndex(), node.getNodePath(), (List)tuple.getSecond()));
    }

    private void unMarkNodeAsDependent(Node node, Collection<Tuple> collection) {
        collection.forEach(tuple -> {
            Node node2 = this.nodes_.get((Integer)tuple.getFirst());
            if (node2 != null) {
                node2.removeDependent(node.getNodeIndex());
            }
        });
    }

    private void finishContainerIndexing() {
        this.nodes_.forEach(this::setupEvolversForNode);
        this.nodes_.forEach(this::resolveDependencyIndicesForNode);
        this.nodes_.forEach(this::markNodeAsDependent);
    }

    private Integer addNode(Integer n, Integer n2, SourceNode sourceNode, Object object) {
        Integer n3;
        if (this.vacantNodeIndices_.isEmpty()) {
            n3 = this.nodes_.size();
        } else {
            n3 = (Integer)this.vacantNodeIndices_.stream().findAny().get();
            this.vacantNodeIndices_.remove(n3);
        }
        Node node = new Node(n2, sourceNode.getPropertyId(), n, sourceNode.isChildrenProperty(), sourceNode.isChildOrderProperty(), sourceNode.getNodePath(), n3, sourceNode.getRelAndAbsDependencyPaths(), sourceNode.getInputDependencies(), sourceNode.getEvolverCode());
        int n4 = n3;
        if (n3 < this.nodes_.size()) {
            this.nodes_.set(n4, node);
            this.values_.set(n4, object);
        } else {
            this.nodes_.add(node);
            this.values_.add(object);
            if (node.isHasAmbiguousDependencies()) {
                this.nodesWithAmbiguousDependencies_.add(node);
            }
        }
        this.pathToIndex_.put(sourceNode.getNodePath(), n3);
        return n3;
    }

    private void addNodeToReusableBuffer(Node node, Object object) {
        this.ensureIndexBufferSize(this.indexBufferSize_ + 1);
        this.reusableNodeBuffer_[this.indexBufferSize_] = node;
        this.reusableReasonBuffer_[this.indexBufferSize_] = object;
        ++this.indexBufferSize_;
    }

    private void addNodeDependentsToEvolvebuffer(Node node) {
        Map<Integer, List<Object>> map = node.getDependentIndices();
        int n = map.size();
        this.ensureIndexBufferSize(this.indexBufferSize_ + n);
        for (Integer n2 : map.keySet()) {
            Node node2 = this.nodes_.get(n2);
            PersistentVector persistentVector = new ArrayList((Collection)map.get(n2));
            persistentVector.remove(persistentVector.size() - 1);
            persistentVector = PersistentVector.create(persistentVector);
            this.reusableNodeBuffer_[this.indexBufferSize_] = node2;
            this.reusableReasonBuffer_[this.indexBufferSize_] = persistentVector;
            Container.log("    Triggered dependent: " + node2.getNodePath() + " referenced as " + persistentVector);
            ++this.indexBufferSize_;
        }
    }

    private void ensureIndexBufferSize(int n) {
        if (n >= this.reusableNodeBuffer_.length) {
            this.reusableNodeBuffer_ = Container.ensureBufferSize(this.reusableNodeBuffer_, n);
            this.reusableReasonBuffer_ = Container.ensureBufferSize(this.reusableReasonBuffer_, n);
        }
    }

    private static <T> T[] ensureBufferSize(T[] TArray, int n) {
        if (n >= TArray.length) {
            Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), TArray.length + 128);
            System.arraycopy(TArray, 0, objectArray, 0, TArray.length);
            return objectArray;
        }
        return TArray;
    }

    private void initializeContainer() {
        this.initializedNodes_ = new HashSet<Integer>();
        Container.log("========================Started initialization cycle================================");
        for (int i = 0; i < this.components_.size(); ++i) {
            this.evolve(i, null);
        }
        Container.log("=====Ended initialization cycle");
        this.initializedNodes_.clear();
        this.initializedNodes_ = null;
    }

    static void log(String string) {
        if (debug_) {
            System.out.println("[FG Eng]: " + string);
        }
    }

    static void logError(String string) {
        System.out.println("[FG Eng Error]: " + string);
    }

    static String valueToString(Object object) {
        if (object != null) {
            String string = object.toString();
            if (string.length() > 100) {
                return string.substring(0, 100) + "...";
            }
            return string;
        }
        return null;
    }

    private boolean pathMatches(List<Object> list, List<Object> list2) {
        if (list.size() == list2.size()) {
            for (int i = 0; i < list.size(); ++i) {
                Object object = list.get(i);
                if (object.equals(list2.get(i)) || this.containerParser_.isWildcardPathElement(object)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void notifyEvolverConsumers() {
        for (Integer n : this.nodeIndexToComponentCopyForConsumers_.keySet()) {
            Node node = this.nodes_.get(n);
            for (IFGEvolveConsumer iFGEvolveConsumer : node.getEvolveConsumers()) {
                Map<Object, Object> map = this.nodeIndexToComponentCopyForConsumers_.get(n);
                Thread thread = new Thread(() -> iFGEvolveConsumer.acceptEvolveResult(null, map), "FlatGUI Evolver Consumer Notifier");
                thread.start();
            }
        }
        this.nodeIndexToComponentCopyForConsumers_.clear();
    }

    private /* synthetic */ void lambda$evolve$1(Map map, Node node, ComponentAccessor componentAccessor, Set set, Set set2, Map map2, Object object) {
        Map map3 = (Map)map.get(object);
        Integer n = this.addContainer(node.getComponentUid(), componentAccessor.getComponentPath(), map3);
        set.add(n);
        set2.add(n);
        map2.put(object, n);
    }

    public static class Node {
        private final Integer componentUid_;
        private final Object propertyId_;
        private final Integer parentComponentUid_;
        private final boolean childrenProperty_;
        private final boolean childOrderProperty_;
        private final List<Object> nodePath_;
        private final Integer nodeUid_;
        private final Collection<DependencyInfo> relAndAbsDependencyPaths_;
        private final boolean hasAmbiguousDependencies_;
        private final Collection<Object> inputDependencies_;
        private Map<Integer, Tuple> dependencyIndices_;
        private Object evolverCode_;
        private Function<Map<Object, Object>, Object> evolver_;
        private Set<IFGEvolveConsumer> evolveConsumers_;
        private final Map<Integer, List<Object>> dependentIndexToRelPath_;

        public Node(Integer n, Object object, Integer n2, boolean bl, boolean bl2, List<Object> list, Integer n3, Collection<DependencyInfo> collection, Collection<Object> collection2, Object object2) {
            this.componentUid_ = n;
            this.propertyId_ = object;
            this.parentComponentUid_ = n2;
            this.childrenProperty_ = bl;
            this.childOrderProperty_ = bl2;
            this.nodePath_ = list;
            this.nodeUid_ = n3;
            this.relAndAbsDependencyPaths_ = collection;
            boolean bl3 = false;
            for (DependencyInfo dependencyInfo : this.relAndAbsDependencyPaths_) {
                if (!dependencyInfo.isAmbiguous()) continue;
                bl3 = true;
                break;
            }
            this.hasAmbiguousDependencies_ = bl3;
            this.inputDependencies_ = collection2;
            this.dependentIndexToRelPath_ = new HashMap<Integer, List<Object>>();
            this.evolverCode_ = object2;
        }

        public Integer getComponentUid() {
            return this.componentUid_;
        }

        public Object getPropertyId() {
            return this.propertyId_;
        }

        public Integer getParentComponentUid() {
            return this.parentComponentUid_;
        }

        public boolean isChildrenProperty() {
            return this.childrenProperty_;
        }

        public boolean isChildOrderProperty() {
            return this.childOrderProperty_;
        }

        public Integer getNodeIndex() {
            return this.nodeUid_;
        }

        public List<Object> getNodePath() {
            return this.nodePath_;
        }

        public Collection<Object> getInputDependencies() {
            return this.inputDependencies_;
        }

        public boolean isHasAmbiguousDependencies() {
            return this.hasAmbiguousDependencies_;
        }

        private void findNodeIndices(ComponentAccessor componentAccessor, int n, DependencyInfo dependencyInfo, List<ComponentAccessor> list, Predicate<Object> predicate, Consumer<Tuple> consumer) {
            List<Object> list2 = dependencyInfo.getAbsPath();
            int n2 = list2.size();
            if (n2 == 1) {
                return;
            }
            Object object = list2.get(n);
            if (n < n2 - 1) {
                if (predicate.test(object)) {
                    List<Integer> list3 = componentAccessor.getChildIndices();
                    for (Integer n3 : list3) {
                        this.findNodeIndices(list.get(n3), n + 1, dependencyInfo, list, predicate, consumer);
                    }
                } else {
                    Integer n4 = componentAccessor.getChildIndex(object);
                    if (n4 != null) {
                        this.findNodeIndices(list.get(n4), n + 1, dependencyInfo, list, predicate, consumer);
                    }
                }
            } else {
                Integer n5 = componentAccessor.getPropertyIndex(object);
                if (n5 != null) {
                    Tuple tuple = Tuple.triple(n5, dependencyInfo.getRelPath(), dependencyInfo.isAmbiguous());
                    this.dependencyIndices_.put(n5, tuple);
                    if (consumer != null) {
                        consumer.accept(tuple);
                    }
                }
            }
        }

        public void resolveDependencyIndices(List<ComponentAccessor> list, Predicate<Object> predicate) {
            this.dependencyIndices_ = new HashMap<Integer, Tuple>();
            for (DependencyInfo dependencyInfo : this.relAndAbsDependencyPaths_) {
                this.findNodeIndices(list.get(0), 1, dependencyInfo, list, predicate, null);
            }
        }

        public Collection<Tuple> reevaluateAmbiguousDependencies(List<ComponentAccessor> list, Predicate<Object> predicate) {
            ArrayList<Tuple> arrayList = new ArrayList<Tuple>();
            for (DependencyInfo dependencyInfo : this.relAndAbsDependencyPaths_) {
                this.findNodeIndices(list.get(0), 1, dependencyInfo, list, predicate, arrayList::add);
            }
            return arrayList;
        }

        public Collection<Tuple> getDependencyIndices() {
            return this.dependencyIndices_.values();
        }

        public Map<Integer, List<Object>> getDependentIndices() {
            return this.dependentIndexToRelPath_;
        }

        public void addDependent(Integer n, List<Object> list, List<Object> list2) {
            ArrayList<Object> arrayList = new ArrayList<Object>(list2);
            if (list.size() < this.nodePath_.size()) {
                for (int i = 1; i < list2.size(); ++i) {
                    arrayList.set(i, this.nodePath_.get(this.nodePath_.size() - list2.size() + i));
                }
            }
            Container.log(this.nodeUid_ + " " + this.nodePath_ + " added dependent: " + n + " " + list + " referenced as " + list2 + " actual ref " + arrayList);
            this.dependentIndexToRelPath_.put(n, arrayList);
        }

        public void removeDependent(Integer n) {
            this.dependentIndexToRelPath_.remove(n);
        }

        public Object getEvolverCode() {
            return this.evolverCode_;
        }

        public Function<Map<Object, Object>, Object> getEvolver() {
            return this.evolver_;
        }

        public void setEvolver(Function<Map<Object, Object>, Object> function) {
            this.evolver_ = function;
        }

        void forgetDependency(Integer n) {
            this.dependencyIndices_.remove(n);
            ((ClojureContainerParser.EvolverWrapper)this.evolver_).unlinkAllDelegates();
        }

        void addEvolveConsumer(IFGEvolveConsumer iFGEvolveConsumer) {
            if (this.evolveConsumers_ == null) {
                this.evolveConsumers_ = new HashSet<IFGEvolveConsumer>();
            }
            this.evolveConsumers_.add(iFGEvolveConsumer);
        }

        Collection<IFGEvolveConsumer> getEvolveConsumers() {
            return this.evolveConsumers_;
        }
    }

    public static class ComponentAccessor
    implements IComponent {
        private final List<Object> componentPath_;
        private Map<Object, Integer> propertyIdToIndex_;
        private final List<Object> values_;
        private List<Integer> childIndices_;
        private Map<Object, Integer> childIdToIndex_;
        private Integer componentUid_;
        private final Function<List<Object>, Object> globalIndexToValueProvider_;
        private Object currentEvolveReason_;
        private Object customData_;

        public ComponentAccessor(List<Object> list, List<Object> list2, Function<List<Object>, Object> function) {
            this.componentPath_ = Collections.unmodifiableList(list);
            this.propertyIdToIndex_ = new HashMap<Object, Integer>();
            this.values_ = Collections.unmodifiableList(list2);
            this.globalIndexToValueProvider_ = function;
        }

        @Override
        public Object get(Object object) {
            Integer n = this.getPropertyIndex(object);
            return n != null ? this.values_.get(n) : null;
        }

        @Override
        public int size() {
            return this.propertyIdToIndex_.size();
        }

        @Override
        public boolean isEmpty() {
            return this.propertyIdToIndex_.isEmpty();
        }

        @Override
        public boolean containsKey(Object object) {
            return this.propertyIdToIndex_.containsKey(object);
        }

        @Override
        public boolean containsValue(Object object) {
            for (Object object2 : this.propertyIdToIndex_.keySet()) {
                if (!Objects.equals(this.get(object2), object)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object put(Object object, Object object2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map map) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set keySet() {
            return this.propertyIdToIndex_.keySet();
        }

        @Override
        public Collection values() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            for (Object object : this.propertyIdToIndex_.keySet()) {
                hashMap.put(object, this.get(object));
            }
            return hashMap.entrySet();
        }

        @Override
        public Integer getPropertyIndex(Object object) {
            return this.propertyIdToIndex_.get(object);
        }

        @Override
        public Collection<Integer> getPropertyIndices() {
            return this.propertyIdToIndex_.values();
        }

        @Override
        public Object getCustomData() {
            return this.customData_;
        }

        @Override
        public void setCustomData(Object object) {
            this.customData_ = object;
        }

        @Override
        public List<Integer> getChildIndices() {
            return this.childIndices_;
        }

        @Override
        public Integer getChildIndex(Object object) {
            return this.childIdToIndex_.get(object);
        }

        public Map<Object, Integer> getPropertyIdToIndex() {
            return this.propertyIdToIndex_;
        }

        public Integer getComponentUid() {
            return this.componentUid_;
        }

        void setComponentUid(Integer n) {
            this.componentUid_ = n;
        }

        void putPropertyIndex(Object object, Integer n) {
            this.propertyIdToIndex_.put(object, n);
        }

        void finishInitialization() {
            this.propertyIdToIndex_ = Collections.unmodifiableMap(this.propertyIdToIndex_);
        }

        public List<Object> getComponentPath() {
            return this.componentPath_;
        }

        void setChildIndices(List<Integer> list, Map<Object, Integer> map) {
            this.childIndices_ = list;
            this.childIdToIndex_ = map;
        }

        void changeChildIndicesOrder(Collection<Integer> collection) {
            HashSet<Integer> hashSet;
            HashSet<Integer> hashSet2;
            if (debug_ && !(hashSet2 = new HashSet<Integer>(this.childIndices_)).equals(hashSet = new HashSet<Integer>(collection))) {
                throw new IllegalStateException("Old child indices: " + hashSet2 + " new: " + hashSet);
            }
            this.childIndices_ = new ArrayList<Integer>(collection);
        }

        void addChildIndices(Collection<Integer> collection, Map<Object, Integer> map) {
            this.childIndices_.addAll(collection);
            this.childIdToIndex_.putAll(map);
        }

        void removeChildIndices(Collection<Integer> collection, Collection<Object> collection2) {
            this.childIndices_.removeAll(collection);
            for (Object object : collection2) {
                this.childIdToIndex_.remove(object);
            }
        }

        void setEvolveReason(Object object) {
            this.currentEvolveReason_ = object;
        }

        public Object getNodeValueByIndex(Integer n) {
            return this.values_.get(n);
        }

        public Object getEvolveReason() {
            return this.currentEvolveReason_;
        }

        public Object getValueByAbsPath(List<Object> list) {
            return this.globalIndexToValueProvider_.apply(list);
        }
    }

    public static interface IContainerMutator {
        public void setValue(int var1, Object var2);
    }

    public static interface IPropertyValueAccessor {
        public Object getPropertyValue(Integer var1);
    }

    public static interface IContainerAccessor {
        public IComponent getComponent(int var1);
    }

    public static interface IComponent
    extends Map<Object, Object> {
        public Integer getPropertyIndex(Object var1);

        public Collection<Integer> getPropertyIndices();

        public List<Integer> getChildIndices();

        public Integer getChildIndex(Object var1);

        public Object getCustomData();

        public void setCustomData(Object var1);
    }

    public static interface IContainerParser {
        public Object getComponentId(Map<Object, Object> var1);

        public Object getChildrenPropertyName();

        public Object getChildOrderPropertyName();

        public List<Object> getChildOrder(Map<Object, Object> var1);

        public Collection<SourceNode> processComponent(List<Object> var1, Map<Object, Object> var2, IPropertyValueAccessor var3);

        public void processComponentAfterIndexing(IComponent var1);

        public Function<Map<Object, Object>, Object> compileEvolverCode(Object var1, Object var2, Function<List<Object>, Integer> var3, List<Object> var4, IPropertyValueAccessor var5);

        public boolean isInterestedIn(Collection<Object> var1, Object var2);

        public boolean isWildcardPathElement(Object var1);
    }

    public static class SourceNode {
        private final Object propertyId_;
        private final boolean childrenProperty_;
        private final boolean childOrderProperty_;
        private final List<Object> nodePath_;
        private final Collection<DependencyInfo> relAndAbsDependencyPaths_;
        private final Object evolverCode_;
        private final List<Object> inputDependencies_;

        public SourceNode(Object object, boolean bl, boolean bl2, List<Object> list, Collection<DependencyInfo> collection, Object object2, List<Object> list2) {
            this.propertyId_ = object;
            this.childrenProperty_ = bl;
            this.childOrderProperty_ = bl2;
            this.nodePath_ = list;
            this.relAndAbsDependencyPaths_ = collection;
            this.evolverCode_ = object2;
            this.inputDependencies_ = list2;
        }

        public Object getPropertyId() {
            return this.propertyId_;
        }

        public boolean isChildrenProperty() {
            return this.childrenProperty_;
        }

        public boolean isChildOrderProperty() {
            return this.childOrderProperty_;
        }

        public List<Object> getNodePath() {
            return this.nodePath_;
        }

        public Collection<DependencyInfo> getRelAndAbsDependencyPaths() {
            return this.relAndAbsDependencyPaths_;
        }

        public Object getEvolverCode() {
            return this.evolverCode_;
        }

        public List<Object> getInputDependencies() {
            return this.inputDependencies_;
        }
    }

    public static class DependencyInfo {
        private final List<Object> relPath_;
        private final List<Object> absPath_;
        private boolean isAmbiguous_;

        public DependencyInfo(List<Object> list, List<Object> list2, boolean bl) {
            this.relPath_ = list;
            this.absPath_ = list2;
            this.isAmbiguous_ = bl;
        }

        public List<Object> getRelPath() {
            return this.relPath_;
        }

        public List<Object> getAbsPath() {
            return this.absPath_;
        }

        public boolean isAmbiguous() {
            return this.isAmbiguous_;
        }
    }
}

