/*
 * Decompiled with CFR 0.152.
 */
package flatgui.core;

import clojure.lang.Keyword;
import clojure.lang.RT;
import clojure.lang.Var;
import flatgui.core.FGComponentPath;
import flatgui.core.IFGModule;
import flatgui.core.awt.FGMouseTargetComponentInfo;
import flatgui.core.util.FGStringPool;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class FGAbstractModule
implements IFGModule {
    private static final Var initInstanceFn_ = RT.var((String)"flatgui.appcontainer", (String)"app-init-instance");
    private static final Var getPaintAllSequence_ = RT.var((String)"flatgui.paint", (String)"get-paint-all-sequence");
    private static final Var getComponentIdPathToComponent_ = RT.var((String)"flatgui.paint", (String)"get-component-id-path-to-component");
    private static final Var getMousePointedPath_ = RT.var((String)"flatgui.access", (String)"get-mouse-pointed-path");
    private static final Var getIdsFromPointedPath_ = RT.var((String)"flatgui.access", (String)"get-ids-from-pointed-path");
    private static final Var getMouseRelXFromPath_ = RT.var((String)"flatgui.access", (String)"get-mouse-rel-x-from-path");
    private static final Var getMouseRelYFromPath_ = RT.var((String)"flatgui.access", (String)"get-mouse-rel-y-from-path");
    private static final Var getPressedCoorCaptureNeededFromPath_ = RT.var((String)"flatgui.access", (String)"get-pressed-coord-capture-from-path");
    private static final Var getFocusedPath_ = RT.var((String)"flatgui.access", (String)"get-focused-path");
    private static final Var getInputChannelSubscribers_ = RT.var((String)"flatgui.access", (String)"get-path-to-property-list-map-for-channel");
    private static final int STRING_POOL_PER_COMPONENT_CAPACITY = 256;
    private static final Keyword CHANGED_PATHS_KEY = Keyword.intern((String)"_changed-paths");
    protected final String containerName_;
    private final Map<Object, FGStringPool> stringPoolMap_;

    public FGAbstractModule(String string) {
        this.containerName_ = string;
        this.stringPoolMap_ = new HashMap<Object, FGStringPool>();
    }

    @Override
    public void initInstance() {
        initInstanceFn_.invoke((Object)this.containerName_);
    }

    @Override
    public List<Object> getPaintAllSequence() {
        Object object = this.getContainer();
        Var var = RT.var((String)"flatgui.paint", (String)"paint-all");
        List list = (List)var.invoke(object);
        return list;
    }

    @Override
    public List<Object> getPaintAllSequence(double d, double d2, double d3, double d4) {
        Object object = this.getContainer();
        Var var = RT.var((String)"flatgui.paint", (String)"paint-all");
        List list = (List)var.invoke(object, (Object)d, (Object)d2, (Object)d3, (Object)d4);
        return list;
    }

    @Override
    public Object getDirtyRectFromContainer() {
        Object object = this.getContainer();
        Var var = RT.var((String)"flatgui.paint", (String)"get-dirty-rect-from-container");
        return var.invoke(object);
    }

    @Override
    public List<Object> getPaintChangesSequence(Collection collection) {
        Object object = this.getContainer();
        Var var = RT.var((String)"flatgui.paint", (String)"paint-dirty");
        List list = (List)var.invoke(object, (Object)collection, (Object)false);
        return list;
    }

    @Override
    public FGMouseTargetComponentInfo getMouseTargetInfoAt(double d, double d2, FGComponentPath fGComponentPath) {
        Object object = this.getContainer();
        Object object2 = getMousePointedPath_.invoke(object, (Object)d, (Object)d2);
        boolean bl = (Boolean)getPressedCoorCaptureNeededFromPath_.invoke(object2);
        Object object3 = null;
        if (fGComponentPath != null && bl) {
            object2 = fGComponentPath.getTargetComponentPath();
            object3 = fGComponentPath.getTargetIdPath();
        } else if (object2 != null) {
            object3 = getIdsFromPointedPath_.invoke(object2);
        }
        if (object3 != null) {
            Object object4 = getMouseRelXFromPath_.invoke(object2);
            Object object5 = getMouseRelYFromPath_.invoke(object2);
            return new FGMouseTargetComponentInfo(new FGComponentPath(object2, object3), object4, object5, bl);
        }
        return new FGMouseTargetComponentInfo(null, null, null, bl);
    }

    @Override
    public List<Keyword> getFocusedPath() {
        return (List)getFocusedPath_.invoke(this.getContainer());
    }

    @Override
    public Map<List<Keyword>, Collection<Keyword>> getInputChannelSubscribers(Keyword keyword) {
        return (Map)getInputChannelSubscribers_.invoke(this.getContainer(), (Object)keyword);
    }

    @Override
    public Set<List<Keyword>> getChangedComponentIdPaths() {
        Object object = this.getContainer();
        return (Set)((Map)object).get(CHANGED_PATHS_KEY);
    }

    @Override
    public Map<Object, Map<Keyword, Object>> getComponentIdPathToComponent(Collection<List<Keyword>> collection) {
        Object object = this.getContainer();
        return (Map)getComponentIdPathToComponent_.invoke(object, collection);
    }

    @Override
    public Map<Object, Object> getStringPoolDiffs(Map<Object, List<String>> map) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        map.entrySet().stream().forEach(entry -> {
            Map<Integer, String> map2 = this.putStrings(entry.getKey(), (Collection)entry.getValue());
            if (!map2.isEmpty()) {
                hashMap.put(entry.getKey(), map2);
            }
        });
        return hashMap;
    }

    @Override
    public Integer getStringPoolId(String string, Object object) {
        return this.stringPoolMap_.get(object).getIndexOfString(string);
    }

    public Map<Integer, String> putStrings(Object object, Collection<String> collection) {
        FGStringPool fGStringPool = this.stringPoolMap_.get(object);
        if (fGStringPool == null) {
            fGStringPool = new FGStringPool(256);
            this.stringPoolMap_.put(object, fGStringPool);
        }
        return fGStringPool.addStrings(collection.stream().filter(string -> string != null).collect(Collectors.toSet()));
    }

    @Override
    public List<Object> getPaintAllSequence2() {
        Object object = this.getContainer();
        List list = (List)getPaintAllSequence_.invoke(object);
        return list;
    }
}

