/*
 * Decompiled with CFR 0.152.
 */
package flatgui.core.websocket;

import clojure.lang.RT;
import clojure.lang.Var;
import flatgui.core.FGContainer;
import flatgui.core.FGWebContainerWrapper;
import flatgui.core.IFGContainerHost;
import flatgui.core.IFGTemplate;
import flatgui.core.engine.remote.FGLegacyCoreGlue;
import flatgui.core.engine.remote.FGLegacyGlueTemplate;
import flatgui.core.engine.ui.FGRemoteAppContainer;
import flatgui.core.engine.ui.FGRemoteClojureResultCollector;
import flatgui.core.websocket.FGAppServer;
import flatgui.core.websocket.FGContainerSession;
import flatgui.core.websocket.FGWebInteropUtil;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

class FGContainerSessionHolder {
    private static final String SPECIAL_CHARS = ".:/=";
    private static final long IDLE_SESSION_TIMEOUT = 900000L;
    private final IFGContainerHost<FGContainerSession> sessionHost_;
    private final Map<Object, FGContainerSession> sessionMap_;
    private static long counter_ = 0L;

    FGContainerSessionHolder(IFGContainerHost<FGContainerSession> iFGContainerHost) {
        this.sessionHost_ = iFGContainerHost;
        this.sessionMap_ = new ConcurrentHashMap<Object, FGContainerSession>();
        Timer timer2 = new Timer("FlatGUI web container idle session cleaner", true);
        timer2.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FGContainerSessionHolder fGContainerSessionHolder = FGContainerSessionHolder.this;
                synchronized (fGContainerSessionHolder) {
                    int n = FGContainerSessionHolder.this.sessionMap_.size();
                    FGContainerSessionHolder.this.sessionMap_.entrySet().removeIf(entry -> ((FGContainerSession)entry.getValue()).isIdle(900000L));
                    int n2 = FGContainerSessionHolder.this.sessionMap_.size();
                    if (n2 != n) {
                        FGAppServer.getFGLogger().info(this.toString() + " cleaned sessions. Before: " + n + "; after: " + n2 + ".");
                    }
                }
            }
        }, 900000L, 900000L);
    }

    FGContainerSession getSession(IFGTemplate iFGTemplate, InetAddress inetAddress, List<byte[]> list, Set<String> set) {
        Object object = FGContainerSessionHolder.getSessionId(iFGTemplate, inetAddress);
        FGContainerSession fGContainerSession = this.sessionMap_.computeIfAbsent(object, object2 -> {
            if (iFGTemplate instanceof FGLegacyGlueTemplate) {
                Var var = RT.var((String)iFGTemplate.getContainerNamespace(), (String)iFGTemplate.getContainerVarName());
                Map map = (Map)var.get();
                FGLegacyCoreGlue.GlueModule glueModule = new FGLegacyCoreGlue.GlueModule(object.toString());
                FGWebContainerWrapper.KeyCache keyCache = new FGWebContainerWrapper.KeyCache();
                HashSet<String> hashSet = new HashSet<String>();
                FGRemoteClojureResultCollector fGRemoteClojureResultCollector = new FGRemoteClojureResultCollector(64, keyCache, glueModule, hashSet);
                FGRemoteAppContainer fGRemoteAppContainer = new FGRemoteAppContainer(object.toString(), (Map<Object, Object>)map, fGRemoteClojureResultCollector);
                FGLegacyCoreGlue fGLegacyCoreGlue = new FGLegacyCoreGlue(fGRemoteAppContainer, glueModule);
                fGLegacyCoreGlue.initialize();
                FGWebInteropUtil fGWebInteropUtil = (FGWebInteropUtil)fGRemoteAppContainer.getInteropUtil();
                list.forEach(byArray -> set.add(fGWebInteropUtil.setMetricsTransmission((byte[])byArray)));
                return this.sessionHost_.hostContainer(fGLegacyCoreGlue, hashSet);
            }
            FGWebInteropUtil fGWebInteropUtil = new FGWebInteropUtil(64);
            list.forEach(byArray -> set.add(fGWebInteropUtil.setMetricsTransmission((byte[])byArray)));
            FGContainer fGContainer = new FGContainer(iFGTemplate, object.toString(), fGWebInteropUtil);
            HashSet<String> hashSet = new HashSet<String>();
            return this.sessionHost_.hostContainer(fGContainer, hashSet);
        });
        FGAppServer.getFGLogger().debug(this.toString() + " state:");
        FGAppServer.getFGLogger().debug(this.sessionMap_.toString());
        FGAppServer.getFGLogger().debug(this.toString() + " returning for remoteAddress=" + inetAddress + " session: " + fGContainerSession);
        return fGContainerSession;
    }

    synchronized long getActiveOrIdleSessionCount() {
        return this.sessionMap_.size();
    }

    synchronized long getActiveSessionCount() {
        return this.sessionMap_.values().stream().filter(FGContainerSession::isActive).count();
    }

    synchronized void forEachActiveSession(Consumer<FGContainerSession> consumer) {
        this.sessionMap_.values().forEach(fGContainerSession -> {
            Object object = fGContainerSession.getContainerLock();
            synchronized (object) {
                if (fGContainerSession.isActive()) {
                    consumer.accept((FGContainerSession)fGContainerSession);
                }
            }
        });
    }

    synchronized void forEachActiveSession(BiConsumer<Object, FGContainerSession> biConsumer) {
        this.sessionMap_.entrySet().forEach(entry -> {
            Object object = ((FGContainerSession)entry.getValue()).getContainerLock();
            synchronized (object) {
                if (((FGContainerSession)entry.getValue()).isActive()) {
                    biConsumer.accept(entry.getKey(), (FGContainerSession)entry.getValue());
                }
            }
        });
    }

    synchronized <R> Stream<R> mapSessions(Function<FGContainerSession, R> function) {
        return this.sessionMap_.values().stream().map(function);
    }

    private static Object getSessionId(IFGTemplate iFGTemplate, InetAddress inetAddress) {
        String string = iFGTemplate.getContainerNamespace() + "_" + iFGTemplate.getContainerVarName() + "_" + inetAddress.getHostAddress().toString() + String.valueOf(counter_);
        ++counter_;
        for (int i = 0; i < SPECIAL_CHARS.length(); ++i) {
            string = string.replace(SPECIAL_CHARS.charAt(i), '_');
        }
        return string;
    }
}

