/*
 * Decompiled with CFR 0.152.
 */
package flatgui.core.awt;

import clojure.lang.RT;
import clojure.lang.Var;
import flatgui.core.awt.FGImageLoader;
import flatgui.core.awt.IFGImageLoader;
import flatgui.core.awt.IFGPrimitivePainter;
import flatgui.core.util.FGChangeEvent;
import flatgui.core.util.IFGChangeListener;
import flatgui.core.util.Tuple;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class FGDefaultPrimitivePainter
implements IFGPrimitivePainter {
    public static final String SET_CLIP = "setClip";
    public static final String CLIP_RECT = "clipRect";
    public static final String TRANSFORM = "transform";
    private static final String PUSH_CURRENT_CLIP = "pushCurrentClip";
    private static final String POP_CURRENT_CLIP = "popCurrentClip";
    private static final String DRAW_IMAGE = "drawImage";
    private static final String FIT_IMAGE = "fitImage";
    private static final String FILL_IMAGE = "fillImage";
    private static final String SET_FONT = "setFont";
    private static Map<Class, Class> NUMBER_CLASS_TO_PRIMITIVE = new HashMap<Class, Class>();
    private static Set<String> COMMANDS_ALLOWED_WHEN_CLIPPED_OUT;
    private static Set<String> COMMANDS_REDUCED_WH;
    private static final Var strToFont_;
    private IFGImageLoader imageLoader_ = new FGImageLoader();
    private double unitSizePx_;
    private Deque<Shape> clipRectStack_ = new LinkedList<Shape>();
    private Map<String, BiConsumer<Graphics2D, Object[]>> customMethods_ = new HashMap<String, BiConsumer<Graphics2D, Object[]>>();
    private Map<String, Method> methodByNameCache_;
    private Font lastFont_ = null;
    private String lastFontStr_ = null;
    private final List<IFGChangeListener<Tuple>> fontChangeListenerList_;

    public FGDefaultPrimitivePainter(double d) {
        this.customMethods_.put(PUSH_CURRENT_CLIP, (graphics2D, objectArray) -> this.clipRectStack_.addLast(graphics2D.getClip()));
        this.customMethods_.put(POP_CURRENT_CLIP, (graphics2D, objectArray) -> graphics2D.setClip(this.clipRectStack_.removeLast()));
        this.customMethods_.put(DRAW_IMAGE, this::drawImage);
        this.customMethods_.put(FIT_IMAGE, this::fitImage);
        this.customMethods_.put(FILL_IMAGE, this::fillImage);
        this.customMethods_.put(SET_FONT, this::setFont);
        this.methodByNameCache_ = new HashMap<String, Method>();
        this.unitSizePx_ = d;
        this.fontChangeListenerList_ = new ArrayList<IFGChangeListener<Tuple>>();
    }

    @Override
    public void addFontChangeListener(IFGChangeListener<Tuple> iFGChangeListener) {
        this.fontChangeListenerList_.add(iFGChangeListener);
    }

    @Override
    public void paintPrimitive(Graphics graphics, List<Object> list) {
        Object object2;
        if (list.size() == 0) {
            return;
        }
        String string = (String)list.get(0);
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle != null && rectangle.width <= 0 && !COMMANDS_ALLOWED_WHEN_CLIPPED_OUT.contains(string)) {
            return;
        }
        boolean bl = COMMANDS_REDUCED_WH.contains(string);
        Object[] objectArray = new Object[list.size() - 1];
        for (int i = 0; i < list.size() - 1; ++i) {
            object2 = list.get(i + 1);
            if (object2 instanceof Number) {
                int n = (int)(((Number)object2).doubleValue() * this.unitSizePx_);
                objectArray[i] = bl && (i == 2 || i == 3) ? n - 1 : n;
                continue;
            }
            objectArray[i] = object2;
        }
        Class[] classArray = Arrays.stream(objectArray).map(object -> object != null ? object.getClass() : null).map(clazz -> NUMBER_CLASS_TO_PRIMITIVE.containsKey(clazz) ? NUMBER_CLASS_TO_PRIMITIVE.get(clazz) : clazz).collect(Collectors.toList()).toArray(new Class[objectArray.length]);
        if (this.customMethods_.containsKey(string)) {
            this.customMethods_.get(string).accept((Graphics2D)graphics, objectArray);
        } else {
            try {
                object2 = this.methodByNameCache_.get(string);
                if (object2 == null) {
                    if (Arrays.stream(classArray).anyMatch(clazz -> clazz == null)) {
                        Method[] methodArray = graphics.getClass().getMethods();
                        Optional<Method> optional = Arrays.stream(methodArray).filter(method -> method.getName().equals(string) && method.getParameterCount() == classArray.length).findAny();
                        object2 = optional.get();
                    } else {
                        object2 = graphics.getClass().getMethod(string, classArray);
                    }
                    this.methodByNameCache_.put(string, (Method)object2);
                }
                ((Method)object2).invoke((Object)graphics, objectArray);
            }
            catch (Exception exception) {
                System.out.println("Error painting primitive: " + list);
                exception.printStackTrace();
            }
        }
    }

    private void drawImage(Graphics2D graphics2D, Object[] objectArray) {
        String string = (String)objectArray[0];
        int n = ((Number)objectArray[1]).intValue();
        int n2 = ((Number)objectArray[2]).intValue();
        try {
            Image image = this.imageLoader_.getImage(string);
            graphics2D.drawImage(image, n, n2, null);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void fitImage(Graphics2D graphics2D, Object[] objectArray) {
        String string = (String)objectArray[0];
        int n = ((Number)objectArray[1]).intValue();
        int n2 = ((Number)objectArray[2]).intValue();
        int n3 = ((Number)objectArray[3]).intValue();
        int n4 = ((Number)objectArray[4]).intValue();
        try {
            Image image = this.imageLoader_.getImage(string);
            graphics2D.drawImage(image, n, n2, n3, n4, null);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void fillImage(Graphics2D graphics2D, Object[] objectArray) {
        String string = (String)objectArray[0];
        int n = ((Number)objectArray[1]).intValue();
        int n2 = ((Number)objectArray[2]).intValue();
        int n3 = ((Number)objectArray[3]).intValue();
        int n4 = ((Number)objectArray[4]).intValue();
        try {
            Image image = this.imageLoader_.getImage(string);
            int n5 = image.getWidth(null);
            int n6 = image.getHeight(null);
            if (n3 <= n5 && n4 <= n6) {
                graphics2D.drawImage(image, n, n2, null);
            } else {
                for (int i = 0; i < n3; i += n5) {
                    for (int j = 0; j < n4; j += n6) {
                        graphics2D.drawImage(image, n + i, n2 + j, null);
                    }
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void setFont(Graphics2D graphics2D, Object[] objectArray) {
        String string = (String)objectArray[0];
        if (this.lastFontStr_ == null || !this.lastFontStr_.equals(string)) {
            Font font = (Font)strToFont_.invoke((Object)string);
            if (font != null) {
                graphics2D.setFont(font);
                if (this.lastFont_ == null || !this.lastFont_.equals(font)) {
                    FGChangeEvent<Tuple> fGChangeEvent = new FGChangeEvent<Tuple>(Tuple.pair(string, font));
                    for (IFGChangeListener<Tuple> iFGChangeListener : this.fontChangeListenerList_) {
                        iFGChangeListener.onChange(fGChangeEvent);
                    }
                }
                this.lastFont_ = font;
            }
            this.lastFontStr_ = string;
        }
    }

    static {
        NUMBER_CLASS_TO_PRIMITIVE.put(Integer.class, Integer.TYPE);
        NUMBER_CLASS_TO_PRIMITIVE.put(Long.class, Integer.TYPE);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(SET_CLIP);
        hashSet.add(CLIP_RECT);
        hashSet.add(PUSH_CURRENT_CLIP);
        hashSet.add(POP_CURRENT_CLIP);
        hashSet.add(TRANSFORM);
        COMMANDS_ALLOWED_WHEN_CLIPPED_OUT = Collections.unmodifiableSet(hashSet);
        hashSet = new HashSet();
        hashSet.add("drawRect");
        hashSet.add("drawRoundRect");
        COMMANDS_REDUCED_WH = Collections.unmodifiableSet(hashSet);
        strToFont_ = RT.var((String)"flatgui.awt", (String)"str->font");
    }
}

