/*
 * Decompiled with CFR 0.152.
 */
package flatgui.core;

import clojure.lang.Keyword;
import clojure.lang.RT;
import clojure.lang.Var;
import flatgui.core.FGEvolveInputData;
import flatgui.core.FGEvolveResultData;
import flatgui.core.IFGContainer;
import flatgui.core.IFGModule;
import flatgui.core.engine.remote.FGLegacyCoreGlue;
import flatgui.core.util.IFGChangeListener;
import flatgui.core.websocket.FGPaintVectorBinaryCoder;
import java.awt.geom.AffineTransform;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class FGWebContainerWrapper {
    public static final byte POSITION_MATRIX_MAP_COMMAND_CODE = 0;
    public static final byte VIEWPORT_MATRIX_MAP_COMMAND_CODE = 1;
    public static final byte CLIP_SIZE_MAP_COMMAND_CODE = 2;
    public static final byte LOOK_VECTOR_MAP_COMMAND_CODE = 3;
    public static final byte CHILD_COUNT_MAP_COMMAND_CODE = 4;
    public static final byte BOOLEAN_STATE_FLAGS_COMMAND_CODE = 5;
    public static final byte STRING_POOL_MAP_COMMAND_CODE = 7;
    public static final byte RESOURCE_STRING_POOL_MAP_COMMAND_CODE = 8;
    public static final byte CLIENT_EVOLVER_MAP_COMMAND_CODE = 9;
    public static final byte PAINT_ALL_LIST_COMMAND_CODE = 64;
    public static final byte REPAINT_CACHED_COMMAND_CODE = 65;
    public static final byte SET_CURSOR_COMMAND_CODE = 66;
    public static final byte PUSH_TEXT_TO_CLIPBOARD = 67;
    public static final byte TEXT_SELECTION_MODEL_COMMAND_CODE = 68;
    public static final byte REMOVE_ADD_COMPONENTS_COMMAND_CODE = 69;
    public static final byte FINISH_PREDICTION_TRANSMISSION = 100;
    public static final byte MOUSE_LEFT_DOWN_PREDICTION = 101;
    public static final byte MOUSE_LEFT_UP_PREDICTION = 102;
    public static final byte MOUSE_LEFT_CLICK_PREDICTION = 103;
    public static final byte MOUSE_MOVE_OR_DRAG_PREDICTION_HEADER = 104;
    public static final byte MOUSE_MOVE_OR_DRAG_PREDICTION = 105;
    public static final byte PING_RESPONSE = 106;
    public static final byte METRICS_REQUEST = 107;
    public static String DEBUG_OP = "OLD";
    public static final byte[] MOUSE_LEFT_CLICK_PREDICTION_SEQUENCE = new byte[]{101, 102, 103};
    private static Set<String> RECT_COMMANDS = new HashSet<String>();
    private final FGContainerStateTransmitter stateTransmitter_;
    private final Map<Object, FGContainerStateTransmitter> stateTransmitterForks_;
    private final IFGContainer fgContainer_;
    private Function<FGEvolveInputData, Future<FGEvolveResultData>> eventConsumer_;
    private Set<String> fontsWithMetricsAlreadyReceived_;
    private volatile int debug_ = 0;

    public FGWebContainerWrapper(IFGContainer iFGContainer, Set<String> set) {
        this.fgContainer_ = iFGContainer;
        this.eventConsumer_ = this.fgContainer_.connect(actionEvent -> {}, this);
        this.fontsWithMetricsAlreadyReceived_ = set;
        this.stateTransmitter_ = new FGContainerStateTransmitter(this.fgContainer_, this.fontsWithMetricsAlreadyReceived_);
        this.stateTransmitterForks_ = new HashMap<Object, FGContainerStateTransmitter>();
    }

    public IFGContainer getContainer() {
        return this.fgContainer_;
    }

    public synchronized void initialize() {
        this.fgContainer_.initialize();
    }

    public synchronized void unInitialize() {
        this.fgContainer_.unInitialize();
    }

    public synchronized boolean isActive() {
        return this.fgContainer_.isActive();
    }

    public synchronized Future<FGEvolveResultData> feedEvent(FGEvolveInputData fGEvolveInputData) {
        Future<FGEvolveResultData> future = this.fgContainer_.feedEvent(fGEvolveInputData);
        this.obtainForkIfNeeded(fGEvolveInputData);
        return future;
    }

    public synchronized Future<FGEvolveResultData> feedTargetedEvent(List<Keyword> list, FGEvolveInputData fGEvolveInputData) {
        Future<FGEvolveResultData> future = this.fgContainer_.feedTargetedEvent(list, fGEvolveInputData);
        this.obtainForkIfNeeded(fGEvolveInputData);
        return future;
    }

    public synchronized Collection<ByteBuffer> getResponseForClient(Future<FGEvolveResultData> future) {
        return this.getResponseForClientImpl(this.stateTransmitter_, future);
    }

    public synchronized Collection<ByteBuffer> getForkedResponseForClient(Object object, Future<FGEvolveResultData> future) {
        FGContainerStateTransmitter fGContainerStateTransmitter = this.stateTransmitterForks_.get(object);
        if (fGContainerStateTransmitter == null) {
            throw new IllegalStateException("stateTransmitter is null for " + object.toString());
        }
        return this.getResponseForClientImpl(fGContainerStateTransmitter, future);
    }

    public synchronized void clearForks() {
        this.stateTransmitterForks_.clear();
    }

    public synchronized void resetCache() {
        this.stateTransmitter_.resetDataCache();
    }

    public void addFontStrListener(IFGChangeListener<String> iFGChangeListener) {
        this.stateTransmitter_.addFontStrListener(iFGChangeListener);
    }

    public synchronized Collection<ByteBuffer> getResponseForClientImpl(FGContainerStateTransmitter fGContainerStateTransmitter, Future<FGEvolveResultData> future) {
        try {
            Future<Collection> future2 = this.fgContainer_.submitTask(() -> fGContainerStateTransmitter.computeDataDiffsToTransmit(future));
            Collection collection = future2.get();
            Future<Collection> future3 = this.fgContainer_.submitTask(() -> future != null ? ((FGLegacyCoreGlue)this.fgContainer_).getDiffsToTransmit() : ((FGLegacyCoreGlue)this.fgContainer_).getInitialDataToTransmit());
            Collection collection2 = future3.get();
            this.debug_ = 4;
            return collection2;
        }
        catch (InterruptedException | ExecutionException exception) {
            exception.printStackTrace();
            return Collections.emptyList();
        }
    }

    public synchronized boolean markFontAsHavingReceivedMetrics(String string) {
        return this.fontsWithMetricsAlreadyReceived_.add(string);
    }

    public static int wtireShort(ByteArrayOutputStream byteArrayOutputStream, int n) {
        byteArrayOutputStream.write((byte)(n & 0xFF));
        byteArrayOutputStream.write((byte)(n >> 8 & 0xFF));
        return 2;
    }

    private void obtainForkIfNeeded(FGEvolveInputData fGEvolveInputData) {
        if (fGEvolveInputData.shouldFork()) {
            Object object = fGEvolveInputData.getEvolveReason();
            IFGModule iFGModule = this.fgContainer_.getForkedFGModule(object);
            this.stateTransmitterForks_.put(object, this.stateTransmitter_.fork(iFGModule));
        }
    }

    private void ensureActive() {
        if (!this.fgContainer_.isActive()) {
            throw new IllegalStateException("Container is not active");
        }
    }

    private List<Object> compressPaintVector(List<Object> list) {
        list = list.stream().filter(object -> {
            Object e = ((List)object).get(0);
            if (RECT_COMMANDS.contains(e)) {
                double d = FGWebContainerWrapper.getCoord((List)object, 1);
                double d2 = FGWebContainerWrapper.getCoord((List)object, 2);
                double d3 = FGWebContainerWrapper.getCoord((List)object, 3);
                double d4 = FGWebContainerWrapper.getCoord((List)object, 4);
                if (d == 0.0 && d2 == 0.0 && d3 == 0.0 && d4 == 0.0) {
                    return false;
                }
            }
            return true;
        }).collect(Collectors.toList());
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            ArrayList arrayList2 = new ArrayList((List)list.get(n2));
            String string = (String)arrayList2.get(0);
            if (n2 < n - 1) {
                if (FGWebContainerWrapper.getCommand(list, n2).equals("transform")) {
                    int n3;
                    double d = ((AffineTransform)arrayList2.get(1)).getTranslateX();
                    double d2 = ((AffineTransform)arrayList2.get(1)).getTranslateY();
                    boolean bl = false;
                    for (n3 = n2 + 1; n3 < n && FGWebContainerWrapper.getCommand(list, n3).equals("transform"); ++n3) {
                        ArrayList arrayList3 = new ArrayList((List)list.get(n3));
                        d += ((AffineTransform)arrayList3.get(1)).getTranslateX();
                        d2 += ((AffineTransform)arrayList3.get(1)).getTranslateY();
                        bl = true;
                    }
                    if (bl) {
                        arrayList.add(Arrays.asList("transform", AffineTransform.getTranslateInstance(d, d2)));
                        n2 = n3;
                        continue;
                    }
                    arrayList.add(arrayList2);
                    ++n2;
                    continue;
                }
                arrayList.add(arrayList2);
                ++n2;
                continue;
            }
            arrayList.add(arrayList2);
            ++n2;
        }
        return arrayList;
    }

    private static String getCommand(List<Object> list, int n) {
        ArrayList arrayList = new ArrayList((List)list.get(n));
        return (String)arrayList.get(0);
    }

    private static double getCoord(List list, int n) {
        return ((Number)list.get(n)).doubleValue();
    }

    private List<Object> compressPaintVector2(List<Object> list) {
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            ArrayList<Double> arrayList2 = new ArrayList<Double>((List)list.get(i));
            String string = (String)arrayList2.get(0);
            if (string.equals("transform")) {
                d += ((AffineTransform)arrayList2.get(1)).getTranslateX();
                d2 += ((AffineTransform)arrayList2.get(1)).getTranslateY();
                continue;
            }
            double d3 = d / 64.0;
            double d4 = d2 / 64.0;
            switch (string) {
                case "drawString": {
                    double d5 = ((Number)arrayList2.get(2)).doubleValue();
                    double d6 = ((Number)arrayList2.get(3)).doubleValue();
                    arrayList2.set(2, d5 + d3);
                    arrayList2.set(3, d6 + d4);
                    break;
                }
                case "drawLine": {
                    double d5 = ((Number)arrayList2.get(1)).doubleValue();
                    double d6 = ((Number)arrayList2.get(2)).doubleValue();
                    arrayList2.set(1, d5 + d3);
                    arrayList2.set(2, d6 + d4);
                    double d7 = ((Number)arrayList2.get(3)).doubleValue();
                    double d8 = ((Number)arrayList2.get(4)).doubleValue();
                    arrayList2.set(3, d7 + d3);
                    arrayList2.set(4, d8 + d4);
                    break;
                }
                case "drawRect": 
                case "fillRect": 
                case "drawOval": 
                case "fillOval": 
                case "clipRect": 
                case "setClip": {
                    double d5 = ((Number)arrayList2.get(1)).doubleValue();
                    double d6 = ((Number)arrayList2.get(2)).doubleValue();
                    arrayList2.set(1, d5 + d3);
                    arrayList2.set(2, d6 + d4);
                }
            }
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    private static boolean eq(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    static {
        RECT_COMMANDS.add("drawLine");
        RECT_COMMANDS.add("drawRect");
        RECT_COMMANDS.add("fillRect");
        RECT_COMMANDS.add("drawOval");
        RECT_COMMANDS.add("fillOval");
        RECT_COMMANDS.add("clipRect");
        RECT_COMMANDS.add("setClip");
    }

    static class FGContainerStateTransmitter {
        private static final String RESPONSE_FEED_NS = "flatgui.responsefeed";
        private static final Var extractPositionMatrix_ = RT.var((String)"flatgui.responsefeed", (String)"extract-position-matrix");
        private static final Var extractViewportMatrix_ = RT.var((String)"flatgui.responsefeed", (String)"extract-viewport-matrix");
        private static final Var extractClipSize_ = RT.var((String)"flatgui.responsefeed", (String)"extract-clip-size");
        private static final Var extractLookVector_ = RT.var((String)"flatgui.responsefeed", (String)"extract-look-vector");
        private static final Var extractChildCount_ = RT.var((String)"flatgui.responsefeed", (String)"extract-child-count");
        private static final Var extractBitFlags_ = RT.var((String)"flatgui.responsefeed", (String)"extract-bit-flags");
        private static final Var extractStringPool_ = RT.var((String)"flatgui.responsefeed", (String)"extract-string-pool");
        private static final Var extractResourceStringPool_ = RT.var((String)"flatgui.responsefeed", (String)"extract-resource-string-pool");
        private static final Var extractClientEvolver_ = RT.var((String)"flatgui.responsefeed", (String)"extract-client-evolver");
        private static final byte DEFAULT_CURSOR_CODE = 8;
        private static final Map<String, Integer> CURSOR_NAME_TO_CODE;
        private static final BinaryOperator THROWING_MERGER;
        private IKeyCache keyCache_;
        private final IFGContainer fgContainer_;
        private final IFGModule fgModule_;
        private Map<Byte, Object> cmdToLastData_;
        private Map<Byte, IDataTransmitter<Object>> cmdToDataTransmitter_;
        private FGPaintVectorBinaryCoder.StringPoolIdSupplier stringPoolIdSupplier_;
        private Map<Object, Map<Keyword, Object>> idPathToComponent_;
        private final LookVectorTransmitter lookVectorTransmitter_;
        private final Set<String> fontsWithMetricsAlreadyReceived_;
        boolean initialCycle_;
        private long debugStartTime_;

        public FGContainerStateTransmitter(IFGContainer iFGContainer, Set<String> set) {
            this(true, iFGContainer, iFGContainer.getFGModule(), null, new KeyCache(), set);
        }

        public FGContainerStateTransmitter(boolean bl, IFGContainer iFGContainer, IFGModule iFGModule, Map<Byte, Object> map, IKeyCache iKeyCache, Set<String> set) {
            this.initialCycle_ = bl;
            this.fgContainer_ = iFGContainer;
            this.fgModule_ = iFGModule;
            this.keyCache_ = iKeyCache;
            this.cmdToDataTransmitter_ = new LinkedHashMap<Byte, IDataTransmitter<Object>>();
            this.stringPoolIdSupplier_ = this.fgModule_::getStringPoolId;
            this.fontsWithMetricsAlreadyReceived_ = set;
            this.addDataTransmitter(new PositionMatrixMapTrasmitter(this.keyCache_, () -> this.idPathToComponent_.entrySet().stream().map(entry -> FGContainerStateTransmitter.checkMapEntry(entry, "Position matrix")).collect(Collectors.toMap(entry -> entry.getKey(), entry -> extractPositionMatrix_.invoke(entry.getValue())))));
            this.addDataTransmitter(new ViewportMatrixMapTrasmitter(this.keyCache_, () -> this.idPathToComponent_.entrySet().stream().map(entry -> FGContainerStateTransmitter.checkMapEntry(entry, "Viewport matrix")).collect(Collectors.toMap(entry -> entry.getKey(), entry -> extractViewportMatrix_.invoke(entry.getValue())))));
            this.addDataTransmitter(new ClipRectTransmitter(this.keyCache_, () -> this.idPathToComponent_.entrySet().stream().map(entry -> FGContainerStateTransmitter.checkMapEntry(entry, "Clip size")).collect(Collectors.toMap(entry -> entry.getKey(), entry -> extractClipSize_.invoke(entry.getValue())))));
            this.lookVectorTransmitter_ = new LookVectorTransmitter(this.stringPoolIdSupplier_, this.keyCache_, () -> this.idPathToComponent_.entrySet().stream().map(entry -> FGContainerStateTransmitter.checkMapEntry(entry, "Look vector")).collect(Collectors.toMap(entry -> entry.getKey(), entry -> extractLookVector_.invoke(entry.getValue()))), set);
            this.addDataTransmitter(this.lookVectorTransmitter_);
            this.addDataTransmitter(new ChildCountMapTransmitter(this.keyCache_, () -> this.idPathToComponent_.entrySet().stream().map(entry -> FGContainerStateTransmitter.checkMapEntry(entry, "Child count")).collect(Collectors.toMap(entry -> entry.getKey(), entry -> extractChildCount_.invoke(entry.getValue())))));
            this.addDataTransmitter(new BooleanFlagsMapTransmitter(this.keyCache_, () -> this.idPathToComponent_.entrySet().stream().map(entry -> FGContainerStateTransmitter.checkMapEntry(entry, "Bit flags")).collect(Collectors.toMap(entry -> entry.getKey(), entry -> extractBitFlags_.invoke(entry.getValue())))));
            this.addDataTransmitter(new PaintAllTransmitter(this.keyCache_, this.fgModule_::getPaintAllSequence2));
            this.addDataTransmitter(new StringPoolMapTransmitter(this.keyCache_, this.createStringPoolSupplier(extractStringPool_)));
            this.addDataTransmitter(new ResourceStringPoolMapTransmitter(this.keyCache_, this.createStringPoolSupplier(extractResourceStringPool_)));
            this.addDataTransmitter(new ClientEvolverTransmitter(this.keyCache_, this.createClientEvolverSupplier()));
            if (map == null) {
                this.resetDataCache();
            } else {
                this.cmdToLastData_ = map;
            }
            this.fgModule_.getPaintAllSequence2().forEach(this.keyCache_::getUniqueId);
        }

        public final FGContainerStateTransmitter fork(IFGModule iFGModule) {
            HashMap<Byte, Object> hashMap = new HashMap<Byte, Object>();
            for (Byte by : this.cmdToLastData_.keySet()) {
                Object object = this.cmdToLastData_.get(by);
                if (object instanceof Map) {
                    hashMap.put(by, new HashMap((Map)object));
                    continue;
                }
                hashMap.put(by, object);
            }
            return new FGContainerStateTransmitter(false, this.fgContainer_, iFGModule, hashMap, this.keyCache_, this.fontsWithMetricsAlreadyReceived_);
        }

        public Collection<ByteBuffer> computeDataDiffsToTransmit(Future<FGEvolveResultData> future) {
            this.debugStartTime_ = System.nanoTime();
            FGEvolveResultData fGEvolveResultData = null;
            if (!this.initialCycle_ && future != null) {
                try {
                    fGEvolveResultData = future.get();
                }
                catch (InterruptedException | ExecutionException exception) {
                    exception.printStackTrace();
                    return Collections.emptyList();
                }
            }
            long l = System.nanoTime() - this.debugStartTime_;
            return null;
        }

        public void resetDataCache() {
            this.cmdToLastData_ = this.cmdToDataTransmitter_.entrySet().stream().collect(Collectors.toMap(entry -> (Byte)entry.getKey(), entry -> ((IDataTransmitter)entry.getValue()).getEmptyDataSupplier().get()));
        }

        void addFontStrListener(IFGChangeListener<String> iFGChangeListener) {
            this.lookVectorTransmitter_.addFontStrListener(iFGChangeListener);
        }

        private static <K> Map.Entry<K, Map<Keyword, Object>> checkMapEntry(Map.Entry<K, Map<Keyword, Object>> entry, String string) {
            if (entry.getValue() == null) {
                throw new NullPointerException(string + " is null for " + entry.getKey());
            }
            return entry;
        }

        private Supplier<Map<Object, Object>> createStringPoolSupplier(Var var) {
            return () -> {
                HashMap<Object, List<String>> hashMap = new HashMap<Object, List<String>>();
                this.idPathToComponent_.forEach((object, map2) -> hashMap.put(object, (List)var.invoke(map2)));
                return this.fgModule_.getStringPoolDiffs(hashMap);
            };
        }

        private Supplier<Map<Object, Object>> createClientEvolverSupplier() {
            return () -> {
                HashMap hashMap = new HashMap();
                this.idPathToComponent_.forEach((object, map2) -> {
                    Object object2 = extractClientEvolver_.invoke(map2);
                    if (object2 != null) {
                        hashMap.put(object, object2);
                    }
                });
                return hashMap;
            };
        }

        private void addDataTransmitter(IDataTransmitter<?> iDataTransmitter) {
            this.cmdToDataTransmitter_.put(iDataTransmitter.getCommandCode(), iDataTransmitter);
        }

        private void mergeNewDatasToLast(Map<Byte, Object> map) {
            for (Byte by : map.keySet()) {
                Object object = map.get(by);
                if (object instanceof Map) {
                    Map map2 = (Map)this.cmdToLastData_.get(by);
                    if (map2 == null) {
                        this.cmdToLastData_.put(by, object);
                        continue;
                    }
                    map2.putAll((Map)object);
                    continue;
                }
                this.cmdToLastData_.put(by, object);
            }
        }

        private static /* synthetic */ boolean lambda$computeDataDiffsToTransmit$75(ByteBuffer byteBuffer) {
            return byteBuffer != null;
        }

        private /* synthetic */ ByteBuffer lambda$computeDataDiffsToTransmit$74(Map.Entry entry) {
            Object v;
            Object object;
            IDataTransmitter<Object> iDataTransmitter = this.cmdToDataTransmitter_.get(entry.getKey());
            Object object2 = iDataTransmitter.getDiffToTransmit(object = this.cmdToLastData_.get(entry.getKey()), v = entry.getValue());
            ByteBuffer byteBuffer = object2 != null ? iDataTransmitter.convertToBinary((Byte)entry.getKey(), object2) : null;
            return byteBuffer;
        }

        private static /* synthetic */ Object lambda$computeDataDiffsToTransmit$73(Map.Entry entry) {
            Object s = ((IDataTransmitter)entry.getValue()).getSourceDataSupplier().get();
            return s;
        }

        private static /* synthetic */ Byte lambda$computeDataDiffsToTransmit$72(Map.Entry entry) {
            return (Byte)entry.getKey();
        }

        static {
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            hashMap.put("alias", 0);
            hashMap.put("all-scroll", 1);
            hashMap.put("auto", 2);
            hashMap.put("cell", 3);
            hashMap.put("context-menu", 4);
            hashMap.put("col-resize", 5);
            hashMap.put("copy", 6);
            hashMap.put("crosshair", 7);
            hashMap.put("default", 8);
            hashMap.put("e-resize", 9);
            hashMap.put("ew-resize", 10);
            hashMap.put("help", 11);
            hashMap.put("move", 12);
            hashMap.put("n-resize", 13);
            hashMap.put("ne-resize", 14);
            hashMap.put("nw-resize", 15);
            hashMap.put("nwse-resize", (Integer)hashMap.get("nw-resize"));
            hashMap.put("ns-resize", 16);
            hashMap.put("no-drop", 17);
            hashMap.put("none", 18);
            hashMap.put("not-allowed", 19);
            hashMap.put("pointer", 20);
            hashMap.put("progress", 21);
            hashMap.put("row-resize", 22);
            hashMap.put("s-resize", 23);
            hashMap.put("se-resize", 24);
            hashMap.put("sw-resize", 25);
            hashMap.put("nesw-resize", (Integer)hashMap.get("sw-resize"));
            hashMap.put("text", 26);
            hashMap.put("vertical-text", 27);
            hashMap.put("w-resize", 28);
            hashMap.put("wait", 29);
            hashMap.put("zoom-in", 30);
            hashMap.put("zoom-out", 31);
            CURSOR_NAME_TO_CODE = Collections.unmodifiableMap(hashMap);
            THROWING_MERGER = (object, object2) -> {
                throw new IllegalStateException(String.format("Duplicate key %s", object));
            };
        }
    }

    public static class KeyCache
    implements IKeyCache {
        private int uid_ = 0;
        private Map<Object, Integer> cache_ = new HashMap<Object, Integer>();

        @Override
        public int getUniqueId(Object object) {
            if (!(object instanceof Integer)) {
                throw new IllegalArgumentException("non-integer key");
            }
            Integer n = this.cache_.get(object);
            if (n == null) {
                n = (Integer)object;
                this.cache_.put(object, n);
                ++this.uid_;
            }
            return n;
        }
    }

    public static class PaintAllTransmitter
    extends KeyListTransmitter {
        public PaintAllTransmitter(IKeyCache iKeyCache, Supplier<List<Object>> supplier) {
            super(iKeyCache, supplier);
        }

        @Override
        public byte getCommandCode() {
            return 64;
        }
    }

    static abstract class KeyListTransmitter
    extends ListTransmitter<Object> {
        private IKeyCache keyCache_;

        public KeyListTransmitter(IKeyCache iKeyCache, Supplier<List<Object>> supplier) {
            super(supplier);
            this.keyCache_ = iKeyCache;
        }

        @Override
        protected int writeValue(ByteArrayOutputStream byteArrayOutputStream, int n, Object object) {
            int n2 = this.keyCache_.getUniqueId(object);
            byteArrayOutputStream.write((byte)(n2 & 0xFF));
            byteArrayOutputStream.write((byte)(n2 >> 8 & 0xFF));
            return 2;
        }
    }

    static abstract class ListTransmitter<V>
    extends AbstractTransmitter<List<Object>> {
        private Supplier<List<Object>> sourceListSupplier_;

        ListTransmitter(Supplier<List<Object>> supplier) {
            this.sourceListSupplier_ = supplier;
        }

        @Override
        public List<Object> getDiffToTransmit(List<Object> list, List<Object> list2) {
            return list2.isEmpty() || list2.equals(list) ? null : list2;
        }

        @Override
        public int writeBinary(ByteArrayOutputStream byteArrayOutputStream, int n, List<Object> list) {
            for (Object object : list) {
                int n2 = this.writeValue(byteArrayOutputStream, n, object);
                n += n2;
            }
            return n;
        }

        @Override
        public Supplier<List<Object>> getEmptyDataSupplier() {
            return ArrayList::new;
        }

        @Override
        public Supplier<List<Object>> getSourceDataSupplier() {
            return this.sourceListSupplier_;
        }

        protected abstract int writeValue(ByteArrayOutputStream var1, int var2, V var3);
    }

    public static class ClientEvolverTransmitter
    extends StringTransmitter {
        public ClientEvolverTransmitter(IKeyCache iKeyCache, Supplier<Map<Object, Object>> supplier) {
            super(iKeyCache, supplier);
        }

        @Override
        public byte getCommandCode() {
            return 9;
        }
    }

    public static class ResourceStringPoolMapTransmitter
    extends AbstractStringPoolMapTransmitter {
        public ResourceStringPoolMapTransmitter(IKeyCache iKeyCache, Supplier<Map<Object, Object>> supplier) {
            super(iKeyCache, supplier);
        }

        @Override
        public byte getCommandCode() {
            return 8;
        }
    }

    public static class StringPoolMapTransmitter
    extends AbstractStringPoolMapTransmitter {
        public StringPoolMapTransmitter(IKeyCache iKeyCache, Supplier<Map<Object, Object>> supplier) {
            super(iKeyCache, supplier);
        }

        @Override
        public byte getCommandCode() {
            return 7;
        }
    }

    public static abstract class AbstractStringPoolMapTransmitter
    extends MapTransmitter<Map<Integer, String>> {
        public AbstractStringPoolMapTransmitter(IKeyCache iKeyCache, Supplier<Map<Object, Object>> supplier) {
            super(iKeyCache, supplier);
        }

        @Override
        protected int writeValue(ByteArrayOutputStream byteArrayOutputStream, int n, Map<Integer, String> map) {
            int n2 = map.size();
            if (n2 > 255) {
                throw new UnsupportedOperationException();
            }
            int n3 = 0;
            byteArrayOutputStream.write((byte)(n2 & 0xFF));
            ++n3;
            for (Map.Entry<Integer, String> entry : map.entrySet()) {
                byteArrayOutputStream.write(entry.getKey().byteValue());
                ++n3;
                n3 += StringTransmitter.writeString(byteArrayOutputStream, n3, entry.getValue());
            }
            return n3;
        }
    }

    public static abstract class StringTransmitter
    extends MapTransmitter<String> {
        public StringTransmitter(IKeyCache iKeyCache, Supplier<Map<Object, Object>> supplier) {
            super(iKeyCache, supplier);
        }

        @Override
        protected int writeValue(ByteArrayOutputStream byteArrayOutputStream, int n, String string) {
            return StringTransmitter.writeString(byteArrayOutputStream, n, string);
        }

        public static int writeString(ByteArrayOutputStream byteArrayOutputStream, int n, String string) {
            int n2 = string.length();
            byteArrayOutputStream.write((byte)(n2 & 0xFF));
            byteArrayOutputStream.write((byte)(n2 >> 8 & 0xFF));
            byte[] byArray = string.getBytes();
            byteArrayOutputStream.write(byArray, 0, byArray.length);
            return n2 + 2;
        }
    }

    public static class LookVectorTransmitter
    extends MapTransmitter<List<Object>> {
        private FGPaintVectorBinaryCoder coder_;

        public LookVectorTransmitter(FGPaintVectorBinaryCoder.StringPoolIdSupplier stringPoolIdSupplier, IKeyCache iKeyCache, Supplier<Map<Object, Object>> supplier, Set<String> set) {
            super(iKeyCache, supplier);
            this.coder_ = new FGPaintVectorBinaryCoder(stringPoolIdSupplier, set);
        }

        @Override
        protected void onWritingUid(Object object, int n) {
            this.coder_.setCodedComponentUid(object, n);
        }

        @Override
        protected int writeValue(ByteArrayOutputStream byteArrayOutputStream, int n, List<Object> list) {
            byte[] byArray = new byte[131072];
            int n2 = this.coder_.writeCoded(byArray, 0, list);
            byteArrayOutputStream.write((byte)(n2 & 0xFF));
            byteArrayOutputStream.write((byte)(n2 >> 8 & 0xFF));
            byteArrayOutputStream.write(byArray, 0, n2);
            return n2 + 2;
        }

        @Override
        public byte getCommandCode() {
            return 3;
        }

        void addFontStrListener(IFGChangeListener<String> iFGChangeListener) {
            this.coder_.addFontStrListener(iFGChangeListener);
        }
    }

    public static class ClipRectTransmitter
    extends MapTransmitter<List<Number>> {
        public ClipRectTransmitter(IKeyCache iKeyCache, Supplier<Map<Object, Object>> supplier) {
            super(iKeyCache, supplier);
        }

        @Override
        protected int writeValue(ByteArrayOutputStream byteArrayOutputStream, int n, List<Number> list) {
            int n2 = (int)(list.get(0).doubleValue() * 64.0);
            int n3 = (int)(list.get(1).doubleValue() * 64.0);
            byteArrayOutputStream.write((byte)(n2 & 0xFF));
            byteArrayOutputStream.write((byte)(n3 & 0xFF));
            byteArrayOutputStream.write((byte)(n2 >> 8 & 0xF | n3 >> 4 & 0xF0));
            return 3;
        }

        @Override
        public byte getCommandCode() {
            return 2;
        }
    }

    public static class BooleanFlagsMapTransmitter
    extends ByteMapTrasmitter {
        public BooleanFlagsMapTransmitter(IKeyCache iKeyCache, Supplier<Map<Object, Object>> supplier) {
            super(iKeyCache, supplier);
        }

        @Override
        public byte getCommandCode() {
            return 5;
        }
    }

    public static class ChildCountMapTransmitter
    extends ShortMapTrasmitter {
        public ChildCountMapTransmitter(IKeyCache iKeyCache, Supplier<Map<Object, Object>> supplier) {
            super(iKeyCache, supplier);
        }

        @Override
        public byte getCommandCode() {
            return 4;
        }
    }

    static abstract class ByteMapTrasmitter
    extends MapTransmitter<Number> {
        public ByteMapTrasmitter(IKeyCache iKeyCache, Supplier<Map<Object, Object>> supplier) {
            super(iKeyCache, supplier);
        }

        @Override
        protected int writeValue(ByteArrayOutputStream byteArrayOutputStream, int n, Number number) {
            byte by = number.byteValue();
            byteArrayOutputStream.write(by);
            return 1;
        }
    }

    static abstract class ShortMapTrasmitter
    extends MapTransmitter<Number> {
        public ShortMapTrasmitter(IKeyCache iKeyCache, Supplier<Map<Object, Object>> supplier) {
            super(iKeyCache, supplier);
        }

        @Override
        protected int writeValue(ByteArrayOutputStream byteArrayOutputStream, int n, Number number) {
            short s = number.shortValue();
            byteArrayOutputStream.write((byte)(s & 0xFF));
            byteArrayOutputStream.write((byte)(s >> 8 & 0xFF));
            return 2;
        }
    }

    public static class ViewportMatrixMapTrasmitter
    extends TransformMatrixMapTransmitter {
        public ViewportMatrixMapTrasmitter(IKeyCache iKeyCache, Supplier<Map<Object, Object>> supplier) {
            super(iKeyCache, supplier);
        }

        @Override
        protected int getTranslateX(AffineTransform affineTransform) {
            return -((int)affineTransform.getTranslateX());
        }

        @Override
        protected int getTranslateY(AffineTransform affineTransform) {
            return -((int)affineTransform.getTranslateY());
        }

        @Override
        public byte getCommandCode() {
            return 1;
        }
    }

    public static class PositionMatrixMapTrasmitter
    extends TransformMatrixMapTransmitter {
        public PositionMatrixMapTrasmitter(IKeyCache iKeyCache, Supplier<Map<Object, Object>> supplier) {
            super(iKeyCache, supplier);
        }

        @Override
        protected int getTranslateX(AffineTransform affineTransform) {
            return (int)affineTransform.getTranslateX();
        }

        @Override
        protected int getTranslateY(AffineTransform affineTransform) {
            return (int)affineTransform.getTranslateY();
        }

        @Override
        public byte getCommandCode() {
            return 0;
        }
    }

    static abstract class TransformMatrixMapTransmitter
    extends MapTransmitter<AffineTransform> {
        TransformMatrixMapTransmitter(IKeyCache iKeyCache, Supplier<Map<Object, Object>> supplier) {
            super(iKeyCache, supplier);
        }

        @Override
        protected int writeValue(ByteArrayOutputStream byteArrayOutputStream, int n, AffineTransform affineTransform) {
            int n2 = this.getTranslateX(affineTransform);
            int n3 = this.getTranslateY(affineTransform);
            this.writeDimImpl(byteArrayOutputStream, n2, n3);
            return 3;
        }

        protected int writeDimImpl(ByteArrayOutputStream byteArrayOutputStream, int n, int n2) {
            byteArrayOutputStream.write((byte)(n & 0xFF));
            byteArrayOutputStream.write((byte)(n >> 8 & 0xFF));
            byteArrayOutputStream.write((byte)(n >> 16 & 0xFF));
            byteArrayOutputStream.write((byte)(n2 & 0xFF));
            byteArrayOutputStream.write((byte)(n2 >> 8 & 0xFF));
            byteArrayOutputStream.write((byte)(n2 >> 16 & 0xFF));
            return 6;
        }

        protected abstract int getTranslateX(AffineTransform var1);

        protected abstract int getTranslateY(AffineTransform var1);
    }

    static abstract class MapFullNewTransmitter<V>
    extends AbstractMapTransmitter<V> {
        public MapFullNewTransmitter(IKeyCache iKeyCache, Supplier<Map<Object, Object>> supplier) {
            super(iKeyCache, supplier);
        }

        @Override
        public Map<Object, Object> getDiffToTransmit(Map<Object, Object> map, Map<Object, Object> map2) {
            return map2.isEmpty() ? null : map2;
        }
    }

    static abstract class MapTransmitter<V>
    extends AbstractMapTransmitter<V> {
        public MapTransmitter(IKeyCache iKeyCache, Supplier<Map<Object, Object>> supplier) {
            super(iKeyCache, supplier);
        }

        @Override
        public Map<Object, Object> getDiffToTransmit(Map<Object, Object> map, Map<Object, Object> map2) {
            Map<Object, Object> map3 = map2.entrySet().stream().filter(entry -> !FGWebContainerWrapper.eq(map.get(entry.getKey()), entry.getValue())).collect(Collectors.toMap(entry -> entry.getKey(), entry -> entry.getValue()));
            return map3.isEmpty() ? null : map3;
        }
    }

    static abstract class AbstractMapTransmitter<V>
    extends AbstractTransmitter<Map<Object, Object>> {
        private IKeyCache keyCache_;
        private Supplier<Map<Object, Object>> sourceMapSupplier_;

        public AbstractMapTransmitter(IKeyCache iKeyCache, Supplier<Map<Object, Object>> supplier) {
            this.keyCache_ = iKeyCache;
            this.sourceMapSupplier_ = supplier;
        }

        @Override
        public int writeBinary(ByteArrayOutputStream byteArrayOutputStream, int n, Map<Object, Object> map) {
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                Object object = entry.getKey();
                int n2 = this.keyCache_.getUniqueId(object);
                this.onWritingUid(object, n2);
                byteArrayOutputStream.write((byte)(n2 & 0xFF));
                ++n;
                byteArrayOutputStream.write((byte)(n2 >> 8 & 0xFF));
                int n3 = this.writeValue(byteArrayOutputStream, ++n, entry.getValue());
                n += n3;
            }
            return n;
        }

        @Override
        public Supplier<Map<Object, Object>> getEmptyDataSupplier() {
            return HashMap::new;
        }

        @Override
        public Supplier<Map<Object, Object>> getSourceDataSupplier() {
            return this.sourceMapSupplier_;
        }

        protected void onWritingUid(Object object, int n) {
        }

        protected abstract int writeValue(ByteArrayOutputStream var1, int var2, V var3);
    }

    public static interface IKeyCache {
        public int getUniqueId(Object var1);
    }

    public static abstract class AbstractTransmitter<S>
    implements IDataTransmitter<S> {
        @Override
        public ByteBuffer convertToBinary(byte by, S s) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(by);
            this.writeBinary(byteArrayOutputStream, 1, s);
            return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
        }

        public abstract int writeBinary(ByteArrayOutputStream var1, int var2, S var3);
    }

    public static interface IDataTransmitter<S> {
        public byte getCommandCode();

        public Supplier<S> getEmptyDataSupplier();

        public Supplier<S> getSourceDataSupplier();

        public S getDiffToTransmit(S var1, S var2);

        public ByteBuffer convertToBinary(byte var1, S var2);
    }
}

