/*
 * Decompiled with CFR 0.152.
 */
package flatgui.core;

import clojure.lang.Keyword;
import clojure.lang.RT;
import clojure.lang.Var;
import flatgui.core.FGClipboardEvent;
import flatgui.core.FGClipboardEventEventParser;
import flatgui.core.FGEvolveInputData;
import flatgui.core.FGEvolveResultData;
import flatgui.core.FGForkModule;
import flatgui.core.FGHostStateEvent;
import flatgui.core.FGInputEventParser;
import flatgui.core.FGKeyEventParser;
import flatgui.core.FGModule;
import flatgui.core.FGMouseEventParser;
import flatgui.core.FGTimerEvent;
import flatgui.core.FGTimerEventParser;
import flatgui.core.IFGContainer;
import flatgui.core.IFGEvolveConsumer;
import flatgui.core.IFGInteropUtil;
import flatgui.core.IFGModule;
import flatgui.core.IFGTemplate;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class FGContainer
implements IFGContainer {
    private static final String REGISTER_FN_NAME = "register-container";
    private static final String UNREGISTER_FN_NAME = "unregister-container";
    private static final String FGC_NS = "flatgui.comlogic";
    private static final String PROPERTY_CHANGED_FN = "property-changed?";
    private static final String GET_CHANGED_PROPERTIES_BY_PATH = "get-changed-properties-by-path";
    private static final Var propetyChanged_ = RT.var((String)"flatgui.comlogic", (String)"property-changed?");
    private static final Var getChangedPropertiesByPath_ = RT.var((String)"flatgui.comlogic", (String)"get-changed-properties-by-path");
    private static final Var clearForks_ = RT.var((String)"flatgui.appcontainer", (String)"app-clear-forks");
    private static final Var useFork_ = RT.var((String)"flatgui.appcontainer", (String)"app-use-fork");
    private final FGInputEventParser reasonParser_;
    private final String containerId_;
    private final IFGModule module_;
    private final Map<Object, IFGModule> forks_;
    private final Map<Object, Future<FGEvolveResultData>> forkResults_;
    private final IFGInteropUtil interopUtil_;
    private boolean active_ = false;
    private ThreadPoolExecutor evolverExecutorService_;
    private ActionListener eventFedCallback_;
    private List<IFGEvolveConsumer> evolveConsumers_;
    private FGMouseEventParser mouseEventParser_;

    public FGContainer(IFGTemplate iFGTemplate, IFGInteropUtil iFGInteropUtil) {
        this(iFGTemplate, iFGTemplate.getContainerVarName(), iFGInteropUtil);
    }

    public FGContainer(IFGTemplate iFGTemplate, String string, IFGInteropUtil iFGInteropUtil) {
        Var var = RT.var((String)iFGTemplate.getContainerNamespace(), (String)iFGTemplate.getContainerVarName());
        Var var2 = RT.var((String)"flatgui.appcontainer", (String)REGISTER_FN_NAME);
        Object object = var.get();
        var2.invoke((Object)string, object, (Object)iFGInteropUtil, (Object)this);
        Keyword keyword = (Keyword)((Map)object).get(Keyword.intern((String)"id"));
        this.containerId_ = string;
        this.module_ = new FGModule(string);
        this.forks_ = new HashMap<Object, IFGModule>();
        this.forkResults_ = new HashMap<Object, Future<FGEvolveResultData>>();
        this.interopUtil_ = iFGInteropUtil;
        this.mouseEventParser_ = new FGMouseEventParser(64);
        this.reasonParser_ = new FGInputEventParser();
        this.reasonParser_.registerReasonClassParser(MouseEvent.class, this.mouseEventParser_);
        this.reasonParser_.registerReasonClassParser(MouseWheelEvent.class, new FGMouseEventParser(64));
        this.reasonParser_.registerReasonClassParser(KeyEvent.class, new FGKeyEventParser());
        this.reasonParser_.registerReasonClassParser(FGClipboardEvent.class, new FGClipboardEventEventParser());
        this.reasonParser_.registerReasonClassParser(FGTimerEvent.class, new FGTimerEventParser());
        this.reasonParser_.registerReasonClassParser(FGHostStateEvent.class, (list, fGHostStateEvent, iFGModule) -> {
            HashMap<FGHostStateEvent, List<Keyword>> hashMap = new HashMap<FGHostStateEvent, List<Keyword>>();
            hashMap.put((FGHostStateEvent)fGHostStateEvent, Arrays.asList(keyword));
            return hashMap;
        });
        this.evolveConsumers_ = new ArrayList<IFGEvolveConsumer>();
    }

    @Override
    public String getId() {
        return this.containerId_;
    }

    @Override
    public void initialize() {
        this.evolverExecutorService_ = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.evolverExecutorService_.submit(() -> this.getFGModule().initInstance());
        this.active_ = true;
    }

    @Override
    public void unInitialize() {
        this.active_ = false;
        this.evolverExecutorService_.shutdown();
        this.mouseEventParser_.clear();
        System.out.println("Unregistering container '" + this.containerId_ + "'");
        Var var = RT.var((String)"flatgui.appcontainer", (String)UNREGISTER_FN_NAME);
        var.invoke((Object)this.containerId_);
    }

    @Override
    public boolean isActive() {
        return this.active_;
    }

    @Override
    public void addEvolveConsumer(IFGEvolveConsumer iFGEvolveConsumer) {
        this.evolveConsumers_.add(iFGEvolveConsumer);
    }

    @Override
    public IFGModule getFGModule() {
        return this.module_;
    }

    @Override
    public IFGModule getForkedFGModule(Object object) {
        return this.forks_.get(object);
    }

    @Override
    public IFGInteropUtil getInterop() {
        return this.interopUtil_;
    }

    @Override
    public Function<FGEvolveInputData, Future<FGEvolveResultData>> connect(ActionListener actionListener, Object object) {
        this.eventFedCallback_ = actionListener;
        return this::feedEvent;
    }

    @Override
    public <T> Future<T> submitTask(Callable<T> callable) {
        return this.evolverExecutorService_.submit(callable);
    }

    @Override
    public List<Keyword> getLastMouseTargetIdPath() {
        return (List)this.mouseEventParser_.getLastTargetIdPath();
    }

    @Override
    public synchronized Future<FGEvolveResultData> feedEvent(FGEvolveInputData fGEvolveInputData) {
        Object object = fGEvolveInputData != null ? fGEvolveInputData.getEvolveReason() : null;
        return this.feedEventImpl(fGEvolveInputData, iFGModule -> FGContainer.cycle(object, this.reasonParser_, iFGModule));
    }

    @Override
    public synchronized Future<FGEvolveResultData> feedTargetedEvent(List<Keyword> list, FGEvolveInputData fGEvolveInputData) {
        Object object = fGEvolveInputData != null ? fGEvolveInputData.getEvolveReason() : null;
        return this.feedEventImpl(fGEvolveInputData, iFGModule -> FGContainer.cycle(list, object, this.reasonParser_, iFGModule));
    }

    @Override
    public Future<FGEvolveResultData> feedTargetedEvent(List<Keyword> list, Object object) {
        return this.feedTargetedEvent(list, new FGEvolveInputData(object, false));
    }

    @Override
    public int getQueueSizeWaiting() {
        return (int)(this.evolverExecutorService_.getTaskCount() - this.evolverExecutorService_.getCompletedTaskCount());
    }

    private Future<FGEvolveResultData> feedEventImpl(FGEvolveInputData fGEvolveInputData, Function<IFGModule, FGEvolveResultData> function) {
        IFGModule iFGModule = this.resolveModuleToWorkOn(fGEvolveInputData);
        Object object = fGEvolveInputData.getEvolveReason();
        boolean bl = false;
        if (!fGEvolveInputData.shouldFork() && this.forks_.containsKey(object)) {
            useFork_.invoke((Object)this.containerId_, object);
            bl = true;
            System.out.println("Hit prediction for " + object);
        }
        if (bl) {
            return null;
        }
        Future<FGEvolveResultData> future = this.evolverExecutorService_.submit(() -> {
            try {
                FGEvolveResultData fGEvolveResultData = (FGEvolveResultData)function.apply(iFGModule);
                if (!fGEvolveInputData.shouldFork()) {
                    this.notifyEvolveConsumers(iFGModule);
                }
                return fGEvolveResultData;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return FGEvolveResultData.EMPTY;
            }
        });
        if (fGEvolveInputData.shouldFork()) {
            this.forkResults_.put(object, future);
        }
        if (!fGEvolveInputData.shouldFork()) {
            clearForks_.invoke((Object)this.containerId_);
            this.forks_.clear();
            this.forkResults_.clear();
        }
        this.eventFedCallback_.actionPerformed(null);
        return future;
    }

    private IFGModule resolveModuleToWorkOn(FGEvolveInputData fGEvolveInputData) {
        if (fGEvolveInputData.shouldFork()) {
            FGForkModule fGForkModule = new FGForkModule(this.containerId_);
            this.forks_.put(fGEvolveInputData.getEvolveReason(), fGForkModule);
            return fGForkModule;
        }
        return this.module_;
    }

    private static FGEvolveResultData cycle(Object object, FGInputEventParser fGInputEventParser, IFGModule iFGModule) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        return FGContainer.cycle(null, object, fGInputEventParser, iFGModule);
    }

    private static FGEvolveResultData cycle(List<Keyword> list, Object object, FGInputEventParser fGInputEventParser, IFGModule iFGModule) {
        Map<Object, List<Keyword>> map;
        try {
            map = fGInputEventParser.getTargetCellIds(list, object, iFGModule);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            map = Collections.emptyMap();
        }
        HashSet<List<Keyword>> hashSet = new HashSet<List<Keyword>>();
        for (Object object2 : map.keySet()) {
            List<Keyword> list2 = map.get(object2);
            if (list2 != null && list2.isEmpty()) continue;
            try {
                iFGModule.evolve(list2, object2);
                Set<List<Keyword>> set = iFGModule.getChangedComponentIdPaths();
                if (set == null) continue;
                hashSet.addAll(set);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return new FGEvolveResultData(map, hashSet);
    }

    private void notifyEvolveConsumers(IFGModule iFGModule) {
        this.evolveConsumers_.stream().filter(iFGEvolveConsumer -> FGContainer.shouldInvokeEvolveConsumer(iFGModule, iFGEvolveConsumer)).forEach(iFGEvolveConsumer -> new Thread(() -> iFGEvolveConsumer.acceptEvolveResult(this.containerId_, iFGModule.getContainer()), "FlatGUI Evolver Consumer Notifier").start());
    }

    private static boolean shouldInvokeEvolveConsumer(IFGModule iFGModule, IFGEvolveConsumer iFGEvolveConsumer) {
        return false;
    }
}

