/*
 * Decompiled with CFR 0.152.
 */
package flatgui.core.websocket;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.json.JSONException;
import org.json.JSONObject;

public class FGPaintVectorBinaryCoder {
    private static int UNIT_SIZE_PX = 64;
    private Map<String, ICommandCoder> cmdNameToCoder_ = new HashMap<String, ICommandCoder>();
    private Map<String, BiFunction<List, Integer, String>> cmdNameToLogger_;

    public FGPaintVectorBinaryCoder() {
        this.registerCoder("setColor", new SetColorCoder());
        this.registerCoder("drawRect", new DrawRectCoder());
        this.registerCoder("fillRect", new FillRectCoder());
        this.registerCoder("drawRoundRect", new DrawRoundRectCoder());
        this.registerCoder("drawOval", new DrawOvalCoder());
        this.registerCoder("fillOval", new FillOvalCoder());
        this.registerCoder("drawString", new DrawStringCoder());
        this.registerCoder("drawLine", new DrawLineCoder());
        this.registerCoder("transform", new TransformCoder());
        this.registerCoder("clipRect", new ClipRectCoder());
        this.registerCoder("setClip", new SetClipCoder());
        this.registerCoder("pushCurrentClip", new PushCurrentClipCoder());
        this.registerCoder("popCurrentClip", new PopCurrentClipCoder());
        this.cmdNameToLogger_ = new HashMap<String, BiFunction<List, Integer, String>>();
        BiFunction<List, Integer, String> biFunction = (list, n) -> {
            try {
                return list.get(0) + " " + new JSONObject().put("x", FGPaintVectorBinaryCoder.getCoord(list, 1)).put("y", FGPaintVectorBinaryCoder.getCoord(list, 2)).put("w", FGPaintVectorBinaryCoder.getCoord(list, 3)).put("h", FGPaintVectorBinaryCoder.getCoord(list, 3)).put("len", n);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
                return "Exception " + jSONException.getMessage();
            }
        };
        BiFunction<List, Integer, String> biFunction2 = (list, n) -> {
            try {
                return list.get(0) + " " + new JSONObject().put("x", 0).put("y", 0).put("w", ((AffineTransform)list.get(1)).getTranslateX()).put("h", ((AffineTransform)list.get(1)).getTranslateY()).put("len", n);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
                return "Exception " + jSONException.getMessage();
            }
        };
        BiFunction<List, Integer, String> biFunction3 = (list, n) -> {
            try {
                return list.get(0) + " " + new JSONObject().put("r", ((Color)list.get(1)).getRed()).put("g", ((Color)list.get(1)).getGreen()).put("b", ((Color)list.get(1)).getBlue()).put("len", n);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
                return "Exception " + jSONException.getMessage();
            }
        };
        BiFunction<List, Integer, String> biFunction4 = (list, n) -> {
            try {
                return list.get(0) + " " + new JSONObject().put("x", FGPaintVectorBinaryCoder.getCoord(list, 2)).put("y", FGPaintVectorBinaryCoder.getCoord(list, 3)).put("s", list.get(1)).put("len", n);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
                return "Exception " + jSONException.getMessage();
            }
        };
        this.cmdNameToLogger_.put("setColor", biFunction3);
        this.cmdNameToLogger_.put("drawRect", biFunction);
        this.cmdNameToLogger_.put("fillRect", biFunction);
        this.cmdNameToLogger_.put("drawOval", biFunction);
        this.cmdNameToLogger_.put("fillOval", biFunction);
        this.cmdNameToLogger_.put("drawString", biFunction4);
        this.cmdNameToLogger_.put("drawLine", biFunction);
        this.cmdNameToLogger_.put("transform", biFunction2);
        this.cmdNameToLogger_.put("clipRect", biFunction);
        this.cmdNameToLogger_.put("setClip", biFunction);
        this.cmdNameToLogger_.put("pushCurrentClip", (list, n) -> (String)list.get(0));
        this.cmdNameToLogger_.put("popCurrentClip", (list, n) -> (String)list.get(0));
    }

    public ByteBuffer codeCommandVector(List<Object> list) {
        int n = 0;
        byte[] byArray = new byte[131072];
        n += this.writeCoded(byArray, n, list);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            ((DeflaterOutputStream)gZIPOutputStream).write(byArray, 0, n);
            gZIPOutputStream.close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return ByteBuffer.wrap(byArray2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return ByteBuffer.wrap(byArray, 0, n);
        }
    }

    public int writeCoded(byte[] byArray, int n, List<Object> list) {
        int n2 = n;
        for (int i = 0; i < list.size(); ++i) {
            List list2 = (List)list.get(i);
            if (list2.get(0) instanceof String) {
                String string = (String)list2.get(0);
                ICommandCoder iCommandCoder = this.cmdNameToCoder_.get(string);
                if (iCommandCoder == null) {
                    throw new IllegalArgumentException("No coder for command: " + string);
                }
                int n3 = iCommandCoder.writeCommand(byArray, n2, list2);
                n2 += n3;
                continue;
            }
            System.out.println("-DLTEMP- FGPaintVectorBinaryCoder.codeCommandVector ERROR: " + list2);
        }
        return n2 - n;
    }

    public void registerCoder(String string, ICommandCoder iCommandCoder) {
        this.cmdNameToCoder_.put(string, iCommandCoder);
    }

    public static int getCoord(List list, int n) {
        return (int)(((Number)list.get(n)).doubleValue() * (double)UNIT_SIZE_PX);
    }

    @Deprecated
    public static class DrawRoundRectCoder
    implements ICommandCoder {
        @Override
        public int writeCommand(byte[] byArray, int n, List list) {
            return 0;
        }
    }

    public static class PopCurrentClipCoder
    implements ICommandCoder {
        @Override
        public int writeCommand(byte[] byArray, int n, List list) {
            byArray[n] = 48;
            return 1;
        }
    }

    public static class PushCurrentClipCoder
    implements ICommandCoder {
        @Override
        public int writeCommand(byte[] byArray, int n, List list) {
            byArray[n] = 16;
            return 1;
        }
    }

    public static class SetClipCoder
    extends RectAreaCoder {
        public SetClipCoder() {
            super(false);
        }

        @Override
        protected byte getOpCode() {
            return 0;
        }
    }

    public static class ClipRectCoder
    extends RectAreaCoder {
        @Override
        protected byte getOpCode() {
            return 7;
        }
    }

    public static class TransformCoder
    extends RectAreaCoder {
        public TransformCoder() {
            super(true, (list, n) -> {
                AffineTransform affineTransform = (AffineTransform)list.get(1);
                return n == 3 ? (int)Math.round(affineTransform.getTranslateX()) : (n == 4 ? (int)Math.round(affineTransform.getTranslateY()) : 0);
            });
        }

        @Override
        public int writeCommand(byte[] byArray, int n, List list) {
            return super.writeCommand(byArray, n, list);
        }

        @Override
        protected byte getOpCode() {
            return 6;
        }
    }

    public static class DrawLineCoder
    extends RectAreaCoder {
        @Override
        protected byte getOpCode() {
            return 5;
        }
    }

    public static class DrawStringCoder
    implements ICommandCoder {
        private BiFunction<List, Integer, Integer> coordProvider_;

        public DrawStringCoder() {
            this(FGPaintVectorBinaryCoder::getCoord);
        }

        public DrawStringCoder(BiFunction<List, Integer, Integer> biFunction) {
            this.coordProvider_ = biFunction;
        }

        @Override
        public int writeCommand(byte[] byArray, int n, List list) {
            int n2 = 0;
            String string = (String)list.get(1);
            byte[] byArray2 = string.getBytes();
            int n3 = this.coordProvider_.apply(list, 2);
            int n4 = this.coordProvider_.apply(list, 3);
            if (byArray2.length <= 15 && n3 <= 63 && n4 <= 63) {
                byArray[n] = (byte)(n2 | 0x70);
                byArray[n + 1] = (byte)((n3 & 0xF) << 4 | byArray2.length);
                byArray[n + 2] = (byte)((n3 & 0x30) << 2 | n4);
                for (int i = 0; i < byArray2.length; ++i) {
                    byArray[n + 3 + i] = byArray2[i];
                }
                return 3 + byArray2.length;
            }
            if (byArray2.length <= 255 && n3 <= 4095 && n4 <= 4095) {
                byArray[n] = (byte)(n2 | 0x50);
                byArray[n + 1] = (byte)byArray2.length;
                byArray[n + 2] = (byte)(n3 & 0xFF);
                byArray[n + 3] = (byte)(n4 & 0xFF);
                byArray[n + 4] = (byte)((n3 & 0xF00) >> 8 | (n4 & 0xF00) >> 4);
                for (int i = 0; i < byArray2.length; ++i) {
                    byArray[n + 5 + i] = byArray2[i];
                }
                return 5 + byArray2.length;
            }
            throw new IllegalStateException("Cannot encode drawString using regular commands. String: " + string + " len=" + byArray2.length + " x=" + n3 + " y=" + n4);
        }
    }

    public static class FillOvalCoder
    extends RectAreaCoder {
        @Override
        protected byte getOpCode() {
            return 4;
        }
    }

    public static class DrawOvalCoder
    extends RectAreaCoder {
        @Override
        protected byte getOpCode() {
            return 3;
        }
    }

    public static class FillRectCoder
    extends RectAreaCoder {
        @Override
        protected byte getOpCode() {
            return 2;
        }
    }

    public static class DrawRectCoder
    extends RectAreaCoder {
        @Override
        protected byte getOpCode() {
            return 1;
        }
    }

    public static abstract class RectAreaCoder
    implements ICommandCoder {
        private PointSubCoder pointSubCoder_;
        private RectSubCoder rectSubCoder_;
        private BiFunction<List, Integer, Integer> coordProvider_;

        public RectAreaCoder() {
            this(true);
        }

        public RectAreaCoder(boolean bl) {
            this(bl, FGPaintVectorBinaryCoder::getCoord);
        }

        public RectAreaCoder(boolean bl, BiFunction<List, Integer, Integer> biFunction) {
            this.pointSubCoder_ = new PointSubCoder(bl);
            this.rectSubCoder_ = new RectSubCoder();
            this.coordProvider_ = biFunction;
        }

        @Override
        public int writeCommand(byte[] byArray, int n, List list) {
            int n2 = this.coordProvider_.apply(list, 1);
            int n3 = this.coordProvider_.apply(list, 2);
            int n4 = this.coordProvider_.apply(list, 3);
            int n5 = this.coordProvider_.apply(list, 4);
            if (n2 == 0 && n3 == 0) {
                int n6 = this.pointSubCoder_.writeBodyWithSubCodeHeader(byArray, n, this.getOpCode(), n4, n5);
                if (n6 >= 0) {
                    return n6;
                }
                return this.rectSubCoder_.writeBodyWithSubCodeHeader(byArray, n, this.getOpCode(), n2, n3, n4, n5);
            }
            return this.rectSubCoder_.writeBodyWithSubCodeHeader(byArray, n, this.getOpCode(), n2, n3, n4, n5);
        }

        protected abstract byte getOpCode();
    }

    public static class RectSubCoder {
        private List<IRectSubCommandBodyCoder> subCommandBodyCoders_ = new ArrayList<IRectSubCommandBodyCoder>();

        private RectSubCoder() {
            this.subCommandBodyCoders_.add(new SubCoderRect63x63());
            this.subCommandBodyCoders_.add(new SubCoderRect255x255());
            this.subCommandBodyCoders_.add(new SubCoderRect1023x1023());
            this.subCommandBodyCoders_.add(new SubCoderRect65535x65535());
        }

        public int writeBodyWithSubCodeHeader(byte[] byArray, int n, byte by, int n2, int n3, int n4, int n5) {
            for (IRectSubCommandBodyCoder iRectSubCommandBodyCoder : this.subCommandBodyCoders_) {
                if (!iRectSubCommandBodyCoder.getRectTester().test(n2, n3, n4, n5)) continue;
                return iRectSubCommandBodyCoder.writeBodyWithSubCodeHeader(byArray, n, by, n2, n3, n4, n5);
            }
            throw new IllegalStateException("Could not encode rect [" + n2 + ";" + n3 + ";" + n4 + ";" + n5 + "], opcode = " + by);
        }
    }

    public static class SubCoderRect65535x65535
    implements IRectSubCommandBodyCoder {
        @Override
        public IRectPredicate getRectTester() {
            return (n, n2, n3, n4) -> n >= Short.MIN_VALUE && n2 >= Short.MIN_VALUE && n3 >= Short.MIN_VALUE && n4 >= Short.MIN_VALUE && n <= Short.MAX_VALUE && n2 <= Short.MAX_VALUE && n3 <= Short.MAX_VALUE && n4 <= Short.MAX_VALUE;
        }

        @Override
        public int writeBodyWithSubCodeHeader(byte[] byArray, int n, byte by, int n2, int n3, int n4, int n5) {
            byArray[n] = (byte)(0xF8 | by);
            byArray[n + 1] = (byte)n2;
            byArray[n + 2] = (byte)(n2 >> 8);
            byArray[n + 3] = (byte)n3;
            byArray[n + 4] = (byte)(n3 >> 8);
            byArray[n + 5] = (byte)n4;
            byArray[n + 6] = (byte)(n4 >> 8);
            byArray[n + 7] = (byte)n5;
            byArray[n + 8] = (byte)(n5 >> 8);
            return 9;
        }
    }

    public static class SubCoderRect1023x1023
    implements IRectSubCommandBodyCoder {
        @Override
        public IRectPredicate getRectTester() {
            return (n, n2, n3, n4) -> n >= 0 && n2 >= 0 && n3 >= 0 && n4 >= 0 && n <= 1023 && n2 <= 1023 && n3 <= 1023 && n4 <= 1023;
        }

        @Override
        public int writeBodyWithSubCodeHeader(byte[] byArray, int n, byte by, int n2, int n3, int n4, int n5) {
            byArray[n] = (byte)(0xB8 | by);
            byArray[n + 1] = (byte)n2;
            byArray[n + 2] = (byte)n3;
            byArray[n + 3] = (byte)n4;
            byArray[n + 4] = (byte)n5;
            byArray[n + 5] = (byte)((n2 & 0x300) >> 8 | (n3 & 0x300) >> 6 | (n4 & 0x300) >> 4 | (n5 & 0x300) >> 2);
            return 6;
        }
    }

    public static class SubCoderRect255x255
    implements IRectSubCommandBodyCoder {
        @Override
        public IRectPredicate getRectTester() {
            return (n, n2, n3, n4) -> n >= 0 && n2 >= 0 && n3 >= 0 && n4 >= 0 && n <= 255 && n2 <= 255 && n3 <= 255 && n4 <= 255;
        }

        @Override
        public int writeBodyWithSubCodeHeader(byte[] byArray, int n, byte by, int n2, int n3, int n4, int n5) {
            byArray[n] = (byte)(0x78 | by);
            byArray[n + 1] = (byte)n2;
            byArray[n + 2] = (byte)n3;
            byArray[n + 3] = (byte)n4;
            byArray[n + 4] = (byte)n5;
            return 5;
        }
    }

    public static class SubCoderRect63x63
    implements IRectSubCommandBodyCoder {
        @Override
        public IRectPredicate getRectTester() {
            return (n, n2, n3, n4) -> n >= 0 && n2 >= 0 && n3 >= 0 && n4 >= 0 && n <= 63 && n2 <= 63 && n3 <= 63 && n4 <= 63;
        }

        @Override
        public int writeBodyWithSubCodeHeader(byte[] byArray, int n, byte by, int n2, int n3, int n4, int n5) {
            byArray[n] = (byte)(0x38 | by);
            byArray[n + 1] = (byte)(n2 & 0xF | (n3 & 0xF) << 4);
            byArray[n + 2] = (byte)(n4 & 0xF | (n5 & 0xF) << 4);
            byArray[n + 3] = (byte)((n2 & 0x30) >> 4 | (n3 & 0x30) >> 2 | n4 & 0x30 | (n5 & 0x30) << 2);
            return 4;
        }
    }

    public static class PointSubCoder {
        private List<IPointSubCommandBodyCoder> subCommandBodyCoders_ = new ArrayList<IPointSubCommandBodyCoder>();

        private PointSubCoder(boolean bl) {
            if (bl) {
                this.subCommandBodyCoders_.add(new SubCoderPoint127x31());
            }
            this.subCommandBodyCoders_.add(new SubCoderPoint511x511());
            this.subCommandBodyCoders_.add(new SubCoderPoint1023x255());
            this.subCommandBodyCoders_.add(new SubCoderPoint255x1023());
        }

        public int writeBodyWithSubCodeHeader(byte[] byArray, int n, byte by, int n2, int n3) {
            for (IPointSubCommandBodyCoder iPointSubCommandBodyCoder : this.subCommandBodyCoders_) {
                if (!iPointSubCommandBodyCoder.getPointTester().test(n2, n3)) continue;
                return iPointSubCommandBodyCoder.writeBodyWithSubCodeHeader(byArray, n, by, n2, n3);
            }
            return -1;
        }
    }

    public static class SubCoderPoint255x1023
    implements IPointSubCommandBodyCoder {
        @Override
        public IPointPredicate getPointTester() {
            return (n, n2) -> n >= 0 && n2 >= 0 && n <= 255 && n2 <= 1023;
        }

        @Override
        public int writeBodyWithSubCodeHeader(byte[] byArray, int n, byte by, int n2, int n3) {
            byte by2 = (byte)((n3 & 0x300) >> 2);
            byArray[n] = (byte)(by2 | 0x28 | by);
            byArray[n + 1] = (byte)n2;
            byArray[n + 2] = (byte)n3;
            return 3;
        }
    }

    public static class SubCoderPoint1023x255
    implements IPointSubCommandBodyCoder {
        @Override
        public IPointPredicate getPointTester() {
            return (n, n2) -> n >= 0 && n2 >= 0 && n <= 1023 && n2 <= 255;
        }

        @Override
        public int writeBodyWithSubCodeHeader(byte[] byArray, int n, byte by, int n2, int n3) {
            byte by2 = (byte)((n2 & 0x300) >> 2);
            byArray[n] = (byte)(by2 | 0x18 | by);
            byArray[n + 1] = (byte)n2;
            byArray[n + 2] = (byte)n3;
            return 3;
        }
    }

    public static class SubCoderPoint511x511
    implements IPointSubCommandBodyCoder {
        @Override
        public IPointPredicate getPointTester() {
            return (n, n2) -> n >= 0 && n2 >= 0 && n <= 511 && n2 <= 511;
        }

        @Override
        public int writeBodyWithSubCodeHeader(byte[] byArray, int n, byte by, int n2, int n3) {
            byte by2 = (byte)((n2 & 0x100) >> 1);
            byte by3 = (byte)((n3 & 0x100) >> 2);
            byArray[n] = (byte)(by2 | by3 | 8 | by);
            byArray[n + 1] = (byte)n2;
            byArray[n + 2] = (byte)n3;
            return 3;
        }
    }

    public static class SubCoderPoint127x31
    implements IPointSubCommandBodyCoder {
        @Override
        public IPointPredicate getPointTester() {
            return (n, n2) -> n >= 0 && n2 >= 0 && n <= 127 && n2 <= 31;
        }

        @Override
        public int writeBodyWithSubCodeHeader(byte[] byArray, int n, byte by, int n2, int n3) {
            byte by2 = (byte)((n2 & 0x70) << 1);
            byte by3 = (byte)(n3 & 0x10);
            byArray[n] = (byte)(by | by2 | by3);
            byte by4 = (byte)((n2 & 0xF) << 4);
            byte by5 = (byte)(n3 & 0xF);
            byArray[n + 1] = (byte)(by4 | by5);
            return 2;
        }
    }

    public static interface IRectSubCommandBodyCoder {
        public IRectPredicate getRectTester();

        public int writeBodyWithSubCodeHeader(byte[] var1, int var2, byte var3, int var4, int var5, int var6, int var7);
    }

    public static interface IPointSubCommandBodyCoder {
        public IPointPredicate getPointTester();

        public int writeBodyWithSubCodeHeader(byte[] var1, int var2, byte var3, int var4, int var5);
    }

    @FunctionalInterface
    public static interface IRectPredicate {
        public boolean test(int var1, int var2, int var3, int var4);
    }

    @FunctionalInterface
    public static interface IPointPredicate {
        public boolean test(int var1, int var2);
    }

    public static class SetColorCoder
    implements ICommandCoder {
        @Override
        public int writeCommand(byte[] byArray, int n, List list) {
            int n2 = ((Color)list.get(1)).getRed();
            int n3 = ((Color)list.get(1)).getGreen();
            int n4 = ((Color)list.get(1)).getBlue();
            byte by = (byte)n2;
            byte by2 = (byte)n3;
            byte by3 = (byte)n4;
            if (n2 == n3 && n3 == n4) {
                byArray[n] = 64;
                byArray[n + 1] = by;
                return 2;
            }
            return this.writeRegularFormat(byArray, n, by, by2, by3);
        }

        private int writeRegularFormat(byte[] byArray, int n, byte by, byte by2, byte by3) {
            byArray[n] = -128;
            byArray[n + 1] = by;
            byArray[n + 2] = by2;
            byArray[n + 3] = by3;
            return 4;
        }
    }

    public static interface ICommandCoder {
        public int writeCommand(byte[] var1, int var2, List var3);
    }
}

