/*
 * Decompiled with CFR 0.152.
 */
package flatgui.core.websocket;

import flatgui.core.FGWebContainerWrapper;
import flatgui.core.IFGContainer;
import flatgui.core.websocket.FGAppServer;
import flatgui.core.websocket.FGInputEventDecoder;
import flatgui.core.websocket.FGPaintVectorBinaryCoder;
import java.util.concurrent.atomic.LongAccumulator;

public class FGContainerSession {
    private static final long IDLE_MARKER = -1L;
    private final Object sessionId_;
    private final FGWebContainerWrapper containerWrapper_;
    private final FGInputEventDecoder parser_;
    private final FGPaintVectorBinaryCoder binaryCoder_;
    private final LongAccumulator lastAccessTime_;

    public FGContainerSession(IFGContainer iFGContainer) {
        this.sessionId_ = iFGContainer.getId();
        this.containerWrapper_ = new FGWebContainerWrapper(iFGContainer);
        this.containerWrapper_.initialize();
        this.parser_ = new FGInputEventDecoder();
        this.binaryCoder_ = new FGPaintVectorBinaryCoder();
        this.lastAccessTime_ = new LongAccumulator((l, l2) -> l2, 0L);
    }

    public FGWebContainerWrapper getContainer() {
        return this.containerWrapper_;
    }

    public FGInputEventDecoder getParser() {
        return this.parser_;
    }

    public FGPaintVectorBinaryCoder getBinaryCoder() {
        return this.binaryCoder_;
    }

    public void markIdle() {
        FGAppServer.getFGLogger().info(this.toString() + " has been marked as idle.");
        this.lastAccessTime_.accumulate(-1L);
    }

    public void markAccesed() {
        if (this.isMarkedIdle()) {
            FGAppServer.getFGLogger().info(this.toString() + " has been restored from idle state due to new activity.");
        }
        this.lastAccessTime_.accumulate(System.currentTimeMillis());
    }

    public boolean isIdle(long l) {
        boolean bl;
        boolean bl2 = bl = this.isMarkedIdle() || this.lastAccessTime_.get() + l < System.currentTimeMillis();
        if (bl) {
            if (!this.isMarkedIdle()) {
                FGAppServer.getFGLogger().info(this.toString() + " has been detected idle for more than " + l + " millis.");
            }
            this.markIdle();
        }
        return bl;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.sessionId_ + "]";
    }

    private boolean isMarkedIdle() {
        return this.lastAccessTime_.get() == -1L;
    }
}

