/*
 * Decompiled with CFR 0.152.
 */
package flatgui.core.websocket;

import flatgui.core.FGLogger;
import flatgui.core.IFGTemplate;
import flatgui.core.websocket.FGContainerSessionHolder;
import flatgui.core.websocket.FGContainerWebSocket;
import flatgui.core.websocket.FGSessionContainerHost;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;

public class FGAppServer {
    private static FGLogger logger_ = new FGLogger();
    private final IFGTemplate template_;
    private Server server_;

    public FGAppServer(IFGTemplate iFGTemplate, int n) throws Exception {
        this.template_ = iFGTemplate;
        this.server_ = new Server(n);
        ServletHandler servletHandler = new ServletHandler();
        this.server_.setHandler((Handler)servletHandler);
        ServletHolder servletHolder = new ServletHolder((Servlet)new FGWebSocketServlet(this.template_));
        servletHandler.addServletWithMapping(servletHolder, "/*");
    }

    public void start() throws Exception {
        this.server_.start();
    }

    public void join() throws Exception {
        this.server_.join();
    }

    static FGLogger getFGLogger() {
        return logger_;
    }

    private static class FGWebSocketServlet
    extends WebSocketServlet {
        private final IFGTemplate template_;
        private final FGContainerSessionHolder sessionHolder_;

        FGWebSocketServlet(IFGTemplate iFGTemplate) {
            this.template_ = iFGTemplate;
            this.sessionHolder_ = new FGContainerSessionHolder(new FGSessionContainerHost());
        }

        public void configure(WebSocketServletFactory webSocketServletFactory) {
            webSocketServletFactory.getPolicy().setIdleTimeout(86400000L);
            webSocketServletFactory.setCreator(this::createWebSocket);
        }

        private Object createWebSocket(ServletUpgradeRequest servletUpgradeRequest, ServletUpgradeResponse servletUpgradeResponse) {
            return new FGContainerWebSocket(this.template_, this.sessionHolder_);
        }
    }
}

