/*
 * Decompiled with CFR 0.152.
 */
package flatgui.core.awt;

import flatgui.core.IFGContainer;
import flatgui.core.awt.FGDefaultPrimitivePainter;
import flatgui.core.awt.IFGPrimitivePainter;
import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Consumer;

public class HostComponent
extends Canvas {
    private IFGContainer fgContainer_;
    private IFGPrimitivePainter primitivePainter_;
    private Image bufferImage_;
    private boolean appTriggered_ = false;

    public HostComponent(IFGContainer iFGContainer) {
        this.setFocusTraversalKeysEnabled(false);
        this.fgContainer_ = iFGContainer;
        this.primitivePainter_ = new FGDefaultPrimitivePainter(64.0);
        this.setFocusable(true);
    }

    public ActionListener getEventFedCallback() {
        return actionEvent -> this.repaint();
    }

    public void setInputEventConsumer(Consumer<Object> consumer) {
        this.addMouseListener(new ContainerMouseListener(consumer));
        this.addMouseMotionListener(new ContainerMouseMotionListener(consumer));
        this.addMouseWheelListener(new ContainerMouseWheelListener(consumer));
        this.addKeyListener(new ContainerKeyListener(consumer));
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.appTriggered_) {
            graphics.drawImage(this.getPendingImage(), 0, 0, null);
        } else {
            graphics.drawImage(this.getPendingImage(), 0, 0, null);
        }
        this.appTriggered_ = false;
    }

    @Override
    public void update(Graphics graphics) {
        try {
            Rectangle rectangle = graphics.getClipBounds();
            double d = rectangle.getX() / 64.0;
            double d2 = rectangle.getY() / 64.0;
            double d3 = rectangle.getWidth() / 64.0;
            double d4 = rectangle.getHeight() / 64.0;
            Future<List> future = this.fgContainer_.submitTask(() -> this.fgContainer_.getFGModule().getPaintAllSequence(d, d2, d3, d4));
            Graphics graphics2 = this.getBufferGraphics();
            ((Graphics2D)graphics2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            List list = future.get();
            this.paintSequence(graphics2, list);
            this.appTriggered_ = true;
            this.paint(graphics);
        }
        catch (InterruptedException | ExecutionException exception) {
            exception.printStackTrace();
        }
    }

    Image getPendingImage() {
        return this.bufferImage_;
    }

    private Graphics getBufferGraphics() {
        if (this.bufferImage_ == null) {
            this.bufferImage_ = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        }
        return this.bufferImage_.getGraphics();
    }

    private int paintSequence(Graphics graphics, List<Object> list) {
        int n = 0;
        for (Object object : list) {
            if (object instanceof List) {
                this.primitivePainter_.paintPrimitive(graphics, (List)object);
                ++n;
                continue;
            }
            if (object == null) continue;
            System.out.println("Error: not a list: " + list);
        }
        return n;
    }

    private static class ContainerKeyListener
    extends ContainerListener
    implements KeyListener {
        ContainerKeyListener(Consumer<Object> consumer) {
            super(consumer);
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            this.eventImpl(keyEvent);
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            this.eventImpl(keyEvent);
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            this.eventImpl(keyEvent);
        }
    }

    private static class ContainerMouseWheelListener
    extends ContainerListener
    implements MouseWheelListener {
        ContainerMouseWheelListener(Consumer<Object> consumer) {
            super(consumer);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            this.eventImpl(mouseWheelEvent);
        }
    }

    private static class ContainerMouseMotionListener
    extends ContainerListener
    implements MouseMotionListener {
        ContainerMouseMotionListener(Consumer<Object> consumer) {
            super(consumer);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.eventImpl(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.eventImpl(mouseEvent);
        }
    }

    private static class ContainerMouseListener
    extends ContainerListener
    implements MouseListener {
        ContainerMouseListener(Consumer<Object> consumer) {
            super(consumer);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.eventImpl(mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.eventImpl(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.eventImpl(mouseEvent);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.eventImpl(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.eventImpl(mouseEvent);
        }
    }

    private static class ContainerListener {
        private final Consumer<Object> eventConsumer_;

        ContainerListener(Consumer<Object> consumer) {
            this.eventConsumer_ = consumer;
        }

        protected final void eventImpl(Object object) {
            this.eventConsumer_.accept(object);
        }
    }
}

