/*
 * Decompiled with CFR 0.152.
 */
package flatgui.core.awt;

import flatgui.core.IFGInteropUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class FGAWTInteropUtil
implements IFGInteropUtil {
    private final Component hostComponent_;
    private final Font font_;
    private final double unitSizePx_;

    public FGAWTInteropUtil(Component component, int n) {
        this.hostComponent_ = component;
        this.font_ = UIManager.getFont("Label.font");
        this.unitSizePx_ = n;
    }

    @Override
    public double getStringWidth(String string) {
        return this.getStringWidth(string, this.font_);
    }

    @Override
    public double getStringWidth(String string, Font font) {
        if (font == null) {
            throw new NullPointerException("Font is null");
        }
        double d = SwingUtilities.computeStringWidth(this.hostComponent_.getFontMetrics(font), string);
        return d / this.unitSizePx_;
    }

    @Override
    public double getFontAscent() {
        return this.getFontAscent(this.font_);
    }

    @Override
    public double getFontAscent(Font font) {
        Component component = this.hostComponent_;
        FontMetrics fontMetrics = component.getFontMetrics(font);
        double d = fontMetrics.getAscent();
        return 0.75 * d / this.unitSizePx_;
    }
}

