/*
 * Decompiled with CFR 0.152.
 */
package flatgui.core;

import flatgui.core.IFGContainer;
import flatgui.core.IFGModule;
import flatgui.core.websocket.FGPaintVectorBinaryCoder;
import java.awt.geom.AffineTransform;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class FGWebContainerWrapper {
    public static final byte POSITION_MATRIX_MAP_COMMAND_CODE = 0;
    public static final byte VIEWPORT_MATRIX_MAP_COMMAND_CODE = 1;
    public static final byte CLIP_SIZE_MAP_COMMAND_CODE = 2;
    public static final byte LOOK_VECTOR_MAP_COMMAND_CODE = 3;
    public static final byte CHILD_COUNT_MAP_COMMAND_CODE = 4;
    public static final byte BOOLEAN_STATE_FLAGS_COMMAND_CODE = 5;
    public static final byte PAINT_ALL_LIST_COMMAND_CODE = 6;
    public static final byte REPAINT_CACHED_COMMAND_CODE = 7;
    private static Set<String> RECT_COMMANDS = new HashSet<String>();
    private final FGContainerStateTransmitter stateTransmitter_;
    private final IFGContainer fgContainer_;
    private Consumer<Object> eventConsumer_;

    public FGWebContainerWrapper(IFGContainer iFGContainer) {
        this.fgContainer_ = iFGContainer;
        this.eventConsumer_ = this.fgContainer_.connect(actionEvent -> {}, this);
        this.stateTransmitter_ = new FGContainerStateTransmitter(this.fgContainer_.getFGModule());
    }

    public IFGContainer getContainer() {
        return this.fgContainer_;
    }

    public void initialize() {
        this.fgContainer_.initialize();
    }

    public void unInitialize() {
        this.fgContainer_.unInitialize();
    }

    public synchronized void feedEvent(Object object) {
        this.eventConsumer_.accept(object);
    }

    public synchronized Collection<ByteBuffer> getResponseForClient() {
        Future<Collection> future = this.fgContainer_.submitTask(() -> this.stateTransmitter_.computeDataDiffsToTransmit());
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            exception.printStackTrace();
            return Collections.emptyList();
        }
    }

    public synchronized void resetCache() {
        this.stateTransmitter_.resetDataCache();
    }

    private List<Object> compressPaintVector(List<Object> list) {
        list = list.stream().filter(object -> {
            Object e = ((List)object).get(0);
            if (RECT_COMMANDS.contains(e)) {
                double d = FGWebContainerWrapper.getCoord((List)object, 1);
                double d2 = FGWebContainerWrapper.getCoord((List)object, 2);
                double d3 = FGWebContainerWrapper.getCoord((List)object, 3);
                double d4 = FGWebContainerWrapper.getCoord((List)object, 4);
                if (d == 0.0 && d2 == 0.0 && d3 == 0.0 && d4 == 0.0) {
                    return false;
                }
            }
            return true;
        }).collect(Collectors.toList());
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            ArrayList arrayList2 = new ArrayList((List)list.get(n2));
            String string = (String)arrayList2.get(0);
            if (n2 < n - 1) {
                if (FGWebContainerWrapper.getCommand(list, n2).equals("transform")) {
                    int n3;
                    double d = ((AffineTransform)arrayList2.get(1)).getTranslateX();
                    double d2 = ((AffineTransform)arrayList2.get(1)).getTranslateY();
                    boolean bl = false;
                    for (n3 = n2 + 1; n3 < n && FGWebContainerWrapper.getCommand(list, n3).equals("transform"); ++n3) {
                        ArrayList arrayList3 = new ArrayList((List)list.get(n3));
                        d += ((AffineTransform)arrayList3.get(1)).getTranslateX();
                        d2 += ((AffineTransform)arrayList3.get(1)).getTranslateY();
                        bl = true;
                    }
                    if (bl) {
                        arrayList.add(Arrays.asList("transform", AffineTransform.getTranslateInstance(d, d2)));
                        n2 = n3;
                        continue;
                    }
                    arrayList.add(arrayList2);
                    ++n2;
                    continue;
                }
                arrayList.add(arrayList2);
                ++n2;
                continue;
            }
            arrayList.add(arrayList2);
            ++n2;
        }
        return arrayList;
    }

    private static String getCommand(List<Object> list, int n) {
        ArrayList arrayList = new ArrayList((List)list.get(n));
        return (String)arrayList.get(0);
    }

    private static double getCoord(List list, int n) {
        return ((Number)list.get(n)).doubleValue();
    }

    private List<Object> compressPaintVector2(List<Object> list) {
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            ArrayList<Double> arrayList2 = new ArrayList<Double>((List)list.get(i));
            String string = (String)arrayList2.get(0);
            if (string.equals("transform")) {
                d += ((AffineTransform)arrayList2.get(1)).getTranslateX();
                d2 += ((AffineTransform)arrayList2.get(1)).getTranslateY();
                continue;
            }
            double d3 = d / 64.0;
            double d4 = d2 / 64.0;
            switch (string) {
                case "drawString": {
                    double d5 = ((Number)arrayList2.get(2)).doubleValue();
                    double d6 = ((Number)arrayList2.get(3)).doubleValue();
                    arrayList2.set(2, d5 + d3);
                    arrayList2.set(3, d6 + d4);
                    break;
                }
                case "drawLine": {
                    double d5 = ((Number)arrayList2.get(1)).doubleValue();
                    double d6 = ((Number)arrayList2.get(2)).doubleValue();
                    arrayList2.set(1, d5 + d3);
                    arrayList2.set(2, d6 + d4);
                    double d7 = ((Number)arrayList2.get(3)).doubleValue();
                    double d8 = ((Number)arrayList2.get(4)).doubleValue();
                    arrayList2.set(3, d7 + d3);
                    arrayList2.set(4, d8 + d4);
                    break;
                }
                case "drawRect": 
                case "fillRect": 
                case "drawOval": 
                case "fillOval": 
                case "clipRect": 
                case "setClip": {
                    double d5 = ((Number)arrayList2.get(1)).doubleValue();
                    double d6 = ((Number)arrayList2.get(2)).doubleValue();
                    arrayList2.set(1, d5 + d3);
                    arrayList2.set(2, d6 + d4);
                }
            }
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    private static boolean eq(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    static {
        RECT_COMMANDS.add("drawLine");
        RECT_COMMANDS.add("drawRect");
        RECT_COMMANDS.add("fillRect");
        RECT_COMMANDS.add("drawOval");
        RECT_COMMANDS.add("fillOval");
        RECT_COMMANDS.add("clipRect");
        RECT_COMMANDS.add("setClip");
    }

    static class FGContainerStateTransmitter {
        private static BinaryOperator THROWING_MERGER = (object, object2) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", object));
        };
        private IKeyCache keyCache_ = new KeyCahe();
        private Map<Byte, ?> cmdToLastData_;
        private Map<Byte, IDataTransmitter<Object>> cmdToDataTransmitter_ = new LinkedHashMap<Byte, IDataTransmitter<Object>>();

        public FGContainerStateTransmitter(IFGModule iFGModule) {
            this.addDataTransmitter(new PositionMatrixMapTrasmitter(this.keyCache_, () -> iFGModule.getComponentIdPathToPositionMatrix()));
            this.addDataTransmitter(new ViewportMatrixMapTrasmitter(this.keyCache_, () -> iFGModule.getComponentIdPathToViewportMatrix()));
            this.addDataTransmitter(new ClipRectTransmitter(this.keyCache_, () -> iFGModule.getComponentIdPathToClipRect()));
            this.addDataTransmitter(new LookVectorTransmitter(this.keyCache_, () -> iFGModule.getComponentIdPathToLookVector()));
            this.addDataTransmitter(new ChildCountMapTransmitter(this.keyCache_, () -> iFGModule.getComponentIdPathToChildCount()));
            this.addDataTransmitter(new BooleanFlagsMapTransmitter(this.keyCache_, () -> iFGModule.getComponentIdPathToBooleanStateFlags()));
            this.addDataTransmitter(new PaintAllTransmitter(this.keyCache_, () -> iFGModule.getPaintAllSequence2()));
            this.resetDataCache();
        }

        public Collection<ByteBuffer> computeDataDiffsToTransmit() {
            Map map = this.cmdToDataTransmitter_.entrySet().stream().collect(Collectors.toMap(entry -> (Byte)entry.getKey(), entry -> {
                Object s = ((IDataTransmitter)entry.getValue()).getSourceDataSupplier().get();
                if (s == null) {
                    System.out.println("-DLTEMP- FGContainerStateTransmitter.computeDataDiffsToTransmit null source data for cmd " + entry.getKey());
                }
                return s;
            }, THROWING_MERGER, LinkedHashMap::new));
            Collection collection = map.entrySet().stream().map(entry -> {
                IDataTransmitter<Object> iDataTransmitter = this.cmdToDataTransmitter_.get(entry.getKey());
                Object object = iDataTransmitter.getDiffToTransmit(this.cmdToLastData_.get(entry.getKey()), entry.getValue());
                return object != null ? iDataTransmitter.convertToBinary((Byte)entry.getKey(), object) : null;
            }).filter(byteBuffer -> byteBuffer != null).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
            this.cmdToLastData_ = map;
            return collection;
        }

        public void resetDataCache() {
            this.cmdToLastData_ = this.cmdToDataTransmitter_.entrySet().stream().collect(Collectors.toMap(entry -> (Byte)entry.getKey(), entry -> ((IDataTransmitter)entry.getValue()).getEmptyDataSupplier().get()));
        }

        private void addDataTransmitter(IDataTransmitter<?> iDataTransmitter) {
            this.cmdToDataTransmitter_.put(iDataTransmitter.getCommandCode(), iDataTransmitter);
        }
    }

    static class KeyCahe
    implements IKeyCache {
        private int uid_ = 0;
        private Map<Object, Integer> cache_ = new HashMap<Object, Integer>();

        KeyCahe() {
        }

        @Override
        public int getUniqueId(Object object) {
            Integer n = this.cache_.get(object);
            if (n == null) {
                n = this.uid_;
                this.cache_.put(object, n);
                ++this.uid_;
            }
            return n;
        }
    }

    static class PaintAllTransmitter
    extends KeyListTransmitter {
        public PaintAllTransmitter(IKeyCache iKeyCache, Supplier<List<Object>> supplier) {
            super(iKeyCache, supplier);
        }

        @Override
        public byte getCommandCode() {
            return 6;
        }
    }

    static abstract class KeyListTransmitter
    extends ListTransmitter<Object> {
        private IKeyCache keyCache_;

        public KeyListTransmitter(IKeyCache iKeyCache, Supplier<List<Object>> supplier) {
            super(supplier);
            this.keyCache_ = iKeyCache;
        }

        @Override
        protected int writeValue(ByteArrayOutputStream byteArrayOutputStream, int n, Object object) {
            int n2 = this.keyCache_.getUniqueId(object);
            byteArrayOutputStream.write((byte)(n2 & 0xFF));
            byteArrayOutputStream.write((byte)(n2 >> 8 & 0xFF));
            return 2;
        }
    }

    static abstract class ListTransmitter<V>
    extends AbstractTransmitter<List<Object>> {
        private Supplier<List<Object>> sourceListSupplier_;

        ListTransmitter(Supplier<List<Object>> supplier) {
            this.sourceListSupplier_ = supplier;
        }

        @Override
        public List<Object> getDiffToTransmit(List<Object> list, List<Object> list2) {
            return list2.isEmpty() || list2.equals(list) ? null : list2;
        }

        @Override
        public int writeBinary(ByteArrayOutputStream byteArrayOutputStream, int n, List<Object> list) {
            for (Object object : list) {
                int n2 = this.writeValue(byteArrayOutputStream, n, object);
                n += n2;
            }
            return n;
        }

        @Override
        public Supplier<List<Object>> getEmptyDataSupplier() {
            return ArrayList::new;
        }

        @Override
        public Supplier<List<Object>> getSourceDataSupplier() {
            return this.sourceListSupplier_;
        }

        protected abstract int writeValue(ByteArrayOutputStream var1, int var2, V var3);
    }

    static class LookVectorTransmitter
    extends MapTransmitter<List<Object>> {
        private FGPaintVectorBinaryCoder coder_ = new FGPaintVectorBinaryCoder();

        public LookVectorTransmitter(IKeyCache iKeyCache, Supplier<Map<Object, Object>> supplier) {
            super(iKeyCache, supplier);
        }

        @Override
        protected int writeValue(ByteArrayOutputStream byteArrayOutputStream, int n, List<Object> list) {
            byte[] byArray = new byte[131072];
            int n2 = this.coder_.writeCoded(byArray, 0, list);
            byteArrayOutputStream.write((byte)(n2 & 0xFF));
            byteArrayOutputStream.write((byte)(n2 >> 8 & 0xFF));
            byteArrayOutputStream.write(byArray, 0, n2);
            return n2 + 2;
        }

        @Override
        public byte getCommandCode() {
            return 3;
        }
    }

    static class ClipRectTransmitter
    extends MapTransmitter<List<Number>> {
        public ClipRectTransmitter(IKeyCache iKeyCache, Supplier<Map<Object, Object>> supplier) {
            super(iKeyCache, supplier);
        }

        @Override
        protected int writeValue(ByteArrayOutputStream byteArrayOutputStream, int n, List<Number> list) {
            int n2 = (int)(list.get(0).doubleValue() * 64.0);
            int n3 = (int)(list.get(1).doubleValue() * 64.0);
            byteArrayOutputStream.write((byte)(n2 & 0xFF));
            byteArrayOutputStream.write((byte)(n3 & 0xFF));
            byteArrayOutputStream.write((byte)(n2 >> 8 & 0xF | n3 >> 4 & 0xF0));
            return 3;
        }

        @Override
        public byte getCommandCode() {
            return 2;
        }
    }

    static class BooleanFlagsMapTransmitter
    extends ByteMapTrasmitter {
        public BooleanFlagsMapTransmitter(IKeyCache iKeyCache, Supplier<Map<Object, Object>> supplier) {
            super(iKeyCache, supplier);
        }

        @Override
        public byte getCommandCode() {
            return 5;
        }
    }

    static class ChildCountMapTransmitter
    extends ShortMapTrasmitter {
        public ChildCountMapTransmitter(IKeyCache iKeyCache, Supplier<Map<Object, Object>> supplier) {
            super(iKeyCache, supplier);
        }

        @Override
        public byte getCommandCode() {
            return 4;
        }
    }

    static abstract class ByteMapTrasmitter
    extends MapTransmitter<Number> {
        public ByteMapTrasmitter(IKeyCache iKeyCache, Supplier<Map<Object, Object>> supplier) {
            super(iKeyCache, supplier);
        }

        @Override
        protected int writeValue(ByteArrayOutputStream byteArrayOutputStream, int n, Number number) {
            byte by = number.byteValue();
            byteArrayOutputStream.write(by);
            return 1;
        }
    }

    static abstract class ShortMapTrasmitter
    extends MapTransmitter<Number> {
        public ShortMapTrasmitter(IKeyCache iKeyCache, Supplier<Map<Object, Object>> supplier) {
            super(iKeyCache, supplier);
        }

        @Override
        protected int writeValue(ByteArrayOutputStream byteArrayOutputStream, int n, Number number) {
            short s = number.shortValue();
            byteArrayOutputStream.write((byte)(s & 0xFF));
            byteArrayOutputStream.write((byte)(s >> 8 & 0xFF));
            return 2;
        }
    }

    static class ViewportMatrixMapTrasmitter
    extends TransformMatrixMapTransmitter {
        ViewportMatrixMapTrasmitter(IKeyCache iKeyCache, Supplier<Map<Object, Object>> supplier) {
            super(iKeyCache, supplier);
        }

        @Override
        protected int getTranslateX(AffineTransform affineTransform) {
            return -((int)affineTransform.getTranslateX());
        }

        @Override
        protected int getTranslateY(AffineTransform affineTransform) {
            return -((int)affineTransform.getTranslateY());
        }

        @Override
        public byte getCommandCode() {
            return 1;
        }
    }

    static class PositionMatrixMapTrasmitter
    extends TransformMatrixMapTransmitter {
        PositionMatrixMapTrasmitter(IKeyCache iKeyCache, Supplier<Map<Object, Object>> supplier) {
            super(iKeyCache, supplier);
        }

        @Override
        protected int getTranslateX(AffineTransform affineTransform) {
            return (int)affineTransform.getTranslateX();
        }

        @Override
        protected int getTranslateY(AffineTransform affineTransform) {
            return (int)affineTransform.getTranslateY();
        }

        @Override
        public byte getCommandCode() {
            return 0;
        }
    }

    static abstract class TransformMatrixMapTransmitter
    extends MapTransmitter<AffineTransform> {
        TransformMatrixMapTransmitter(IKeyCache iKeyCache, Supplier<Map<Object, Object>> supplier) {
            super(iKeyCache, supplier);
        }

        @Override
        protected int writeValue(ByteArrayOutputStream byteArrayOutputStream, int n, AffineTransform affineTransform) {
            int n2 = this.getTranslateX(affineTransform);
            int n3 = this.getTranslateY(affineTransform);
            byteArrayOutputStream.write((byte)(n2 & 0xFF));
            byteArrayOutputStream.write((byte)(n3 & 0xFF));
            byteArrayOutputStream.write((byte)(n2 >> 8 & 0xF | n3 >> 4 & 0xF0));
            return 3;
        }

        protected abstract int getTranslateX(AffineTransform var1);

        protected abstract int getTranslateY(AffineTransform var1);
    }

    static abstract class MapTransmitter<V>
    extends AbstractTransmitter<Map<Object, Object>> {
        private IKeyCache keyCache_;
        private Supplier<Map<Object, Object>> sourceMapSupplier_;

        public MapTransmitter(IKeyCache iKeyCache, Supplier<Map<Object, Object>> supplier) {
            this.keyCache_ = iKeyCache;
            this.sourceMapSupplier_ = supplier;
        }

        @Override
        public Map<Object, Object> getDiffToTransmit(Map<Object, Object> map, Map<Object, Object> map2) {
            Map<Object, Object> map3 = map2.entrySet().stream().filter(entry -> !FGWebContainerWrapper.eq(map.get(entry.getKey()), entry.getValue())).collect(Collectors.toMap(entry -> entry.getKey(), entry -> entry.getValue()));
            return map3.isEmpty() ? null : map3;
        }

        @Override
        public int writeBinary(ByteArrayOutputStream byteArrayOutputStream, int n, Map<Object, Object> map) {
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                int n2 = this.keyCache_.getUniqueId(entry.getKey());
                byteArrayOutputStream.write((byte)(n2 & 0xFF));
                ++n;
                byteArrayOutputStream.write((byte)(n2 >> 8 & 0xFF));
                int n3 = this.writeValue(byteArrayOutputStream, ++n, entry.getValue());
                n += n3;
            }
            return n;
        }

        @Override
        public Supplier<Map<Object, Object>> getEmptyDataSupplier() {
            return HashMap::new;
        }

        @Override
        public Supplier<Map<Object, Object>> getSourceDataSupplier() {
            return this.sourceMapSupplier_;
        }

        protected abstract int writeValue(ByteArrayOutputStream var1, int var2, V var3);
    }

    static interface IKeyCache {
        public int getUniqueId(Object var1);
    }

    static abstract class AbstractTransmitter<S>
    implements IDataTransmitter<S> {
        AbstractTransmitter() {
        }

        @Override
        public ByteBuffer convertToBinary(byte by, S s) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(by);
            this.writeBinary(byteArrayOutputStream, 1, s);
            return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
        }

        public abstract int writeBinary(ByteArrayOutputStream var1, int var2, S var3);
    }

    static interface IDataTransmitter<S> {
        public byte getCommandCode();

        public Supplier<S> getEmptyDataSupplier();

        public Supplier<S> getSourceDataSupplier();

        public S getDiffToTransmit(S var1, S var2);

        public ByteBuffer convertToBinary(byte var1, S var2);
    }
}

