/*
 * Decompiled with CFR 0.152.
 */
package flatgui.core;

import flatgui.core.FGComponentPath;
import flatgui.core.IFGInputEventParser;
import flatgui.core.IFGModule;
import flatgui.core.awt.FGMouseEvent;
import flatgui.core.awt.FGMouseTargetComponentInfo;
import flatgui.core.awt.FGMouseWheelEvent;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

class FGMouseEventParser
implements IFGInputEventParser<MouseEvent> {
    public static final String CHANNEL_NAME = "mouse";
    private final int unitSizePx_;
    private boolean leftButtonDown_;
    static Collection<Object> latestPressedTargetCellIds_ = new HashSet<Object>();
    private FGComponentPath pressedPath_;
    private Object lastTargetIdPath_;
    private Object lastXRelativeVec_;
    private Object lastYRelativeVec_;
    private MouseEvent lastMouseEvent_;

    public FGMouseEventParser(int n) {
        this.unitSizePx_ = n;
    }

    @Override
    public Map<String, Object> initialize(IFGModule iFGModule) {
        return null;
    }

    @Override
    public Map<String, Object> getTargetedPropertyValues(MouseEvent mouseEvent) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(CHANNEL_NAME, mouseEvent);
        return hashMap;
    }

    @Override
    public Map<MouseEvent, Collection<Object>> getTargetCellIds(MouseEvent mouseEvent, IFGModule iFGModule, Map<String, Object> map) {
        boolean bl = (mouseEvent.getModifiersEx() & 0x400) == 1024;
        double d = (double)mouseEvent.getX() / (double)this.unitSizePx_;
        double d2 = (double)mouseEvent.getY() / (double)this.unitSizePx_;
        FGMouseTargetComponentInfo fGMouseTargetComponentInfo = iFGModule.getMouseTargetInfoAt(d, d2, bl && this.leftButtonDown_ ? this.pressedPath_ : null);
        FGComponentPath fGComponentPath = fGMouseTargetComponentInfo.getComponentPath();
        Object object = fGMouseTargetComponentInfo.getXRelativeVec();
        Object object2 = fGMouseTargetComponentInfo.getYRelativeVec();
        if (bl) {
            latestPressedTargetCellIds_ = (Collection)fGComponentPath.getTargetIdPath();
            if (!this.leftButtonDown_) {
                this.pressedPath_ = fGComponentPath;
            } else {
                fGComponentPath = this.pressedPath_;
            }
        }
        this.leftButtonDown_ = bl;
        HashMap<MouseEvent, Collection<Object>> hashMap = new HashMap<MouseEvent, Collection<Object>>();
        if (fGComponentPath != null) {
            boolean bl2;
            boolean bl3 = bl2 = this.lastTargetIdPath_ != null && !this.lastTargetIdPath_.equals(fGComponentPath.getTargetIdPath());
            if (bl2) {
                hashMap.put(this.deriveFGEvent(this.deriveWithIdAndNoButton(this.lastMouseEvent_, 505), this.lastXRelativeVec_, this.lastYRelativeVec_, (Collection)this.lastTargetIdPath_), (Collection)this.lastTargetIdPath_);
                hashMap.put(this.deriveFGEvent(this.deriveWithIdAndNoButton(mouseEvent, 504), object, object2, (Collection)fGComponentPath.getTargetIdPath()), (Collection)fGComponentPath.getTargetIdPath());
            }
            hashMap.put(this.deriveFGEvent(mouseEvent, object, object2, (Collection)fGComponentPath.getTargetIdPath()), (Collection)fGComponentPath.getTargetIdPath());
            this.lastTargetIdPath_ = fGComponentPath.getTargetIdPath();
            this.lastXRelativeVec_ = object;
            this.lastYRelativeVec_ = object2;
            this.lastMouseEvent_ = mouseEvent;
        }
        return hashMap;
    }

    private MouseEvent deriveWithIdAndNoButton(MouseEvent mouseEvent, int n) {
        return new MouseEvent((Component)mouseEvent.getSource(), n, mouseEvent.getWhen(), 0, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen(), 0, false, 0);
    }

    private MouseEvent deriveFGEvent(MouseEvent mouseEvent, Object object, Object object2, Collection<Object> collection) {
        if (mouseEvent instanceof MouseWheelEvent) {
            return new FGMouseWheelEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), ((MouseWheelEvent)mouseEvent).getScrollType(), ((MouseWheelEvent)mouseEvent).getScrollAmount(), ((MouseWheelEvent)mouseEvent).getWheelRotation(), ((MouseWheelEvent)mouseEvent).getPreciseWheelRotation(), object, object2, collection);
        }
        return new FGMouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton(), object, object2, collection);
    }
}

