/*
 * Decompiled with CFR 0.152.
 */
package flatgui.core.websocket;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import org.json.JSONException;
import org.json.JSONObject;

public class FGInputEventDecoder {
    public static final Component dummySourceComponent_ = new Container();
    private Collection<IParser<JSONObject, ? extends InputEvent>> jsonParsers_ = new ArrayList<IParser<JSONObject, ? extends InputEvent>>();
    private Collection<IParser<BinaryInput, ? extends InputEvent>> binaryParsers_ = new ArrayList<IParser<BinaryInput, ? extends InputEvent>>();

    public FGInputEventDecoder() {
        this.addJSONParser(new MouseJSONParser());
        this.addJSONParser(new KeyJSONParser());
        this.addBinaryParser(new MouseBinaryParser());
    }

    public final void addJSONParser(IParser<JSONObject, ? extends InputEvent> iParser) {
        this.jsonParsers_.add(iParser);
    }

    public final void addBinaryParser(IParser<BinaryInput, ? extends InputEvent> iParser) {
        this.binaryParsers_.add(iParser);
    }

    public <E extends InputEvent> E getInputEvent(String string) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            return FGInputEventDecoder.getInputEvent(jSONObject, this.jsonParsers_);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return null;
        }
    }

    public <E extends InputEvent> E getInputEvent(BinaryInput binaryInput) {
        return FGInputEventDecoder.getInputEvent(binaryInput, this.binaryParsers_);
    }

    private static <S, E extends InputEvent> E getInputEvent(S s, Collection<IParser<S, ? extends InputEvent>> collection) {
        try {
            for (IParser<S, InputEvent> iParser : collection) {
                InputEvent inputEvent = iParser.getInputEvent(s);
                if (inputEvent == null) continue;
                return (E)inputEvent;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private static MouseEvent getMouseEvent(int n, int n2, int n3) {
        boolean bl = n == 501 || n == 502 || n == 500 || n == 506;
        int n4 = bl && n != 506 ? 1 : 0;
        int n5 = bl ? 1 : 0;
        MouseEvent mouseEvent = new MouseEvent(dummySourceComponent_, n, 0L, bl && n == 506 ? InputEvent.getMaskForButton(n5) : 0, n2, n3, n2, n3, n4, false, n5);
        return mouseEvent;
    }

    public static class MouseBinaryParser
    extends AbstractBinaryParser<MouseEvent> {
        @Override
        protected MouseEvent parseImpl(BinaryInput binaryInput, int n) throws Exception {
            if (n >= 500 && n <= 507) {
                byte[] byArray = binaryInput.getPayload();
                int n2 = binaryInput.getOffset();
                int n3 = byArray[n2 + 1] & 0x7F;
                if ((byArray[n2 + 1] & 0x80) == 128) {
                    n3 += 128;
                }
                n3 += (byArray[n2 + 3] & 0x70) << 4;
                if ((byArray[n2 + 3] & 0x80) == 128) {
                    n3 += 2048;
                }
                int n4 = byArray[n2 + 2] & 0x7F;
                if ((byArray[n2 + 2] & 0x80) == 128) {
                    n4 += 128;
                }
                return FGInputEventDecoder.getMouseEvent(n, n3, n4 += (byArray[n2 + 3] & 0xF) << 8);
            }
            return null;
        }
    }

    public static abstract class AbstractBinaryParser<E extends InputEvent>
    implements IParser<BinaryInput, E> {
        @Override
        public E getInputEvent(BinaryInput binaryInput) throws Exception {
            byte[] byArray = binaryInput.getPayload();
            int n = binaryInput.getOffset();
            int n2 = byArray[n] + 400;
            return this.parseImpl(binaryInput, n2);
        }

        protected abstract E parseImpl(BinaryInput var1, int var2) throws Exception;
    }

    public static class KeyJSONParser
    extends AbstractJSONParser<KeyEvent> {
        public static final String C = "c";
        public static final String S = "s";

        @Override
        protected KeyEvent parseImpl(JSONObject jSONObject, int n) throws JSONException {
            if (n >= 400 && n <= 402) {
                int n2 = jSONObject.getInt(C);
                char c = (char)jSONObject.getInt(S);
                KeyEvent keyEvent = new KeyEvent(dummySourceComponent_, n, 0L, 0, n == 400 ? 0 : n2, c);
                return keyEvent;
            }
            return null;
        }
    }

    public static class MouseJSONParser
    extends AbstractJSONParser<MouseEvent> {
        public static final String X = "x";
        public static final String Y = "y";

        @Override
        protected MouseEvent parseImpl(JSONObject jSONObject, int n) throws JSONException {
            if (n >= 500 && n <= 507) {
                int n2 = jSONObject.getInt(X);
                int n3 = jSONObject.getInt(Y);
                return FGInputEventDecoder.getMouseEvent(n, n2, n3);
            }
            return null;
        }
    }

    public static abstract class AbstractJSONParser<E extends InputEvent>
    implements IParser<JSONObject, E> {
        public static final String ID = "id";

        @Override
        public E getInputEvent(JSONObject jSONObject) throws JSONException {
            int n = jSONObject.getInt(ID);
            return this.parseImpl(jSONObject, n);
        }

        protected abstract E parseImpl(JSONObject var1, int var2) throws JSONException;
    }

    public static interface IParser<S, E extends InputEvent> {
        public E getInputEvent(S var1) throws Exception;
    }

    public static class BinaryInput {
        private byte[] payload_;
        private int offset_;
        private int len_;

        public BinaryInput(byte[] byArray, int n, int n2) {
            this.payload_ = byArray;
            this.offset_ = n;
            this.len_ = n2;
        }

        public byte[] getPayload() {
            return this.payload_;
        }

        public int getOffset() {
            return this.offset_;
        }

        public int getLen() {
            return this.len_;
        }
    }
}

