/*
 * Decompiled with CFR 0.152.
 */
package flatgui.core.websocket;

import flatgui.core.FGWebContainerWrapper;
import flatgui.core.IFGTemplate;
import flatgui.core.websocket.FGAppServer;
import flatgui.core.websocket.FGContainerSession;
import flatgui.core.websocket.FGContainerSessionHolder;
import flatgui.core.websocket.FGInputEventDecoder;
import java.awt.event.InputEvent;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;

public class FGContainerWebSocket
implements WebSocketListener {
    private final FGContainerSessionHolder sessionHolder_;
    private final IFGTemplate template_;
    private volatile Session session_;
    private volatile FGWebContainerWrapper container_;
    private volatile FGInputEventDecoder parser_;
    private volatile FGContainerSession fgSession_;

    public FGContainerWebSocket(IFGTemplate iFGTemplate, FGContainerSessionHolder fGContainerSessionHolder) {
        this.template_ = iFGTemplate;
        this.sessionHolder_ = fGContainerSessionHolder;
        FGAppServer.getFGLogger().info("WS Listener created " + System.identityHashCode(this));
    }

    public void onWebSocketClose(int n, String string) {
        FGAppServer.getFGLogger().info("WS Connect " + System.identityHashCode(this) + " session: " + this.fgSession_ + " remote: " + this.session_.getRemoteAddress() + " reason = " + string);
        this.container_.unInitialize();
        this.fgSession_.markIdle();
        this.session_ = null;
    }

    public void onWebSocketConnect(Session session) {
        this.session_ = session;
        StringBuilder stringBuilder = new StringBuilder("Creating session...");
        this.setTextToRemote(stringBuilder.toString());
        this.fgSession_ = this.sessionHolder_.getSession(this.template_, this.session_.getRemoteAddress().getAddress());
        stringBuilder.append("|created session");
        this.setTextToRemote(stringBuilder.toString());
        FGAppServer.getFGLogger().info("WS Connect " + System.identityHashCode(this) + " session: " + this.fgSession_ + " remote: " + session.getRemoteAddress());
        this.container_ = this.fgSession_.getContainer();
        stringBuilder.append("|created app");
        this.setTextToRemote(stringBuilder.toString());
        this.container_.initialize();
        stringBuilder.append("|initialized app");
        this.setTextToRemote(stringBuilder.toString());
        this.parser_ = this.fgSession_.getParser();
        stringBuilder.append("|retrieving initial state...");
        this.setTextToRemote(stringBuilder.toString());
        this.container_.resetCache();
        this.collectAndSendResponse();
    }

    public void onWebSocketError(Throwable throwable) {
        FGAppServer.getFGLogger().error(this.fgSession_ + " WS error: " + throwable.getMessage());
    }

    public void onWebSocketBinary(byte[] byArray, int n, int n2) {
        this.fgSession_.markAccesed();
        Object e = this.parser_.getInputEvent(new FGInputEventDecoder.BinaryInput(byArray, n, n2));
        this.processInputEvent((InputEvent)e);
    }

    public void onWebSocketText(String string) {
        this.fgSession_.markAccesed();
        Object e = this.parser_.getInputEvent(string);
        this.processInputEvent((InputEvent)e);
    }

    private void processInputEvent(InputEvent inputEvent) {
        if (inputEvent == null) {
            return;
        }
        this.container_.feedEvent(inputEvent);
        this.collectAndSendResponse();
    }

    private void collectAndSendResponse() {
        Collection<ByteBuffer> collection = this.container_.getResponseForClient();
        if (collection.size() > 0) {
            collection.forEach(this::sendBytesToRemote);
            this.sendBytesToRemote(ByteBuffer.wrap(new byte[]{7}));
        }
    }

    private void sendBytesToRemote(ByteBuffer byteBuffer) {
        try {
            this.session_.getRemote().sendBytes(byteBuffer);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void setTextToRemote(String string) {
        try {
            this.session_.getRemote().sendString(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

