/*
 * Decompiled with CFR 0.152.
 */
package flatgui.core.websocket;

import flatgui.core.FGContainer;
import flatgui.core.IFGContainerHost;
import flatgui.core.IFGTemplate;
import flatgui.core.websocket.FGAppServer;
import flatgui.core.websocket.FGContainerSession;
import java.net.InetAddress;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

class FGContainerSessionHolder {
    private static final String SPECIAL_CHARS = ".:/=";
    private static final long IDLE_SESSION_TIMEOUT = 900000L;
    private final IFGContainerHost<FGContainerSession> sessionHost_;
    private final Map<Object, FGContainerSession> sessionMap_;

    FGContainerSessionHolder(IFGContainerHost<FGContainerSession> iFGContainerHost) {
        this.sessionHost_ = iFGContainerHost;
        this.sessionMap_ = new ConcurrentHashMap<Object, FGContainerSession>();
        Timer timer = new Timer("FlatGUI web container idle session cleaner", true);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                int n = FGContainerSessionHolder.this.sessionMap_.size();
                FGContainerSessionHolder.this.sessionMap_.entrySet().removeIf(entry -> ((FGContainerSession)entry.getValue()).isIdle(900000L));
                int n2 = FGContainerSessionHolder.this.sessionMap_.size();
                if (n2 != n) {
                    FGAppServer.getFGLogger().info(this.toString() + " cleaned sessions. Before: " + n + "; after: " + n2 + ".");
                }
            }
        }, 900000L, 900000L);
    }

    FGContainerSession getSession(IFGTemplate iFGTemplate, InetAddress inetAddress) {
        Object object = FGContainerSessionHolder.getSessionId(iFGTemplate, inetAddress);
        FGContainerSession fGContainerSession = this.sessionMap_.computeIfAbsent(FGContainerSessionHolder.getSessionId(iFGTemplate, inetAddress), object2 -> this.sessionHost_.hostContainer(new FGContainer(iFGTemplate, object.toString())));
        FGAppServer.getFGLogger().debug(this.toString() + " state:");
        FGAppServer.getFGLogger().debug(this.sessionMap_.toString());
        FGAppServer.getFGLogger().debug(this.toString() + " returning for remoteAddress=" + inetAddress + " session: " + fGContainerSession);
        return fGContainerSession;
    }

    private static Object getSessionId(IFGTemplate iFGTemplate, InetAddress inetAddress) {
        String string = iFGTemplate.getContainerNamespace() + "_" + iFGTemplate.getContainerVarName() + "_" + inetAddress.getHostAddress().toString();
        for (int i = 0; i < SPECIAL_CHARS.length(); ++i) {
            string = string.replace(SPECIAL_CHARS.charAt(i), '_');
        }
        return string;
    }
}

