/*
 * Decompiled with CFR 0.152.
 */
package flatgui.core.awt;

import flatgui.core.awt.IFGPrimitivePainter;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class FGDefaultPrimitivePainter
implements IFGPrimitivePainter {
    private static Map<Class, Class> NUMBER_CLASS_TO_PRIMITIVE = new HashMap<Class, Class>();
    private static final String PUSH_CURRENT_CLIP = "pushCurrentClip";
    private static final String POP_CURRENT_CLIP = "popCurrentClip";
    private double unitSizePx_;
    private Deque<Shape> clipRectStack_ = new LinkedList<Shape>();
    private Map<String, Consumer<Graphics2D>> customMethods_ = new HashMap<String, Consumer<Graphics2D>>();
    private Map<String, Method> methodByNameCache_;

    public FGDefaultPrimitivePainter(double d) {
        this.customMethods_.put(PUSH_CURRENT_CLIP, graphics2D -> this.clipRectStack_.addLast(graphics2D.getClip()));
        this.customMethods_.put(POP_CURRENT_CLIP, graphics2D -> graphics2D.setClip(this.clipRectStack_.removeLast()));
        this.methodByNameCache_ = new HashMap<String, Method>();
        this.unitSizePx_ = d;
    }

    @Override
    public void paintPrimitive(Graphics graphics, List<Object> list) {
        String string = (String)list.get(0);
        Object[] objectArray = list.stream().skip(1L).map(object -> object instanceof Double ? Integer.valueOf((int)((Double)object * this.unitSizePx_)) : (object instanceof Number ? Integer.valueOf((int)(((Number)object).doubleValue() * this.unitSizePx_)) : object)).collect(Collectors.toList()).toArray();
        Class[] classArray = Arrays.stream(objectArray).map(object -> object != null ? object.getClass() : null).map(clazz -> NUMBER_CLASS_TO_PRIMITIVE.containsKey(clazz) ? NUMBER_CLASS_TO_PRIMITIVE.get(clazz) : clazz).collect(Collectors.toList()).toArray(new Class[objectArray.length]);
        if (this.customMethods_.containsKey(string)) {
            this.customMethods_.get(string).accept((Graphics2D)graphics);
        } else {
            try {
                Method method2 = this.methodByNameCache_.get(string);
                if (method2 == null) {
                    if (Arrays.stream(classArray).anyMatch(clazz -> clazz == null)) {
                        Method[] methodArray = graphics.getClass().getMethods();
                        Optional<Method> optional = Arrays.stream(methodArray).filter(method -> method.getName().equals(string) && method.getParameterCount() == classArray.length).findAny();
                        method2 = optional.get();
                    } else {
                        method2 = graphics.getClass().getMethod(string, classArray);
                    }
                    this.methodByNameCache_.put(string, method2);
                }
                method2.invoke((Object)graphics, objectArray);
            }
            catch (Exception exception) {
                System.out.println("Error painting primitive: " + list);
                exception.printStackTrace();
            }
        }
    }

    static {
        NUMBER_CLASS_TO_PRIMITIVE.put(Integer.class, Integer.TYPE);
        NUMBER_CLASS_TO_PRIMITIVE.put(Long.class, Integer.TYPE);
    }
}

