/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.fife.ui.rtextarea.AbstractGutterComponent;
import org.fife.ui.rtextarea.Gutter;
import org.fife.ui.rtextarea.GutterIconInfo;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaUI;

public class IconRowHeader
extends AbstractGutterComponent
implements MouseListener {
    protected List trackingIcons;
    protected int width = 16;
    private boolean bookmarkingEnabled;
    private Icon bookmarkIcon;
    protected Rectangle visibleRect = new Rectangle();
    protected Insets textAreaInsets;
    protected int activeLineRangeStart;
    protected int activeLineRangeEnd;
    private Color activeLineRangeColor;

    public IconRowHeader(RTextArea rTextArea) {
        super(rTextArea);
        this.addMouseListener(this);
        this.activeLineRangeEnd = -1;
        this.activeLineRangeStart = -1;
        this.setActiveLineRangeColor(null);
        this.updateBackground();
    }

    public GutterIconInfo addOffsetTrackingIcon(int n, Icon icon) throws BadLocationException {
        int n2;
        Position position = this.textArea.getDocument().createPosition(n);
        GutterIconImpl gutterIconImpl = new GutterIconImpl(icon, position);
        if (this.trackingIcons == null) {
            this.trackingIcons = new ArrayList(1);
        }
        if ((n2 = Collections.binarySearch(this.trackingIcons, gutterIconImpl)) < 0) {
            n2 = -(n2 + 1);
        }
        this.trackingIcons.add(n2, gutterIconImpl);
        this.repaint();
        return gutterIconImpl;
    }

    public void clearActiveLineRange() {
        if (this.activeLineRangeStart != -1 || this.activeLineRangeEnd != -1) {
            this.activeLineRangeEnd = -1;
            this.activeLineRangeStart = -1;
            this.repaint();
        }
    }

    public Color getActiveLineRangeColor() {
        return this.activeLineRangeColor;
    }

    public Icon getBookmarkIcon() {
        return this.bookmarkIcon;
    }

    public GutterIconInfo[] getBookmarks() {
        ArrayList<GutterIconImpl> arrayList = new ArrayList<GutterIconImpl>(1);
        if (this.trackingIcons != null) {
            for (int i = 0; i < this.trackingIcons.size(); ++i) {
                GutterIconImpl gutterIconImpl = this.getTrackingIcon(i);
                if (gutterIconImpl.getIcon() != this.bookmarkIcon) continue;
                arrayList.add(gutterIconImpl);
            }
        }
        GutterIconInfo[] gutterIconInfoArray = new GutterIconInfo[arrayList.size()];
        return arrayList.toArray(gutterIconInfoArray);
    }

    void handleDocumentEvent(DocumentEvent documentEvent) {
        int n = this.textArea.getLineCount();
        if (n != this.currentLineCount) {
            this.currentLineCount = n;
            this.repaint();
        }
    }

    public Dimension getPreferredSize() {
        int n = this.textArea != null ? this.textArea.getHeight() : 100;
        return new Dimension(this.width, n);
    }

    protected GutterIconImpl getTrackingIcon(int n) {
        return (GutterIconImpl)this.trackingIcons.get(n);
    }

    public GutterIconInfo[] getTrackingIcons(int n) throws BadLocationException {
        ArrayList<GutterIconImpl> arrayList = new ArrayList<GutterIconImpl>(1);
        if (this.trackingIcons != null) {
            int n2 = this.textArea.getLineStartOffset(n);
            int n3 = this.textArea.getLineEndOffset(n);
            if (n == this.textArea.getLineCount() - 1) {
                ++n3;
            }
            for (int i = 0; i < this.trackingIcons.size(); ++i) {
                GutterIconImpl gutterIconImpl = this.getTrackingIcon(i);
                int n4 = gutterIconImpl.getMarkedOffset();
                if (n4 >= n2 && n4 < n3) {
                    arrayList.add(gutterIconImpl);
                    continue;
                }
                if (n4 >= n3) break;
            }
        }
        GutterIconInfo[] gutterIconInfoArray = new GutterIconInfo[arrayList.size()];
        return arrayList.toArray(gutterIconInfoArray);
    }

    public boolean isBookmarkingEnabled() {
        return this.bookmarkingEnabled;
    }

    void lineHeightsChanged() {
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.bookmarkingEnabled && this.bookmarkIcon != null) {
            try {
                int n = this.textArea.viewToModel(mouseEvent.getPoint());
                if (n > -1) {
                    int n2 = this.textArea.getLineOfOffset(n);
                    this.toggleBookmark(n2);
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    protected void paintComponent(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (this.textArea == null) {
            return;
        }
        this.visibleRect = graphics.getClipBounds(this.visibleRect);
        if (this.visibleRect == null) {
            this.visibleRect = this.getVisibleRect();
        }
        if (this.visibleRect == null) {
            return;
        }
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, this.visibleRect.y, this.width, this.visibleRect.height);
        if (this.textArea.getLineWrap()) {
            this.paintComponentWrapped(graphics);
            return;
        }
        Document document = this.textArea.getDocument();
        Element element = document.getDefaultRootElement();
        this.textAreaInsets = this.textArea.getInsets(this.textAreaInsets);
        int n6 = this.textArea.getLineHeight();
        int n7 = (this.visibleRect.y - this.textAreaInsets.top) / n6;
        int n8 = Math.min(n7 + this.visibleRect.height / n6 + 1, element.getElementCount());
        int n9 = n7 * n6 + this.textAreaInsets.top;
        if (this.activeLineRangeStart >= n7 && this.activeLineRangeStart <= n8 || this.activeLineRangeEnd >= n7 && this.activeLineRangeEnd <= n8 || this.activeLineRangeStart <= n7 && this.activeLineRangeEnd >= n8) {
            int n10;
            graphics.setColor(this.activeLineRangeColor);
            n5 = Math.max(this.activeLineRangeStart, n7);
            n4 = n5 * n6 + this.textAreaInsets.top;
            int n11 = Math.min(this.activeLineRangeEnd, n8);
            n3 = (n11 + 1) * n6 + this.textAreaInsets.top - 1;
            for (n2 = n4; n2 <= n3; n2 += 2) {
                n10 = Math.min(n3, n2 + this.getWidth());
                n = n10 - n2;
                graphics.drawLine(0, n2, n, n10);
            }
            for (n10 = 2; n10 < this.getWidth(); n10 += 2) {
                n = n4 + this.getWidth() - n10;
                graphics.drawLine(n10, n4, this.getWidth(), n);
            }
            if (n5 == this.activeLineRangeStart) {
                graphics.drawLine(0, n4, this.getWidth(), n4);
            }
            if (n11 == this.activeLineRangeEnd) {
                graphics.drawLine(0, n3, this.getWidth(), n3);
            }
        }
        if (this.trackingIcons != null) {
            n5 = n8;
            for (n4 = this.trackingIcons.size() - 1; n4 >= 0; --n4) {
                GutterIconImpl gutterIconImpl = this.getTrackingIcon(n4);
                n3 = gutterIconImpl.getMarkedOffset();
                if (n3 < 0 || n3 > document.getLength()) continue;
                n2 = element.getElementIndex(n3);
                if (n2 <= n5 && n2 >= n7) {
                    Icon icon = gutterIconImpl.getIcon();
                    if (icon == null) continue;
                    n = n9 + (n2 - n7) * n6;
                    gutterIconImpl.getIcon().paintIcon(this, graphics, 0, n += (n6 - icon.getIconHeight()) / 2);
                    n5 = n2 - 1;
                    continue;
                }
                if (n2 < n7) break;
            }
        }
    }

    private void paintComponentWrapped(Graphics graphics) {
        int n;
        GutterIconImpl gutterIconImpl;
        int n2;
        RTextAreaUI rTextAreaUI = (RTextAreaUI)this.textArea.getUI();
        View view = rTextAreaUI.getRootView(this.textArea).getView(0);
        Document document = this.textArea.getDocument();
        Element element = document.getDefaultRootElement();
        int n3 = element.getElementCount();
        int n4 = this.textArea.viewToModel(new Point(this.visibleRect.x, this.visibleRect.y));
        int n5 = element.getElementIndex(n4);
        Rectangle rectangle = rTextAreaUI.getVisibleEditorRect();
        Rectangle rectangle2 = IconRowHeader.getChildViewBounds(view, n5, rectangle);
        int n6 = rectangle2.y;
        int n7 = this.visibleRect.y + this.visibleRect.height;
        int n8 = -1;
        if (this.trackingIcons != null) {
            for (n2 = 0; n2 < this.trackingIcons.size(); ++n2) {
                gutterIconImpl = this.getTrackingIcon(n2);
                int n9 = gutterIconImpl.getMarkedOffset();
                if (n9 < 0 || n9 > document.getLength() || (n = element.getElementIndex(n9)) < n5) continue;
                n8 = n2;
                break;
            }
        }
        graphics.setColor(this.getForeground());
        n2 = this.textArea.getLineHeight();
        while (n6 < n7) {
            rectangle2 = IconRowHeader.getChildViewBounds(view, n5, rectangle);
            if (n8 > -1) {
                Icon icon;
                gutterIconImpl = null;
                while (n8 < this.trackingIcons.size()) {
                    GutterIconImpl gutterIconImpl2 = this.getTrackingIcon(n8);
                    n = gutterIconImpl2.getMarkedOffset();
                    if (n >= 0 && n <= document.getLength()) {
                        int n10 = element.getElementIndex(n);
                        if (n10 == n5) {
                            gutterIconImpl = gutterIconImpl2;
                        } else if (n10 > n5) break;
                    }
                    ++n8;
                }
                if (gutterIconImpl != null && (icon = gutterIconImpl.getIcon()) != null) {
                    n = n6 + (n2 - icon.getIconHeight()) / 2;
                    icon.paintIcon(this, graphics, 0, n);
                }
            }
            n6 += rectangle2.height;
            if (++n5 < n3) continue;
            break;
        }
    }

    public void removeTrackingIcon(Object object) {
        if (this.trackingIcons != null && this.trackingIcons.remove(object)) {
            this.repaint();
        }
    }

    public void removeAllTrackingIcons() {
        if (this.trackingIcons != null && this.trackingIcons.size() > 0) {
            this.trackingIcons.clear();
            this.repaint();
        }
    }

    private void removeBookmarkTrackingIcons() {
        if (this.trackingIcons != null) {
            Iterator iterator = this.trackingIcons.iterator();
            while (iterator.hasNext()) {
                GutterIconImpl gutterIconImpl = (GutterIconImpl)iterator.next();
                if (gutterIconImpl.getIcon() != this.bookmarkIcon) continue;
                iterator.remove();
            }
        }
    }

    public void setActiveLineRange(int n, int n2) {
        if (n != this.activeLineRangeStart || n2 != this.activeLineRangeEnd) {
            this.activeLineRangeStart = n;
            this.activeLineRangeEnd = n2;
            this.repaint();
        }
    }

    public void setActiveLineRangeColor(Color color) {
        if (color == null) {
            color = Gutter.DEFAULT_ACTIVE_LINE_RANGE_COLOR;
        }
        if (!color.equals(this.activeLineRangeColor)) {
            this.activeLineRangeColor = color;
            this.repaint();
        }
    }

    public void setBookmarkIcon(Icon icon) {
        this.removeBookmarkTrackingIcons();
        this.bookmarkIcon = icon;
        this.repaint();
    }

    public void setBookmarkingEnabled(boolean bl) {
        if (bl != this.bookmarkingEnabled) {
            this.bookmarkingEnabled = bl;
            if (!bl) {
                this.removeBookmarkTrackingIcons();
            }
            this.repaint();
        }
    }

    public void setTextArea(RTextArea rTextArea) {
        this.removeAllTrackingIcons();
        super.setTextArea(rTextArea);
    }

    public boolean toggleBookmark(int n) throws BadLocationException {
        int n2;
        if (!this.isBookmarkingEnabled() || this.getBookmarkIcon() == null) {
            return false;
        }
        GutterIconInfo[] gutterIconInfoArray = this.getTrackingIcons(n);
        if (gutterIconInfoArray.length == 0) {
            int n3 = this.textArea.getLineStartOffset(n);
            this.addOffsetTrackingIcon(n3, this.bookmarkIcon);
            return true;
        }
        boolean bl = false;
        for (n2 = 0; n2 < gutterIconInfoArray.length; ++n2) {
            if (gutterIconInfoArray[n2].getIcon() != this.bookmarkIcon) continue;
            this.removeTrackingIcon(gutterIconInfoArray[n2]);
            bl = true;
        }
        if (!bl) {
            n2 = this.textArea.getLineStartOffset(n);
            this.addOffsetTrackingIcon(n2, this.bookmarkIcon);
        }
        return !bl;
    }

    private void updateBackground() {
        Color color = UIManager.getColor("Panel.background");
        if (color == null) {
            color = new JPanel().getBackground();
        }
        this.setBackground(color);
    }

    public void updateUI() {
        super.updateUI();
        this.updateBackground();
    }

    private static class GutterIconImpl
    implements GutterIconInfo,
    Comparable {
        private Icon icon;
        private Position pos;

        public GutterIconImpl(Icon icon, Position position) {
            this.icon = icon;
            this.pos = position;
        }

        public int compareTo(Object object) {
            if (object instanceof GutterIconInfo) {
                return this.pos.getOffset() - ((GutterIconInfo)object).getMarkedOffset();
            }
            return -1;
        }

        public boolean equals(Object object) {
            return object == this;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public int getMarkedOffset() {
            return this.pos.getOffset();
        }

        public int hashCode() {
            return this.icon.hashCode();
        }
    }
}

