(ns ezand.flume-nodes.core
  (:require [superstring.core :as str]))

;;;;;;;;;;;;;;;;;;;
;; Node Handlers ;;
;;;;;;;;;;;;;;;;;;;
(defn static-value
  [input-values]
  {:value (get-in input-values [:static-value :string])})

(defn join
  [{:keys [value1 value2] :as input-values}]
  (let [separator (get-in input-values [:separator :string])]
    {:joined (str/join separator [value1 value2])}))

;;;;;;;;;;;;;;;
;; Fire node ;;
;;;;;;;;;;;;;;;
(defn fire-node
  [node input-values node-type context]
  (case (:type node-type)
    :static-value (static-value input-values)
    :join (join input-values)
    nil))
