(defproject org.ezand/flume-engine-clj "0.0.1"
  :description "Flume Engine for Clojure"
  :url "https://github.com/ezand/flume-engine-clj"
  :license {:name "The MIT License"
            :url "http://opensource.org/licenses/MIT"}
  :dependencies [[org.clojure/algo.generic "0.1.3"]
                 [org.clojure/clojure "1.10.3"]
                 [org.clojure/data.json "1.1.0"]
                 [org.clojure/tools.logging "1.1.0"]
                 [slingshot "0.12.2"]
                 [superstring "3.0.0"]]
  :repl-options {:init-ns ezand.flume-engine.engines.root-engine}
  :profiles {:dev {:dependencies [[clj-kondo "2021.03.03" :exclusions [org.clojure/clojure]]]}}
  :aliases {"lint" ["run" "-m" "clj-kondo.main" "--lint" "src" "--lint" "dev" "--lint" "test"]
            "l" "lint"
            "t" ["do" ["clean"] ["test"]]})
