(ns instaparsers.util)

(defn splice-at [n xs coll]
  (if (neg? n)
    (concat (drop-last (- n) coll) xs (take-last (- n) coll))
    (concat (take n coll) xs (drop n coll))))

(defn unparse [node]
  (if (string? node)
    node
    (transduce
      (map (fn [part]
             (cond
               (string? part) part
               (vector? part) (unparse part)
               (seq part) (transduce (map unparse) str part)
               :else part)))
      str (rest node))))
