(ns instaparsers.es6
  (:require [clojure.java.io :as io]
            [instaparse.core :as insta]
            [instaparse.combinators :as combo]
            [instaparsers.util :as util])
  (:import [instaparse.gll Failure]))

(def es6 (combo/ebnf (slurp (io/resource "es6.bnf"))))

(defn with-jsx [m]
  (-> m
    (merge (combo/ebnf (slurp (io/resource "es6-jsx.bnf"))))
    (update-in [:expr :parsers] conj (combo/nt :jsxTag))))

(defn with-flowtype [m]
  (let [fs [(combo/nt :wso) (combo/opt (combo/nt :flowSpec))]
        splice (fn [xs n fs]
                 (util/splice-at n fs xs))]
    (-> m
      (merge (combo/ebnf (slurp (io/resource "es6-flowtype.bnf"))))
      (update-in [:stmt :parsers] conj (combo/nt :flowImport))
      (update-in [:stmt :parsers] conj (combo/nt :flowTypeDeclaration))
      (update-in [:exportable :parsers] conj (combo/nt :flowTypeDeclaration))
      (update-in [:func :parsers] splice -2 fs)
      (update-in [:anonFunc :parsers] splice -2 fs)
      (update-in [:generator :parsers] splice -2 fs)
      (update-in [:anonGenerator :parsers] splice -2 fs)
      (update-in [:lambda :parsers] splice -2 fs)
      (update-in [:blockLambda :parsers] splice -2 fs)
      (update-in [:arg :parsers] splice -2 fs))))

(def parser (insta/parser (-> es6 with-jsx with-flowtype) :start :S))

(def unparse util/unparse)
