// Compiled by ClojureScript 1.9.946 {}
goog.provide('markdown.core');
goog.require('cljs.core');
goog.require('markdown.common');
goog.require('markdown.links');
goog.require('markdown.transformers');
markdown.core.init_transformer = (function markdown$core$init_transformer(p__33170){
var map__33171 = p__33170;
var map__33171__$1 = ((((!((map__33171 == null)))?((((map__33171.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33171.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33171):map__33171);
var replacement_transformers = cljs.core.get.call(null,map__33171__$1,new cljs.core.Keyword(null,"replacement-transformers","replacement-transformers",-2028552897));
var custom_transformers = cljs.core.get.call(null,map__33171__$1,new cljs.core.Keyword(null,"custom-transformers","custom-transformers",1440601790));
var inhibit_separator = cljs.core.get.call(null,map__33171__$1,new cljs.core.Keyword(null,"inhibit-separator","inhibit-separator",1268116222));
return ((function (map__33171,map__33171__$1,replacement_transformers,custom_transformers,inhibit_separator){
return (function (html,line,next_line,state){
var _STAR_inhibit_separator_STAR_33173 = markdown.common._STAR_inhibit_separator_STAR_;
markdown.common._STAR_inhibit_separator_STAR_ = inhibit_separator;

try{var vec__33174 = cljs.core.reduce.call(null,((function (_STAR_inhibit_separator_STAR_33173,map__33171,map__33171__$1,replacement_transformers,custom_transformers,inhibit_separator){
return (function (p__33177,transformer){
var vec__33178 = p__33177;
var text = cljs.core.nth.call(null,vec__33178,(0),null);
var state__$1 = cljs.core.nth.call(null,vec__33178,(1),null);
return transformer.call(null,text,cljs.core.assoc.call(null,state__$1,new cljs.core.Keyword(null,"next-line","next-line",-1187000287),next_line));
});})(_STAR_inhibit_separator_STAR_33173,map__33171,map__33171__$1,replacement_transformers,custom_transformers,inhibit_separator))
,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [line,state], null),(function (){var or__8186__auto__ = replacement_transformers;
if(cljs.core.truth_(or__8186__auto__)){
return or__8186__auto__;
} else {
return cljs.core.into.call(null,markdown.transformers.transformer_vector,custom_transformers);
}
})());
var text = cljs.core.nth.call(null,vec__33174,(0),null);
var new_state = cljs.core.nth.call(null,vec__33174,(1),null);
html.append(text);

return new_state;
}finally {markdown.common._STAR_inhibit_separator_STAR_ = _STAR_inhibit_separator_STAR_33173;
}});
;})(map__33171,map__33171__$1,replacement_transformers,custom_transformers,inhibit_separator))
});
/**
 * Removed from cljs.core 0.0-1885, Ref. http://goo.gl/su7Xkj
 */
markdown.core.format = (function markdown$core$format(var_args){
var args__9364__auto__ = [];
var len__9357__auto___33183 = arguments.length;
var i__9358__auto___33184 = (0);
while(true){
if((i__9358__auto___33184 < len__9357__auto___33183)){
args__9364__auto__.push((arguments[i__9358__auto___33184]));

var G__33185 = (i__9358__auto___33184 + (1));
i__9358__auto___33184 = G__33185;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((1) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((1)),(0),null)):null);
return markdown.core.format.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9365__auto__);
});

markdown.core.format.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,args){
return cljs.core.apply.call(null,goog.string.format,fmt,args);
});

markdown.core.format.cljs$lang$maxFixedArity = (1);

markdown.core.format.cljs$lang$applyTo = (function (seq33181){
var G__33182 = cljs.core.first.call(null,seq33181);
var seq33181__$1 = cljs.core.next.call(null,seq33181);
return markdown.core.format.cljs$core$IFn$_invoke$arity$variadic(G__33182,seq33181__$1);
});

markdown.core.parse_references = (function markdown$core$parse_references(lines){
var references = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var seq__33186_33190 = cljs.core.seq.call(null,lines);
var chunk__33187_33191 = null;
var count__33188_33192 = (0);
var i__33189_33193 = (0);
while(true){
if((i__33189_33193 < count__33188_33192)){
var line_33194 = cljs.core._nth.call(null,chunk__33187_33191,i__33189_33193);
markdown.links.parse_reference_link.call(null,line_33194,references);

var G__33195 = seq__33186_33190;
var G__33196 = chunk__33187_33191;
var G__33197 = count__33188_33192;
var G__33198 = (i__33189_33193 + (1));
seq__33186_33190 = G__33195;
chunk__33187_33191 = G__33196;
count__33188_33192 = G__33197;
i__33189_33193 = G__33198;
continue;
} else {
var temp__4657__auto___33199 = cljs.core.seq.call(null,seq__33186_33190);
if(temp__4657__auto___33199){
var seq__33186_33200__$1 = temp__4657__auto___33199;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33186_33200__$1)){
var c__9025__auto___33201 = cljs.core.chunk_first.call(null,seq__33186_33200__$1);
var G__33202 = cljs.core.chunk_rest.call(null,seq__33186_33200__$1);
var G__33203 = c__9025__auto___33201;
var G__33204 = cljs.core.count.call(null,c__9025__auto___33201);
var G__33205 = (0);
seq__33186_33190 = G__33202;
chunk__33187_33191 = G__33203;
count__33188_33192 = G__33204;
i__33189_33193 = G__33205;
continue;
} else {
var line_33206 = cljs.core.first.call(null,seq__33186_33200__$1);
markdown.links.parse_reference_link.call(null,line_33206,references);

var G__33207 = cljs.core.next.call(null,seq__33186_33200__$1);
var G__33208 = null;
var G__33209 = (0);
var G__33210 = (0);
seq__33186_33190 = G__33207;
chunk__33187_33191 = G__33208;
count__33188_33192 = G__33209;
i__33189_33193 = G__33210;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref.call(null,references);
});
markdown.core.parse_footnotes = (function markdown$core$parse_footnotes(lines){
var footnotes = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"next-fn-id","next-fn-id",738579636),(1),new cljs.core.Keyword(null,"processed","processed",800622264),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"unprocessed","unprocessed",766771972),cljs.core.PersistentArrayMap.EMPTY], null));
var seq__33211_33215 = cljs.core.seq.call(null,lines);
var chunk__33212_33216 = null;
var count__33213_33217 = (0);
var i__33214_33218 = (0);
while(true){
if((i__33214_33218 < count__33213_33217)){
var line_33219 = cljs.core._nth.call(null,chunk__33212_33216,i__33214_33218);
markdown.links.parse_footnote_link.call(null,line_33219,footnotes);

var G__33220 = seq__33211_33215;
var G__33221 = chunk__33212_33216;
var G__33222 = count__33213_33217;
var G__33223 = (i__33214_33218 + (1));
seq__33211_33215 = G__33220;
chunk__33212_33216 = G__33221;
count__33213_33217 = G__33222;
i__33214_33218 = G__33223;
continue;
} else {
var temp__4657__auto___33224 = cljs.core.seq.call(null,seq__33211_33215);
if(temp__4657__auto___33224){
var seq__33211_33225__$1 = temp__4657__auto___33224;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33211_33225__$1)){
var c__9025__auto___33226 = cljs.core.chunk_first.call(null,seq__33211_33225__$1);
var G__33227 = cljs.core.chunk_rest.call(null,seq__33211_33225__$1);
var G__33228 = c__9025__auto___33226;
var G__33229 = cljs.core.count.call(null,c__9025__auto___33226);
var G__33230 = (0);
seq__33211_33215 = G__33227;
chunk__33212_33216 = G__33228;
count__33213_33217 = G__33229;
i__33214_33218 = G__33230;
continue;
} else {
var line_33231 = cljs.core.first.call(null,seq__33211_33225__$1);
markdown.links.parse_footnote_link.call(null,line_33231,footnotes);

var G__33232 = cljs.core.next.call(null,seq__33211_33225__$1);
var G__33233 = null;
var G__33234 = (0);
var G__33235 = (0);
seq__33211_33215 = G__33232;
chunk__33212_33216 = G__33233;
count__33213_33217 = G__33234;
i__33214_33218 = G__33235;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref.call(null,footnotes);
});
markdown.core.parse_metadata = (function markdown$core$parse_metadata(lines){
var vec__33237 = cljs.core.split_with.call(null,(function (p1__33236_SHARP_){
return cljs.core.not_empty.call(null,p1__33236_SHARP_.trim());
}),lines);
var metadata = cljs.core.nth.call(null,vec__33237,(0),null);
var lines__$1 = cljs.core.nth.call(null,vec__33237,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [markdown.transformers.parse_metadata_headers.call(null,metadata),lines__$1], null);
});
/**
 * processes input text line by line and outputs an HTML string
 */
markdown.core.md_to_html_string_STAR_ = (function markdown$core$md_to_html_string_STAR_(text,params){
var _STAR_substring_STAR_33240 = markdown.common._STAR_substring_STAR_;
var _STAR_formatter_STAR_33241 = markdown.transformers._STAR_formatter_STAR_;
markdown.common._STAR_substring_STAR_ = ((function (_STAR_substring_STAR_33240,_STAR_formatter_STAR_33241){
return (function (s,n){
return cljs.core.apply.call(null,cljs.core.str,cljs.core.drop.call(null,n,s));
});})(_STAR_substring_STAR_33240,_STAR_formatter_STAR_33241))
;

markdown.transformers._STAR_formatter_STAR_ = markdown.core.format;

try{var params__$1 = (cljs.core.truth_(params)?cljs.core.apply.call(null,cljs.core.partial.call(null,cljs.core.assoc,cljs.core.PersistentArrayMap.EMPTY),params):null);
var lines = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text),"\n"].join('').split("\n");
var html = (new goog.string.StringBuffer(""));
var references = (cljs.core.truth_(new cljs.core.Keyword(null,"reference-links?","reference-links?",-2003778981).cljs$core$IFn$_invoke$arity$1(params__$1))?markdown.core.parse_references.call(null,lines):null);
var footnotes = (cljs.core.truth_(new cljs.core.Keyword(null,"footnotes?","footnotes?",-1590157845).cljs$core$IFn$_invoke$arity$1(params__$1))?markdown.core.parse_footnotes.call(null,lines):null);
var vec__33242 = (cljs.core.truth_(new cljs.core.Keyword(null,"parse-meta?","parse-meta?",-1938948742).cljs$core$IFn$_invoke$arity$1(params__$1))?markdown.core.parse_metadata.call(null,lines):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,lines], null));
var metadata = cljs.core.nth.call(null,vec__33242,(0),null);
var lines__$1 = cljs.core.nth.call(null,vec__33242,(1),null);
var transformer = markdown.core.init_transformer.call(null,params__$1);
var G__33248_33255 = lines__$1;
var vec__33249_33256 = G__33248_33255;
var seq__33250_33257 = cljs.core.seq.call(null,vec__33249_33256);
var first__33251_33258 = cljs.core.first.call(null,seq__33250_33257);
var seq__33250_33259__$1 = cljs.core.next.call(null,seq__33250_33257);
var line_33260 = first__33251_33258;
var more_33261 = seq__33250_33259__$1;
var state_33262 = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"clojurescript","clojurescript",-299769403),true,new cljs.core.Keyword(null,"references","references",882562509),references,new cljs.core.Keyword(null,"footnotes","footnotes",-1842778205),footnotes,new cljs.core.Keyword(null,"last-line-empty?","last-line-empty?",1279111527),true], null),params__$1);
var G__33248_33263__$1 = G__33248_33255;
var state_33264__$1 = state_33262;
while(true){
var vec__33252_33265 = G__33248_33263__$1;
var seq__33253_33266 = cljs.core.seq.call(null,vec__33252_33265);
var first__33254_33267 = cljs.core.first.call(null,seq__33253_33266);
var seq__33253_33268__$1 = cljs.core.next.call(null,seq__33253_33266);
var line_33269__$1 = first__33254_33267;
var more_33270__$1 = seq__33253_33268__$1;
var state_33271__$2 = state_33264__$1;
var line_33272__$2 = (cljs.core.truth_(new cljs.core.Keyword(null,"skip-next-line?","skip-next-line?",1683617749).cljs$core$IFn$_invoke$arity$1(state_33271__$2))?"":line_33269__$1);
var state_33273__$3 = (cljs.core.truth_(new cljs.core.Keyword(null,"buf","buf",-213913340).cljs$core$IFn$_invoke$arity$1(state_33271__$2))?transformer.call(null,html,new cljs.core.Keyword(null,"buf","buf",-213913340).cljs$core$IFn$_invoke$arity$1(state_33271__$2),new cljs.core.Keyword(null,"next-line","next-line",-1187000287).cljs$core$IFn$_invoke$arity$1(state_33271__$2),cljs.core.assoc.call(null,cljs.core.dissoc.call(null,state_33271__$2,new cljs.core.Keyword(null,"buf","buf",-213913340),new cljs.core.Keyword(null,"lists","lists",-884730684),new cljs.core.Keyword(null,"next-line","next-line",-1187000287)),new cljs.core.Keyword(null,"last-line-empty?","last-line-empty?",1279111527),true)):state_33271__$2);
if(cljs.core.truth_(cljs.core.not_empty.call(null,more_33270__$1))){
var G__33274 = more_33270__$1;
var G__33275 = cljs.core.assoc.call(null,transformer.call(null,html,line_33272__$2,cljs.core.first.call(null,more_33270__$1),cljs.core.dissoc.call(null,state_33273__$3,new cljs.core.Keyword(null,"skip-next-line?","skip-next-line?",1683617749))),new cljs.core.Keyword(null,"last-line-empty?","last-line-empty?",1279111527),cljs.core.empty_QMARK_.call(null,line_33272__$2));
G__33248_33263__$1 = G__33274;
state_33264__$1 = G__33275;
continue;
} else {
transformer.call(null,html.append(markdown.transformers.footer.call(null,new cljs.core.Keyword(null,"footnotes","footnotes",-1842778205).cljs$core$IFn$_invoke$arity$1(state_33273__$3))),line_33272__$2,"",cljs.core.assoc.call(null,state_33273__$3,new cljs.core.Keyword(null,"eof","eof",-489063237),true));
}
break;
}

return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"metadata","metadata",1799301597),metadata,new cljs.core.Keyword(null,"html","html",-998796897),html.toString()], null);
}finally {markdown.transformers._STAR_formatter_STAR_ = _STAR_formatter_STAR_33241;

markdown.common._STAR_substring_STAR_ = _STAR_substring_STAR_33240;
}});
markdown.core.md__GT_html = (function markdown$core$md__GT_html(var_args){
var args__9364__auto__ = [];
var len__9357__auto___33278 = arguments.length;
var i__9358__auto___33279 = (0);
while(true){
if((i__9358__auto___33279 < len__9357__auto___33278)){
args__9364__auto__.push((arguments[i__9358__auto___33279]));

var G__33280 = (i__9358__auto___33279 + (1));
i__9358__auto___33279 = G__33280;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((1) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((1)),(0),null)):null);
return markdown.core.md__GT_html.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9365__auto__);
});

markdown.core.md__GT_html.cljs$core$IFn$_invoke$arity$variadic = (function (text,params){
return new cljs.core.Keyword(null,"html","html",-998796897).cljs$core$IFn$_invoke$arity$1(markdown.core.md_to_html_string_STAR_.call(null,text,params));
});

markdown.core.md__GT_html.cljs$lang$maxFixedArity = (1);

markdown.core.md__GT_html.cljs$lang$applyTo = (function (seq33276){
var G__33277 = cljs.core.first.call(null,seq33276);
var seq33276__$1 = cljs.core.next.call(null,seq33276);
return markdown.core.md__GT_html.cljs$core$IFn$_invoke$arity$variadic(G__33277,seq33276__$1);
});

markdown.core.md__GT_html_with_meta = (function markdown$core$md__GT_html_with_meta(var_args){
var args__9364__auto__ = [];
var len__9357__auto___33283 = arguments.length;
var i__9358__auto___33284 = (0);
while(true){
if((i__9358__auto___33284 < len__9357__auto___33283)){
args__9364__auto__.push((arguments[i__9358__auto___33284]));

var G__33285 = (i__9358__auto___33284 + (1));
i__9358__auto___33284 = G__33285;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((1) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((1)),(0),null)):null);
return markdown.core.md__GT_html_with_meta.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9365__auto__);
});

markdown.core.md__GT_html_with_meta.cljs$core$IFn$_invoke$arity$variadic = (function (text,params){
return markdown.core.md_to_html_string_STAR_.call(null,text,cljs.core.into.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"parse-meta?","parse-meta?",-1938948742),true], null),params));
});

markdown.core.md__GT_html_with_meta.cljs$lang$maxFixedArity = (1);

markdown.core.md__GT_html_with_meta.cljs$lang$applyTo = (function (seq33281){
var G__33282 = cljs.core.first.call(null,seq33281);
var seq33281__$1 = cljs.core.next.call(null,seq33281);
return markdown.core.md__GT_html_with_meta.cljs$core$IFn$_invoke$arity$variadic(G__33282,seq33281__$1);
});

/**
 * Js accessible wrapper
 */
markdown.core.mdToHtml = (function markdown$core$mdToHtml(var_args){
var args__9364__auto__ = [];
var len__9357__auto___33287 = arguments.length;
var i__9358__auto___33288 = (0);
while(true){
if((i__9358__auto___33288 < len__9357__auto___33287)){
args__9364__auto__.push((arguments[i__9358__auto___33288]));

var G__33289 = (i__9358__auto___33288 + (1));
i__9358__auto___33288 = G__33289;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((0) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((0)),(0),null)):null);
return markdown.core.mdToHtml.cljs$core$IFn$_invoke$arity$variadic(argseq__9365__auto__);
});
goog.exportSymbol('markdown.core.mdToHtml', markdown.core.mdToHtml);

markdown.core.mdToHtml.cljs$core$IFn$_invoke$arity$variadic = (function (params){
return cljs.core.apply.call(null,markdown.core.md__GT_html,params);
});

markdown.core.mdToHtml.cljs$lang$maxFixedArity = (0);

markdown.core.mdToHtml.cljs$lang$applyTo = (function (seq33286){
return markdown.core.mdToHtml.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq33286));
});

/**
 * Js accessible wrapper
 */
markdown.core.mdToHtmlWithMeta = (function markdown$core$mdToHtmlWithMeta(var_args){
var args__9364__auto__ = [];
var len__9357__auto___33291 = arguments.length;
var i__9358__auto___33292 = (0);
while(true){
if((i__9358__auto___33292 < len__9357__auto___33291)){
args__9364__auto__.push((arguments[i__9358__auto___33292]));

var G__33293 = (i__9358__auto___33292 + (1));
i__9358__auto___33292 = G__33293;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((0) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((0)),(0),null)):null);
return markdown.core.mdToHtmlWithMeta.cljs$core$IFn$_invoke$arity$variadic(argseq__9365__auto__);
});
goog.exportSymbol('markdown.core.mdToHtmlWithMeta', markdown.core.mdToHtmlWithMeta);

markdown.core.mdToHtmlWithMeta.cljs$core$IFn$_invoke$arity$variadic = (function (params){
return cljs.core.apply.call(null,markdown.core.md__GT_html_with_meta,params);
});

markdown.core.mdToHtmlWithMeta.cljs$lang$maxFixedArity = (0);

markdown.core.mdToHtmlWithMeta.cljs$lang$applyTo = (function (seq33290){
return markdown.core.mdToHtmlWithMeta.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq33290));
});

