// Compiled by ClojureScript 1.9.946 {}
goog.provide('cljs.core$macros');
goog.require('cljs.core');
goog.require('clojure.walk');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('cljs.compiler');
goog.require('cljs.env');
goog.require('cljs.core');
goog.require('cljs.analyzer');
var ret__9397__auto___36096 = (function (){
/**
 * Threads the expr through the forms. Inserts x as the
 *   second item in the first form, making a list of it if it is not a
 *   list already. If there are more forms, inserts the first form as the
 *   second item in second form, etc.
 */
cljs.core$macros.__GT_ = (function cljs$core$macros$__GT_(var_args){
var args__9364__auto__ = [];
var len__9357__auto___36097 = arguments.length;
var i__9358__auto___36098 = (0);
while(true){
if((i__9358__auto___36098 < len__9357__auto___36097)){
args__9364__auto__.push((arguments[i__9358__auto___36098]));

var G__36099 = (i__9358__auto___36098 + (1));
i__9358__auto___36098 = G__36099;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((3) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9365__auto__);
});

cljs.core$macros.__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,forms){
var x__$1 = x;
var forms__$1 = forms;
while(true){
if(cljs.core.truth_(forms__$1)){
var form = cljs.core.first.call(null,forms__$1);
var threaded = ((cljs.core.seq_QMARK_.call(null,form))?cljs.core.with_meta.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = cljs.core.first.call(null,form);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = x__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core.next.call(null,form)))),cljs.core.meta.call(null,form)):(function (){var x__9048__auto__ = form;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = x__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})());
var G__36100 = threaded;
var G__36101 = cljs.core.next.call(null,forms__$1);
x__$1 = G__36100;
forms__$1 = G__36101;
continue;
} else {
return x__$1;
}
break;
}
});

cljs.core$macros.__GT_.cljs$lang$maxFixedArity = (3);

cljs.core$macros.__GT_.cljs$lang$applyTo = (function (seq36092){
var G__36093 = cljs.core.first.call(null,seq36092);
var seq36092__$1 = cljs.core.next.call(null,seq36092);
var G__36094 = cljs.core.first.call(null,seq36092__$1);
var seq36092__$2 = cljs.core.next.call(null,seq36092__$1);
var G__36095 = cljs.core.first.call(null,seq36092__$2);
var seq36092__$3 = cljs.core.next.call(null,seq36092__$2);
return cljs.core$macros.__GT_.cljs$core$IFn$_invoke$arity$variadic(G__36093,G__36094,G__36095,seq36092__$3);
});

return null;
})()
;
cljs.core$macros.__GT_.cljs$lang$macro = true;

var ret__9397__auto___36106 = (function (){
/**
 * Threads the expr through the forms. Inserts x as the
 *   last item in the first form, making a list of it if it is not a
 *   list already. If there are more forms, inserts the first form as the
 *   last item in second form, etc.
 */
cljs.core$macros.__GT__GT_ = (function cljs$core$macros$__GT__GT_(var_args){
var args__9364__auto__ = [];
var len__9357__auto___36107 = arguments.length;
var i__9358__auto___36108 = (0);
while(true){
if((i__9358__auto___36108 < len__9357__auto___36107)){
args__9364__auto__.push((arguments[i__9358__auto___36108]));

var G__36109 = (i__9358__auto___36108 + (1));
i__9358__auto___36108 = G__36109;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((3) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.__GT__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9365__auto__);
});

cljs.core$macros.__GT__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,forms){
var x__$1 = x;
var forms__$1 = forms;
while(true){
if(cljs.core.truth_(forms__$1)){
var form = cljs.core.first.call(null,forms__$1);
var threaded = ((cljs.core.seq_QMARK_.call(null,form))?cljs.core.with_meta.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = cljs.core.first.call(null,form);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core.next.call(null,form),(function (){var x__9048__auto__ = x__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))),cljs.core.meta.call(null,form)):(function (){var x__9048__auto__ = form;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = x__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})());
var G__36110 = threaded;
var G__36111 = cljs.core.next.call(null,forms__$1);
x__$1 = G__36110;
forms__$1 = G__36111;
continue;
} else {
return x__$1;
}
break;
}
});

cljs.core$macros.__GT__GT_.cljs$lang$maxFixedArity = (3);

cljs.core$macros.__GT__GT_.cljs$lang$applyTo = (function (seq36102){
var G__36103 = cljs.core.first.call(null,seq36102);
var seq36102__$1 = cljs.core.next.call(null,seq36102);
var G__36104 = cljs.core.first.call(null,seq36102__$1);
var seq36102__$2 = cljs.core.next.call(null,seq36102__$1);
var G__36105 = cljs.core.first.call(null,seq36102__$2);
var seq36102__$3 = cljs.core.next.call(null,seq36102__$2);
return cljs.core$macros.__GT__GT_.cljs$core$IFn$_invoke$arity$variadic(G__36103,G__36104,G__36105,seq36102__$3);
});

return null;
})()
;
cljs.core$macros.__GT__GT_.cljs$lang$macro = true;

var ret__9397__auto___36119 = (function (){
/**
 * form => fieldName-symbol or (instanceMethodName-symbol args*)
 * 
 *   Expands into a member access (.) of the first member on the first
 *   argument, followed by the next member on the result, etc. For
 *   instance:
 * 
 *   (.. System (getProperties) (get "os.name"))
 * 
 *   expands to:
 * 
 *   (. (. System (getProperties)) (get "os.name"))
 * 
 *   but is easier to write, read, and understand.
 */
cljs.core$macros._DOT__DOT_ = (function cljs$core$macros$_DOT__DOT_(var_args){
var G__36118 = arguments.length;
switch (G__36118) {
case 4:
return cljs.core$macros._DOT__DOT_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__9376__auto__ = [];
var len__9357__auto___36121 = arguments.length;
var i__9358__auto___36122 = (0);
while(true){
if((i__9358__auto___36122 < len__9357__auto___36121)){
args_arr__9376__auto__.push((arguments[i__9358__auto___36122]));

var G__36123 = (i__9358__auto___36122 + (1));
i__9358__auto___36122 = G__36123;
continue;
} else {
}
break;
}

var argseq__9377__auto__ = (new cljs.core.IndexedSeq(args_arr__9376__auto__.slice((4)),(0),null));
return cljs.core$macros._DOT__DOT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__9377__auto__);

}
});

cljs.core$macros._DOT__DOT_.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,x,form){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = form;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros._DOT__DOT_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,form,more){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"..","..",-300507420,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = form;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),more)));
});

cljs.core$macros._DOT__DOT_.cljs$lang$applyTo = (function (seq36113){
var G__36114 = cljs.core.first.call(null,seq36113);
var seq36113__$1 = cljs.core.next.call(null,seq36113);
var G__36115 = cljs.core.first.call(null,seq36113__$1);
var seq36113__$2 = cljs.core.next.call(null,seq36113__$1);
var G__36116 = cljs.core.first.call(null,seq36113__$2);
var seq36113__$3 = cljs.core.next.call(null,seq36113__$2);
var G__36117 = cljs.core.first.call(null,seq36113__$3);
var seq36113__$4 = cljs.core.next.call(null,seq36113__$3);
return cljs.core$macros._DOT__DOT_.cljs$core$IFn$_invoke$arity$variadic(G__36114,G__36115,G__36116,G__36117,seq36113__$4);
});

cljs.core$macros._DOT__DOT_.cljs$lang$maxFixedArity = (4);

return null;
})()
;
cljs.core$macros._DOT__DOT_.cljs$lang$macro = true;

var ret__9397__auto___36127 = (function (){
/**
 * Ignores body, yields nil
 */
cljs.core$macros.comment = (function cljs$core$macros$comment(var_args){
var args__9364__auto__ = [];
var len__9357__auto___36128 = arguments.length;
var i__9358__auto___36129 = (0);
while(true){
if((i__9358__auto___36129 < len__9357__auto___36128)){
args__9364__auto__.push((arguments[i__9358__auto___36129]));

var G__36130 = (i__9358__auto___36129 + (1));
i__9358__auto___36129 = G__36130;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((2) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.comment.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9365__auto__);
});

cljs.core$macros.comment.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,body){
return null;
});

cljs.core$macros.comment.cljs$lang$maxFixedArity = (2);

cljs.core$macros.comment.cljs$lang$applyTo = (function (seq36124){
var G__36125 = cljs.core.first.call(null,seq36124);
var seq36124__$1 = cljs.core.next.call(null,seq36124);
var G__36126 = cljs.core.first.call(null,seq36124__$1);
var seq36124__$2 = cljs.core.next.call(null,seq36124__$1);
return cljs.core$macros.comment.cljs$core$IFn$_invoke$arity$variadic(G__36125,G__36126,seq36124__$2);
});

return null;
})()
;
cljs.core$macros.comment.cljs$lang$macro = true;

var ret__9397__auto___36134 = (function (){
/**
 * Takes a set of test/expr pairs. It evaluates each test one at a
 *   time.  If a test returns logical true, cond evaluates and returns
 *   the value of the corresponding expr and doesn't evaluate any of the
 *   other tests or exprs. (cond) returns nil.
 */
cljs.core$macros.cond = (function cljs$core$macros$cond(var_args){
var args__9364__auto__ = [];
var len__9357__auto___36135 = arguments.length;
var i__9358__auto___36136 = (0);
while(true){
if((i__9358__auto___36136 < len__9357__auto___36135)){
args__9364__auto__.push((arguments[i__9358__auto___36136]));

var G__36137 = (i__9358__auto___36136 + (1));
i__9358__auto___36136 = G__36137;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((2) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.cond.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9365__auto__);
});

cljs.core$macros.cond.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,clauses){
if(cljs.core.truth_(clauses)){
return cljs.core._conj.call(null,(function (){var x__9048__auto__ = cljs.core.first.call(null,clauses);
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = ((cljs.core.next.call(null,clauses))?cljs.core.second.call(null,clauses):(function(){throw (new Error("cond requires an even number of forms"))})());
return cljs.core._conj.call(null,(function (){var x__9048__auto____$2 = cljs.core.cons.call(null,new cljs.core.Symbol("cljs.core","cond","cljs.core/cond",2005388338,null),cljs.core.next.call(null,cljs.core.next.call(null,clauses)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$2);
})(),x__9048__auto____$1);
})(),x__9048__auto__);
})(),new cljs.core.Symbol(null,"if","if",1181717262,null));
} else {
return null;
}
});

cljs.core$macros.cond.cljs$lang$maxFixedArity = (2);

cljs.core$macros.cond.cljs$lang$applyTo = (function (seq36131){
var G__36132 = cljs.core.first.call(null,seq36131);
var seq36131__$1 = cljs.core.next.call(null,seq36131);
var G__36133 = cljs.core.first.call(null,seq36131__$1);
var seq36131__$2 = cljs.core.next.call(null,seq36131__$1);
return cljs.core$macros.cond.cljs$core$IFn$_invoke$arity$variadic(G__36132,G__36133,seq36131__$2);
});

return null;
})()
;
cljs.core$macros.cond.cljs$lang$macro = true;

var ret__9397__auto___36142 = (function (){
/**
 * defs the supplied var names with no bindings, useful for making forward declarations.
 */
cljs.core$macros.declare = (function cljs$core$macros$declare(var_args){
var args__9364__auto__ = [];
var len__9357__auto___36143 = arguments.length;
var i__9358__auto___36144 = (0);
while(true){
if((i__9358__auto___36144 < len__9357__auto___36143)){
args__9364__auto__.push((arguments[i__9358__auto___36144]));

var G__36145 = (i__9358__auto___36144 + (1));
i__9358__auto___36144 = G__36145;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((2) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.declare.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9365__auto__);
});

cljs.core$macros.declare.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,names){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),cljs.core.map.call(null,(function (p1__36138_SHARP_){
return cljs.core._conj.call(null,(function (){var x__9048__auto__ = cljs.core.vary_meta.call(null,p1__36138_SHARP_,cljs.core.assoc,new cljs.core.Keyword(null,"declared","declared",92336021),true);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),new cljs.core.Symbol(null,"def","def",597100991,null));
}),names))));
});

cljs.core$macros.declare.cljs$lang$maxFixedArity = (2);

cljs.core$macros.declare.cljs$lang$applyTo = (function (seq36139){
var G__36140 = cljs.core.first.call(null,seq36139);
var seq36139__$1 = cljs.core.next.call(null,seq36139);
var G__36141 = cljs.core.first.call(null,seq36139__$1);
var seq36139__$2 = cljs.core.next.call(null,seq36139__$1);
return cljs.core$macros.declare.cljs$core$IFn$_invoke$arity$variadic(G__36140,G__36141,seq36139__$2);
});

return null;
})()
;
cljs.core$macros.declare.cljs$lang$macro = true;

var ret__9397__auto___36150 = (function (){
/**
 * Evaluates x then calls all of the methods and functions with the
 *   value of x supplied at the front of the given arguments.  The forms
 *   are evaluated in order.  Returns x.
 * 
 *   (doto (new java.util.HashMap) (.put "a" 1) (.put "b" 2))
 */
cljs.core$macros.doto = (function cljs$core$macros$doto(var_args){
var args__9364__auto__ = [];
var len__9357__auto___36151 = arguments.length;
var i__9358__auto___36152 = (0);
while(true){
if((i__9358__auto___36152 < len__9357__auto___36151)){
args__9364__auto__.push((arguments[i__9358__auto___36152]));

var G__36153 = (i__9358__auto___36152 + (1));
i__9358__auto___36152 = G__36153;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((3) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.doto.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9365__auto__);
});

cljs.core$macros.doto.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,forms){
var gx = cljs.core.gensym.call(null);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = gx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core.map.call(null,((function (gx){
return (function (f){
if(cljs.core.seq_QMARK_.call(null,f)){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = cljs.core.first.call(null,f);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = gx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core.next.call(null,f))));
} else {
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = f;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = gx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
}
});})(gx))
,forms),(function (){var x__9048__auto__ = gx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros.doto.cljs$lang$maxFixedArity = (3);

cljs.core$macros.doto.cljs$lang$applyTo = (function (seq36146){
var G__36147 = cljs.core.first.call(null,seq36146);
var seq36146__$1 = cljs.core.next.call(null,seq36146);
var G__36148 = cljs.core.first.call(null,seq36146__$1);
var seq36146__$2 = cljs.core.next.call(null,seq36146__$1);
var G__36149 = cljs.core.first.call(null,seq36146__$2);
var seq36146__$3 = cljs.core.next.call(null,seq36146__$2);
return cljs.core$macros.doto.cljs$core$IFn$_invoke$arity$variadic(G__36147,G__36148,G__36149,seq36146__$3);
});

return null;
})()
;
cljs.core$macros.doto.cljs$lang$macro = true;

cljs.core$macros.parse_impls = (function cljs$core$macros$parse_impls(specs){
var ret = cljs.core.PersistentArrayMap.EMPTY;
var s = specs;
while(true){
if(cljs.core.seq.call(null,s)){
var G__36154 = cljs.core.assoc.call(null,ret,cljs.core.first.call(null,s),cljs.core.take_while.call(null,cljs.core.seq_QMARK_,cljs.core.next.call(null,s)));
var G__36155 = cljs.core.drop_while.call(null,cljs.core.seq_QMARK_,cljs.core.next.call(null,s));
ret = G__36154;
s = G__36155;
continue;
} else {
return ret;
}
break;
}
});
cljs.core$macros.emit_extend_protocol = (function cljs$core$macros$emit_extend_protocol(p,specs){
var impls = cljs.core$macros.parse_impls.call(null,specs);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),cljs.core.map.call(null,((function (impls){
return (function (p__36156){
var vec__36157 = p__36156;
var t = cljs.core.nth.call(null,vec__36157,(0),null);
var fs = cljs.core.nth.call(null,vec__36157,(1),null);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","extend-type","cljs.core$macros/extend-type",1713295201,null)),(function (){var x__9048__auto__ = t;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = p;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),fs)));
});})(impls))
,impls))));
});
var ret__9397__auto___36164 = (function (){
/**
 * Useful when you want to provide several implementations of the same
 *   protocol all at once. Takes a single protocol and the implementation
 *   of that protocol for one or more types. Expands into calls to
 *   extend-type:
 * 
 *   (extend-protocol Protocol
 *     AType
 *       (foo [x] ...)
 *       (bar [x y] ...)
 *     BType
 *       (foo [x] ...)
 *       (bar [x y] ...)
 *     AClass
 *       (foo [x] ...)
 *       (bar [x y] ...)
 *     nil
 *       (foo [x] ...)
 *       (bar [x y] ...))
 * 
 *   expands into:
 * 
 *   (do
 *    (clojure.core/extend-type AType Protocol
 *      (foo [x] ...)
 *      (bar [x y] ...))
 *    (clojure.core/extend-type BType Protocol
 *      (foo [x] ...)
 *      (bar [x y] ...))
 *    (clojure.core/extend-type AClass Protocol
 *      (foo [x] ...)
 *      (bar [x y] ...))
 *    (clojure.core/extend-type nil Protocol
 *      (foo [x] ...)
 *      (bar [x y] ...)))
 */
cljs.core$macros.extend_protocol = (function cljs$core$macros$extend_protocol(var_args){
var args__9364__auto__ = [];
var len__9357__auto___36165 = arguments.length;
var i__9358__auto___36166 = (0);
while(true){
if((i__9358__auto___36166 < len__9357__auto___36165)){
args__9364__auto__.push((arguments[i__9358__auto___36166]));

var G__36167 = (i__9358__auto___36166 + (1));
i__9358__auto___36166 = G__36167;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((3) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.extend_protocol.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9365__auto__);
});

cljs.core$macros.extend_protocol.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,p,specs){
return cljs.core$macros.emit_extend_protocol.call(null,p,specs);
});

cljs.core$macros.extend_protocol.cljs$lang$maxFixedArity = (3);

cljs.core$macros.extend_protocol.cljs$lang$applyTo = (function (seq36160){
var G__36161 = cljs.core.first.call(null,seq36160);
var seq36160__$1 = cljs.core.next.call(null,seq36160);
var G__36162 = cljs.core.first.call(null,seq36160__$1);
var seq36160__$2 = cljs.core.next.call(null,seq36160__$1);
var G__36163 = cljs.core.first.call(null,seq36160__$2);
var seq36160__$3 = cljs.core.next.call(null,seq36160__$2);
return cljs.core$macros.extend_protocol.cljs$core$IFn$_invoke$arity$variadic(G__36161,G__36162,G__36163,seq36160__$3);
});

return null;
})()
;
cljs.core$macros.extend_protocol.cljs$lang$macro = true;

cljs.core$macros.maybe_destructured = (function cljs$core$macros$maybe_destructured(params,body){
if(cljs.core.every_QMARK_.call(null,cljs.core.symbol_QMARK_,params)){
return cljs.core.cons.call(null,params,body);
} else {
var params__$1 = params;
var new_params = cljs.core.with_meta.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.meta.call(null,params__$1));
var lets = cljs.core.PersistentVector.EMPTY;
while(true){
if(cljs.core.truth_(params__$1)){
if((cljs.core.first.call(null,params__$1) instanceof cljs.core.Symbol)){
var G__36168 = cljs.core.next.call(null,params__$1);
var G__36169 = cljs.core.conj.call(null,new_params,cljs.core.first.call(null,params__$1));
var G__36170 = lets;
params__$1 = G__36168;
new_params = G__36169;
lets = G__36170;
continue;
} else {
var gparam = cljs.core.gensym.call(null,"p__");
var G__36171 = cljs.core.next.call(null,params__$1);
var G__36172 = cljs.core.conj.call(null,new_params,gparam);
var G__36173 = cljs.core.conj.call(null,cljs.core.conj.call(null,lets,cljs.core.first.call(null,params__$1)),gparam);
params__$1 = G__36171;
new_params = G__36172;
lets = G__36173;
continue;
}
} else {
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = new_params;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = lets;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),body)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
}
break;
}
}
});
var ret__9397__auto___36180 = (function (){
/**
 * params => positional-params* , or positional-params* & next-param
 *   positional-param => binding-form
 *   next-param => binding-form
 *   name => symbol
 * 
 *   Defines a function
 */
cljs.core$macros.fn = (function cljs$core$macros$fn(var_args){
var args__9364__auto__ = [];
var len__9357__auto___36181 = arguments.length;
var i__9358__auto___36182 = (0);
while(true){
if((i__9358__auto___36182 < len__9357__auto___36181)){
args__9364__auto__.push((arguments[i__9358__auto___36182]));

var G__36183 = (i__9358__auto___36182 + (1));
i__9358__auto___36182 = G__36183;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((2) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.fn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9365__auto__);
});

cljs.core$macros.fn.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,sigs){
var name = (((cljs.core.first.call(null,sigs) instanceof cljs.core.Symbol))?cljs.core.first.call(null,sigs):null);
var sigs__$1 = (cljs.core.truth_(name)?cljs.core.next.call(null,sigs):sigs);
var sigs__$2 = ((cljs.core.vector_QMARK_.call(null,cljs.core.first.call(null,sigs__$1)))?(function (){var x__9048__auto__ = sigs__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})():((cljs.core.seq_QMARK_.call(null,cljs.core.first.call(null,sigs__$1)))?sigs__$1:(function(){throw (new Error(((cljs.core.seq.call(null,sigs__$1))?["Parameter declaration ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,sigs__$1))," should be a vector"].join(''):["Parameter declaration missing"].join(''))))})()));
var psig = ((function (name,sigs__$1,sigs__$2){
return (function (sig){
if(!(cljs.core.seq_QMARK_.call(null,sig))){
throw (new Error(["Invalid signature ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(sig)," should be a list"].join('')));
} else {
}

var vec__36177 = sig;
var seq__36178 = cljs.core.seq.call(null,vec__36177);
var first__36179 = cljs.core.first.call(null,seq__36178);
var seq__36178__$1 = cljs.core.next.call(null,seq__36178);
var params = first__36179;
var body = seq__36178__$1;
var _ = ((!(cljs.core.vector_QMARK_.call(null,params)))?(function(){throw (new Error(((cljs.core.seq_QMARK_.call(null,cljs.core.first.call(null,sigs__$2)))?["Parameter declaration ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(params)," should be a vector"].join(''):["Invalid signature ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(sig)," should be a list"].join(''))))})():null);
var conds = (((cljs.core.next.call(null,body)) && (cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))))?cljs.core.first.call(null,body):null);
var body__$1 = (cljs.core.truth_(conds)?cljs.core.next.call(null,body):body);
var conds__$1 = (function (){var or__8186__auto__ = conds;
if(cljs.core.truth_(or__8186__auto__)){
return or__8186__auto__;
} else {
return cljs.core.meta.call(null,params);
}
})();
var pre = new cljs.core.Keyword(null,"pre","pre",2118456869).cljs$core$IFn$_invoke$arity$1(conds__$1);
var post = new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(conds__$1);
var body__$2 = (cljs.core.truth_(post)?cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"%","%",-950237169,null)),(function (){var x__9048__auto__ = ((((1) < cljs.core.count.call(null,body__$1)))?cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),body__$1))):cljs.core.first.call(null,body__$1));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core.map.call(null,((function (vec__36177,seq__36178,first__36179,seq__36178__$1,params,body,_,conds,body__$1,conds__$1,pre,post,name,sigs__$1,sigs__$2){
return (function (c){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","assert","cljs.core$macros/assert",1333198789,null)),(function (){var x__9048__auto__ = c;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});})(vec__36177,seq__36178,first__36179,seq__36178__$1,params,body,_,conds,body__$1,conds__$1,pre,post,name,sigs__$1,sigs__$2))
,post),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"%","%",-950237169,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))):body__$1);
var body__$3 = (cljs.core.truth_(pre)?cljs.core.concat.call(null,cljs.core.map.call(null,((function (vec__36177,seq__36178,first__36179,seq__36178__$1,params,body,_,conds,body__$1,conds__$1,pre,post,body__$2,name,sigs__$1,sigs__$2){
return (function (c){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","assert","cljs.core$macros/assert",1333198789,null)),(function (){var x__9048__auto__ = c;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});})(vec__36177,seq__36178,first__36179,seq__36178__$1,params,body,_,conds,body__$1,conds__$1,pre,post,body__$2,name,sigs__$1,sigs__$2))
,pre),body__$2):body__$2);
return cljs.core$macros.maybe_destructured.call(null,params,body__$3);
});})(name,sigs__$1,sigs__$2))
;
var new_sigs = cljs.core.map.call(null,psig,sigs__$2);
return cljs.core.with_meta.call(null,(cljs.core.truth_(name)?cljs.core.list_STAR_.call(null,new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),name,new_sigs):cljs.core.cons.call(null,new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new_sigs)),cljs.core.meta.call(null,_AMPERSAND_form));
});

cljs.core$macros.fn.cljs$lang$maxFixedArity = (2);

cljs.core$macros.fn.cljs$lang$applyTo = (function (seq36174){
var G__36175 = cljs.core.first.call(null,seq36174);
var seq36174__$1 = cljs.core.next.call(null,seq36174);
var G__36176 = cljs.core.first.call(null,seq36174__$1);
var seq36174__$2 = cljs.core.next.call(null,seq36174__$1);
return cljs.core$macros.fn.cljs$core$IFn$_invoke$arity$variadic(G__36175,G__36176,seq36174__$2);
});

return null;
})()
;
cljs.core$macros.fn.cljs$lang$macro = true;

var ret__9397__auto___36188 = (function (){
/**
 * same as defn, yielding non-public def
 */
cljs.core$macros.defn_ = (function cljs$core$macros$defn_(var_args){
var args__9364__auto__ = [];
var len__9357__auto___36189 = arguments.length;
var i__9358__auto___36190 = (0);
while(true){
if((i__9358__auto___36190 < len__9357__auto___36189)){
args__9364__auto__.push((arguments[i__9358__auto___36190]));

var G__36191 = (i__9358__auto___36190 + (1));
i__9358__auto___36190 = G__36191;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((3) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.defn_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9365__auto__);
});

cljs.core$macros.defn_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,name,decls){
return cljs.core.list_STAR_.call(null,new cljs.core.Symbol("cljs.core$macros","defn","cljs.core$macros/defn",-728332354,null),cljs.core.with_meta.call(null,name,cljs.core.assoc.call(null,cljs.core.meta.call(null,name),new cljs.core.Keyword(null,"private","private",-558947994),true)),decls);
});

cljs.core$macros.defn_.cljs$lang$maxFixedArity = (3);

cljs.core$macros.defn_.cljs$lang$applyTo = (function (seq36184){
var G__36185 = cljs.core.first.call(null,seq36184);
var seq36184__$1 = cljs.core.next.call(null,seq36184);
var G__36186 = cljs.core.first.call(null,seq36184__$1);
var seq36184__$2 = cljs.core.next.call(null,seq36184__$1);
var G__36187 = cljs.core.first.call(null,seq36184__$2);
var seq36184__$3 = cljs.core.next.call(null,seq36184__$2);
return cljs.core$macros.defn_.cljs$core$IFn$_invoke$arity$variadic(G__36185,G__36186,G__36187,seq36184__$3);
});

return null;
})()
;
cljs.core$macros.defn_.cljs$lang$macro = true;

var ret__9397__auto___36201 = (function (){
/**
 * bindings => binding-form test
 * 
 *   If test is true, evaluates then with binding-form bound to the value of
 *   test, if not, yields else
 */
cljs.core$macros.if_let = (function cljs$core$macros$if_let(var_args){
var G__36200 = arguments.length;
switch (G__36200) {
case 4:
return cljs.core$macros.if_let.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__9376__auto__ = [];
var len__9357__auto___36203 = arguments.length;
var i__9358__auto___36204 = (0);
while(true){
if((i__9358__auto___36204 < len__9357__auto___36203)){
args_arr__9376__auto__.push((arguments[i__9358__auto___36204]));

var G__36205 = (i__9358__auto___36204 + (1));
i__9358__auto___36204 = G__36205;
continue;
} else {
}
break;
}

var argseq__9377__auto__ = (new cljs.core.IndexedSeq(args_arr__9376__auto__.slice((5)),(0),null));
return cljs.core$macros.if_let.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__9377__auto__);

}
});

cljs.core$macros.if_let.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,bindings,then){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","if-let","cljs.core$macros/if-let",1291543946,null)),(function (){var x__9048__auto__ = bindings;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = then;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null))));
});

cljs.core$macros.if_let.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,bindings,then,else$,oldform){
if(cljs.core.vector_QMARK_.call(null,bindings)){
} else {
throw cljs.core.ex_info.call(null,"if-let requires a vector for its binding",cljs.core.PersistentArrayMap.EMPTY);
}

if(cljs.core.empty_QMARK_.call(null,oldform)){
} else {
throw cljs.core.ex_info.call(null,"if-let requires 1 or 2 forms after binding vector",cljs.core.PersistentArrayMap.EMPTY);
}

if(cljs.core._EQ_.call(null,(2),cljs.core.count.call(null,bindings))){
} else {
throw cljs.core.ex_info.call(null,"if-let requires exactly 2 forms in binding vector",cljs.core.PersistentArrayMap.EMPTY);
}


var form = bindings.call(null,(0));
var tst = bindings.call(null,(1));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"temp__36192__auto__","temp__36192__auto__",-347337227,null)),(function (){var x__9048__auto__ = tst;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"temp__36192__auto__","temp__36192__auto__",-347337227,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = form;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"temp__36192__auto__","temp__36192__auto__",-347337227,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = then;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = else$;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros.if_let.cljs$lang$applyTo = (function (seq36194){
var G__36195 = cljs.core.first.call(null,seq36194);
var seq36194__$1 = cljs.core.next.call(null,seq36194);
var G__36196 = cljs.core.first.call(null,seq36194__$1);
var seq36194__$2 = cljs.core.next.call(null,seq36194__$1);
var G__36197 = cljs.core.first.call(null,seq36194__$2);
var seq36194__$3 = cljs.core.next.call(null,seq36194__$2);
var G__36198 = cljs.core.first.call(null,seq36194__$3);
var seq36194__$4 = cljs.core.next.call(null,seq36194__$3);
var G__36199 = cljs.core.first.call(null,seq36194__$4);
var seq36194__$5 = cljs.core.next.call(null,seq36194__$4);
return cljs.core$macros.if_let.cljs$core$IFn$_invoke$arity$variadic(G__36195,G__36196,G__36197,G__36198,G__36199,seq36194__$5);
});

cljs.core$macros.if_let.cljs$lang$maxFixedArity = (5);

return null;
})()
;
cljs.core$macros.if_let.cljs$lang$macro = true;

var ret__9397__auto___36208 = (function (){
/**
 * Evaluates test. If logical false, evaluates and returns then expr,
 *   otherwise else expr, if supplied, else nil.
 */
cljs.core$macros.if_not = (function cljs$core$macros$if_not(var_args){
var G__36207 = arguments.length;
switch (G__36207) {
case 4:
return cljs.core$macros.if_not.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core$macros.if_not.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (2)))].join('')));

}
});

cljs.core$macros.if_not.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,test,then){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","if-not","cljs.core$macros/if-not",-1825285737,null)),(function (){var x__9048__auto__ = test;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = then;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null))));
});

cljs.core$macros.if_not.cljs$core$IFn$_invoke$arity$5 = (function (_AMPERSAND_form,_AMPERSAND_env,test,then,else$){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null)),(function (){var x__9048__auto__ = test;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = then;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = else$;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros.if_not.cljs$lang$maxFixedArity = 5;

return null;
})()
;
cljs.core$macros.if_not.cljs$lang$macro = true;

var ret__9397__auto___36215 = (function (){
/**
 * fnspec ==> (fname [params*] exprs) or (fname ([params*] exprs)+)
 * 
 *   Takes a vector of function specs and a body, and generates a set of
 *   bindings of functions to their names. All of the names are available
 *   in all of the definitions of the functions, as well as the body.
 */
cljs.core$macros.letfn = (function cljs$core$macros$letfn(var_args){
var args__9364__auto__ = [];
var len__9357__auto___36216 = arguments.length;
var i__9358__auto___36217 = (0);
while(true){
if((i__9358__auto___36217 < len__9357__auto___36216)){
args__9364__auto__.push((arguments[i__9358__auto___36217]));

var G__36218 = (i__9358__auto___36217 + (1));
i__9358__auto___36217 = G__36218;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((3) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.letfn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9365__auto__);
});

cljs.core$macros.letfn.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,fnspecs,body){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"letfn*","letfn*",-110097810,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.interleave.call(null,cljs.core.map.call(null,cljs.core.first,fnspecs),cljs.core.map.call(null,(function (p1__36210_SHARP_){
return cljs.core.cons.call(null,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null),p1__36210_SHARP_);
}),fnspecs)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),body)));
});

cljs.core$macros.letfn.cljs$lang$maxFixedArity = (3);

cljs.core$macros.letfn.cljs$lang$applyTo = (function (seq36211){
var G__36212 = cljs.core.first.call(null,seq36211);
var seq36211__$1 = cljs.core.next.call(null,seq36211);
var G__36213 = cljs.core.first.call(null,seq36211__$1);
var seq36211__$2 = cljs.core.next.call(null,seq36211__$1);
var G__36214 = cljs.core.first.call(null,seq36211__$2);
var seq36211__$3 = cljs.core.next.call(null,seq36211__$2);
return cljs.core$macros.letfn.cljs$core$IFn$_invoke$arity$variadic(G__36212,G__36213,G__36214,seq36211__$3);
});

return null;
})()
;
cljs.core$macros.letfn.cljs$lang$macro = true;

var ret__9397__auto___36223 = (function (){
/**
 * Expands into code that creates a fn that expects to be passed an
 *   object and any args and calls the named instance method on the
 *   object passing the args. Use when you want to treat a JavaScript
 *   method as a first-class fn.
 */
cljs.core$macros.memfn = (function cljs$core$macros$memfn(var_args){
var args__9364__auto__ = [];
var len__9357__auto___36224 = arguments.length;
var i__9358__auto___36225 = (0);
while(true){
if((i__9358__auto___36225 < len__9357__auto___36224)){
args__9364__auto__.push((arguments[i__9358__auto___36225]));

var G__36226 = (i__9358__auto___36225 + (1));
i__9358__auto___36225 = G__36226;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((3) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.memfn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9365__auto__);
});

cljs.core$macros.memfn.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,name,args){
var t = cljs.core.with_meta.call(null,cljs.core.gensym.call(null,"target"),cljs.core.meta.call(null,name));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = t;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),args))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__9048__auto__ = t;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = name;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),args)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros.memfn.cljs$lang$maxFixedArity = (3);

cljs.core$macros.memfn.cljs$lang$applyTo = (function (seq36219){
var G__36220 = cljs.core.first.call(null,seq36219);
var seq36219__$1 = cljs.core.next.call(null,seq36219);
var G__36221 = cljs.core.first.call(null,seq36219__$1);
var seq36219__$2 = cljs.core.next.call(null,seq36219__$1);
var G__36222 = cljs.core.first.call(null,seq36219__$2);
var seq36219__$3 = cljs.core.next.call(null,seq36219__$2);
return cljs.core$macros.memfn.cljs$core$IFn$_invoke$arity$variadic(G__36220,G__36221,G__36222,seq36219__$3);
});

return null;
})()
;
cljs.core$macros.memfn.cljs$lang$macro = true;

var ret__9397__auto___36231 = (function (){
/**
 * Evaluates test. If logical true, evaluates body in an implicit do.
 */
cljs.core$macros.when = (function cljs$core$macros$when(var_args){
var args__9364__auto__ = [];
var len__9357__auto___36232 = arguments.length;
var i__9358__auto___36233 = (0);
while(true){
if((i__9358__auto___36233 < len__9357__auto___36232)){
args__9364__auto__.push((arguments[i__9358__auto___36233]));

var G__36234 = (i__9358__auto___36233 + (1));
i__9358__auto___36233 = G__36234;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((3) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.when.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9365__auto__);
});

cljs.core$macros.when.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,test,body){
return cljs.core._conj.call(null,(function (){var x__9048__auto__ = test;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = cljs.core.cons.call(null,new cljs.core.Symbol(null,"do","do",1686842252,null),body);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})(),new cljs.core.Symbol(null,"if","if",1181717262,null));
});

cljs.core$macros.when.cljs$lang$maxFixedArity = (3);

cljs.core$macros.when.cljs$lang$applyTo = (function (seq36227){
var G__36228 = cljs.core.first.call(null,seq36227);
var seq36227__$1 = cljs.core.next.call(null,seq36227);
var G__36229 = cljs.core.first.call(null,seq36227__$1);
var seq36227__$2 = cljs.core.next.call(null,seq36227__$1);
var G__36230 = cljs.core.first.call(null,seq36227__$2);
var seq36227__$3 = cljs.core.next.call(null,seq36227__$2);
return cljs.core$macros.when.cljs$core$IFn$_invoke$arity$variadic(G__36228,G__36229,G__36230,seq36227__$3);
});

return null;
})()
;
cljs.core$macros.when.cljs$lang$macro = true;

var ret__9397__auto___36243 = (function (){
/**
 * bindings => x xs
 * 
 *   Roughly the same as (when (seq xs) (let [x (first xs)] body)) but xs is evaluated only once
 */
cljs.core$macros.when_first = (function cljs$core$macros$when_first(var_args){
var args__9364__auto__ = [];
var len__9357__auto___36244 = arguments.length;
var i__9358__auto___36245 = (0);
while(true){
if((i__9358__auto___36245 < len__9357__auto___36244)){
args__9364__auto__.push((arguments[i__9358__auto___36245]));

var G__36246 = (i__9358__auto___36245 + (1));
i__9358__auto___36245 = G__36246;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((3) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.when_first.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9365__auto__);
});

cljs.core$macros.when_first.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,bindings,body){
if(cljs.core.vector_QMARK_.call(null,bindings)){
} else {
throw cljs.core.ex_info.call(null,"when-first requires a vector for its binding",cljs.core.PersistentArrayMap.EMPTY);
}

if(cljs.core._EQ_.call(null,(2),cljs.core.count.call(null,bindings))){
} else {
throw cljs.core.ex_info.call(null,"when-first requires exactly 2 forms in binding vector",cljs.core.PersistentArrayMap.EMPTY);
}


var vec__36240 = bindings;
var x = cljs.core.nth.call(null,vec__36240,(0),null);
var xs = cljs.core.nth.call(null,vec__36240,(1),null);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","when-let","cljs.core$macros/when-let",-2004472648,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"xs__36235__auto__","xs__36235__auto__",-1053639499,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","seq","cljs.core/seq",-1649497689,null)),(function (){var x__9048__auto__ = xs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","first","cljs.core/first",-752535972,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"xs__36235__auto__","xs__36235__auto__",-1053639499,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),body)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros.when_first.cljs$lang$maxFixedArity = (3);

cljs.core$macros.when_first.cljs$lang$applyTo = (function (seq36236){
var G__36237 = cljs.core.first.call(null,seq36236);
var seq36236__$1 = cljs.core.next.call(null,seq36236);
var G__36238 = cljs.core.first.call(null,seq36236__$1);
var seq36236__$2 = cljs.core.next.call(null,seq36236__$1);
var G__36239 = cljs.core.first.call(null,seq36236__$2);
var seq36236__$3 = cljs.core.next.call(null,seq36236__$2);
return cljs.core$macros.when_first.cljs$core$IFn$_invoke$arity$variadic(G__36237,G__36238,G__36239,seq36236__$3);
});

return null;
})()
;
cljs.core$macros.when_first.cljs$lang$macro = true;

var ret__9397__auto___36252 = (function (){
/**
 * bindings => binding-form test
 * 
 *   When test is true, evaluates body with binding-form bound to the value of test
 */
cljs.core$macros.when_let = (function cljs$core$macros$when_let(var_args){
var args__9364__auto__ = [];
var len__9357__auto___36253 = arguments.length;
var i__9358__auto___36254 = (0);
while(true){
if((i__9358__auto___36254 < len__9357__auto___36253)){
args__9364__auto__.push((arguments[i__9358__auto___36254]));

var G__36255 = (i__9358__auto___36254 + (1));
i__9358__auto___36254 = G__36255;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((3) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.when_let.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9365__auto__);
});

cljs.core$macros.when_let.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,bindings,body){
if(cljs.core.vector_QMARK_.call(null,bindings)){
} else {
throw cljs.core.ex_info.call(null,"when-let requires a vector for its binding",cljs.core.PersistentArrayMap.EMPTY);
}

if(cljs.core._EQ_.call(null,(2),cljs.core.count.call(null,bindings))){
} else {
throw cljs.core.ex_info.call(null,"when-let requires exactly 2 forms in binding vector",cljs.core.PersistentArrayMap.EMPTY);
}


var form = bindings.call(null,(0));
var tst = bindings.call(null,(1));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"temp__36247__auto__","temp__36247__auto__",1236083156,null)),(function (){var x__9048__auto__ = tst;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","when","cljs.core$macros/when",328457725,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"temp__36247__auto__","temp__36247__auto__",1236083156,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = form;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"temp__36247__auto__","temp__36247__auto__",1236083156,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),body)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros.when_let.cljs$lang$maxFixedArity = (3);

cljs.core$macros.when_let.cljs$lang$applyTo = (function (seq36248){
var G__36249 = cljs.core.first.call(null,seq36248);
var seq36248__$1 = cljs.core.next.call(null,seq36248);
var G__36250 = cljs.core.first.call(null,seq36248__$1);
var seq36248__$2 = cljs.core.next.call(null,seq36248__$1);
var G__36251 = cljs.core.first.call(null,seq36248__$2);
var seq36248__$3 = cljs.core.next.call(null,seq36248__$2);
return cljs.core$macros.when_let.cljs$core$IFn$_invoke$arity$variadic(G__36249,G__36250,G__36251,seq36248__$3);
});

return null;
})()
;
cljs.core$macros.when_let.cljs$lang$macro = true;

var ret__9397__auto___36260 = (function (){
/**
 * Evaluates test. If logical false, evaluates body in an implicit do.
 */
cljs.core$macros.when_not = (function cljs$core$macros$when_not(var_args){
var args__9364__auto__ = [];
var len__9357__auto___36261 = arguments.length;
var i__9358__auto___36262 = (0);
while(true){
if((i__9358__auto___36262 < len__9357__auto___36261)){
args__9364__auto__.push((arguments[i__9358__auto___36262]));

var G__36263 = (i__9358__auto___36262 + (1));
i__9358__auto___36262 = G__36263;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((3) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.when_not.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9365__auto__);
});

cljs.core$macros.when_not.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,test,body){
return cljs.core._conj.call(null,(function (){var x__9048__auto__ = test;
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = cljs.core.cons.call(null,new cljs.core.Symbol(null,"do","do",1686842252,null),body);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),null),x__9048__auto__);
})(),new cljs.core.Symbol(null,"if","if",1181717262,null));
});

cljs.core$macros.when_not.cljs$lang$maxFixedArity = (3);

cljs.core$macros.when_not.cljs$lang$applyTo = (function (seq36256){
var G__36257 = cljs.core.first.call(null,seq36256);
var seq36256__$1 = cljs.core.next.call(null,seq36256);
var G__36258 = cljs.core.first.call(null,seq36256__$1);
var seq36256__$2 = cljs.core.next.call(null,seq36256__$1);
var G__36259 = cljs.core.first.call(null,seq36256__$2);
var seq36256__$3 = cljs.core.next.call(null,seq36256__$2);
return cljs.core$macros.when_not.cljs$core$IFn$_invoke$arity$variadic(G__36257,G__36258,G__36259,seq36256__$3);
});

return null;
})()
;
cljs.core$macros.when_not.cljs$lang$macro = true;

var ret__9397__auto___36268 = (function (){
/**
 * Repeatedly executes body while test expression is true. Presumes
 *   some side-effect will cause test to become false/nil. Returns nil
 */
cljs.core$macros.while$ = (function cljs$core$macros$while(var_args){
var args__9364__auto__ = [];
var len__9357__auto___36269 = arguments.length;
var i__9358__auto___36270 = (0);
while(true){
if((i__9358__auto___36270 < len__9357__auto___36269)){
args__9364__auto__.push((arguments[i__9358__auto___36270]));

var G__36271 = (i__9358__auto___36270 + (1));
i__9358__auto___36270 = G__36271;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((3) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.while$.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9365__auto__);
});

cljs.core$macros.while$.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,test,body){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","loop","cljs.core$macros/loop",1731108390,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","when","cljs.core$macros/when",328457725,null)),(function (){var x__9048__auto__ = test;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),body,(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"recur","recur",1202958259,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros.while$.cljs$lang$maxFixedArity = (3);

cljs.core$macros.while$.cljs$lang$applyTo = (function (seq36264){
var G__36265 = cljs.core.first.call(null,seq36264);
var seq36264__$1 = cljs.core.next.call(null,seq36264);
var G__36266 = cljs.core.first.call(null,seq36264__$1);
var seq36264__$2 = cljs.core.next.call(null,seq36264__$1);
var G__36267 = cljs.core.first.call(null,seq36264__$2);
var seq36264__$3 = cljs.core.next.call(null,seq36264__$2);
return cljs.core$macros.while$.cljs$core$IFn$_invoke$arity$variadic(G__36265,G__36266,G__36267,seq36264__$3);
});

return null;
})()
;
cljs.core$macros.while$.cljs$lang$macro = true;

var ret__9397__auto___36280 = (function (){
/**
 * Takes an expression and a set of test/form pairs. Threads expr (via ->)
 *   through each form for which the corresponding test
 *   expression is true. Note that, unlike cond branching, cond-> threading does
 *   not short circuit after the first true test expression.
 */
cljs.core$macros.cond__GT_ = (function cljs$core$macros$cond__GT_(var_args){
var args__9364__auto__ = [];
var len__9357__auto___36281 = arguments.length;
var i__9358__auto___36282 = (0);
while(true){
if((i__9358__auto___36282 < len__9357__auto___36281)){
args__9364__auto__.push((arguments[i__9358__auto___36282]));

var G__36283 = (i__9358__auto___36282 + (1));
i__9358__auto___36282 = G__36283;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((3) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.cond__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9365__auto__);
});

cljs.core$macros.cond__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,expr,clauses){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,clauses))){
} else {
throw (new Error("Assert failed: (even? (count clauses))"));
}

var g = cljs.core.gensym.call(null);
var steps = cljs.core.map.call(null,((function (g){
return (function (p__36276){
var vec__36277 = p__36276;
var test = cljs.core.nth.call(null,vec__36277,(0),null);
var step = cljs.core.nth.call(null,vec__36277,(1),null);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__9048__auto__ = test;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","->","cljs.core$macros/->",-1519455206,null)),(function (){var x__9048__auto__ = g;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = step;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = g;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});})(g))
,cljs.core.partition.call(null,(2),clauses));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = g;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = expr;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core.interleave.call(null,cljs.core.repeat.call(null,g),cljs.core.butlast.call(null,steps))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = ((cljs.core.empty_QMARK_.call(null,steps))?g:cljs.core.last.call(null,steps));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros.cond__GT_.cljs$lang$maxFixedArity = (3);

cljs.core$macros.cond__GT_.cljs$lang$applyTo = (function (seq36272){
var G__36273 = cljs.core.first.call(null,seq36272);
var seq36272__$1 = cljs.core.next.call(null,seq36272);
var G__36274 = cljs.core.first.call(null,seq36272__$1);
var seq36272__$2 = cljs.core.next.call(null,seq36272__$1);
var G__36275 = cljs.core.first.call(null,seq36272__$2);
var seq36272__$3 = cljs.core.next.call(null,seq36272__$2);
return cljs.core$macros.cond__GT_.cljs$core$IFn$_invoke$arity$variadic(G__36273,G__36274,G__36275,seq36272__$3);
});

return null;
})()
;
cljs.core$macros.cond__GT_.cljs$lang$macro = true;

var ret__9397__auto___36292 = (function (){
/**
 * Takes an expression and a set of test/form pairs. Threads expr (via ->>)
 *   through each form for which the corresponding test expression
 *   is true.  Note that, unlike cond branching, cond->> threading does not short circuit
 *   after the first true test expression.
 */
cljs.core$macros.cond__GT__GT_ = (function cljs$core$macros$cond__GT__GT_(var_args){
var args__9364__auto__ = [];
var len__9357__auto___36293 = arguments.length;
var i__9358__auto___36294 = (0);
while(true){
if((i__9358__auto___36294 < len__9357__auto___36293)){
args__9364__auto__.push((arguments[i__9358__auto___36294]));

var G__36295 = (i__9358__auto___36294 + (1));
i__9358__auto___36294 = G__36295;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((3) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.cond__GT__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9365__auto__);
});

cljs.core$macros.cond__GT__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,expr,clauses){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,clauses))){
} else {
throw (new Error("Assert failed: (even? (count clauses))"));
}

var g = cljs.core.gensym.call(null);
var steps = cljs.core.map.call(null,((function (g){
return (function (p__36288){
var vec__36289 = p__36288;
var test = cljs.core.nth.call(null,vec__36289,(0),null);
var step = cljs.core.nth.call(null,vec__36289,(1),null);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__9048__auto__ = test;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","->>","cljs.core$macros/->>",-1353108561,null)),(function (){var x__9048__auto__ = g;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = step;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = g;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});})(g))
,cljs.core.partition.call(null,(2),clauses));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = g;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = expr;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core.interleave.call(null,cljs.core.repeat.call(null,g),cljs.core.butlast.call(null,steps))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = ((cljs.core.empty_QMARK_.call(null,steps))?g:cljs.core.last.call(null,steps));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros.cond__GT__GT_.cljs$lang$maxFixedArity = (3);

cljs.core$macros.cond__GT__GT_.cljs$lang$applyTo = (function (seq36284){
var G__36285 = cljs.core.first.call(null,seq36284);
var seq36284__$1 = cljs.core.next.call(null,seq36284);
var G__36286 = cljs.core.first.call(null,seq36284__$1);
var seq36284__$2 = cljs.core.next.call(null,seq36284__$1);
var G__36287 = cljs.core.first.call(null,seq36284__$2);
var seq36284__$3 = cljs.core.next.call(null,seq36284__$2);
return cljs.core$macros.cond__GT__GT_.cljs$core$IFn$_invoke$arity$variadic(G__36285,G__36286,G__36287,seq36284__$3);
});

return null;
})()
;
cljs.core$macros.cond__GT__GT_.cljs$lang$macro = true;

var ret__9397__auto___36301 = (function (){
/**
 * Binds name to expr, evaluates the first form in the lexical context
 *   of that binding, then binds name to that result, repeating for each
 *   successive form, returning the result of the last form.
 */
cljs.core$macros.as__GT_ = (function cljs$core$macros$as__GT_(var_args){
var args__9364__auto__ = [];
var len__9357__auto___36302 = arguments.length;
var i__9358__auto___36303 = (0);
while(true){
if((i__9358__auto___36303 < len__9357__auto___36302)){
args__9364__auto__.push((arguments[i__9358__auto___36303]));

var G__36304 = (i__9358__auto___36303 + (1));
i__9358__auto___36303 = G__36304;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((4) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((4)),(0),null)):null);
return cljs.core$macros.as__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__9365__auto__);
});

cljs.core$macros.as__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,expr,name,forms){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = name;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = expr;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core.interleave.call(null,cljs.core.repeat.call(null,name),cljs.core.butlast.call(null,forms))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = ((cljs.core.empty_QMARK_.call(null,forms))?name:cljs.core.last.call(null,forms));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros.as__GT_.cljs$lang$maxFixedArity = (4);

cljs.core$macros.as__GT_.cljs$lang$applyTo = (function (seq36296){
var G__36297 = cljs.core.first.call(null,seq36296);
var seq36296__$1 = cljs.core.next.call(null,seq36296);
var G__36298 = cljs.core.first.call(null,seq36296__$1);
var seq36296__$2 = cljs.core.next.call(null,seq36296__$1);
var G__36299 = cljs.core.first.call(null,seq36296__$2);
var seq36296__$3 = cljs.core.next.call(null,seq36296__$2);
var G__36300 = cljs.core.first.call(null,seq36296__$3);
var seq36296__$4 = cljs.core.next.call(null,seq36296__$3);
return cljs.core$macros.as__GT_.cljs$core$IFn$_invoke$arity$variadic(G__36297,G__36298,G__36299,G__36300,seq36296__$4);
});

return null;
})()
;
cljs.core$macros.as__GT_.cljs$lang$macro = true;

var ret__9397__auto___36309 = (function (){
/**
 * When expr is not nil, threads it into the first form (via ->),
 *   and when that result is not nil, through the next etc
 */
cljs.core$macros.some__GT_ = (function cljs$core$macros$some__GT_(var_args){
var args__9364__auto__ = [];
var len__9357__auto___36310 = arguments.length;
var i__9358__auto___36311 = (0);
while(true){
if((i__9358__auto___36311 < len__9357__auto___36310)){
args__9364__auto__.push((arguments[i__9358__auto___36311]));

var G__36312 = (i__9358__auto___36311 + (1));
i__9358__auto___36311 = G__36312;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((3) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.some__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9365__auto__);
});

cljs.core$macros.some__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,expr,forms){
var g = cljs.core.gensym.call(null);
var steps = cljs.core.map.call(null,((function (g){
return (function (step){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","nil?","cljs.core$macros/nil?",83624258,null)),(function (){var x__9048__auto__ = g;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","->","cljs.core$macros/->",-1519455206,null)),(function (){var x__9048__auto__ = g;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = step;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});})(g))
,forms);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = g;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = expr;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core.interleave.call(null,cljs.core.repeat.call(null,g),cljs.core.butlast.call(null,steps))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = ((cljs.core.empty_QMARK_.call(null,steps))?g:cljs.core.last.call(null,steps));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros.some__GT_.cljs$lang$maxFixedArity = (3);

cljs.core$macros.some__GT_.cljs$lang$applyTo = (function (seq36305){
var G__36306 = cljs.core.first.call(null,seq36305);
var seq36305__$1 = cljs.core.next.call(null,seq36305);
var G__36307 = cljs.core.first.call(null,seq36305__$1);
var seq36305__$2 = cljs.core.next.call(null,seq36305__$1);
var G__36308 = cljs.core.first.call(null,seq36305__$2);
var seq36305__$3 = cljs.core.next.call(null,seq36305__$2);
return cljs.core$macros.some__GT_.cljs$core$IFn$_invoke$arity$variadic(G__36306,G__36307,G__36308,seq36305__$3);
});

return null;
})()
;
cljs.core$macros.some__GT_.cljs$lang$macro = true;

var ret__9397__auto___36317 = (function (){
/**
 * When expr is not nil, threads it into the first form (via ->>),
 *   and when that result is not nil, through the next etc
 */
cljs.core$macros.some__GT__GT_ = (function cljs$core$macros$some__GT__GT_(var_args){
var args__9364__auto__ = [];
var len__9357__auto___36318 = arguments.length;
var i__9358__auto___36319 = (0);
while(true){
if((i__9358__auto___36319 < len__9357__auto___36318)){
args__9364__auto__.push((arguments[i__9358__auto___36319]));

var G__36320 = (i__9358__auto___36319 + (1));
i__9358__auto___36319 = G__36320;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((3) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.some__GT__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9365__auto__);
});

cljs.core$macros.some__GT__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,expr,forms){
var g = cljs.core.gensym.call(null);
var steps = cljs.core.map.call(null,((function (g){
return (function (step){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","nil?","cljs.core$macros/nil?",83624258,null)),(function (){var x__9048__auto__ = g;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","->>","cljs.core$macros/->>",-1353108561,null)),(function (){var x__9048__auto__ = g;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = step;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});})(g))
,forms);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = g;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = expr;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core.interleave.call(null,cljs.core.repeat.call(null,g),cljs.core.butlast.call(null,steps))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = ((cljs.core.empty_QMARK_.call(null,steps))?g:cljs.core.last.call(null,steps));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros.some__GT__GT_.cljs$lang$maxFixedArity = (3);

cljs.core$macros.some__GT__GT_.cljs$lang$applyTo = (function (seq36313){
var G__36314 = cljs.core.first.call(null,seq36313);
var seq36313__$1 = cljs.core.next.call(null,seq36313);
var G__36315 = cljs.core.first.call(null,seq36313__$1);
var seq36313__$2 = cljs.core.next.call(null,seq36313__$1);
var G__36316 = cljs.core.first.call(null,seq36313__$2);
var seq36313__$3 = cljs.core.next.call(null,seq36313__$2);
return cljs.core$macros.some__GT__GT_.cljs$core$IFn$_invoke$arity$variadic(G__36314,G__36315,G__36316,seq36313__$3);
});

return null;
})()
;
cljs.core$macros.some__GT__GT_.cljs$lang$macro = true;

var ret__9397__auto___36330 = (function (){
/**
 * bindings => binding-form test
 * 
 *    If test is not nil, evaluates then with binding-form bound to the
 *    value of test, if not, yields else
 */
cljs.core$macros.if_some = (function cljs$core$macros$if_some(var_args){
var G__36329 = arguments.length;
switch (G__36329) {
case 4:
return cljs.core$macros.if_some.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__9376__auto__ = [];
var len__9357__auto___36332 = arguments.length;
var i__9358__auto___36333 = (0);
while(true){
if((i__9358__auto___36333 < len__9357__auto___36332)){
args_arr__9376__auto__.push((arguments[i__9358__auto___36333]));

var G__36334 = (i__9358__auto___36333 + (1));
i__9358__auto___36333 = G__36334;
continue;
} else {
}
break;
}

var argseq__9377__auto__ = (new cljs.core.IndexedSeq(args_arr__9376__auto__.slice((5)),(0),null));
return cljs.core$macros.if_some.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__9377__auto__);

}
});

cljs.core$macros.if_some.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,bindings,then){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","if-some","cljs.core$macros/if-some",1405341529,null)),(function (){var x__9048__auto__ = bindings;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = then;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null))));
});

cljs.core$macros.if_some.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,bindings,then,else$,oldform){
if(cljs.core.vector_QMARK_.call(null,bindings)){
} else {
throw cljs.core.ex_info.call(null,"if-some requires a vector for its binding",cljs.core.PersistentArrayMap.EMPTY);
}

if(cljs.core.empty_QMARK_.call(null,oldform)){
} else {
throw cljs.core.ex_info.call(null,"if-some requires 1 or 2 forms after binding vector",cljs.core.PersistentArrayMap.EMPTY);
}

if(cljs.core._EQ_.call(null,(2),cljs.core.count.call(null,bindings))){
} else {
throw cljs.core.ex_info.call(null,"if-some requires exactly 2 forms in binding vector",cljs.core.PersistentArrayMap.EMPTY);
}


var form = bindings.call(null,(0));
var tst = bindings.call(null,(1));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"temp__36321__auto__","temp__36321__auto__",738421936,null)),(function (){var x__9048__auto__ = tst;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","nil?","cljs.core$macros/nil?",83624258,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"temp__36321__auto__","temp__36321__auto__",738421936,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = else$;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = form;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"temp__36321__auto__","temp__36321__auto__",738421936,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = then;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros.if_some.cljs$lang$applyTo = (function (seq36323){
var G__36324 = cljs.core.first.call(null,seq36323);
var seq36323__$1 = cljs.core.next.call(null,seq36323);
var G__36325 = cljs.core.first.call(null,seq36323__$1);
var seq36323__$2 = cljs.core.next.call(null,seq36323__$1);
var G__36326 = cljs.core.first.call(null,seq36323__$2);
var seq36323__$3 = cljs.core.next.call(null,seq36323__$2);
var G__36327 = cljs.core.first.call(null,seq36323__$3);
var seq36323__$4 = cljs.core.next.call(null,seq36323__$3);
var G__36328 = cljs.core.first.call(null,seq36323__$4);
var seq36323__$5 = cljs.core.next.call(null,seq36323__$4);
return cljs.core$macros.if_some.cljs$core$IFn$_invoke$arity$variadic(G__36324,G__36325,G__36326,G__36327,G__36328,seq36323__$5);
});

cljs.core$macros.if_some.cljs$lang$maxFixedArity = (5);

return null;
})()
;
cljs.core$macros.if_some.cljs$lang$macro = true;

var ret__9397__auto___36340 = (function (){
/**
 * bindings => binding-form test
 * 
 *    When test is not nil, evaluates body with binding-form bound to the
 *    value of test
 */
cljs.core$macros.when_some = (function cljs$core$macros$when_some(var_args){
var args__9364__auto__ = [];
var len__9357__auto___36341 = arguments.length;
var i__9358__auto___36342 = (0);
while(true){
if((i__9358__auto___36342 < len__9357__auto___36341)){
args__9364__auto__.push((arguments[i__9358__auto___36342]));

var G__36343 = (i__9358__auto___36342 + (1));
i__9358__auto___36342 = G__36343;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((3) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.when_some.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9365__auto__);
});

cljs.core$macros.when_some.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,bindings,body){
if(cljs.core.vector_QMARK_.call(null,bindings)){
} else {
throw cljs.core.ex_info.call(null,"when-some requires a vector for its binding",cljs.core.PersistentArrayMap.EMPTY);
}

if(cljs.core._EQ_.call(null,(2),cljs.core.count.call(null,bindings))){
} else {
throw cljs.core.ex_info.call(null,"when-some requires exactly 2 forms in binding vector",cljs.core.PersistentArrayMap.EMPTY);
}


var form = bindings.call(null,(0));
var tst = bindings.call(null,(1));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"temp__36335__auto__","temp__36335__auto__",-135422655,null)),(function (){var x__9048__auto__ = tst;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","nil?","cljs.core$macros/nil?",83624258,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"temp__36335__auto__","temp__36335__auto__",-135422655,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = form;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"temp__36335__auto__","temp__36335__auto__",-135422655,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),body)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros.when_some.cljs$lang$maxFixedArity = (3);

cljs.core$macros.when_some.cljs$lang$applyTo = (function (seq36336){
var G__36337 = cljs.core.first.call(null,seq36336);
var seq36336__$1 = cljs.core.next.call(null,seq36336);
var G__36338 = cljs.core.first.call(null,seq36336__$1);
var seq36336__$2 = cljs.core.next.call(null,seq36336__$1);
var G__36339 = cljs.core.first.call(null,seq36336__$2);
var seq36336__$3 = cljs.core.next.call(null,seq36336__$2);
return cljs.core$macros.when_some.cljs$core$IFn$_invoke$arity$variadic(G__36337,G__36338,G__36339,seq36336__$3);
});

return null;
})()
;
cljs.core$macros.when_some.cljs$lang$macro = true;

/**
 * A good fdecl looks like (([a] ...) ([a b] ...)) near the end of defn.
 */
cljs.core$macros.assert_valid_fdecl = (function cljs$core$macros$assert_valid_fdecl(fdecl){
if(cljs.core.empty_QMARK_.call(null,fdecl)){
throw (new Error("Parameter declaration missing"));
} else {
}

var argdecls = cljs.core.map.call(null,(function (p1__36344_SHARP_){
if(cljs.core.seq_QMARK_.call(null,p1__36344_SHARP_)){
return cljs.core.first.call(null,p1__36344_SHARP_);
} else {
throw (new Error(((cljs.core.seq_QMARK_.call(null,cljs.core.first.call(null,fdecl)))?["Invalid signature \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__36344_SHARP_),"\" should be a list"].join(''):["Parameter declaration \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__36344_SHARP_),"\" should be a vector"].join(''))));
}
}),fdecl);
var bad_args = cljs.core.seq.call(null,cljs.core.remove.call(null,((function (argdecls){
return (function (p1__36345_SHARP_){
return cljs.core.vector_QMARK_.call(null,p1__36345_SHARP_);
});})(argdecls))
,argdecls));
if(bad_args){
throw (new Error(["Parameter declaration \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,bad_args)),"\" should be a vector"].join('')));
} else {
return null;
}
});
cljs.core$macros.sigs = (function cljs$core$macros$sigs(fdecl){
cljs.core$macros.assert_valid_fdecl.call(null,fdecl);

var asig = (function (fdecl__$1){
var arglist = cljs.core.first.call(null,fdecl__$1);
var arglist__$1 = ((cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"&form","&form",1482799337,null),cljs.core.first.call(null,arglist)))?cljs.core.subvec.call(null,arglist,(2),cljs.core.count.call(null,arglist)):arglist);
var body = cljs.core.next.call(null,fdecl__$1);
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
if(cljs.core.next.call(null,body)){
return cljs.core.with_meta.call(null,arglist__$1,cljs.core.conj.call(null,(cljs.core.truth_(cljs.core.meta.call(null,arglist__$1))?cljs.core.meta.call(null,arglist__$1):cljs.core.PersistentArrayMap.EMPTY),cljs.core.first.call(null,body)));
} else {
return arglist__$1;
}
} else {
return arglist__$1;
}
});
if(cljs.core.seq_QMARK_.call(null,cljs.core.first.call(null,fdecl))){
var ret = cljs.core.PersistentVector.EMPTY;
var fdecls = fdecl;
while(true){
if(cljs.core.truth_(fdecls)){
var G__36346 = cljs.core.conj.call(null,ret,asig.call(null,cljs.core.first.call(null,fdecls)));
var G__36347 = cljs.core.next.call(null,fdecls);
ret = G__36346;
fdecls = G__36347;
continue;
} else {
return cljs.core.seq.call(null,ret);
}
break;
}
} else {
var x__9048__auto__ = asig.call(null,fdecl);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
}
});
var ret__9397__auto___36348 = /**
 * defs name to have the root value of init iff the named var has no root value,
 *   else init is unevaluated
 */
cljs.core$macros.defonce = (function cljs$core$macros$defonce(_AMPERSAND_form,_AMPERSAND_env,x,init){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","when-not","cljs.core$macros/when-not",-764302244,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","exists?","cljs.core$macros/exists?",-1828590389,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"def","def",597100991,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = init;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});
cljs.core$macros.defonce.cljs$lang$macro = true;

cljs.core$macros.destructure = (function cljs$core$macros$destructure(bindings){
var bents = cljs.core.partition.call(null,(2),bindings);
var pb = ((function (bents){
return (function cljs$core$macros$destructure_$_pb(bvec,b,v){
var pvec = ((function (bents){
return (function (bvec__$1,b__$1,val){
var gvec = cljs.core.gensym.call(null,"vec__");
var gseq = cljs.core.gensym.call(null,"seq__");
var gfirst = cljs.core.gensym.call(null,"first__");
var has_rest = cljs.core.some.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"&","&",-2144855648,null),null], null), null),b__$1);
var ret = (function (){var ret = cljs.core.conj.call(null,bvec__$1,gvec,val);
if(cljs.core.truth_(has_rest)){
return cljs.core.conj.call(null,ret,gseq,cljs.core._conj.call(null,(function (){var x__9048__auto__ = gvec;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),new cljs.core.Symbol("cljs.core","seq","cljs.core/seq",-1649497689,null)));
} else {
return ret;
}
})();
var n = (0);
var bs = b__$1;
var seen_rest_QMARK_ = false;
while(true){
if(cljs.core.seq.call(null,bs)){
var firstb = cljs.core.first.call(null,bs);
if(cljs.core._EQ_.call(null,firstb,new cljs.core.Symbol(null,"&","&",-2144855648,null))){
var G__36355 = cljs$core$macros$destructure_$_pb.call(null,ret,cljs.core.second.call(null,bs),gseq);
var G__36356 = n;
var G__36357 = cljs.core.nnext.call(null,bs);
var G__36358 = true;
ret = G__36355;
n = G__36356;
bs = G__36357;
seen_rest_QMARK_ = G__36358;
continue;
} else {
if(cljs.core._EQ_.call(null,firstb,new cljs.core.Keyword(null,"as","as",1148689641))){
return cljs$core$macros$destructure_$_pb.call(null,ret,cljs.core.second.call(null,bs),gvec);
} else {
if(seen_rest_QMARK_){
throw (new Error("Unsupported binding form, only :as can follow & parameter"));
} else {
var G__36359 = cljs$core$macros$destructure_$_pb.call(null,(cljs.core.truth_(has_rest)?cljs.core.conj.call(null,ret,gfirst,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","first","cljs.core/first",-752535972,null)),(function (){var x__9048__auto__ = gseq;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))),gseq,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","next","cljs.core/next",-1291438473,null)),(function (){var x__9048__auto__ = gseq;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())))):ret),firstb,(cljs.core.truth_(has_rest)?gfirst:cljs.core._conj.call(null,(function (){var x__9048__auto__ = gvec;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = n;
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,null),x__9048__auto____$1);
})(),x__9048__auto__);
})(),new cljs.core.Symbol("cljs.core","nth","cljs.core/nth",1961052085,null))));
var G__36360 = (n + (1));
var G__36361 = cljs.core.next.call(null,bs);
var G__36362 = seen_rest_QMARK_;
ret = G__36359;
n = G__36360;
bs = G__36361;
seen_rest_QMARK_ = G__36362;
continue;
}

}
}
} else {
return ret;
}
break;
}
});})(bents))
;
var pmap = ((function (pvec,bents){
return (function (bvec__$1,b__$1,v__$1){
var gmap = cljs.core.gensym.call(null,"map__");
var defaults = new cljs.core.Keyword(null,"or","or",235744169).cljs$core$IFn$_invoke$arity$1(b__$1);
var ret = ((function (gmap,defaults,pvec,bents){
return (function (ret){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(b__$1))){
return cljs.core.conj.call(null,ret,new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(b__$1),gmap);
} else {
return ret;
}
});})(gmap,defaults,pvec,bents))
.call(null,cljs.core.conj.call(null,cljs.core.conj.call(null,cljs.core.conj.call(null,cljs.core.conj.call(null,bvec__$1,gmap),v__$1),gmap),cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","implements?","cljs.core$macros/implements?",-94762250,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","ISeq","cljs.core/ISeq",230133392,null)),(function (){var x__9048__auto__ = gmap;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","apply","cljs.core/apply",1757277831,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","hash-map","cljs.core/hash-map",303385767,null)),(function (){var x__9048__auto__ = gmap;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = gmap;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())))));
var bes = (function (){var transforms = cljs.core.reduce.call(null,((function (ret,gmap,defaults,pvec,bents){
return (function (transforms,mk){
if((mk instanceof cljs.core.Keyword)){
var mkns = cljs.core.namespace.call(null,mk);
var mkn = cljs.core.name.call(null,mk);
if(cljs.core._EQ_.call(null,mkn,"keys")){
return cljs.core.assoc.call(null,transforms,mk,((function (mkns,mkn,ret,gmap,defaults,pvec,bents){
return (function (p1__36349_SHARP_){
return cljs.core.keyword.call(null,(function (){var or__8186__auto__ = mkns;
if(cljs.core.truth_(or__8186__auto__)){
return or__8186__auto__;
} else {
return cljs.core.namespace.call(null,p1__36349_SHARP_);
}
})(),cljs.core.name.call(null,p1__36349_SHARP_));
});})(mkns,mkn,ret,gmap,defaults,pvec,bents))
);
} else {
if(cljs.core._EQ_.call(null,mkn,"syms")){
return cljs.core.assoc.call(null,transforms,mk,((function (mkns,mkn,ret,gmap,defaults,pvec,bents){
return (function (p1__36350_SHARP_){
return cljs.core._conj.call(null,(function (){var x__9048__auto__ = cljs.core.symbol.call(null,(function (){var or__8186__auto__ = mkns;
if(cljs.core.truth_(or__8186__auto__)){
return or__8186__auto__;
} else {
return cljs.core.namespace.call(null,p1__36350_SHARP_);
}
})(),cljs.core.name.call(null,p1__36350_SHARP_));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),new cljs.core.Symbol(null,"quote","quote",1377916282,null));
});})(mkns,mkn,ret,gmap,defaults,pvec,bents))
);
} else {
if(cljs.core._EQ_.call(null,mkn,"strs")){
return cljs.core.assoc.call(null,transforms,mk,cljs.core.str);
} else {
return transforms;

}
}
}
} else {
return transforms;
}
});})(ret,gmap,defaults,pvec,bents))
,cljs.core.PersistentArrayMap.EMPTY,cljs.core.keys.call(null,b__$1));
return cljs.core.reduce.call(null,((function (transforms,ret,gmap,defaults,pvec,bents){
return (function (bes,entry){
return cljs.core.reduce.call(null,((function (transforms,ret,gmap,defaults,pvec,bents){
return (function (p1__36351_SHARP_,p2__36352_SHARP_){
return cljs.core.assoc.call(null,p1__36351_SHARP_,p2__36352_SHARP_,cljs.core.val.call(null,entry).call(null,p2__36352_SHARP_));
});})(transforms,ret,gmap,defaults,pvec,bents))
,cljs.core.dissoc.call(null,bes,cljs.core.key.call(null,entry)),cljs.core.key.call(null,entry).call(null,bes));
});})(transforms,ret,gmap,defaults,pvec,bents))
,cljs.core.dissoc.call(null,b__$1,new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Keyword(null,"or","or",235744169)),transforms);
})();
while(true){
if(cljs.core.seq.call(null,bes)){
var bb = cljs.core.key.call(null,cljs.core.first.call(null,bes));
var bk = cljs.core.val.call(null,cljs.core.first.call(null,bes));
var local = ((((!((bb == null)))?((((bb.cljs$lang$protocol_mask$partition1$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === bb.cljs$core$INamed$)))?true:false):false))?cljs.core.with_meta.call(null,cljs.core.symbol.call(null,null,cljs.core.name.call(null,bb)),cljs.core.meta.call(null,bb)):bb);
var bv = ((cljs.core.contains_QMARK_.call(null,defaults,local))?cljs.core._conj.call(null,(function (){var x__9048__auto__ = gmap;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = bk;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$2 = defaults.call(null,local);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$2);
})(),x__9048__auto____$1);
})(),x__9048__auto__);
})(),new cljs.core.Symbol("cljs.core","get","cljs.core/get",-296075407,null)):cljs.core._conj.call(null,(function (){var x__9048__auto__ = gmap;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = bk;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})(),new cljs.core.Symbol("cljs.core","get","cljs.core/get",-296075407,null)));
var G__36363 = ((((bb instanceof cljs.core.Keyword)) || ((bb instanceof cljs.core.Symbol)))?cljs.core.conj.call(null,ret,local,bv):cljs$core$macros$destructure_$_pb.call(null,ret,bb,bv));
var G__36364 = cljs.core.next.call(null,bes);
ret = G__36363;
bes = G__36364;
continue;
} else {
return ret;
}
break;
}
});})(pvec,bents))
;
if((b instanceof cljs.core.Symbol)){
return cljs.core.conj.call(null,cljs.core.conj.call(null,bvec,(cljs.core.truth_(cljs.core.namespace.call(null,b))?cljs.core.symbol.call(null,cljs.core.name.call(null,b)):b)),v);
} else {
if((b instanceof cljs.core.Keyword)){
return cljs.core.conj.call(null,cljs.core.conj.call(null,bvec,cljs.core.symbol.call(null,cljs.core.name.call(null,b))),v);
} else {
if(cljs.core.vector_QMARK_.call(null,b)){
return pvec.call(null,bvec,b,v);
} else {
if(cljs.core.map_QMARK_.call(null,b)){
return pmap.call(null,bvec,b,v);
} else {
throw (new Error(["Unsupported binding form: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(b)].join('')));

}
}
}
}
});})(bents))
;
var process_entry = ((function (bents,pb){
return (function (bvec,b){
return pb.call(null,bvec,cljs.core.first.call(null,b),cljs.core.second.call(null,b));
});})(bents,pb))
;
if(cljs.core.every_QMARK_.call(null,cljs.core.symbol_QMARK_,cljs.core.map.call(null,cljs.core.first,bents))){
return bindings;
} else {
var temp__4655__auto__ = cljs.core.seq.call(null,cljs.core.filter.call(null,((function (bents,pb,process_entry){
return (function (p1__36353_SHARP_){
return (cljs.core.first.call(null,p1__36353_SHARP_) instanceof cljs.core.Keyword);
});})(bents,pb,process_entry))
,bents));
if(temp__4655__auto__){
var kwbs = temp__4655__auto__;
throw (new Error(["Unsupported binding key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.ffirst.call(null,kwbs))].join('')));
} else {
return cljs.core.reduce.call(null,process_entry,cljs.core.PersistentVector.EMPTY,bents);
}
}
});
var ret__9397__auto___36365 = /**
 * Defines a var using `goog.define`. Passed default value must be
 *   string, number or boolean.
 * 
 *   Default value can be overridden at compile time using the
 *   compiler option `:closure-defines`.
 * 
 *   Example:
 *  (ns your-app.core)
 *  (goog-define DEBUG! false)
 *  ;; can be overridden with
 *  :closure-defines {"your_app.core.DEBUG_BANG_" true}
 *  or
 *  :closure-defines {'your-app.core/DEBUG! true}
 */
cljs.core$macros.goog_define = (function cljs$core$macros$goog_define(_AMPERSAND_form,_AMPERSAND_env,sym,default$){
if((typeof default$ === 'string') || (typeof default$ === 'number') || (default$ === true) || (default$ === false)){
} else {
throw cljs.core.ex_info.call(null,"goog-define requires a string, number or boolean as default value",cljs.core.PersistentArrayMap.EMPTY);
}


var defname = cljs.compiler.munge.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core._STAR_ns_STAR_),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(sym)].join(''));
var type = ((typeof default$ === 'string')?"string":((typeof default$ === 'number')?"number":(((default$ === true) || (default$ === false))?"boolean":null)));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","declare","cljs.core$macros/declare",1172642527,null)),(function (){var x__9048__auto__ = cljs.core.symbol.call(null,sym);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"js*","js*",-1134233646,null)),(function (){var x__9048__auto__ = ["/** @define {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type),"} */"].join('');
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("goog","define","goog/define",-352722538,null)),(function (){var x__9048__auto__ = defname;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = default$;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});
cljs.core$macros.goog_define.cljs$lang$macro = true;

var ret__9397__auto___36370 = (function (){
/**
 * binding => binding-form init-expr
 * 
 *   Evaluates the exprs in a lexical context in which the symbols in
 *   the binding-forms are bound to their respective init-exprs or parts
 *   therein.
 */
cljs.core$macros.let$ = (function cljs$core$macros$let(var_args){
var args__9364__auto__ = [];
var len__9357__auto___36371 = arguments.length;
var i__9358__auto___36372 = (0);
while(true){
if((i__9358__auto___36372 < len__9357__auto___36371)){
args__9364__auto__.push((arguments[i__9358__auto___36372]));

var G__36373 = (i__9358__auto___36372 + (1));
i__9358__auto___36372 = G__36373;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((3) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.let$.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9365__auto__);
});

cljs.core$macros.let$.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,bindings,body){
if(cljs.core.vector_QMARK_.call(null,bindings)){
} else {
throw cljs.core.ex_info.call(null,"let requires a vector for its binding",cljs.core.PersistentArrayMap.EMPTY);
}

if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,bindings))){
} else {
throw cljs.core.ex_info.call(null,"let requires an even number of forms in binding vector",cljs.core.PersistentArrayMap.EMPTY);
}


return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"let*","let*",1920721458,null)),(function (){var x__9048__auto__ = cljs.core$macros.destructure.call(null,bindings);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),body)));
});

cljs.core$macros.let$.cljs$lang$maxFixedArity = (3);

cljs.core$macros.let$.cljs$lang$applyTo = (function (seq36366){
var G__36367 = cljs.core.first.call(null,seq36366);
var seq36366__$1 = cljs.core.next.call(null,seq36366);
var G__36368 = cljs.core.first.call(null,seq36366__$1);
var seq36366__$2 = cljs.core.next.call(null,seq36366__$1);
var G__36369 = cljs.core.first.call(null,seq36366__$2);
var seq36366__$3 = cljs.core.next.call(null,seq36366__$2);
return cljs.core$macros.let$.cljs$core$IFn$_invoke$arity$variadic(G__36367,G__36368,G__36369,seq36366__$3);
});

return null;
})()
;
cljs.core$macros.let$.cljs$lang$macro = true;

var ret__9397__auto___36382 = (function (){
/**
 * Evaluates the exprs in a lexical context in which the symbols in
 *   the binding-forms are bound to their respective init-exprs or parts
 *   therein. Acts as a recur target.
 */
cljs.core$macros.loop = (function cljs$core$macros$loop(var_args){
var args__9364__auto__ = [];
var len__9357__auto___36383 = arguments.length;
var i__9358__auto___36384 = (0);
while(true){
if((i__9358__auto___36384 < len__9357__auto___36383)){
args__9364__auto__.push((arguments[i__9358__auto___36384]));

var G__36385 = (i__9358__auto___36384 + (1));
i__9358__auto___36384 = G__36385;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((3) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.loop.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9365__auto__);
});

cljs.core$macros.loop.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,bindings,body){
if(cljs.core.vector_QMARK_.call(null,bindings)){
} else {
throw cljs.core.ex_info.call(null,"loop requires a vector for its binding",cljs.core.PersistentArrayMap.EMPTY);
}

if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,bindings))){
} else {
throw cljs.core.ex_info.call(null,"loop requires an even number of forms in binding vector",cljs.core.PersistentArrayMap.EMPTY);
}


var db = cljs.core$macros.destructure.call(null,bindings);
if(cljs.core._EQ_.call(null,db,bindings)){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"loop*","loop*",615029416,null)),(function (){var x__9048__auto__ = bindings;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),body)));
} else {
var vs = cljs.core.take_nth.call(null,(2),cljs.core.drop.call(null,(1),bindings));
var bs = cljs.core.take_nth.call(null,(2),bindings);
var gs = cljs.core.map.call(null,((function (vs,bs,db){
return (function (b){
if((b instanceof cljs.core.Symbol)){
return b;
} else {
return cljs.core.gensym.call(null);
}
});})(vs,bs,db))
,bs);
var bfs = cljs.core.reduce.call(null,((function (vs,bs,gs,db){
return (function (ret,p__36378){
var vec__36379 = p__36378;
var b = cljs.core.nth.call(null,vec__36379,(0),null);
var v = cljs.core.nth.call(null,vec__36379,(1),null);
var g = cljs.core.nth.call(null,vec__36379,(2),null);
if((b instanceof cljs.core.Symbol)){
return cljs.core.conj.call(null,ret,g,v);
} else {
return cljs.core.conj.call(null,ret,g,v,b,g);
}
});})(vs,bs,gs,db))
,cljs.core.PersistentVector.EMPTY,cljs.core.map.call(null,cljs.core.vector,bs,vs,gs));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = bfs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"loop*","loop*",615029416,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.interleave.call(null,gs,gs));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.interleave.call(null,bs,gs));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),body)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
}
});

cljs.core$macros.loop.cljs$lang$maxFixedArity = (3);

cljs.core$macros.loop.cljs$lang$applyTo = (function (seq36374){
var G__36375 = cljs.core.first.call(null,seq36374);
var seq36374__$1 = cljs.core.next.call(null,seq36374);
var G__36376 = cljs.core.first.call(null,seq36374__$1);
var seq36374__$2 = cljs.core.next.call(null,seq36374__$1);
var G__36377 = cljs.core.first.call(null,seq36374__$2);
var seq36374__$3 = cljs.core.next.call(null,seq36374__$2);
return cljs.core$macros.loop.cljs$core$IFn$_invoke$arity$variadic(G__36375,G__36376,G__36377,seq36374__$3);
});

return null;
})()
;
cljs.core$macros.loop.cljs$lang$macro = true;

/**
 * protocol fqn -> [partition number, bit]
 */
cljs.core$macros.fast_path_protocols = cljs.core.zipmap.call(null,cljs.core.map.call(null,(function (p1__36386_SHARP_){
return cljs.core.symbol.call(null,"cljs.core",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__36386_SHARP_)].join(''));
}),cljs.core.PersistentVector.fromArray([new cljs.core.Symbol(null,"IFn","IFn",-244881638,null),new cljs.core.Symbol(null,"ICounted","ICounted",-1705786327,null),new cljs.core.Symbol(null,"IEmptyableCollection","IEmptyableCollection",1477271438,null),new cljs.core.Symbol(null,"ICollection","ICollection",-686709190,null),new cljs.core.Symbol(null,"IIndexed","IIndexed",-574812826,null),new cljs.core.Symbol(null,"ASeq","ASeq",266390234,null),new cljs.core.Symbol(null,"ISeq","ISeq",1517365813,null),new cljs.core.Symbol(null,"INext","INext",562211849,null),new cljs.core.Symbol(null,"ILookup","ILookup",784647298,null),new cljs.core.Symbol(null,"IAssociative","IAssociative",-1306431882,null),new cljs.core.Symbol(null,"IMap","IMap",992876629,null),new cljs.core.Symbol(null,"IMapEntry","IMapEntry",-943754199,null),new cljs.core.Symbol(null,"ISet","ISet",-1398072657,null),new cljs.core.Symbol(null,"IStack","IStack",1136769449,null),new cljs.core.Symbol(null,"IVector","IVector",-1120721434,null),new cljs.core.Symbol(null,"IDeref","IDeref",1738423197,null),new cljs.core.Symbol(null,"IDerefWithTimeout","IDerefWithTimeout",2140974319,null),new cljs.core.Symbol(null,"IMeta","IMeta",1095313672,null),new cljs.core.Symbol(null,"IWithMeta","IWithMeta",-509493158,null),new cljs.core.Symbol(null,"IReduce","IReduce",-440384974,null),new cljs.core.Symbol(null,"IKVReduce","IKVReduce",-870856862,null),new cljs.core.Symbol(null,"IEquiv","IEquiv",-1912850869,null),new cljs.core.Symbol(null,"IHash","IHash",-1495374645,null),new cljs.core.Symbol(null,"ISeqable","ISeqable",1349682102,null),new cljs.core.Symbol(null,"ISequential","ISequential",-1626174217,null),new cljs.core.Symbol(null,"IList","IList",1682281311,null),new cljs.core.Symbol(null,"IRecord","IRecord",-903221169,null),new cljs.core.Symbol(null,"IReversible","IReversible",-723048599,null),new cljs.core.Symbol(null,"ISorted","ISorted",-253627362,null),new cljs.core.Symbol(null,"IPrintWithWriter","IPrintWithWriter",-1205316154,null),new cljs.core.Symbol(null,"IWriter","IWriter",-1681087107,null),new cljs.core.Symbol(null,"IPrintWithWriter","IPrintWithWriter",-1205316154,null),new cljs.core.Symbol(null,"IPending","IPending",1229113039,null),new cljs.core.Symbol(null,"IWatchable","IWatchable",-1929659016,null),new cljs.core.Symbol(null,"IEditableCollection","IEditableCollection",-906687187,null),new cljs.core.Symbol(null,"ITransientCollection","ITransientCollection",252832402,null),new cljs.core.Symbol(null,"ITransientAssociative","ITransientAssociative",-1612754624,null),new cljs.core.Symbol(null,"ITransientMap","ITransientMap",298423651,null),new cljs.core.Symbol(null,"ITransientVector","ITransientVector",1978793164,null),new cljs.core.Symbol(null,"ITransientSet","ITransientSet",-575559912,null),new cljs.core.Symbol(null,"IMultiFn","IMultiFn",-1848282794,null),new cljs.core.Symbol(null,"IChunkedSeq","IChunkedSeq",-1299765705,null),new cljs.core.Symbol(null,"IChunkedNext","IChunkedNext",1193289532,null),new cljs.core.Symbol(null,"IComparable","IComparable",1834481627,null),new cljs.core.Symbol(null,"INamed","INamed",357992946,null),new cljs.core.Symbol(null,"ICloneable","ICloneable",1882653160,null),new cljs.core.Symbol(null,"IAtom","IAtom",-1411134312,null),new cljs.core.Symbol(null,"IReset","IReset",-1893729426,null),new cljs.core.Symbol(null,"ISwap","ISwap",484378193,null),new cljs.core.Symbol(null,"IIterable","IIterable",577191430,null)], true)),cljs.core.iterate.call(null,(function (p__36387){
var vec__36388 = p__36387;
var p = cljs.core.nth.call(null,vec__36388,(0),null);
var b = cljs.core.nth.call(null,vec__36388,(1),null);
if(((2147483648) === b)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(p + (1)),(1)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,((2) * b)], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(1)], null)));
/**
 * total number of partitions
 */
cljs.core$macros.fast_path_protocol_partitions_count = (function (){var c = cljs.core.count.call(null,cljs.core$macros.fast_path_protocols);
var m = cljs.core.mod.call(null,c,(32));
if((m === (0))){
return cljs.core.quot.call(null,c,(32));
} else {
return (cljs.core.quot.call(null,c,(32)) + (1));
}
})();
var ret__9397__auto___36394 = (function (){
cljs.core$macros.str = (function cljs$core$macros$str(var_args){
var args__9364__auto__ = [];
var len__9357__auto___36395 = arguments.length;
var i__9358__auto___36396 = (0);
while(true){
if((i__9358__auto___36396 < len__9357__auto___36395)){
args__9364__auto__.push((arguments[i__9358__auto___36396]));

var G__36397 = (i__9358__auto___36396 + (1));
i__9358__auto___36396 = G__36397;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((2) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9365__auto__);
});

cljs.core$macros.str.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,xs){
var interpolate = (function (x){
if(typeof x === 'string'){
return "~{}";
} else {
return "cljs.core.str.cljs$core$IFn$_invoke$arity$1(~{})";
}
});
var strs = cljs.core.apply.call(null,cljs.core.str,cljs.core.interpose.call(null,",",cljs.core.map.call(null,interpolate,xs)));
return cljs.core.list_STAR_.call(null,new cljs.core.Symbol(null,"js*","js*",-1134233646,null),["[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(strs),"].join('')"].join(''),xs);
});

cljs.core$macros.str.cljs$lang$maxFixedArity = (2);

cljs.core$macros.str.cljs$lang$applyTo = (function (seq36391){
var G__36392 = cljs.core.first.call(null,seq36391);
var seq36391__$1 = cljs.core.next.call(null,seq36391);
var G__36393 = cljs.core.first.call(null,seq36391__$1);
var seq36391__$2 = cljs.core.next.call(null,seq36391__$1);
return cljs.core$macros.str.cljs$core$IFn$_invoke$arity$variadic(G__36392,G__36393,seq36391__$2);
});

return null;
})()
;
cljs.core$macros.str.cljs$lang$macro = true;

cljs.core$macros.bool_expr = (function cljs$core$macros$bool_expr(e){
return cljs.core.vary_meta.call(null,e,cljs.core.assoc,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null));
});
cljs.core$macros.simple_test_expr_QMARK_ = (function cljs$core$macros$simple_test_expr_QMARK_(env,ast){
var and__8174__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"js","js",1768080579),null,new cljs.core.Keyword(null,"constant","constant",-379609303),null,new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"invoke","invoke",1145927159),null,new cljs.core.Keyword(null,"dot","dot",1442709401),null], null), null).call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(ast));
if(cljs.core.truth_(and__8174__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null], null), null).call(null,cljs.analyzer.infer_tag.call(null,env,ast));
} else {
return and__8174__auto__;
}
});
var ret__9397__auto___36408 = (function (){
/**
 * Evaluates exprs one at a time, from left to right. If a form
 *   returns logical false (nil or false), and returns that value and
 *   doesn't evaluate any of the other expressions, otherwise it returns
 *   the value of the last expr. (and) returns true.
 */
cljs.core$macros.and = (function cljs$core$macros$and(var_args){
var G__36406 = arguments.length;
switch (G__36406) {
case 2:
return cljs.core$macros.and.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core$macros.and.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__9376__auto__ = [];
var len__9357__auto___36410 = arguments.length;
var i__9358__auto___36411 = (0);
while(true){
if((i__9358__auto___36411 < len__9357__auto___36410)){
args_arr__9376__auto__.push((arguments[i__9358__auto___36411]));

var G__36412 = (i__9358__auto___36411 + (1));
i__9358__auto___36411 = G__36412;
continue;
} else {
}
break;
}

var argseq__9377__auto__ = (new cljs.core.IndexedSeq(args_arr__9376__auto__.slice((3)),(0),null));
return cljs.core$macros.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9377__auto__);

}
});

cljs.core$macros.and.cljs$core$IFn$_invoke$arity$2 = (function (_AMPERSAND_form,_AMPERSAND_env){
return true;
});

cljs.core$macros.and.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,x){
return x;
});

cljs.core$macros.and.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,next){
var forms = cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [x], null),next);
if(cljs.core.every_QMARK_.call(null,((function (forms){
return (function (p1__36398_SHARP_){
return cljs.core$macros.simple_test_expr_QMARK_.call(null,_AMPERSAND_env,p1__36398_SHARP_);
});})(forms))
,cljs.core.map.call(null,((function (forms){
return (function (p1__36399_SHARP_){
var _STAR_cljs_warnings_STAR_36407 = cljs.analyzer._STAR_cljs_warnings_STAR_;
cljs.analyzer._STAR_cljs_warnings_STAR_ = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"invoke-ctor","invoke-ctor",-756052704),new cljs.core.Keyword(null,"extending-base-js-type","extending-base-js-type",432787264),new cljs.core.Keyword(null,"unsupported-preprocess-value","unsupported-preprocess-value",1635147105),new cljs.core.Keyword(null,"redef","redef",1032704258),new cljs.core.Keyword(null,"js-shadowed-by-local","js-shadowed-by-local",198048291),new cljs.core.Keyword(null,"unsupported-js-module-type","unsupported-js-module-type",1806206180),new cljs.core.Keyword(null,"invalid-protocol-symbol","invalid-protocol-symbol",86246948),new cljs.core.Keyword(null,"protocol-duped-method","protocol-duped-method",15128166),new cljs.core.Keyword(null,"munged-namespace","munged-namespace",-101986199),new cljs.core.Keyword(null,"single-segment-namespace","single-segment-namespace",-491924469),new cljs.core.Keyword(null,"fn-arity","fn-arity",-403576501),new cljs.core.Keyword(null,"infer-warning","infer-warning",-1600671410),new cljs.core.Keyword(null,"variadic-max-arity","variadic-max-arity",-14288402),new cljs.core.Keyword(null,"protocol-with-variadic-method","protocol-with-variadic-method",-693368178),new cljs.core.Keyword(null,"fn-deprecated","fn-deprecated",626877647),new cljs.core.Keyword(null,"undeclared-var","undeclared-var",-1624364944),new cljs.core.Keyword(null,"preamble-missing","preamble-missing",220974801),new cljs.core.Keyword(null,"undeclared-protocol-symbol","undeclared-protocol-symbol",462882867),new cljs.core.Keyword(null,"dynamic","dynamic",704819571),new cljs.core.Keyword(null,"invalid-array-access","invalid-array-access",-1747132236),new cljs.core.Keyword(null,"unprovided","unprovided",-652330764),new cljs.core.Keyword(null,"ns-var-clash","ns-var-clash",-280494668),new cljs.core.Keyword(null,"undeclared-ns","undeclared-ns",-1589012812),new cljs.core.Keyword(null,"undeclared-ns-form","undeclared-ns-form",-248024137),new cljs.core.Keyword(null,"invalid-arithmetic","invalid-arithmetic",1917075065),new cljs.core.Keyword(null,"protocol-deprecated","protocol-deprecated",103233497),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"protocol-impl-recur-with-target","protocol-impl-recur-with-target",-1648321574),new cljs.core.Keyword(null,"overload-arity","overload-arity",823206044),new cljs.core.Keyword(null,"protocol-multiple-impls","protocol-multiple-impls",794179260),new cljs.core.Keyword(null,"redef-in-file","redef-in-file",-476530788),new cljs.core.Keyword(null,"protocol-invalid-method","protocol-invalid-method",522647516),new cljs.core.Keyword(null,"extend-type-invalid-method-shape","extend-type-invalid-method-shape",1424103549),new cljs.core.Keyword(null,"multiple-variadic-overloads","multiple-variadic-overloads",1110059837),new cljs.core.Keyword(null,"protocol-impl-with-variadic-method","protocol-impl-with-variadic-method",-319321217)],[false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false]);

try{return cljs.analyzer.analyze.call(null,_AMPERSAND_env,p1__36399_SHARP_);
}finally {cljs.analyzer._STAR_cljs_warnings_STAR_ = _STAR_cljs_warnings_STAR_36407;
}});})(forms))
,forms))){
var and_str = cljs.core.apply.call(null,cljs.core.str,cljs.core.interpose.call(null," && ",cljs.core.repeat.call(null,cljs.core.count.call(null,forms),"(~{})")));
return cljs.core$macros.bool_expr.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"js*","js*",-1134233646,null)),(function (){var x__9048__auto__ = and_str;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),forms))));
} else {
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"and__36400__auto__","and__36400__auto__",-986351367,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"and__36400__auto__","and__36400__auto__",-986351367,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","and","cljs.core$macros/and",48320334,null)),next)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"and__36400__auto__","and__36400__auto__",-986351367,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
}
});

cljs.core$macros.and.cljs$lang$applyTo = (function (seq36402){
var G__36403 = cljs.core.first.call(null,seq36402);
var seq36402__$1 = cljs.core.next.call(null,seq36402);
var G__36404 = cljs.core.first.call(null,seq36402__$1);
var seq36402__$2 = cljs.core.next.call(null,seq36402__$1);
var G__36405 = cljs.core.first.call(null,seq36402__$2);
var seq36402__$3 = cljs.core.next.call(null,seq36402__$2);
return cljs.core$macros.and.cljs$core$IFn$_invoke$arity$variadic(G__36403,G__36404,G__36405,seq36402__$3);
});

cljs.core$macros.and.cljs$lang$maxFixedArity = (3);

return null;
})()
;
cljs.core$macros.and.cljs$lang$macro = true;

var ret__9397__auto___36423 = (function (){
/**
 * Evaluates exprs one at a time, from left to right. If a form
 *   returns a logical true value, or returns that value and doesn't
 *   evaluate any of the other expressions, otherwise it returns the
 *   value of the last expression. (or) returns nil.
 */
cljs.core$macros.or = (function cljs$core$macros$or(var_args){
var G__36421 = arguments.length;
switch (G__36421) {
case 2:
return cljs.core$macros.or.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core$macros.or.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__9376__auto__ = [];
var len__9357__auto___36425 = arguments.length;
var i__9358__auto___36426 = (0);
while(true){
if((i__9358__auto___36426 < len__9357__auto___36425)){
args_arr__9376__auto__.push((arguments[i__9358__auto___36426]));

var G__36427 = (i__9358__auto___36426 + (1));
i__9358__auto___36426 = G__36427;
continue;
} else {
}
break;
}

var argseq__9377__auto__ = (new cljs.core.IndexedSeq(args_arr__9376__auto__.slice((3)),(0),null));
return cljs.core$macros.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9377__auto__);

}
});

cljs.core$macros.or.cljs$core$IFn$_invoke$arity$2 = (function (_AMPERSAND_form,_AMPERSAND_env){
return null;
});

cljs.core$macros.or.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,x){
return x;
});

cljs.core$macros.or.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,next){
var forms = cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [x], null),next);
if(cljs.core.every_QMARK_.call(null,((function (forms){
return (function (p1__36413_SHARP_){
return cljs.core$macros.simple_test_expr_QMARK_.call(null,_AMPERSAND_env,p1__36413_SHARP_);
});})(forms))
,cljs.core.map.call(null,((function (forms){
return (function (p1__36414_SHARP_){
var _STAR_cljs_warnings_STAR_36422 = cljs.analyzer._STAR_cljs_warnings_STAR_;
cljs.analyzer._STAR_cljs_warnings_STAR_ = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"invoke-ctor","invoke-ctor",-756052704),new cljs.core.Keyword(null,"extending-base-js-type","extending-base-js-type",432787264),new cljs.core.Keyword(null,"unsupported-preprocess-value","unsupported-preprocess-value",1635147105),new cljs.core.Keyword(null,"redef","redef",1032704258),new cljs.core.Keyword(null,"js-shadowed-by-local","js-shadowed-by-local",198048291),new cljs.core.Keyword(null,"unsupported-js-module-type","unsupported-js-module-type",1806206180),new cljs.core.Keyword(null,"invalid-protocol-symbol","invalid-protocol-symbol",86246948),new cljs.core.Keyword(null,"protocol-duped-method","protocol-duped-method",15128166),new cljs.core.Keyword(null,"munged-namespace","munged-namespace",-101986199),new cljs.core.Keyword(null,"single-segment-namespace","single-segment-namespace",-491924469),new cljs.core.Keyword(null,"fn-arity","fn-arity",-403576501),new cljs.core.Keyword(null,"infer-warning","infer-warning",-1600671410),new cljs.core.Keyword(null,"variadic-max-arity","variadic-max-arity",-14288402),new cljs.core.Keyword(null,"protocol-with-variadic-method","protocol-with-variadic-method",-693368178),new cljs.core.Keyword(null,"fn-deprecated","fn-deprecated",626877647),new cljs.core.Keyword(null,"undeclared-var","undeclared-var",-1624364944),new cljs.core.Keyword(null,"preamble-missing","preamble-missing",220974801),new cljs.core.Keyword(null,"undeclared-protocol-symbol","undeclared-protocol-symbol",462882867),new cljs.core.Keyword(null,"dynamic","dynamic",704819571),new cljs.core.Keyword(null,"invalid-array-access","invalid-array-access",-1747132236),new cljs.core.Keyword(null,"unprovided","unprovided",-652330764),new cljs.core.Keyword(null,"ns-var-clash","ns-var-clash",-280494668),new cljs.core.Keyword(null,"undeclared-ns","undeclared-ns",-1589012812),new cljs.core.Keyword(null,"undeclared-ns-form","undeclared-ns-form",-248024137),new cljs.core.Keyword(null,"invalid-arithmetic","invalid-arithmetic",1917075065),new cljs.core.Keyword(null,"protocol-deprecated","protocol-deprecated",103233497),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"protocol-impl-recur-with-target","protocol-impl-recur-with-target",-1648321574),new cljs.core.Keyword(null,"overload-arity","overload-arity",823206044),new cljs.core.Keyword(null,"protocol-multiple-impls","protocol-multiple-impls",794179260),new cljs.core.Keyword(null,"redef-in-file","redef-in-file",-476530788),new cljs.core.Keyword(null,"protocol-invalid-method","protocol-invalid-method",522647516),new cljs.core.Keyword(null,"extend-type-invalid-method-shape","extend-type-invalid-method-shape",1424103549),new cljs.core.Keyword(null,"multiple-variadic-overloads","multiple-variadic-overloads",1110059837),new cljs.core.Keyword(null,"protocol-impl-with-variadic-method","protocol-impl-with-variadic-method",-319321217)],[false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false]);

try{return cljs.analyzer.analyze.call(null,_AMPERSAND_env,p1__36414_SHARP_);
}finally {cljs.analyzer._STAR_cljs_warnings_STAR_ = _STAR_cljs_warnings_STAR_36422;
}});})(forms))
,forms))){
var or_str = cljs.core.apply.call(null,cljs.core.str,cljs.core.interpose.call(null," || ",cljs.core.repeat.call(null,cljs.core.count.call(null,forms),"(~{})")));
return cljs.core$macros.bool_expr.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"js*","js*",-1134233646,null)),(function (){var x__9048__auto__ = or_str;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),forms))));
} else {
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"or__36415__auto__","or__36415__auto__",1166663247,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"or__36415__auto__","or__36415__auto__",1166663247,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"or__36415__auto__","or__36415__auto__",1166663247,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","or","cljs.core$macros/or",1346243648,null)),next)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
}
});

cljs.core$macros.or.cljs$lang$applyTo = (function (seq36417){
var G__36418 = cljs.core.first.call(null,seq36417);
var seq36417__$1 = cljs.core.next.call(null,seq36417);
var G__36419 = cljs.core.first.call(null,seq36417__$1);
var seq36417__$2 = cljs.core.next.call(null,seq36417__$1);
var G__36420 = cljs.core.first.call(null,seq36417__$2);
var seq36417__$3 = cljs.core.next.call(null,seq36417__$2);
return cljs.core$macros.or.cljs$core$IFn$_invoke$arity$variadic(G__36418,G__36419,G__36420,seq36417__$3);
});

cljs.core$macros.or.cljs$lang$maxFixedArity = (3);

return null;
})()
;
cljs.core$macros.or.cljs$lang$macro = true;

var ret__9397__auto___36428 = cljs.core$macros.nil_QMARK_ = (function cljs$core$macros$nil_QMARK_(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","coercive-=","cljs.core$macros/coercive-=",-1655776086,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null))));
});
cljs.core$macros.nil_QMARK_.cljs$lang$macro = true;

var ret__9397__auto___36429 = cljs.core$macros.some_QMARK_ = (function cljs$core$macros$some_QMARK_(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","nil?","cljs.core$macros/nil?",83624258,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});
cljs.core$macros.some_QMARK_.cljs$lang$macro = true;

var ret__9397__auto___36430 = cljs.core$macros.coercive_not = (function cljs$core$macros$coercive_not(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core$macros.bool_expr.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),"(!~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null)));
});
cljs.core$macros.coercive_not.cljs$lang$macro = true;

var ret__9397__auto___36431 = cljs.core$macros.coercive_not_EQ_ = (function cljs$core$macros$coercive_not_EQ_(_AMPERSAND_form,_AMPERSAND_env,x,y){
return cljs.core$macros.bool_expr.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})(),"(~{} != ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null)));
});
cljs.core$macros.coercive_not_EQ_.cljs$lang$macro = true;

var ret__9397__auto___36432 = cljs.core$macros.coercive__EQ_ = (function cljs$core$macros$coercive__EQ_(_AMPERSAND_form,_AMPERSAND_env,x,y){
return cljs.core$macros.bool_expr.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})(),"(~{} == ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null)));
});
cljs.core$macros.coercive__EQ_.cljs$lang$macro = true;

var ret__9397__auto___36433 = cljs.core$macros.coercive_boolean = (function cljs$core$macros$coercive_boolean(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core.with_meta.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),"~{}"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null)),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null)], null));
});
cljs.core$macros.coercive_boolean.cljs$lang$macro = true;

var ret__9397__auto___36434 = cljs.core$macros.truth_ = (function cljs$core$macros$truth_(_AMPERSAND_form,_AMPERSAND_env,x){
if((x instanceof cljs.core.Symbol)){
} else {
throw (new Error(["Assert failed: ","x is substituted twice","\n","(core/symbol? x)"].join('')));
}

return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})(),"(~{} != null && ~{} !== false)"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.truth_.cljs$lang$macro = true;

var ret__9397__auto___36435 = cljs.core$macros.js_arguments = (function cljs$core$macros$js_arguments(_AMPERSAND_form,_AMPERSAND_env){
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,"arguments"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.js_arguments.cljs$lang$macro = true;

var ret__9397__auto___36436 = cljs.core$macros.js_delete = (function cljs$core$macros$js_delete(_AMPERSAND_form,_AMPERSAND_env,obj,key){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = obj;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = key;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})(),"delete ~{}[~{}]"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.js_delete.cljs$lang$macro = true;

var ret__9397__auto___36437 = cljs.core$macros.js_in = (function cljs$core$macros$js_in(_AMPERSAND_form,_AMPERSAND_env,key,obj){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = key;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = obj;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})(),"~{} in ~{}"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.js_in.cljs$lang$macro = true;

var ret__9397__auto___36438 = /**
 * Emit JavaScript "debugger;" statement
 */
cljs.core$macros.js_debugger = (function cljs$core$macros$js_debugger(_AMPERSAND_form,_AMPERSAND_env){
return cljs.core._conj.call(null,(function (){var x__9048__auto__ = cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,"debugger"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,null),x__9048__auto__);
})(),new cljs.core.Symbol(null,"do","do",1686842252,null));
});
cljs.core$macros.js_debugger.cljs$lang$macro = true;

var ret__9397__auto___36443 = /**
 * Emit a top-level JavaScript multi-line comment. New lines will create a
 *   new comment line. Comment block will be preceded and followed by a newline
 */
cljs.core$macros.js_comment = (function cljs$core$macros$js_comment(_AMPERSAND_form,_AMPERSAND_env,comment){
var vec__36440 = clojure.string.split.call(null,comment,/\n/);
var seq__36441 = cljs.core.seq.call(null,vec__36440);
var first__36442 = cljs.core.first.call(null,seq__36441);
var seq__36441__$1 = cljs.core.next.call(null,seq__36441);
var x = first__36442;
var ys = seq__36441__$1;
return cljs.core._conj.call(null,(function (){var x__9048__auto__ = ["\n/**\n",cljs.core.str.cljs$core$IFn$_invoke$arity$1([" * ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\n"].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.reduce.call(null,cljs.core.str,"",cljs.core.map.call(null,((function (vec__36440,seq__36441,first__36442,seq__36441__$1,x,ys){
return (function (p1__36439_SHARP_){
return [" * ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.replace.call(null,p1__36439_SHARP_,/^   /,"")),"\n"].join('');
});})(vec__36440,seq__36441,first__36442,seq__36441__$1,x,ys))
,ys)))," */\n"].join('');
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.js_comment.cljs$lang$macro = true;

var ret__9397__auto___36444 = /**
 * EXPERIMENTAL: Subject to change. Unsafely cast a value to a different type.
 */
cljs.core$macros.unsafe_cast = (function cljs$core$macros$unsafe_cast(_AMPERSAND_form,_AMPERSAND_env,t,x){
var cast_expr = ["~{} = /** @type {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(t),"} */ (~{})"].join('');
return cljs.core._conj.call(null,(function (){var x__9048__auto__ = cast_expr;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = x;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$2 = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$2);
})(),x__9048__auto____$1);
})(),x__9048__auto__);
})(),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.unsafe_cast.cljs$lang$macro = true;

var ret__9397__auto___36445 = /**
 * Emit an inline JavaScript comment.
 */
cljs.core$macros.js_inline_comment = (function cljs$core$macros$js_inline_comment(_AMPERSAND_form,_AMPERSAND_env,comment){
return cljs.core._conj.call(null,(function (){var x__9048__auto__ = ["/**",cljs.core.str.cljs$core$IFn$_invoke$arity$1(comment),"*/"].join('');
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.js_inline_comment.cljs$lang$macro = true;

var ret__9397__auto___36446 = cljs.core$macros.true_QMARK_ = (function cljs$core$macros$true_QMARK_(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core$macros.bool_expr.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),"~{} === true"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null)));
});
cljs.core$macros.true_QMARK_.cljs$lang$macro = true;

var ret__9397__auto___36447 = cljs.core$macros.false_QMARK_ = (function cljs$core$macros$false_QMARK_(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core$macros.bool_expr.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),"~{} === false"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null)));
});
cljs.core$macros.false_QMARK_.cljs$lang$macro = true;

var ret__9397__auto___36448 = cljs.core$macros.string_QMARK_ = (function cljs$core$macros$string_QMARK_(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core$macros.bool_expr.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),"typeof ~{} === 'string'"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null)));
});
cljs.core$macros.string_QMARK_.cljs$lang$macro = true;

var ret__9397__auto___36449 = /**
 * Return true if argument exists, analogous to usage of typeof operator
 * in JavaScript.
 */
cljs.core$macros.exists_QMARK_ = (function cljs$core$macros$exists_QMARK_(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core$macros.bool_expr.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = cljs.core.vary_meta.call(null,x,cljs.core.assoc,new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),"typeof ~{} !== 'undefined'"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null)));
});
cljs.core$macros.exists_QMARK_.cljs$lang$macro = true;

var ret__9397__auto___36450 = /**
 * Return true if argument is identical to the JavaScript undefined value.
 */
cljs.core$macros.undefined_QMARK_ = (function cljs$core$macros$undefined_QMARK_(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core$macros.bool_expr.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),"(void 0 === ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null)));
});
cljs.core$macros.undefined_QMARK_.cljs$lang$macro = true;

var ret__9397__auto___36451 = cljs.core$macros.identical_QMARK_ = (function cljs$core$macros$identical_QMARK_(_AMPERSAND_form,_AMPERSAND_env,a,b){
return cljs.core$macros.bool_expr.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = a;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = b;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})(),"(~{} === ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null)));
});
cljs.core$macros.identical_QMARK_.cljs$lang$macro = true;

var ret__9397__auto___36454 = cljs.core$macros.instance_QMARK_ = (function cljs$core$macros$instance_QMARK_(_AMPERSAND_form,_AMPERSAND_env,c,x){
return cljs.core$macros.bool_expr.call(null,(((c instanceof cljs.core.Symbol))?cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = c;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})(),"(~{} instanceof ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null)):cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"c__36452__auto__","c__36452__auto__",-1458978436,null)),(function (){var x__9048__auto__ = c;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"x__36453__auto__","x__36453__auto__",585800169,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"js*","js*",-1134233646,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,"(~{} instanceof ~{})"),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"x__36453__auto__","x__36453__auto__",585800169,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"c__36452__auto__","c__36452__auto__",-1458978436,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())))));
});
cljs.core$macros.instance_QMARK_.cljs$lang$macro = true;

var ret__9397__auto___36455 = cljs.core$macros.number_QMARK_ = (function cljs$core$macros$number_QMARK_(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core$macros.bool_expr.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),"typeof ~{} === 'number'"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null)));
});
cljs.core$macros.number_QMARK_.cljs$lang$macro = true;

var ret__9397__auto___36456 = cljs.core$macros.symbol_QMARK_ = (function cljs$core$macros$symbol_QMARK_(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core$macros.bool_expr.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","instance?","cljs.core$macros/instance?",1829750179,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","Symbol","cljs.core/Symbol",292989338,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
});
cljs.core$macros.symbol_QMARK_.cljs$lang$macro = true;

var ret__9397__auto___36457 = cljs.core$macros.keyword_QMARK_ = (function cljs$core$macros$keyword_QMARK_(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core$macros.bool_expr.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","instance?","cljs.core$macros/instance?",1829750179,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","Keyword","cljs.core/Keyword",-451434488,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
});
cljs.core$macros.keyword_QMARK_.cljs$lang$macro = true;

var ret__9397__auto___36467 = (function (){
cljs.core$macros.aget = (function cljs$core$macros$aget(var_args){
var G__36464 = arguments.length;
switch (G__36464) {
case 4:
return cljs.core$macros.aget.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__9376__auto__ = [];
var len__9357__auto___36469 = arguments.length;
var i__9358__auto___36470 = (0);
while(true){
if((i__9358__auto___36470 < len__9357__auto___36469)){
args_arr__9376__auto__.push((arguments[i__9358__auto___36470]));

var G__36471 = (i__9358__auto___36470 + (1));
i__9358__auto___36470 = G__36471;
continue;
} else {
}
break;
}

var argseq__9377__auto__ = (new cljs.core.IndexedSeq(args_arr__9376__auto__.slice((4)),(0),null));
return cljs.core$macros.aget.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__9377__auto__);

}
});

cljs.core$macros.aget.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,array,idx){
var G__36465 = cljs.analyzer.checked_arrays.call(null);
var G__36465__$1 = (((G__36465 instanceof cljs.core.Keyword))?G__36465.fqn:null);
switch (G__36465__$1) {
case "warn":
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","checked-aget","cljs.core/checked-aget",24024561,null)),(function (){var x__9048__auto__ = array;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = idx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));

break;
case "error":
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","checked-aget'","cljs.core/checked-aget'",1960922245,null)),(function (){var x__9048__auto__ = array;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = idx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));

break;
default:
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = array;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = idx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})(),"(~{}[~{}])"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));

}
});

cljs.core$macros.aget.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,array,idx,idxs){
var G__36466 = cljs.analyzer.checked_arrays.call(null);
var G__36466__$1 = (((G__36466 instanceof cljs.core.Keyword))?G__36466.fqn:null);
switch (G__36466__$1) {
case "warn":
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","checked-aget","cljs.core/checked-aget",24024561,null)),(function (){var x__9048__auto__ = array;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = idx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),idxs)));

break;
case "error":
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","checked-aget'","cljs.core/checked-aget'",1960922245,null)),(function (){var x__9048__auto__ = array;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = idx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),idxs)));

break;
default:
var astr = cljs.core.apply.call(null,cljs.core.str,cljs.core.repeat.call(null,cljs.core.count.call(null,idxs),"[~{}]"));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"js*","js*",-1134233646,null)),(function (){var x__9048__auto__ = ["(~{}[~{}]",cljs.core.str.cljs$core$IFn$_invoke$arity$1(astr),")"].join('');
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = array;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = idx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),idxs)));

}
});

cljs.core$macros.aget.cljs$lang$applyTo = (function (seq36459){
var G__36460 = cljs.core.first.call(null,seq36459);
var seq36459__$1 = cljs.core.next.call(null,seq36459);
var G__36461 = cljs.core.first.call(null,seq36459__$1);
var seq36459__$2 = cljs.core.next.call(null,seq36459__$1);
var G__36462 = cljs.core.first.call(null,seq36459__$2);
var seq36459__$3 = cljs.core.next.call(null,seq36459__$2);
var G__36463 = cljs.core.first.call(null,seq36459__$3);
var seq36459__$4 = cljs.core.next.call(null,seq36459__$3);
return cljs.core$macros.aget.cljs$core$IFn$_invoke$arity$variadic(G__36460,G__36461,G__36462,G__36463,seq36459__$4);
});

cljs.core$macros.aget.cljs$lang$maxFixedArity = (4);

return null;
})()
;
cljs.core$macros.aget.cljs$lang$macro = true;

var ret__9397__auto___36484 = (function (){
cljs.core$macros.aset = (function cljs$core$macros$aset(var_args){
var G__36481 = arguments.length;
switch (G__36481) {
case 5:
return cljs.core$macros.aset.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__9376__auto__ = [];
var len__9357__auto___36486 = arguments.length;
var i__9358__auto___36487 = (0);
while(true){
if((i__9358__auto___36487 < len__9357__auto___36486)){
args_arr__9376__auto__.push((arguments[i__9358__auto___36487]));

var G__36488 = (i__9358__auto___36487 + (1));
i__9358__auto___36487 = G__36488;
continue;
} else {
}
break;
}

var argseq__9377__auto__ = (new cljs.core.IndexedSeq(args_arr__9376__auto__.slice((5)),(0),null));
return cljs.core$macros.aset.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__9377__auto__);

}
});

cljs.core$macros.aset.cljs$core$IFn$_invoke$arity$5 = (function (_AMPERSAND_form,_AMPERSAND_env,array,idx,val){
var G__36482 = cljs.analyzer.checked_arrays.call(null);
var G__36482__$1 = (((G__36482 instanceof cljs.core.Keyword))?G__36482.fqn:null);
switch (G__36482__$1) {
case "warn":
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","checked-aset","cljs.core/checked-aset",-2080232353,null)),(function (){var x__9048__auto__ = array;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = idx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = val;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));

break;
case "error":
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","checked-aset'","cljs.core/checked-aset'",163859714,null)),(function (){var x__9048__auto__ = array;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = idx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = val;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));

break;
default:
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = array;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = idx;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$2 = val;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$2);
})(),x__9048__auto____$1);
})(),x__9048__auto__);
})(),"(~{}[~{}] = ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));

}
});

cljs.core$macros.aset.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,array,idx,idx2,idxv){
var G__36483 = cljs.analyzer.checked_arrays.call(null);
var G__36483__$1 = (((G__36483 instanceof cljs.core.Keyword))?G__36483.fqn:null);
switch (G__36483__$1) {
case "warn":
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","checked-aset","cljs.core/checked-aset",-2080232353,null)),(function (){var x__9048__auto__ = array;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = idx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = idx2;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),idxv)));

break;
case "error":
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","checked-aset'","cljs.core/checked-aset'",163859714,null)),(function (){var x__9048__auto__ = array;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = idx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = idx2;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),idxv)));

break;
default:
var n = (cljs.core.count.call(null,idxv) - (1));
var astr = cljs.core.apply.call(null,cljs.core.str,cljs.core.repeat.call(null,n,"[~{}]"));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"js*","js*",-1134233646,null)),(function (){var x__9048__auto__ = ["(~{}[~{}][~{}]",cljs.core.str.cljs$core$IFn$_invoke$arity$1(astr)," = ~{})"].join('');
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = array;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = idx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = idx2;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),idxv)));

}
});

cljs.core$macros.aset.cljs$lang$applyTo = (function (seq36475){
var G__36476 = cljs.core.first.call(null,seq36475);
var seq36475__$1 = cljs.core.next.call(null,seq36475);
var G__36477 = cljs.core.first.call(null,seq36475__$1);
var seq36475__$2 = cljs.core.next.call(null,seq36475__$1);
var G__36478 = cljs.core.first.call(null,seq36475__$2);
var seq36475__$3 = cljs.core.next.call(null,seq36475__$2);
var G__36479 = cljs.core.first.call(null,seq36475__$3);
var seq36475__$4 = cljs.core.next.call(null,seq36475__$3);
var G__36480 = cljs.core.first.call(null,seq36475__$4);
var seq36475__$5 = cljs.core.next.call(null,seq36475__$4);
return cljs.core$macros.aset.cljs$core$IFn$_invoke$arity$variadic(G__36476,G__36477,G__36478,G__36479,G__36480,seq36475__$5);
});

cljs.core$macros.aset.cljs$lang$maxFixedArity = (5);

return null;
})()
;
cljs.core$macros.aset.cljs$lang$macro = true;

var ret__9397__auto___36491 = /**
 * INTERNAL. Compiles to JavaScript property access using bracket notation. Does
 *   not distinguish between object and array types and not subject to compiler
 *   static analysis.
 */
cljs.core$macros.unchecked_get = (function cljs$core$macros$unchecked_get(_AMPERSAND_form,_AMPERSAND_env,obj,key){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = obj;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = key;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})(),"(~{}[~{}])"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.unchecked_get.cljs$lang$macro = true;

var ret__9397__auto___36492 = /**
 * INTERNAL. Compiles to JavaScript property access using bracket notation. Does
 *   not distinguish between object and array types and not subject to compiler
 *   static analysis.
 */
cljs.core$macros.unchecked_set = (function cljs$core$macros$unchecked_set(_AMPERSAND_form,_AMPERSAND_env,obj,key,val){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = obj;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = key;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$2 = val;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$2);
})(),x__9048__auto____$1);
})(),x__9048__auto__);
})(),"(~{}[~{}] = ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.unchecked_set.cljs$lang$macro = true;

var ret__9397__auto___36500 = (function (){
cljs.core$macros._PLUS_ = (function cljs$core$macros$_PLUS_(var_args){
var G__36499 = arguments.length;
switch (G__36499) {
case 2:
return cljs.core$macros._PLUS_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core$macros._PLUS_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core$macros._PLUS_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__9376__auto__ = [];
var len__9357__auto___36502 = arguments.length;
var i__9358__auto___36503 = (0);
while(true){
if((i__9358__auto___36503 < len__9357__auto___36502)){
args_arr__9376__auto__.push((arguments[i__9358__auto___36503]));

var G__36504 = (i__9358__auto___36503 + (1));
i__9358__auto___36503 = G__36504;
continue;
} else {
}
break;
}

var argseq__9377__auto__ = (new cljs.core.IndexedSeq(args_arr__9376__auto__.slice((4)),(0),null));
return cljs.core$macros._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__9377__auto__);

}
});

cljs.core$macros._PLUS_.cljs$core$IFn$_invoke$arity$2 = (function (_AMPERSAND_form,_AMPERSAND_env){
return (0);
});

cljs.core$macros._PLUS_.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,x){
return x;
});

cljs.core$macros._PLUS_.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,x,y){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})(),"(~{} + ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});

cljs.core$macros._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,y,more){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","+","cljs.core$macros/+",-18260342,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","+","cljs.core$macros/+",-18260342,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),more)));
});

cljs.core$macros._PLUS_.cljs$lang$applyTo = (function (seq36494){
var G__36495 = cljs.core.first.call(null,seq36494);
var seq36494__$1 = cljs.core.next.call(null,seq36494);
var G__36496 = cljs.core.first.call(null,seq36494__$1);
var seq36494__$2 = cljs.core.next.call(null,seq36494__$1);
var G__36497 = cljs.core.first.call(null,seq36494__$2);
var seq36494__$3 = cljs.core.next.call(null,seq36494__$2);
var G__36498 = cljs.core.first.call(null,seq36494__$3);
var seq36494__$4 = cljs.core.next.call(null,seq36494__$3);
return cljs.core$macros._PLUS_.cljs$core$IFn$_invoke$arity$variadic(G__36495,G__36496,G__36497,G__36498,seq36494__$4);
});

cljs.core$macros._PLUS_.cljs$lang$maxFixedArity = (4);

return null;
})()
;
cljs.core$macros._PLUS_.cljs$lang$macro = true;

var ret__9397__auto___36505 = cljs.core$macros.byte$ = (function cljs$core$macros$byte(_AMPERSAND_form,_AMPERSAND_env,x){
return x;
});
cljs.core$macros.byte$.cljs$lang$macro = true;

var ret__9397__auto___36506 = cljs.core$macros.short$ = (function cljs$core$macros$short(_AMPERSAND_form,_AMPERSAND_env,x){
return x;
});
cljs.core$macros.short$.cljs$lang$macro = true;

var ret__9397__auto___36507 = cljs.core$macros.float$ = (function cljs$core$macros$float(_AMPERSAND_form,_AMPERSAND_env,x){
return x;
});
cljs.core$macros.float$.cljs$lang$macro = true;

var ret__9397__auto___36508 = cljs.core$macros.double$ = (function cljs$core$macros$double(_AMPERSAND_form,_AMPERSAND_env,x){
return x;
});
cljs.core$macros.double$.cljs$lang$macro = true;

var ret__9397__auto___36509 = cljs.core$macros.unchecked_byte = (function cljs$core$macros$unchecked_byte(_AMPERSAND_form,_AMPERSAND_env,x){
return x;
});
cljs.core$macros.unchecked_byte.cljs$lang$macro = true;

var ret__9397__auto___36510 = cljs.core$macros.unchecked_char = (function cljs$core$macros$unchecked_char(_AMPERSAND_form,_AMPERSAND_env,x){
return x;
});
cljs.core$macros.unchecked_char.cljs$lang$macro = true;

var ret__9397__auto___36511 = cljs.core$macros.unchecked_short = (function cljs$core$macros$unchecked_short(_AMPERSAND_form,_AMPERSAND_env,x){
return x;
});
cljs.core$macros.unchecked_short.cljs$lang$macro = true;

var ret__9397__auto___36512 = cljs.core$macros.unchecked_float = (function cljs$core$macros$unchecked_float(_AMPERSAND_form,_AMPERSAND_env,x){
return x;
});
cljs.core$macros.unchecked_float.cljs$lang$macro = true;

var ret__9397__auto___36513 = cljs.core$macros.unchecked_double = (function cljs$core$macros$unchecked_double(_AMPERSAND_form,_AMPERSAND_env,x){
return x;
});
cljs.core$macros.unchecked_double.cljs$lang$macro = true;

var ret__9397__auto___36517 = (function (){
cljs.core$macros.unchecked_add = (function cljs$core$macros$unchecked_add(var_args){
var args__9364__auto__ = [];
var len__9357__auto___36518 = arguments.length;
var i__9358__auto___36519 = (0);
while(true){
if((i__9358__auto___36519 < len__9357__auto___36518)){
args__9364__auto__.push((arguments[i__9358__auto___36519]));

var G__36520 = (i__9358__auto___36519 + (1));
i__9358__auto___36519 = G__36520;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((2) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.unchecked_add.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9365__auto__);
});

cljs.core$macros.unchecked_add.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,xs){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","+","cljs.core$macros/+",-18260342,null)),xs)));
});

cljs.core$macros.unchecked_add.cljs$lang$maxFixedArity = (2);

cljs.core$macros.unchecked_add.cljs$lang$applyTo = (function (seq36514){
var G__36515 = cljs.core.first.call(null,seq36514);
var seq36514__$1 = cljs.core.next.call(null,seq36514);
var G__36516 = cljs.core.first.call(null,seq36514__$1);
var seq36514__$2 = cljs.core.next.call(null,seq36514__$1);
return cljs.core$macros.unchecked_add.cljs$core$IFn$_invoke$arity$variadic(G__36515,G__36516,seq36514__$2);
});

return null;
})()
;
cljs.core$macros.unchecked_add.cljs$lang$macro = true;

var ret__9397__auto___36524 = (function (){
cljs.core$macros.unchecked_add_int = (function cljs$core$macros$unchecked_add_int(var_args){
var args__9364__auto__ = [];
var len__9357__auto___36525 = arguments.length;
var i__9358__auto___36526 = (0);
while(true){
if((i__9358__auto___36526 < len__9357__auto___36525)){
args__9364__auto__.push((arguments[i__9358__auto___36526]));

var G__36527 = (i__9358__auto___36526 + (1));
i__9358__auto___36526 = G__36527;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((2) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9365__auto__);
});

cljs.core$macros.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,xs){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","+","cljs.core$macros/+",-18260342,null)),xs)));
});

cljs.core$macros.unchecked_add_int.cljs$lang$maxFixedArity = (2);

cljs.core$macros.unchecked_add_int.cljs$lang$applyTo = (function (seq36521){
var G__36522 = cljs.core.first.call(null,seq36521);
var seq36521__$1 = cljs.core.next.call(null,seq36521);
var G__36523 = cljs.core.first.call(null,seq36521__$1);
var seq36521__$2 = cljs.core.next.call(null,seq36521__$1);
return cljs.core$macros.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic(G__36522,G__36523,seq36521__$2);
});

return null;
})()
;
cljs.core$macros.unchecked_add_int.cljs$lang$macro = true;

var ret__9397__auto___36528 = cljs.core$macros.unchecked_dec = (function cljs$core$macros$unchecked_dec(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","dec","cljs.core$macros/dec",-247694061,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});
cljs.core$macros.unchecked_dec.cljs$lang$macro = true;

var ret__9397__auto___36529 = cljs.core$macros.unchecked_dec_int = (function cljs$core$macros$unchecked_dec_int(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","dec","cljs.core$macros/dec",-247694061,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});
cljs.core$macros.unchecked_dec_int.cljs$lang$macro = true;

var ret__9397__auto___36533 = (function (){
cljs.core$macros.unchecked_divide_int = (function cljs$core$macros$unchecked_divide_int(var_args){
var args__9364__auto__ = [];
var len__9357__auto___36534 = arguments.length;
var i__9358__auto___36535 = (0);
while(true){
if((i__9358__auto___36535 < len__9357__auto___36534)){
args__9364__auto__.push((arguments[i__9358__auto___36535]));

var G__36536 = (i__9358__auto___36535 + (1));
i__9358__auto___36535 = G__36536;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((2) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9365__auto__);
});

cljs.core$macros.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,xs){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","/","cljs.core$macros//",-893374331,null)),xs)));
});

cljs.core$macros.unchecked_divide_int.cljs$lang$maxFixedArity = (2);

cljs.core$macros.unchecked_divide_int.cljs$lang$applyTo = (function (seq36530){
var G__36531 = cljs.core.first.call(null,seq36530);
var seq36530__$1 = cljs.core.next.call(null,seq36530);
var G__36532 = cljs.core.first.call(null,seq36530__$1);
var seq36530__$2 = cljs.core.next.call(null,seq36530__$1);
return cljs.core$macros.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic(G__36531,G__36532,seq36530__$2);
});

return null;
})()
;
cljs.core$macros.unchecked_divide_int.cljs$lang$macro = true;

var ret__9397__auto___36537 = cljs.core$macros.unchecked_inc = (function cljs$core$macros$unchecked_inc(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","inc","cljs.core$macros/inc",876629257,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});
cljs.core$macros.unchecked_inc.cljs$lang$macro = true;

var ret__9397__auto___36538 = cljs.core$macros.unchecked_inc_int = (function cljs$core$macros$unchecked_inc_int(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","inc","cljs.core$macros/inc",876629257,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});
cljs.core$macros.unchecked_inc_int.cljs$lang$macro = true;

var ret__9397__auto___36542 = (function (){
cljs.core$macros.unchecked_multiply = (function cljs$core$macros$unchecked_multiply(var_args){
var args__9364__auto__ = [];
var len__9357__auto___36543 = arguments.length;
var i__9358__auto___36544 = (0);
while(true){
if((i__9358__auto___36544 < len__9357__auto___36543)){
args__9364__auto__.push((arguments[i__9358__auto___36544]));

var G__36545 = (i__9358__auto___36544 + (1));
i__9358__auto___36544 = G__36545;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((2) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9365__auto__);
});

cljs.core$macros.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,xs){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","*","cljs.core$macros/*",946321529,null)),xs)));
});

cljs.core$macros.unchecked_multiply.cljs$lang$maxFixedArity = (2);

cljs.core$macros.unchecked_multiply.cljs$lang$applyTo = (function (seq36539){
var G__36540 = cljs.core.first.call(null,seq36539);
var seq36539__$1 = cljs.core.next.call(null,seq36539);
var G__36541 = cljs.core.first.call(null,seq36539__$1);
var seq36539__$2 = cljs.core.next.call(null,seq36539__$1);
return cljs.core$macros.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic(G__36540,G__36541,seq36539__$2);
});

return null;
})()
;
cljs.core$macros.unchecked_multiply.cljs$lang$macro = true;

var ret__9397__auto___36549 = (function (){
cljs.core$macros.unchecked_multiply_int = (function cljs$core$macros$unchecked_multiply_int(var_args){
var args__9364__auto__ = [];
var len__9357__auto___36550 = arguments.length;
var i__9358__auto___36551 = (0);
while(true){
if((i__9358__auto___36551 < len__9357__auto___36550)){
args__9364__auto__.push((arguments[i__9358__auto___36551]));

var G__36552 = (i__9358__auto___36551 + (1));
i__9358__auto___36551 = G__36552;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((2) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9365__auto__);
});

cljs.core$macros.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,xs){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","*","cljs.core$macros/*",946321529,null)),xs)));
});

cljs.core$macros.unchecked_multiply_int.cljs$lang$maxFixedArity = (2);

cljs.core$macros.unchecked_multiply_int.cljs$lang$applyTo = (function (seq36546){
var G__36547 = cljs.core.first.call(null,seq36546);
var seq36546__$1 = cljs.core.next.call(null,seq36546);
var G__36548 = cljs.core.first.call(null,seq36546__$1);
var seq36546__$2 = cljs.core.next.call(null,seq36546__$1);
return cljs.core$macros.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic(G__36547,G__36548,seq36546__$2);
});

return null;
})()
;
cljs.core$macros.unchecked_multiply_int.cljs$lang$macro = true;

var ret__9397__auto___36553 = cljs.core$macros.unchecked_negate = (function cljs$core$macros$unchecked_negate(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","-","cljs.core$macros/-",13526976,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});
cljs.core$macros.unchecked_negate.cljs$lang$macro = true;

var ret__9397__auto___36554 = cljs.core$macros.unchecked_negate_int = (function cljs$core$macros$unchecked_negate_int(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","-","cljs.core$macros/-",13526976,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});
cljs.core$macros.unchecked_negate_int.cljs$lang$macro = true;

var ret__9397__auto___36555 = cljs.core$macros.unchecked_remainder_int = (function cljs$core$macros$unchecked_remainder_int(_AMPERSAND_form,_AMPERSAND_env,x,n){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","mod","cljs.core/mod",1925370196,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = n;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});
cljs.core$macros.unchecked_remainder_int.cljs$lang$macro = true;

var ret__9397__auto___36559 = (function (){
cljs.core$macros.unchecked_subtract = (function cljs$core$macros$unchecked_subtract(var_args){
var args__9364__auto__ = [];
var len__9357__auto___36560 = arguments.length;
var i__9358__auto___36561 = (0);
while(true){
if((i__9358__auto___36561 < len__9357__auto___36560)){
args__9364__auto__.push((arguments[i__9358__auto___36561]));

var G__36562 = (i__9358__auto___36561 + (1));
i__9358__auto___36561 = G__36562;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((2) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9365__auto__);
});

cljs.core$macros.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,xs){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","-","cljs.core$macros/-",13526976,null)),xs)));
});

cljs.core$macros.unchecked_subtract.cljs$lang$maxFixedArity = (2);

cljs.core$macros.unchecked_subtract.cljs$lang$applyTo = (function (seq36556){
var G__36557 = cljs.core.first.call(null,seq36556);
var seq36556__$1 = cljs.core.next.call(null,seq36556);
var G__36558 = cljs.core.first.call(null,seq36556__$1);
var seq36556__$2 = cljs.core.next.call(null,seq36556__$1);
return cljs.core$macros.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic(G__36557,G__36558,seq36556__$2);
});

return null;
})()
;
cljs.core$macros.unchecked_subtract.cljs$lang$macro = true;

var ret__9397__auto___36566 = (function (){
cljs.core$macros.unchecked_subtract_int = (function cljs$core$macros$unchecked_subtract_int(var_args){
var args__9364__auto__ = [];
var len__9357__auto___36567 = arguments.length;
var i__9358__auto___36568 = (0);
while(true){
if((i__9358__auto___36568 < len__9357__auto___36567)){
args__9364__auto__.push((arguments[i__9358__auto___36568]));

var G__36569 = (i__9358__auto___36568 + (1));
i__9358__auto___36568 = G__36569;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((2) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9365__auto__);
});

cljs.core$macros.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,xs){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","-","cljs.core$macros/-",13526976,null)),xs)));
});

cljs.core$macros.unchecked_subtract_int.cljs$lang$maxFixedArity = (2);

cljs.core$macros.unchecked_subtract_int.cljs$lang$applyTo = (function (seq36563){
var G__36564 = cljs.core.first.call(null,seq36563);
var seq36563__$1 = cljs.core.next.call(null,seq36563);
var G__36565 = cljs.core.first.call(null,seq36563__$1);
var seq36563__$2 = cljs.core.next.call(null,seq36563__$1);
return cljs.core$macros.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic(G__36564,G__36565,seq36563__$2);
});

return null;
})()
;
cljs.core$macros.unchecked_subtract_int.cljs$lang$macro = true;

var ret__9397__auto___36577 = (function (){
cljs.core$macros._ = (function cljs$core$macros$_(var_args){
var G__36576 = arguments.length;
switch (G__36576) {
case 3:
return cljs.core$macros._.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core$macros._.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__9376__auto__ = [];
var len__9357__auto___36579 = arguments.length;
var i__9358__auto___36580 = (0);
while(true){
if((i__9358__auto___36580 < len__9357__auto___36579)){
args_arr__9376__auto__.push((arguments[i__9358__auto___36580]));

var G__36581 = (i__9358__auto___36580 + (1));
i__9358__auto___36580 = G__36581;
continue;
} else {
}
break;
}

var argseq__9377__auto__ = (new cljs.core.IndexedSeq(args_arr__9376__auto__.slice((4)),(0),null));
return cljs.core$macros._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__9377__auto__);

}
});

cljs.core$macros._.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),"(- ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});

cljs.core$macros._.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,x,y){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})(),"(~{} - ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});

cljs.core$macros._.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,y,more){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","-","cljs.core$macros/-",13526976,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","-","cljs.core$macros/-",13526976,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),more)));
});

cljs.core$macros._.cljs$lang$applyTo = (function (seq36571){
var G__36572 = cljs.core.first.call(null,seq36571);
var seq36571__$1 = cljs.core.next.call(null,seq36571);
var G__36573 = cljs.core.first.call(null,seq36571__$1);
var seq36571__$2 = cljs.core.next.call(null,seq36571__$1);
var G__36574 = cljs.core.first.call(null,seq36571__$2);
var seq36571__$3 = cljs.core.next.call(null,seq36571__$2);
var G__36575 = cljs.core.first.call(null,seq36571__$3);
var seq36571__$4 = cljs.core.next.call(null,seq36571__$3);
return cljs.core$macros._.cljs$core$IFn$_invoke$arity$variadic(G__36572,G__36573,G__36574,G__36575,seq36571__$4);
});

cljs.core$macros._.cljs$lang$maxFixedArity = (4);

return null;
})()
;
cljs.core$macros._.cljs$lang$macro = true;

var ret__9397__auto___36589 = (function (){
cljs.core$macros._STAR_ = (function cljs$core$macros$_STAR_(var_args){
var G__36588 = arguments.length;
switch (G__36588) {
case 2:
return cljs.core$macros._STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core$macros._STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core$macros._STAR_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__9376__auto__ = [];
var len__9357__auto___36591 = arguments.length;
var i__9358__auto___36592 = (0);
while(true){
if((i__9358__auto___36592 < len__9357__auto___36591)){
args_arr__9376__auto__.push((arguments[i__9358__auto___36592]));

var G__36593 = (i__9358__auto___36592 + (1));
i__9358__auto___36592 = G__36593;
continue;
} else {
}
break;
}

var argseq__9377__auto__ = (new cljs.core.IndexedSeq(args_arr__9376__auto__.slice((4)),(0),null));
return cljs.core$macros._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__9377__auto__);

}
});

cljs.core$macros._STAR_.cljs$core$IFn$_invoke$arity$2 = (function (_AMPERSAND_form,_AMPERSAND_env){
return (1);
});

cljs.core$macros._STAR_.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,x){
return x;
});

cljs.core$macros._STAR_.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,x,y){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})(),"(~{} * ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});

cljs.core$macros._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,y,more){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","*","cljs.core$macros/*",946321529,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","*","cljs.core$macros/*",946321529,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),more)));
});

cljs.core$macros._STAR_.cljs$lang$applyTo = (function (seq36583){
var G__36584 = cljs.core.first.call(null,seq36583);
var seq36583__$1 = cljs.core.next.call(null,seq36583);
var G__36585 = cljs.core.first.call(null,seq36583__$1);
var seq36583__$2 = cljs.core.next.call(null,seq36583__$1);
var G__36586 = cljs.core.first.call(null,seq36583__$2);
var seq36583__$3 = cljs.core.next.call(null,seq36583__$2);
var G__36587 = cljs.core.first.call(null,seq36583__$3);
var seq36583__$4 = cljs.core.next.call(null,seq36583__$3);
return cljs.core$macros._STAR_.cljs$core$IFn$_invoke$arity$variadic(G__36584,G__36585,G__36586,G__36587,seq36583__$4);
});

cljs.core$macros._STAR_.cljs$lang$maxFixedArity = (4);

return null;
})()
;
cljs.core$macros._STAR_.cljs$lang$macro = true;

var ret__9397__auto___36601 = (function (){
cljs.core$macros._SLASH_ = (function cljs$core$macros$_SLASH_(var_args){
var G__36600 = arguments.length;
switch (G__36600) {
case 3:
return cljs.core$macros._SLASH_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core$macros._SLASH_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__9376__auto__ = [];
var len__9357__auto___36603 = arguments.length;
var i__9358__auto___36604 = (0);
while(true){
if((i__9358__auto___36604 < len__9357__auto___36603)){
args_arr__9376__auto__.push((arguments[i__9358__auto___36604]));

var G__36605 = (i__9358__auto___36604 + (1));
i__9358__auto___36604 = G__36605;
continue;
} else {
}
break;
}

var argseq__9377__auto__ = (new cljs.core.IndexedSeq(args_arr__9376__auto__.slice((4)),(0),null));
return cljs.core$macros._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__9377__auto__);

}
});

cljs.core$macros._SLASH_.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","/","cljs.core$macros//",-893374331,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,(1)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros._SLASH_.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,x,y){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})(),"(~{} / ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});

cljs.core$macros._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,y,more){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","/","cljs.core$macros//",-893374331,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","/","cljs.core$macros//",-893374331,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),more)));
});

cljs.core$macros._SLASH_.cljs$lang$applyTo = (function (seq36595){
var G__36596 = cljs.core.first.call(null,seq36595);
var seq36595__$1 = cljs.core.next.call(null,seq36595);
var G__36597 = cljs.core.first.call(null,seq36595__$1);
var seq36595__$2 = cljs.core.next.call(null,seq36595__$1);
var G__36598 = cljs.core.first.call(null,seq36595__$2);
var seq36595__$3 = cljs.core.next.call(null,seq36595__$2);
var G__36599 = cljs.core.first.call(null,seq36595__$3);
var seq36595__$4 = cljs.core.next.call(null,seq36595__$3);
return cljs.core$macros._SLASH_.cljs$core$IFn$_invoke$arity$variadic(G__36596,G__36597,G__36598,G__36599,seq36595__$4);
});

cljs.core$macros._SLASH_.cljs$lang$maxFixedArity = (4);

return null;
})()
;
cljs.core$macros._SLASH_.cljs$lang$macro = true;

var ret__9397__auto___36613 = (function (){
cljs.core$macros.divide = (function cljs$core$macros$divide(var_args){
var G__36612 = arguments.length;
switch (G__36612) {
case 3:
return cljs.core$macros.divide.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core$macros.divide.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__9376__auto__ = [];
var len__9357__auto___36615 = arguments.length;
var i__9358__auto___36616 = (0);
while(true){
if((i__9358__auto___36616 < len__9357__auto___36615)){
args_arr__9376__auto__.push((arguments[i__9358__auto___36616]));

var G__36617 = (i__9358__auto___36616 + (1));
i__9358__auto___36616 = G__36617;
continue;
} else {
}
break;
}

var argseq__9377__auto__ = (new cljs.core.IndexedSeq(args_arr__9376__auto__.slice((4)),(0),null));
return cljs.core$macros.divide.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__9377__auto__);

}
});

cljs.core$macros.divide.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","/","cljs.core$macros//",-893374331,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,(1)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros.divide.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,x,y){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})(),"(~{} / ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});

cljs.core$macros.divide.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,y,more){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","/","cljs.core$macros//",-893374331,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","/","cljs.core$macros//",-893374331,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),more)));
});

cljs.core$macros.divide.cljs$lang$applyTo = (function (seq36607){
var G__36608 = cljs.core.first.call(null,seq36607);
var seq36607__$1 = cljs.core.next.call(null,seq36607);
var G__36609 = cljs.core.first.call(null,seq36607__$1);
var seq36607__$2 = cljs.core.next.call(null,seq36607__$1);
var G__36610 = cljs.core.first.call(null,seq36607__$2);
var seq36607__$3 = cljs.core.next.call(null,seq36607__$2);
var G__36611 = cljs.core.first.call(null,seq36607__$3);
var seq36607__$4 = cljs.core.next.call(null,seq36607__$3);
return cljs.core$macros.divide.cljs$core$IFn$_invoke$arity$variadic(G__36608,G__36609,G__36610,G__36611,seq36607__$4);
});

cljs.core$macros.divide.cljs$lang$maxFixedArity = (4);

return null;
})()
;
cljs.core$macros.divide.cljs$lang$macro = true;

var ret__9397__auto___36625 = (function (){
cljs.core$macros._LT_ = (function cljs$core$macros$_LT_(var_args){
var G__36624 = arguments.length;
switch (G__36624) {
case 3:
return cljs.core$macros._LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core$macros._LT_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__9376__auto__ = [];
var len__9357__auto___36627 = arguments.length;
var i__9358__auto___36628 = (0);
while(true){
if((i__9358__auto___36628 < len__9357__auto___36627)){
args_arr__9376__auto__.push((arguments[i__9358__auto___36628]));

var G__36629 = (i__9358__auto___36628 + (1));
i__9358__auto___36628 = G__36629;
continue;
} else {
}
break;
}

var argseq__9377__auto__ = (new cljs.core.IndexedSeq(args_arr__9376__auto__.slice((4)),(0),null));
return cljs.core$macros._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__9377__auto__);

}
});

cljs.core$macros._LT_.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,x){
return true;
});

cljs.core$macros._LT_.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,x,y){
return cljs.core$macros.bool_expr.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})(),"(~{} < ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null)));
});

cljs.core$macros._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,y,more){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","and","cljs.core$macros/and",48320334,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","<","cljs.core$macros/<",371512596,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","<","cljs.core$macros/<",371512596,null)),(function (){var x__9048__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),more)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros._LT_.cljs$lang$applyTo = (function (seq36619){
var G__36620 = cljs.core.first.call(null,seq36619);
var seq36619__$1 = cljs.core.next.call(null,seq36619);
var G__36621 = cljs.core.first.call(null,seq36619__$1);
var seq36619__$2 = cljs.core.next.call(null,seq36619__$1);
var G__36622 = cljs.core.first.call(null,seq36619__$2);
var seq36619__$3 = cljs.core.next.call(null,seq36619__$2);
var G__36623 = cljs.core.first.call(null,seq36619__$3);
var seq36619__$4 = cljs.core.next.call(null,seq36619__$3);
return cljs.core$macros._LT_.cljs$core$IFn$_invoke$arity$variadic(G__36620,G__36621,G__36622,G__36623,seq36619__$4);
});

cljs.core$macros._LT_.cljs$lang$maxFixedArity = (4);

return null;
})()
;
cljs.core$macros._LT_.cljs$lang$macro = true;

var ret__9397__auto___36637 = (function (){
cljs.core$macros._LT__EQ_ = (function cljs$core$macros$_LT__EQ_(var_args){
var G__36636 = arguments.length;
switch (G__36636) {
case 3:
return cljs.core$macros._LT__EQ_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core$macros._LT__EQ_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__9376__auto__ = [];
var len__9357__auto___36639 = arguments.length;
var i__9358__auto___36640 = (0);
while(true){
if((i__9358__auto___36640 < len__9357__auto___36639)){
args_arr__9376__auto__.push((arguments[i__9358__auto___36640]));

var G__36641 = (i__9358__auto___36640 + (1));
i__9358__auto___36640 = G__36641;
continue;
} else {
}
break;
}

var argseq__9377__auto__ = (new cljs.core.IndexedSeq(args_arr__9376__auto__.slice((4)),(0),null));
return cljs.core$macros._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__9377__auto__);

}
});

cljs.core$macros._LT__EQ_.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,x){
return true;
});

cljs.core$macros._LT__EQ_.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,x,y){
return cljs.core$macros.bool_expr.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})(),"(~{} <= ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null)));
});

cljs.core$macros._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,y,more){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","and","cljs.core$macros/and",48320334,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","<=","cljs.core$macros/<=",1865244377,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","<=","cljs.core$macros/<=",1865244377,null)),(function (){var x__9048__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),more)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros._LT__EQ_.cljs$lang$applyTo = (function (seq36631){
var G__36632 = cljs.core.first.call(null,seq36631);
var seq36631__$1 = cljs.core.next.call(null,seq36631);
var G__36633 = cljs.core.first.call(null,seq36631__$1);
var seq36631__$2 = cljs.core.next.call(null,seq36631__$1);
var G__36634 = cljs.core.first.call(null,seq36631__$2);
var seq36631__$3 = cljs.core.next.call(null,seq36631__$2);
var G__36635 = cljs.core.first.call(null,seq36631__$3);
var seq36631__$4 = cljs.core.next.call(null,seq36631__$3);
return cljs.core$macros._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__36632,G__36633,G__36634,G__36635,seq36631__$4);
});

cljs.core$macros._LT__EQ_.cljs$lang$maxFixedArity = (4);

return null;
})()
;
cljs.core$macros._LT__EQ_.cljs$lang$macro = true;

var ret__9397__auto___36649 = (function (){
cljs.core$macros._GT_ = (function cljs$core$macros$_GT_(var_args){
var G__36648 = arguments.length;
switch (G__36648) {
case 3:
return cljs.core$macros._GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core$macros._GT_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__9376__auto__ = [];
var len__9357__auto___36651 = arguments.length;
var i__9358__auto___36652 = (0);
while(true){
if((i__9358__auto___36652 < len__9357__auto___36651)){
args_arr__9376__auto__.push((arguments[i__9358__auto___36652]));

var G__36653 = (i__9358__auto___36652 + (1));
i__9358__auto___36652 = G__36653;
continue;
} else {
}
break;
}

var argseq__9377__auto__ = (new cljs.core.IndexedSeq(args_arr__9376__auto__.slice((4)),(0),null));
return cljs.core$macros._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__9377__auto__);

}
});

cljs.core$macros._GT_.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,x){
return true;
});

cljs.core$macros._GT_.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,x,y){
return cljs.core$macros.bool_expr.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})(),"(~{} > ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null)));
});

cljs.core$macros._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,y,more){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","and","cljs.core$macros/and",48320334,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros",">","cljs.core$macros/>",1703297853,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros",">","cljs.core$macros/>",1703297853,null)),(function (){var x__9048__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),more)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros._GT_.cljs$lang$applyTo = (function (seq36643){
var G__36644 = cljs.core.first.call(null,seq36643);
var seq36643__$1 = cljs.core.next.call(null,seq36643);
var G__36645 = cljs.core.first.call(null,seq36643__$1);
var seq36643__$2 = cljs.core.next.call(null,seq36643__$1);
var G__36646 = cljs.core.first.call(null,seq36643__$2);
var seq36643__$3 = cljs.core.next.call(null,seq36643__$2);
var G__36647 = cljs.core.first.call(null,seq36643__$3);
var seq36643__$4 = cljs.core.next.call(null,seq36643__$3);
return cljs.core$macros._GT_.cljs$core$IFn$_invoke$arity$variadic(G__36644,G__36645,G__36646,G__36647,seq36643__$4);
});

cljs.core$macros._GT_.cljs$lang$maxFixedArity = (4);

return null;
})()
;
cljs.core$macros._GT_.cljs$lang$macro = true;

var ret__9397__auto___36661 = (function (){
cljs.core$macros._GT__EQ_ = (function cljs$core$macros$_GT__EQ_(var_args){
var G__36660 = arguments.length;
switch (G__36660) {
case 3:
return cljs.core$macros._GT__EQ_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core$macros._GT__EQ_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__9376__auto__ = [];
var len__9357__auto___36663 = arguments.length;
var i__9358__auto___36664 = (0);
while(true){
if((i__9358__auto___36664 < len__9357__auto___36663)){
args_arr__9376__auto__.push((arguments[i__9358__auto___36664]));

var G__36665 = (i__9358__auto___36664 + (1));
i__9358__auto___36664 = G__36665;
continue;
} else {
}
break;
}

var argseq__9377__auto__ = (new cljs.core.IndexedSeq(args_arr__9376__auto__.slice((4)),(0),null));
return cljs.core$macros._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__9377__auto__);

}
});

cljs.core$macros._GT__EQ_.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,x){
return true;
});

cljs.core$macros._GT__EQ_.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,x,y){
return cljs.core$macros.bool_expr.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})(),"(~{} >= ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null)));
});

cljs.core$macros._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,y,more){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","and","cljs.core$macros/and",48320334,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros",">=","cljs.core$macros/>=",527849062,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros",">=","cljs.core$macros/>=",527849062,null)),(function (){var x__9048__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),more)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros._GT__EQ_.cljs$lang$applyTo = (function (seq36655){
var G__36656 = cljs.core.first.call(null,seq36655);
var seq36655__$1 = cljs.core.next.call(null,seq36655);
var G__36657 = cljs.core.first.call(null,seq36655__$1);
var seq36655__$2 = cljs.core.next.call(null,seq36655__$1);
var G__36658 = cljs.core.first.call(null,seq36655__$2);
var seq36655__$3 = cljs.core.next.call(null,seq36655__$2);
var G__36659 = cljs.core.first.call(null,seq36655__$3);
var seq36655__$4 = cljs.core.next.call(null,seq36655__$3);
return cljs.core$macros._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__36656,G__36657,G__36658,G__36659,seq36655__$4);
});

cljs.core$macros._GT__EQ_.cljs$lang$maxFixedArity = (4);

return null;
})()
;
cljs.core$macros._GT__EQ_.cljs$lang$macro = true;

var ret__9397__auto___36673 = (function (){
cljs.core$macros._EQ__EQ_ = (function cljs$core$macros$_EQ__EQ_(var_args){
var G__36672 = arguments.length;
switch (G__36672) {
case 3:
return cljs.core$macros._EQ__EQ_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core$macros._EQ__EQ_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__9376__auto__ = [];
var len__9357__auto___36675 = arguments.length;
var i__9358__auto___36676 = (0);
while(true){
if((i__9358__auto___36676 < len__9357__auto___36675)){
args_arr__9376__auto__.push((arguments[i__9358__auto___36676]));

var G__36677 = (i__9358__auto___36676 + (1));
i__9358__auto___36676 = G__36677;
continue;
} else {
}
break;
}

var argseq__9377__auto__ = (new cljs.core.IndexedSeq(args_arr__9376__auto__.slice((4)),(0),null));
return cljs.core$macros._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__9377__auto__);

}
});

cljs.core$macros._EQ__EQ_.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,x){
return true;
});

cljs.core$macros._EQ__EQ_.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,x,y){
return cljs.core$macros.bool_expr.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})(),"(~{} === ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null)));
});

cljs.core$macros._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,y,more){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","and","cljs.core$macros/and",48320334,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","==","cljs.core$macros/==",-818551413,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","==","cljs.core$macros/==",-818551413,null)),(function (){var x__9048__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),more)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros._EQ__EQ_.cljs$lang$applyTo = (function (seq36667){
var G__36668 = cljs.core.first.call(null,seq36667);
var seq36667__$1 = cljs.core.next.call(null,seq36667);
var G__36669 = cljs.core.first.call(null,seq36667__$1);
var seq36667__$2 = cljs.core.next.call(null,seq36667__$1);
var G__36670 = cljs.core.first.call(null,seq36667__$2);
var seq36667__$3 = cljs.core.next.call(null,seq36667__$2);
var G__36671 = cljs.core.first.call(null,seq36667__$3);
var seq36667__$4 = cljs.core.next.call(null,seq36667__$3);
return cljs.core$macros._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__36668,G__36669,G__36670,G__36671,seq36667__$4);
});

cljs.core$macros._EQ__EQ_.cljs$lang$maxFixedArity = (4);

return null;
})()
;
cljs.core$macros._EQ__EQ_.cljs$lang$macro = true;

var ret__9397__auto___36678 = cljs.core$macros.dec = (function cljs$core$macros$dec(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","-","cljs.core$macros/-",13526976,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,(1)))));
});
cljs.core$macros.dec.cljs$lang$macro = true;

var ret__9397__auto___36679 = cljs.core$macros.inc = (function cljs$core$macros$inc(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","+","cljs.core$macros/+",-18260342,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,(1)))));
});
cljs.core$macros.inc.cljs$lang$macro = true;

var ret__9397__auto___36680 = cljs.core$macros.zero_QMARK_ = (function cljs$core$macros$zero_QMARK_(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","==","cljs.core$macros/==",-818551413,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,(0)))));
});
cljs.core$macros.zero_QMARK_.cljs$lang$macro = true;

var ret__9397__auto___36681 = cljs.core$macros.pos_QMARK_ = (function cljs$core$macros$pos_QMARK_(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros",">","cljs.core$macros/>",1703297853,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,(0)))));
});
cljs.core$macros.pos_QMARK_.cljs$lang$macro = true;

var ret__9397__auto___36682 = cljs.core$macros.neg_QMARK_ = (function cljs$core$macros$neg_QMARK_(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","<","cljs.core$macros/<",371512596,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,(0)))));
});
cljs.core$macros.neg_QMARK_.cljs$lang$macro = true;

var ret__9397__auto___36692 = (function (){
cljs.core$macros.max = (function cljs$core$macros$max(var_args){
var G__36691 = arguments.length;
switch (G__36691) {
case 3:
return cljs.core$macros.max.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core$macros.max.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__9376__auto__ = [];
var len__9357__auto___36694 = arguments.length;
var i__9358__auto___36695 = (0);
while(true){
if((i__9358__auto___36695 < len__9357__auto___36694)){
args_arr__9376__auto__.push((arguments[i__9358__auto___36695]));

var G__36696 = (i__9358__auto___36695 + (1));
i__9358__auto___36695 = G__36696;
continue;
} else {
}
break;
}

var argseq__9377__auto__ = (new cljs.core.IndexedSeq(args_arr__9376__auto__.slice((4)),(0),null));
return cljs.core$macros.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__9377__auto__);

}
});

cljs.core$macros.max.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,x){
return x;
});

cljs.core$macros.max.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,x,y){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"x__36683__auto__","x__36683__auto__",47565557,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"y__36684__auto__","y__36684__auto__",-533025914,null)),(function (){var x__9048__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"js*","js*",-1134233646,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,"((~{} > ~{}) ? ~{} : ~{})"),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"x__36683__auto__","x__36683__auto__",47565557,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"y__36684__auto__","y__36684__auto__",-533025914,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"x__36683__auto__","x__36683__auto__",47565557,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"y__36684__auto__","y__36684__auto__",-533025914,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros.max.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,y,more){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","max","cljs.core$macros/max",1176150699,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","max","cljs.core$macros/max",1176150699,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),more)));
});

cljs.core$macros.max.cljs$lang$applyTo = (function (seq36686){
var G__36687 = cljs.core.first.call(null,seq36686);
var seq36686__$1 = cljs.core.next.call(null,seq36686);
var G__36688 = cljs.core.first.call(null,seq36686__$1);
var seq36686__$2 = cljs.core.next.call(null,seq36686__$1);
var G__36689 = cljs.core.first.call(null,seq36686__$2);
var seq36686__$3 = cljs.core.next.call(null,seq36686__$2);
var G__36690 = cljs.core.first.call(null,seq36686__$3);
var seq36686__$4 = cljs.core.next.call(null,seq36686__$3);
return cljs.core$macros.max.cljs$core$IFn$_invoke$arity$variadic(G__36687,G__36688,G__36689,G__36690,seq36686__$4);
});

cljs.core$macros.max.cljs$lang$maxFixedArity = (4);

return null;
})()
;
cljs.core$macros.max.cljs$lang$macro = true;

var ret__9397__auto___36706 = (function (){
cljs.core$macros.min = (function cljs$core$macros$min(var_args){
var G__36705 = arguments.length;
switch (G__36705) {
case 3:
return cljs.core$macros.min.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core$macros.min.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__9376__auto__ = [];
var len__9357__auto___36708 = arguments.length;
var i__9358__auto___36709 = (0);
while(true){
if((i__9358__auto___36709 < len__9357__auto___36708)){
args_arr__9376__auto__.push((arguments[i__9358__auto___36709]));

var G__36710 = (i__9358__auto___36709 + (1));
i__9358__auto___36709 = G__36710;
continue;
} else {
}
break;
}

var argseq__9377__auto__ = (new cljs.core.IndexedSeq(args_arr__9376__auto__.slice((4)),(0),null));
return cljs.core$macros.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__9377__auto__);

}
});

cljs.core$macros.min.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,x){
return x;
});

cljs.core$macros.min.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,x,y){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"x__36697__auto__","x__36697__auto__",-1424162794,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"y__36698__auto__","y__36698__auto__",1868354575,null)),(function (){var x__9048__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"js*","js*",-1134233646,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,"((~{} < ~{}) ? ~{} : ~{})"),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"x__36697__auto__","x__36697__auto__",-1424162794,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"y__36698__auto__","y__36698__auto__",1868354575,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"x__36697__auto__","x__36697__auto__",-1424162794,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"y__36698__auto__","y__36698__auto__",1868354575,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros.min.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,y,more){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","min","cljs.core$macros/min",1499775161,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","min","cljs.core$macros/min",1499775161,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),more)));
});

cljs.core$macros.min.cljs$lang$applyTo = (function (seq36700){
var G__36701 = cljs.core.first.call(null,seq36700);
var seq36700__$1 = cljs.core.next.call(null,seq36700);
var G__36702 = cljs.core.first.call(null,seq36700__$1);
var seq36700__$2 = cljs.core.next.call(null,seq36700__$1);
var G__36703 = cljs.core.first.call(null,seq36700__$2);
var seq36700__$3 = cljs.core.next.call(null,seq36700__$2);
var G__36704 = cljs.core.first.call(null,seq36700__$3);
var seq36700__$4 = cljs.core.next.call(null,seq36700__$3);
return cljs.core$macros.min.cljs$core$IFn$_invoke$arity$variadic(G__36701,G__36702,G__36703,G__36704,seq36700__$4);
});

cljs.core$macros.min.cljs$lang$maxFixedArity = (4);

return null;
})()
;
cljs.core$macros.min.cljs$lang$macro = true;

var ret__9397__auto___36711 = cljs.core$macros.js_mod = (function cljs$core$macros$js_mod(_AMPERSAND_form,_AMPERSAND_env,num,div){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = num;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = div;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})(),"(~{} % ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.js_mod.cljs$lang$macro = true;

var ret__9397__auto___36712 = cljs.core$macros.bit_not = (function cljs$core$macros$bit_not(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),"(~ ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.bit_not.cljs$lang$macro = true;

var ret__9397__auto___36720 = (function (){
cljs.core$macros.bit_and = (function cljs$core$macros$bit_and(var_args){
var G__36719 = arguments.length;
switch (G__36719) {
case 4:
return cljs.core$macros.bit_and.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__9376__auto__ = [];
var len__9357__auto___36722 = arguments.length;
var i__9358__auto___36723 = (0);
while(true){
if((i__9358__auto___36723 < len__9357__auto___36722)){
args_arr__9376__auto__.push((arguments[i__9358__auto___36723]));

var G__36724 = (i__9358__auto___36723 + (1));
i__9358__auto___36723 = G__36724;
continue;
} else {
}
break;
}

var argseq__9377__auto__ = (new cljs.core.IndexedSeq(args_arr__9376__auto__.slice((4)),(0),null));
return cljs.core$macros.bit_and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__9377__auto__);

}
});

cljs.core$macros.bit_and.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,x,y){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})(),"(~{} & ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});

cljs.core$macros.bit_and.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,y,more){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","bit-and","cljs.core$macros/bit-and",-1069060797,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","bit-and","cljs.core$macros/bit-and",-1069060797,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),more)));
});

cljs.core$macros.bit_and.cljs$lang$applyTo = (function (seq36714){
var G__36715 = cljs.core.first.call(null,seq36714);
var seq36714__$1 = cljs.core.next.call(null,seq36714);
var G__36716 = cljs.core.first.call(null,seq36714__$1);
var seq36714__$2 = cljs.core.next.call(null,seq36714__$1);
var G__36717 = cljs.core.first.call(null,seq36714__$2);
var seq36714__$3 = cljs.core.next.call(null,seq36714__$2);
var G__36718 = cljs.core.first.call(null,seq36714__$3);
var seq36714__$4 = cljs.core.next.call(null,seq36714__$3);
return cljs.core$macros.bit_and.cljs$core$IFn$_invoke$arity$variadic(G__36715,G__36716,G__36717,G__36718,seq36714__$4);
});

cljs.core$macros.bit_and.cljs$lang$maxFixedArity = (4);

return null;
})()
;
cljs.core$macros.bit_and.cljs$lang$macro = true;

var ret__9397__auto___36732 = (function (){
cljs.core$macros.unsafe_bit_and = (function cljs$core$macros$unsafe_bit_and(var_args){
var G__36731 = arguments.length;
switch (G__36731) {
case 4:
return cljs.core$macros.unsafe_bit_and.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__9376__auto__ = [];
var len__9357__auto___36734 = arguments.length;
var i__9358__auto___36735 = (0);
while(true){
if((i__9358__auto___36735 < len__9357__auto___36734)){
args_arr__9376__auto__.push((arguments[i__9358__auto___36735]));

var G__36736 = (i__9358__auto___36735 + (1));
i__9358__auto___36735 = G__36736;
continue;
} else {
}
break;
}

var argseq__9377__auto__ = (new cljs.core.IndexedSeq(args_arr__9376__auto__.slice((4)),(0),null));
return cljs.core$macros.unsafe_bit_and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__9377__auto__);

}
});

cljs.core$macros.unsafe_bit_and.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,x,y){
return cljs.core$macros.bool_expr.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})(),"(~{} & ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null)));
});

cljs.core$macros.unsafe_bit_and.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,y,more){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","unsafe-bit-and","cljs.core$macros/unsafe-bit-and",1803731600,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","unsafe-bit-and","cljs.core$macros/unsafe-bit-and",1803731600,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),more)));
});

cljs.core$macros.unsafe_bit_and.cljs$lang$applyTo = (function (seq36726){
var G__36727 = cljs.core.first.call(null,seq36726);
var seq36726__$1 = cljs.core.next.call(null,seq36726);
var G__36728 = cljs.core.first.call(null,seq36726__$1);
var seq36726__$2 = cljs.core.next.call(null,seq36726__$1);
var G__36729 = cljs.core.first.call(null,seq36726__$2);
var seq36726__$3 = cljs.core.next.call(null,seq36726__$2);
var G__36730 = cljs.core.first.call(null,seq36726__$3);
var seq36726__$4 = cljs.core.next.call(null,seq36726__$3);
return cljs.core$macros.unsafe_bit_and.cljs$core$IFn$_invoke$arity$variadic(G__36727,G__36728,G__36729,G__36730,seq36726__$4);
});

cljs.core$macros.unsafe_bit_and.cljs$lang$maxFixedArity = (4);

return null;
})()
;
cljs.core$macros.unsafe_bit_and.cljs$lang$macro = true;

var ret__9397__auto___36744 = (function (){
cljs.core$macros.bit_or = (function cljs$core$macros$bit_or(var_args){
var G__36743 = arguments.length;
switch (G__36743) {
case 4:
return cljs.core$macros.bit_or.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__9376__auto__ = [];
var len__9357__auto___36746 = arguments.length;
var i__9358__auto___36747 = (0);
while(true){
if((i__9358__auto___36747 < len__9357__auto___36746)){
args_arr__9376__auto__.push((arguments[i__9358__auto___36747]));

var G__36748 = (i__9358__auto___36747 + (1));
i__9358__auto___36747 = G__36748;
continue;
} else {
}
break;
}

var argseq__9377__auto__ = (new cljs.core.IndexedSeq(args_arr__9376__auto__.slice((4)),(0),null));
return cljs.core$macros.bit_or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__9377__auto__);

}
});

cljs.core$macros.bit_or.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,x,y){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})(),"(~{} | ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});

cljs.core$macros.bit_or.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,y,more){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","bit-or","cljs.core$macros/bit-or",1463236165,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","bit-or","cljs.core$macros/bit-or",1463236165,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),more)));
});

cljs.core$macros.bit_or.cljs$lang$applyTo = (function (seq36738){
var G__36739 = cljs.core.first.call(null,seq36738);
var seq36738__$1 = cljs.core.next.call(null,seq36738);
var G__36740 = cljs.core.first.call(null,seq36738__$1);
var seq36738__$2 = cljs.core.next.call(null,seq36738__$1);
var G__36741 = cljs.core.first.call(null,seq36738__$2);
var seq36738__$3 = cljs.core.next.call(null,seq36738__$2);
var G__36742 = cljs.core.first.call(null,seq36738__$3);
var seq36738__$4 = cljs.core.next.call(null,seq36738__$3);
return cljs.core$macros.bit_or.cljs$core$IFn$_invoke$arity$variadic(G__36739,G__36740,G__36741,G__36742,seq36738__$4);
});

cljs.core$macros.bit_or.cljs$lang$maxFixedArity = (4);

return null;
})()
;
cljs.core$macros.bit_or.cljs$lang$macro = true;

var ret__9397__auto___36749 = cljs.core$macros.int$ = (function cljs$core$macros$int(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","bit-or","cljs.core$macros/bit-or",1463236165,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,(0)))));
});
cljs.core$macros.int$.cljs$lang$macro = true;

var ret__9397__auto___36757 = (function (){
cljs.core$macros.bit_xor = (function cljs$core$macros$bit_xor(var_args){
var G__36756 = arguments.length;
switch (G__36756) {
case 4:
return cljs.core$macros.bit_xor.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__9376__auto__ = [];
var len__9357__auto___36759 = arguments.length;
var i__9358__auto___36760 = (0);
while(true){
if((i__9358__auto___36760 < len__9357__auto___36759)){
args_arr__9376__auto__.push((arguments[i__9358__auto___36760]));

var G__36761 = (i__9358__auto___36760 + (1));
i__9358__auto___36760 = G__36761;
continue;
} else {
}
break;
}

var argseq__9377__auto__ = (new cljs.core.IndexedSeq(args_arr__9376__auto__.slice((4)),(0),null));
return cljs.core$macros.bit_xor.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__9377__auto__);

}
});

cljs.core$macros.bit_xor.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,x,y){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})(),"(~{} ^ ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});

cljs.core$macros.bit_xor.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,y,more){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","bit-xor","cljs.core$macros/bit-xor",1284619191,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","bit-xor","cljs.core$macros/bit-xor",1284619191,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),more)));
});

cljs.core$macros.bit_xor.cljs$lang$applyTo = (function (seq36751){
var G__36752 = cljs.core.first.call(null,seq36751);
var seq36751__$1 = cljs.core.next.call(null,seq36751);
var G__36753 = cljs.core.first.call(null,seq36751__$1);
var seq36751__$2 = cljs.core.next.call(null,seq36751__$1);
var G__36754 = cljs.core.first.call(null,seq36751__$2);
var seq36751__$3 = cljs.core.next.call(null,seq36751__$2);
var G__36755 = cljs.core.first.call(null,seq36751__$3);
var seq36751__$4 = cljs.core.next.call(null,seq36751__$3);
return cljs.core$macros.bit_xor.cljs$core$IFn$_invoke$arity$variadic(G__36752,G__36753,G__36754,G__36755,seq36751__$4);
});

cljs.core$macros.bit_xor.cljs$lang$maxFixedArity = (4);

return null;
})()
;
cljs.core$macros.bit_xor.cljs$lang$macro = true;

var ret__9397__auto___36769 = (function (){
cljs.core$macros.bit_and_not = (function cljs$core$macros$bit_and_not(var_args){
var G__36768 = arguments.length;
switch (G__36768) {
case 4:
return cljs.core$macros.bit_and_not.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__9376__auto__ = [];
var len__9357__auto___36771 = arguments.length;
var i__9358__auto___36772 = (0);
while(true){
if((i__9358__auto___36772 < len__9357__auto___36771)){
args_arr__9376__auto__.push((arguments[i__9358__auto___36772]));

var G__36773 = (i__9358__auto___36772 + (1));
i__9358__auto___36772 = G__36773;
continue;
} else {
}
break;
}

var argseq__9377__auto__ = (new cljs.core.IndexedSeq(args_arr__9376__auto__.slice((4)),(0),null));
return cljs.core$macros.bit_and_not.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__9377__auto__);

}
});

cljs.core$macros.bit_and_not.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,x,y){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})(),"(~{} & ~~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});

cljs.core$macros.bit_and_not.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,y,more){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","bit-and-not","cljs.core$macros/bit-and-not",-537076037,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","bit-and-not","cljs.core$macros/bit-and-not",-537076037,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),more)));
});

cljs.core$macros.bit_and_not.cljs$lang$applyTo = (function (seq36763){
var G__36764 = cljs.core.first.call(null,seq36763);
var seq36763__$1 = cljs.core.next.call(null,seq36763);
var G__36765 = cljs.core.first.call(null,seq36763__$1);
var seq36763__$2 = cljs.core.next.call(null,seq36763__$1);
var G__36766 = cljs.core.first.call(null,seq36763__$2);
var seq36763__$3 = cljs.core.next.call(null,seq36763__$2);
var G__36767 = cljs.core.first.call(null,seq36763__$3);
var seq36763__$4 = cljs.core.next.call(null,seq36763__$3);
return cljs.core$macros.bit_and_not.cljs$core$IFn$_invoke$arity$variadic(G__36764,G__36765,G__36766,G__36767,seq36763__$4);
});

cljs.core$macros.bit_and_not.cljs$lang$maxFixedArity = (4);

return null;
})()
;
cljs.core$macros.bit_and_not.cljs$lang$macro = true;

var ret__9397__auto___36774 = cljs.core$macros.bit_clear = (function cljs$core$macros$bit_clear(_AMPERSAND_form,_AMPERSAND_env,x,n){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = n;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})(),"(~{} & ~(1 << ~{}))"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.bit_clear.cljs$lang$macro = true;

var ret__9397__auto___36775 = cljs.core$macros.bit_flip = (function cljs$core$macros$bit_flip(_AMPERSAND_form,_AMPERSAND_env,x,n){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = n;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})(),"(~{} ^ (1 << ~{}))"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.bit_flip.cljs$lang$macro = true;

var ret__9397__auto___36776 = cljs.core$macros.bit_test = (function cljs$core$macros$bit_test(_AMPERSAND_form,_AMPERSAND_env,x,n){
return cljs.core$macros.bool_expr.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = n;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})(),"((~{} & (1 << ~{})) != 0)"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null)));
});
cljs.core$macros.bit_test.cljs$lang$macro = true;

var ret__9397__auto___36777 = cljs.core$macros.bit_shift_left = (function cljs$core$macros$bit_shift_left(_AMPERSAND_form,_AMPERSAND_env,x,n){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = n;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})(),"(~{} << ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.bit_shift_left.cljs$lang$macro = true;

var ret__9397__auto___36778 = cljs.core$macros.bit_shift_right = (function cljs$core$macros$bit_shift_right(_AMPERSAND_form,_AMPERSAND_env,x,n){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = n;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})(),"(~{} >> ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.bit_shift_right.cljs$lang$macro = true;

var ret__9397__auto___36779 = cljs.core$macros.bit_shift_right_zero_fill = (function cljs$core$macros$bit_shift_right_zero_fill(_AMPERSAND_form,_AMPERSAND_env,x,n){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = n;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})(),"(~{} >>> ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.bit_shift_right_zero_fill.cljs$lang$macro = true;

var ret__9397__auto___36780 = cljs.core$macros.unsigned_bit_shift_right = (function cljs$core$macros$unsigned_bit_shift_right(_AMPERSAND_form,_AMPERSAND_env,x,n){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = n;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})(),"(~{} >>> ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.unsigned_bit_shift_right.cljs$lang$macro = true;

var ret__9397__auto___36781 = cljs.core$macros.bit_set = (function cljs$core$macros$bit_set(_AMPERSAND_form,_AMPERSAND_env,x,n){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = n;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})(),"(~{} | (1 << ~{}))"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.bit_set.cljs$lang$macro = true;

var ret__9397__auto___36782 = cljs.core$macros.mask = (function cljs$core$macros$mask(_AMPERSAND_form,_AMPERSAND_env,hash,shift){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = hash;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = shift;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})(),"((~{} >>> ~{}) & 0x01f)"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.mask.cljs$lang$macro = true;

var ret__9397__auto___36783 = cljs.core$macros.bitpos = (function cljs$core$macros$bitpos(_AMPERSAND_form,_AMPERSAND_env,hash,shift){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","mask","cljs.core$macros/mask",1575319768,null)),(function (){var x__9048__auto__ = hash;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = shift;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),"(1 << ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.bitpos.cljs$lang$macro = true;

var ret__9397__auto___36785 = cljs.core$macros.caching_hash = (function cljs$core$macros$caching_hash(_AMPERSAND_form,_AMPERSAND_env,coll,hash_fn,hash_key){
if((hash_key instanceof cljs.core.Symbol)){
} else {
throw (new Error(["Assert failed: ","hash-key is substituted twice","\n","(clojure.core/symbol? hash-key)"].join('')));
}

return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"h__36784__auto__","h__36784__auto__",-245791860,null)),(function (){var x__9048__auto__ = hash_key;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","if-not","cljs.core$macros/if-not",-1825285737,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","nil?","cljs.core$macros/nil?",83624258,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"h__36784__auto__","h__36784__auto__",-245791860,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"h__36784__auto__","h__36784__auto__",-245791860,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"h__36784__auto__","h__36784__auto__",-245791860,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = hash_fn;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = coll;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__9048__auto__ = hash_key;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"h__36784__auto__","h__36784__auto__",-245791860,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"h__36784__auto__","h__36784__auto__",-245791860,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});
cljs.core$macros.caching_hash.cljs$lang$macro = true;

cljs.core$macros.do_curried = (function cljs$core$macros$do_curried(name,doc,meta,args,body){
var cargs = cljs.core.vec.call(null,cljs.core.butlast.call(null,args));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","defn","cljs.core$macros/defn",-728332354,null)),(function (){var x__9048__auto__ = name;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = doc;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = meta;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = cargs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"x__36786__auto__","x__36786__auto__",-1531223181,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = name;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cargs,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"x__36786__auto__","x__36786__auto__",-1531223181,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = args;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),body)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});
var ret__9397__auto___36794 = (function (){
/**
 * Builds another arity of the fn that returns a fn awaiting the last
 *   param
 */
cljs.core$macros.defcurried = (function cljs$core$macros$defcurried(var_args){
var args__9364__auto__ = [];
var len__9357__auto___36795 = arguments.length;
var i__9358__auto___36796 = (0);
while(true){
if((i__9358__auto___36796 < len__9357__auto___36795)){
args__9364__auto__.push((arguments[i__9358__auto___36796]));

var G__36797 = (i__9358__auto___36796 + (1));
i__9358__auto___36796 = G__36797;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((6) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((6)),(0),null)):null);
return cljs.core$macros.defcurried.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__9365__auto__);
});

cljs.core$macros.defcurried.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,name,doc,meta,args,body){
return cljs.core$macros.do_curried.call(null,name,doc,meta,args,body);
});

cljs.core$macros.defcurried.cljs$lang$maxFixedArity = (6);

cljs.core$macros.defcurried.cljs$lang$applyTo = (function (seq36787){
var G__36788 = cljs.core.first.call(null,seq36787);
var seq36787__$1 = cljs.core.next.call(null,seq36787);
var G__36789 = cljs.core.first.call(null,seq36787__$1);
var seq36787__$2 = cljs.core.next.call(null,seq36787__$1);
var G__36790 = cljs.core.first.call(null,seq36787__$2);
var seq36787__$3 = cljs.core.next.call(null,seq36787__$2);
var G__36791 = cljs.core.first.call(null,seq36787__$3);
var seq36787__$4 = cljs.core.next.call(null,seq36787__$3);
var G__36792 = cljs.core.first.call(null,seq36787__$4);
var seq36787__$5 = cljs.core.next.call(null,seq36787__$4);
var G__36793 = cljs.core.first.call(null,seq36787__$5);
var seq36787__$6 = cljs.core.next.call(null,seq36787__$5);
return cljs.core$macros.defcurried.cljs$core$IFn$_invoke$arity$variadic(G__36788,G__36789,G__36790,G__36791,G__36792,G__36793,seq36787__$6);
});

return null;
})()
;
cljs.core$macros.defcurried.cljs$lang$macro = true;

cljs.core$macros.do_rfn = (function cljs$core$macros$do_rfn(f1,k,fkv){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = f1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = clojure.walk.postwalk.call(null,(function (p1__36798_SHARP_){
if(cljs.core.sequential_QMARK_.call(null,p1__36798_SHARP_)){
return ((cljs.core.vector_QMARK_.call(null,p1__36798_SHARP_))?cljs.core.vec:cljs.core.identity).call(null,cljs.core.remove.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([k]),p1__36798_SHARP_));
} else {
return p1__36798_SHARP_;
}
}),fkv);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = fkv;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});
var ret__9397__auto___36803 = /**
 * Builds 3-arity reducing fn given names of wrapped fn and key, and k/v impl.
 */
cljs.core$macros.rfn = (function cljs$core$macros$rfn(_AMPERSAND_form,_AMPERSAND_env,p__36799,fkv){
var vec__36800 = p__36799;
var f1 = cljs.core.nth.call(null,vec__36800,(0),null);
var k = cljs.core.nth.call(null,vec__36800,(1),null);
return cljs.core$macros.do_rfn.call(null,f1,k,fkv);
});
cljs.core$macros.rfn.cljs$lang$macro = true;

cljs.core$macros.protocol_prefix = (function cljs$core$macros$protocol_prefix(psym){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym)].join('').replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join('');
});
cljs.core$macros.base_type = new cljs.core.PersistentArrayMap(null, 8, [null,"null",new cljs.core.Symbol(null,"object","object",-1179821820,null),"object",new cljs.core.Symbol(null,"string","string",-349010059,null),"string",new cljs.core.Symbol(null,"number","number",-1084057331,null),"number",new cljs.core.Symbol(null,"array","array",-440182315,null),"array",new cljs.core.Symbol(null,"function","function",-486723946,null),"function",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"boolean",new cljs.core.Symbol(null,"default","default",-347290801,null),"_"], null);
cljs.core$macros.js_base_type = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Symbol("js","Boolean","js/Boolean",1661145260,null),"boolean",new cljs.core.Symbol("js","String","js/String",-2070054036,null),"string",new cljs.core.Symbol("js","Array","js/Array",-423508366,null),"array",new cljs.core.Symbol("js","Object","js/Object",61215323,null),"object",new cljs.core.Symbol("js","Number","js/Number",-508133572,null),"number",new cljs.core.Symbol("js","Function","js/Function",-749892063,null),"function"], null);
var ret__9397__auto___36807 = (function (){
/**
 * reify is a macro with the following structure:
 * 
 *  (reify options* specs*)
 * 
 *   Currently there are no options.
 * 
 *   Each spec consists of the protocol name followed by zero
 *   or more method bodies:
 * 
 *   protocol
 *   (methodName [args+] body)*
 * 
 *   Methods should be supplied for all methods of the desired
 *   protocol(s). You can also define overrides for Object methods. Note that
 *   the first parameter must be supplied to correspond to the target object
 *   ('this' in JavaScript parlance). Note also that recur calls
 *   to the method head should *not* pass the target object, it will be supplied
 *   automatically and can not be substituted.
 * 
 *   recur works to method heads The method bodies of reify are lexical
 *   closures, and can refer to the surrounding local scope:
 * 
 *   (str (let [f "foo"]
 *     (reify Object
 *       (toString [this] f))))
 *   == "foo"
 * 
 *   (seq (let [f "foo"]
 *     (reify ISeqable
 *       (-seq [this] (seq f)))))
 *   == ("f" "o" "o"))
 * 
 *   reify always implements IMeta and IWithMeta and transfers meta
 *   data of the form to the created object.
 * 
 *   (meta ^{:k :v} (reify Object (toString [this] "foo")))
 *   == {:k :v}
 */
cljs.core$macros.reify = (function cljs$core$macros$reify(var_args){
var args__9364__auto__ = [];
var len__9357__auto___36808 = arguments.length;
var i__9358__auto___36809 = (0);
while(true){
if((i__9358__auto___36809 < len__9357__auto___36808)){
args__9364__auto__.push((arguments[i__9358__auto___36809]));

var G__36810 = (i__9358__auto___36809 + (1));
i__9358__auto___36809 = G__36810;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((2) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.reify.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9365__auto__);
});

cljs.core$macros.reify.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,impls){
var t = cljs.core.with_meta.call(null,cljs.core.gensym.call(null,["t_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.replace.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.munge.call(null,cljs.analyzer._STAR_cljs_ns_STAR_))].join(''),".","$"))].join('')),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"anonymous","anonymous",447897231),true], null));
var meta_sym = cljs.core.gensym.call(null,"meta");
var this_sym = cljs.core.gensym.call(null,"_");
var locals = cljs.core.keys.call(null,new cljs.core.Keyword(null,"locals","locals",535295783).cljs$core$IFn$_invoke$arity$1(_AMPERSAND_env));
var ns = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(_AMPERSAND_env));
var munge = cljs.compiler.munge;
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","when-not","cljs.core$macros/when-not",-764302244,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","exists?","cljs.core$macros/exists?",-1828590389,null)),(function (){var x__9048__auto__ = cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)].join(''),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(t)].join(''));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","deftype","cljs.core$macros/deftype",1799045688,null)),(function (){var x__9048__auto__ = t;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,locals,(function (){var x__9048__auto__ = meta_sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","IWithMeta","cljs.core/IWithMeta",-1981666051,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-with-meta","-with-meta",-1610713823,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = this_sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = meta_sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"new","new",-444906321,null)),(function (){var x__9048__auto__ = t;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),locals,(function (){var x__9048__auto__ = meta_sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","IMeta","cljs.core/IMeta",-1459057517,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-meta","-meta",494863156,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = this_sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = meta_sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),impls)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"new","new",-444906321,null)),(function (){var x__9048__auto__ = t;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),locals,(function (){var x__9048__auto__ = cljs.analyzer.elide_reader_meta.call(null,cljs.core.meta.call(null,_AMPERSAND_form));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros.reify.cljs$lang$maxFixedArity = (2);

cljs.core$macros.reify.cljs$lang$applyTo = (function (seq36804){
var G__36805 = cljs.core.first.call(null,seq36804);
var seq36804__$1 = cljs.core.next.call(null,seq36804);
var G__36806 = cljs.core.first.call(null,seq36804__$1);
var seq36804__$2 = cljs.core.next.call(null,seq36804__$1);
return cljs.core$macros.reify.cljs$core$IFn$_invoke$arity$variadic(G__36805,G__36806,seq36804__$2);
});

return null;
})()
;
cljs.core$macros.reify.cljs$lang$macro = true;

var ret__9397__auto___36815 = (function (){
/**
 * Identical to reify but mutates its first argument.
 */
cljs.core$macros.specify_BANG_ = (function cljs$core$macros$specify_BANG_(var_args){
var args__9364__auto__ = [];
var len__9357__auto___36816 = arguments.length;
var i__9358__auto___36817 = (0);
while(true){
if((i__9358__auto___36817 < len__9357__auto___36816)){
args__9364__auto__.push((arguments[i__9358__auto___36817]));

var G__36818 = (i__9358__auto___36817 + (1));
i__9358__auto___36817 = G__36818;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((3) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.specify_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9365__auto__);
});

cljs.core$macros.specify_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,expr,impls){
var x = cljs.core.with_meta.call(null,cljs.core.gensym.call(null,"x"),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"extend","extend",1836484006),new cljs.core.Keyword(null,"instance","instance",-2121349050)], null));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = expr;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","extend-type","cljs.core$macros/extend-type",1713295201,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),impls)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros.specify_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core$macros.specify_BANG_.cljs$lang$applyTo = (function (seq36811){
var G__36812 = cljs.core.first.call(null,seq36811);
var seq36811__$1 = cljs.core.next.call(null,seq36811);
var G__36813 = cljs.core.first.call(null,seq36811__$1);
var seq36811__$2 = cljs.core.next.call(null,seq36811__$1);
var G__36814 = cljs.core.first.call(null,seq36811__$2);
var seq36811__$3 = cljs.core.next.call(null,seq36811__$2);
return cljs.core$macros.specify_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__36812,G__36813,G__36814,seq36811__$3);
});

return null;
})()
;
cljs.core$macros.specify_BANG_.cljs$lang$macro = true;

var ret__9397__auto___36823 = (function (){
/**
 * Identical to specify! but does not mutate its first argument. The first
 *   argument must be an ICloneable instance.
 */
cljs.core$macros.specify = (function cljs$core$macros$specify(var_args){
var args__9364__auto__ = [];
var len__9357__auto___36824 = arguments.length;
var i__9358__auto___36825 = (0);
while(true){
if((i__9358__auto___36825 < len__9357__auto___36824)){
args__9364__auto__.push((arguments[i__9358__auto___36825]));

var G__36826 = (i__9358__auto___36825 + (1));
i__9358__auto___36825 = G__36826;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((3) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.specify.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9365__auto__);
});

cljs.core$macros.specify.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,expr,impls){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","specify!","cljs.core/specify!",-585401629,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","clone","cljs.core/clone",1417120092,null)),(function (){var x__9048__auto__ = expr;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),impls)));
});

cljs.core$macros.specify.cljs$lang$maxFixedArity = (3);

cljs.core$macros.specify.cljs$lang$applyTo = (function (seq36819){
var G__36820 = cljs.core.first.call(null,seq36819);
var seq36819__$1 = cljs.core.next.call(null,seq36819);
var G__36821 = cljs.core.first.call(null,seq36819__$1);
var seq36819__$2 = cljs.core.next.call(null,seq36819__$1);
var G__36822 = cljs.core.first.call(null,seq36819__$2);
var seq36819__$3 = cljs.core.next.call(null,seq36819__$2);
return cljs.core$macros.specify.cljs$core$IFn$_invoke$arity$variadic(G__36820,G__36821,G__36822,seq36819__$3);
});

return null;
})()
;
cljs.core$macros.specify.cljs$lang$macro = true;

var ret__9397__auto___36827 = cljs.core$macros.js_this = (function cljs$core$macros$js_this(_AMPERSAND_form,_AMPERSAND_env){
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,"this"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.js_this.cljs$lang$macro = true;

var ret__9397__auto___36832 = (function (){
/**
 * Defines a scope where JavaScript's implicit "this" is bound to the name provided.
 */
cljs.core$macros.this_as = (function cljs$core$macros$this_as(var_args){
var args__9364__auto__ = [];
var len__9357__auto___36833 = arguments.length;
var i__9358__auto___36834 = (0);
while(true){
if((i__9358__auto___36834 < len__9357__auto___36833)){
args__9364__auto__.push((arguments[i__9358__auto___36834]));

var G__36835 = (i__9358__auto___36834 + (1));
i__9358__auto___36834 = G__36835;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((3) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.this_as.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9365__auto__);
});

cljs.core$macros.this_as.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,name,body){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = name;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","js-this","cljs.core$macros/js-this",353597180,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),body)));
});

cljs.core$macros.this_as.cljs$lang$maxFixedArity = (3);

cljs.core$macros.this_as.cljs$lang$applyTo = (function (seq36828){
var G__36829 = cljs.core.first.call(null,seq36828);
var seq36828__$1 = cljs.core.next.call(null,seq36828);
var G__36830 = cljs.core.first.call(null,seq36828__$1);
var seq36828__$2 = cljs.core.next.call(null,seq36828__$1);
var G__36831 = cljs.core.first.call(null,seq36828__$2);
var seq36828__$3 = cljs.core.next.call(null,seq36828__$2);
return cljs.core$macros.this_as.cljs$core$IFn$_invoke$arity$variadic(G__36829,G__36830,G__36831,seq36828__$3);
});

return null;
})()
;
cljs.core$macros.this_as.cljs$lang$macro = true;

cljs.core$macros.to_property = (function cljs$core$macros$to_property(sym){
return cljs.core.symbol.call(null,["-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(sym)].join(''));
});
cljs.core$macros.warn_and_update_protocol = (function cljs$core$macros$warn_and_update_protocol(p,type,env){
if(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"Object","Object",61210754,null),p)){
return null;
} else {
var temp__4655__auto__ = cljs.analyzer.resolve_existing_var.call(null,cljs.core.dissoc.call(null,env,new cljs.core.Keyword(null,"locals","locals",535295783)),p);
if(cljs.core.truth_(temp__4655__auto__)){
var var$ = temp__4655__auto__;
if(cljs.core.truth_(new cljs.core.Keyword(null,"protocol-symbol","protocol-symbol",1279552198).cljs$core$IFn$_invoke$arity$1(var$))){
} else {
cljs.analyzer.warning.call(null,new cljs.core.Keyword(null,"invalid-protocol-symbol","invalid-protocol-symbol",86246948),env,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"protocol","protocol",652470118),p], null));
}

if(cljs.core.truth_((function (){var and__8174__auto__ = new cljs.core.Keyword(null,"protocol-deprecated","protocol-deprecated",103233497).cljs$core$IFn$_invoke$arity$1(cljs.analyzer._STAR_cljs_warnings_STAR_);
if(cljs.core.truth_(and__8174__auto__)){
var and__8174__auto____$1 = new cljs.core.Keyword(null,"deprecated","deprecated",1498275348).cljs$core$IFn$_invoke$arity$1(var$);
if(cljs.core.truth_(and__8174__auto____$1)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"deprecation-nowarn","deprecation-nowarn",-1762828044).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,p)));
} else {
return and__8174__auto____$1;
}
} else {
return and__8174__auto__;
}
})())){
cljs.analyzer.warning.call(null,new cljs.core.Keyword(null,"protocol-deprecated","protocol-deprecated",103233497),env,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"protocol","protocol",652470118),p], null));
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"protocol-symbol","protocol-symbol",1279552198).cljs$core$IFn$_invoke$arity$1(var$))){
return cljs.core.swap_BANG_.call(null,cljs.env._STAR_compiler_STAR_,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927)], null),((function (var$,temp__4655__auto__){
return (function (ns){
return cljs.core.update_in.call(null,ns,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(var$),new cljs.core.Keyword(null,"defs","defs",1398449717),cljs.core.symbol.call(null,cljs.core.name.call(null,p)),new cljs.core.Keyword(null,"impls","impls",-1314014853)], null),cljs.core.conj,type);
});})(var$,temp__4655__auto__))
);
} else {
return null;
}
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"undeclared","undeclared",1446667347).cljs$core$IFn$_invoke$arity$1(cljs.analyzer._STAR_cljs_warnings_STAR_))){
return cljs.analyzer.warning.call(null,new cljs.core.Keyword(null,"undeclared-protocol-symbol","undeclared-protocol-symbol",462882867),env,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"protocol","protocol",652470118),p], null));
} else {
return null;
}
}
}
});
cljs.core$macros.resolve_var = (function cljs$core$macros$resolve_var(env,sym){
var ret = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.call(null,env,sym));
if(cljs.core.truth_(ret)){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["Can't resolve: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(sym)].join('')),"\n","ret"].join('')));
}

return ret;
});
cljs.core$macros.__GT_impl_map = (function cljs$core$macros$__GT_impl_map(impls){
var ret = cljs.core.PersistentArrayMap.EMPTY;
var s = impls;
while(true){
if(cljs.core.seq.call(null,s)){
var G__36836 = cljs.core.assoc.call(null,ret,cljs.core.first.call(null,s),cljs.core.take_while.call(null,cljs.core.seq_QMARK_,cljs.core.next.call(null,s)));
var G__36837 = cljs.core.drop_while.call(null,cljs.core.seq_QMARK_,cljs.core.next.call(null,s));
ret = G__36836;
s = G__36837;
continue;
} else {
return ret;
}
break;
}
});
cljs.core$macros.base_assign_impls = (function cljs$core$macros$base_assign_impls(env,resolve,tsym,type,p__36838){
var vec__36839 = p__36838;
var p = cljs.core.nth.call(null,vec__36839,(0),null);
var sigs = cljs.core.nth.call(null,vec__36839,(1),null);
cljs.core$macros.warn_and_update_protocol.call(null,p,tsym,env);

var psym = resolve.call(null,p);
var pfn_prefix = cljs.core.subs.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym)].join(''),(0),([cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym)].join('').indexOf("/") + (1)));
return cljs.core.cons.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("goog.object","set","goog.object/set",-2123361230,null)),(function (){var x__9048__auto__ = psym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = type;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,true)))),cljs.core.map.call(null,((function (psym,pfn_prefix,vec__36839,p,sigs){
return (function (p__36842){
var vec__36843 = p__36842;
var seq__36844 = cljs.core.seq.call(null,vec__36843);
var first__36845 = cljs.core.first.call(null,seq__36844);
var seq__36844__$1 = cljs.core.next.call(null,seq__36844);
var f = first__36845;
var meths = seq__36844__$1;
var form = vec__36843;
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("goog.object","set","goog.object/set",-2123361230,null)),(function (){var x__9048__auto__ = cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfn_prefix),cljs.core.str.cljs$core$IFn$_invoke$arity$1(f)].join(''));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = type;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.with_meta.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),meths))),cljs.core.meta.call(null,form));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});})(psym,pfn_prefix,vec__36839,p,sigs))
,sigs));
});
if(typeof cljs.core$macros.extend_prefix !== 'undefined'){
} else {
cljs.core$macros.extend_prefix = (function (){var method_table__9143__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__9144__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__9145__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__9146__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__9147__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"cljs.core$macros","extend-prefix"),((function (method_table__9143__auto__,prefer_table__9144__auto__,method_cache__9145__auto__,cached_hierarchy__9146__auto__,hierarchy__9147__auto__){
return (function (tsym,sym){
return new cljs.core.Keyword(null,"extend","extend",1836484006).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,tsym));
});})(method_table__9143__auto__,prefer_table__9144__auto__,method_cache__9145__auto__,cached_hierarchy__9146__auto__,hierarchy__9147__auto__))
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__9147__auto__,method_table__9143__auto__,prefer_table__9144__auto__,method_cache__9145__auto__,cached_hierarchy__9146__auto__));
})();
}
cljs.core._add_method.call(null,cljs.core$macros.extend_prefix,new cljs.core.Keyword(null,"instance","instance",-2121349050),(function (tsym,sym){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"..","..",-300507420,null)),(function (){var x__9048__auto__ = tsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core$macros.to_property.call(null,sym);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
}));
cljs.core._add_method.call(null,cljs.core$macros.extend_prefix,new cljs.core.Keyword(null,"default","default",-1987822328),(function (tsym,sym){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"..","..",-300507420,null)),(function (){var x__9048__auto__ = tsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-prototype","-prototype",-450831903,null)),(function (){var x__9048__auto__ = cljs.core$macros.to_property.call(null,sym);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
}));
cljs.core$macros.adapt_obj_params = (function cljs$core$macros$adapt_obj_params(type,p__36846){
var vec__36847 = p__36846;
var seq__36848 = cljs.core.seq.call(null,vec__36847);
var first__36849 = cljs.core.first.call(null,seq__36848);
var seq__36848__$1 = cljs.core.next.call(null,seq__36848);
var vec__36850 = first__36849;
var seq__36851 = cljs.core.seq.call(null,vec__36850);
var first__36852 = cljs.core.first.call(null,seq__36851);
var seq__36851__$1 = cljs.core.next.call(null,seq__36851);
var this$ = first__36852;
var args = seq__36851__$1;
var sig = vec__36850;
var body = seq__36848__$1;
var x__9048__auto__ = cljs.core.vec.call(null,args);
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = cljs.core.list_STAR_.call(null,new cljs.core.Symbol(null,"this-as","this-as",-848995740,null),cljs.core.vary_meta.call(null,this$,cljs.core.assoc,new cljs.core.Keyword(null,"tag","tag",-1290361223),type),body);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
});
cljs.core$macros.adapt_ifn_params = (function cljs$core$macros$adapt_ifn_params(type,p__36853){
var vec__36854 = p__36853;
var seq__36855 = cljs.core.seq.call(null,vec__36854);
var first__36856 = cljs.core.first.call(null,seq__36855);
var seq__36855__$1 = cljs.core.next.call(null,seq__36855);
var vec__36857 = first__36856;
var seq__36858 = cljs.core.seq.call(null,vec__36857);
var first__36859 = cljs.core.first.call(null,seq__36858);
var seq__36858__$1 = cljs.core.next.call(null,seq__36858);
var this$ = first__36859;
var args = seq__36858__$1;
var sig = vec__36857;
var body = seq__36855__$1;
var self_sym = cljs.core.with_meta.call(null,new cljs.core.Symbol(null,"self__","self__",-153190816,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),type], null));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.cons.call(null,self_sym,args));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","this-as","cljs.core$macros/this-as",-799075148,null)),(function (){var x__9048__auto__ = self_sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = this$;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = self_sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),body)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});
cljs.core$macros.adapt_ifn_invoke_params = (function cljs$core$macros$adapt_ifn_invoke_params(type,p__36860){
var vec__36861 = p__36860;
var seq__36862 = cljs.core.seq.call(null,vec__36861);
var first__36863 = cljs.core.first.call(null,seq__36862);
var seq__36862__$1 = cljs.core.next.call(null,seq__36862);
var vec__36864 = first__36863;
var seq__36865 = cljs.core.seq.call(null,vec__36864);
var first__36866 = cljs.core.first.call(null,seq__36865);
var seq__36865__$1 = cljs.core.next.call(null,seq__36865);
var this$ = first__36866;
var args = seq__36865__$1;
var sig = vec__36864;
var body = seq__36862__$1;
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = cljs.core.vec.call(null,args);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","this-as","cljs.core$macros/this-as",-799075148,null)),(function (){var x__9048__auto__ = cljs.core.vary_meta.call(null,this$,cljs.core.assoc,new cljs.core.Keyword(null,"tag","tag",-1290361223),type);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),body)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});
cljs.core$macros.adapt_proto_params = (function cljs$core$macros$adapt_proto_params(type,p__36867){
var vec__36868 = p__36867;
var seq__36869 = cljs.core.seq.call(null,vec__36868);
var first__36870 = cljs.core.first.call(null,seq__36869);
var seq__36869__$1 = cljs.core.next.call(null,seq__36869);
var vec__36871 = first__36870;
var seq__36872 = cljs.core.seq.call(null,vec__36871);
var first__36873 = cljs.core.first.call(null,seq__36872);
var seq__36872__$1 = cljs.core.next.call(null,seq__36872);
var this$ = first__36873;
var args = seq__36872__$1;
var sig = vec__36871;
var body = seq__36869__$1;
var this_SINGLEQUOTE_ = cljs.core.vary_meta.call(null,this$,cljs.core.assoc,new cljs.core.Keyword(null,"tag","tag",-1290361223),type);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.cons.call(null,this_SINGLEQUOTE_,args));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","this-as","cljs.core$macros/this-as",-799075148,null)),(function (){var x__9048__auto__ = this_SINGLEQUOTE_;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),body)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});
cljs.core$macros.add_obj_methods = (function cljs$core$macros$add_obj_methods(type,type_sym,sigs){
return cljs.core.map.call(null,(function (p__36875){
var vec__36876 = p__36875;
var seq__36877 = cljs.core.seq.call(null,vec__36876);
var first__36878 = cljs.core.first.call(null,seq__36877);
var seq__36877__$1 = cljs.core.next.call(null,seq__36877);
var f = first__36878;
var meths = seq__36877__$1;
var form = vec__36876;
var vec__36879 = ((cljs.core.vector_QMARK_.call(null,cljs.core.first.call(null,meths)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.rest.call(null,form)], null)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,meths], null));
var f__$1 = cljs.core.nth.call(null,vec__36879,(0),null);
var meths__$1 = cljs.core.nth.call(null,vec__36879,(1),null);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__9048__auto__ = cljs.core$macros.extend_prefix.call(null,type_sym,f__$1);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.with_meta.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),cljs.core.map.call(null,((function (vec__36879,f__$1,meths__$1,vec__36876,seq__36877,first__36878,seq__36877__$1,f,meths,form){
return (function (p1__36874_SHARP_){
return cljs.core$macros.adapt_obj_params.call(null,type,p1__36874_SHARP_);
});})(vec__36879,f__$1,meths__$1,vec__36876,seq__36877,first__36878,seq__36877__$1,f,meths,form))
,meths__$1)))),cljs.core.meta.call(null,form));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
}),sigs);
});
cljs.core$macros.ifn_invoke_methods = (function cljs$core$macros$ifn_invoke_methods(type,type_sym,p__36883){
var vec__36884 = p__36883;
var seq__36885 = cljs.core.seq.call(null,vec__36884);
var first__36886 = cljs.core.first.call(null,seq__36885);
var seq__36885__$1 = cljs.core.next.call(null,seq__36885);
var f = first__36886;
var meths = seq__36885__$1;
var form = vec__36884;
return cljs.core.map.call(null,((function (vec__36884,seq__36885,first__36886,seq__36885__$1,f,meths,form){
return (function (meth){
var arity = cljs.core.count.call(null,cljs.core.first.call(null,meth));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__9048__auto__ = cljs.core$macros.extend_prefix.call(null,type_sym,cljs.core.symbol.call(null,["cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join('')));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.with_meta.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__9048__auto__ = meth;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))),cljs.core.meta.call(null,form));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});})(vec__36884,seq__36885,first__36886,seq__36885__$1,f,meths,form))
,cljs.core.map.call(null,((function (vec__36884,seq__36885,first__36886,seq__36885__$1,f,meths,form){
return (function (p1__36882_SHARP_){
return cljs.core$macros.adapt_ifn_invoke_params.call(null,type,p1__36882_SHARP_);
});})(vec__36884,seq__36885,first__36886,seq__36885__$1,f,meths,form))
,meths));
});
cljs.core$macros.add_ifn_methods = (function cljs$core$macros$add_ifn_methods(type,type_sym,p__36888){
var vec__36889 = p__36888;
var seq__36890 = cljs.core.seq.call(null,vec__36889);
var first__36891 = cljs.core.first.call(null,seq__36890);
var seq__36890__$1 = cljs.core.next.call(null,seq__36890);
var f = first__36891;
var meths = seq__36890__$1;
var form = vec__36889;
var meths__$1 = cljs.core.map.call(null,((function (vec__36889,seq__36890,first__36891,seq__36890__$1,f,meths,form){
return (function (p1__36887_SHARP_){
return cljs.core$macros.adapt_ifn_params.call(null,type,p1__36887_SHARP_);
});})(vec__36889,seq__36890,first__36891,seq__36890__$1,f,meths,form))
,meths);
var this_sym = cljs.core.with_meta.call(null,new cljs.core.Symbol(null,"self__","self__",-153190816,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),type], null));
var argsym = cljs.core.gensym.call(null,"args");
return cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__9048__auto__ = cljs.core$macros.extend_prefix.call(null,type_sym,new cljs.core.Symbol(null,"call","call",1120531661,null));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.with_meta.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),meths__$1))),cljs.core.meta.call(null,form));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))),cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__9048__auto__ = cljs.core$macros.extend_prefix.call(null,type_sym,new cljs.core.Symbol(null,"apply","apply",-1334050276,null));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.with_meta.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__9048__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [this_sym,argsym], null);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","this-as","cljs.core$macros/this-as",-799075148,null)),(function (){var x__9048__auto__ = this_sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".apply",".apply",-1176201338,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".-call",".-call",1760541695,null)),(function (){var x__9048__auto__ = this_sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = this_sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".concat",".concat",1180408684,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","array","cljs.core$macros/array",49650437,null)),(function (){var x__9048__auto__ = this_sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","aclone","cljs.core/aclone",-758078968,null)),(function (){var x__9048__auto__ = argsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))),cljs.core.meta.call(null,form));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())))], null),cljs.core$macros.ifn_invoke_methods.call(null,type,type_sym,form));
});
cljs.core$macros.add_proto_methods_STAR_ = (function cljs$core$macros$add_proto_methods_STAR_(pprefix,type,type_sym,p__36892){
var vec__36893 = p__36892;
var seq__36894 = cljs.core.seq.call(null,vec__36893);
var first__36895 = cljs.core.first.call(null,seq__36894);
var seq__36894__$1 = cljs.core.next.call(null,seq__36894);
var f = first__36895;
var meths = seq__36894__$1;
var form = vec__36893;
var pf = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(pprefix),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,f))].join('');
if(cljs.core.vector_QMARK_.call(null,cljs.core.first.call(null,meths))){
var meth = meths;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__9048__auto__ = cljs.core$macros.extend_prefix.call(null,type_sym,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(pf),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,cljs.core.first.call(null,meth)))].join(''));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.with_meta.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),cljs.core$macros.adapt_proto_params.call(null,type,meth)))),cljs.core.meta.call(null,form));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())))], null);
} else {
return cljs.core.map.call(null,((function (pf,vec__36893,seq__36894,first__36895,seq__36894__$1,f,meths,form){
return (function (p__36896){
var vec__36897 = p__36896;
var seq__36898 = cljs.core.seq.call(null,vec__36897);
var first__36899 = cljs.core.first.call(null,seq__36898);
var seq__36898__$1 = cljs.core.next.call(null,seq__36898);
var sig = first__36899;
var body = seq__36898__$1;
var meth = vec__36897;
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__9048__auto__ = cljs.core$macros.extend_prefix.call(null,type_sym,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(pf),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,sig))].join(''));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.with_meta.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__9048__auto__ = cljs.core$macros.adapt_proto_params.call(null,type,meth);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))),cljs.core.meta.call(null,form));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});})(pf,vec__36893,seq__36894,first__36895,seq__36894__$1,f,meths,form))
,meths);
}
});
cljs.core$macros.proto_assign_impls = (function cljs$core$macros$proto_assign_impls(env,resolve,type_sym,type,p__36900){
var vec__36901 = p__36900;
var p = cljs.core.nth.call(null,vec__36901,(0),null);
var sigs = cljs.core.nth.call(null,vec__36901,(1),null);
cljs.core$macros.warn_and_update_protocol.call(null,p,type,env);

var psym = resolve.call(null,p);
var pprefix = cljs.core$macros.protocol_prefix.call(null,psym);
var skip_flag = cljs.core.set.call(null,new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,type_sym)));
if(cljs.core._EQ_.call(null,p,new cljs.core.Symbol(null,"Object","Object",61210754,null))){
return cljs.core$macros.add_obj_methods.call(null,type,type_sym,sigs);
} else {
return cljs.core.concat.call(null,(cljs.core.truth_(skip_flag.call(null,psym))?null:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__9048__auto__ = cljs.core$macros.extend_prefix.call(null,type_sym,pprefix);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","PROTOCOL_SENTINEL","cljs.core/PROTOCOL_SENTINEL",210209696,null)))))], null)),cljs.core.mapcat.call(null,((function (psym,pprefix,skip_flag,vec__36901,p,sigs){
return (function (sig){
if(cljs.core._EQ_.call(null,psym,new cljs.core.Symbol("cljs.core","IFn","cljs.core/IFn",-920223129,null))){
return cljs.core$macros.add_ifn_methods.call(null,type,type_sym,sig);
} else {
return cljs.core$macros.add_proto_methods_STAR_.call(null,pprefix,type,type_sym,sig);
}
});})(psym,pprefix,skip_flag,vec__36901,p,sigs))
,sigs));
}
});
cljs.core$macros.validate_impl_sigs = (function cljs$core$macros$validate_impl_sigs(env,p,method){
if(cljs.core._EQ_.call(null,p,new cljs.core.Symbol(null,"Object","Object",61210754,null))){
return null;
} else {
var var$ = cljs.analyzer.resolve_var.call(null,cljs.core.dissoc.call(null,env,new cljs.core.Keyword(null,"locals","locals",535295783)),p);
var minfo = new cljs.core.Keyword(null,"methods","methods",453930866).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"protocol-info","protocol-info",1471745843).cljs$core$IFn$_invoke$arity$1(var$));
var method_name = cljs.core.first.call(null,method);
var __GT_name = cljs.core.comp.call(null,cljs.core.symbol,cljs.core.name);
var vec__36904 = ((cljs.core.vector_QMARK_.call(null,cljs.core.second.call(null,method)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [__GT_name.call(null,method_name),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.second.call(null,method)], null)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [__GT_name.call(null,method_name),cljs.core.map.call(null,cljs.core.first,cljs.core.rest.call(null,method))], null));
var fname = cljs.core.nth.call(null,vec__36904,(0),null);
var sigs = cljs.core.nth.call(null,vec__36904,(1),null);
var decmeths = cljs.core.get.call(null,minfo,fname,new cljs.core.Keyword("cljs.core$macros","not-found","cljs.core$macros/not-found",-1226326556));
if(cljs.core._EQ_.call(null,decmeths,new cljs.core.Keyword("cljs.core$macros","not-found","cljs.core$macros/not-found",-1226326556))){
cljs.analyzer.warning.call(null,new cljs.core.Keyword(null,"protocol-invalid-method","protocol-invalid-method",522647516),env,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"protocol","protocol",652470118),p,new cljs.core.Keyword(null,"fname","fname",1500291491),fname,new cljs.core.Keyword(null,"no-such-method","no-such-method",1087422840),true], null));
} else {
}

if(cljs.core.truth_(cljs.core.namespace.call(null,method_name))){
var method_var_36907 = cljs.analyzer.resolve_var.call(null,cljs.core.dissoc.call(null,env,new cljs.core.Keyword(null,"locals","locals",535295783)),method_name,cljs.analyzer.confirm_var_exist_warning);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(var$),new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(method_var_36907))){
} else {
cljs.analyzer.warning.call(null,new cljs.core.Keyword(null,"protocol-invalid-method","protocol-invalid-method",522647516),env,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"protocol","protocol",652470118),p,new cljs.core.Keyword(null,"fname","fname",1500291491),method_name,new cljs.core.Keyword(null,"no-such-method","no-such-method",1087422840),true], null));
}
} else {
}

var sigs__$1 = sigs;
var seen = cljs.core.PersistentHashSet.EMPTY;
while(true){
if(cljs.core.seq.call(null,sigs__$1)){
var sig = cljs.core.first.call(null,sigs__$1);
var c = cljs.core.count.call(null,sig);
if(cljs.core.contains_QMARK_.call(null,seen,c)){
cljs.analyzer.warning.call(null,new cljs.core.Keyword(null,"protocol-duped-method","protocol-duped-method",15128166),env,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"protocol","protocol",652470118),p,new cljs.core.Keyword(null,"fname","fname",1500291491),fname], null));
} else {
}

if(cljs.core.truth_(cljs.core.some.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"&","&",-2144855648,null),null], null), null),sig))){
cljs.analyzer.warning.call(null,new cljs.core.Keyword(null,"protocol-impl-with-variadic-method","protocol-impl-with-variadic-method",-319321217),env,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"protocol","protocol",652470118),p,new cljs.core.Keyword(null,"name","name",1843675177),fname], null));
} else {
}

if((cljs.core.not_EQ_.call(null,decmeths,new cljs.core.Keyword("cljs.core$macros","not-found","cljs.core$macros/not-found",-1226326556))) && (cljs.core.not.call(null,cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([c]),cljs.core.map.call(null,cljs.core.count,decmeths))))){
cljs.analyzer.warning.call(null,new cljs.core.Keyword(null,"protocol-invalid-method","protocol-invalid-method",522647516),env,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"protocol","protocol",652470118),p,new cljs.core.Keyword(null,"fname","fname",1500291491),fname,new cljs.core.Keyword(null,"invalid-arity","invalid-arity",1335461949),c], null));
} else {
}

var G__36908 = cljs.core.next.call(null,sigs__$1);
var G__36909 = cljs.core.conj.call(null,seen,c);
sigs__$1 = G__36908;
seen = G__36909;
continue;
} else {
return null;
}
break;
}
}
});
cljs.core$macros.validate_impls = (function cljs$core$macros$validate_impls(env,impls){
var protos = cljs.core.PersistentHashSet.EMPTY;
var impls__$1 = impls;
while(true){
if(cljs.core.seq.call(null,impls__$1)){
var proto = cljs.core.first.call(null,impls__$1);
var methods$ = cljs.core.take_while.call(null,cljs.core.seq_QMARK_,cljs.core.next.call(null,impls__$1));
var impls__$2 = cljs.core.drop_while.call(null,cljs.core.seq_QMARK_,cljs.core.next.call(null,impls__$1));
if(cljs.core.contains_QMARK_.call(null,protos,proto)){
cljs.analyzer.warning.call(null,new cljs.core.Keyword(null,"protocol-multiple-impls","protocol-multiple-impls",794179260),env,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"protocol","protocol",652470118),proto], null));
} else {
}

var seen_36913 = cljs.core.PersistentHashSet.EMPTY;
var methods_36914__$1 = methods$;
while(true){
if(cljs.core.seq.call(null,methods_36914__$1)){
var vec__36910_36915 = cljs.core.first.call(null,methods_36914__$1);
var fname_36916 = cljs.core.nth.call(null,vec__36910_36915,(0),null);
var method_36917 = vec__36910_36915;
if(cljs.core.contains_QMARK_.call(null,seen_36913,fname_36916)){
cljs.analyzer.warning.call(null,new cljs.core.Keyword(null,"extend-type-invalid-method-shape","extend-type-invalid-method-shape",1424103549),env,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"protocol","protocol",652470118),proto,new cljs.core.Keyword(null,"method","method",55703592),fname_36916], null));
} else {
}

cljs.core$macros.validate_impl_sigs.call(null,env,proto,method_36917);

var G__36918 = cljs.core.conj.call(null,seen_36913,fname_36916);
var G__36919 = cljs.core.next.call(null,methods_36914__$1);
seen_36913 = G__36918;
methods_36914__$1 = G__36919;
continue;
} else {
}
break;
}

var G__36920 = cljs.core.conj.call(null,protos,proto);
var G__36921 = impls__$2;
protos = G__36920;
impls__$1 = G__36921;
continue;
} else {
return null;
}
break;
}
});
cljs.core$macros.type_hint_first_arg = (function cljs$core$macros$type_hint_first_arg(type_sym,argv){
return cljs.core.assoc.call(null,argv,(0),cljs.core.vary_meta.call(null,argv.call(null,(0)),cljs.core.assoc,new cljs.core.Keyword(null,"tag","tag",-1290361223),type_sym));
});
cljs.core$macros.type_hint_single_arity_sig = (function cljs$core$macros$type_hint_single_arity_sig(type_sym,sig){
return cljs.core.list_STAR_.call(null,cljs.core.first.call(null,sig),cljs.core$macros.type_hint_first_arg.call(null,type_sym,cljs.core.second.call(null,sig)),cljs.core.nnext.call(null,sig));
});
cljs.core$macros.type_hint_multi_arity_sig = (function cljs$core$macros$type_hint_multi_arity_sig(type_sym,sig){
return cljs.core.list_STAR_.call(null,cljs.core$macros.type_hint_first_arg.call(null,type_sym,cljs.core.first.call(null,sig)),cljs.core.next.call(null,sig));
});
cljs.core$macros.type_hint_multi_arity_sigs = (function cljs$core$macros$type_hint_multi_arity_sigs(type_sym,sigs){
return cljs.core.list_STAR_.call(null,cljs.core.first.call(null,sigs),cljs.core.map.call(null,cljs.core.partial.call(null,cljs.core$macros.type_hint_multi_arity_sig,type_sym),cljs.core.rest.call(null,sigs)));
});
cljs.core$macros.type_hint_sigs = (function cljs$core$macros$type_hint_sigs(type_sym,sig){
if(cljs.core.vector_QMARK_.call(null,cljs.core.second.call(null,sig))){
return cljs.core$macros.type_hint_single_arity_sig.call(null,type_sym,sig);
} else {
return cljs.core$macros.type_hint_multi_arity_sigs.call(null,type_sym,sig);
}
});
cljs.core$macros.type_hint_impl_map = (function cljs$core$macros$type_hint_impl_map(type_sym,impl_map){
return cljs.core.reduce_kv.call(null,(function (m,proto,sigs){
return cljs.core.assoc.call(null,m,proto,cljs.core.map.call(null,cljs.core.partial.call(null,cljs.core$macros.type_hint_sigs,type_sym),sigs));
}),cljs.core.PersistentArrayMap.EMPTY,impl_map);
});
var ret__9397__auto___36930 = (function (){
/**
 * Extend a type to a series of protocols. Useful when you are
 *   supplying the definitions explicitly inline. Propagates the
 *   type as a type hint on the first argument of all fns.
 * 
 *   type-sym may be
 * 
 * * default, meaning the definitions will apply for any value,
 *   unless an extend-type exists for one of the more specific
 *   cases below.
 * * nil, meaning the definitions will apply for the nil value.
 * * any of object, boolean, number, string, array, or function,
 *   indicating the definitions will apply for values of the
 *   associated base JavaScript types. Note that, for example,
 *   string should be used instead of js/String.
 * * a JavaScript type not covered by the previous list, such
 *   as js/RegExp.
 * * a type defined by deftype or defrecord.
 * 
 *   (extend-type MyType
 *  ICounted
 *  (-count [c] ...)
 *  Foo
 *  (bar [x y] ...)
 *  (baz ([x] ...) ([x y] ...) ...)
 */
cljs.core$macros.extend_type = (function cljs$core$macros$extend_type(var_args){
var args__9364__auto__ = [];
var len__9357__auto___36931 = arguments.length;
var i__9358__auto___36932 = (0);
while(true){
if((i__9358__auto___36932 < len__9357__auto___36931)){
args__9364__auto__.push((arguments[i__9358__auto___36932]));

var G__36933 = (i__9358__auto___36932 + (1));
i__9358__auto___36932 = G__36933;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((3) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.extend_type.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9365__auto__);
});

cljs.core$macros.extend_type.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,type_sym,impls){
var env = _AMPERSAND_env;
var _ = cljs.core$macros.validate_impls.call(null,env,impls);
var resolve = cljs.core.partial.call(null,cljs.core$macros.resolve_var,env);
var impl_map = cljs.core$macros.__GT_impl_map.call(null,impls);
var impl_map__$1 = (cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null,new cljs.core.Symbol(null,"number","number",-1084057331,null),null], null), null).call(null,type_sym))?cljs.core$macros.type_hint_impl_map.call(null,type_sym,impl_map):impl_map);
var vec__36927 = (function (){var temp__4655__auto__ = cljs.core$macros.base_type.call(null,type_sym);
if(cljs.core.truth_(temp__4655__auto__)){
var type = temp__4655__auto__;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [type,cljs.core$macros.base_assign_impls], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [resolve.call(null,type_sym),cljs.core$macros.proto_assign_impls], null);
}
})();
var type = cljs.core.nth.call(null,vec__36927,(0),null);
var assign_impls = cljs.core.nth.call(null,vec__36927,(1),null);
if(cljs.core.truth_((function (){var and__8174__auto__ = new cljs.core.Keyword(null,"extending-base-js-type","extending-base-js-type",432787264).cljs$core$IFn$_invoke$arity$1(cljs.analyzer._STAR_cljs_warnings_STAR_);
if(cljs.core.truth_(and__8174__auto__)){
return cljs.core$macros.js_base_type.call(null,type_sym);
} else {
return and__8174__auto__;
}
})())){
cljs.analyzer.warning.call(null,new cljs.core.Keyword(null,"extending-base-js-type","extending-base-js-type",432787264),env,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"current-symbol","current-symbol",-932381075),type_sym,new cljs.core.Keyword(null,"suggested-symbol","suggested-symbol",-1329631875),cljs.core$macros.js_base_type.call(null,type_sym)], null));
} else {
}

return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),cljs.core.mapcat.call(null,((function (env,_,resolve,impl_map,impl_map__$1,vec__36927,type,assign_impls){
return (function (p1__36922_SHARP_){
return assign_impls.call(null,env,resolve,type_sym,type,p1__36922_SHARP_);
});})(env,_,resolve,impl_map,impl_map__$1,vec__36927,type,assign_impls))
,impl_map__$1))));
});

cljs.core$macros.extend_type.cljs$lang$maxFixedArity = (3);

cljs.core$macros.extend_type.cljs$lang$applyTo = (function (seq36923){
var G__36924 = cljs.core.first.call(null,seq36923);
var seq36923__$1 = cljs.core.next.call(null,seq36923);
var G__36925 = cljs.core.first.call(null,seq36923__$1);
var seq36923__$2 = cljs.core.next.call(null,seq36923__$1);
var G__36926 = cljs.core.first.call(null,seq36923__$2);
var seq36923__$3 = cljs.core.next.call(null,seq36923__$2);
return cljs.core$macros.extend_type.cljs$core$IFn$_invoke$arity$variadic(G__36924,G__36925,G__36926,seq36923__$3);
});

return null;
})()
;
cljs.core$macros.extend_type.cljs$lang$macro = true;

cljs.core$macros.prepare_protocol_masks = (function cljs$core$macros$prepare_protocol_masks(env,impls){
var resolve = cljs.core.partial.call(null,cljs.core$macros.resolve_var,env);
var impl_map = cljs.core$macros.__GT_impl_map.call(null,impls);
var fpp_pbs = cljs.core.seq.call(null,cljs.core.keep.call(null,cljs.core$macros.fast_path_protocols,cljs.core.map.call(null,resolve,cljs.core.keys.call(null,impl_map))));
if(fpp_pbs){
var fpps = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.filter.call(null,cljs.core.partial.call(null,cljs.core.contains_QMARK_,cljs.core$macros.fast_path_protocols),cljs.core.map.call(null,resolve,cljs.core.keys.call(null,impl_map))));
var parts = (function (){var parts = cljs.core.group_by.call(null,cljs.core.first,fpp_pbs);
var parts__$1 = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,cljs.core.juxt.call(null,cljs.core.key,cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,cljs.core.peek),cljs.core.val)),parts));
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,cljs.core.juxt.call(null,cljs.core.key,cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.reduce,cljs.core.bit_or),cljs.core.val)),parts__$1));
})();
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fpps,cljs.core.reduce.call(null,((function (fpps,parts,resolve,impl_map,fpp_pbs){
return (function (ps,p){
return cljs.core.update_in.call(null,ps,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p], null),cljs.core.fnil.call(null,cljs.core.identity,(0)));
});})(fpps,parts,resolve,impl_map,fpp_pbs))
,parts,cljs.core.range.call(null,cljs.core$macros.fast_path_protocol_partitions_count))], null);
} else {
return null;
}
});
cljs.core$macros.annotate_specs = (function cljs$core$macros$annotate_specs(annots,v,p__36935){
var vec__36936 = p__36935;
var f = cljs.core.nth.call(null,vec__36936,(0),null);
var sigs = cljs.core.nth.call(null,vec__36936,(1),null);
return cljs.core.conj.call(null,v,cljs.core.vary_meta.call(null,cljs.core.cons.call(null,f,cljs.core.map.call(null,((function (vec__36936,f,sigs){
return (function (p1__36934_SHARP_){
return cljs.core.cons.call(null,cljs.core.second.call(null,p1__36934_SHARP_),cljs.core.nnext.call(null,p1__36934_SHARP_));
});})(vec__36936,f,sigs))
,sigs)),cljs.core.merge,annots));
});
cljs.core$macros.dt__GT_et = (function cljs$core$macros$dt__GT_et(var_args){
var G__36940 = arguments.length;
switch (G__36940) {
case 3:
return cljs.core$macros.dt__GT_et.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core$macros.dt__GT_et.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core$macros.dt__GT_et.cljs$core$IFn$_invoke$arity$3 = (function (type,specs,fields){
return cljs.core$macros.dt__GT_et.call(null,type,specs,fields,false);
});

cljs.core$macros.dt__GT_et.cljs$core$IFn$_invoke$arity$4 = (function (type,specs,fields,inline){
var annots = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("cljs.analyzer","type","cljs.analyzer/type",478749742),type,new cljs.core.Keyword("cljs.analyzer","protocol-impl","cljs.analyzer/protocol-impl",-1523935409),true,new cljs.core.Keyword("cljs.analyzer","protocol-inline","cljs.analyzer/protocol-inline",-1611519026),inline], null);
var ret = cljs.core.PersistentVector.EMPTY;
var specs__$1 = specs;
while(true){
if(cljs.core.seq.call(null,specs__$1)){
var p = cljs.core.first.call(null,specs__$1);
var ret__$1 = cljs.core.into.call(null,cljs.core.conj.call(null,ret,p),cljs.core.reduce.call(null,cljs.core.partial.call(null,cljs.core$macros.annotate_specs,annots),cljs.core.PersistentVector.EMPTY,cljs.core.group_by.call(null,cljs.core.first,cljs.core.take_while.call(null,cljs.core.seq_QMARK_,cljs.core.next.call(null,specs__$1)))));
var specs__$2 = cljs.core.drop_while.call(null,cljs.core.seq_QMARK_,cljs.core.next.call(null,specs__$1));
var G__36942 = ret__$1;
var G__36943 = specs__$2;
ret = G__36942;
specs__$1 = G__36943;
continue;
} else {
return ret;
}
break;
}
});

cljs.core$macros.dt__GT_et.cljs$lang$maxFixedArity = 4;

cljs.core$macros.collect_protocols = (function cljs$core$macros$collect_protocols(impls,env){
return cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,(function (p1__36944_SHARP_){
return new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.call(null,cljs.core.dissoc.call(null,env,new cljs.core.Keyword(null,"locals","locals",535295783)),p1__36944_SHARP_));
}),cljs.core.filter.call(null,cljs.core.symbol_QMARK_,impls)));
});
cljs.core$macros.build_positional_factory = (function cljs$core$macros$build_positional_factory(rsym,rname,fields){
var fn_name = cljs.core.with_meta.call(null,cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"->","->",-2139605430,null)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(rsym)].join('')),cljs.core.assoc.call(null,cljs.core.meta.call(null,rsym),new cljs.core.Keyword(null,"factory","factory",63933746),new cljs.core.Keyword(null,"positional","positional",-203580463)));
var field_values = (cljs.core.truth_(new cljs.core.Keyword(null,"internal-ctor","internal-ctor",937392560).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,rsym)))?cljs.core.conj.call(null,fields,null,null,null):fields);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","defn","cljs.core$macros/defn",-728332354,null)),(function (){var x__9048__auto__ = fn_name;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,fields))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"new","new",-444906321,null)),(function (){var x__9048__auto__ = rname;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),field_values)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});
cljs.core$macros.validate_fields = (function cljs$core$macros$validate_fields(case$,name,fields){
if(cljs.core.vector_QMARK_.call(null,fields)){
return null;
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1(case$)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),", no fields vector given."].join('')));
}
});
var ret__9397__auto___36956 = (function (){
/**
 * (deftype name [fields*]  options* specs*)
 * 
 *   Currently there are no options.
 * 
 *   Each spec consists of a protocol or interface name followed by zero
 *   or more method bodies:
 * 
 *   protocol-or-Object
 *   (methodName [args*] body)*
 * 
 *   The type will have the (by default, immutable) fields named by
 *   fields, which can have type hints. Protocols and methods
 *   are optional. The only methods that can be supplied are those
 *   declared in the protocols/interfaces.  Note that method bodies are
 *   not closures, the local environment includes only the named fields,
 *   and those fields can be accessed directly. Fields can be qualified
 *   with the metadata :mutable true at which point (set! afield aval) will be
 *   supported in method bodies. Note well that mutable fields are extremely
 *   difficult to use correctly, and are present only to facilitate the building
 *   of higherlevel constructs, such as ClojureScript's reference types, in
 *   ClojureScript itself. They are for experts only - if the semantics and
 *   implications of :mutable are not immediately apparent to you, you should not
 *   be using them.
 * 
 *   Method definitions take the form:
 * 
 *   (methodname [args*] body)
 * 
 *   The argument and return types can be hinted on the arg and
 *   methodname symbols. If not supplied, they will be inferred, so type
 *   hints should be reserved for disambiguation.
 * 
 *   Methods should be supplied for all methods of the desired
 *   protocol(s). You can also define overrides for methods of Object. Note that
 *   a parameter must be supplied to correspond to the target object
 *   ('this' in JavaScript parlance). Note also that recur calls to the method
 *   head should *not* pass the target object, it will be supplied
 *   automatically and can not be substituted.
 * 
 *   In the method bodies, the (unqualified) name can be used to name the
 *   class (for calls to new, instance? etc).
 * 
 *   One constructor will be defined, taking the designated fields.  Note
 *   that the field names __meta and __extmap are currently reserved and
 *   should not be used when defining your own types.
 * 
 *   Given (deftype TypeName ...), a factory function called ->TypeName
 *   will be defined, taking positional parameters for the fields
 */
cljs.core$macros.deftype = (function cljs$core$macros$deftype(var_args){
var args__9364__auto__ = [];
var len__9357__auto___36957 = arguments.length;
var i__9358__auto___36958 = (0);
while(true){
if((i__9358__auto___36958 < len__9357__auto___36957)){
args__9364__auto__.push((arguments[i__9358__auto___36958]));

var G__36959 = (i__9358__auto___36958 + (1));
i__9358__auto___36958 = G__36959;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((4) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((4)),(0),null)):null);
return cljs.core$macros.deftype.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__9365__auto__);
});

cljs.core$macros.deftype.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,t,fields,impls){
cljs.core$macros.validate_fields.call(null,"deftype",t,fields);

var env = _AMPERSAND_env;
var r = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.call(null,cljs.core.dissoc.call(null,env,new cljs.core.Keyword(null,"locals","locals",535295783)),t));
var vec__36953 = cljs.core$macros.prepare_protocol_masks.call(null,env,impls);
var fpps = cljs.core.nth.call(null,vec__36953,(0),null);
var pmasks = cljs.core.nth.call(null,vec__36953,(1),null);
var protocols = cljs.core$macros.collect_protocols.call(null,impls,env);
var t__$1 = cljs.core.vary_meta.call(null,t,cljs.core.assoc,new cljs.core.Keyword(null,"protocols","protocols",-5615896),protocols,new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630),fpps);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"deftype*","deftype*",962659890,null)),(function (){var x__9048__auto__ = t__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = fields;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = pmasks;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = ((cljs.core.seq.call(null,impls))?cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","extend-type","cljs.core$macros/extend-type",1713295201,null)),(function (){var x__9048__auto__ = t__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core$macros.dt__GT_et.call(null,t__$1,impls,fields)))):null);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".-getBasis",".-getBasis",-1306451468,null)),(function (){var x__9048__auto__ = t__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"quote","quote",1377916282,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,fields))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".-cljs$lang$type",".-cljs$lang$type",-1029307724,null)),(function (){var x__9048__auto__ = t__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,true))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".-cljs$lang$ctorStr",".-cljs$lang$ctorStr",-1820706991,null)),(function (){var x__9048__auto__ = t__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(r)].join('');
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".-cljs$lang$ctorPrWriter",".-cljs$lang$ctorPrWriter",255834464,null)),(function (){var x__9048__auto__ = t__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__36945__auto__","this__36945__auto__",-835195614,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"writer__36946__auto__","writer__36946__auto__",682204629,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"opt__36947__auto__","opt__36947__auto__",1814728072,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","-write","cljs.core/-write",527220517,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"writer__36946__auto__","writer__36946__auto__",682204629,null)),(function (){var x__9048__auto__ = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(r)].join('');
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core$macros.build_positional_factory.call(null,t__$1,r,fields);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = t__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros.deftype.cljs$lang$maxFixedArity = (4);

cljs.core$macros.deftype.cljs$lang$applyTo = (function (seq36948){
var G__36949 = cljs.core.first.call(null,seq36948);
var seq36948__$1 = cljs.core.next.call(null,seq36948);
var G__36950 = cljs.core.first.call(null,seq36948__$1);
var seq36948__$2 = cljs.core.next.call(null,seq36948__$1);
var G__36951 = cljs.core.first.call(null,seq36948__$2);
var seq36948__$3 = cljs.core.next.call(null,seq36948__$2);
var G__36952 = cljs.core.first.call(null,seq36948__$3);
var seq36948__$4 = cljs.core.next.call(null,seq36948__$3);
return cljs.core$macros.deftype.cljs$core$IFn$_invoke$arity$variadic(G__36949,G__36950,G__36951,G__36952,seq36948__$4);
});

return null;
})()
;
cljs.core$macros.deftype.cljs$lang$macro = true;

/**
 * Do not use this directly - use defrecord
 */
cljs.core$macros.emit_defrecord = (function cljs$core$macros$emit_defrecord(env,tagname,rname,fields,impls){
var hinted_fields = fields;
var fields__$1 = cljs.core.vec.call(null,cljs.core.map.call(null,((function (hinted_fields){
return (function (p1__36960_SHARP_){
return cljs.core.with_meta.call(null,p1__36960_SHARP_,null);
});})(hinted_fields))
,fields));
var base_fields = fields__$1;
var pr_open = ["#",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.namespace.call(null,rname)),".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,rname)),"{"].join('');
var fields__$2 = cljs.core.conj.call(null,fields__$1,new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),cljs.core.with_meta.call(null,new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)));
var gs = cljs.core.gensym.call(null);
var ksym = cljs.core.gensym.call(null,"k");
var impls__$1 = cljs.core.concat.call(null,impls,new cljs.core.PersistentVector(null, 28, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"IRecord","IRecord",-903221169,null),new cljs.core.Symbol(null,"ICloneable","ICloneable",1882653160,null),cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-clone","-clone",227130084,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__36961__auto__","this__36961__auto__",605386358,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"new","new",-444906321,null)),(function (){var x__9048__auto__ = tagname;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),fields__$2)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))),new cljs.core.Symbol(null,"IHash","IHash",-1495374645,null),cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-hash","-hash",-630070274,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__36962__auto__","this__36962__auto__",-209561319,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","caching-hash","cljs.core$macros/caching-hash",-1892393069,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__36962__auto__","this__36962__auto__",-209561319,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"coll__36963__auto__","coll__36963__auto__",-217337625,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","bit-xor","cljs.core$macros/bit-xor",1284619191,null)),(function (){var x__9048__auto__ = cljs.core.hash.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,rname))].join(''));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","hash-unordered-coll","cljs.core/hash-unordered-coll",-639086053,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"coll__36963__auto__","coll__36963__auto__",-217337625,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))),new cljs.core.Symbol(null,"IEquiv","IEquiv",-1912850869,null),(function (){var this$ = cljs.core.gensym.call(null,new cljs.core.Symbol(null,"this","this",1028897902,null));
var other = cljs.core.gensym.call(null,new cljs.core.Symbol(null,"other","other",-1658642225,null));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-equiv","-equiv",320124272,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = this$;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = other;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","and","cljs.core$macros/and",48320334,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","some?","cljs.core$macros/some?",-253244523,null)),(function (){var x__9048__auto__ = other;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","identical?","cljs.core$macros/identical?",815580547,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".-constructor",".-constructor",279801701,null)),(function (){var x__9048__auto__ = this$;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".-constructor",".-constructor",279801701,null)),(function (){var x__9048__auto__ = other;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core.map.call(null,((function (this$,other,gs,ksym,hinted_fields,fields__$1,base_fields,pr_open,fields__$2){
return (function (field){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","=","cljs.core/=",-1891498332,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"..","..",-300507420,null)),(function (){var x__9048__auto__ = this$;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core$macros.to_property.call(null,field);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"..","..",-300507420,null)),(function (){var x__9048__auto__ = other;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core$macros.to_property.call(null,field);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});})(this$,other,gs,ksym,hinted_fields,fields__$1,base_fields,pr_open,fields__$2))
,base_fields),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","=","cljs.core/=",-1891498332,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".-__extmap",".-__extmap",438409624,null)),(function (){var x__9048__auto__ = this$;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".-__extmap",".-__extmap",438409624,null)),(function (){var x__9048__auto__ = other;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
})(),new cljs.core.Symbol(null,"IMeta","IMeta",1095313672,null),cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-meta","-meta",494863156,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__36964__auto__","this__36964__auto__",-1577753559,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"__meta","__meta",-946752628,null))))),new cljs.core.Symbol(null,"IWithMeta","IWithMeta",-509493158,null),cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-with-meta","-with-meta",-1610713823,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__36965__auto__","this__36965__auto__",747130007,null)),(function (){var x__9048__auto__ = gs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"new","new",-444906321,null)),(function (){var x__9048__auto__ = tagname;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core.replace.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),gs], null),fields__$2))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))),new cljs.core.Symbol(null,"ILookup","ILookup",784647298,null),cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-lookup","-lookup",-1438393944,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__36966__auto__","this__36966__auto__",122771083,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"k__36967__auto__","k__36967__auto__",492011923,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","-lookup","cljs.core/-lookup",-1845674443,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__36966__auto__","this__36966__auto__",122771083,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"k__36967__auto__","k__36967__auto__",492011923,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))),cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-lookup","-lookup",-1438393944,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__36968__auto__","this__36968__auto__",1728878645,null)),(function (){var x__9048__auto__ = ksym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"else__36969__auto__","else__36969__auto__",1306343070,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","case","cljs.core$macros/case",-2131866965,null)),(function (){var x__9048__auto__ = ksym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core.mapcat.call(null,((function (gs,ksym,hinted_fields,fields__$1,base_fields,pr_open,fields__$2){
return (function (f){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,f),f], null);
});})(gs,ksym,hinted_fields,fields__$1,base_fields,pr_open,fields__$2))
,base_fields),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","get","cljs.core/get",-296075407,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null)),(function (){var x__9048__auto__ = ksym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"else__36969__auto__","else__36969__auto__",1306343070,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))),new cljs.core.Symbol(null,"ICounted","ICounted",-1705786327,null),cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-count","-count",416049189,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__36970__auto__","this__36970__auto__",-110112223,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","+","cljs.core$macros/+",-18260342,null)),(function (){var x__9048__auto__ = cljs.core.count.call(null,base_fields);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))),new cljs.core.Symbol(null,"ICollection","ICollection",-686709190,null),cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-conj","-conj",1373798691,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__36971__auto__","this__36971__auto__",-1982190926,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"entry__36972__auto__","entry__36972__auto__",-381553241,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"entry__36972__auto__","entry__36972__auto__",-381553241,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","-assoc","cljs.core/-assoc",-814539323,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__36971__auto__","this__36971__auto__",-1982190926,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","-nth","cljs.core/-nth",504234802,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"entry__36972__auto__","entry__36972__auto__",-381553241,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,(0)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","-nth","cljs.core/-nth",504234802,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"entry__36972__auto__","entry__36972__auto__",-381553241,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,(1)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","reduce","cljs.core/reduce",2025430439,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","-conj","cljs.core/-conj",2040622670,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__36971__auto__","this__36971__auto__",-1982190926,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"entry__36972__auto__","entry__36972__auto__",-381553241,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))),new cljs.core.Symbol(null,"IAssociative","IAssociative",-1306431882,null),cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-assoc","-assoc",-416089758,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__36973__auto__","this__36973__auto__",-1681260382,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"k__36974__auto__","k__36974__auto__",-159174034,null)),(function (){var x__9048__auto__ = gs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","condp","cljs.core$macros/condp",431619047,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","keyword-identical?","cljs.core/keyword-identical?",1598491177,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"k__36974__auto__","k__36974__auto__",-159174034,null)),cljs.core.mapcat.call(null,((function (gs,ksym,hinted_fields,fields__$1,base_fields,pr_open,fields__$2){
return (function (fld){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,fld),cljs.core.list_STAR_.call(null,new cljs.core.Symbol(null,"new","new",-444906321,null),tagname,cljs.core.replace.call(null,cljs.core.PersistentArrayMap.createAsIfByAssoc([fld,gs,new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),null]),fields__$2))], null);
});})(gs,ksym,hinted_fields,fields__$1,base_fields,pr_open,fields__$2))
,base_fields),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"new","new",-444906321,null)),(function (){var x__9048__auto__ = tagname;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core.remove.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),null,new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),null], null), null),fields__$2),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","assoc","cljs.core/assoc",322326297,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"k__36974__auto__","k__36974__auto__",-159174034,null)),(function (){var x__9048__auto__ = gs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))),new cljs.core.Symbol(null,"IMap","IMap",992876629,null),cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-dissoc","-dissoc",1638079447,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__36975__auto__","this__36975__auto__",1880249527,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"k__36976__auto__","k__36976__auto__",982355717,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","contains?","cljs.core/contains?",-976526835,null)),(function (){var x__9048__auto__ = cljs.core.apply.call(null,cljs.core.hash_set,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core.map.call(null,cljs.core.keyword,base_fields)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"k__36976__auto__","k__36976__auto__",982355717,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","dissoc","cljs.core/dissoc",-432349815,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","-with-meta","cljs.core/-with-meta",-146937782,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","into","cljs.core/into",1879938733,null)),(function (){var x__9048__auto__ = cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__36975__auto__","this__36975__auto__",1880249527,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"__meta","__meta",-946752628,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"k__36976__auto__","k__36976__auto__",982355717,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"new","new",-444906321,null)),(function (){var x__9048__auto__ = tagname;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core.remove.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),null,new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),null], null), null),fields__$2),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","not-empty","cljs.core/not-empty",540057011,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","dissoc","cljs.core/dissoc",-432349815,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"k__36976__auto__","k__36976__auto__",982355717,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))),new cljs.core.Symbol(null,"ISeqable","ISeqable",1349682102,null),cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-seq","-seq",1019896831,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__36978__auto__","this__36978__auto__",215847651,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","seq","cljs.core/seq",-1649497689,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","concat","cljs.core/concat",-1133584918,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core.map.call(null,((function (gs,ksym,hinted_fields,fields__$1,base_fields,pr_open,fields__$2){
return (function (p1__36977_SHARP_){
return cljs.core._conj.call(null,(function (){var x__9048__auto__ = cljs.core.keyword.call(null,p1__36977_SHARP_);
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = p1__36977_SHARP_;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})(),new cljs.core.Symbol("cljs.core$macros","vector","cljs.core$macros/vector",912237829,null));
});})(gs,ksym,hinted_fields,fields__$1,base_fields,pr_open,fields__$2))
,base_fields)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))),new cljs.core.Symbol(null,"IIterable","IIterable",577191430,null),cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-iterator","-iterator",310937281,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = gs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"RecordIter.","RecordIter.",-265283060,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,(0)),(function (){var x__9048__auto__ = gs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.count.call(null,base_fields);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core.map.call(null,cljs.core.keyword,base_fields)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","-iterator","cljs.core/-iterator",1833427494,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","nil-iter","cljs.core/nil-iter",-1712403690,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))),new cljs.core.Symbol(null,"IPrintWithWriter","IPrintWithWriter",-1205316154,null),cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-pr-writer","-pr-writer",-445354136,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__36980__auto__","this__36980__auto__",1062846827,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"writer__36981__auto__","writer__36981__auto__",247373361,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"opts__36982__auto__","opts__36982__auto__",-501950665,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"pr-pair__36983__auto__","pr-pair__36983__auto__",276787978,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"keyval__36984__auto__","keyval__36984__auto__",-550833469,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","pr-sequential-writer","cljs.core/pr-sequential-writer",-1101677821,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"writer__36981__auto__","writer__36981__auto__",247373361,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","pr-writer","cljs.core/pr-writer",133956070,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,""),cljs.core._conj.call(null,cljs.core.List.EMPTY," "),cljs.core._conj.call(null,cljs.core.List.EMPTY,""),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"opts__36982__auto__","opts__36982__auto__",-501950665,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"keyval__36984__auto__","keyval__36984__auto__",-550833469,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","pr-sequential-writer","cljs.core/pr-sequential-writer",-1101677821,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"writer__36981__auto__","writer__36981__auto__",247373361,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"pr-pair__36983__auto__","pr-pair__36983__auto__",276787978,null)),(function (){var x__9048__auto__ = pr_open;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,", "),cljs.core._conj.call(null,cljs.core.List.EMPTY,"}"),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"opts__36982__auto__","opts__36982__auto__",-501950665,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","concat","cljs.core/concat",-1133584918,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core.map.call(null,((function (gs,ksym,hinted_fields,fields__$1,base_fields,pr_open,fields__$2){
return (function (p1__36979_SHARP_){
return cljs.core._conj.call(null,(function (){var x__9048__auto__ = cljs.core.keyword.call(null,p1__36979_SHARP_);
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = p1__36979_SHARP_;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})(),new cljs.core.Symbol("cljs.core$macros","vector","cljs.core$macros/vector",912237829,null));
});})(gs,ksym,hinted_fields,fields__$1,base_fields,pr_open,fields__$2))
,base_fields)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())))], null));
var vec__36985 = cljs.core$macros.prepare_protocol_masks.call(null,env,impls__$1);
var fpps = cljs.core.nth.call(null,vec__36985,(0),null);
var pmasks = cljs.core.nth.call(null,vec__36985,(1),null);
var protocols = cljs.core$macros.collect_protocols.call(null,impls__$1,env);
var tagname__$1 = cljs.core.vary_meta.call(null,tagname,cljs.core.assoc,new cljs.core.Keyword(null,"protocols","protocols",-5615896),protocols,new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630),fpps);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"defrecord*","defrecord*",-1936366207,null)),(function (){var x__9048__auto__ = tagname__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = hinted_fields;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = pmasks;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","extend-type","cljs.core$macros/extend-type",1713295201,null)),(function (){var x__9048__auto__ = tagname__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core$macros.dt__GT_et.call(null,tagname__$1,impls__$1,fields__$2,true))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});
cljs.core$macros.build_map_factory = (function cljs$core$macros$build_map_factory(rsym,rname,fields){
var fn_name = cljs.core.with_meta.call(null,cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"map->","map->",-999714600,null)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(rsym)].join('')),cljs.core.assoc.call(null,cljs.core.meta.call(null,rsym),new cljs.core.Keyword(null,"factory","factory",63933746),new cljs.core.Keyword(null,"map","map",1371690461)));
var ms = cljs.core.gensym.call(null);
var ks = cljs.core.map.call(null,cljs.core.keyword,fields);
var getters = cljs.core.map.call(null,((function (fn_name,ms,ks){
return (function (k){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = k;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = ms;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});})(fn_name,ms,ks))
,ks);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","defn","cljs.core$macros/defn",-728332354,null)),(function (){var x__9048__auto__ = fn_name;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = ms;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"new","new",-444906321,null)),(function (){var x__9048__auto__ = rname;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),getters,cljs.core._conj.call(null,cljs.core.List.EMPTY,null),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","not-empty","cljs.core/not-empty",540057011,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","dissoc","cljs.core/dissoc",-432349815,null)),(function (){var x__9048__auto__ = ms;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),ks)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});
var ret__9397__auto___36995 = (function (){
/**
 * (defrecord name [fields*]  options* specs*)
 * 
 *   Currently there are no options.
 * 
 *   Each spec consists of a protocol or interface name followed by zero
 *   or more method bodies:
 * 
 *   protocol-or-Object
 *   (methodName [args*] body)*
 * 
 *   The record will have the (immutable) fields named by
 *   fields, which can have type hints. Protocols and methods
 *   are optional. The only methods that can be supplied are those
 *   declared in the protocols.  Note that method bodies are
 *   not closures, the local environment includes only the named fields,
 *   and those fields can be accessed directly.
 * 
 *   Method definitions take the form:
 * 
 *   (methodname [args*] body)
 * 
 *   The argument and return types can be hinted on the arg and
 *   methodname symbols. If not supplied, they will be inferred, so type
 *   hints should be reserved for disambiguation.
 * 
 *   Methods should be supplied for all methods of the desired
 *   protocol(s). You can also define overrides for
 *   methods of Object. Note that a parameter must be supplied to
 *   correspond to the target object ('this' in JavaScript parlance). Note also
 *   that recur calls to the method head should *not* pass the target object, it
 *   will be supplied automatically and can not be substituted.
 * 
 *   In the method bodies, the (unqualified) name can be used to name the
 *   class (for calls to new, instance? etc).
 * 
 *   The type will have implementations of several ClojureScript
 *   protocol generated automatically: IMeta/IWithMeta (metadata support) and
 *   IMap, etc.
 * 
 *   In addition, defrecord will define type-and-value-based =,
 *   and will define ClojureScript IHash and IEquiv.
 * 
 *   Two constructors will be defined, one taking the designated fields
 *   followed by a metadata map (nil for none) and an extension field
 *   map (nil for none), and one taking only the fields (using nil for
 *   meta and extension fields). Note that the field names __meta
 *   and __extmap are currently reserved and should not be used when
 *   defining your own records.
 * 
 *   Given (defrecord TypeName ...), two factory functions will be
 *   defined: ->TypeName, taking positional parameters for the fields,
 *   and map->TypeName, taking a map of keywords to field values.
 */
cljs.core$macros.defrecord = (function cljs$core$macros$defrecord(var_args){
var args__9364__auto__ = [];
var len__9357__auto___36996 = arguments.length;
var i__9358__auto___36997 = (0);
while(true){
if((i__9358__auto___36997 < len__9357__auto___36996)){
args__9364__auto__.push((arguments[i__9358__auto___36997]));

var G__36998 = (i__9358__auto___36997 + (1));
i__9358__auto___36997 = G__36998;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((4) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((4)),(0),null)):null);
return cljs.core$macros.defrecord.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__9365__auto__);
});

cljs.core$macros.defrecord.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,rsym,fields,impls){
cljs.core$macros.validate_fields.call(null,"defrecord",rsym,fields);

var rsym__$1 = cljs.core.vary_meta.call(null,rsym,cljs.core.assoc,new cljs.core.Keyword(null,"internal-ctor","internal-ctor",937392560),true);
var r = cljs.core.vary_meta.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.call(null,cljs.core.dissoc.call(null,_AMPERSAND_env,new cljs.core.Keyword(null,"locals","locals",535295783)),rsym__$1)),cljs.core.assoc,new cljs.core.Keyword(null,"internal-ctor","internal-ctor",937392560),true);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core$macros.emit_defrecord.call(null,_AMPERSAND_env,rsym__$1,r,fields,impls);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".-getBasis",".-getBasis",-1306451468,null)),(function (){var x__9048__auto__ = r;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"quote","quote",1377916282,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,fields))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".-cljs$lang$type",".-cljs$lang$type",-1029307724,null)),(function (){var x__9048__auto__ = r;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,true))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".-cljs$lang$ctorPrSeq",".-cljs$lang$ctorPrSeq",41132414,null)),(function (){var x__9048__auto__ = r;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__36988__auto__","this__36988__auto__",-609471731,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","list","cljs.core/list",-1331406371,null)),(function (){var x__9048__auto__ = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(r)].join('');
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".-cljs$lang$ctorPrWriter",".-cljs$lang$ctorPrWriter",255834464,null)),(function (){var x__9048__auto__ = r;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__36988__auto__","this__36988__auto__",-609471731,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"writer__36989__auto__","writer__36989__auto__",1039869880,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","-write","cljs.core/-write",527220517,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"writer__36989__auto__","writer__36989__auto__",1039869880,null)),(function (){var x__9048__auto__ = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(r)].join('');
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core$macros.build_positional_factory.call(null,rsym__$1,r,fields);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core$macros.build_map_factory.call(null,rsym__$1,r,fields);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = r;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros.defrecord.cljs$lang$maxFixedArity = (4);

cljs.core$macros.defrecord.cljs$lang$applyTo = (function (seq36990){
var G__36991 = cljs.core.first.call(null,seq36990);
var seq36990__$1 = cljs.core.next.call(null,seq36990);
var G__36992 = cljs.core.first.call(null,seq36990__$1);
var seq36990__$2 = cljs.core.next.call(null,seq36990__$1);
var G__36993 = cljs.core.first.call(null,seq36990__$2);
var seq36990__$3 = cljs.core.next.call(null,seq36990__$2);
var G__36994 = cljs.core.first.call(null,seq36990__$3);
var seq36990__$4 = cljs.core.next.call(null,seq36990__$3);
return cljs.core$macros.defrecord.cljs$core$IFn$_invoke$arity$variadic(G__36991,G__36992,G__36993,G__36994,seq36990__$4);
});

return null;
})()
;
cljs.core$macros.defrecord.cljs$lang$macro = true;

var ret__9397__auto___37026 = (function (){
/**
 * A protocol is a named set of named methods and their signatures:
 * 
 *   (defprotocol AProtocolName
 *  ;optional doc string
 *  "A doc string for AProtocol abstraction"
 * 
 *   ;method signatures
 *  (bar [this a b] "bar docs")
 *  (baz [this a] [this a b] [this a b c] "baz docs"))
 * 
 *   No implementations are provided. Docs can be specified for the
 *   protocol overall and for each method. The above yields a set of
 *   polymorphic functions and a protocol object. All are
 *   namespace-qualified by the ns enclosing the definition The resulting
 *   functions dispatch on the type of their first argument, which is
 *   required and corresponds to the implicit target object ('this' in
 *   JavaScript parlance). defprotocol is dynamic, has no special compile-time
 *   effect, and defines no new types.
 * 
 *   (defprotocol P
 *  (foo [this])
 *  (bar-me [this] [this y]))
 * 
 *   (deftype Foo [a b c]
 *  P
 *  (foo [this] a)
 *  (bar-me [this] b)
 *  (bar-me [this y] (+ c y)))
 * 
 *   (bar-me (Foo. 1 2 3) 42)
 *   => 45
 * 
 *   (foo
 *  (let [x 42]
 *    (reify P
 *      (foo [this] 17)
 *      (bar-me [this] x)
 *      (bar-me [this y] x))))
 *   => 17
 */
cljs.core$macros.defprotocol = (function cljs$core$macros$defprotocol(var_args){
var args__9364__auto__ = [];
var len__9357__auto___37027 = arguments.length;
var i__9358__auto___37028 = (0);
while(true){
if((i__9358__auto___37028 < len__9357__auto___37027)){
args__9364__auto__.push((arguments[i__9358__auto___37028]));

var G__37029 = (i__9358__auto___37028 + (1));
i__9358__auto___37028 = G__37029;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((3) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.defprotocol.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9365__auto__);
});

cljs.core$macros.defprotocol.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,psym,doc_PLUS_methods){
var p = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.call(null,cljs.core.dissoc.call(null,_AMPERSAND_env,new cljs.core.Keyword(null,"locals","locals",535295783)),psym));
var vec__37005 = ((typeof cljs.core.first.call(null,doc_PLUS_methods) === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,doc_PLUS_methods),cljs.core.next.call(null,doc_PLUS_methods)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,doc_PLUS_methods], null));
var doc = cljs.core.nth.call(null,vec__37005,(0),null);
var methods$ = cljs.core.nth.call(null,vec__37005,(1),null);
var psym__$1 = cljs.core.vary_meta.call(null,psym,cljs.core.assoc,new cljs.core.Keyword(null,"doc","doc",1913296891),doc,new cljs.core.Keyword(null,"protocol-symbol","protocol-symbol",1279552198),true);
var ns_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(_AMPERSAND_env));
var fqn = ((function (p,vec__37005,doc,methods$,psym__$1,ns_name){
return (function (n){
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)].join(''));
});})(p,vec__37005,doc,methods$,psym__$1,ns_name))
;
var prefix = cljs.core$macros.protocol_prefix.call(null,p);
var _ = (function (){var seq__37008 = cljs.core.seq.call(null,methods$);
var chunk__37009 = null;
var count__37010 = (0);
var i__37011 = (0);
while(true){
if((i__37011 < count__37010)){
var vec__37012 = cljs.core._nth.call(null,chunk__37009,i__37011);
var seq__37013 = cljs.core.seq.call(null,vec__37012);
var first__37014 = cljs.core.first.call(null,seq__37013);
var seq__37013__$1 = cljs.core.next.call(null,seq__37013);
var mname = first__37014;
var arities = seq__37013__$1;
if(cljs.core.truth_(cljs.core.some.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [(0),null], null), null),cljs.core.map.call(null,cljs.core.count,cljs.core.filter.call(null,cljs.core.vector_QMARK_,arities))))){
throw (new Error(["Invalid protocol, ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym__$1)," defines method ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)," with arity 0"].join('')));
} else {
}

var G__37030 = seq__37008;
var G__37031 = chunk__37009;
var G__37032 = count__37010;
var G__37033 = (i__37011 + (1));
seq__37008 = G__37030;
chunk__37009 = G__37031;
count__37010 = G__37032;
i__37011 = G__37033;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__37008);
if(temp__4657__auto__){
var seq__37008__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__37008__$1)){
var c__9025__auto__ = cljs.core.chunk_first.call(null,seq__37008__$1);
var G__37034 = cljs.core.chunk_rest.call(null,seq__37008__$1);
var G__37035 = c__9025__auto__;
var G__37036 = cljs.core.count.call(null,c__9025__auto__);
var G__37037 = (0);
seq__37008 = G__37034;
chunk__37009 = G__37035;
count__37010 = G__37036;
i__37011 = G__37037;
continue;
} else {
var vec__37015 = cljs.core.first.call(null,seq__37008__$1);
var seq__37016 = cljs.core.seq.call(null,vec__37015);
var first__37017 = cljs.core.first.call(null,seq__37016);
var seq__37016__$1 = cljs.core.next.call(null,seq__37016);
var mname = first__37017;
var arities = seq__37016__$1;
if(cljs.core.truth_(cljs.core.some.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [(0),null], null), null),cljs.core.map.call(null,cljs.core.count,cljs.core.filter.call(null,cljs.core.vector_QMARK_,arities))))){
throw (new Error(["Invalid protocol, ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym__$1)," defines method ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)," with arity 0"].join('')));
} else {
}

var G__37038 = cljs.core.next.call(null,seq__37008__$1);
var G__37039 = null;
var G__37040 = (0);
var G__37041 = (0);
seq__37008 = G__37038;
chunk__37009 = G__37039;
count__37010 = G__37040;
i__37011 = G__37041;
continue;
}
} else {
return null;
}
}
break;
}
})();
var expand_sig = ((function (p,vec__37005,doc,methods$,psym__$1,ns_name,fqn,prefix,_){
return (function (fname,slot,sig){
var sig__$1 = ((!(cljs.core.every_QMARK_.call(null,cljs.core.symbol_QMARK_,sig)))?cljs.core.mapv.call(null,((function (p,vec__37005,doc,methods$,psym__$1,ns_name,fqn,prefix,_){
return (function (arg){
if((arg instanceof cljs.core.Symbol)){
return arg;
} else {
if((cljs.core.map_QMARK_.call(null,arg)) && (!((new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(arg) == null)))){
return new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(arg);
} else {
return cljs.core.gensym.call(null);

}
}
});})(p,vec__37005,doc,methods$,psym__$1,ns_name,fqn,prefix,_))
,sig):sig);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = sig__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","and","cljs.core$macros/and",48320334,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","nil?","cljs.core$macros/nil?",83624258,null)),(function (){var x__9048__auto__ = cljs.core.first.call(null,sig__$1);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","nil?","cljs.core$macros/nil?",83624258,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__9048__auto__ = cljs.core.first.call(null,sig__$1);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.symbol.call(null,["-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(slot)].join(''));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__9048__auto__ = cljs.core.first.call(null,sig__$1);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = slot;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),sig__$1)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"x__36999__auto__","x__36999__auto__",-1665806065,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","nil?","cljs.core$macros/nil?",83624258,null)),(function (){var x__9048__auto__ = cljs.core.first.call(null,sig__$1);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null),(function (){var x__9048__auto__ = cljs.core.first.call(null,sig__$1);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"m__37000__auto__","m__37000__auto__",2030698812,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","unchecked-get","cljs.core$macros/unchecked-get",-1185166893,null)),(function (){var x__9048__auto__ = fqn.call(null,fname);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("goog","typeOf","goog/typeOf",539097255,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"x__36999__auto__","x__36999__auto__",-1665806065,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","if-not","cljs.core$macros/if-not",-1825285737,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","nil?","cljs.core$macros/nil?",83624258,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"m__37000__auto__","m__37000__auto__",2030698812,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"m__37000__auto__","m__37000__auto__",2030698812,null)),sig__$1)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"m__37000__auto__","m__37000__auto__",2030698812,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","unchecked-get","cljs.core$macros/unchecked-get",-1185166893,null)),(function (){var x__9048__auto__ = fqn.call(null,fname);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,"_"))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","if-not","cljs.core$macros/if-not",-1825285737,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","nil?","cljs.core$macros/nil?",83624258,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"m__37000__auto__","m__37000__auto__",2030698812,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"m__37000__auto__","m__37000__auto__",2030698812,null)),sig__$1)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"throw","throw",595905694,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","missing-protocol","cljs.core/missing-protocol",531539732,null)),(function (){var x__9048__auto__ = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym__$1),".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fname)].join('');
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.first.call(null,sig__$1);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});})(p,vec__37005,doc,methods$,psym__$1,ns_name,fqn,prefix,_))
;
var psym__$2 = cljs.core.vary_meta.call(null,cljs.core.vary_meta.call(null,psym__$1,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516)], null),cljs.core.conj,"@interface"),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"protocol-info","protocol-info",1471745843),new cljs.core.Keyword(null,"methods","methods",453930866)], null),cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,((function (p,vec__37005,doc,methods$,psym__$1,ns_name,fqn,prefix,_,expand_sig){
return (function (p__37018){
var vec__37019 = p__37018;
var seq__37020 = cljs.core.seq.call(null,vec__37019);
var first__37021 = cljs.core.first.call(null,seq__37020);
var seq__37020__$1 = cljs.core.next.call(null,seq__37020);
var fname = first__37021;
var sigs = seq__37020__$1;
var doc__$1 = (function (){var doc__$1 = cljs.core.last.call(null,sigs);
if(typeof doc__$1 === 'string'){
return doc__$1;
} else {
return null;
}
})();
var sigs__$1 = cljs.core.take_while.call(null,cljs.core.vector_QMARK_,sigs);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.vary_meta.call(null,fname,cljs.core.assoc,new cljs.core.Keyword(null,"doc","doc",1913296891),doc__$1),cljs.core.vec.call(null,sigs__$1)], null);
});})(p,vec__37005,doc,methods$,psym__$1,ns_name,fqn,prefix,_,expand_sig))
,methods$)));
var method = ((function (p,vec__37005,doc,methods$,psym__$1,ns_name,fqn,prefix,_,expand_sig,psym__$2){
return (function (p__37022){
var vec__37023 = p__37022;
var seq__37024 = cljs.core.seq.call(null,vec__37023);
var first__37025 = cljs.core.first.call(null,seq__37024);
var seq__37024__$1 = cljs.core.next.call(null,seq__37024);
var fname = first__37025;
var sigs = seq__37024__$1;
var doc__$1 = (function (){var doc__$1 = cljs.core.last.call(null,sigs);
if(typeof doc__$1 === 'string'){
return doc__$1;
} else {
return null;
}
})();
var sigs__$1 = cljs.core.take_while.call(null,cljs.core.vector_QMARK_,sigs);
var amp = (cljs.core.truth_(cljs.core.some.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"&","&",-2144855648,null),null], null), null),cljs.core.apply.call(null,cljs.core.concat,sigs__$1)))?cljs.analyzer.warning.call(null,new cljs.core.Keyword(null,"protocol-with-variadic-method","protocol-with-variadic-method",-693368178),_AMPERSAND_env,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"protocol","protocol",652470118),psym__$2,new cljs.core.Keyword(null,"name","name",1843675177),fname], null)):null);
var slot = cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefix),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,fname))].join(''));
var fname__$1 = cljs.core.vary_meta.call(null,fname,cljs.core.assoc,new cljs.core.Keyword(null,"protocol","protocol",652470118),p,new cljs.core.Keyword(null,"doc","doc",1913296891),doc__$1);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","defn","cljs.core$macros/defn",-728332354,null)),(function (){var x__9048__auto__ = fname__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core.map.call(null,((function (doc__$1,sigs__$1,amp,slot,fname__$1,vec__37023,seq__37024,first__37025,seq__37024__$1,fname,sigs,p,vec__37005,doc,methods$,psym__$1,ns_name,fqn,prefix,_,expand_sig,psym__$2){
return (function (sig){
return expand_sig.call(null,fname__$1,cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(slot),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,sig))].join('')),sig);
});})(doc__$1,sigs__$1,amp,slot,fname__$1,vec__37023,seq__37024,first__37025,seq__37024__$1,fname,sigs,p,vec__37005,doc,methods$,psym__$1,ns_name,fqn,prefix,_,expand_sig,psym__$2))
,sigs__$1))));
});})(p,vec__37005,doc,methods$,psym__$1,ns_name,fqn,prefix,_,expand_sig,psym__$2))
;
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"*unchecked-if*","*unchecked-if*",1542408350,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,true))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"def","def",597100991,null)),(function (){var x__9048__auto__ = psym__$2;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"js*","js*",-1134233646,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,"function(){}"))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core.map.call(null,method,methods$),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"*unchecked-if*","*unchecked-if*",1542408350,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,false))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros.defprotocol.cljs$lang$maxFixedArity = (3);

cljs.core$macros.defprotocol.cljs$lang$applyTo = (function (seq37001){
var G__37002 = cljs.core.first.call(null,seq37001);
var seq37001__$1 = cljs.core.next.call(null,seq37001);
var G__37003 = cljs.core.first.call(null,seq37001__$1);
var seq37001__$2 = cljs.core.next.call(null,seq37001__$1);
var G__37004 = cljs.core.first.call(null,seq37001__$2);
var seq37001__$3 = cljs.core.next.call(null,seq37001__$2);
return cljs.core$macros.defprotocol.cljs$core$IFn$_invoke$arity$variadic(G__37002,G__37003,G__37004,seq37001__$3);
});

return null;
})()
;
cljs.core$macros.defprotocol.cljs$lang$macro = true;

var ret__9397__auto___37045 = /**
 * EXPERIMENTAL
 */
cljs.core$macros.implements_QMARK_ = (function cljs$core$macros$implements_QMARK_(_AMPERSAND_form,_AMPERSAND_env,psym,x){
var p = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.call(null,cljs.core.dissoc.call(null,_AMPERSAND_env,new cljs.core.Keyword(null,"locals","locals",535295783)),psym));
var prefix = cljs.core$macros.protocol_prefix.call(null,p);
var xsym = cljs.core$macros.bool_expr.call(null,cljs.core.gensym.call(null));
var vec__37042 = cljs.core$macros.fast_path_protocols.call(null,p);
var part = cljs.core.nth.call(null,vec__37042,(0),null);
var bit = cljs.core.nth.call(null,vec__37042,(1),null);
var msym = cljs.core.symbol.call(null,["-cljs$lang$protocol_mask$partition",cljs.core.str.cljs$core$IFn$_invoke$arity$1(part),"$"].join(''));
if(!((x instanceof cljs.core.Symbol))){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = xsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__9048__auto__ = xsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","or","cljs.core$macros/or",1346243648,null)),(function (){var x__9048__auto__ = (cljs.core.truth_(bit)?cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","unsafe-bit-and","cljs.core$macros/unsafe-bit-and",1803731600,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__9048__auto__ = xsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = msym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = bit;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))):false);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","identical?","cljs.core$macros/identical?",815580547,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","PROTOCOL_SENTINEL","cljs.core/PROTOCOL_SENTINEL",210209696,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__9048__auto__ = xsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.symbol.call(null,["-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefix)].join(''));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,true),cljs.core._conj.call(null,cljs.core.List.EMPTY,false))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,false))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
} else {
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","if-not","cljs.core$macros/if-not",-1825285737,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","nil?","cljs.core$macros/nil?",83624258,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","or","cljs.core$macros/or",1346243648,null)),(function (){var x__9048__auto__ = (cljs.core.truth_(bit)?cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","unsafe-bit-and","cljs.core$macros/unsafe-bit-and",1803731600,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = msym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = bit;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))):false);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","identical?","cljs.core$macros/identical?",815580547,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","PROTOCOL_SENTINEL","cljs.core/PROTOCOL_SENTINEL",210209696,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.symbol.call(null,["-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefix)].join(''));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,true),cljs.core._conj.call(null,cljs.core.List.EMPTY,false))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,false))));
}
});
cljs.core$macros.implements_QMARK_.cljs$lang$macro = true;

var ret__9397__auto___37049 = /**
 * Returns true if x satisfies the protocol
 */
cljs.core$macros.satisfies_QMARK_ = (function cljs$core$macros$satisfies_QMARK_(_AMPERSAND_form,_AMPERSAND_env,psym,x){
var p = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.call(null,cljs.core.dissoc.call(null,_AMPERSAND_env,new cljs.core.Keyword(null,"locals","locals",535295783)),psym));
var prefix = cljs.core$macros.protocol_prefix.call(null,p);
var xsym = cljs.core$macros.bool_expr.call(null,cljs.core.gensym.call(null));
var vec__37046 = cljs.core$macros.fast_path_protocols.call(null,p);
var part = cljs.core.nth.call(null,vec__37046,(0),null);
var bit = cljs.core.nth.call(null,vec__37046,(1),null);
var msym = cljs.core.symbol.call(null,["-cljs$lang$protocol_mask$partition",cljs.core.str.cljs$core$IFn$_invoke$arity$1(part),"$"].join(''));
if(!((x instanceof cljs.core.Symbol))){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = xsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","if-not","cljs.core$macros/if-not",-1825285737,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","nil?","cljs.core$macros/nil?",83624258,null)),(function (){var x__9048__auto__ = xsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","or","cljs.core$macros/or",1346243648,null)),(function (){var x__9048__auto__ = (cljs.core.truth_(bit)?cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","unsafe-bit-and","cljs.core$macros/unsafe-bit-and",1803731600,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__9048__auto__ = xsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = msym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = bit;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))):false);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","identical?","cljs.core$macros/identical?",815580547,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","PROTOCOL_SENTINEL","cljs.core/PROTOCOL_SENTINEL",210209696,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__9048__auto__ = xsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.symbol.call(null,["-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefix)].join(''));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,true),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","coercive-not","cljs.core$macros/coercive-not",115999987,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__9048__auto__ = xsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = msym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","native-satisfies?","cljs.core/native-satisfies?",1482305036,null)),(function (){var x__9048__auto__ = psym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = xsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,false))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","native-satisfies?","cljs.core/native-satisfies?",1482305036,null)),(function (){var x__9048__auto__ = psym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = xsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
} else {
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","if-not","cljs.core$macros/if-not",-1825285737,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","nil?","cljs.core$macros/nil?",83624258,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","or","cljs.core$macros/or",1346243648,null)),(function (){var x__9048__auto__ = (cljs.core.truth_(bit)?cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","unsafe-bit-and","cljs.core$macros/unsafe-bit-and",1803731600,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = msym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = bit;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))):false);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","identical?","cljs.core$macros/identical?",815580547,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","PROTOCOL_SENTINEL","cljs.core/PROTOCOL_SENTINEL",210209696,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.symbol.call(null,["-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefix)].join(''));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,true),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","coercive-not","cljs.core$macros/coercive-not",115999987,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = msym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","native-satisfies?","cljs.core/native-satisfies?",1482305036,null)),(function (){var x__9048__auto__ = psym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,false))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","native-satisfies?","cljs.core/native-satisfies?",1482305036,null)),(function (){var x__9048__auto__ = psym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
}
});
cljs.core$macros.satisfies_QMARK_.cljs$lang$macro = true;

var ret__9397__auto___37053 = (function (){
/**
 * Takes a body of expressions that returns an ISeq or nil, and yields
 *   a ISeqable object that will invoke the body only the first time seq
 *   is called, and will cache the result and return it on all subsequent
 *   seq calls.
 */
cljs.core$macros.lazy_seq = (function cljs$core$macros$lazy_seq(var_args){
var args__9364__auto__ = [];
var len__9357__auto___37054 = arguments.length;
var i__9358__auto___37055 = (0);
while(true){
if((i__9358__auto___37055 < len__9357__auto___37054)){
args__9364__auto__.push((arguments[i__9358__auto___37055]));

var G__37056 = (i__9358__auto___37055 + (1));
i__9358__auto___37055 = G__37056;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((2) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.lazy_seq.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9365__auto__);
});

cljs.core$macros.lazy_seq.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,body){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"new","new",-444906321,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","LazySeq","cljs.core/LazySeq",1986389673,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,null),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),body)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null),cljs.core._conj.call(null,cljs.core.List.EMPTY,null))));
});

cljs.core$macros.lazy_seq.cljs$lang$maxFixedArity = (2);

cljs.core$macros.lazy_seq.cljs$lang$applyTo = (function (seq37050){
var G__37051 = cljs.core.first.call(null,seq37050);
var seq37050__$1 = cljs.core.next.call(null,seq37050);
var G__37052 = cljs.core.first.call(null,seq37050__$1);
var seq37050__$2 = cljs.core.next.call(null,seq37050__$1);
return cljs.core$macros.lazy_seq.cljs$core$IFn$_invoke$arity$variadic(G__37051,G__37052,seq37050__$2);
});

return null;
})()
;
cljs.core$macros.lazy_seq.cljs$lang$macro = true;

var ret__9397__auto___37060 = (function (){
/**
 * Takes a body of expressions and yields a Delay object that will
 *   invoke the body only the first time it is forced (with force or deref/@), and
 *   will cache the result and return it on all subsequent force
 *   calls.
 */
cljs.core$macros.delay = (function cljs$core$macros$delay(var_args){
var args__9364__auto__ = [];
var len__9357__auto___37061 = arguments.length;
var i__9358__auto___37062 = (0);
while(true){
if((i__9358__auto___37062 < len__9357__auto___37061)){
args__9364__auto__.push((arguments[i__9358__auto___37062]));

var G__37063 = (i__9358__auto___37062 + (1));
i__9358__auto___37062 = G__37063;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((2) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.delay.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9365__auto__);
});

cljs.core$macros.delay.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,body){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"new","new",-444906321,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","Delay","cljs.core/Delay",-21574999,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),body)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null))));
});

cljs.core$macros.delay.cljs$lang$maxFixedArity = (2);

cljs.core$macros.delay.cljs$lang$applyTo = (function (seq37057){
var G__37058 = cljs.core.first.call(null,seq37057);
var seq37057__$1 = cljs.core.next.call(null,seq37057);
var G__37059 = cljs.core.first.call(null,seq37057__$1);
var seq37057__$2 = cljs.core.next.call(null,seq37057__$1);
return cljs.core$macros.delay.cljs$core$IFn$_invoke$arity$variadic(G__37058,G__37059,seq37057__$2);
});

return null;
})()
;
cljs.core$macros.delay.cljs$lang$macro = true;

var ret__9397__auto___37072 = (function (){
/**
 * binding => var-symbol temp-value-expr
 * 
 *   Temporarily redefines vars while executing the body.  The
 *   temp-value-exprs will be evaluated and each resulting value will
 *   replace in parallel the root value of its var.  After the body is
 *   executed, the root values of all the vars will be set back to their
 *   old values. Useful for mocking out functions during testing.
 */
cljs.core$macros.with_redefs = (function cljs$core$macros$with_redefs(var_args){
var args__9364__auto__ = [];
var len__9357__auto___37073 = arguments.length;
var i__9358__auto___37074 = (0);
while(true){
if((i__9358__auto___37074 < len__9357__auto___37073)){
args__9364__auto__.push((arguments[i__9358__auto___37074]));

var G__37075 = (i__9358__auto___37074 + (1));
i__9358__auto___37074 = G__37075;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((3) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.with_redefs.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9365__auto__);
});

cljs.core$macros.with_redefs.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,bindings,body){
var names = cljs.core.take_nth.call(null,(2),bindings);
var vals = cljs.core.take_nth.call(null,(2),cljs.core.drop.call(null,(1),bindings));
var tempnames = cljs.core.map.call(null,cljs.core.comp.call(null,cljs.core.gensym,cljs.core.name),names);
var binds = cljs.core.map.call(null,cljs.core.vector,names,vals);
var resets = cljs.core.reverse.call(null,cljs.core.map.call(null,cljs.core.vector,names,tempnames));
var bind_value = ((function (names,vals,tempnames,binds,resets){
return (function (p__37068){
var vec__37069 = p__37068;
var k = cljs.core.nth.call(null,vec__37069,(0),null);
var v = cljs.core.nth.call(null,vec__37069,(1),null);
return cljs.core._conj.call(null,(function (){var x__9048__auto__ = k;
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = v;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})(),new cljs.core.Symbol(null,"set!","set!",250714521,null));
});})(names,vals,tempnames,binds,resets))
;
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core.interleave.call(null,tempnames,names)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core.map.call(null,bind_value,binds),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"try","try",-1273693247,null)),body,(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"finally","finally",-1065347064,null)),cljs.core.map.call(null,bind_value,resets))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros.with_redefs.cljs$lang$maxFixedArity = (3);

cljs.core$macros.with_redefs.cljs$lang$applyTo = (function (seq37064){
var G__37065 = cljs.core.first.call(null,seq37064);
var seq37064__$1 = cljs.core.next.call(null,seq37064);
var G__37066 = cljs.core.first.call(null,seq37064__$1);
var seq37064__$2 = cljs.core.next.call(null,seq37064__$1);
var G__37067 = cljs.core.first.call(null,seq37064__$2);
var seq37064__$3 = cljs.core.next.call(null,seq37064__$2);
return cljs.core$macros.with_redefs.cljs$core$IFn$_invoke$arity$variadic(G__37065,G__37066,G__37067,seq37064__$3);
});

return null;
})()
;
cljs.core$macros.with_redefs.cljs$lang$macro = true;

var ret__9397__auto___37080 = (function (){
/**
 * binding => var-symbol init-expr
 * 
 *   Creates new bindings for the (already-existing) vars, with the
 *   supplied initial values, executes the exprs in an implicit do, then
 *   re-establishes the bindings that existed before.  The new bindings
 *   are made in parallel (unlike let); all init-exprs are evaluated
 *   before the vars are bound to their new values.
 */
cljs.core$macros.binding = (function cljs$core$macros$binding(var_args){
var args__9364__auto__ = [];
var len__9357__auto___37081 = arguments.length;
var i__9358__auto___37082 = (0);
while(true){
if((i__9358__auto___37082 < len__9357__auto___37081)){
args__9364__auto__.push((arguments[i__9358__auto___37082]));

var G__37083 = (i__9358__auto___37082 + (1));
i__9358__auto___37082 = G__37083;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((3) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.binding.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9365__auto__);
});

cljs.core$macros.binding.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,bindings,body){
var names = cljs.core.take_nth.call(null,(2),bindings);
cljs.analyzer.confirm_bindings.call(null,_AMPERSAND_env,names);

return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","with-redefs","cljs.core$macros/with-redefs",1489217801,null)),(function (){var x__9048__auto__ = bindings;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),body)));
});

cljs.core$macros.binding.cljs$lang$maxFixedArity = (3);

cljs.core$macros.binding.cljs$lang$applyTo = (function (seq37076){
var G__37077 = cljs.core.first.call(null,seq37076);
var seq37076__$1 = cljs.core.next.call(null,seq37076);
var G__37078 = cljs.core.first.call(null,seq37076__$1);
var seq37076__$2 = cljs.core.next.call(null,seq37076__$1);
var G__37079 = cljs.core.first.call(null,seq37076__$2);
var seq37076__$3 = cljs.core.next.call(null,seq37076__$2);
return cljs.core$macros.binding.cljs$core$IFn$_invoke$arity$variadic(G__37077,G__37078,G__37079,seq37076__$3);
});

return null;
})()
;
cljs.core$macros.binding.cljs$lang$macro = true;

var ret__9397__auto___37096 = (function (){
/**
 * Takes a binary predicate, an expression, and a set of clauses.
 *   Each clause can take the form of either:
 * 
 *   test-expr result-expr
 * 
 *   test-expr :>> result-fn
 * 
 *   Note :>> is an ordinary keyword.
 * 
 *   For each clause, (pred test-expr expr) is evaluated. If it returns
 *   logical true, the clause is a match. If a binary clause matches, the
 *   result-expr is returned, if a ternary clause matches, its result-fn,
 *   which must be a unary function, is called with the result of the
 *   predicate as its argument, the result of that call being the return
 *   value of condp. A single default expression can follow the clauses,
 *   and its value will be returned if no clause matches. If no default
 *   expression is provided and no clause matches, an
 *   IllegalArgumentException is thrown.
 */
cljs.core$macros.condp = (function cljs$core$macros$condp(var_args){
var args__9364__auto__ = [];
var len__9357__auto___37097 = arguments.length;
var i__9358__auto___37098 = (0);
while(true){
if((i__9358__auto___37098 < len__9357__auto___37097)){
args__9364__auto__.push((arguments[i__9358__auto___37098]));

var G__37099 = (i__9358__auto___37098 + (1));
i__9358__auto___37098 = G__37099;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((4) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((4)),(0),null)):null);
return cljs.core$macros.condp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__9365__auto__);
});

cljs.core$macros.condp.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,pred,expr,clauses){
var gpred = cljs.core.gensym.call(null,"pred__");
var gexpr = cljs.core.gensym.call(null,"expr__");
var emit = ((function (gpred,gexpr){
return (function cljs$core$macros$emit(pred__$1,expr__$1,args){
var vec__37090 = cljs.core.split_at.call(null,((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,">>",">>",-277509267),cljs.core.second.call(null,args)))?(3):(2)),args);
var vec__37093 = cljs.core.nth.call(null,vec__37090,(0),null);
var a = cljs.core.nth.call(null,vec__37093,(0),null);
var b = cljs.core.nth.call(null,vec__37093,(1),null);
var c = cljs.core.nth.call(null,vec__37093,(2),null);
var clause = vec__37093;
var more = cljs.core.nth.call(null,vec__37090,(1),null);
var n = cljs.core.count.call(null,clause);
if(cljs.core._EQ_.call(null,(0),n)){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"throw","throw",595905694,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("js","Error.","js/Error.",750655924,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","str","cljs.core/str",-1971828991,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,"No matching clause: "),(function (){var x__9048__auto__ = expr__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
} else {
if(cljs.core._EQ_.call(null,(1),n)){
return a;
} else {
if(cljs.core._EQ_.call(null,(2),n)){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = pred__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = a;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = expr__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = b;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs$core$macros$emit.call(null,pred__$1,expr__$1,more);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
} else {
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","if-let","cljs.core$macros/if-let",1291543946,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"p__37084__auto__","p__37084__auto__",1389168618,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = pred__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = a;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = expr__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = c;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"p__37084__auto__","p__37084__auto__",1389168618,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs$core$macros$emit.call(null,pred__$1,expr__$1,more);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));

}
}
}
});})(gpred,gexpr))
;
var gres = cljs.core.gensym.call(null,"res__");
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = gpred;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = pred;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = gexpr;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = expr;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = emit.call(null,gpred,gexpr,clauses);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros.condp.cljs$lang$maxFixedArity = (4);

cljs.core$macros.condp.cljs$lang$applyTo = (function (seq37085){
var G__37086 = cljs.core.first.call(null,seq37085);
var seq37085__$1 = cljs.core.next.call(null,seq37085);
var G__37087 = cljs.core.first.call(null,seq37085__$1);
var seq37085__$2 = cljs.core.next.call(null,seq37085__$1);
var G__37088 = cljs.core.first.call(null,seq37085__$2);
var seq37085__$3 = cljs.core.next.call(null,seq37085__$2);
var G__37089 = cljs.core.first.call(null,seq37085__$3);
var seq37085__$4 = cljs.core.next.call(null,seq37085__$3);
return cljs.core$macros.condp.cljs$core$IFn$_invoke$arity$variadic(G__37086,G__37087,G__37088,G__37089,seq37085__$4);
});

return null;
})()
;
cljs.core$macros.condp.cljs$lang$macro = true;

cljs.core$macros.assoc_test = (function cljs$core$macros$assoc_test(m,test,expr,env){
if(cljs.core.contains_QMARK_.call(null,m,test)){
throw (new Error(["Duplicate case test constant '",cljs.core.str.cljs$core$IFn$_invoke$arity$1(test),"'",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env))?[" on line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env))," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.analyzer._STAR_cljs_file_STAR_)].join(''):null))].join('')));
} else {
return cljs.core.assoc.call(null,m,test,expr);
}
});
cljs.core$macros.const_QMARK_ = (function cljs$core$macros$const_QMARK_(env,x){
var m = (function (){var and__8174__auto__ = cljs.core.list_QMARK_.call(null,x);
if(and__8174__auto__){
return cljs.analyzer.resolve_var.call(null,env,cljs.core.last.call(null,x));
} else {
return and__8174__auto__;
}
})();
if(cljs.core.truth_(m)){
return cljs.core.get.call(null,m,new cljs.core.Keyword(null,"const","const",1709929842));
} else {
return null;
}
});
var ret__9397__auto___37120 = (function (){
/**
 * Takes an expression, and a set of clauses.
 * 
 *   Each clause can take the form of either:
 * 
 *   test-constant result-expr
 * 
 *   (test-constant1 ... test-constantN)  result-expr
 * 
 *   The test-constants are not evaluated. They must be compile-time
 *   literals, and need not be quoted.  If the expression is equal to a
 *   test-constant, the corresponding result-expr is returned. A single
 *   default expression can follow the clauses, and its value will be
 *   returned if no clause matches. If no default expression is provided
 *   and no clause matches, an Error is thrown.
 * 
 *   Unlike cond and condp, case does a constant-time dispatch, the
 *   clauses are not considered sequentially.  All manner of constant
 *   expressions are acceptable in case, including numbers, strings,
 *   symbols, keywords, and (ClojureScript) composites thereof. Note that since
 *   lists are used to group multiple constants that map to the same
 *   expression, a vector can be used to match a list if needed. The
 *   test-constants need not be all of the same type.
 */
cljs.core$macros.case$ = (function cljs$core$macros$case(var_args){
var args__9364__auto__ = [];
var len__9357__auto___37121 = arguments.length;
var i__9358__auto___37122 = (0);
while(true){
if((i__9358__auto___37122 < len__9357__auto___37121)){
args__9364__auto__.push((arguments[i__9358__auto___37122]));

var G__37123 = (i__9358__auto___37122 + (1));
i__9358__auto___37122 = G__37123;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((3) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.case$.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9365__auto__);
});

cljs.core$macros.case$.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,e,clauses){
var esym = cljs.core.gensym.call(null);
var default$ = ((cljs.core.odd_QMARK_.call(null,cljs.core.count.call(null,clauses)))?cljs.core.last.call(null,clauses):cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"throw","throw",595905694,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("js","Error.","js/Error.",750655924,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","str","cljs.core/str",-1971828991,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,"No matching clause: "),(function (){var x__9048__auto__ = esym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
var env = _AMPERSAND_env;
var pairs = cljs.core.reduce.call(null,((function (esym,default$,env){
return (function (m,p__37108){
var vec__37109 = p__37108;
var test = cljs.core.nth.call(null,vec__37109,(0),null);
var expr = cljs.core.nth.call(null,vec__37109,(1),null);
if(cljs.core.seq_QMARK_.call(null,test)){
return cljs.core.reduce.call(null,((function (vec__37109,test,expr,esym,default$,env){
return (function (m__$1,test__$1){
var test__$2 = (((test__$1 instanceof cljs.core.Symbol))?cljs.core._conj.call(null,(function (){var x__9048__auto__ = test__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),new cljs.core.Symbol(null,"quote","quote",1377916282,null)):test__$1);
return cljs.core$macros.assoc_test.call(null,m__$1,test__$2,expr,env);
});})(vec__37109,test,expr,esym,default$,env))
,m,test);
} else {
if((test instanceof cljs.core.Symbol)){
return cljs.core$macros.assoc_test.call(null,m,cljs.core._conj.call(null,(function (){var x__9048__auto__ = test;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),new cljs.core.Symbol(null,"quote","quote",1377916282,null)),expr,env);
} else {
return cljs.core$macros.assoc_test.call(null,m,test,expr,env);

}
}
});})(esym,default$,env))
,cljs.core.PersistentArrayMap.EMPTY,cljs.core.partition.call(null,(2),clauses));
var tests = cljs.core.keys.call(null,pairs);
if(cljs.core.every_QMARK_.call(null,cljs.core.some_fn.call(null,cljs.core.number_QMARK_,cljs.core.string_QMARK_,cljs.core.fnil.call(null,cljs.core.char_QMARK_,new cljs.core.Keyword(null,"nonchar","nonchar",-421759703)),((function (esym,default$,env,pairs,tests){
return (function (p1__37100_SHARP_){
return cljs.core$macros.const_QMARK_.call(null,env,p1__37100_SHARP_);
});})(esym,default$,env,pairs,tests))
),tests)){
var no_default = ((cljs.core.odd_QMARK_.call(null,cljs.core.count.call(null,clauses)))?cljs.core.butlast.call(null,clauses):clauses);
var tests__$1 = cljs.core.mapv.call(null,((function (no_default,esym,default$,env,pairs,tests){
return (function (p1__37101_SHARP_){
if(cljs.core.seq_QMARK_.call(null,p1__37101_SHARP_)){
return cljs.core.vec.call(null,p1__37101_SHARP_);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__37101_SHARP_], null);
}
});})(no_default,esym,default$,env,pairs,tests))
,cljs.core.take_nth.call(null,(2),no_default));
var thens = cljs.core.vec.call(null,cljs.core.take_nth.call(null,(2),cljs.core.drop.call(null,(1),no_default)));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = esym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = e;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"case*","case*",-1938255072,null)),(function (){var x__9048__auto__ = esym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = tests__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = thens;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = default$;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
} else {
if(cljs.core.every_QMARK_.call(null,cljs.core.keyword_QMARK_,tests)){
var no_default = ((cljs.core.odd_QMARK_.call(null,cljs.core.count.call(null,clauses)))?cljs.core.butlast.call(null,clauses):clauses);
var kw_str = ((function (no_default,esym,default$,env,pairs,tests){
return (function (p1__37102_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__37102_SHARP_)].join('').substring((1));
});})(no_default,esym,default$,env,pairs,tests))
;
var tests__$1 = cljs.core.mapv.call(null,((function (no_default,kw_str,esym,default$,env,pairs,tests){
return (function (p1__37103_SHARP_){
if(cljs.core.seq_QMARK_.call(null,p1__37103_SHARP_)){
return cljs.core.mapv.call(null,kw_str,p1__37103_SHARP_);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [kw_str.call(null,p1__37103_SHARP_)], null);
}
});})(no_default,kw_str,esym,default$,env,pairs,tests))
,cljs.core.take_nth.call(null,(2),no_default));
var thens = cljs.core.vec.call(null,cljs.core.take_nth.call(null,(2),cljs.core.drop.call(null,(1),no_default)));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = esym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = e;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = esym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","keyword?","cljs.core$macros/keyword?",1362730141,null)),(function (){var x__9048__auto__ = esym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".-fqn",".-fqn",1246113027,null)),(function (){var x__9048__auto__ = esym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"case*","case*",-1938255072,null)),(function (){var x__9048__auto__ = esym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = tests__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = thens;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = default$;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
} else {
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = esym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = e;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","cond","cljs.core$macros/cond",1626318471,null)),cljs.core.mapcat.call(null,((function (esym,default$,env,pairs,tests){
return (function (p__37116){
var vec__37117 = p__37116;
var m = cljs.core.nth.call(null,vec__37117,(0),null);
var c = cljs.core.nth.call(null,vec__37117,(1),null);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","=","cljs.core/=",-1891498332,null)),(function (){var x__9048__auto__ = m;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = esym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = c;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});})(esym,default$,env,pairs,tests))
,pairs),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"else","else",-1508377146)),(function (){var x__9048__auto__ = default$;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));

}
}
});

cljs.core$macros.case$.cljs$lang$maxFixedArity = (3);

cljs.core$macros.case$.cljs$lang$applyTo = (function (seq37104){
var G__37105 = cljs.core.first.call(null,seq37104);
var seq37104__$1 = cljs.core.next.call(null,seq37104);
var G__37106 = cljs.core.first.call(null,seq37104__$1);
var seq37104__$2 = cljs.core.next.call(null,seq37104__$1);
var G__37107 = cljs.core.first.call(null,seq37104__$2);
var seq37104__$3 = cljs.core.next.call(null,seq37104__$2);
return cljs.core$macros.case$.cljs$core$IFn$_invoke$arity$variadic(G__37105,G__37106,G__37107,seq37104__$3);
});

return null;
})()
;
cljs.core$macros.case$.cljs$lang$macro = true;

var ret__9397__auto___37124 = cljs.core$macros.when_assert = (function cljs$core$macros$when_assert(_AMPERSAND_form,_AMPERSAND_env,x){
if(cljs.core._STAR_assert_STAR_){
return x;
} else {
return null;
}
});
cljs.core$macros.when_assert.cljs$lang$macro = true;

var ret__9397__auto___37127 = (function (){
/**
 * Evaluates expr and throws an exception if it does not evaluate to
 *   logical true.
 */
cljs.core$macros.assert = (function cljs$core$macros$assert(var_args){
var G__37126 = arguments.length;
switch (G__37126) {
case 3:
return cljs.core$macros.assert.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core$macros.assert.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (2)))].join('')));

}
});

cljs.core$macros.assert.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,x){
if(cljs.core._STAR_assert_STAR_){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","when-not","cljs.core$macros/when-not",-764302244,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"throw","throw",595905694,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("js","Error.","js/Error.",750655924,null)),(function (){var x__9048__auto__ = ["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,x))].join('');
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
} else {
return null;
}
});

cljs.core$macros.assert.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,x,message){
if(cljs.core._STAR_assert_STAR_){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","when-not","cljs.core$macros/when-not",-764302244,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"throw","throw",595905694,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("js","Error.","js/Error.",750655924,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","str","cljs.core/str",-1971828991,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,"Assert failed: "),(function (){var x__9048__auto__ = message;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,"\n"),(function (){var x__9048__auto__ = cljs.core.pr_str.call(null,x);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
} else {
return null;
}
});

cljs.core$macros.assert.cljs$lang$maxFixedArity = 4;

return null;
})()
;
cljs.core$macros.assert.cljs$lang$macro = true;

var ret__9397__auto___37165 = /**
 * List comprehension. Takes a vector of one or more
 * binding-form/collection-expr pairs, each followed by zero or more
 * modifiers, and yields a lazy sequence of evaluations of expr.
 * Collections are iterated in a nested fashion, rightmost fastest,
 * and nested coll-exprs can refer to bindings created in prior
 * binding-forms.  Supported modifiers are: :let [binding-form expr ...],
 * :while test, :when test.
 * 
 *   (take 100 (for [x (range 100000000) y (range 1000000) :while (< y x)]  [x y]))
 */
cljs.core$macros.for$ = (function cljs$core$macros$for(_AMPERSAND_form,_AMPERSAND_env,seq_exprs,body_expr){
if(cljs.core.vector_QMARK_.call(null,seq_exprs)){
} else {
throw cljs.core.ex_info.call(null,"for requires a vector for its binding",cljs.core.PersistentArrayMap.EMPTY);
}

if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,seq_exprs))){
} else {
throw cljs.core.ex_info.call(null,"for requires an even number of forms in binding vector",cljs.core.PersistentArrayMap.EMPTY);
}


var to_groups = (function (seq_exprs__$1){
return cljs.core.reduce.call(null,(function (groups,p__37134){
var vec__37135 = p__37134;
var k = cljs.core.nth.call(null,vec__37135,(0),null);
var v = cljs.core.nth.call(null,vec__37135,(1),null);
if((k instanceof cljs.core.Keyword)){
return cljs.core.conj.call(null,cljs.core.pop.call(null,groups),cljs.core.conj.call(null,cljs.core.peek.call(null,groups),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null)));
} else {
return cljs.core.conj.call(null,groups,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));
}
}),cljs.core.PersistentVector.EMPTY,cljs.core.partition.call(null,(2),seq_exprs__$1));
});
var err = ((function (to_groups){
return (function() { 
var G__37166__delegate = function (msg){
throw cljs.core.ex_info.call(null,cljs.core.apply.call(null,cljs.core.str,msg),cljs.core.PersistentArrayMap.EMPTY);
};
var G__37166 = function (var_args){
var msg = null;
if (arguments.length > 0) {
var G__37167__i = 0, G__37167__a = new Array(arguments.length -  0);
while (G__37167__i < G__37167__a.length) {G__37167__a[G__37167__i] = arguments[G__37167__i + 0]; ++G__37167__i;}
  msg = new cljs.core.IndexedSeq(G__37167__a,0,null);
} 
return G__37166__delegate.call(this,msg);};
G__37166.cljs$lang$maxFixedArity = 0;
G__37166.cljs$lang$applyTo = (function (arglist__37168){
var msg = cljs.core.seq(arglist__37168);
return G__37166__delegate(msg);
});
G__37166.cljs$core$IFn$_invoke$arity$variadic = G__37166__delegate;
return G__37166;
})()
;})(to_groups))
;
var emit_bind = ((function (to_groups,err){
return (function cljs$core$macros$for_$_emit_bind(p__37138){
var vec__37139 = p__37138;
var seq__37140 = cljs.core.seq.call(null,vec__37139);
var first__37141 = cljs.core.first.call(null,seq__37140);
var seq__37140__$1 = cljs.core.next.call(null,seq__37140);
var vec__37142 = first__37141;
var seq__37143 = cljs.core.seq.call(null,vec__37142);
var first__37144 = cljs.core.first.call(null,seq__37143);
var seq__37143__$1 = cljs.core.next.call(null,seq__37143);
var bind = first__37144;
var first__37144__$1 = cljs.core.first.call(null,seq__37143__$1);
var seq__37143__$2 = cljs.core.next.call(null,seq__37143__$1);
var expr = first__37144__$1;
var mod_pairs = seq__37143__$2;
var vec__37145 = seq__37140__$1;
var vec__37148 = cljs.core.nth.call(null,vec__37145,(0),null);
var _ = cljs.core.nth.call(null,vec__37148,(0),null);
var next_expr = cljs.core.nth.call(null,vec__37148,(1),null);
var next_groups = vec__37145;
var giter = cljs.core.gensym.call(null,"iter__");
var gxs = cljs.core.gensym.call(null,"s__");
var do_mod = ((function (giter,gxs,vec__37139,seq__37140,first__37141,seq__37140__$1,vec__37142,seq__37143,first__37144,seq__37143__$1,bind,first__37144__$1,seq__37143__$2,expr,mod_pairs,vec__37145,vec__37148,_,next_expr,next_groups,to_groups,err){
return (function cljs$core$macros$for_$_emit_bind_$_do_mod(p__37151){
var vec__37152 = p__37151;
var seq__37153 = cljs.core.seq.call(null,vec__37152);
var first__37154 = cljs.core.first.call(null,seq__37153);
var seq__37153__$1 = cljs.core.next.call(null,seq__37153);
var vec__37155 = first__37154;
var k = cljs.core.nth.call(null,vec__37155,(0),null);
var v = cljs.core.nth.call(null,vec__37155,(1),null);
var pair = vec__37155;
var etc = seq__37153__$1;
if(cljs.core._EQ_.call(null,k,new cljs.core.Keyword(null,"let","let",-1282412701))){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = v;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs$core$macros$for_$_emit_bind_$_do_mod.call(null,etc);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
} else {
if(cljs.core._EQ_.call(null,k,new cljs.core.Keyword(null,"while","while",963117786))){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","when","cljs.core$macros/when",328457725,null)),(function (){var x__9048__auto__ = v;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs$core$macros$for_$_emit_bind_$_do_mod.call(null,etc);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
} else {
if(cljs.core._EQ_.call(null,k,new cljs.core.Keyword(null,"when","when",-576417306))){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__9048__auto__ = v;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs$core$macros$for_$_emit_bind_$_do_mod.call(null,etc);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"recur","recur",1202958259,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","rest","cljs.core/rest",-285075455,null)),(function (){var x__9048__auto__ = gxs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
} else {
if((k instanceof cljs.core.Keyword)){
return err.call(null,"Invalid 'for' keyword ",k);
} else {
if(next_groups){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"iterys__37129__auto__","iterys__37129__auto__",405942488,null)),(function (){var x__9048__auto__ = cljs$core$macros$for_$_emit_bind.call(null,next_groups);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"fs__37130__auto__","fs__37130__auto__",321079645,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","seq","cljs.core/seq",-1649497689,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"iterys__37129__auto__","iterys__37129__auto__",405942488,null)),(function (){var x__9048__auto__ = next_expr;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"fs__37130__auto__","fs__37130__auto__",321079645,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","concat","cljs.core/concat",-1133584918,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"fs__37130__auto__","fs__37130__auto__",321079645,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = giter;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","rest","cljs.core/rest",-285075455,null)),(function (){var x__9048__auto__ = gxs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"recur","recur",1202958259,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","rest","cljs.core/rest",-285075455,null)),(function (){var x__9048__auto__ = gxs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
} else {
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","cons","cljs.core/cons",96507417,null)),(function (){var x__9048__auto__ = body_expr;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = giter;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","rest","cljs.core/rest",-285075455,null)),(function (){var x__9048__auto__ = gxs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));

}
}
}
}
}
});})(giter,gxs,vec__37139,seq__37140,first__37141,seq__37140__$1,vec__37142,seq__37143,first__37144,seq__37143__$1,bind,first__37144__$1,seq__37143__$2,expr,mod_pairs,vec__37145,vec__37148,_,next_expr,next_groups,to_groups,err))
;
if(next_groups){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__9048__auto__ = giter;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = gxs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","lazy-seq","cljs.core$macros/lazy-seq",806482650,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","loop","cljs.core$macros/loop",1731108390,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = gxs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = gxs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","when-first","cljs.core$macros/when-first",-840670160,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = bind;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = gxs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = do_mod.call(null,mod_pairs);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
} else {
var gi = cljs.core.gensym.call(null,"i__");
var gb = cljs.core.gensym.call(null,"b__");
var do_cmod = ((function (gi,gb,giter,gxs,do_mod,vec__37139,seq__37140,first__37141,seq__37140__$1,vec__37142,seq__37143,first__37144,seq__37143__$1,bind,first__37144__$1,seq__37143__$2,expr,mod_pairs,vec__37145,vec__37148,_,next_expr,next_groups,to_groups,err){
return (function cljs$core$macros$for_$_emit_bind_$_do_cmod(p__37158){
var vec__37159 = p__37158;
var seq__37160 = cljs.core.seq.call(null,vec__37159);
var first__37161 = cljs.core.first.call(null,seq__37160);
var seq__37160__$1 = cljs.core.next.call(null,seq__37160);
var vec__37162 = first__37161;
var k = cljs.core.nth.call(null,vec__37162,(0),null);
var v = cljs.core.nth.call(null,vec__37162,(1),null);
var pair = vec__37162;
var etc = seq__37160__$1;
if(cljs.core._EQ_.call(null,k,new cljs.core.Keyword(null,"let","let",-1282412701))){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = v;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs$core$macros$for_$_emit_bind_$_do_cmod.call(null,etc);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
} else {
if(cljs.core._EQ_.call(null,k,new cljs.core.Keyword(null,"while","while",963117786))){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","when","cljs.core$macros/when",328457725,null)),(function (){var x__9048__auto__ = v;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs$core$macros$for_$_emit_bind_$_do_cmod.call(null,etc);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
} else {
if(cljs.core._EQ_.call(null,k,new cljs.core.Keyword(null,"when","when",-576417306))){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__9048__auto__ = v;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs$core$macros$for_$_emit_bind_$_do_cmod.call(null,etc);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"recur","recur",1202958259,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","unchecked-inc","cljs.core$macros/unchecked-inc",-1615365330,null)),(function (){var x__9048__auto__ = gi;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
} else {
if((k instanceof cljs.core.Keyword)){
return err.call(null,"Invalid 'for' keyword ",k);
} else {
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","chunk-append","cljs.core/chunk-append",-243671470,null)),(function (){var x__9048__auto__ = gb;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = body_expr;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"recur","recur",1202958259,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","unchecked-inc","cljs.core$macros/unchecked-inc",-1615365330,null)),(function (){var x__9048__auto__ = gi;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));

}
}
}
}
});})(gi,gb,giter,gxs,do_mod,vec__37139,seq__37140,first__37141,seq__37140__$1,vec__37142,seq__37143,first__37144,seq__37143__$1,bind,first__37144__$1,seq__37143__$2,expr,mod_pairs,vec__37145,vec__37148,_,next_expr,next_groups,to_groups,err))
;
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__9048__auto__ = giter;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = gxs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","lazy-seq","cljs.core$macros/lazy-seq",806482650,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","loop","cljs.core$macros/loop",1731108390,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = gxs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = gxs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","when-let","cljs.core$macros/when-let",-2004472648,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = gxs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","seq","cljs.core/seq",-1649497689,null)),(function (){var x__9048__auto__ = gxs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","chunked-seq?","cljs.core/chunked-seq?",-712922369,null)),(function (){var x__9048__auto__ = gxs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"c__37131__auto__","c__37131__auto__",571227181,null)),(function (){var x__9048__auto__ = cljs.core.with_meta.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","chunk-first","cljs.core/chunk-first",-1157877305,null)),(function (){var x__9048__auto__ = gxs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))),cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"file","file",-1269645878)),cljs.core._conj.call(null,cljs.core.List.EMPTY,"/Users/exupero/code/grapple/target/cljsbuild/public/js/out/cljs/core.cljc"),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"line","line",212345235)),cljs.core._conj.call(null,cljs.core.List.EMPTY,2383),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"column","column",2078222095)),cljs.core._conj.call(null,cljs.core.List.EMPTY,52),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"end-line","end-line",1837326455)),cljs.core._conj.call(null,cljs.core.List.EMPTY,2383),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"end-column","end-column",1425389514)),cljs.core._conj.call(null,cljs.core.List.EMPTY,82),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"tag","tag",-1290361223)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","not-native","cljs.core/not-native",-1716909265,null)))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"size__37132__auto__","size__37132__auto__",889501886,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"c__37131__auto__","c__37131__auto__",571227181,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = gb;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","chunk-buffer","cljs.core/chunk-buffer",14093626,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"size__37132__auto__","size__37132__auto__",889501886,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","coercive-boolean","cljs.core$macros/coercive-boolean",-450758280,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","loop","cljs.core$macros/loop",1731108390,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = gi;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,(0))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","<","cljs.core$macros/<",371512596,null)),(function (){var x__9048__auto__ = gi;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"size__37132__auto__","size__37132__auto__",889501886,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = bind;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","-nth","cljs.core/-nth",504234802,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"c__37131__auto__","c__37131__auto__",571227181,null)),(function (){var x__9048__auto__ = gi;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = do_cmod.call(null,mod_pairs);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,true))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","chunk-cons","cljs.core/chunk-cons",-250075688,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","chunk","cljs.core/chunk",847936424,null)),(function (){var x__9048__auto__ = gb;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = giter;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","chunk-rest","cljs.core/chunk-rest",-398161143,null)),(function (){var x__9048__auto__ = gxs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","chunk-cons","cljs.core/chunk-cons",-250075688,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","chunk","cljs.core/chunk",847936424,null)),(function (){var x__9048__auto__ = gb;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = bind;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","first","cljs.core/first",-752535972,null)),(function (){var x__9048__auto__ = gxs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = do_mod.call(null,mod_pairs);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
}
});})(to_groups,err))
;
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"iter__37133__auto__","iter__37133__auto__",-917332396,null)),(function (){var x__9048__auto__ = emit_bind.call(null,to_groups.call(null,seq_exprs));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"iter__37133__auto__","iter__37133__auto__",-917332396,null)),(function (){var x__9048__auto__ = cljs.core.second.call(null,seq_exprs);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});
cljs.core$macros.for$.cljs$lang$macro = true;

var ret__9397__auto___37174 = (function (){
/**
 * Repeatedly executes body (presumably for side-effects) with
 *   bindings and filtering as provided by "for".  Does not retain
 *   the head of the sequence. Returns nil.
 */
cljs.core$macros.doseq = (function cljs$core$macros$doseq(var_args){
var args__9364__auto__ = [];
var len__9357__auto___37175 = arguments.length;
var i__9358__auto___37176 = (0);
while(true){
if((i__9358__auto___37176 < len__9357__auto___37175)){
args__9364__auto__.push((arguments[i__9358__auto___37176]));

var G__37177 = (i__9358__auto___37176 + (1));
i__9358__auto___37176 = G__37177;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((3) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.doseq.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9365__auto__);
});

cljs.core$macros.doseq.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,seq_exprs,body){
if(cljs.core.vector_QMARK_.call(null,seq_exprs)){
} else {
throw cljs.core.ex_info.call(null,"doseq requires a vector for its binding",cljs.core.PersistentArrayMap.EMPTY);
}

if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,seq_exprs))){
} else {
throw cljs.core.ex_info.call(null,"doseq requires an even number of forms in binding vector",cljs.core.PersistentArrayMap.EMPTY);
}


var err = (function() { 
var G__37178__delegate = function (msg){
throw cljs.core.ex_info.call(null,cljs.core.apply.call(null,cljs.core.str,msg),cljs.core.PersistentArrayMap.EMPTY);
};
var G__37178 = function (var_args){
var msg = null;
if (arguments.length > 0) {
var G__37179__i = 0, G__37179__a = new Array(arguments.length -  0);
while (G__37179__i < G__37179__a.length) {G__37179__a[G__37179__i] = arguments[G__37179__i + 0]; ++G__37179__i;}
  msg = new cljs.core.IndexedSeq(G__37179__a,0,null);
} 
return G__37178__delegate.call(this,msg);};
G__37178.cljs$lang$maxFixedArity = 0;
G__37178.cljs$lang$applyTo = (function (arglist__37180){
var msg = cljs.core.seq(arglist__37180);
return G__37178__delegate(msg);
});
G__37178.cljs$core$IFn$_invoke$arity$variadic = G__37178__delegate;
return G__37178;
})()
;
var step = ((function (err){
return (function cljs$core$macros$step(recform,exprs){
if(cljs.core.not.call(null,exprs)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),body)))], null);
} else {
var k = cljs.core.first.call(null,exprs);
var v = cljs.core.second.call(null,exprs);
var seqsym = cljs.core.gensym.call(null,"seq__");
var recform__$1 = (((k instanceof cljs.core.Keyword))?recform:cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"recur","recur",1202958259,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","next","cljs.core/next",-1291438473,null)),(function (){var x__9048__auto__ = seqsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null),cljs.core._conj.call(null,cljs.core.List.EMPTY,(0)),cljs.core._conj.call(null,cljs.core.List.EMPTY,(0))))));
var steppair = cljs$core$macros$step.call(null,recform__$1,cljs.core.nnext.call(null,exprs));
var needrec = steppair.call(null,(0));
var subform = steppair.call(null,(1));
if(cljs.core._EQ_.call(null,k,new cljs.core.Keyword(null,"let","let",-1282412701))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [needrec,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = v;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = subform;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())))], null);
} else {
if(cljs.core._EQ_.call(null,k,new cljs.core.Keyword(null,"while","while",963117786))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","when","cljs.core$macros/when",328457725,null)),(function (){var x__9048__auto__ = v;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = subform;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(cljs.core.truth_(needrec)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [recform__$1], null):null))))], null);
} else {
if(cljs.core._EQ_.call(null,k,new cljs.core.Keyword(null,"when","when",-576417306))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__9048__auto__ = v;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),(function (){var x__9048__auto__ = subform;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(cljs.core.truth_(needrec)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [recform__$1], null):null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = recform__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())))], null);
} else {
if((k instanceof cljs.core.Keyword)){
return err.call(null,"Invalid 'doseq' keyword",k);
} else {
var chunksym = cljs.core.with_meta.call(null,cljs.core.gensym.call(null,"chunk__"),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"not-native","not-native",-236392494,null)], null));
var countsym = cljs.core.gensym.call(null,"count__");
var isym = cljs.core.gensym.call(null,"i__");
var recform_chunk = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"recur","recur",1202958259,null)),(function (){var x__9048__auto__ = seqsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = chunksym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = countsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","unchecked-inc","cljs.core$macros/unchecked-inc",-1615365330,null)),(function (){var x__9048__auto__ = isym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
var steppair_chunk = cljs$core$macros$step.call(null,recform_chunk,cljs.core.nnext.call(null,exprs));
var subform_chunk = steppair_chunk.call(null,(1));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","loop","cljs.core$macros/loop",1731108390,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = seqsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","seq","cljs.core/seq",-1649497689,null)),(function (){var x__9048__auto__ = v;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = chunksym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null),(function (){var x__9048__auto__ = countsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,(0)),(function (){var x__9048__auto__ = isym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,(0))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","coercive-boolean","cljs.core$macros/coercive-boolean",-450758280,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","<","cljs.core$macros/<",371512596,null)),(function (){var x__9048__auto__ = isym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = countsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = k;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","-nth","cljs.core/-nth",504234802,null)),(function (){var x__9048__auto__ = chunksym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = isym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = subform_chunk;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(cljs.core.truth_(needrec)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [recform_chunk], null):null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","when-let","cljs.core$macros/when-let",-2004472648,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = seqsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","seq","cljs.core/seq",-1649497689,null)),(function (){var x__9048__auto__ = seqsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","chunked-seq?","cljs.core/chunked-seq?",-712922369,null)),(function (){var x__9048__auto__ = seqsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"c__37169__auto__","c__37169__auto__",317431039,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","chunk-first","cljs.core/chunk-first",-1157877305,null)),(function (){var x__9048__auto__ = seqsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"recur","recur",1202958259,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","chunk-rest","cljs.core/chunk-rest",-398161143,null)),(function (){var x__9048__auto__ = seqsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"c__37169__auto__","c__37169__auto__",317431039,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"c__37169__auto__","c__37169__auto__",317431039,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,(0)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = k;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","first","cljs.core/first",-752535972,null)),(function (){var x__9048__auto__ = seqsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = subform;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(cljs.core.truth_(needrec)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [recform__$1], null):null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())))], null);

}
}
}
}
}
});})(err))
;
return cljs.core.nth.call(null,step.call(null,null,cljs.core.seq.call(null,seq_exprs)),(1));
});

cljs.core$macros.doseq.cljs$lang$maxFixedArity = (3);

cljs.core$macros.doseq.cljs$lang$applyTo = (function (seq37170){
var G__37171 = cljs.core.first.call(null,seq37170);
var seq37170__$1 = cljs.core.next.call(null,seq37170);
var G__37172 = cljs.core.first.call(null,seq37170__$1);
var seq37170__$2 = cljs.core.next.call(null,seq37170__$1);
var G__37173 = cljs.core.first.call(null,seq37170__$2);
var seq37170__$3 = cljs.core.next.call(null,seq37170__$2);
return cljs.core$macros.doseq.cljs$core$IFn$_invoke$arity$variadic(G__37171,G__37172,G__37173,seq37170__$3);
});

return null;
})()
;
cljs.core$macros.doseq.cljs$lang$macro = true;

var ret__9397__auto___37184 = (function (){
cljs.core$macros.array = (function cljs$core$macros$array(var_args){
var args__9364__auto__ = [];
var len__9357__auto___37185 = arguments.length;
var i__9358__auto___37186 = (0);
while(true){
if((i__9358__auto___37186 < len__9357__auto___37185)){
args__9364__auto__.push((arguments[i__9358__auto___37186]));

var G__37187 = (i__9358__auto___37186 + (1));
i__9358__auto___37186 = G__37187;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((2) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.array.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9365__auto__);
});

cljs.core$macros.array.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,rest){
var xs_str = cljs.core.apply.call(null,cljs.core.str,cljs.core.interpose.call(null,",",cljs.core.take.call(null,cljs.core.count.call(null,rest),cljs.core.repeat.call(null,"~{}"))));
return cljs.core.vary_meta.call(null,cljs.core.list_STAR_.call(null,new cljs.core.Symbol(null,"js*","js*",-1134233646,null),["[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(xs_str),"]"].join(''),rest),cljs.core.assoc,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"array","array",-440182315,null));
});

cljs.core$macros.array.cljs$lang$maxFixedArity = (2);

cljs.core$macros.array.cljs$lang$applyTo = (function (seq37181){
var G__37182 = cljs.core.first.call(null,seq37181);
var seq37181__$1 = cljs.core.next.call(null,seq37181);
var G__37183 = cljs.core.first.call(null,seq37181__$1);
var seq37181__$2 = cljs.core.next.call(null,seq37181__$1);
return cljs.core$macros.array.cljs$core$IFn$_invoke$arity$variadic(G__37182,G__37183,seq37181__$2);
});

return null;
})()
;
cljs.core$macros.array.cljs$lang$macro = true;

var ret__9397__auto___37198 = (function (){
cljs.core$macros.make_array = (function cljs$core$macros$make_array(var_args){
var G__37197 = arguments.length;
switch (G__37197) {
case 3:
return cljs.core$macros.make_array.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core$macros.make_array.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__9376__auto__ = [];
var len__9357__auto___37200 = arguments.length;
var i__9358__auto___37201 = (0);
while(true){
if((i__9358__auto___37201 < len__9357__auto___37200)){
args_arr__9376__auto__.push((arguments[i__9358__auto___37201]));

var G__37202 = (i__9358__auto___37201 + (1));
i__9358__auto___37201 = G__37202;
continue;
} else {
}
break;
}

var argseq__9377__auto__ = (new cljs.core.IndexedSeq(args_arr__9376__auto__.slice((4)),(0),null));
return cljs.core$macros.make_array.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__9377__auto__);

}
});

cljs.core$macros.make_array.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,size){
return cljs.core.vary_meta.call(null,((typeof size === 'number')?cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","array","cljs.core$macros/array",49650437,null)),cljs.core.take.call(null,size,cljs.core.repeat.call(null,null))))):cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("js","Array.","js/Array.",1235645307,null)),(function (){var x__9048__auto__ = size;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())))),cljs.core.assoc,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"array","array",-440182315,null));
});

cljs.core$macros.make_array.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,type,size){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","make-array","cljs.core/make-array",-1802166799,null)),(function (){var x__9048__auto__ = size;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros.make_array.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,type,size,more_sizes){
return cljs.core.vary_meta.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"dims__37188__auto__","dims__37188__auto__",1956806621,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","list","cljs.core$macros/list",-1408486806,null)),more_sizes)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"dimarray__37189__auto__","dimarray__37189__auto__",835633922,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","make-array","cljs.core/make-array",-1802166799,null)),(function (){var x__9048__auto__ = size;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","dotimes","cljs.core$macros/dotimes",-1407597661,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"i__37190__auto__","i__37190__auto__",-1051077059,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","alength","cljs.core$macros/alength",-683052937,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"dimarray__37189__auto__","dimarray__37189__auto__",835633922,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","aset","cljs.core$macros/aset",-693176374,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"dimarray__37189__auto__","dimarray__37189__auto__",835633922,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"i__37190__auto__","i__37190__auto__",-1051077059,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","apply","cljs.core/apply",1757277831,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","make-array","cljs.core/make-array",-1802166799,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,null),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"dims__37188__auto__","dims__37188__auto__",1956806621,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"dimarray__37189__auto__","dimarray__37189__auto__",835633922,null))))),cljs.core.assoc,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"array","array",-440182315,null));
});

cljs.core$macros.make_array.cljs$lang$applyTo = (function (seq37192){
var G__37193 = cljs.core.first.call(null,seq37192);
var seq37192__$1 = cljs.core.next.call(null,seq37192);
var G__37194 = cljs.core.first.call(null,seq37192__$1);
var seq37192__$2 = cljs.core.next.call(null,seq37192__$1);
var G__37195 = cljs.core.first.call(null,seq37192__$2);
var seq37192__$3 = cljs.core.next.call(null,seq37192__$2);
var G__37196 = cljs.core.first.call(null,seq37192__$3);
var seq37192__$4 = cljs.core.next.call(null,seq37192__$3);
return cljs.core$macros.make_array.cljs$core$IFn$_invoke$arity$variadic(G__37193,G__37194,G__37195,G__37196,seq37192__$4);
});

cljs.core$macros.make_array.cljs$lang$maxFixedArity = (4);

return null;
})()
;
cljs.core$macros.make_array.cljs$lang$macro = true;

var ret__9397__auto___37211 = (function (){
cljs.core$macros.list = (function cljs$core$macros$list(var_args){
var G__37209 = arguments.length;
switch (G__37209) {
case 2:
return cljs.core$macros.list.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__9376__auto__ = [];
var len__9357__auto___37213 = arguments.length;
var i__9358__auto___37214 = (0);
while(true){
if((i__9358__auto___37214 < len__9357__auto___37213)){
args_arr__9376__auto__.push((arguments[i__9358__auto___37214]));

var G__37215 = (i__9358__auto___37214 + (1));
i__9358__auto___37214 = G__37215;
continue;
} else {
}
break;
}

var argseq__9377__auto__ = (new cljs.core.IndexedSeq(args_arr__9376__auto__.slice((3)),(0),null));
return cljs.core$macros.list.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9377__auto__);

}
});

cljs.core$macros.list.cljs$core$IFn$_invoke$arity$2 = (function (_AMPERSAND_form,_AMPERSAND_env){
return cljs.core.list(new cljs.core.Symbol(null,".-EMPTY",".-EMPTY",-471586691,null),new cljs.core.Symbol("cljs.core","List","cljs.core/List",1708954352,null));
});

cljs.core$macros.list.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,xs){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"constant","constant",-379609303),new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1((function (){var _STAR_cljs_warnings_STAR_37210 = cljs.analyzer._STAR_cljs_warnings_STAR_;
cljs.analyzer._STAR_cljs_warnings_STAR_ = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"invoke-ctor","invoke-ctor",-756052704),new cljs.core.Keyword(null,"extending-base-js-type","extending-base-js-type",432787264),new cljs.core.Keyword(null,"unsupported-preprocess-value","unsupported-preprocess-value",1635147105),new cljs.core.Keyword(null,"redef","redef",1032704258),new cljs.core.Keyword(null,"js-shadowed-by-local","js-shadowed-by-local",198048291),new cljs.core.Keyword(null,"unsupported-js-module-type","unsupported-js-module-type",1806206180),new cljs.core.Keyword(null,"invalid-protocol-symbol","invalid-protocol-symbol",86246948),new cljs.core.Keyword(null,"protocol-duped-method","protocol-duped-method",15128166),new cljs.core.Keyword(null,"munged-namespace","munged-namespace",-101986199),new cljs.core.Keyword(null,"single-segment-namespace","single-segment-namespace",-491924469),new cljs.core.Keyword(null,"fn-arity","fn-arity",-403576501),new cljs.core.Keyword(null,"infer-warning","infer-warning",-1600671410),new cljs.core.Keyword(null,"variadic-max-arity","variadic-max-arity",-14288402),new cljs.core.Keyword(null,"protocol-with-variadic-method","protocol-with-variadic-method",-693368178),new cljs.core.Keyword(null,"fn-deprecated","fn-deprecated",626877647),new cljs.core.Keyword(null,"undeclared-var","undeclared-var",-1624364944),new cljs.core.Keyword(null,"preamble-missing","preamble-missing",220974801),new cljs.core.Keyword(null,"undeclared-protocol-symbol","undeclared-protocol-symbol",462882867),new cljs.core.Keyword(null,"dynamic","dynamic",704819571),new cljs.core.Keyword(null,"invalid-array-access","invalid-array-access",-1747132236),new cljs.core.Keyword(null,"unprovided","unprovided",-652330764),new cljs.core.Keyword(null,"ns-var-clash","ns-var-clash",-280494668),new cljs.core.Keyword(null,"undeclared-ns","undeclared-ns",-1589012812),new cljs.core.Keyword(null,"undeclared-ns-form","undeclared-ns-form",-248024137),new cljs.core.Keyword(null,"invalid-arithmetic","invalid-arithmetic",1917075065),new cljs.core.Keyword(null,"protocol-deprecated","protocol-deprecated",103233497),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"protocol-impl-recur-with-target","protocol-impl-recur-with-target",-1648321574),new cljs.core.Keyword(null,"overload-arity","overload-arity",823206044),new cljs.core.Keyword(null,"protocol-multiple-impls","protocol-multiple-impls",794179260),new cljs.core.Keyword(null,"redef-in-file","redef-in-file",-476530788),new cljs.core.Keyword(null,"protocol-invalid-method","protocol-invalid-method",522647516),new cljs.core.Keyword(null,"extend-type-invalid-method-shape","extend-type-invalid-method-shape",1424103549),new cljs.core.Keyword(null,"multiple-variadic-overloads","multiple-variadic-overloads",1110059837),new cljs.core.Keyword(null,"protocol-impl-with-variadic-method","protocol-impl-with-variadic-method",-319321217)],[false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false]);

try{return cljs.analyzer.analyze.call(null,_AMPERSAND_env,x);
}finally {cljs.analyzer._STAR_cljs_warnings_STAR_ = _STAR_cljs_warnings_STAR_37210;
}})()))){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","-conj","cljs.core/-conj",2040622670,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","list","cljs.core$macros/list",-1408486806,null)),xs)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
} else {
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"x__37203__auto__","x__37203__auto__",-845845542,null)),(function (){var x__9048__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","-conj","cljs.core/-conj",2040622670,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","list","cljs.core$macros/list",-1408486806,null)),xs)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"x__37203__auto__","x__37203__auto__",-845845542,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
}
});

cljs.core$macros.list.cljs$lang$applyTo = (function (seq37205){
var G__37206 = cljs.core.first.call(null,seq37205);
var seq37205__$1 = cljs.core.next.call(null,seq37205);
var G__37207 = cljs.core.first.call(null,seq37205__$1);
var seq37205__$2 = cljs.core.next.call(null,seq37205__$1);
var G__37208 = cljs.core.first.call(null,seq37205__$2);
var seq37205__$3 = cljs.core.next.call(null,seq37205__$2);
return cljs.core$macros.list.cljs$core$IFn$_invoke$arity$variadic(G__37206,G__37207,G__37208,seq37205__$3);
});

cljs.core$macros.list.cljs$lang$maxFixedArity = (3);

return null;
})()
;
cljs.core$macros.list.cljs$lang$macro = true;

var ret__9397__auto___37221 = (function (){
cljs.core$macros.vector = (function cljs$core$macros$vector(var_args){
var G__37220 = arguments.length;
switch (G__37220) {
case 2:
return cljs.core$macros.vector.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__9376__auto__ = [];
var len__9357__auto___37223 = arguments.length;
var i__9358__auto___37224 = (0);
while(true){
if((i__9358__auto___37224 < len__9357__auto___37223)){
args_arr__9376__auto__.push((arguments[i__9358__auto___37224]));

var G__37225 = (i__9358__auto___37224 + (1));
i__9358__auto___37224 = G__37225;
continue;
} else {
}
break;
}

var argseq__9377__auto__ = (new cljs.core.IndexedSeq(args_arr__9376__auto__.slice((2)),(0),null));
return cljs.core$macros.vector.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9377__auto__);

}
});

cljs.core$macros.vector.cljs$core$IFn$_invoke$arity$2 = (function (_AMPERSAND_form,_AMPERSAND_env){
return cljs.core.list(new cljs.core.Symbol(null,".-EMPTY",".-EMPTY",-471586691,null),new cljs.core.Symbol("cljs.core","PersistentVector","cljs.core/PersistentVector",-1211028272,null));
});

cljs.core$macros.vector.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,xs){
var cnt = cljs.core.count.call(null,xs);
if((cnt < (32))){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","PersistentVector.","cljs.core/PersistentVector.",-1074647876,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,null),(function (){var x__9048__auto__ = cnt;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,(5)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".-EMPTY-NODE",".-EMPTY-NODE",-1333332641,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","PersistentVector","cljs.core/PersistentVector",-1211028272,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","array","cljs.core$macros/array",49650437,null)),xs)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null))));
} else {
return cljs.core.vary_meta.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".fromArray",".fromArray",1053499311,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","PersistentVector","cljs.core/PersistentVector",-1211028272,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","array","cljs.core$macros/array",49650437,null)),xs)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,true)))),cljs.core.assoc,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core","PersistentVector","cljs.core/PersistentVector",-1211028272,null));
}
});

cljs.core$macros.vector.cljs$lang$applyTo = (function (seq37217){
var G__37218 = cljs.core.first.call(null,seq37217);
var seq37217__$1 = cljs.core.next.call(null,seq37217);
var G__37219 = cljs.core.first.call(null,seq37217__$1);
var seq37217__$2 = cljs.core.next.call(null,seq37217__$1);
return cljs.core$macros.vector.cljs$core$IFn$_invoke$arity$variadic(G__37218,G__37219,seq37217__$2);
});

cljs.core$macros.vector.cljs$lang$maxFixedArity = (2);

return null;
})()
;
cljs.core$macros.vector.cljs$lang$macro = true;

var ret__9397__auto___37235 = (function (){
cljs.core$macros.array_map = (function cljs$core$macros$array_map(var_args){
var G__37232 = arguments.length;
switch (G__37232) {
case 2:
return cljs.core$macros.array_map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__9376__auto__ = [];
var len__9357__auto___37237 = arguments.length;
var i__9358__auto___37238 = (0);
while(true){
if((i__9358__auto___37238 < len__9357__auto___37237)){
args_arr__9376__auto__.push((arguments[i__9358__auto___37238]));

var G__37239 = (i__9358__auto___37238 + (1));
i__9358__auto___37238 = G__37239;
continue;
} else {
}
break;
}

var argseq__9377__auto__ = (new cljs.core.IndexedSeq(args_arr__9376__auto__.slice((2)),(0),null));
return cljs.core$macros.array_map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9377__auto__);

}
});

cljs.core$macros.array_map.cljs$core$IFn$_invoke$arity$2 = (function (_AMPERSAND_form,_AMPERSAND_env){
return cljs.core.list(new cljs.core.Symbol(null,".-EMPTY",".-EMPTY",-471586691,null),new cljs.core.Symbol("cljs.core","PersistentArrayMap","cljs.core/PersistentArrayMap",1025194468,null));
});

cljs.core$macros.array_map.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,kvs){
var keys = cljs.core.map.call(null,cljs.core.first,cljs.core.partition.call(null,(2),kvs));
if((cljs.core.every_QMARK_.call(null,((function (keys){
return (function (p1__37226_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__37226_SHARP_),new cljs.core.Keyword(null,"constant","constant",-379609303));
});})(keys))
,cljs.core.map.call(null,((function (keys){
return (function (p1__37227_SHARP_){
var _STAR_cljs_warnings_STAR_37234 = cljs.analyzer._STAR_cljs_warnings_STAR_;
cljs.analyzer._STAR_cljs_warnings_STAR_ = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"invoke-ctor","invoke-ctor",-756052704),new cljs.core.Keyword(null,"extending-base-js-type","extending-base-js-type",432787264),new cljs.core.Keyword(null,"unsupported-preprocess-value","unsupported-preprocess-value",1635147105),new cljs.core.Keyword(null,"redef","redef",1032704258),new cljs.core.Keyword(null,"js-shadowed-by-local","js-shadowed-by-local",198048291),new cljs.core.Keyword(null,"unsupported-js-module-type","unsupported-js-module-type",1806206180),new cljs.core.Keyword(null,"invalid-protocol-symbol","invalid-protocol-symbol",86246948),new cljs.core.Keyword(null,"protocol-duped-method","protocol-duped-method",15128166),new cljs.core.Keyword(null,"munged-namespace","munged-namespace",-101986199),new cljs.core.Keyword(null,"single-segment-namespace","single-segment-namespace",-491924469),new cljs.core.Keyword(null,"fn-arity","fn-arity",-403576501),new cljs.core.Keyword(null,"infer-warning","infer-warning",-1600671410),new cljs.core.Keyword(null,"variadic-max-arity","variadic-max-arity",-14288402),new cljs.core.Keyword(null,"protocol-with-variadic-method","protocol-with-variadic-method",-693368178),new cljs.core.Keyword(null,"fn-deprecated","fn-deprecated",626877647),new cljs.core.Keyword(null,"undeclared-var","undeclared-var",-1624364944),new cljs.core.Keyword(null,"preamble-missing","preamble-missing",220974801),new cljs.core.Keyword(null,"undeclared-protocol-symbol","undeclared-protocol-symbol",462882867),new cljs.core.Keyword(null,"dynamic","dynamic",704819571),new cljs.core.Keyword(null,"invalid-array-access","invalid-array-access",-1747132236),new cljs.core.Keyword(null,"unprovided","unprovided",-652330764),new cljs.core.Keyword(null,"ns-var-clash","ns-var-clash",-280494668),new cljs.core.Keyword(null,"undeclared-ns","undeclared-ns",-1589012812),new cljs.core.Keyword(null,"undeclared-ns-form","undeclared-ns-form",-248024137),new cljs.core.Keyword(null,"invalid-arithmetic","invalid-arithmetic",1917075065),new cljs.core.Keyword(null,"protocol-deprecated","protocol-deprecated",103233497),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"protocol-impl-recur-with-target","protocol-impl-recur-with-target",-1648321574),new cljs.core.Keyword(null,"overload-arity","overload-arity",823206044),new cljs.core.Keyword(null,"protocol-multiple-impls","protocol-multiple-impls",794179260),new cljs.core.Keyword(null,"redef-in-file","redef-in-file",-476530788),new cljs.core.Keyword(null,"protocol-invalid-method","protocol-invalid-method",522647516),new cljs.core.Keyword(null,"extend-type-invalid-method-shape","extend-type-invalid-method-shape",1424103549),new cljs.core.Keyword(null,"multiple-variadic-overloads","multiple-variadic-overloads",1110059837),new cljs.core.Keyword(null,"protocol-impl-with-variadic-method","protocol-impl-with-variadic-method",-319321217)],[false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false]);

try{return cljs.analyzer.analyze.call(null,_AMPERSAND_env,p1__37227_SHARP_);
}finally {cljs.analyzer._STAR_cljs_warnings_STAR_ = _STAR_cljs_warnings_STAR_37234;
}});})(keys))
,keys))) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,keys)),cljs.core.count.call(null,keys)))){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","PersistentArrayMap.","cljs.core/PersistentArrayMap.",-471979341,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,null),(function (){var x__9048__auto__ = (cljs.core.count.call(null,kvs) / (2));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","array","cljs.core$macros/array",49650437,null)),kvs)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null))));
} else {
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".createAsIfByAssoc",".createAsIfByAssoc",18554053,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","PersistentArrayMap","cljs.core/PersistentArrayMap",1025194468,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","array","cljs.core$macros/array",49650437,null)),kvs)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
}
});

cljs.core$macros.array_map.cljs$lang$applyTo = (function (seq37229){
var G__37230 = cljs.core.first.call(null,seq37229);
var seq37229__$1 = cljs.core.next.call(null,seq37229);
var G__37231 = cljs.core.first.call(null,seq37229__$1);
var seq37229__$2 = cljs.core.next.call(null,seq37229__$1);
return cljs.core$macros.array_map.cljs$core$IFn$_invoke$arity$variadic(G__37230,G__37231,seq37229__$2);
});

cljs.core$macros.array_map.cljs$lang$maxFixedArity = (2);

return null;
})()
;
cljs.core$macros.array_map.cljs$lang$macro = true;

var ret__9397__auto___37245 = (function (){
cljs.core$macros.hash_map = (function cljs$core$macros$hash_map(var_args){
var G__37244 = arguments.length;
switch (G__37244) {
case 2:
return cljs.core$macros.hash_map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__9376__auto__ = [];
var len__9357__auto___37247 = arguments.length;
var i__9358__auto___37248 = (0);
while(true){
if((i__9358__auto___37248 < len__9357__auto___37247)){
args_arr__9376__auto__.push((arguments[i__9358__auto___37248]));

var G__37249 = (i__9358__auto___37248 + (1));
i__9358__auto___37248 = G__37249;
continue;
} else {
}
break;
}

var argseq__9377__auto__ = (new cljs.core.IndexedSeq(args_arr__9376__auto__.slice((2)),(0),null));
return cljs.core$macros.hash_map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9377__auto__);

}
});

cljs.core$macros.hash_map.cljs$core$IFn$_invoke$arity$2 = (function (_AMPERSAND_form,_AMPERSAND_env){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".-EMPTY",".-EMPTY",-471586691,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","PersistentHashMap","cljs.core/PersistentHashMap",-454120575,null)))));
});

cljs.core$macros.hash_map.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,kvs){
var pairs = cljs.core.partition.call(null,(2),kvs);
var ks = cljs.core.map.call(null,cljs.core.first,pairs);
var vs = cljs.core.map.call(null,cljs.core.second,pairs);
return cljs.core.vary_meta.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".fromArrays",".fromArrays",1110244209,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","PersistentHashMap","cljs.core/PersistentHashMap",-454120575,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","array","cljs.core$macros/array",49650437,null)),ks)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","array","cljs.core$macros/array",49650437,null)),vs)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))),cljs.core.assoc,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core","PersistentHashMap","cljs.core/PersistentHashMap",-454120575,null));
});

cljs.core$macros.hash_map.cljs$lang$applyTo = (function (seq37241){
var G__37242 = cljs.core.first.call(null,seq37241);
var seq37241__$1 = cljs.core.next.call(null,seq37241);
var G__37243 = cljs.core.first.call(null,seq37241__$1);
var seq37241__$2 = cljs.core.next.call(null,seq37241__$1);
return cljs.core$macros.hash_map.cljs$core$IFn$_invoke$arity$variadic(G__37242,G__37243,seq37241__$2);
});

cljs.core$macros.hash_map.cljs$lang$maxFixedArity = (2);

return null;
})()
;
cljs.core$macros.hash_map.cljs$lang$macro = true;

var ret__9397__auto___37259 = (function (){
cljs.core$macros.hash_set = (function cljs$core$macros$hash_set(var_args){
var G__37256 = arguments.length;
switch (G__37256) {
case 2:
return cljs.core$macros.hash_set.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__9376__auto__ = [];
var len__9357__auto___37261 = arguments.length;
var i__9358__auto___37262 = (0);
while(true){
if((i__9358__auto___37262 < len__9357__auto___37261)){
args_arr__9376__auto__.push((arguments[i__9358__auto___37262]));

var G__37263 = (i__9358__auto___37262 + (1));
i__9358__auto___37262 = G__37263;
continue;
} else {
}
break;
}

var argseq__9377__auto__ = (new cljs.core.IndexedSeq(args_arr__9376__auto__.slice((2)),(0),null));
return cljs.core$macros.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9377__auto__);

}
});

cljs.core$macros.hash_set.cljs$core$IFn$_invoke$arity$2 = (function (_AMPERSAND_form,_AMPERSAND_env){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".-EMPTY",".-EMPTY",-471586691,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","PersistentHashSet","cljs.core/PersistentHashSet",-967232330,null)))));
});

cljs.core$macros.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,xs){
if(((cljs.core.count.call(null,xs) <= (8))) && (cljs.core.every_QMARK_.call(null,(function (p1__37250_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__37250_SHARP_),new cljs.core.Keyword(null,"constant","constant",-379609303));
}),cljs.core.map.call(null,(function (p1__37251_SHARP_){
var _STAR_cljs_warnings_STAR_37258 = cljs.analyzer._STAR_cljs_warnings_STAR_;
cljs.analyzer._STAR_cljs_warnings_STAR_ = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"invoke-ctor","invoke-ctor",-756052704),new cljs.core.Keyword(null,"extending-base-js-type","extending-base-js-type",432787264),new cljs.core.Keyword(null,"unsupported-preprocess-value","unsupported-preprocess-value",1635147105),new cljs.core.Keyword(null,"redef","redef",1032704258),new cljs.core.Keyword(null,"js-shadowed-by-local","js-shadowed-by-local",198048291),new cljs.core.Keyword(null,"unsupported-js-module-type","unsupported-js-module-type",1806206180),new cljs.core.Keyword(null,"invalid-protocol-symbol","invalid-protocol-symbol",86246948),new cljs.core.Keyword(null,"protocol-duped-method","protocol-duped-method",15128166),new cljs.core.Keyword(null,"munged-namespace","munged-namespace",-101986199),new cljs.core.Keyword(null,"single-segment-namespace","single-segment-namespace",-491924469),new cljs.core.Keyword(null,"fn-arity","fn-arity",-403576501),new cljs.core.Keyword(null,"infer-warning","infer-warning",-1600671410),new cljs.core.Keyword(null,"variadic-max-arity","variadic-max-arity",-14288402),new cljs.core.Keyword(null,"protocol-with-variadic-method","protocol-with-variadic-method",-693368178),new cljs.core.Keyword(null,"fn-deprecated","fn-deprecated",626877647),new cljs.core.Keyword(null,"undeclared-var","undeclared-var",-1624364944),new cljs.core.Keyword(null,"preamble-missing","preamble-missing",220974801),new cljs.core.Keyword(null,"undeclared-protocol-symbol","undeclared-protocol-symbol",462882867),new cljs.core.Keyword(null,"dynamic","dynamic",704819571),new cljs.core.Keyword(null,"invalid-array-access","invalid-array-access",-1747132236),new cljs.core.Keyword(null,"unprovided","unprovided",-652330764),new cljs.core.Keyword(null,"ns-var-clash","ns-var-clash",-280494668),new cljs.core.Keyword(null,"undeclared-ns","undeclared-ns",-1589012812),new cljs.core.Keyword(null,"undeclared-ns-form","undeclared-ns-form",-248024137),new cljs.core.Keyword(null,"invalid-arithmetic","invalid-arithmetic",1917075065),new cljs.core.Keyword(null,"protocol-deprecated","protocol-deprecated",103233497),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"protocol-impl-recur-with-target","protocol-impl-recur-with-target",-1648321574),new cljs.core.Keyword(null,"overload-arity","overload-arity",823206044),new cljs.core.Keyword(null,"protocol-multiple-impls","protocol-multiple-impls",794179260),new cljs.core.Keyword(null,"redef-in-file","redef-in-file",-476530788),new cljs.core.Keyword(null,"protocol-invalid-method","protocol-invalid-method",522647516),new cljs.core.Keyword(null,"extend-type-invalid-method-shape","extend-type-invalid-method-shape",1424103549),new cljs.core.Keyword(null,"multiple-variadic-overloads","multiple-variadic-overloads",1110059837),new cljs.core.Keyword(null,"protocol-impl-with-variadic-method","protocol-impl-with-variadic-method",-319321217)],[false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false]);

try{return cljs.analyzer.analyze.call(null,_AMPERSAND_env,p1__37251_SHARP_);
}finally {cljs.analyzer._STAR_cljs_warnings_STAR_ = _STAR_cljs_warnings_STAR_37258;
}}),xs))) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,xs)),cljs.core.count.call(null,xs)))){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","PersistentHashSet.","cljs.core/PersistentHashSet.",300313251,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,null),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","PersistentArrayMap.","cljs.core/PersistentArrayMap.",-471979341,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,null),(function (){var x__9048__auto__ = cljs.core.count.call(null,xs);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","array","cljs.core$macros/array",49650437,null)),cljs.core.interleave.call(null,xs,cljs.core.repeat.call(null,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null))));
} else {
return cljs.core.vary_meta.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".createAsIfByAssoc",".createAsIfByAssoc",18554053,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","PersistentHashSet","cljs.core/PersistentHashSet",-967232330,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","array","cljs.core$macros/array",49650437,null)),xs)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))),cljs.core.assoc,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core","PersistentHashSet","cljs.core/PersistentHashSet",-967232330,null));
}
});

cljs.core$macros.hash_set.cljs$lang$applyTo = (function (seq37253){
var G__37254 = cljs.core.first.call(null,seq37253);
var seq37253__$1 = cljs.core.next.call(null,seq37253);
var G__37255 = cljs.core.first.call(null,seq37253__$1);
var seq37253__$2 = cljs.core.next.call(null,seq37253__$1);
return cljs.core$macros.hash_set.cljs$core$IFn$_invoke$arity$variadic(G__37254,G__37255,seq37253__$2);
});

cljs.core$macros.hash_set.cljs$lang$maxFixedArity = (2);

return null;
})()
;
cljs.core$macros.hash_set.cljs$lang$macro = true;

cljs.core$macros.js_obj_STAR_ = (function cljs$core$macros$js_obj_STAR_(kvs){
var kvs_str = cljs.core.apply.call(null,cljs.core.str,cljs.core.interpose.call(null,",",cljs.core.take.call(null,cljs.core.count.call(null,kvs),cljs.core.repeat.call(null,"~{}:~{}"))));
return cljs.core.vary_meta.call(null,cljs.core.list_STAR_.call(null,new cljs.core.Symbol(null,"js*","js*",-1134233646,null),["{",cljs.core.str.cljs$core$IFn$_invoke$arity$1(kvs_str),"}"].join(''),cljs.core.apply.call(null,cljs.core.concat,kvs)),cljs.core.assoc,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"object","object",-1179821820,null));
});
var ret__9397__auto___37279 = (function (){
cljs.core$macros.js_obj = (function cljs$core$macros$js_obj(var_args){
var args__9364__auto__ = [];
var len__9357__auto___37280 = arguments.length;
var i__9358__auto___37281 = (0);
while(true){
if((i__9358__auto___37281 < len__9357__auto___37280)){
args__9364__auto__.push((arguments[i__9358__auto___37281]));

var G__37282 = (i__9358__auto___37281 + (1));
i__9358__auto___37281 = G__37282;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((2) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.js_obj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9365__auto__);
});

cljs.core$macros.js_obj.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,rest){
var sym_or_str_QMARK_ = (function (x){
return ((x instanceof cljs.core.Symbol)) || (typeof x === 'string');
});
var filter_on_keys = ((function (sym_or_str_QMARK_){
return (function (f,coll){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.filter.call(null,((function (sym_or_str_QMARK_){
return (function (p__37267){
var vec__37268 = p__37267;
var k = cljs.core.nth.call(null,vec__37268,(0),null);
var _ = cljs.core.nth.call(null,vec__37268,(1),null);
return f.call(null,k);
});})(sym_or_str_QMARK_))
,coll));
});})(sym_or_str_QMARK_))
;
var kvs = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,cljs.core.vec,cljs.core.partition.call(null,(2),rest)));
var sym_pairs = filter_on_keys.call(null,cljs.core.symbol_QMARK_,kvs);
var expr__GT_local = cljs.core.zipmap.call(null,cljs.core.filter.call(null,cljs.core.complement.call(null,sym_or_str_QMARK_),cljs.core.keys.call(null,kvs)),cljs.core.repeatedly.call(null,cljs.core.gensym));
var obj = cljs.core.gensym.call(null,"obj");
if(cljs.core.empty_QMARK_.call(null,rest)){
return cljs.core$macros.js_obj_STAR_.call(null,cljs.core.List.EMPTY);
} else {
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core.apply.call(null,cljs.core.concat,clojure.set.map_invert.call(null,expr__GT_local)),(function (){var x__9048__auto__ = obj;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core$macros.js_obj_STAR_.call(null,filter_on_keys.call(null,cljs.core.string_QMARK_,kvs));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core.map.call(null,((function (sym_or_str_QMARK_,filter_on_keys,kvs,sym_pairs,expr__GT_local,obj){
return (function (p__37271){
var vec__37272 = p__37271;
var k = cljs.core.nth.call(null,vec__37272,(0),null);
var v = cljs.core.nth.call(null,vec__37272,(1),null);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("goog.object","set","goog.object/set",-2123361230,null)),(function (){var x__9048__auto__ = obj;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = k;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = v;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});})(sym_or_str_QMARK_,filter_on_keys,kvs,sym_pairs,expr__GT_local,obj))
,sym_pairs),cljs.core.map.call(null,((function (sym_or_str_QMARK_,filter_on_keys,kvs,sym_pairs,expr__GT_local,obj){
return (function (p__37275){
var vec__37276 = p__37275;
var k = cljs.core.nth.call(null,vec__37276,(0),null);
var v = cljs.core.nth.call(null,vec__37276,(1),null);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("goog.object","set","goog.object/set",-2123361230,null)),(function (){var x__9048__auto__ = obj;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = v;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.get.call(null,kvs,k);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});})(sym_or_str_QMARK_,filter_on_keys,kvs,sym_pairs,expr__GT_local,obj))
,expr__GT_local),(function (){var x__9048__auto__ = obj;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
}
});

cljs.core$macros.js_obj.cljs$lang$maxFixedArity = (2);

cljs.core$macros.js_obj.cljs$lang$applyTo = (function (seq37264){
var G__37265 = cljs.core.first.call(null,seq37264);
var seq37264__$1 = cljs.core.next.call(null,seq37264);
var G__37266 = cljs.core.first.call(null,seq37264__$1);
var seq37264__$2 = cljs.core.next.call(null,seq37264__$1);
return cljs.core$macros.js_obj.cljs$core$IFn$_invoke$arity$variadic(G__37265,G__37266,seq37264__$2);
});

return null;
})()
;
cljs.core$macros.js_obj.cljs$lang$macro = true;

var ret__9397__auto___37283 = cljs.core$macros.alength = (function cljs$core$macros$alength(_AMPERSAND_form,_AMPERSAND_env,a){
return cljs.core.vary_meta.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = a;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),"~{}.length"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null)),cljs.core.assoc,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"number","number",-1084057331,null));
});
cljs.core$macros.alength.cljs$lang$macro = true;

var ret__9397__auto___37286 = /**
 * Maps an expression across an array a, using an index named idx, and
 *   return value named ret, initialized to a clone of a, then setting
 *   each element of ret to the evaluation of expr, returning the new
 *   array ret.
 */
cljs.core$macros.amap = (function cljs$core$macros$amap(_AMPERSAND_form,_AMPERSAND_env,a,idx,ret,expr){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"a__37284__auto__","a__37284__auto__",-1309182492,null)),(function (){var x__9048__auto__ = a;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"l__37285__auto__","l__37285__auto__",337993036,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","alength","cljs.core$macros/alength",-683052937,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"a__37284__auto__","a__37284__auto__",-1309182492,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = ret;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","aclone","cljs.core/aclone",-758078968,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"a__37284__auto__","a__37284__auto__",-1309182492,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","loop","cljs.core$macros/loop",1731108390,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = idx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,(0))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","<","cljs.core$macros/<",371512596,null)),(function (){var x__9048__auto__ = idx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"l__37285__auto__","l__37285__auto__",337993036,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","aset","cljs.core$macros/aset",-693176374,null)),(function (){var x__9048__auto__ = ret;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = idx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = expr;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"recur","recur",1202958259,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","inc","cljs.core$macros/inc",876629257,null)),(function (){var x__9048__auto__ = idx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = ret;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});
cljs.core$macros.amap.cljs$lang$macro = true;

var ret__9397__auto___37289 = /**
 * Reduces an expression across an array a, using an index named idx,
 *   and return value named ret, initialized to init, setting ret to the
 *   evaluation of expr at each step, returning ret.
 */
cljs.core$macros.areduce = (function cljs$core$macros$areduce(_AMPERSAND_form,_AMPERSAND_env,a,idx,ret,init,expr){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"a__37287__auto__","a__37287__auto__",-673380696,null)),(function (){var x__9048__auto__ = a;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"l__37288__auto__","l__37288__auto__",-2092912523,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","alength","cljs.core$macros/alength",-683052937,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"a__37287__auto__","a__37287__auto__",-673380696,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","loop","cljs.core$macros/loop",1731108390,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = idx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,(0)),(function (){var x__9048__auto__ = ret;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = init;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","<","cljs.core$macros/<",371512596,null)),(function (){var x__9048__auto__ = idx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"l__37288__auto__","l__37288__auto__",-2092912523,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"recur","recur",1202958259,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","inc","cljs.core$macros/inc",876629257,null)),(function (){var x__9048__auto__ = idx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = expr;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = ret;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});
cljs.core$macros.areduce.cljs$lang$macro = true;

var ret__9397__auto___37295 = (function (){
/**
 * bindings => name n
 * 
 *   Repeatedly executes body (presumably for side-effects) with name
 *   bound to integers from 0 through n-1.
 */
cljs.core$macros.dotimes = (function cljs$core$macros$dotimes(var_args){
var args__9364__auto__ = [];
var len__9357__auto___37296 = arguments.length;
var i__9358__auto___37297 = (0);
while(true){
if((i__9358__auto___37297 < len__9357__auto___37296)){
args__9364__auto__.push((arguments[i__9358__auto___37297]));

var G__37298 = (i__9358__auto___37297 + (1));
i__9358__auto___37297 = G__37298;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((3) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.dotimes.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9365__auto__);
});

cljs.core$macros.dotimes.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,bindings,body){
var i = cljs.core.first.call(null,bindings);
var n = cljs.core.second.call(null,bindings);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"n__37290__auto__","n__37290__auto__",-338763053,null)),(function (){var x__9048__auto__ = n;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","loop","cljs.core$macros/loop",1731108390,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = i;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,(0))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","when","cljs.core$macros/when",328457725,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","<","cljs.core$macros/<",371512596,null)),(function (){var x__9048__auto__ = i;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"n__37290__auto__","n__37290__auto__",-338763053,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),body,(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"recur","recur",1202958259,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","inc","cljs.core$macros/inc",876629257,null)),(function (){var x__9048__auto__ = i;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros.dotimes.cljs$lang$maxFixedArity = (3);

cljs.core$macros.dotimes.cljs$lang$applyTo = (function (seq37291){
var G__37292 = cljs.core.first.call(null,seq37291);
var seq37291__$1 = cljs.core.next.call(null,seq37291);
var G__37293 = cljs.core.first.call(null,seq37291__$1);
var seq37291__$2 = cljs.core.next.call(null,seq37291__$1);
var G__37294 = cljs.core.first.call(null,seq37291__$2);
var seq37291__$3 = cljs.core.next.call(null,seq37291__$2);
return cljs.core$macros.dotimes.cljs$core$IFn$_invoke$arity$variadic(G__37292,G__37293,G__37294,seq37291__$3);
});

return null;
})()
;
cljs.core$macros.dotimes.cljs$lang$macro = true;

/**
 * Throws an exception if the given option map contains keys not listed
 *   as valid, else returns nil.
 */
cljs.core$macros.check_valid_options = (function cljs$core$macros$check_valid_options(var_args){
var args__9364__auto__ = [];
var len__9357__auto___37302 = arguments.length;
var i__9358__auto___37303 = (0);
while(true){
if((i__9358__auto___37303 < len__9357__auto___37302)){
args__9364__auto__.push((arguments[i__9358__auto___37303]));

var G__37304 = (i__9358__auto___37303 + (1));
i__9358__auto___37303 = G__37304;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((1) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((1)),(0),null)):null);
return cljs.core$macros.check_valid_options.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9365__auto__);
});

cljs.core$macros.check_valid_options.cljs$core$IFn$_invoke$arity$variadic = (function (options,valid_keys){
if(cljs.core.seq.call(null,cljs.core.apply.call(null,cljs.core.disj,cljs.core.apply.call(null,cljs.core.hash_set,cljs.core.keys.call(null,options)),valid_keys))){
throw cljs.core.apply.call(null,cljs.core.str,"Only these options are valid: ",cljs.core.first.call(null,valid_keys),cljs.core.map.call(null,(function (p1__37299_SHARP_){
return [", ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__37299_SHARP_)].join('');
}),cljs.core.rest.call(null,valid_keys)));
} else {
return null;
}
});

cljs.core$macros.check_valid_options.cljs$lang$maxFixedArity = (1);

cljs.core$macros.check_valid_options.cljs$lang$applyTo = (function (seq37300){
var G__37301 = cljs.core.first.call(null,seq37300);
var seq37300__$1 = cljs.core.next.call(null,seq37300);
return cljs.core$macros.check_valid_options.cljs$core$IFn$_invoke$arity$variadic(G__37301,seq37300__$1);
});

var ret__9397__auto___37314 = (function (){
/**
 * Creates a new multimethod with the associated dispatch function.
 *   The docstring and attribute-map are optional.
 * 
 *   Options are key-value pairs and may be one of:
 *  :default    the default dispatch value, defaults to :default
 *  :hierarchy  the isa? hierarchy to use for dispatching
 *              defaults to the global hierarchy
 */
cljs.core$macros.defmulti = (function cljs$core$macros$defmulti(var_args){
var args__9364__auto__ = [];
var len__9357__auto___37315 = arguments.length;
var i__9358__auto___37316 = (0);
while(true){
if((i__9358__auto___37316 < len__9357__auto___37315)){
args__9364__auto__.push((arguments[i__9358__auto___37316]));

var G__37317 = (i__9358__auto___37316 + (1));
i__9358__auto___37316 = G__37317;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((3) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.defmulti.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9365__auto__);
});

cljs.core$macros.defmulti.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,mm_name,options){
var docstring = ((typeof cljs.core.first.call(null,options) === 'string')?cljs.core.first.call(null,options):null);
var options__$1 = ((typeof cljs.core.first.call(null,options) === 'string')?cljs.core.next.call(null,options):options);
var m = ((cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,options__$1)))?cljs.core.first.call(null,options__$1):cljs.core.PersistentArrayMap.EMPTY);
var options__$2 = ((cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,options__$1)))?cljs.core.next.call(null,options__$1):options__$1);
var dispatch_fn = cljs.core.first.call(null,options__$2);
var options__$3 = cljs.core.next.call(null,options__$2);
var m__$1 = (cljs.core.truth_(docstring)?cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"doc","doc",1913296891),docstring):m);
var m__$2 = (cljs.core.truth_(cljs.core.meta.call(null,mm_name))?cljs.core.conj.call(null,cljs.core.meta.call(null,mm_name),m__$1):m__$1);
var mm_ns = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(_AMPERSAND_env)))].join('');
if(cljs.core._EQ_.call(null,cljs.core.count.call(null,options__$3),(1))){
throw (new Error("The syntax for defmulti has changed. Example: (defmulti name dispatch-fn :default dispatch-value)"));
} else {
}

var options__$4 = cljs.core.apply.call(null,cljs.core.hash_map,options__$3);
var default$ = cljs.core.get.call(null,options__$4,new cljs.core.Keyword(null,"default","default",-1987822328),new cljs.core.Keyword(null,"default","default",-1987822328));
cljs.core$macros.check_valid_options.call(null,options__$4,new cljs.core.Keyword(null,"default","default",-1987822328),new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341));

return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","defonce","cljs.core$macros/defonce",-1096231613,null)),(function (){var x__9048__auto__ = cljs.core.with_meta.call(null,mm_name,m__$2);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"method-table__37305__auto__","method-table__37305__auto__",1432809181,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","atom","cljs.core/atom",1943839529,null)),(function (){var x__9048__auto__ = cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"prefer-table__37306__auto__","prefer-table__37306__auto__",-2080699572,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","atom","cljs.core/atom",1943839529,null)),(function (){var x__9048__auto__ = cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"method-cache__37307__auto__","method-cache__37307__auto__",467803932,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","atom","cljs.core/atom",1943839529,null)),(function (){var x__9048__auto__ = cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"cached-hierarchy__37308__auto__","cached-hierarchy__37308__auto__",-873969618,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","atom","cljs.core/atom",1943839529,null)),(function (){var x__9048__auto__ = cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"hierarchy__37309__auto__","hierarchy__37309__auto__",-2095183429,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","get","cljs.core/get",-296075407,null)),(function (){var x__9048__auto__ = options__$4;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","get-global-hierarchy","cljs.core/get-global-hierarchy",48052871,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","MultiFn.","cljs.core/MultiFn.",1073941573,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","symbol","cljs.core/symbol",195265748,null)),(function (){var x__9048__auto__ = mm_ns;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.name.call(null,mm_name);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = dispatch_fn;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = default$;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"hierarchy__37309__auto__","hierarchy__37309__auto__",-2095183429,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"method-table__37305__auto__","method-table__37305__auto__",1432809181,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"prefer-table__37306__auto__","prefer-table__37306__auto__",-2080699572,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"method-cache__37307__auto__","method-cache__37307__auto__",467803932,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"cached-hierarchy__37308__auto__","cached-hierarchy__37308__auto__",-873969618,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros.defmulti.cljs$lang$maxFixedArity = (3);

cljs.core$macros.defmulti.cljs$lang$applyTo = (function (seq37310){
var G__37311 = cljs.core.first.call(null,seq37310);
var seq37310__$1 = cljs.core.next.call(null,seq37310);
var G__37312 = cljs.core.first.call(null,seq37310__$1);
var seq37310__$2 = cljs.core.next.call(null,seq37310__$1);
var G__37313 = cljs.core.first.call(null,seq37310__$2);
var seq37310__$3 = cljs.core.next.call(null,seq37310__$2);
return cljs.core$macros.defmulti.cljs$core$IFn$_invoke$arity$variadic(G__37311,G__37312,G__37313,seq37310__$3);
});

return null;
})()
;
cljs.core$macros.defmulti.cljs$lang$macro = true;

var ret__9397__auto___37323 = (function (){
/**
 * Creates and installs a new method of multimethod associated with dispatch-value. 
 */
cljs.core$macros.defmethod = (function cljs$core$macros$defmethod(var_args){
var args__9364__auto__ = [];
var len__9357__auto___37324 = arguments.length;
var i__9358__auto___37325 = (0);
while(true){
if((i__9358__auto___37325 < len__9357__auto___37324)){
args__9364__auto__.push((arguments[i__9358__auto___37325]));

var G__37326 = (i__9358__auto___37325 + (1));
i__9358__auto___37325 = G__37326;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((4) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((4)),(0),null)):null);
return cljs.core$macros.defmethod.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__9365__auto__);
});

cljs.core$macros.defmethod.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,multifn,dispatch_val,fn_tail){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","-add-method","cljs.core/-add-method",571092113,null)),(function (){var x__9048__auto__ = cljs.core.with_meta.call(null,multifn,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core","MultiFn","cljs.core/MultiFn",1487419554,null)], null));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = dispatch_val;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),fn_tail)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros.defmethod.cljs$lang$maxFixedArity = (4);

cljs.core$macros.defmethod.cljs$lang$applyTo = (function (seq37318){
var G__37319 = cljs.core.first.call(null,seq37318);
var seq37318__$1 = cljs.core.next.call(null,seq37318);
var G__37320 = cljs.core.first.call(null,seq37318__$1);
var seq37318__$2 = cljs.core.next.call(null,seq37318__$1);
var G__37321 = cljs.core.first.call(null,seq37318__$2);
var seq37318__$3 = cljs.core.next.call(null,seq37318__$2);
var G__37322 = cljs.core.first.call(null,seq37318__$3);
var seq37318__$4 = cljs.core.next.call(null,seq37318__$3);
return cljs.core$macros.defmethod.cljs$core$IFn$_invoke$arity$variadic(G__37319,G__37320,G__37321,G__37322,seq37318__$4);
});

return null;
})()
;
cljs.core$macros.defmethod.cljs$lang$macro = true;

var ret__9397__auto___37329 = /**
 * Evaluates expr and prints the time it took. Returns the value of expr.
 */
cljs.core$macros.time = (function cljs$core$macros$time(_AMPERSAND_form,_AMPERSAND_env,expr){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"start__37327__auto__","start__37327__auto__",2075142540,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","system-time","cljs.core/system-time",1562011930,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"ret__37328__auto__","ret__37328__auto__",-769235044,null)),(function (){var x__9048__auto__ = expr;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","prn","cljs.core/prn",1725204552,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","str","cljs.core/str",-1971828991,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,"Elapsed time: "),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".toFixed",".toFixed",-895046938,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","-","cljs.core$macros/-",13526976,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","system-time","cljs.core/system-time",1562011930,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"start__37327__auto__","start__37327__auto__",2075142540,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,(6)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY," msecs"))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"ret__37328__auto__","ret__37328__auto__",-769235044,null)))));
});
cljs.core$macros.time.cljs$lang$macro = true;

var ret__9397__auto___37344 = (function (){
/**
 * Runs expr iterations times in the context of a let expression with
 *   the given bindings, then prints out the bindings and the expr
 *   followed by number of iterations and total time. The optional
 *   argument print-fn, defaulting to println, sets function used to
 *   print the result. expr's string representation will be produced
 *   using pr-str in any case.
 */
cljs.core$macros.simple_benchmark = (function cljs$core$macros$simple_benchmark(var_args){
var args__9364__auto__ = [];
var len__9357__auto___37345 = arguments.length;
var i__9358__auto___37346 = (0);
while(true){
if((i__9358__auto___37346 < len__9357__auto___37345)){
args__9364__auto__.push((arguments[i__9358__auto___37346]));

var G__37347 = (i__9358__auto___37346 + (1));
i__9358__auto___37346 = G__37347;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((5) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((5)),(0),null)):null);
return cljs.core$macros.simple_benchmark.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__9365__auto__);
});

cljs.core$macros.simple_benchmark.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,bindings,expr,iterations,p__37341){
var map__37342 = p__37341;
var map__37342__$1 = ((((!((map__37342 == null)))?((((map__37342.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37342.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37342):map__37342);
var print_fn = cljs.core.get.call(null,map__37342__$1,new cljs.core.Keyword(null,"print-fn","print-fn",-1720960489),new cljs.core.Symbol(null,"println","println",-733595439,null));
var bs_str = cljs.core.pr_str.call(null,bindings);
var expr_str = cljs.core.pr_str.call(null,expr);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = bindings;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"start__37330__auto__","start__37330__auto__",1515528031,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".getTime",".getTime",-1048557777,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("js","Date.","js/Date.",384205255,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"ret__37331__auto__","ret__37331__auto__",-10049396,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","dotimes","cljs.core$macros/dotimes",-1407597661,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"___37332__auto__","___37332__auto__",-1451056370,null)),(function (){var x__9048__auto__ = iterations;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = expr;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"end__37333__auto__","end__37333__auto__",-2138290650,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".getTime",".getTime",-1048557777,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("js","Date.","js/Date.",384205255,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"elapsed__37334__auto__","elapsed__37334__auto__",845067421,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","-","cljs.core$macros/-",13526976,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"end__37333__auto__","end__37333__auto__",-2138290650,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"start__37330__auto__","start__37330__auto__",1515528031,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = print_fn;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","str","cljs.core$macros/str",-2019499702,null)),(function (){var x__9048__auto__ = bs_str;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,", "),(function (){var x__9048__auto__ = expr_str;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,", "),(function (){var x__9048__auto__ = iterations;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY," runs, "),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"elapsed__37334__auto__","elapsed__37334__auto__",845067421,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY," msecs"))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros.simple_benchmark.cljs$lang$maxFixedArity = (5);

cljs.core$macros.simple_benchmark.cljs$lang$applyTo = (function (seq37335){
var G__37336 = cljs.core.first.call(null,seq37335);
var seq37335__$1 = cljs.core.next.call(null,seq37335);
var G__37337 = cljs.core.first.call(null,seq37335__$1);
var seq37335__$2 = cljs.core.next.call(null,seq37335__$1);
var G__37338 = cljs.core.first.call(null,seq37335__$2);
var seq37335__$3 = cljs.core.next.call(null,seq37335__$2);
var G__37339 = cljs.core.first.call(null,seq37335__$3);
var seq37335__$4 = cljs.core.next.call(null,seq37335__$3);
var G__37340 = cljs.core.first.call(null,seq37335__$4);
var seq37335__$5 = cljs.core.next.call(null,seq37335__$4);
return cljs.core$macros.simple_benchmark.cljs$core$IFn$_invoke$arity$variadic(G__37336,G__37337,G__37338,G__37339,G__37340,seq37335__$5);
});

return null;
})()
;
cljs.core$macros.simple_benchmark.cljs$lang$macro = true;

cljs.core$macros.cs = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.map.call(null,cljs.core.comp.call(null,cljs.core.gensym,cljs.core.str,cljs.core.char$),cljs.core.range.call(null,(97),(118))));
cljs.core$macros.gen_apply_to_helper = (function cljs$core$macros$gen_apply_to_helper(var_args){
var G__37349 = arguments.length;
switch (G__37349) {
case 0:
return cljs.core$macros.gen_apply_to_helper.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core$macros.gen_apply_to_helper.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core$macros.gen_apply_to_helper.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core$macros.gen_apply_to_helper.call(null,(1));
});

cljs.core$macros.gen_apply_to_helper.cljs$core$IFn$_invoke$arity$1 = (function (n){
if((n <= (20))){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = cljs.core$macros.cs.call(null,(n - (1)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","-first","cljs.core/-first",545297391,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"args","args",-1338879193,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"args","args",-1338879193,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","-rest","cljs.core/-rest",-1829241664,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"args","args",-1338879193,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","==","cljs.core$macros/==",-818551413,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"argc","argc",187692008,null)),(function (){var x__9048__auto__ = n;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"f","f",43394975,null)),cljs.core.take.call(null,n,cljs.core$macros.cs))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core$macros.gen_apply_to_helper.call(null,(n + (1)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
} else {
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"throw","throw",595905694,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("js","Error.","js/Error.",750655924,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,"Only up to 20 arguments supported on functions"))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
}
});

cljs.core$macros.gen_apply_to_helper.cljs$lang$maxFixedArity = 1;

var ret__9397__auto___37351 = cljs.core$macros.gen_apply_to = (function cljs$core$macros$gen_apply_to(_AMPERSAND_form,_AMPERSAND_env){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"*unchecked-if*","*unchecked-if*",1542408350,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,true))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","defn","cljs.core$macros/defn",-728332354,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"apply-to","apply-to",-1858571928,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"f","f",43394975,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"argc","argc",187692008,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"args","args",-1338879193,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"args","args",-1338879193,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","seq","cljs.core/seq",-1649497689,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"args","args",-1338879193,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","zero?","cljs.core$macros/zero?",-65998367,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"argc","argc",187692008,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"f","f",43394975,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core$macros.gen_apply_to_helper.call(null);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"*unchecked-if*","*unchecked-if*",1542408350,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,false))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});
cljs.core$macros.gen_apply_to.cljs$lang$macro = true;

cljs.core$macros.gen_apply_to_simple_helper = (function cljs$core$macros$gen_apply_to_simple_helper(f,num_args,args){
var new_arg_sym = cljs.core.symbol.call(null,["a",cljs.core.str.cljs$core$IFn$_invoke$arity$1(num_args)].join(''));
var proto_name = ["cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1((num_args + (1)))].join('');
var proto_prop = cljs.core.symbol.call(null,[".-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(proto_name)].join(''));
var proto_inv = cljs.core.symbol.call(null,[".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(proto_name)].join(''));
var next_sym = cljs.core.symbol.call(null,["next_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(num_args)].join(''));
var all_args = cljs.core.mapv.call(null,((function (new_arg_sym,proto_name,proto_prop,proto_inv,next_sym){
return (function (p1__37352_SHARP_){
return cljs.core.symbol.call(null,["a",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__37352_SHARP_)].join(''));
});})(new_arg_sym,proto_name,proto_prop,proto_inv,next_sym))
,cljs.core.range.call(null,(num_args + (1))));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = new_arg_sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","-first","cljs.core/-first",545297391,null)),(function (){var x__9048__auto__ = args;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = next_sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","next","cljs.core/next",-1291438473,null)),(function (){var x__9048__auto__ = args;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","nil?","cljs.core$macros/nil?",83624258,null)),(function (){var x__9048__auto__ = next_sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = proto_prop;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = f;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = proto_inv;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = f;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),all_args)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".call",".call",1496874263,null)),(function (){var x__9048__auto__ = f;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = f;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),all_args)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = ((((19) <= num_args))?cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"arr__37353__auto__","arr__37353__auto__",1631525202,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","array","cljs.core/array",486685886,null)),all_args)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","loop","cljs.core$macros/loop",1731108390,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"s__37354__auto__","s__37354__auto__",-2124806158,null)),(function (){var x__9048__auto__ = next_sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","when","cljs.core$macros/when",328457725,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"s__37354__auto__","s__37354__auto__",-2124806158,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".push",".push",-1497267248,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"arr__37353__auto__","arr__37353__auto__",1631525202,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","-first","cljs.core/-first",545297391,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"s__37354__auto__","s__37354__auto__",-2124806158,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"recur","recur",1202958259,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","next","cljs.core/next",-1291438473,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"s__37354__auto__","s__37354__auto__",-2124806158,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".apply",".apply",-1176201338,null)),(function (){var x__9048__auto__ = f;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = f;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"arr__37353__auto__","arr__37353__auto__",1631525202,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))):cljs.core$macros.gen_apply_to_simple_helper.call(null,f,(num_args + (1)),next_sym));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});
var ret__9397__auto___37355 = cljs.core$macros.gen_apply_to_simple = (function cljs$core$macros$gen_apply_to_simple(_AMPERSAND_form,_AMPERSAND_env,f,num_args,args){
return cljs.core$macros.gen_apply_to_simple_helper.call(null,f,num_args,args);
});
cljs.core$macros.gen_apply_to_simple.cljs$lang$macro = true;

var ret__9397__auto___37361 = (function (){
/**
 * Evaluates exprs in a context in which *print-fn* is bound to .append
 *   on a fresh StringBuffer.  Returns the string created by any nested
 *   printing calls.
 */
cljs.core$macros.with_out_str = (function cljs$core$macros$with_out_str(var_args){
var args__9364__auto__ = [];
var len__9357__auto___37362 = arguments.length;
var i__9358__auto___37363 = (0);
while(true){
if((i__9358__auto___37363 < len__9357__auto___37362)){
args__9364__auto__.push((arguments[i__9358__auto___37363]));

var G__37364 = (i__9358__auto___37363 + (1));
i__9358__auto___37363 = G__37364;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((2) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.with_out_str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9365__auto__);
});

cljs.core$macros.with_out_str.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,body){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"sb__37356__auto__","sb__37356__auto__",-1231980224,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("js","goog.string.StringBuffer.","js/goog.string.StringBuffer.",-1043451650,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","binding","cljs.core$macros/binding",1855847304,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","*print-newline*","cljs.core/*print-newline*",6231625,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,true),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","*print-fn*","cljs.core/*print-fn*",1342365176,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"x__37357__auto__","x__37357__auto__",-2079203887,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".append",".append",1595439852,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"sb__37356__auto__","sb__37356__auto__",-1231980224,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"x__37357__auto__","x__37357__auto__",-2079203887,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),body)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","str","cljs.core/str",-1971828991,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"sb__37356__auto__","sb__37356__auto__",-1231980224,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros.with_out_str.cljs$lang$maxFixedArity = (2);

cljs.core$macros.with_out_str.cljs$lang$applyTo = (function (seq37358){
var G__37359 = cljs.core.first.call(null,seq37358);
var seq37358__$1 = cljs.core.next.call(null,seq37358);
var G__37360 = cljs.core.first.call(null,seq37358__$1);
var seq37358__$2 = cljs.core.next.call(null,seq37358__$1);
return cljs.core$macros.with_out_str.cljs$core$IFn$_invoke$arity$variadic(G__37359,G__37360,seq37358__$2);
});

return null;
})()
;
cljs.core$macros.with_out_str.cljs$lang$macro = true;

var ret__9397__auto___37369 = (function (){
/**
 * Expands to code which yields a lazy sequence of the concatenation
 *   of the supplied colls.  Each coll expr is not evaluated until it is
 *   needed.
 * 
 *   (lazy-cat xs ys zs) === (concat (lazy-seq xs) (lazy-seq ys) (lazy-seq zs))
 */
cljs.core$macros.lazy_cat = (function cljs$core$macros$lazy_cat(var_args){
var args__9364__auto__ = [];
var len__9357__auto___37370 = arguments.length;
var i__9358__auto___37371 = (0);
while(true){
if((i__9358__auto___37371 < len__9357__auto___37370)){
args__9364__auto__.push((arguments[i__9358__auto___37371]));

var G__37372 = (i__9358__auto___37371 + (1));
i__9358__auto___37371 = G__37372;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((2) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.lazy_cat.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9365__auto__);
});

cljs.core$macros.lazy_cat.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,colls){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","concat","cljs.core/concat",-1133584918,null)),cljs.core.map.call(null,(function (p1__37365_SHARP_){
return cljs.core._conj.call(null,(function (){var x__9048__auto__ = p1__37365_SHARP_;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),new cljs.core.Symbol("cljs.core$macros","lazy-seq","cljs.core$macros/lazy-seq",806482650,null));
}),colls))));
});

cljs.core$macros.lazy_cat.cljs$lang$maxFixedArity = (2);

cljs.core$macros.lazy_cat.cljs$lang$applyTo = (function (seq37366){
var G__37367 = cljs.core.first.call(null,seq37366);
var seq37366__$1 = cljs.core.next.call(null,seq37366);
var G__37368 = cljs.core.first.call(null,seq37366__$1);
var seq37366__$2 = cljs.core.next.call(null,seq37366__$1);
return cljs.core$macros.lazy_cat.cljs$core$IFn$_invoke$arity$variadic(G__37367,G__37368,seq37366__$2);
});

return null;
})()
;
cljs.core$macros.lazy_cat.cljs$lang$macro = true;

var ret__9397__auto___37373 = cljs.core$macros.js_str = (function cljs$core$macros$js_str(_AMPERSAND_form,_AMPERSAND_env,s){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__9048__auto__ = s;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),"''+~{}"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.js_str.cljs$lang$macro = true;

var ret__9397__auto___37375 = cljs.core$macros.es6_iterable = (function cljs$core$macros$es6_iterable(_AMPERSAND_form,_AMPERSAND_env,ty){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("goog.object","set","goog.object/set",-2123361230,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".-prototype",".-prototype",-1562038608,null)),(function (){var x__9048__auto__ = ty;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","ITER_SYMBOL","cljs.core/ITER_SYMBOL",-2091399233,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","this-as","cljs.core$macros/this-as",-799075148,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__37374__auto__","this__37374__auto__",-686629392,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","es6-iterator","cljs.core/es6-iterator",856007913,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__37374__auto__","this__37374__auto__",-686629392,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});
cljs.core$macros.es6_iterable.cljs$lang$macro = true;

var ret__9397__auto___37392 = /**
 * Returns a map of the public intern mappings for the namespace.
 */
cljs.core$macros.ns_publics = (function cljs$core$macros$ns_publics(_AMPERSAND_form,_AMPERSAND_env,quoted_ns){
if((cljs.core.seq_QMARK_.call(null,quoted_ns)) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,quoted_ns),new cljs.core.Symbol(null,"quote","quote",1377916282,null))) && ((cljs.core.second.call(null,quoted_ns) instanceof cljs.core.Symbol))){
} else {
throw (new Error(["Assert failed: ","Argument to ns-publics must be a quoted symbol","\n","(core/and (seq? quoted-ns) (= (first quoted-ns) (quote quote)) (core/symbol? (second quoted-ns)))"].join('')));
}

var ns = cljs.core.second.call(null,quoted_ns);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","into","cljs.core/into",1879938733,null)),(function (){var x__9048__auto__ = cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core.map.call(null,((function (ns){
return (function (p__37384){
var vec__37385 = p__37384;
var sym = cljs.core.nth.call(null,vec__37385,(0),null);
var _ = cljs.core.nth.call(null,vec__37385,(1),null);
return cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","symbol","cljs.core/symbol",195265748,null)),(function (){var x__9048__auto__ = cljs.core.name.call(null,sym);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"var","var",870848730,null)),(function (){var x__9048__auto__ = cljs.core.symbol.call(null,cljs.core.name.call(null,ns),cljs.core.name.call(null,sym));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
});})(ns))
,cljs.core.filter.call(null,((function (ns){
return (function (p__37388){
var vec__37389 = p__37388;
var _ = cljs.core.nth.call(null,vec__37389,(0),null);
var info = cljs.core.nth.call(null,vec__37389,(1),null);
return cljs.core.not.call(null,new cljs.core.Keyword(null,"private","private",-558947994).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(info)));
});})(ns))
,cljs.core.get_in.call(null,cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927),ns,new cljs.core.Keyword(null,"defs","defs",1398449717)], null))))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});
cljs.core$macros.ns_publics.cljs$lang$macro = true;

var ret__9397__auto___37401 = /**
 * Returns a map of the import mappings for the namespace.
 */
cljs.core$macros.ns_imports = (function cljs$core$macros$ns_imports(_AMPERSAND_form,_AMPERSAND_env,quoted_ns){
if((cljs.core.seq_QMARK_.call(null,quoted_ns)) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,quoted_ns),new cljs.core.Symbol(null,"quote","quote",1377916282,null))) && ((cljs.core.second.call(null,quoted_ns) instanceof cljs.core.Symbol))){
} else {
throw (new Error(["Assert failed: ","Argument to ns-imports must be a quoted symbol","\n","(core/and (seq? quoted-ns) (= (first quoted-ns) (quote quote)) (core/symbol? (second quoted-ns)))"].join('')));
}

var ns = cljs.core.second.call(null,quoted_ns);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","into","cljs.core/into",1879938733,null)),(function (){var x__9048__auto__ = cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core.map.call(null,((function (ns){
return (function (p__37397){
var vec__37398 = p__37397;
var ctor = cljs.core.nth.call(null,vec__37398,(0),null);
var qualified_ctor = cljs.core.nth.call(null,vec__37398,(1),null);
return cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","symbol","cljs.core/symbol",195265748,null)),(function (){var x__9048__auto__ = cljs.core.name.call(null,ctor);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.symbol.call(null,qualified_ctor);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
});})(ns))
,cljs.core.get_in.call(null,cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927),ns,new cljs.core.Keyword(null,"imports","imports",-1249933394)], null)))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});
cljs.core$macros.ns_imports.cljs$lang$macro = true;

var ret__9397__auto___37410 = /**
 * Returns a map of the intern mappings for the namespace.
 */
cljs.core$macros.ns_interns = (function cljs$core$macros$ns_interns(_AMPERSAND_form,_AMPERSAND_env,quoted_ns){
if((cljs.core.seq_QMARK_.call(null,quoted_ns)) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,quoted_ns),new cljs.core.Symbol(null,"quote","quote",1377916282,null))) && ((cljs.core.second.call(null,quoted_ns) instanceof cljs.core.Symbol))){
} else {
throw (new Error(["Assert failed: ","Argument to ns-interns must be a quoted symbol","\n","(core/and (seq? quoted-ns) (= (first quoted-ns) (quote quote)) (core/symbol? (second quoted-ns)))"].join('')));
}

var ns = cljs.core.second.call(null,quoted_ns);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","into","cljs.core/into",1879938733,null)),(function (){var x__9048__auto__ = cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core.map.call(null,((function (ns){
return (function (p__37406){
var vec__37407 = p__37406;
var sym = cljs.core.nth.call(null,vec__37407,(0),null);
var _ = cljs.core.nth.call(null,vec__37407,(1),null);
return cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","symbol","cljs.core/symbol",195265748,null)),(function (){var x__9048__auto__ = cljs.core.name.call(null,sym);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"var","var",870848730,null)),(function (){var x__9048__auto__ = cljs.core.symbol.call(null,cljs.core.name.call(null,ns),cljs.core.name.call(null,sym));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
});})(ns))
,cljs.core.get_in.call(null,cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927),ns,new cljs.core.Keyword(null,"defs","defs",1398449717)], null)))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});
cljs.core$macros.ns_interns.cljs$lang$macro = true;

var ret__9397__auto___37411 = /**
 * Removes the mappings for the symbol from the namespace.
 */
cljs.core$macros.ns_unmap = (function cljs$core$macros$ns_unmap(_AMPERSAND_form,_AMPERSAND_env,quoted_ns,quoted_sym){
if((cljs.core.seq_QMARK_.call(null,quoted_ns)) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,quoted_ns),new cljs.core.Symbol(null,"quote","quote",1377916282,null))) && ((cljs.core.second.call(null,quoted_ns) instanceof cljs.core.Symbol)) && (cljs.core.seq_QMARK_.call(null,quoted_sym)) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,quoted_sym),new cljs.core.Symbol(null,"quote","quote",1377916282,null))) && ((cljs.core.second.call(null,quoted_sym) instanceof cljs.core.Symbol))){
} else {
throw (new Error(["Assert failed: ","Arguments to ns-unmap must be quoted symbols","\n","(core/and (seq? quoted-ns) (= (first quoted-ns) (quote quote)) (core/symbol? (second quoted-ns)) (seq? quoted-sym) (= (first quoted-sym) (quote quote)) (core/symbol? (second quoted-sym)))"].join('')));
}

var ns = cljs.core.second.call(null,quoted_ns);
var sym = cljs.core.second.call(null,quoted_sym);
cljs.core.swap_BANG_.call(null,cljs.env._STAR_compiler_STAR_,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927),ns,new cljs.core.Keyword(null,"defs","defs",1398449717)], null),cljs.core.dissoc,sym);

return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","js-delete","cljs.core$macros/js-delete",387769082,null)),(function (){var x__9048__auto__ = cljs.compiler.munge.call(null,ns);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.compiler.munge.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(sym)].join(''));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});
cljs.core$macros.ns_unmap.cljs$lang$macro = true;

var ret__9397__auto___37417 = (function (){
/**
 * Non-atomically swaps the value of the volatile as if:
 * (apply f current-value-of-vol args). Returns the value that
 * was swapped in.
 */
cljs.core$macros.vswap_BANG_ = (function cljs$core$macros$vswap_BANG_(var_args){
var args__9364__auto__ = [];
var len__9357__auto___37418 = arguments.length;
var i__9358__auto___37419 = (0);
while(true){
if((i__9358__auto___37419 < len__9357__auto___37418)){
args__9364__auto__.push((arguments[i__9358__auto___37419]));

var G__37420 = (i__9358__auto___37419 + (1));
i__9358__auto___37419 = G__37420;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((4) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((4)),(0),null)):null);
return cljs.core$macros.vswap_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__9365__auto__);
});

cljs.core$macros.vswap_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,vol,f,args){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","-vreset!","cljs.core/-vreset!",-1186516972,null)),(function (){var x__9048__auto__ = vol;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = f;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","-deref","cljs.core/-deref",-1260480154,null)),(function (){var x__9048__auto__ = vol;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),args)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros.vswap_BANG_.cljs$lang$maxFixedArity = (4);

cljs.core$macros.vswap_BANG_.cljs$lang$applyTo = (function (seq37412){
var G__37413 = cljs.core.first.call(null,seq37412);
var seq37412__$1 = cljs.core.next.call(null,seq37412);
var G__37414 = cljs.core.first.call(null,seq37412__$1);
var seq37412__$2 = cljs.core.next.call(null,seq37412__$1);
var G__37415 = cljs.core.first.call(null,seq37412__$2);
var seq37412__$3 = cljs.core.next.call(null,seq37412__$2);
var G__37416 = cljs.core.first.call(null,seq37412__$3);
var seq37412__$4 = cljs.core.next.call(null,seq37412__$3);
return cljs.core$macros.vswap_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__37413,G__37414,G__37415,G__37416,seq37412__$4);
});

return null;
})()
;
cljs.core$macros.vswap_BANG_.cljs$lang$macro = true;

var ret__9397__auto___37425 = (function (){
cljs.core$macros.locking = (function cljs$core$macros$locking(var_args){
var args__9364__auto__ = [];
var len__9357__auto___37426 = arguments.length;
var i__9358__auto___37427 = (0);
while(true){
if((i__9358__auto___37427 < len__9357__auto___37426)){
args__9364__auto__.push((arguments[i__9358__auto___37427]));

var G__37428 = (i__9358__auto___37427 + (1));
i__9358__auto___37427 = G__37428;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((3) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.locking.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9365__auto__);
});

cljs.core$macros.locking.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,forms){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),forms)));
});

cljs.core$macros.locking.cljs$lang$maxFixedArity = (3);

cljs.core$macros.locking.cljs$lang$applyTo = (function (seq37421){
var G__37422 = cljs.core.first.call(null,seq37421);
var seq37421__$1 = cljs.core.next.call(null,seq37421);
var G__37423 = cljs.core.first.call(null,seq37421__$1);
var seq37421__$2 = cljs.core.next.call(null,seq37421__$1);
var G__37424 = cljs.core.first.call(null,seq37421__$2);
var seq37421__$3 = cljs.core.next.call(null,seq37421__$2);
return cljs.core$macros.locking.cljs$core$IFn$_invoke$arity$variadic(G__37422,G__37423,G__37424,seq37421__$3);
});

return null;
})()
;
cljs.core$macros.locking.cljs$lang$macro = true;

var ret__9397__auto___37432 = (function (){
/**
 * Loads libs, skipping any that are already loaded. Each argument is
 *   either a libspec that identifies a lib or a flag that modifies how all the identified
 *   libs are loaded. Use :require in the ns macro in preference to calling this
 *   directly.
 * 
 *   Libs
 * 
 *   A 'lib' is a named set of resources in classpath whose contents define a
 *   library of ClojureScript code. Lib names are symbols and each lib is associated
 *   with a ClojureScript namespace. A lib's name also locates its root directory
 *   within classpath using Java's package name to classpath-relative path mapping.
 *   All resources in a lib should be contained in the directory structure under its
 *   root directory. All definitions a lib makes should be in its associated namespace.
 * 
 *   'require loads a lib by loading its root resource. The root resource path
 *   is derived from the lib name in the following manner:
 *   Consider a lib named by the symbol 'x.y.z; it has the root directory
 *   <classpath>/x/y/, and its root resource is <classpath>/x/y/z.clj. The root
 *   resource should contain code to create the lib's namespace (usually by using
 *   the ns macro) and load any additional lib resources.
 * 
 *   Libspecs
 * 
 *   A libspec is a lib name or a vector containing a lib name followed by
 *   options expressed as sequential keywords and arguments.
 * 
 *   Recognized options:
 *   :as takes a symbol as its argument and makes that symbol an alias to the
 *  lib's namespace in the current namespace.
 *   :refer takes a list of symbols to refer from the namespace.
 *   :refer-macros takes a list of macro symbols to refer from the namespace.
 *   :include-macros true causes macros from the namespace to be required.
 *   :rename specifies a map from referred var names to different
 *  symbols (and can be used to prevent clashes)
 * 
 * 
 *   Flags
 * 
 *   A flag is a keyword.
 *   Recognized flags: :reload, :reload-all, :verbose
 *   :reload forces loading of all the identified libs even if they are
 *  already loaded
 *   :reload-all implies :reload and also forces loading of all libs that the
 *  identified libs directly or indirectly load via require or use
 *   :verbose triggers printing information about each load, alias, and refer
 * 
 *   Example:
 * 
 *   The following would load the library clojure.string :as string.
 * 
 *   (require '[clojure.string :as string])
 */
cljs.core$macros.require = (function cljs$core$macros$require(var_args){
var args__9364__auto__ = [];
var len__9357__auto___37433 = arguments.length;
var i__9358__auto___37434 = (0);
while(true){
if((i__9358__auto___37434 < len__9357__auto___37433)){
args__9364__auto__.push((arguments[i__9358__auto___37434]));

var G__37435 = (i__9358__auto___37434 + (1));
i__9358__auto___37434 = G__37435;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((2) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.require.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9365__auto__);
});

cljs.core$macros.require.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,args){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"ns*","ns*",1840949383,null)),(function (){var x__9048__auto__ = cljs.core.cons.call(null,new cljs.core.Keyword(null,"require","require",-468001333),args);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros.require.cljs$lang$maxFixedArity = (2);

cljs.core$macros.require.cljs$lang$applyTo = (function (seq37429){
var G__37430 = cljs.core.first.call(null,seq37429);
var seq37429__$1 = cljs.core.next.call(null,seq37429);
var G__37431 = cljs.core.first.call(null,seq37429__$1);
var seq37429__$2 = cljs.core.next.call(null,seq37429__$1);
return cljs.core$macros.require.cljs$core$IFn$_invoke$arity$variadic(G__37430,G__37431,seq37429__$2);
});

return null;
})()
;
cljs.core$macros.require.cljs$lang$macro = true;

var ret__9397__auto___37439 = (function (){
/**
 * Similar to require but only for macros.
 */
cljs.core$macros.require_macros = (function cljs$core$macros$require_macros(var_args){
var args__9364__auto__ = [];
var len__9357__auto___37440 = arguments.length;
var i__9358__auto___37441 = (0);
while(true){
if((i__9358__auto___37441 < len__9357__auto___37440)){
args__9364__auto__.push((arguments[i__9358__auto___37441]));

var G__37442 = (i__9358__auto___37441 + (1));
i__9358__auto___37441 = G__37442;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((2) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.require_macros.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9365__auto__);
});

cljs.core$macros.require_macros.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,args){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"ns*","ns*",1840949383,null)),(function (){var x__9048__auto__ = cljs.core.cons.call(null,new cljs.core.Keyword(null,"require-macros","require-macros",707947416),args);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros.require_macros.cljs$lang$maxFixedArity = (2);

cljs.core$macros.require_macros.cljs$lang$applyTo = (function (seq37436){
var G__37437 = cljs.core.first.call(null,seq37436);
var seq37436__$1 = cljs.core.next.call(null,seq37436);
var G__37438 = cljs.core.first.call(null,seq37436__$1);
var seq37436__$2 = cljs.core.next.call(null,seq37436__$1);
return cljs.core$macros.require_macros.cljs$core$IFn$_invoke$arity$variadic(G__37437,G__37438,seq37436__$2);
});

return null;
})()
;
cljs.core$macros.require_macros.cljs$lang$macro = true;

var ret__9397__auto___37446 = (function (){
/**
 * Like require, but referring vars specified by the mandatory
 *   :only option.
 * 
 *   Example:
 * 
 *   The following would load the library clojure.set while referring
 *   the intersection var.
 * 
 *   (use '[clojure.set :only [intersection]])
 */
cljs.core$macros.use = (function cljs$core$macros$use(var_args){
var args__9364__auto__ = [];
var len__9357__auto___37447 = arguments.length;
var i__9358__auto___37448 = (0);
while(true){
if((i__9358__auto___37448 < len__9357__auto___37447)){
args__9364__auto__.push((arguments[i__9358__auto___37448]));

var G__37449 = (i__9358__auto___37448 + (1));
i__9358__auto___37448 = G__37449;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((2) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.use.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9365__auto__);
});

cljs.core$macros.use.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,args){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"ns*","ns*",1840949383,null)),(function (){var x__9048__auto__ = cljs.core.cons.call(null,new cljs.core.Keyword(null,"use","use",-1846382424),args);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros.use.cljs$lang$maxFixedArity = (2);

cljs.core$macros.use.cljs$lang$applyTo = (function (seq37443){
var G__37444 = cljs.core.first.call(null,seq37443);
var seq37443__$1 = cljs.core.next.call(null,seq37443);
var G__37445 = cljs.core.first.call(null,seq37443__$1);
var seq37443__$2 = cljs.core.next.call(null,seq37443__$1);
return cljs.core$macros.use.cljs$core$IFn$_invoke$arity$variadic(G__37444,G__37445,seq37443__$2);
});

return null;
})()
;
cljs.core$macros.use.cljs$lang$macro = true;

var ret__9397__auto___37453 = (function (){
/**
 * Similar to use but only for macros.
 */
cljs.core$macros.use_macros = (function cljs$core$macros$use_macros(var_args){
var args__9364__auto__ = [];
var len__9357__auto___37454 = arguments.length;
var i__9358__auto___37455 = (0);
while(true){
if((i__9358__auto___37455 < len__9357__auto___37454)){
args__9364__auto__.push((arguments[i__9358__auto___37455]));

var G__37456 = (i__9358__auto___37455 + (1));
i__9358__auto___37455 = G__37456;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((2) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.use_macros.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9365__auto__);
});

cljs.core$macros.use_macros.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,args){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"ns*","ns*",1840949383,null)),(function (){var x__9048__auto__ = cljs.core.cons.call(null,new cljs.core.Keyword(null,"use-macros","use-macros",-905638393),args);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros.use_macros.cljs$lang$maxFixedArity = (2);

cljs.core$macros.use_macros.cljs$lang$applyTo = (function (seq37450){
var G__37451 = cljs.core.first.call(null,seq37450);
var seq37450__$1 = cljs.core.next.call(null,seq37450);
var G__37452 = cljs.core.first.call(null,seq37450__$1);
var seq37450__$2 = cljs.core.next.call(null,seq37450__$1);
return cljs.core$macros.use_macros.cljs$core$IFn$_invoke$arity$variadic(G__37451,G__37452,seq37450__$2);
});

return null;
})()
;
cljs.core$macros.use_macros.cljs$lang$macro = true;

var ret__9397__auto___37460 = (function (){
/**
 * import-list => (closure-namespace constructor-name-symbols*)
 * 
 *   For each name in constructor-name-symbols, adds a mapping from name to the
 *   constructor named by closure-namespace to the current namespace. Use :import in the ns
 *   macro in preference to calling this directly.
 */
cljs.core$macros.import$ = (function cljs$core$macros$import(var_args){
var args__9364__auto__ = [];
var len__9357__auto___37461 = arguments.length;
var i__9358__auto___37462 = (0);
while(true){
if((i__9358__auto___37462 < len__9357__auto___37461)){
args__9364__auto__.push((arguments[i__9358__auto___37462]));

var G__37463 = (i__9358__auto___37462 + (1));
i__9358__auto___37462 = G__37463;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((2) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.import$.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9365__auto__);
});

cljs.core$macros.import$.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,import_symbols_or_lists){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"ns*","ns*",1840949383,null)),(function (){var x__9048__auto__ = cljs.core.cons.call(null,new cljs.core.Keyword(null,"import","import",-1399500709),import_symbols_or_lists);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros.import$.cljs$lang$maxFixedArity = (2);

cljs.core$macros.import$.cljs$lang$applyTo = (function (seq37457){
var G__37458 = cljs.core.first.call(null,seq37457);
var seq37457__$1 = cljs.core.next.call(null,seq37457);
var G__37459 = cljs.core.first.call(null,seq37457__$1);
var seq37457__$2 = cljs.core.next.call(null,seq37457__$1);
return cljs.core$macros.import$.cljs$core$IFn$_invoke$arity$variadic(G__37458,G__37459,seq37457__$2);
});

return null;
})()
;
cljs.core$macros.import$.cljs$lang$macro = true;

var ret__9397__auto___37467 = (function (){
/**
 * Refers to all the public vars of `cljs.core`, subject to
 *   filters.
 *   Filters can include at most one each of:
 * 
 *   :exclude list-of-symbols
 *   :rename map-of-fromsymbol-tosymbol
 * 
 *   Filters can be used to select a subset, via exclusion, or to provide a mapping
 *   to a symbol different from the var's name, in order to prevent clashes.
 */
cljs.core$macros.refer_clojure = (function cljs$core$macros$refer_clojure(var_args){
var args__9364__auto__ = [];
var len__9357__auto___37468 = arguments.length;
var i__9358__auto___37469 = (0);
while(true){
if((i__9358__auto___37469 < len__9357__auto___37468)){
args__9364__auto__.push((arguments[i__9358__auto___37469]));

var G__37470 = (i__9358__auto___37469 + (1));
i__9358__auto___37469 = G__37470;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((2) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.refer_clojure.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9365__auto__);
});

cljs.core$macros.refer_clojure.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,args){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"ns*","ns*",1840949383,null)),(function (){var x__9048__auto__ = cljs.core.cons.call(null,new cljs.core.Keyword(null,"refer-clojure","refer-clojure",813784440),args);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros.refer_clojure.cljs$lang$maxFixedArity = (2);

cljs.core$macros.refer_clojure.cljs$lang$applyTo = (function (seq37464){
var G__37465 = cljs.core.first.call(null,seq37464);
var seq37464__$1 = cljs.core.next.call(null,seq37464);
var G__37466 = cljs.core.first.call(null,seq37464__$1);
var seq37464__$2 = cljs.core.next.call(null,seq37464__$1);
return cljs.core$macros.refer_clojure.cljs$core$IFn$_invoke$arity$variadic(G__37465,G__37466,seq37464__$2);
});

return null;
})()
;
cljs.core$macros.refer_clojure.cljs$lang$macro = true;

var ret__9397__auto___37471 = cljs.core$macros.load_file_STAR_ = (function cljs$core$macros$load_file_STAR_(_AMPERSAND_form,_AMPERSAND_env,f){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("js","goog","js/goog",-70605150,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"nodeGlobalRequire","nodeGlobalRequire",167018599,null)),(function (){var x__9048__auto__ = f;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});
cljs.core$macros.load_file_STAR_.cljs$lang$macro = true;

var ret__9397__auto___37472 = /**
 * If form represents a macro form, returns its expansion,
 *   else returns form.
 */
cljs.core$macros.macroexpand_1 = (function cljs$core$macros$macroexpand_1(_AMPERSAND_form,_AMPERSAND_env,quoted){
if(cljs.core._EQ_.call(null,cljs.core.first.call(null,quoted),new cljs.core.Symbol(null,"quote","quote",1377916282,null))){
} else {
throw (new Error(["Assert failed: ","Argument to macroexpand-1 must be quoted","\n","(core/= (core/first quoted) (quote quote))"].join('')));
}

var form = cljs.core.second.call(null,quoted);
if(cljs.core.seq_QMARK_.call(null,form)){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"quote","quote",1377916282,null)),(function (){var x__9048__auto__ = cljs.analyzer.macroexpand_1.call(null,_AMPERSAND_env,form);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
} else {
return form;
}
});
cljs.core$macros.macroexpand_1.cljs$lang$macro = true;

var ret__9397__auto___37473 = /**
 * Repeatedly calls macroexpand-1 on form until it no longer
 *   represents a macro form, then returns it.  Note neither
 *   macroexpand-1 nor macroexpand expand macros in subforms.
 */
cljs.core$macros.macroexpand = (function cljs$core$macros$macroexpand(_AMPERSAND_form,_AMPERSAND_env,quoted){
if(cljs.core._EQ_.call(null,cljs.core.first.call(null,quoted),new cljs.core.Symbol(null,"quote","quote",1377916282,null))){
} else {
throw (new Error(["Assert failed: ","Argument to macroexpand must be quoted","\n","(core/= (core/first quoted) (quote quote))"].join('')));
}

var form = cljs.core.second.call(null,quoted);
var env = _AMPERSAND_env;
if(cljs.core.seq_QMARK_.call(null,form)){
var form__$1 = form;
var form_SINGLEQUOTE_ = cljs.analyzer.macroexpand_1.call(null,env,form__$1);
while(true){
if(!((form__$1 === form_SINGLEQUOTE_))){
var G__37474 = form_SINGLEQUOTE_;
var G__37475 = cljs.analyzer.macroexpand_1.call(null,env,form_SINGLEQUOTE_);
form__$1 = G__37474;
form_SINGLEQUOTE_ = G__37475;
continue;
} else {
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"quote","quote",1377916282,null)),(function (){var x__9048__auto__ = form_SINGLEQUOTE_;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
}
break;
}
} else {
return form;
}
});
cljs.core$macros.macroexpand.cljs$lang$macro = true;

cljs.core$macros.multi_arity_fn_QMARK_ = (function cljs$core$macros$multi_arity_fn_QMARK_(fdecl){
return ((1) < cljs.core.count.call(null,fdecl));
});
cljs.core$macros.variadic_fn_QMARK_ = (function cljs$core$macros$variadic_fn_QMARK_(fdecl){
var and__8174__auto__ = cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,fdecl));
if(and__8174__auto__){
return cljs.core.some.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"&","&",-2144855648,null),null], null), null),cljs.core.ffirst.call(null,fdecl));
} else {
return and__8174__auto__;
}
});
cljs.core$macros.variadic_fn_STAR_ = (function cljs$core$macros$variadic_fn_STAR_(var_args){
var G__37477 = arguments.length;
switch (G__37477) {
case 2:
return cljs.core$macros.variadic_fn_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core$macros.variadic_fn_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core$macros.variadic_fn_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (sym,method){
return cljs.core$macros.variadic_fn_STAR_.call(null,sym,method,true);
});

cljs.core$macros.variadic_fn_STAR_.cljs$core$IFn$_invoke$arity$3 = (function (sym,p__37478,solo){
var vec__37479 = p__37478;
var seq__37480 = cljs.core.seq.call(null,vec__37479);
var first__37481 = cljs.core.first.call(null,seq__37480);
var seq__37480__$1 = cljs.core.next.call(null,seq__37480);
var arglist = first__37481;
var body = seq__37480__$1;
var method = vec__37479;
var sig = cljs.core.remove.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"&","&",-2144855648,null),null], null), null),arglist);
var restarg = cljs.core.gensym.call(null,"seq");
var get_delegate = ((function (sig,restarg,vec__37479,seq__37480,first__37481,seq__37480__$1,arglist,body,method){
return (function cljs$core$macros$get_delegate(){
return new cljs.core.Symbol(null,"cljs$core$IFn$_invoke$arity$variadic","cljs$core$IFn$_invoke$arity$variadic",-378825034,null);
});})(sig,restarg,vec__37479,seq__37480,first__37481,seq__37480__$1,arglist,body,method))
;
var get_delegate_prop = ((function (sig,restarg,vec__37479,seq__37480,first__37481,seq__37480__$1,arglist,body,method){
return (function cljs$core$macros$get_delegate_prop(){
return cljs.core.symbol.call(null,["-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(get_delegate.call(null))].join(''));
});})(sig,restarg,vec__37479,seq__37480,first__37481,seq__37480__$1,arglist,body,method))
;
var param_bind = ((function (sig,restarg,vec__37479,seq__37480,first__37481,seq__37480__$1,arglist,body,method){
return (function cljs$core$macros$param_bind(param){
return cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = param;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = cljs.core.with_meta.call(null,new cljs.core.Symbol("cljs.core","first","cljs.core/first",-752535972,null),cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"file","file",-1269645878)),cljs.core._conj.call(null,cljs.core.List.EMPTY,"/Users/exupero/code/grapple/target/cljsbuild/public/js/out/cljs/core.cljc"),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"line","line",212345235)),cljs.core._conj.call(null,cljs.core.List.EMPTY,2999),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"column","column",2078222095)),cljs.core._conj.call(null,cljs.core.List.EMPTY,49),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"end-line","end-line",1837326455)),cljs.core._conj.call(null,cljs.core.List.EMPTY,2999),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"end-column","end-column",1425389514)),cljs.core._conj.call(null,cljs.core.List.EMPTY,54),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017)),cljs.core._conj.call(null,cljs.core.List.EMPTY,true))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = restarg;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = restarg;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = cljs.core.with_meta.call(null,new cljs.core.Symbol("cljs.core","next","cljs.core/next",-1291438473,null),cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"file","file",-1269645878)),cljs.core._conj.call(null,cljs.core.List.EMPTY,"/Users/exupero/code/grapple/target/cljsbuild/public/js/out/cljs/core.cljc"),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"line","line",212345235)),cljs.core._conj.call(null,cljs.core.List.EMPTY,3000),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"column","column",2078222095)),cljs.core._conj.call(null,cljs.core.List.EMPTY,51),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"end-line","end-line",1837326455)),cljs.core._conj.call(null,cljs.core.List.EMPTY,3000),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"end-column","end-column",1425389514)),cljs.core._conj.call(null,cljs.core.List.EMPTY,55),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017)),cljs.core._conj.call(null,cljs.core.List.EMPTY,true))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = restarg;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
});})(sig,restarg,vec__37479,seq__37480,first__37481,seq__37480__$1,arglist,body,method))
;
var apply_to = ((function (sig,restarg,vec__37479,seq__37480,first__37481,seq__37480__$1,arglist,body,method){
return (function cljs$core$macros$apply_to(){
if(((1) < cljs.core.count.call(null,sig))){
var params = cljs.core.repeatedly.call(null,(cljs.core.count.call(null,sig) - (1)),cljs.core.gensym);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = restarg;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core.mapcat.call(null,param_bind,params)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__9048__auto__ = sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = get_delegate.call(null);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),params,(function (){var x__9048__auto__ = restarg;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
} else {
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = restarg;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__9048__auto__ = sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = get_delegate.call(null);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","seq","cljs.core/seq",-1649497689,null)),(function (){var x__9048__auto__ = restarg;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
}
});})(sig,restarg,vec__37479,seq__37480,first__37481,seq__37480__$1,arglist,body,method))
;
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__9048__auto__ = sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = get_delegate_prop.call(null);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = cljs.core.vec.call(null,sig);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),body)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(cljs.core.truth_(solo)?cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__9048__auto__ = sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-cljs$lang$maxFixedArity","-cljs$lang$maxFixedArity",-1481434279,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = (cljs.core.count.call(null,sig) - (1));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())))):null),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__9048__auto__ = sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-cljs$lang$applyTo","-cljs$lang$applyTo",-225535181,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = apply_to.call(null);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});

cljs.core$macros.variadic_fn_STAR_.cljs$lang$maxFixedArity = 3;

var ret__9397__auto___37485 = cljs.core$macros.copy_arguments = (function cljs$core$macros$copy_arguments(_AMPERSAND_form,_AMPERSAND_env,dest){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"len__37483__auto__","len__37483__auto__",794556037,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","alength","cljs.core$macros/alength",-683052937,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","js-arguments","cljs.core$macros/js-arguments",390128540,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","loop","cljs.core$macros/loop",1731108390,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"i__37484__auto__","i__37484__auto__",-1467287948,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,(0))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","when","cljs.core$macros/when",328457725,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","<","cljs.core$macros/<",371512596,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"i__37484__auto__","i__37484__auto__",-1467287948,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"len__37483__auto__","len__37483__auto__",794556037,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".push",".push",-1497267248,null)),(function (){var x__9048__auto__ = dest;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","unchecked-get","cljs.core$macros/unchecked-get",-1185166893,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","js-arguments","cljs.core$macros/js-arguments",390128540,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"i__37484__auto__","i__37484__auto__",-1467287948,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"recur","recur",1202958259,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","inc","cljs.core$macros/inc",876629257,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"i__37484__auto__","i__37484__auto__",-1467287948,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});
cljs.core$macros.copy_arguments.cljs$lang$macro = true;

cljs.core$macros.variadic_fn = (function cljs$core$macros$variadic_fn(name,meta,p__37488,emit_var_QMARK_){
var vec__37489 = p__37488;
var vec__37492 = cljs.core.nth.call(null,vec__37489,(0),null);
var seq__37493 = cljs.core.seq.call(null,vec__37492);
var first__37494 = cljs.core.first.call(null,seq__37493);
var seq__37493__$1 = cljs.core.next.call(null,seq__37493);
var arglist = first__37494;
var body = seq__37493__$1;
var method = vec__37492;
var fdecl = vec__37489;
var dest_args = ((function (vec__37489,vec__37492,seq__37493,first__37494,seq__37493__$1,arglist,body,method,fdecl){
return (function cljs$core$macros$variadic_fn_$_dest_args(c){
return cljs.core.map.call(null,((function (vec__37489,vec__37492,seq__37493,first__37494,seq__37493__$1,arglist,body,method,fdecl){
return (function (n){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","unchecked-get","cljs.core$macros/unchecked-get",-1185166893,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","js-arguments","cljs.core$macros/js-arguments",390128540,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = n;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});})(vec__37489,vec__37492,seq__37493,first__37494,seq__37493__$1,arglist,body,method,fdecl))
,cljs.core.range.call(null,c));
});})(vec__37489,vec__37492,seq__37493,first__37494,seq__37493__$1,arglist,body,method,fdecl))
;
var rname = cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.analyzer._STAR_cljs_ns_STAR_)].join(''),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''));
var sig = cljs.core.remove.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"&","&",-2144855648,null),null], null), null),arglist);
var c_1 = (cljs.core.count.call(null,sig) - (1));
var meta__$1 = cljs.core.assoc.call(null,meta,new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),c_1,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sig], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),(function (){var x__9048__auto__ = arglist;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.doall.call(null,cljs.core.map.call(null,meta,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [arglist], null)))], null));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"def","def",597100991,null)),(function (){var x__9048__auto__ = cljs.core.with_meta.call(null,name,meta__$1);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"var_args","var_args",1214280389,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"args__37486__auto__","args__37486__auto__",1060916606,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","array","cljs.core$macros/array",49650437,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","copy-arguments","cljs.core$macros/copy-arguments",-1675962356,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"args__37486__auto__","args__37486__auto__",1060916606,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"argseq__37487__auto__","argseq__37487__auto__",-1225093581,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","when","cljs.core$macros/when",328457725,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","<","cljs.core$macros/<",371512596,null)),(function (){var x__9048__auto__ = c_1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","alength","cljs.core$macros/alength",-683052937,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"args__37486__auto__","args__37486__auto__",1060916606,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"new","new",-444906321,null)),(function (){var x__9048__auto__ = cljs.core.with_meta.call(null,new cljs.core.Symbol("cljs.core","IndexedSeq","cljs.core/IndexedSeq",-228688698,null),cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"file","file",-1269645878)),cljs.core._conj.call(null,cljs.core.List.EMPTY,"/Users/exupero/code/grapple/target/cljsbuild/public/js/out/cljs/core.cljc"),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"line","line",212345235)),cljs.core._conj.call(null,cljs.core.List.EMPTY,3047),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"column","column",2078222095)),cljs.core._conj.call(null,cljs.core.List.EMPTY,55),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"end-line","end-line",1837326455)),cljs.core._conj.call(null,cljs.core.List.EMPTY,3047),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"end-column","end-column",1425389514)),cljs.core._conj.call(null,cljs.core.List.EMPTY,75),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017)),cljs.core._conj.call(null,cljs.core.List.EMPTY,true))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".slice",".slice",1874048374,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"args__37486__auto__","args__37486__auto__",1060916606,null)),(function (){var x__9048__auto__ = c_1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,(0)),cljs.core._conj.call(null,cljs.core.List.EMPTY,null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__9048__auto__ = rname;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"cljs$core$IFn$_invoke$arity$variadic","cljs$core$IFn$_invoke$arity$variadic",-378825034,null)),dest_args.call(null,c_1),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"argseq__37487__auto__","argseq__37487__auto__",-1225093581,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core$macros.variadic_fn_STAR_.call(null,rname,method);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = (cljs.core.truth_(emit_var_QMARK_)?cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"var","var",870848730,null)),(function (){var x__9048__auto__ = name;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))):null);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});
cljs.core$macros.multi_arity_fn = (function cljs$core$macros$multi_arity_fn(name,meta,fdecl,emit_var_QMARK_){
var dest_args = (function cljs$core$macros$multi_arity_fn_$_dest_args(c){
return cljs.core.map.call(null,(function (n){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","unchecked-get","cljs.core$macros/unchecked-get",-1185166893,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","js-arguments","cljs.core$macros/js-arguments",390128540,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = n;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
}),cljs.core.range.call(null,c));
});
var fixed_arity = (function cljs$core$macros$multi_arity_fn_$_fixed_arity(rname,sig){
var c = cljs.core.count.call(null,sig);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [c,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__9048__auto__ = rname;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__9048__auto__ = cljs.core.symbol.call(null,["cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(c)].join(''));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),dest_args.call(null,c))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())))], null);
});
var fn_method = (function cljs$core$macros$multi_arity_fn_$_fn_method(p__37503){
var vec__37504 = p__37503;
var seq__37505 = cljs.core.seq.call(null,vec__37504);
var first__37506 = cljs.core.first.call(null,seq__37505);
var seq__37505__$1 = cljs.core.next.call(null,seq__37505);
var sig = first__37506;
var body = seq__37505__$1;
var method = vec__37504;
if(cljs.core.truth_(cljs.core.some.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"&","&",-2144855648,null),null], null), null),sig))){
return cljs.core$macros.variadic_fn_STAR_.call(null,name,method,false);
} else {
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__9048__auto__ = name;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.symbol.call(null,["-cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,sig))].join(''));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__9048__auto__ = method;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
}
});
var rname = cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.analyzer._STAR_cljs_ns_STAR_)].join(''),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''));
var arglists = cljs.core.map.call(null,cljs.core.first,fdecl);
var varsig_QMARK_ = ((function (rname,arglists){
return (function (p1__37495_SHARP_){
return cljs.core.some.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"&","&",-2144855648,null),null], null), null),p1__37495_SHARP_);
});})(rname,arglists))
;
var variadic = cljs.core.boolean$.call(null,cljs.core.some.call(null,varsig_QMARK_,arglists));
var sigs = cljs.core.remove.call(null,varsig_QMARK_,arglists);
var maxfa = cljs.core.apply.call(null,cljs.core.max,cljs.core.concat.call(null,cljs.core.map.call(null,cljs.core.count,sigs),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.count.call(null,cljs.core.first.call(null,cljs.core.filter.call(null,varsig_QMARK_,arglists))) - (2))], null)));
var meta__$1 = cljs.core.assoc.call(null,meta,new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),variadic,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),maxfa,new cljs.core.Keyword(null,"method-params","method-params",-980792179),sigs,new cljs.core.Keyword(null,"arglists","arglists",1661989754),arglists,new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.doall.call(null,cljs.core.map.call(null,meta,arglists))], null));
var args_sym = cljs.core.gensym.call(null,"args");
var param_counts = cljs.core.map.call(null,cljs.core.count,arglists);
if(cljs.core.not_EQ_.call(null,cljs.core.distinct.call(null,param_counts),param_counts)){
cljs.analyzer.warning.call(null,new cljs.core.Keyword(null,"overload-arity","overload-arity",823206044),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),name], null));
} else {
}

return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"def","def",597100991,null)),(function (){var x__9048__auto__ = cljs.core.with_meta.call(null,name,meta__$1);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"var_args","var_args",1214280389,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","case","cljs.core$macros/case",-2131866965,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","alength","cljs.core$macros/alength",-683052937,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","js-arguments","cljs.core$macros/js-arguments",390128540,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core.mapcat.call(null,((function (rname,arglists,varsig_QMARK_,variadic,sigs,maxfa,meta__$1,args_sym,param_counts){
return (function (p1__37496_SHARP_){
return fixed_arity.call(null,rname,p1__37496_SHARP_);
});})(rname,arglists,varsig_QMARK_,variadic,sigs,maxfa,meta__$1,args_sym,param_counts))
,sigs),(function (){var x__9048__auto__ = ((variadic)?cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"args-arr__37497__auto__","args-arr__37497__auto__",-2047606000,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","array","cljs.core$macros/array",49650437,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","copy-arguments","cljs.core$macros/copy-arguments",-1675962356,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"args-arr__37497__auto__","args-arr__37497__auto__",-2047606000,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"argseq__37498__auto__","argseq__37498__auto__",-669732504,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"new","new",-444906321,null)),(function (){var x__9048__auto__ = cljs.core.with_meta.call(null,new cljs.core.Symbol("cljs.core","IndexedSeq","cljs.core/IndexedSeq",-228688698,null),cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"file","file",-1269645878)),cljs.core._conj.call(null,cljs.core.List.EMPTY,"/Users/exupero/code/grapple/target/cljsbuild/public/js/out/cljs/core.cljc"),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"line","line",212345235)),cljs.core._conj.call(null,cljs.core.List.EMPTY,3108),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"column","column",2078222095)),cljs.core._conj.call(null,cljs.core.List.EMPTY,59),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"end-line","end-line",1837326455)),cljs.core._conj.call(null,cljs.core.List.EMPTY,3108),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"end-column","end-column",1425389514)),cljs.core._conj.call(null,cljs.core.List.EMPTY,79),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017)),cljs.core._conj.call(null,cljs.core.List.EMPTY,true))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".slice",".slice",1874048374,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"args-arr__37497__auto__","args-arr__37497__auto__",-2047606000,null)),(function (){var x__9048__auto__ = maxfa;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,(0)),cljs.core._conj.call(null,cljs.core.List.EMPTY,null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__9048__auto__ = rname;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"cljs$core$IFn$_invoke$arity$variadic","cljs$core$IFn$_invoke$arity$variadic",-378825034,null)),dest_args.call(null,maxfa),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"argseq__37498__auto__","argseq__37498__auto__",-669732504,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))):(cljs.core.truth_(new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(meta__$1))?cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"throw","throw",595905694,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("js","Error.","js/Error.",750655924,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","str","cljs.core$macros/str",-2019499702,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,"Invalid arity: "),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","-","cljs.core$macros/-",13526976,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","alength","cljs.core$macros/alength",-683052937,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","js-arguments","cljs.core$macros/js-arguments",390128540,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,(2)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))):cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"throw","throw",595905694,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("js","Error.","js/Error.",750655924,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","str","cljs.core$macros/str",-2019499702,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,"Invalid arity: "),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","alength","cljs.core$macros/alength",-683052937,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","js-arguments","cljs.core$macros/js-arguments",390128540,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core.map.call(null,fn_method,fdecl),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__9048__auto__ = name;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-cljs$lang$maxFixedArity","-cljs$lang$maxFixedArity",-1481434279,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = maxfa;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = (cljs.core.truth_(emit_var_QMARK_)?cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"var","var",870848730,null)),(function (){var x__9048__auto__ = name;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))):null);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});
/**
 * Same as (def name (core/fn [params* ] exprs*)) or (def
 *  name (core/fn ([params* ] exprs*)+)) with any doc-string or attrs added
 *  to the var metadata. prepost-map defines a map with optional keys
 *  :pre and :post that contain collections of pre or post conditions.
 * @param {...*} var_args
 */
cljs.core$macros.defn = (function() { 
var cljs$core$macros$defn__delegate = function (_AMPERSAND_form,_AMPERSAND_env,name,fdecl){
if((name instanceof cljs.core.Symbol)){
} else {
throw (new Error("First argument to defn must be a symbol"));
}

var m = ((typeof cljs.core.first.call(null,fdecl) === 'string')?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),cljs.core.first.call(null,fdecl)], null):cljs.core.PersistentArrayMap.EMPTY);
var fdecl__$1 = ((typeof cljs.core.first.call(null,fdecl) === 'string')?cljs.core.next.call(null,fdecl):fdecl);
var m__$1 = ((cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,fdecl__$1)))?cljs.core.conj.call(null,m,cljs.core.first.call(null,fdecl__$1)):m);
var fdecl__$2 = ((cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,fdecl__$1)))?cljs.core.next.call(null,fdecl__$1):fdecl__$1);
var fdecl__$3 = ((cljs.core.vector_QMARK_.call(null,cljs.core.first.call(null,fdecl__$2)))?(function (){var x__9048__auto__ = fdecl__$2;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})():fdecl__$2);
var m__$2 = ((cljs.core.map_QMARK_.call(null,cljs.core.last.call(null,fdecl__$3)))?cljs.core.conj.call(null,m__$1,cljs.core.last.call(null,fdecl__$3)):m__$1);
var fdecl__$4 = ((cljs.core.map_QMARK_.call(null,cljs.core.last.call(null,fdecl__$3)))?cljs.core.butlast.call(null,fdecl__$3):fdecl__$3);
var m__$3 = cljs.core.conj.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core._conj.call(null,(function (){var x__9048__auto__ = cljs.core$macros.sigs.call(null,fdecl__$4);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),new cljs.core.Symbol(null,"quote","quote",1377916282,null))], null),m__$2);
var m__$4 = cljs.core.conj.call(null,(cljs.core.truth_(cljs.core.meta.call(null,name))?cljs.core.meta.call(null,name):cljs.core.PersistentArrayMap.EMPTY),m__$3);
if(cljs.core.truth_(cljs.core$macros.multi_arity_fn_QMARK_.call(null,fdecl__$4))){
return cljs.core$macros.multi_arity_fn.call(null,name,(cljs.core.truth_(cljs.compiler.checking_types_QMARK_.call(null))?cljs.core.update_in.call(null,m__$4,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516)], null),cljs.core.conj,"@param {...*} var_args"):m__$4),fdecl__$4,new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(_AMPERSAND_env));
} else {
if(cljs.core.truth_(cljs.core$macros.variadic_fn_QMARK_.call(null,fdecl__$4))){
return cljs.core$macros.variadic_fn.call(null,name,(cljs.core.truth_(cljs.compiler.checking_types_QMARK_.call(null))?cljs.core.update_in.call(null,m__$4,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516)], null),cljs.core.conj,"@param {...*} var_args"):m__$4),fdecl__$4,new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(_AMPERSAND_env));
} else {
return cljs.core._conj.call(null,(function (){var x__9048__auto__ = cljs.core.with_meta.call(null,name,m__$4);
return cljs.core._conj.call(null,(function (){var x__9048__auto____$1 = cljs.core.cons.call(null,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null),fdecl__$4);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto____$1);
})(),x__9048__auto__);
})(),new cljs.core.Symbol(null,"def","def",597100991,null));

}
}
};
var cljs$core$macros$defn = function (_AMPERSAND_form,_AMPERSAND_env,name,var_args){
var fdecl = null;
if (arguments.length > 3) {
var G__37507__i = 0, G__37507__a = new Array(arguments.length -  3);
while (G__37507__i < G__37507__a.length) {G__37507__a[G__37507__i] = arguments[G__37507__i + 3]; ++G__37507__i;}
  fdecl = new cljs.core.IndexedSeq(G__37507__a,0,null);
} 
return cljs$core$macros$defn__delegate.call(this,_AMPERSAND_form,_AMPERSAND_env,name,fdecl);};
cljs$core$macros$defn.cljs$lang$maxFixedArity = 3;
cljs$core$macros$defn.cljs$lang$applyTo = (function (arglist__37508){
var _AMPERSAND_form = cljs.core.first(arglist__37508);
arglist__37508 = cljs.core.next(arglist__37508);
var _AMPERSAND_env = cljs.core.first(arglist__37508);
arglist__37508 = cljs.core.next(arglist__37508);
var name = cljs.core.first(arglist__37508);
var fdecl = cljs.core.rest(arglist__37508);
return cljs$core$macros$defn__delegate(_AMPERSAND_form,_AMPERSAND_env,name,fdecl);
});
cljs$core$macros$defn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$macros$defn__delegate;
return cljs$core$macros$defn;
})()
;
cljs.core$macros.defn.cljs$lang$macro = true;
/**
 * Like defn, but the resulting function name is declared as a
 *   macro and will be used as a macro by the compiler when it is
 *   called.
 */
cljs.core$macros.defmacro = (function cljs$core$macros$defmacro(var_args){
var args__9364__auto__ = [];
var len__9357__auto___37514 = arguments.length;
var i__9358__auto___37515 = (0);
while(true){
if((i__9358__auto___37515 < len__9357__auto___37514)){
args__9364__auto__.push((arguments[i__9358__auto___37515]));

var G__37516 = (i__9358__auto___37515 + (1));
i__9358__auto___37515 = G__37516;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((3) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.defmacro.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9365__auto__);
});

cljs.core$macros.defmacro.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,name,args){
var prefix = (function (){var p = (function (){var x__9048__auto__ = cljs.core.vary_meta.call(null,name,cljs.core.assoc,new cljs.core.Keyword(null,"macro","macro",-867863404),true);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})();
var args__$1 = args;
while(true){
var f = cljs.core.first.call(null,args__$1);
if(typeof f === 'string'){
var G__37517 = cljs.core.cons.call(null,f,p);
var G__37518 = cljs.core.next.call(null,args__$1);
p = G__37517;
args__$1 = G__37518;
continue;
} else {
if(cljs.core.map_QMARK_.call(null,f)){
var G__37519 = cljs.core.cons.call(null,f,p);
var G__37520 = cljs.core.next.call(null,args__$1);
p = G__37519;
args__$1 = G__37520;
continue;
} else {
return p;
}
}
break;
}
})();
var fdecl = (function (){var fd = args;
while(true){
if(typeof cljs.core.first.call(null,fd) === 'string'){
var G__37521 = cljs.core.next.call(null,fd);
fd = G__37521;
continue;
} else {
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,fd))){
var G__37522 = cljs.core.next.call(null,fd);
fd = G__37522;
continue;
} else {
return fd;
}
}
break;
}
})();
var fdecl__$1 = ((cljs.core.vector_QMARK_.call(null,cljs.core.first.call(null,fdecl)))?(function (){var x__9048__auto__ = fdecl;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})():fdecl);
var add_implicit_args = ((function (prefix,fdecl,fdecl__$1){
return (function (fd){
var args__$1 = cljs.core.first.call(null,fd);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"&form","&form",1482799337,null),cljs.core.cons.call(null,new cljs.core.Symbol(null,"&env","&env",-919163083,null),args__$1))),cljs.core.next.call(null,fd));
});})(prefix,fdecl,fdecl__$1))
;
var add_args = ((function (prefix,fdecl,fdecl__$1,add_implicit_args){
return (function (acc,ds){
while(true){
if((ds == null)){
return acc;
} else {
var d = cljs.core.first.call(null,ds);
if(cljs.core.map_QMARK_.call(null,d)){
return cljs.core.conj.call(null,acc,d);
} else {
var G__37523 = cljs.core.conj.call(null,acc,add_implicit_args.call(null,d));
var G__37524 = cljs.core.next.call(null,ds);
acc = G__37523;
ds = G__37524;
continue;
}
}
break;
}
});})(prefix,fdecl,fdecl__$1,add_implicit_args))
;
var fdecl__$2 = cljs.core.seq.call(null,add_args.call(null,cljs.core.PersistentVector.EMPTY,fdecl__$1));
var decl = (function (){var p = prefix;
var d = fdecl__$2;
while(true){
if(cljs.core.truth_(p)){
var G__37525 = cljs.core.next.call(null,p);
var G__37526 = cljs.core.cons.call(null,cljs.core.first.call(null,p),d);
p = G__37525;
d = G__37526;
continue;
} else {
return d;
}
break;
}
})();
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"ret__37509__auto__","ret__37509__auto__",-1475009385,null)),(function (){var x__9048__auto__ = cljs.core.cons.call(null,new cljs.core.Symbol("cljs.core$macros","defn","cljs.core$macros/defn",-728332354,null),decl);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__9048__auto__ = name;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-cljs$lang$macro","-cljs$lang$macro",443600924,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,true))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"ret__37509__auto__","ret__37509__auto__",-1475009385,null)))));
});

cljs.core$macros.defmacro.cljs$lang$maxFixedArity = (3);

cljs.core$macros.defmacro.cljs$lang$applyTo = (function (seq37510){
var G__37511 = cljs.core.first.call(null,seq37510);
var seq37510__$1 = cljs.core.next.call(null,seq37510);
var G__37512 = cljs.core.first.call(null,seq37510__$1);
var seq37510__$2 = cljs.core.next.call(null,seq37510__$1);
var G__37513 = cljs.core.first.call(null,seq37510__$2);
var seq37510__$3 = cljs.core.next.call(null,seq37510__$2);
return cljs.core$macros.defmacro.cljs$core$IFn$_invoke$arity$variadic(G__37511,G__37512,G__37513,seq37510__$3);
});

cljs.core$macros.defmacro.cljs$lang$macro = true;
var ret__9397__auto___37531 = /**
 * Returns the var to which a symbol will be resolved in the namespace else nil.
 */
cljs.core$macros.resolve = (function cljs$core$macros$resolve(_AMPERSAND_form,_AMPERSAND_env,quoted_sym){
if((cljs.core.seq_QMARK_.call(null,quoted_sym)) && (cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.first.call(null,quoted_sym)))){
} else {
throw (new Error(["Assert failed: ","Argument to resolve must be a quoted symbol","\n","(core/and (seq? quoted-sym) (= (quote quote) (first quoted-sym)))"].join('')));
}

var sym = cljs.core.second.call(null,quoted_sym);
var env = _AMPERSAND_env;
var vec__37527 = (function (){try{var var$ = cljs.analyzer.resolve_var.call(null,env,sym,cljs.analyzer.confirm_var_exists_throw.call(null));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [var$,cljs.analyzer.var_meta.call(null,var$)], null);
}catch (e37530){var e = e37530;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.analyzer.resolve_var.call(null,env,sym),null], null);
}})();
var var$ = cljs.core.nth.call(null,vec__37527,(0),null);
var meta = cljs.core.nth.call(null,vec__37527,(1),null);
var resolved = cljs.core.vary_meta.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(var$),cljs.core.assoc,new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","when","cljs.core$macros/when",328457725,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","exists?","cljs.core$macros/exists?",-1828590389,null)),(function (){var x__9048__auto__ = resolved;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","Var.","cljs.core/Var.",-242685277,null)),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__9048__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = resolved;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"quote","quote",1377916282,null)),(function (){var x__9048__auto__ = resolved;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),(function (){var x__9048__auto__ = meta;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})())));
});
cljs.core$macros.resolve.cljs$lang$macro = true;

