// Compiled by ClojureScript 1.9.946 {}
goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.tools.reader');
goog.require('cljs.env');
goog.require('cljs.analyzer');
goog.require('cljs.source_map');
goog.require('goog.string.StringBuffer');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.call(null,cljs.core.mapcat.call(null,(function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.call(null,clojure.string.replace.call(null,cljs.core.name.call(null,lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ecmascript5","ecmascript5",342717552),new cljs.core.Keyword(null,"ecmascript5-strict","ecmascript5-strict",888234811),new cljs.core.Keyword(null,"ecmascript6","ecmascript6",723864898),new cljs.core.Keyword(null,"ecmascript6-strict","ecmascript6-strict",-786049555),new cljs.core.Keyword(null,"ecmascript-2015","ecmascript-2015",-902254444),new cljs.core.Keyword(null,"ecmascript6-typed","ecmascript6-typed",-1978203054),new cljs.core.Keyword(null,"ecmascript-2016","ecmascript-2016",471574729),new cljs.core.Keyword(null,"ecmascript-2017","ecmascript-2017",620145058),new cljs.core.Keyword(null,"ecmascript-next","ecmascript-next",-1935155962)], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)].join('');
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.call(null,ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv.call(null,(function (xs,ns,_){
if(cljs.core._EQ_.call(null,needle,cljs.compiler.get_first_ns_segment.call(null,ns))){
return cljs.core.reduced.call(null,needle);
} else {
return null;
}
}),null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__31812 = s;
var map__31812__$1 = ((((!((map__31812 == null)))?((((map__31812.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31812.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31812):map__31812);
var name = cljs.core.get.call(null,map__31812__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.call(null,map__31812__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var d = (0);
var G__31815 = info;
var map__31816 = G__31815;
var map__31816__$1 = ((((!((map__31816 == null)))?((((map__31816.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31816.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31816):map__31816);
var shadow = cljs.core.get.call(null,map__31816__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
var d__$1 = d;
var G__31815__$1 = G__31815;
while(true){
var d__$2 = d__$1;
var map__31818 = G__31815__$1;
var map__31818__$1 = ((((!((map__31818 == null)))?((((map__31818.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31818.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31818):map__31818);
var shadow__$1 = cljs.core.get.call(null,map__31818__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
if(cljs.core.truth_(shadow__$1)){
var G__31820 = (d__$2 + (1));
var G__31821 = shadow__$1;
d__$1 = G__31820;
G__31815__$1 = G__31821;
continue;
} else {
if(cljs.core.truth_(cljs.compiler.find_ns_starts_with.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('')))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine.call(null,cljs.core._hash.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s)),cljs.compiler.shadow_depth.call(null,s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__31822){
var map__31823 = p__31822;
var map__31823__$1 = ((((!((map__31823 == null)))?((((map__31823.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31823.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31823):map__31823);
var name_var = map__31823__$1;
var name = cljs.core.get.call(null,map__31823__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.call(null,map__31823__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var name__$1 = clojure.string.replace.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''),"..","_DOT__DOT_");
var map__31825 = info;
var map__31825__$1 = ((((!((map__31825 == null)))?((((map__31825.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31825.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31825):map__31825);
var ns = cljs.core.get.call(null,map__31825__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var fn_scope = cljs.core.get.call(null,map__31825__$1,new cljs.core.Keyword(null,"fn-scope","fn-scope",-865664859));
var scoped_name = cljs.core.apply.call(null,cljs.core.str,cljs.core.interpose.call(null,"_$_",cljs.core.concat.call(null,cljs.core.map.call(null,cljs.core.comp.call(null,cljs.core.str,new cljs.core.Keyword(null,"name","name",1843675177)),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.call(null,cljs.compiler.munge.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.replace.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)].join(''),".","$")),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('')));
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if(!((cljs.core.get.call(null,reserved,s) == null))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__31828 = arguments.length;
switch (G__31828) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.call(null,s,cljs.compiler.js_reserved);
});

cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.cljs_map_QMARK_.call(null,s)){
var name_var = s;
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(name_var);
var field = new cljs.core.Keyword(null,"field","field",-1302436500).cljs$core$IFn$_invoke$arity$1(name_var);
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(name_var);
if(!((new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531).cljs$core$IFn$_invoke$arity$1(info) == null))){
return cljs.compiler.fn_self_name.call(null,s);
} else {
var depth = cljs.compiler.shadow_depth.call(null,s);
var code = cljs.compiler.hash_scope.call(null,s);
var renamed = cljs.core.get.call(null,cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):((!((renamed == null)))?renamed:name
));
var munged_name = cljs.compiler.munge.call(null,name__$1,reserved);
if((field === true) || ((depth === (0)))){
return munged_name;
} else {
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join(''),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace.call(null,ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved.call(null,reserved);
var ss__$2 = cljs.core.map.call(null,rf,clojure.string.split.call(null,ss__$1,/\./));
var ss__$3 = clojure.string.join.call(null,".",ss__$2);
var ms = cljs.core.munge_str.call(null,ss__$3);
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.call(null,ms);
} else {
return ms;
}
}
});

cljs.compiler.munge.cljs$lang$maxFixedArity = 2;

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.call(null,",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__31830 = cp;
switch (G__31830) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if((((31) < cp)) && ((cp < (127)))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.call(null,"0000",unpadded.length);
return ["\\u",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pad),cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__31832_31836 = cljs.core.seq.call(null,s);
var chunk__31833_31837 = null;
var count__31834_31838 = (0);
var i__31835_31839 = (0);
while(true){
if((i__31835_31839 < count__31834_31838)){
var c_31840 = cljs.core._nth.call(null,chunk__31833_31837,i__31835_31839);
sb.append(cljs.compiler.escape_char.call(null,c_31840));

var G__31841 = seq__31832_31836;
var G__31842 = chunk__31833_31837;
var G__31843 = count__31834_31838;
var G__31844 = (i__31835_31839 + (1));
seq__31832_31836 = G__31841;
chunk__31833_31837 = G__31842;
count__31834_31838 = G__31843;
i__31835_31839 = G__31844;
continue;
} else {
var temp__4657__auto___31845 = cljs.core.seq.call(null,seq__31832_31836);
if(temp__4657__auto___31845){
var seq__31832_31846__$1 = temp__4657__auto___31845;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31832_31846__$1)){
var c__9025__auto___31847 = cljs.core.chunk_first.call(null,seq__31832_31846__$1);
var G__31848 = cljs.core.chunk_rest.call(null,seq__31832_31846__$1);
var G__31849 = c__9025__auto___31847;
var G__31850 = cljs.core.count.call(null,c__9025__auto___31847);
var G__31851 = (0);
seq__31832_31836 = G__31848;
chunk__31833_31837 = G__31849;
count__31834_31838 = G__31850;
i__31835_31839 = G__31851;
continue;
} else {
var c_31852 = cljs.core.first.call(null,seq__31832_31846__$1);
sb.append(cljs.compiler.escape_char.call(null,c_31852));

var G__31853 = cljs.core.next.call(null,seq__31832_31846__$1);
var G__31854 = null;
var G__31855 = (0);
var G__31856 = (0);
seq__31832_31836 = G__31853;
chunk__31833_31837 = G__31854;
count__31834_31838 = G__31855;
i__31835_31839 = G__31856;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("\""),cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\"")].join('');
});
if(typeof cljs.compiler.emit_STAR_ !== 'undefined'){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__9143__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__9144__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__9145__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__9146__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__9147__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"cljs.compiler","emit*"),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__9147__auto__,method_table__9143__auto__,prefer_table__9144__auto__,method_cache__9145__auto__,cached_hierarchy__9146__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
var val__30209__auto__ = cljs.env._STAR_compiler_STAR_;
if((val__30209__auto__ == null)){
cljs.env._STAR_compiler_STAR_ = cljs.env.default_compiler_env.call(null);
} else {
}

try{if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__31857_31862 = ast;
var map__31857_31863__$1 = ((((!((map__31857_31862 == null)))?((((map__31857_31862.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31857_31862.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31857_31862):map__31857_31862);
var env_31864 = cljs.core.get.call(null,map__31857_31863__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.truth_(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env_31864))){
var map__31859_31865 = env_31864;
var map__31859_31866__$1 = ((((!((map__31859_31865 == null)))?((((map__31859_31865.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31859_31865.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31859_31865):map__31859_31865);
var line_31867 = cljs.core.get.call(null,map__31859_31866__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_31868 = cljs.core.get.call(null,map__31859_31866__$1,new cljs.core.Keyword(null,"column","column",2078222095));
cljs.core.swap_BANG_.call(null,cljs.compiler._STAR_source_map_data_STAR_,((function (map__31859_31865,map__31859_31866__$1,line_31867,column_31868,map__31857_31862,map__31857_31863__$1,env_31864,val__30209__auto__){
return (function (m){
var minfo = (function (){var G__31861 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gcol","gcol",309250807),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"gline","gline",-1086242431),new cljs.core.Keyword(null,"gen-line","gen-line",589592125).cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(ast),new cljs.core.Keyword(null,"var","var",-769682797))){
return cljs.core.assoc.call(null,G__31861,new cljs.core.Keyword(null,"name","name",1843675177),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(ast)))].join(''));
} else {
return G__31861;
}
})();
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"source-map","source-map",1706252311),(line_31867 - (1))], null),cljs.core.fnil.call(null,((function (minfo,map__31859_31865,map__31859_31866__$1,line_31867,column_31868,map__31857_31862,map__31857_31863__$1,env_31864,val__30209__auto__){
return (function (line__$1){
return cljs.core.update_in.call(null,line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_31868)?(column_31868 - (1)):(0))], null),cljs.core.fnil.call(null,((function (minfo,map__31859_31865,map__31859_31866__$1,line_31867,column_31868,map__31857_31862,map__31857_31863__$1,env_31864,val__30209__auto__){
return (function (column__$1){
return cljs.core.conj.call(null,column__$1,minfo);
});})(minfo,map__31859_31865,map__31859_31866__$1,line_31867,column_31868,map__31857_31862,map__31857_31863__$1,env_31864,val__30209__auto__))
,cljs.core.PersistentVector.EMPTY));
});})(minfo,map__31859_31865,map__31859_31866__$1,line_31867,column_31868,map__31857_31862,map__31857_31863__$1,env_31864,val__30209__auto__))
,cljs.core.sorted_map.call(null)));
});})(map__31859_31865,map__31859_31866__$1,line_31867,column_31868,map__31857_31862,map__31857_31863__$1,env_31864,val__30209__auto__))
);
} else {
}
} else {
}

return cljs.compiler.emit_STAR_.call(null,ast);
}finally {if((val__30209__auto__ == null)){
cljs.env._STAR_compiler_STAR_ = null;
} else {
}
}});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var args__9364__auto__ = [];
var len__9357__auto___31875 = arguments.length;
var i__9358__auto___31876 = (0);
while(true){
if((i__9358__auto___31876 < len__9357__auto___31875)){
args__9364__auto__.push((arguments[i__9358__auto___31876]));

var G__31877 = (i__9358__auto___31876 + (1));
i__9358__auto___31876 = G__31877;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((0) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((0)),(0),null)):null);
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(argseq__9365__auto__);
});

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
var seq__31871_31878 = cljs.core.seq.call(null,xs);
var chunk__31872_31879 = null;
var count__31873_31880 = (0);
var i__31874_31881 = (0);
while(true){
if((i__31874_31881 < count__31873_31880)){
var x_31882 = cljs.core._nth.call(null,chunk__31872_31879,i__31874_31881);
if((x_31882 == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_.call(null,x_31882)){
cljs.compiler.emit.call(null,x_31882);
} else {
if(cljs.analyzer.cljs_seq_QMARK_.call(null,x_31882)){
cljs.core.apply.call(null,cljs.compiler.emits,x_31882);
} else {
if(goog.isFunction(x_31882)){
x_31882.call(null);
} else {
var s_31883 = cljs.core.print_str.call(null,x_31882);
if((cljs.compiler._STAR_source_map_data_STAR_ == null)){
} else {
cljs.core.swap_BANG_.call(null,cljs.compiler._STAR_source_map_data_STAR_,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gen-col","gen-col",1901918303)], null),((function (seq__31871_31878,chunk__31872_31879,count__31873_31880,i__31874_31881,s_31883,x_31882){
return (function (p1__31869_SHARP_){
return (p1__31869_SHARP_ + cljs.core.count.call(null,s_31883));
});})(seq__31871_31878,chunk__31872_31879,count__31873_31880,i__31874_31881,s_31883,x_31882))
);
}

cljs.core.print.call(null,s_31883);

}
}
}
}

var G__31884 = seq__31871_31878;
var G__31885 = chunk__31872_31879;
var G__31886 = count__31873_31880;
var G__31887 = (i__31874_31881 + (1));
seq__31871_31878 = G__31884;
chunk__31872_31879 = G__31885;
count__31873_31880 = G__31886;
i__31874_31881 = G__31887;
continue;
} else {
var temp__4657__auto___31888 = cljs.core.seq.call(null,seq__31871_31878);
if(temp__4657__auto___31888){
var seq__31871_31889__$1 = temp__4657__auto___31888;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31871_31889__$1)){
var c__9025__auto___31890 = cljs.core.chunk_first.call(null,seq__31871_31889__$1);
var G__31891 = cljs.core.chunk_rest.call(null,seq__31871_31889__$1);
var G__31892 = c__9025__auto___31890;
var G__31893 = cljs.core.count.call(null,c__9025__auto___31890);
var G__31894 = (0);
seq__31871_31878 = G__31891;
chunk__31872_31879 = G__31892;
count__31873_31880 = G__31893;
i__31874_31881 = G__31894;
continue;
} else {
var x_31895 = cljs.core.first.call(null,seq__31871_31889__$1);
if((x_31895 == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_.call(null,x_31895)){
cljs.compiler.emit.call(null,x_31895);
} else {
if(cljs.analyzer.cljs_seq_QMARK_.call(null,x_31895)){
cljs.core.apply.call(null,cljs.compiler.emits,x_31895);
} else {
if(goog.isFunction(x_31895)){
x_31895.call(null);
} else {
var s_31896 = cljs.core.print_str.call(null,x_31895);
if((cljs.compiler._STAR_source_map_data_STAR_ == null)){
} else {
cljs.core.swap_BANG_.call(null,cljs.compiler._STAR_source_map_data_STAR_,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gen-col","gen-col",1901918303)], null),((function (seq__31871_31878,chunk__31872_31879,count__31873_31880,i__31874_31881,s_31896,x_31895,seq__31871_31889__$1,temp__4657__auto___31888){
return (function (p1__31869_SHARP_){
return (p1__31869_SHARP_ + cljs.core.count.call(null,s_31896));
});})(seq__31871_31878,chunk__31872_31879,count__31873_31880,i__31874_31881,s_31896,x_31895,seq__31871_31889__$1,temp__4657__auto___31888))
);
}

cljs.core.print.call(null,s_31896);

}
}
}
}

var G__31897 = cljs.core.next.call(null,seq__31871_31889__$1);
var G__31898 = null;
var G__31899 = (0);
var G__31900 = (0);
seq__31871_31878 = G__31897;
chunk__31872_31879 = G__31898;
count__31873_31880 = G__31899;
i__31874_31881 = G__31900;
continue;
}
} else {
}
}
break;
}

return null;
});

cljs.compiler.emits.cljs$lang$maxFixedArity = (0);

cljs.compiler.emits.cljs$lang$applyTo = (function (seq31870){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq31870));
});

cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var args__9364__auto__ = [];
var len__9357__auto___31906 = arguments.length;
var i__9358__auto___31907 = (0);
while(true){
if((i__9358__auto___31907 < len__9357__auto___31906)){
args__9364__auto__.push((arguments[i__9358__auto___31907]));

var G__31908 = (i__9358__auto___31907 + (1));
i__9358__auto___31907 = G__31908;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((0) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((0)),(0),null)):null);
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(argseq__9365__auto__);
});

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
cljs.core.apply.call(null,cljs.compiler.emits,xs);

var _STAR_flush_on_newline_STAR_31902_31909 = cljs.core._STAR_flush_on_newline_STAR_;
cljs.core._STAR_flush_on_newline_STAR_ = false;

try{cljs.core.println.call(null);
}finally {cljs.core._STAR_flush_on_newline_STAR_ = _STAR_flush_on_newline_STAR_31902_31909;
}
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.call(null,cljs.compiler._STAR_source_map_data_STAR_,(function (p__31903){
var map__31904 = p__31903;
var map__31904__$1 = ((((!((map__31904 == null)))?((((map__31904.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31904.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31904):map__31904);
var m = map__31904__$1;
var gen_line = cljs.core.get.call(null,map__31904__$1,new cljs.core.Keyword(null,"gen-line","gen-line",589592125));
return cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"gen-line","gen-line",589592125),(gen_line + (1)),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(0));
}));
} else {
}

return null;
});

cljs.compiler.emitln.cljs$lang$maxFixedArity = (0);

cljs.compiler.emitln.cljs$lang$applyTo = (function (seq31901){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq31901));
});

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__9215__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR_31910_31912 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR_31911_31913 = cljs.core._STAR_print_fn_STAR_;
cljs.core._STAR_print_newline_STAR_ = true;

cljs.core._STAR_print_fn_STAR_ = ((function (_STAR_print_newline_STAR_31910_31912,_STAR_print_fn_STAR_31911_31913,sb__9215__auto__){
return (function (x__9216__auto__){
return sb__9215__auto__.append(x__9216__auto__);
});})(_STAR_print_newline_STAR_31910_31912,_STAR_print_fn_STAR_31911_31913,sb__9215__auto__))
;

try{cljs.compiler.emit.call(null,expr);
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR_31911_31913;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR_31910_31912;
}
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__9215__auto__)].join('');
});
if(typeof cljs.compiler.emit_constant !== 'undefined'){
} else {
cljs.compiler.emit_constant = (function (){var method_table__9143__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__9144__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__9145__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__9146__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__9147__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"cljs.compiler","emit-constant"),cljs.core.type,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__9147__auto__,method_table__9143__auto__,prefer_table__9144__auto__,method_cache__9145__auto__,cached_hierarchy__9146__auto__));
})();
}
cljs.core._add_method.call(null,cljs.compiler.emit_constant,new cljs.core.Keyword(null,"default","default",-1987822328),(function (x){
throw cljs.core.ex_info.call(null,["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type.call(null,x))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"constant","constant",-379609303),x,new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.type.call(null,x)], null));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant,null,(function (x){
return cljs.compiler.emits.call(null,"null");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.call(null,"NaN");
} else {
if(cljs.core.not.call(null,isFinite(x))){
return cljs.compiler.emits.call(null,(((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.call(null,"(",x,")");

}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant,String,(function (x){
return cljs.compiler.emits.call(null,cljs.compiler.wrap_in_double_quotes.call(null,cljs.compiler.escape_string.call(null,x)));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant,Boolean,(function (x){
return cljs.compiler.emits.call(null,(cljs.core.truth_(x)?"true":"false"));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant,RegExp,(function (x){
if(cljs.core._EQ_.call(null,"",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''))){
return cljs.compiler.emits.call(null,"(new RegExp(\"\"))");
} else {
var vec__31914 = cljs.core.re_find.call(null,/^(?:\(\?([idmsux]*)\))?(.*)/,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''));
var _ = cljs.core.nth.call(null,vec__31914,(0),null);
var flags = cljs.core.nth.call(null,vec__31914,(1),null);
var pattern = cljs.core.nth.call(null,vec__31914,(2),null);
return cljs.compiler.emits.call(null,pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace.call(null,kw);
var name = cljs.core.name.call(null,kw);
cljs.compiler.emits.call(null,"new cljs.core.Keyword(");

cljs.compiler.emit_constant.call(null,ns);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,name);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,(cljs.core.truth_(ns)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):name));

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,cljs.core.hash.call(null,kw));

return cljs.compiler.emits.call(null,")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace.call(null,sym);
var name = cljs.core.name.call(null,sym);
var symstr = ((!((ns == null)))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):name);
cljs.compiler.emits.call(null,"new cljs.core.Symbol(");

cljs.compiler.emit_constant.call(null,ns);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,name);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,symstr);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,cljs.core.hash.call(null,sym));

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,null);

return cljs.compiler.emits.call(null,")");
});
cljs.core._add_method.call(null,cljs.compiler.emit_constant,cljs.core.Keyword,(function (x){
var temp__4655__auto__ = (function (){var and__8174__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__8174__auto__)){
return x.call(null,new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
} else {
return and__8174__auto__;
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var value = temp__4655__auto__;
return cljs.compiler.emits.call(null,"cljs.core.",value);
} else {
return cljs.compiler.emits_keyword.call(null,x);
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant,cljs.core.Symbol,(function (x){
var temp__4655__auto__ = (function (){var and__8174__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__8174__auto__)){
return x.call(null,new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
} else {
return and__8174__auto__;
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var value = temp__4655__auto__;
return cljs.compiler.emits.call(null,"cljs.core.",value);
} else {
return cljs.compiler.emits_symbol.call(null,x);
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant,Date,(function (date){
return cljs.compiler.emits.call(null,"new Date(",date.getTime(),")");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.call(null,"new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash.call(null,uuid_str),")");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"no-op","no-op",-93046065),(function (m){
return null;
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"var","var",-769682797),(function (p__31918){
var map__31919 = p__31918;
var map__31919__$1 = ((((!((map__31919 == null)))?((((map__31919.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31919.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31919):map__31919);
var ast = map__31919__$1;
var info = cljs.core.get.call(null,map__31919__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var env = cljs.core.get.call(null,map__31919__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var form = cljs.core.get.call(null,map__31919__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var temp__4655__auto__ = new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292).cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__4655__auto__)){
var const_expr = temp__4655__auto__;
return cljs.compiler.emit.call(null,cljs.core.assoc.call(null,const_expr,new cljs.core.Keyword(null,"env","env",-1815813235),env));
} else {
var map__31921 = cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_);
var map__31921__$1 = ((((!((map__31921 == null)))?((((map__31921.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31921.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31921):map__31921);
var cenv = map__31921__$1;
var options = cljs.core.get.call(null,map__31921__$1,new cljs.core.Keyword(null,"options","options",99638489));
var var_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.call(null,cljs.core.namespace.call(null,var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.call(null,cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-module-index","js-module-index",2072061931),cljs.core.name.call(null,var_name),new cljs.core.Keyword(null,"name","name",1843675177)], null));
var or__8186__auto__ = js_module_name;
if(cljs.core.truth_(or__8186__auto__)){
return or__8186__auto__;
} else {
return cljs.core.name.call(null,var_name);
}
})():info);
if(cljs.core.truth_(new cljs.core.Keyword(null,"binding-form?","binding-form?",1728940169).cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,ast));
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__31923 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__8174__auto__ = cljs.compiler.es5_GT__EQ_.call(null,new cljs.core.Keyword(null,"language-out","language-out",334619882).cljs$core$IFn$_invoke$arity$1(options));
if(cljs.core.truth_(and__8174__auto__)){
return !((cljs.core.namespace.call(null,var_name) == null));
} else {
return and__8174__auto__;
}
})())){
return clojure.set.difference.call(null,G__31923,cljs.analyzer.es5_allowed);
} else {
return G__31923;
}
})();
var env__31804__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__31804__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,(function (){var G__31924 = info__$1;
if(cljs.core.not_EQ_.call(null,form,new cljs.core.Symbol("js","-Infinity","js/-Infinity",958706333,null))){
return cljs.compiler.munge.call(null,G__31924,reserved);
} else {
return G__31924;
}
})());

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__31804__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"var-special","var-special",1131576802),(function (p__31925){
var map__31926 = p__31925;
var map__31926__$1 = ((((!((map__31926 == null)))?((((map__31926.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31926.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31926):map__31926);
var arg = map__31926__$1;
var env = cljs.core.get.call(null,map__31926__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var var$ = cljs.core.get.call(null,map__31926__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var sym = cljs.core.get.call(null,map__31926__$1,new cljs.core.Keyword(null,"sym","sym",-1444860305));
var meta = cljs.core.get.call(null,map__31926__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
if(cljs.analyzer.ast_QMARK_.call(null,sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_.call(null,meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__31928 = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(var$);
var map__31928__$1 = ((((!((map__31928 == null)))?((((map__31928.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31928.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31928):map__31928);
var name = cljs.core.get.call(null,map__31928__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env__31804__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__31804__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"new cljs.core.Var(function(){return ",cljs.compiler.munge.call(null,name),";},",sym,",",meta,")");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__31804__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"meta","meta",1499536964),(function (p__31930){
var map__31931 = p__31930;
var map__31931__$1 = ((((!((map__31931 == null)))?((((map__31931.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31931.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31931):map__31931);
var expr = cljs.core.get.call(null,map__31931__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var meta = cljs.core.get.call(null,map__31931__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var env = cljs.core.get.call(null,map__31931__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__31804__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__31804__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"cljs.core.with_meta(",expr,",",meta,")");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__31804__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.array_map_threshold = (8);
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
return (cljs.core.every_QMARK_.call(null,(function (p1__31933_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__31933_SHARP_),new cljs.core.Keyword(null,"constant","constant",-379609303));
}),keys)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,keys)),cljs.core.count.call(null,keys)));
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"map","map",1371690461),(function (p__31934){
var map__31935 = p__31934;
var map__31935__$1 = ((((!((map__31935 == null)))?((((map__31935.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31935.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31935):map__31935);
var env = cljs.core.get.call(null,map__31935__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var keys = cljs.core.get.call(null,map__31935__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.call(null,map__31935__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env__31804__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__31804__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if((cljs.core.count.call(null,keys) === (0))){
cljs.compiler.emits.call(null,"cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count.call(null,keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_(cljs.compiler.distinct_keys_QMARK_.call(null,keys))){
cljs.compiler.emits.call(null,"new cljs.core.PersistentArrayMap(null, ",cljs.core.count.call(null,keys),", [",cljs.compiler.comma_sep.call(null,cljs.core.interleave.call(null,keys,vals)),"], null)");
} else {
cljs.compiler.emits.call(null,"cljs.core.PersistentArrayMap.createAsIfByAssoc([",cljs.compiler.comma_sep.call(null,cljs.core.interleave.call(null,keys,vals)),"])");
}
} else {
cljs.compiler.emits.call(null,"cljs.core.PersistentHashMap.fromArrays([",cljs.compiler.comma_sep.call(null,keys),"],[",cljs.compiler.comma_sep.call(null,vals),"])");

}
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__31804__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"list","list",765357683),(function (p__31937){
var map__31938 = p__31937;
var map__31938__$1 = ((((!((map__31938 == null)))?((((map__31938.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31938.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31938):map__31938);
var items = cljs.core.get.call(null,map__31938__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__31938__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__31804__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__31804__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.empty_QMARK_.call(null,items)){
cljs.compiler.emits.call(null,"cljs.core.List.EMPTY");
} else {
cljs.compiler.emits.call(null,"cljs.core.list(",cljs.compiler.comma_sep.call(null,items),")");
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__31804__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"vector","vector",1902966158),(function (p__31940){
var map__31941 = p__31940;
var map__31941__$1 = ((((!((map__31941 == null)))?((((map__31941.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31941.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31941):map__31941);
var items = cljs.core.get.call(null,map__31941__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__31941__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__31804__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__31804__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.empty_QMARK_.call(null,items)){
cljs.compiler.emits.call(null,"cljs.core.PersistentVector.EMPTY");
} else {
var cnt_31943 = cljs.core.count.call(null,items);
if((cnt_31943 < (32))){
cljs.compiler.emits.call(null,"new cljs.core.PersistentVector(null, ",cnt_31943,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",cljs.compiler.comma_sep.call(null,items),"], null)");
} else {
cljs.compiler.emits.call(null,"cljs.core.PersistentVector.fromArray([",cljs.compiler.comma_sep.call(null,items),"], true)");
}
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__31804__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
return (cljs.core.every_QMARK_.call(null,(function (p1__31944_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__31944_SHARP_),new cljs.core.Keyword(null,"constant","constant",-379609303));
}),items)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,items)),cljs.core.count.call(null,items)));
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"set","set",304602554),(function (p__31945){
var map__31946 = p__31945;
var map__31946__$1 = ((((!((map__31946 == null)))?((((map__31946.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31946.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31946):map__31946);
var items = cljs.core.get.call(null,map__31946__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__31946__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__31804__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__31804__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.empty_QMARK_.call(null,items)){
cljs.compiler.emits.call(null,"cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_(cljs.compiler.distinct_constants_QMARK_.call(null,items))){
cljs.compiler.emits.call(null,"new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count.call(null,items),", [",cljs.compiler.comma_sep.call(null,cljs.core.interleave.call(null,items,cljs.core.repeat.call(null,"null"))),"], null), null)");
} else {
cljs.compiler.emits.call(null,"cljs.core.PersistentHashSet.createAsIfByAssoc([",cljs.compiler.comma_sep.call(null,items),"])");

}
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__31804__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js-value","js-value",-758336661),(function (p__31948){
var map__31949 = p__31948;
var map__31949__$1 = ((((!((map__31949 == null)))?((((map__31949.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31949.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31949):map__31949);
var items = cljs.core.get.call(null,map__31949__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var js_type = cljs.core.get.call(null,map__31949__$1,new cljs.core.Keyword(null,"js-type","js-type",539386702));
var env = cljs.core.get.call(null,map__31949__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__31804__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__31804__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core._EQ_.call(null,js_type,new cljs.core.Keyword(null,"object","object",1474613949))){
cljs.compiler.emits.call(null,"({");

var temp__4657__auto___31967 = cljs.core.seq.call(null,items);
if(temp__4657__auto___31967){
var items_31968__$1 = temp__4657__auto___31967;
var vec__31951_31969 = items_31968__$1;
var seq__31952_31970 = cljs.core.seq.call(null,vec__31951_31969);
var first__31953_31971 = cljs.core.first.call(null,seq__31952_31970);
var seq__31952_31972__$1 = cljs.core.next.call(null,seq__31952_31970);
var vec__31954_31973 = first__31953_31971;
var k_31974 = cljs.core.nth.call(null,vec__31954_31973,(0),null);
var v_31975 = cljs.core.nth.call(null,vec__31954_31973,(1),null);
var r_31976 = seq__31952_31972__$1;
cljs.compiler.emits.call(null,"\"",cljs.core.name.call(null,k_31974),"\": ",v_31975);

var seq__31957_31977 = cljs.core.seq.call(null,r_31976);
var chunk__31958_31978 = null;
var count__31959_31979 = (0);
var i__31960_31980 = (0);
while(true){
if((i__31960_31980 < count__31959_31979)){
var vec__31961_31981 = cljs.core._nth.call(null,chunk__31958_31978,i__31960_31980);
var k_31982__$1 = cljs.core.nth.call(null,vec__31961_31981,(0),null);
var v_31983__$1 = cljs.core.nth.call(null,vec__31961_31981,(1),null);
cljs.compiler.emits.call(null,", \"",cljs.core.name.call(null,k_31982__$1),"\": ",v_31983__$1);

var G__31984 = seq__31957_31977;
var G__31985 = chunk__31958_31978;
var G__31986 = count__31959_31979;
var G__31987 = (i__31960_31980 + (1));
seq__31957_31977 = G__31984;
chunk__31958_31978 = G__31985;
count__31959_31979 = G__31986;
i__31960_31980 = G__31987;
continue;
} else {
var temp__4657__auto___31988__$1 = cljs.core.seq.call(null,seq__31957_31977);
if(temp__4657__auto___31988__$1){
var seq__31957_31989__$1 = temp__4657__auto___31988__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31957_31989__$1)){
var c__9025__auto___31990 = cljs.core.chunk_first.call(null,seq__31957_31989__$1);
var G__31991 = cljs.core.chunk_rest.call(null,seq__31957_31989__$1);
var G__31992 = c__9025__auto___31990;
var G__31993 = cljs.core.count.call(null,c__9025__auto___31990);
var G__31994 = (0);
seq__31957_31977 = G__31991;
chunk__31958_31978 = G__31992;
count__31959_31979 = G__31993;
i__31960_31980 = G__31994;
continue;
} else {
var vec__31964_31995 = cljs.core.first.call(null,seq__31957_31989__$1);
var k_31996__$1 = cljs.core.nth.call(null,vec__31964_31995,(0),null);
var v_31997__$1 = cljs.core.nth.call(null,vec__31964_31995,(1),null);
cljs.compiler.emits.call(null,", \"",cljs.core.name.call(null,k_31996__$1),"\": ",v_31997__$1);

var G__31998 = cljs.core.next.call(null,seq__31957_31989__$1);
var G__31999 = null;
var G__32000 = (0);
var G__32001 = (0);
seq__31957_31977 = G__31998;
chunk__31958_31978 = G__31999;
count__31959_31979 = G__32000;
i__31960_31980 = G__32001;
continue;
}
} else {
}
}
break;
}
} else {
}

cljs.compiler.emits.call(null,"})");
} else {
cljs.compiler.emits.call(null,"[",cljs.compiler.comma_sep.call(null,items),"]");
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__31804__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"record-value","record-value",-367500392),(function (p__32002){
var map__32003 = p__32002;
var map__32003__$1 = ((((!((map__32003 == null)))?((((map__32003.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32003.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32003):map__32003);
var items = cljs.core.get.call(null,map__32003__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var ns = cljs.core.get.call(null,map__32003__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var name = cljs.core.get.call(null,map__32003__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.call(null,map__32003__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__31804__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__31804__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,ns,".map__GT_",name,"(",items,")");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__31804__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"constant","constant",-379609303),(function (p__32005){
var map__32006 = p__32005;
var map__32006__$1 = ((((!((map__32006 == null)))?((((map__32006.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32006.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32006):map__32006);
var form = cljs.core.get.call(null,map__32006__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var env = cljs.core.get.call(null,map__32006__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__31804__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__31804__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_constant.call(null,form);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__31804__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(p__32008){
var map__32009 = p__32008;
var map__32009__$1 = ((((!((map__32009 == null)))?((((map__32009.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32009.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32009):map__32009);
var op = cljs.core.get.call(null,map__32009__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.call(null,map__32009__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.call(null,map__32009__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__8186__auto__ = (function (){var and__8174__auto__ = cljs.core._EQ_.call(null,op,new cljs.core.Keyword(null,"constant","constant",-379609303));
if(and__8174__auto__){
var and__8174__auto____$1 = form;
if(cljs.core.truth_(and__8174__auto____$1)){
return !(((typeof form === 'string') && (cljs.core._EQ_.call(null,form,""))) || ((typeof form === 'number') && ((form === (0)))));
} else {
return and__8174__auto____$1;
}
} else {
return and__8174__auto__;
}
})();
if(cljs.core.truth_(or__8186__auto__)){
return or__8186__auto__;
} else {
var and__8174__auto__ = !((const_expr == null));
if(and__8174__auto__){
return cljs.compiler.truthy_constant_QMARK_.call(null,const_expr);
} else {
return and__8174__auto__;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(p__32011){
var map__32012 = p__32011;
var map__32012__$1 = ((((!((map__32012 == null)))?((((map__32012.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32012.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32012):map__32012);
var op = cljs.core.get.call(null,map__32012__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.call(null,map__32012__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.call(null,map__32012__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__8186__auto__ = (cljs.core._EQ_.call(null,op,new cljs.core.Keyword(null,"constant","constant",-379609303))) && ((form === false) || ((form == null)));
if(or__8186__auto__){
return or__8186__auto__;
} else {
var and__8174__auto__ = !((const_expr == null));
if(and__8174__auto__){
return cljs.compiler.falsey_constant_QMARK_.call(null,const_expr);
} else {
return and__8174__auto__;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag.call(null,env,e);
var or__8186__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null], null), null).call(null,tag);
if(cljs.core.truth_(or__8186__auto__)){
return or__8186__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_.call(null,e);
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"if","if",-458814265),(function (p__32014){
var map__32015 = p__32014;
var map__32015__$1 = ((((!((map__32015 == null)))?((((map__32015.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32015.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32015):map__32015);
var test = cljs.core.get.call(null,map__32015__$1,new cljs.core.Keyword(null,"test","test",577538877));
var then = cljs.core.get.call(null,map__32015__$1,new cljs.core.Keyword(null,"then","then",460598070));
var else$ = cljs.core.get.call(null,map__32015__$1,new cljs.core.Keyword(null,"else","else",-1508377146));
var env = cljs.core.get.call(null,map__32015__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var unchecked = cljs.core.get.call(null,map__32015__$1,new cljs.core.Keyword(null,"unchecked","unchecked",924418378));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not.call(null,(function (){var or__8186__auto__ = unchecked;
if(cljs.core.truth_(or__8186__auto__)){
return or__8186__auto__;
} else {
return cljs.compiler.safe_test_QMARK_.call(null,env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_.call(null,test))){
return cljs.compiler.emitln.call(null,then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_.call(null,test))){
return cljs.compiler.emitln.call(null,else$);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"(",((checked)?"cljs.core.truth_":null),"(",test,")?",then,":",else$,")");
} else {
if(checked){
cljs.compiler.emitln.call(null,"if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.call(null,"if(",test,"){");
}

cljs.compiler.emitln.call(null,then,"} else {");

return cljs.compiler.emitln.call(null,else$,"}");
}

}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"case*","case*",716180697),(function (p__32017){
var map__32018 = p__32017;
var map__32018__$1 = ((((!((map__32018 == null)))?((((map__32018.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32018.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32018):map__32018);
var v = cljs.core.get.call(null,map__32018__$1,new cljs.core.Keyword(null,"v","v",21465059));
var tests = cljs.core.get.call(null,map__32018__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var thens = cljs.core.get.call(null,map__32018__$1,new cljs.core.Keyword(null,"thens","thens",226631442));
var default$ = cljs.core.get.call(null,map__32018__$1,new cljs.core.Keyword(null,"default","default",-1987822328));
var env = cljs.core.get.call(null,map__32018__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env),new cljs.core.Keyword(null,"expr","expr",745722291))){
cljs.compiler.emitln.call(null,"(function(){");
} else {
}

var gs = cljs.core.gensym.call(null,"caseval__");
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"var ",gs,";");
} else {
}

cljs.compiler.emitln.call(null,"switch (",v,") {");

var seq__32020_32038 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),cljs.core.interleave.call(null,tests,thens)));
var chunk__32021_32039 = null;
var count__32022_32040 = (0);
var i__32023_32041 = (0);
while(true){
if((i__32023_32041 < count__32022_32040)){
var vec__32024_32042 = cljs.core._nth.call(null,chunk__32021_32039,i__32023_32041);
var ts_32043 = cljs.core.nth.call(null,vec__32024_32042,(0),null);
var then_32044 = cljs.core.nth.call(null,vec__32024_32042,(1),null);
var seq__32027_32045 = cljs.core.seq.call(null,ts_32043);
var chunk__32028_32046 = null;
var count__32029_32047 = (0);
var i__32030_32048 = (0);
while(true){
if((i__32030_32048 < count__32029_32047)){
var test_32049 = cljs.core._nth.call(null,chunk__32028_32046,i__32030_32048);
cljs.compiler.emitln.call(null,"case ",test_32049,":");

var G__32050 = seq__32027_32045;
var G__32051 = chunk__32028_32046;
var G__32052 = count__32029_32047;
var G__32053 = (i__32030_32048 + (1));
seq__32027_32045 = G__32050;
chunk__32028_32046 = G__32051;
count__32029_32047 = G__32052;
i__32030_32048 = G__32053;
continue;
} else {
var temp__4657__auto___32054 = cljs.core.seq.call(null,seq__32027_32045);
if(temp__4657__auto___32054){
var seq__32027_32055__$1 = temp__4657__auto___32054;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32027_32055__$1)){
var c__9025__auto___32056 = cljs.core.chunk_first.call(null,seq__32027_32055__$1);
var G__32057 = cljs.core.chunk_rest.call(null,seq__32027_32055__$1);
var G__32058 = c__9025__auto___32056;
var G__32059 = cljs.core.count.call(null,c__9025__auto___32056);
var G__32060 = (0);
seq__32027_32045 = G__32057;
chunk__32028_32046 = G__32058;
count__32029_32047 = G__32059;
i__32030_32048 = G__32060;
continue;
} else {
var test_32061 = cljs.core.first.call(null,seq__32027_32055__$1);
cljs.compiler.emitln.call(null,"case ",test_32061,":");

var G__32062 = cljs.core.next.call(null,seq__32027_32055__$1);
var G__32063 = null;
var G__32064 = (0);
var G__32065 = (0);
seq__32027_32045 = G__32062;
chunk__32028_32046 = G__32063;
count__32029_32047 = G__32064;
i__32030_32048 = G__32065;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",then_32044);
} else {
cljs.compiler.emitln.call(null,then_32044);
}

cljs.compiler.emitln.call(null,"break;");

var G__32066 = seq__32020_32038;
var G__32067 = chunk__32021_32039;
var G__32068 = count__32022_32040;
var G__32069 = (i__32023_32041 + (1));
seq__32020_32038 = G__32066;
chunk__32021_32039 = G__32067;
count__32022_32040 = G__32068;
i__32023_32041 = G__32069;
continue;
} else {
var temp__4657__auto___32070 = cljs.core.seq.call(null,seq__32020_32038);
if(temp__4657__auto___32070){
var seq__32020_32071__$1 = temp__4657__auto___32070;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32020_32071__$1)){
var c__9025__auto___32072 = cljs.core.chunk_first.call(null,seq__32020_32071__$1);
var G__32073 = cljs.core.chunk_rest.call(null,seq__32020_32071__$1);
var G__32074 = c__9025__auto___32072;
var G__32075 = cljs.core.count.call(null,c__9025__auto___32072);
var G__32076 = (0);
seq__32020_32038 = G__32073;
chunk__32021_32039 = G__32074;
count__32022_32040 = G__32075;
i__32023_32041 = G__32076;
continue;
} else {
var vec__32031_32077 = cljs.core.first.call(null,seq__32020_32071__$1);
var ts_32078 = cljs.core.nth.call(null,vec__32031_32077,(0),null);
var then_32079 = cljs.core.nth.call(null,vec__32031_32077,(1),null);
var seq__32034_32080 = cljs.core.seq.call(null,ts_32078);
var chunk__32035_32081 = null;
var count__32036_32082 = (0);
var i__32037_32083 = (0);
while(true){
if((i__32037_32083 < count__32036_32082)){
var test_32084 = cljs.core._nth.call(null,chunk__32035_32081,i__32037_32083);
cljs.compiler.emitln.call(null,"case ",test_32084,":");

var G__32085 = seq__32034_32080;
var G__32086 = chunk__32035_32081;
var G__32087 = count__32036_32082;
var G__32088 = (i__32037_32083 + (1));
seq__32034_32080 = G__32085;
chunk__32035_32081 = G__32086;
count__32036_32082 = G__32087;
i__32037_32083 = G__32088;
continue;
} else {
var temp__4657__auto___32089__$1 = cljs.core.seq.call(null,seq__32034_32080);
if(temp__4657__auto___32089__$1){
var seq__32034_32090__$1 = temp__4657__auto___32089__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32034_32090__$1)){
var c__9025__auto___32091 = cljs.core.chunk_first.call(null,seq__32034_32090__$1);
var G__32092 = cljs.core.chunk_rest.call(null,seq__32034_32090__$1);
var G__32093 = c__9025__auto___32091;
var G__32094 = cljs.core.count.call(null,c__9025__auto___32091);
var G__32095 = (0);
seq__32034_32080 = G__32092;
chunk__32035_32081 = G__32093;
count__32036_32082 = G__32094;
i__32037_32083 = G__32095;
continue;
} else {
var test_32096 = cljs.core.first.call(null,seq__32034_32090__$1);
cljs.compiler.emitln.call(null,"case ",test_32096,":");

var G__32097 = cljs.core.next.call(null,seq__32034_32090__$1);
var G__32098 = null;
var G__32099 = (0);
var G__32100 = (0);
seq__32034_32080 = G__32097;
chunk__32035_32081 = G__32098;
count__32036_32082 = G__32099;
i__32037_32083 = G__32100;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",then_32079);
} else {
cljs.compiler.emitln.call(null,then_32079);
}

cljs.compiler.emitln.call(null,"break;");

var G__32101 = cljs.core.next.call(null,seq__32020_32071__$1);
var G__32102 = null;
var G__32103 = (0);
var G__32104 = (0);
seq__32020_32038 = G__32101;
chunk__32021_32039 = G__32102;
count__32022_32040 = G__32103;
i__32023_32041 = G__32104;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.call(null,"default:");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",default$);
} else {
cljs.compiler.emitln.call(null,default$);
}
} else {
}

cljs.compiler.emitln.call(null,"}");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.call(null,"return ",gs,";})()");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"throw","throw",-1044625833),(function (p__32105){
var map__32106 = p__32105;
var map__32106__$1 = ((((!((map__32106 == null)))?((((map__32106.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32106.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32106):map__32106);
var throw$ = cljs.core.get.call(null,map__32106__$1,new cljs.core.Keyword(null,"throw","throw",-1044625833));
var env = cljs.core.get.call(null,map__32106__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.call(null,"(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.call(null,"throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.call(null,cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.call(null,cljs.compiler.mapped_types,t))){
return cljs.core.get.call(null,cljs.compiler.mapped_types,t);
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"!"))){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.resolve_type.call(null,env,cljs.core.subs.call(null,t,(1))))].join('');
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"{"))){
return t;
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"function"))){
var idx = t.lastIndexOf(":");
var vec__32109 = ((!(((-1) === idx)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.call(null,t,(0),idx),cljs.core.subs.call(null,t,(idx + (1)),cljs.core.count.call(null,t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.call(null,vec__32109,(0),null);
var rstr = cljs.core.nth.call(null,vec__32109,(1),null);
var ret_t = (cljs.core.truth_(rstr)?cljs.compiler.resolve_type.call(null,env,rstr):null);
var axstr = cljs.core.subs.call(null,fstr,(9),(cljs.core.count.call(null,fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_.call(null,axstr))?null:cljs.core.map.call(null,cljs.core.comp.call(null,((function (idx,vec__32109,fstr,rstr,ret_t,axstr){
return (function (p1__32108_SHARP_){
return cljs.compiler.resolve_type.call(null,env,p1__32108_SHARP_);
});})(idx,vec__32109,fstr,rstr,ret_t,axstr))
,clojure.string.trim),clojure.string.split.call(null,axstr,/,/)));
var G__32112 = ["function(",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.call(null,",",args_ts)),")"].join('');
if(cljs.core.truth_(ret_t)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__32112),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__32112;
}
} else {
if(cljs.core.truth_(goog.string.endsWith(t,"="))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.resolve_type.call(null,env,cljs.core.subs.call(null,t,(0),(cljs.core.count.call(null,t) - (1))))),"="].join('');
} else {
return cljs.compiler.munge.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.call(null,env,cljs.core.symbol.call(null,t))))].join(''));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.call(null,clojure.string.trim.call(null,ts),(1),(cljs.core.count.call(null,ts) - (1)));
var xs = clojure.string.split.call(null,ts__$1,/\|/);
return ["{",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.call(null,"|",cljs.core.map.call(null,((function (ts__$1,xs){
return (function (p1__32113_SHARP_){
return cljs.compiler.resolve_type.call(null,env,p1__32113_SHARP_);
});})(ts__$1,xs))
,xs))),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find.call(null,/@param/,line))){
var vec__32114 = cljs.core.map.call(null,clojure.string.trim,clojure.string.split.call(null,clojure.string.trim.call(null,line),/ /));
var seq__32115 = cljs.core.seq.call(null,vec__32114);
var first__32116 = cljs.core.first.call(null,seq__32115);
var seq__32115__$1 = cljs.core.next.call(null,seq__32115);
var p = first__32116;
var first__32116__$1 = cljs.core.first.call(null,seq__32115__$1);
var seq__32115__$2 = cljs.core.next.call(null,seq__32115__$1);
var ts = first__32116__$1;
var first__32116__$2 = cljs.core.first.call(null,seq__32115__$2);
var seq__32115__$3 = cljs.core.next.call(null,seq__32115__$2);
var n = first__32116__$2;
var xs = seq__32115__$3;
if(cljs.core.truth_((function (){var and__8174__auto__ = cljs.core._EQ_.call(null,"@param",p);
if(and__8174__auto__){
var and__8174__auto____$1 = ts;
if(cljs.core.truth_(and__8174__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__8174__auto____$1;
}
} else {
return and__8174__auto__;
}
})())){
return clojure.string.join.call(null," ",cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types.call(null,env,ts),cljs.compiler.munge.call(null,n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find.call(null,/@return/,line))){
var vec__32117 = cljs.core.map.call(null,clojure.string.trim,clojure.string.split.call(null,clojure.string.trim.call(null,line),/ /));
var seq__32118 = cljs.core.seq.call(null,vec__32117);
var first__32119 = cljs.core.first.call(null,seq__32118);
var seq__32118__$1 = cljs.core.next.call(null,seq__32118);
var p = first__32119;
var first__32119__$1 = cljs.core.first.call(null,seq__32118__$1);
var seq__32118__$2 = cljs.core.next.call(null,seq__32118__$1);
var ts = first__32119__$1;
var xs = seq__32118__$2;
if(cljs.core.truth_((function (){var and__8174__auto__ = cljs.core._EQ_.call(null,"@return",p);
if(and__8174__auto__){
var and__8174__auto____$1 = ts;
if(cljs.core.truth_(and__8174__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__8174__auto____$1;
}
} else {
return and__8174__auto__;
}
})())){
return clojure.string.join.call(null," ",cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types.call(null,env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"warning","warning",-1685650671),null,new cljs.core.Keyword(null,"error","error",-978969032),null], null), null).call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"closure-warnings","closure-warnings",1362834211),new cljs.core.Keyword(null,"check-types","check-types",-833794607)], null)));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__32122 = arguments.length;
switch (G__32122) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.call(null,null,doc,jsdoc);
});

cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.call(null,docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = ((function (docs,docs__$1,docs__$2){
return (function cljs$compiler$print_comment_lines(e){
var vec__32130 = cljs.core.map.call(null,((function (docs,docs__$1,docs__$2){
return (function (p1__32120_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_.call(null))){
return cljs.compiler.munge_param_return.call(null,env,p1__32120_SHARP_);
} else {
return p1__32120_SHARP_;
}
});})(docs,docs__$1,docs__$2))
,clojure.string.split_lines.call(null,e));
var seq__32131 = cljs.core.seq.call(null,vec__32130);
var first__32132 = cljs.core.first.call(null,seq__32131);
var seq__32131__$1 = cljs.core.next.call(null,seq__32131);
var x = first__32132;
var ys = seq__32131__$1;
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,x,"*/","* /"));

var seq__32133 = cljs.core.seq.call(null,ys);
var chunk__32134 = null;
var count__32135 = (0);
var i__32136 = (0);
while(true){
if((i__32136 < count__32135)){
var next_line = cljs.core._nth.call(null,chunk__32134,i__32136);
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,clojure.string.replace.call(null,next_line,/^   /,""),"*/","* /"));

var G__32142 = seq__32133;
var G__32143 = chunk__32134;
var G__32144 = count__32135;
var G__32145 = (i__32136 + (1));
seq__32133 = G__32142;
chunk__32134 = G__32143;
count__32135 = G__32144;
i__32136 = G__32145;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__32133);
if(temp__4657__auto__){
var seq__32133__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32133__$1)){
var c__9025__auto__ = cljs.core.chunk_first.call(null,seq__32133__$1);
var G__32146 = cljs.core.chunk_rest.call(null,seq__32133__$1);
var G__32147 = c__9025__auto__;
var G__32148 = cljs.core.count.call(null,c__9025__auto__);
var G__32149 = (0);
seq__32133 = G__32146;
chunk__32134 = G__32147;
count__32135 = G__32148;
i__32136 = G__32149;
continue;
} else {
var next_line = cljs.core.first.call(null,seq__32133__$1);
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,clojure.string.replace.call(null,next_line,/^   /,""),"*/","* /"));

var G__32150 = cljs.core.next.call(null,seq__32133__$1);
var G__32151 = null;
var G__32152 = (0);
var G__32153 = (0);
seq__32133 = G__32150;
chunk__32134 = G__32151;
count__32135 = G__32152;
i__32136 = G__32153;
continue;
}
} else {
return null;
}
}
break;
}
});})(docs,docs__$1,docs__$2))
;
if(cljs.core.seq.call(null,docs__$2)){
cljs.compiler.emitln.call(null,"/**");

var seq__32137_32154 = cljs.core.seq.call(null,docs__$2);
var chunk__32138_32155 = null;
var count__32139_32156 = (0);
var i__32140_32157 = (0);
while(true){
if((i__32140_32157 < count__32139_32156)){
var e_32158 = cljs.core._nth.call(null,chunk__32138_32155,i__32140_32157);
if(cljs.core.truth_(e_32158)){
print_comment_lines.call(null,e_32158);
} else {
}

var G__32159 = seq__32137_32154;
var G__32160 = chunk__32138_32155;
var G__32161 = count__32139_32156;
var G__32162 = (i__32140_32157 + (1));
seq__32137_32154 = G__32159;
chunk__32138_32155 = G__32160;
count__32139_32156 = G__32161;
i__32140_32157 = G__32162;
continue;
} else {
var temp__4657__auto___32163 = cljs.core.seq.call(null,seq__32137_32154);
if(temp__4657__auto___32163){
var seq__32137_32164__$1 = temp__4657__auto___32163;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32137_32164__$1)){
var c__9025__auto___32165 = cljs.core.chunk_first.call(null,seq__32137_32164__$1);
var G__32166 = cljs.core.chunk_rest.call(null,seq__32137_32164__$1);
var G__32167 = c__9025__auto___32165;
var G__32168 = cljs.core.count.call(null,c__9025__auto___32165);
var G__32169 = (0);
seq__32137_32154 = G__32166;
chunk__32138_32155 = G__32167;
count__32139_32156 = G__32168;
i__32140_32157 = G__32169;
continue;
} else {
var e_32170 = cljs.core.first.call(null,seq__32137_32164__$1);
if(cljs.core.truth_(e_32170)){
print_comment_lines.call(null,e_32170);
} else {
}

var G__32171 = cljs.core.next.call(null,seq__32137_32164__$1);
var G__32172 = null;
var G__32173 = (0);
var G__32174 = (0);
seq__32137_32154 = G__32171;
chunk__32138_32155 = G__32172;
count__32139_32156 = G__32173;
i__32140_32157 = G__32174;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.call(null," */");
} else {
return null;
}
});

cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3;

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return (typeof x === 'string') || (x === true) || (x === false) || (typeof x === 'number');
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.call(null,cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_),new cljs.core.Keyword(null,"options","options",99638489));
var and__8174__auto__ = cljs.core.some.call(null,((function (opts){
return (function (p1__32176_SHARP_){
return goog.string.startsWith(p1__32176_SHARP_,"@define");
});})(opts))
,jsdoc);
if(cljs.core.truth_(and__8174__auto__)){
var and__8174__auto____$1 = opts;
if(cljs.core.truth_(and__8174__auto____$1)){
var and__8174__auto____$2 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"none","none",1333468478));
if(and__8174__auto____$2){
var define = cljs.core.get_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"closure-defines","closure-defines",-1213856476),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)].join('')], null));
if(cljs.core.truth_(cljs.compiler.valid_define_value_QMARK_.call(null,define))){
return cljs.core.pr_str.call(null,define);
} else {
return null;
}
} else {
return and__8174__auto____$2;
}
} else {
return and__8174__auto____$1;
}
} else {
return and__8174__auto__;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"def","def",-1043430536),(function (p__32177){
var map__32178 = p__32177;
var map__32178__$1 = ((((!((map__32178 == null)))?((((map__32178.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32178.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32178):map__32178);
var name = cljs.core.get.call(null,map__32178__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var var$ = cljs.core.get.call(null,map__32178__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var init = cljs.core.get.call(null,map__32178__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
var env = cljs.core.get.call(null,map__32178__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var doc = cljs.core.get.call(null,map__32178__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var jsdoc = cljs.core.get.call(null,map__32178__$1,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516));
var export$ = cljs.core.get.call(null,map__32178__$1,new cljs.core.Keyword(null,"export","export",214356590));
var test = cljs.core.get.call(null,map__32178__$1,new cljs.core.Keyword(null,"test","test",577538877));
var var_ast = cljs.core.get.call(null,map__32178__$1,new cljs.core.Keyword(null,"var-ast","var-ast",1200379319));
if(cljs.core.truth_((function (){var or__8186__auto__ = init;
if(cljs.core.truth_(or__8186__auto__)){
return or__8186__auto__;
} else {
return new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.call(null,name);
cljs.compiler.emit_comment.call(null,env,doc,cljs.core.concat.call(null,jsdoc,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516).cljs$core$IFn$_invoke$arity$1(init)));

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"return (");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"(function (){");
} else {
}

cljs.compiler.emits.call(null,var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.call(null," = ",(function (){var temp__4655__auto__ = cljs.compiler.get_define.call(null,mname,jsdoc);
if(cljs.core.truth_(temp__4655__auto__)){
var define = temp__4655__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"; return (");

cljs.compiler.emits.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"var-special","var-special",1131576802),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.assoc.call(null,env,new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291))], null),var_ast));

cljs.compiler.emitln.call(null,");})()");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,")");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.call(null,";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.call(null,"goog.exportSymbol('",cljs.compiler.munge.call(null,export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__8174__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(and__8174__auto__){
return test;
} else {
return and__8174__auto__;
}
})())){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,";");
} else {
}

return cljs.compiler.emitln.call(null,var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__32180){
var map__32181 = p__32180;
var map__32181__$1 = ((((!((map__32181 == null)))?((((map__32181.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32181.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32181):map__32181);
var name = cljs.core.get.call(null,map__32181__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.call(null,map__32181__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.call(null,map__32181__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var arglist = cljs.core.gensym.call(null,"arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,name)),"__delegate"].join('');
cljs.compiler.emitln.call(null,"(function (",arglist,"){");

var seq__32183_32201 = cljs.core.seq.call(null,cljs.core.map_indexed.call(null,cljs.core.vector,cljs.core.drop_last.call(null,(2),params)));
var chunk__32184_32202 = null;
var count__32185_32203 = (0);
var i__32186_32204 = (0);
while(true){
if((i__32186_32204 < count__32185_32203)){
var vec__32187_32205 = cljs.core._nth.call(null,chunk__32184_32202,i__32186_32204);
var i_32206 = cljs.core.nth.call(null,vec__32187_32205,(0),null);
var param_32207 = cljs.core.nth.call(null,vec__32187_32205,(1),null);
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,param_32207);

cljs.compiler.emits.call(null," = cljs.core.first(");

cljs.compiler.emitln.call(null,arglist,");");

cljs.compiler.emitln.call(null,arglist," = cljs.core.next(",arglist,");");

var G__32208 = seq__32183_32201;
var G__32209 = chunk__32184_32202;
var G__32210 = count__32185_32203;
var G__32211 = (i__32186_32204 + (1));
seq__32183_32201 = G__32208;
chunk__32184_32202 = G__32209;
count__32185_32203 = G__32210;
i__32186_32204 = G__32211;
continue;
} else {
var temp__4657__auto___32212 = cljs.core.seq.call(null,seq__32183_32201);
if(temp__4657__auto___32212){
var seq__32183_32213__$1 = temp__4657__auto___32212;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32183_32213__$1)){
var c__9025__auto___32214 = cljs.core.chunk_first.call(null,seq__32183_32213__$1);
var G__32215 = cljs.core.chunk_rest.call(null,seq__32183_32213__$1);
var G__32216 = c__9025__auto___32214;
var G__32217 = cljs.core.count.call(null,c__9025__auto___32214);
var G__32218 = (0);
seq__32183_32201 = G__32215;
chunk__32184_32202 = G__32216;
count__32185_32203 = G__32217;
i__32186_32204 = G__32218;
continue;
} else {
var vec__32190_32219 = cljs.core.first.call(null,seq__32183_32213__$1);
var i_32220 = cljs.core.nth.call(null,vec__32190_32219,(0),null);
var param_32221 = cljs.core.nth.call(null,vec__32190_32219,(1),null);
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,param_32221);

cljs.compiler.emits.call(null," = cljs.core.first(");

cljs.compiler.emitln.call(null,arglist,");");

cljs.compiler.emitln.call(null,arglist," = cljs.core.next(",arglist,");");

var G__32222 = cljs.core.next.call(null,seq__32183_32213__$1);
var G__32223 = null;
var G__32224 = (0);
var G__32225 = (0);
seq__32183_32201 = G__32222;
chunk__32184_32202 = G__32223;
count__32185_32203 = G__32224;
i__32186_32204 = G__32225;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count.call(null,params))){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,cljs.core.butlast.call(null,params)));

cljs.compiler.emitln.call(null," = cljs.core.first(",arglist,");");

cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = cljs.core.rest(",arglist,");");

cljs.compiler.emits.call(null,"return ",delegate_name,"(");

var seq__32193_32226 = cljs.core.seq.call(null,params);
var chunk__32194_32227 = null;
var count__32195_32228 = (0);
var i__32196_32229 = (0);
while(true){
if((i__32196_32229 < count__32195_32228)){
var param_32230 = cljs.core._nth.call(null,chunk__32194_32227,i__32196_32229);
cljs.compiler.emit.call(null,param_32230);

if(cljs.core._EQ_.call(null,param_32230,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}

var G__32231 = seq__32193_32226;
var G__32232 = chunk__32194_32227;
var G__32233 = count__32195_32228;
var G__32234 = (i__32196_32229 + (1));
seq__32193_32226 = G__32231;
chunk__32194_32227 = G__32232;
count__32195_32228 = G__32233;
i__32196_32229 = G__32234;
continue;
} else {
var temp__4657__auto___32235 = cljs.core.seq.call(null,seq__32193_32226);
if(temp__4657__auto___32235){
var seq__32193_32236__$1 = temp__4657__auto___32235;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32193_32236__$1)){
var c__9025__auto___32237 = cljs.core.chunk_first.call(null,seq__32193_32236__$1);
var G__32238 = cljs.core.chunk_rest.call(null,seq__32193_32236__$1);
var G__32239 = c__9025__auto___32237;
var G__32240 = cljs.core.count.call(null,c__9025__auto___32237);
var G__32241 = (0);
seq__32193_32226 = G__32238;
chunk__32194_32227 = G__32239;
count__32195_32228 = G__32240;
i__32196_32229 = G__32241;
continue;
} else {
var param_32242 = cljs.core.first.call(null,seq__32193_32236__$1);
cljs.compiler.emit.call(null,param_32242);

if(cljs.core._EQ_.call(null,param_32242,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}

var G__32243 = cljs.core.next.call(null,seq__32193_32236__$1);
var G__32244 = null;
var G__32245 = (0);
var G__32246 = (0);
seq__32193_32226 = G__32243;
chunk__32194_32227 = G__32244;
count__32195_32228 = G__32245;
i__32196_32229 = G__32246;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,");");
} else {
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = cljs.core.seq(",arglist,");");

cljs.compiler.emits.call(null,"return ",delegate_name,"(");

var seq__32197_32247 = cljs.core.seq.call(null,params);
var chunk__32198_32248 = null;
var count__32199_32249 = (0);
var i__32200_32250 = (0);
while(true){
if((i__32200_32250 < count__32199_32249)){
var param_32251 = cljs.core._nth.call(null,chunk__32198_32248,i__32200_32250);
cljs.compiler.emit.call(null,param_32251);

if(cljs.core._EQ_.call(null,param_32251,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}

var G__32252 = seq__32197_32247;
var G__32253 = chunk__32198_32248;
var G__32254 = count__32199_32249;
var G__32255 = (i__32200_32250 + (1));
seq__32197_32247 = G__32252;
chunk__32198_32248 = G__32253;
count__32199_32249 = G__32254;
i__32200_32250 = G__32255;
continue;
} else {
var temp__4657__auto___32256 = cljs.core.seq.call(null,seq__32197_32247);
if(temp__4657__auto___32256){
var seq__32197_32257__$1 = temp__4657__auto___32256;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32197_32257__$1)){
var c__9025__auto___32258 = cljs.core.chunk_first.call(null,seq__32197_32257__$1);
var G__32259 = cljs.core.chunk_rest.call(null,seq__32197_32257__$1);
var G__32260 = c__9025__auto___32258;
var G__32261 = cljs.core.count.call(null,c__9025__auto___32258);
var G__32262 = (0);
seq__32197_32247 = G__32259;
chunk__32198_32248 = G__32260;
count__32199_32249 = G__32261;
i__32200_32250 = G__32262;
continue;
} else {
var param_32263 = cljs.core.first.call(null,seq__32197_32257__$1);
cljs.compiler.emit.call(null,param_32263);

if(cljs.core._EQ_.call(null,param_32263,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}

var G__32264 = cljs.core.next.call(null,seq__32197_32257__$1);
var G__32265 = null;
var G__32266 = (0);
var G__32267 = (0);
seq__32197_32247 = G__32264;
chunk__32198_32248 = G__32265;
count__32199_32249 = G__32266;
i__32200_32250 = G__32267;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,");");
}

return cljs.compiler.emits.call(null,"})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__32268 = cljs.core.seq.call(null,params);
var chunk__32269 = null;
var count__32270 = (0);
var i__32271 = (0);
while(true){
if((i__32271 < count__32270)){
var param = cljs.core._nth.call(null,chunk__32269,i__32271);
cljs.compiler.emit.call(null,param);

if(cljs.core._EQ_.call(null,param,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}

var G__32272 = seq__32268;
var G__32273 = chunk__32269;
var G__32274 = count__32270;
var G__32275 = (i__32271 + (1));
seq__32268 = G__32272;
chunk__32269 = G__32273;
count__32270 = G__32274;
i__32271 = G__32275;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__32268);
if(temp__4657__auto__){
var seq__32268__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32268__$1)){
var c__9025__auto__ = cljs.core.chunk_first.call(null,seq__32268__$1);
var G__32276 = cljs.core.chunk_rest.call(null,seq__32268__$1);
var G__32277 = c__9025__auto__;
var G__32278 = cljs.core.count.call(null,c__9025__auto__);
var G__32279 = (0);
seq__32268 = G__32276;
chunk__32269 = G__32277;
count__32270 = G__32278;
i__32271 = G__32279;
continue;
} else {
var param = cljs.core.first.call(null,seq__32268__$1);
cljs.compiler.emit.call(null,param);

if(cljs.core._EQ_.call(null,param,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}

var G__32280 = cljs.core.next.call(null,seq__32268__$1);
var G__32281 = null;
var G__32282 = (0);
var G__32283 = (0);
seq__32268 = G__32280;
chunk__32269 = G__32281;
count__32270 = G__32282;
i__32271 = G__32283;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__32284){
var map__32285 = p__32284;
var map__32285__$1 = ((((!((map__32285 == null)))?((((map__32285.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32285.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32285):map__32285);
var type = cljs.core.get.call(null,map__32285__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.call(null,map__32285__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var variadic = cljs.core.get.call(null,map__32285__$1,new cljs.core.Keyword(null,"variadic","variadic",882626057));
var params = cljs.core.get.call(null,map__32285__$1,new cljs.core.Keyword(null,"params","params",710516235));
var expr = cljs.core.get.call(null,map__32285__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var env = cljs.core.get.call(null,map__32285__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.call(null,map__32285__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var max_fixed_arity = cljs.core.get.call(null,map__32285__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var env__31804__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__31804__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"(function ",cljs.compiler.munge.call(null,name),"(");

cljs.compiler.emit_fn_params.call(null,params);

cljs.compiler.emitln.call(null,"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}

cljs.compiler.emits.call(null,"})");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__31804__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if(((startslice >= (0))) && (cljs.core.integer_QMARK_.call(null,startslice))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.call(null,"var ",i," = 0, ",a," = new Array(arguments.length -  ",startslice,");");

cljs.compiler.emitln.call(null,"while (",i," < ",a,".length) {",a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}");

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__32287){
var map__32288 = p__32287;
var map__32288__$1 = ((((!((map__32288 == null)))?((((map__32288.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32288.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32288):map__32288);
var f = map__32288__$1;
var type = cljs.core.get.call(null,map__32288__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.call(null,map__32288__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var variadic = cljs.core.get.call(null,map__32288__$1,new cljs.core.Keyword(null,"variadic","variadic",882626057));
var params = cljs.core.get.call(null,map__32288__$1,new cljs.core.Keyword(null,"params","params",710516235));
var expr = cljs.core.get.call(null,map__32288__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var env = cljs.core.get.call(null,map__32288__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.call(null,map__32288__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var max_fixed_arity = cljs.core.get.call(null,map__32288__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var env__31804__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__31804__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

var name_32298__$1 = (function (){var or__8186__auto__ = name;
if(cljs.core.truth_(or__8186__auto__)){
return or__8186__auto__;
} else {
return cljs.core.gensym.call(null);
}
})();
var mname_32299 = cljs.compiler.munge.call(null,name_32298__$1);
var delegate_name_32300 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_32299),"__delegate"].join('');
cljs.compiler.emitln.call(null,"(function() { ");

cljs.compiler.emits.call(null,"var ",delegate_name_32300," = function (");

var seq__32290_32301 = cljs.core.seq.call(null,params);
var chunk__32291_32302 = null;
var count__32292_32303 = (0);
var i__32293_32304 = (0);
while(true){
if((i__32293_32304 < count__32292_32303)){
var param_32305 = cljs.core._nth.call(null,chunk__32291_32302,i__32293_32304);
cljs.compiler.emit.call(null,param_32305);

if(cljs.core._EQ_.call(null,param_32305,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}

var G__32306 = seq__32290_32301;
var G__32307 = chunk__32291_32302;
var G__32308 = count__32292_32303;
var G__32309 = (i__32293_32304 + (1));
seq__32290_32301 = G__32306;
chunk__32291_32302 = G__32307;
count__32292_32303 = G__32308;
i__32293_32304 = G__32309;
continue;
} else {
var temp__4657__auto___32310 = cljs.core.seq.call(null,seq__32290_32301);
if(temp__4657__auto___32310){
var seq__32290_32311__$1 = temp__4657__auto___32310;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32290_32311__$1)){
var c__9025__auto___32312 = cljs.core.chunk_first.call(null,seq__32290_32311__$1);
var G__32313 = cljs.core.chunk_rest.call(null,seq__32290_32311__$1);
var G__32314 = c__9025__auto___32312;
var G__32315 = cljs.core.count.call(null,c__9025__auto___32312);
var G__32316 = (0);
seq__32290_32301 = G__32313;
chunk__32291_32302 = G__32314;
count__32292_32303 = G__32315;
i__32293_32304 = G__32316;
continue;
} else {
var param_32317 = cljs.core.first.call(null,seq__32290_32311__$1);
cljs.compiler.emit.call(null,param_32317);

if(cljs.core._EQ_.call(null,param_32317,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}

var G__32318 = cljs.core.next.call(null,seq__32290_32311__$1);
var G__32319 = null;
var G__32320 = (0);
var G__32321 = (0);
seq__32290_32301 = G__32318;
chunk__32291_32302 = G__32319;
count__32292_32303 = G__32320;
i__32293_32304 = G__32321;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}

cljs.compiler.emitln.call(null,"};");

cljs.compiler.emitln.call(null,"var ",mname_32299," = function (",cljs.compiler.comma_sep.call(null,(cljs.core.truth_(variadic)?cljs.core.concat.call(null,cljs.core.butlast.call(null,params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",(cljs.core.count.call(null,params) - (1)),") {");

var a_32322 = cljs.compiler.emit_arguments_to_array.call(null,(cljs.core.count.call(null,params) - (1)));
cljs.compiler.emitln.call(null,"  ",cljs.core.last.call(null,params)," = new cljs.core.IndexedSeq(",a_32322,",0,null);");

cljs.compiler.emitln.call(null,"} ");
} else {
}

cljs.compiler.emits.call(null,"return ",delegate_name_32300,".call(this,");

var seq__32294_32323 = cljs.core.seq.call(null,params);
var chunk__32295_32324 = null;
var count__32296_32325 = (0);
var i__32297_32326 = (0);
while(true){
if((i__32297_32326 < count__32296_32325)){
var param_32327 = cljs.core._nth.call(null,chunk__32295_32324,i__32297_32326);
cljs.compiler.emit.call(null,param_32327);

if(cljs.core._EQ_.call(null,param_32327,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}

var G__32328 = seq__32294_32323;
var G__32329 = chunk__32295_32324;
var G__32330 = count__32296_32325;
var G__32331 = (i__32297_32326 + (1));
seq__32294_32323 = G__32328;
chunk__32295_32324 = G__32329;
count__32296_32325 = G__32330;
i__32297_32326 = G__32331;
continue;
} else {
var temp__4657__auto___32332 = cljs.core.seq.call(null,seq__32294_32323);
if(temp__4657__auto___32332){
var seq__32294_32333__$1 = temp__4657__auto___32332;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32294_32333__$1)){
var c__9025__auto___32334 = cljs.core.chunk_first.call(null,seq__32294_32333__$1);
var G__32335 = cljs.core.chunk_rest.call(null,seq__32294_32333__$1);
var G__32336 = c__9025__auto___32334;
var G__32337 = cljs.core.count.call(null,c__9025__auto___32334);
var G__32338 = (0);
seq__32294_32323 = G__32335;
chunk__32295_32324 = G__32336;
count__32296_32325 = G__32337;
i__32297_32326 = G__32338;
continue;
} else {
var param_32339 = cljs.core.first.call(null,seq__32294_32333__$1);
cljs.compiler.emit.call(null,param_32339);

if(cljs.core._EQ_.call(null,param_32339,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}

var G__32340 = cljs.core.next.call(null,seq__32294_32333__$1);
var G__32341 = null;
var G__32342 = (0);
var G__32343 = (0);
seq__32294_32323 = G__32340;
chunk__32295_32324 = G__32341;
count__32296_32325 = G__32342;
i__32297_32326 = G__32343;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.call(null,");");

cljs.compiler.emitln.call(null,"};");

cljs.compiler.emitln.call(null,mname_32299,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.call(null,mname_32299,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to.call(null,cljs.core.assoc.call(null,f,new cljs.core.Keyword(null,"name","name",1843675177),name_32298__$1));

cljs.compiler.emitln.call(null,";");

cljs.compiler.emitln.call(null,mname_32299,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_32300,";");

cljs.compiler.emitln.call(null,"return ",mname_32299,";");

cljs.compiler.emitln.call(null,"})()");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__31804__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (p__32347){
var map__32348 = p__32347;
var map__32348__$1 = ((((!((map__32348 == null)))?((((map__32348.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32348.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32348):map__32348);
var name = cljs.core.get.call(null,map__32348__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.call(null,map__32348__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var methods$ = cljs.core.get.call(null,map__32348__$1,new cljs.core.Keyword(null,"methods","methods",453930866));
var max_fixed_arity = cljs.core.get.call(null,map__32348__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var variadic = cljs.core.get.call(null,map__32348__$1,new cljs.core.Keyword(null,"variadic","variadic",882626057));
var recur_frames = cljs.core.get.call(null,map__32348__$1,new cljs.core.Keyword(null,"recur-frames","recur-frames",-307205196));
var loop_lets = cljs.core.get.call(null,map__32348__$1,new cljs.core.Keyword(null,"loop-lets","loop-lets",2036794185));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var loop_locals = cljs.core.seq.call(null,cljs.core.map.call(null,cljs.compiler.munge,cljs.core.concat.call(null,cljs.core.mapcat.call(null,new cljs.core.Keyword(null,"params","params",710516235),cljs.core.filter.call(null,((function (map__32348,map__32348__$1,name,env,methods$,max_fixed_arity,variadic,recur_frames,loop_lets){
return (function (p1__32344_SHARP_){
var and__8174__auto__ = p1__32344_SHARP_;
if(cljs.core.truth_(and__8174__auto__)){
return cljs.core.deref.call(null,new cljs.core.Keyword(null,"flag","flag",1088647881).cljs$core$IFn$_invoke$arity$1(p1__32344_SHARP_));
} else {
return and__8174__auto__;
}
});})(map__32348,map__32348__$1,name,env,methods$,max_fixed_arity,variadic,recur_frames,loop_lets))
,recur_frames)),cljs.core.mapcat.call(null,new cljs.core.Keyword(null,"params","params",710516235),loop_lets))));
if(loop_locals){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emitln.call(null,"((function (",cljs.compiler.comma_sep.call(null,cljs.core.map.call(null,cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.call(null,"return ");
}
} else {
}

if(cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method.call(null,cljs.core.assoc.call(null,cljs.core.first.call(null,methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
} else {
cljs.compiler.emit_fn_method.call(null,cljs.core.assoc.call(null,cljs.core.first.call(null,methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
}
} else {
var name_32383__$1 = (function (){var or__8186__auto__ = name;
if(cljs.core.truth_(or__8186__auto__)){
return or__8186__auto__;
} else {
return cljs.core.gensym.call(null);
}
})();
var mname_32384 = cljs.compiler.munge.call(null,name_32383__$1);
var maxparams_32385 = cljs.core.apply.call(null,cljs.core.max_key,cljs.core.count,cljs.core.map.call(null,new cljs.core.Keyword(null,"params","params",710516235),methods$));
var mmap_32386 = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,((function (name_32383__$1,mname_32384,maxparams_32385,loop_locals,map__32348,map__32348__$1,name,env,methods$,max_fixed_arity,variadic,recur_frames,loop_lets){
return (function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.call(null,cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_32384),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
});})(name_32383__$1,mname_32384,maxparams_32385,loop_locals,map__32348,map__32348__$1,name,env,methods$,max_fixed_arity,variadic,recur_frames,loop_lets))
,methods$));
var ms_32387 = cljs.core.sort_by.call(null,((function (name_32383__$1,mname_32384,maxparams_32385,mmap_32386,loop_locals,map__32348,map__32348__$1,name,env,methods$,max_fixed_arity,variadic,recur_frames,loop_lets){
return (function (p1__32345_SHARP_){
return cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,p1__32345_SHARP_)));
});})(name_32383__$1,mname_32384,maxparams_32385,mmap_32386,loop_locals,map__32348,map__32348__$1,name,env,methods$,max_fixed_arity,variadic,recur_frames,loop_lets))
,cljs.core.seq.call(null,mmap_32386));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emitln.call(null,"(function() {");

cljs.compiler.emitln.call(null,"var ",mname_32384," = null;");

var seq__32350_32388 = cljs.core.seq.call(null,ms_32387);
var chunk__32351_32389 = null;
var count__32352_32390 = (0);
var i__32353_32391 = (0);
while(true){
if((i__32353_32391 < count__32352_32390)){
var vec__32354_32392 = cljs.core._nth.call(null,chunk__32351_32389,i__32353_32391);
var n_32393 = cljs.core.nth.call(null,vec__32354_32392,(0),null);
var meth_32394 = cljs.core.nth.call(null,vec__32354_32392,(1),null);
cljs.compiler.emits.call(null,"var ",n_32393," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic","variadic",882626057).cljs$core$IFn$_invoke$arity$1(meth_32394))){
cljs.compiler.emit_variadic_fn_method.call(null,meth_32394);
} else {
cljs.compiler.emit_fn_method.call(null,meth_32394);
}

cljs.compiler.emitln.call(null,";");

var G__32395 = seq__32350_32388;
var G__32396 = chunk__32351_32389;
var G__32397 = count__32352_32390;
var G__32398 = (i__32353_32391 + (1));
seq__32350_32388 = G__32395;
chunk__32351_32389 = G__32396;
count__32352_32390 = G__32397;
i__32353_32391 = G__32398;
continue;
} else {
var temp__4657__auto___32399 = cljs.core.seq.call(null,seq__32350_32388);
if(temp__4657__auto___32399){
var seq__32350_32400__$1 = temp__4657__auto___32399;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32350_32400__$1)){
var c__9025__auto___32401 = cljs.core.chunk_first.call(null,seq__32350_32400__$1);
var G__32402 = cljs.core.chunk_rest.call(null,seq__32350_32400__$1);
var G__32403 = c__9025__auto___32401;
var G__32404 = cljs.core.count.call(null,c__9025__auto___32401);
var G__32405 = (0);
seq__32350_32388 = G__32402;
chunk__32351_32389 = G__32403;
count__32352_32390 = G__32404;
i__32353_32391 = G__32405;
continue;
} else {
var vec__32357_32406 = cljs.core.first.call(null,seq__32350_32400__$1);
var n_32407 = cljs.core.nth.call(null,vec__32357_32406,(0),null);
var meth_32408 = cljs.core.nth.call(null,vec__32357_32406,(1),null);
cljs.compiler.emits.call(null,"var ",n_32407," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic","variadic",882626057).cljs$core$IFn$_invoke$arity$1(meth_32408))){
cljs.compiler.emit_variadic_fn_method.call(null,meth_32408);
} else {
cljs.compiler.emit_fn_method.call(null,meth_32408);
}

cljs.compiler.emitln.call(null,";");

var G__32409 = cljs.core.next.call(null,seq__32350_32400__$1);
var G__32410 = null;
var G__32411 = (0);
var G__32412 = (0);
seq__32350_32388 = G__32409;
chunk__32351_32389 = G__32410;
count__32352_32390 = G__32411;
i__32353_32391 = G__32412;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,mname_32384," = function(",cljs.compiler.comma_sep.call(null,(cljs.core.truth_(variadic)?cljs.core.concat.call(null,cljs.core.butlast.call(null,maxparams_32385),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):maxparams_32385)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,maxparams_32385));

cljs.compiler.emitln.call(null," = var_args;");
} else {
}

cljs.compiler.emitln.call(null,"switch(arguments.length){");

var seq__32360_32413 = cljs.core.seq.call(null,ms_32387);
var chunk__32361_32414 = null;
var count__32362_32415 = (0);
var i__32363_32416 = (0);
while(true){
if((i__32363_32416 < count__32362_32415)){
var vec__32364_32417 = cljs.core._nth.call(null,chunk__32361_32414,i__32363_32416);
var n_32418 = cljs.core.nth.call(null,vec__32364_32417,(0),null);
var meth_32419 = cljs.core.nth.call(null,vec__32364_32417,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic","variadic",882626057).cljs$core$IFn$_invoke$arity$1(meth_32419))){
cljs.compiler.emitln.call(null,"default:");

var restarg_32420 = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
cljs.compiler.emitln.call(null,"var ",restarg_32420," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",max_fixed_arity,") {");

var a_32421 = cljs.compiler.emit_arguments_to_array.call(null,max_fixed_arity);
cljs.compiler.emitln.call(null,restarg_32420," = new cljs.core.IndexedSeq(",a_32421,",0,null);");

cljs.compiler.emitln.call(null,"}");

cljs.compiler.emitln.call(null,"return ",n_32418,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep.call(null,cljs.core.butlast.call(null,maxparams_32385)),(((cljs.core.count.call(null,maxparams_32385) > (1)))?", ":null),restarg_32420,");");
} else {
var pcnt_32422 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_32419));
cljs.compiler.emitln.call(null,"case ",pcnt_32422,":");

cljs.compiler.emitln.call(null,"return ",n_32418,".call(this",(((pcnt_32422 === (0)))?null:cljs.core._conj.call(null,(function (){var x__9048__auto__ = cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,pcnt_32422,maxparams_32385));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),",")),");");
}

var G__32423 = seq__32360_32413;
var G__32424 = chunk__32361_32414;
var G__32425 = count__32362_32415;
var G__32426 = (i__32363_32416 + (1));
seq__32360_32413 = G__32423;
chunk__32361_32414 = G__32424;
count__32362_32415 = G__32425;
i__32363_32416 = G__32426;
continue;
} else {
var temp__4657__auto___32427 = cljs.core.seq.call(null,seq__32360_32413);
if(temp__4657__auto___32427){
var seq__32360_32428__$1 = temp__4657__auto___32427;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32360_32428__$1)){
var c__9025__auto___32429 = cljs.core.chunk_first.call(null,seq__32360_32428__$1);
var G__32430 = cljs.core.chunk_rest.call(null,seq__32360_32428__$1);
var G__32431 = c__9025__auto___32429;
var G__32432 = cljs.core.count.call(null,c__9025__auto___32429);
var G__32433 = (0);
seq__32360_32413 = G__32430;
chunk__32361_32414 = G__32431;
count__32362_32415 = G__32432;
i__32363_32416 = G__32433;
continue;
} else {
var vec__32367_32434 = cljs.core.first.call(null,seq__32360_32428__$1);
var n_32435 = cljs.core.nth.call(null,vec__32367_32434,(0),null);
var meth_32436 = cljs.core.nth.call(null,vec__32367_32434,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic","variadic",882626057).cljs$core$IFn$_invoke$arity$1(meth_32436))){
cljs.compiler.emitln.call(null,"default:");

var restarg_32437 = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
cljs.compiler.emitln.call(null,"var ",restarg_32437," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",max_fixed_arity,") {");

var a_32438 = cljs.compiler.emit_arguments_to_array.call(null,max_fixed_arity);
cljs.compiler.emitln.call(null,restarg_32437," = new cljs.core.IndexedSeq(",a_32438,",0,null);");

cljs.compiler.emitln.call(null,"}");

cljs.compiler.emitln.call(null,"return ",n_32435,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep.call(null,cljs.core.butlast.call(null,maxparams_32385)),(((cljs.core.count.call(null,maxparams_32385) > (1)))?", ":null),restarg_32437,");");
} else {
var pcnt_32439 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_32436));
cljs.compiler.emitln.call(null,"case ",pcnt_32439,":");

cljs.compiler.emitln.call(null,"return ",n_32435,".call(this",(((pcnt_32439 === (0)))?null:cljs.core._conj.call(null,(function (){var x__9048__auto__ = cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,pcnt_32439,maxparams_32385));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9048__auto__);
})(),",")),");");
}

var G__32440 = cljs.core.next.call(null,seq__32360_32428__$1);
var G__32441 = null;
var G__32442 = (0);
var G__32443 = (0);
seq__32360_32413 = G__32440;
chunk__32361_32414 = G__32441;
count__32362_32415 = G__32442;
i__32363_32416 = G__32443;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"}");

cljs.compiler.emitln.call(null,"throw(new Error('Invalid arity: ' + (arguments.length - 1)));");

cljs.compiler.emitln.call(null,"};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.call(null,mname_32384,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.call(null,mname_32384,".cljs$lang$applyTo = ",cljs.core.some.call(null,((function (name_32383__$1,mname_32384,maxparams_32385,mmap_32386,ms_32387,loop_locals,map__32348,map__32348__$1,name,env,methods$,max_fixed_arity,variadic,recur_frames,loop_lets){
return (function (p1__32346_SHARP_){
var vec__32370 = p1__32346_SHARP_;
var n = cljs.core.nth.call(null,vec__32370,(0),null);
var m = cljs.core.nth.call(null,vec__32370,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic","variadic",882626057).cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
});})(name_32383__$1,mname_32384,maxparams_32385,mmap_32386,ms_32387,loop_locals,map__32348,map__32348__$1,name,env,methods$,max_fixed_arity,variadic,recur_frames,loop_lets))
,ms_32387),".cljs$lang$applyTo;");
} else {
}

var seq__32373_32444 = cljs.core.seq.call(null,ms_32387);
var chunk__32374_32445 = null;
var count__32375_32446 = (0);
var i__32376_32447 = (0);
while(true){
if((i__32376_32447 < count__32375_32446)){
var vec__32377_32448 = cljs.core._nth.call(null,chunk__32374_32445,i__32376_32447);
var n_32449 = cljs.core.nth.call(null,vec__32377_32448,(0),null);
var meth_32450 = cljs.core.nth.call(null,vec__32377_32448,(1),null);
var c_32451 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_32450));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic","variadic",882626057).cljs$core$IFn$_invoke$arity$1(meth_32450))){
cljs.compiler.emitln.call(null,mname_32384,".cljs$core$IFn$_invoke$arity$variadic = ",n_32449,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.call(null,mname_32384,".cljs$core$IFn$_invoke$arity$",c_32451," = ",n_32449,";");
}

var G__32452 = seq__32373_32444;
var G__32453 = chunk__32374_32445;
var G__32454 = count__32375_32446;
var G__32455 = (i__32376_32447 + (1));
seq__32373_32444 = G__32452;
chunk__32374_32445 = G__32453;
count__32375_32446 = G__32454;
i__32376_32447 = G__32455;
continue;
} else {
var temp__4657__auto___32456 = cljs.core.seq.call(null,seq__32373_32444);
if(temp__4657__auto___32456){
var seq__32373_32457__$1 = temp__4657__auto___32456;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32373_32457__$1)){
var c__9025__auto___32458 = cljs.core.chunk_first.call(null,seq__32373_32457__$1);
var G__32459 = cljs.core.chunk_rest.call(null,seq__32373_32457__$1);
var G__32460 = c__9025__auto___32458;
var G__32461 = cljs.core.count.call(null,c__9025__auto___32458);
var G__32462 = (0);
seq__32373_32444 = G__32459;
chunk__32374_32445 = G__32460;
count__32375_32446 = G__32461;
i__32376_32447 = G__32462;
continue;
} else {
var vec__32380_32463 = cljs.core.first.call(null,seq__32373_32457__$1);
var n_32464 = cljs.core.nth.call(null,vec__32380_32463,(0),null);
var meth_32465 = cljs.core.nth.call(null,vec__32380_32463,(1),null);
var c_32466 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_32465));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic","variadic",882626057).cljs$core$IFn$_invoke$arity$1(meth_32465))){
cljs.compiler.emitln.call(null,mname_32384,".cljs$core$IFn$_invoke$arity$variadic = ",n_32464,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.call(null,mname_32384,".cljs$core$IFn$_invoke$arity$",c_32466," = ",n_32464,";");
}

var G__32467 = cljs.core.next.call(null,seq__32373_32457__$1);
var G__32468 = null;
var G__32469 = (0);
var G__32470 = (0);
seq__32373_32444 = G__32467;
chunk__32374_32445 = G__32468;
count__32375_32446 = G__32469;
i__32376_32447 = G__32470;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"return ",mname_32384,";");

cljs.compiler.emitln.call(null,"})()");
}

if(loop_locals){
return cljs.compiler.emitln.call(null,";})(",cljs.compiler.comma_sep.call(null,loop_locals),"))");
} else {
return null;
}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"do","do",46310725),(function (p__32471){
var map__32472 = p__32471;
var map__32472__$1 = ((((!((map__32472 == null)))?((((map__32472.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32472.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32472):map__32472);
var statements = cljs.core.get.call(null,map__32472__$1,new cljs.core.Keyword(null,"statements","statements",600349855));
var ret = cljs.core.get.call(null,map__32472__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var env = cljs.core.get.call(null,map__32472__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var and__8174__auto__ = statements;
if(cljs.core.truth_(and__8174__auto__)){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context);
} else {
return and__8174__auto__;
}
})())){
cljs.compiler.emitln.call(null,"(function (){");
} else {
}

var seq__32474_32478 = cljs.core.seq.call(null,statements);
var chunk__32475_32479 = null;
var count__32476_32480 = (0);
var i__32477_32481 = (0);
while(true){
if((i__32477_32481 < count__32476_32480)){
var s_32482 = cljs.core._nth.call(null,chunk__32475_32479,i__32477_32481);
cljs.compiler.emitln.call(null,s_32482);

var G__32483 = seq__32474_32478;
var G__32484 = chunk__32475_32479;
var G__32485 = count__32476_32480;
var G__32486 = (i__32477_32481 + (1));
seq__32474_32478 = G__32483;
chunk__32475_32479 = G__32484;
count__32476_32480 = G__32485;
i__32477_32481 = G__32486;
continue;
} else {
var temp__4657__auto___32487 = cljs.core.seq.call(null,seq__32474_32478);
if(temp__4657__auto___32487){
var seq__32474_32488__$1 = temp__4657__auto___32487;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32474_32488__$1)){
var c__9025__auto___32489 = cljs.core.chunk_first.call(null,seq__32474_32488__$1);
var G__32490 = cljs.core.chunk_rest.call(null,seq__32474_32488__$1);
var G__32491 = c__9025__auto___32489;
var G__32492 = cljs.core.count.call(null,c__9025__auto___32489);
var G__32493 = (0);
seq__32474_32478 = G__32490;
chunk__32475_32479 = G__32491;
count__32476_32480 = G__32492;
i__32477_32481 = G__32493;
continue;
} else {
var s_32494 = cljs.core.first.call(null,seq__32474_32488__$1);
cljs.compiler.emitln.call(null,s_32494);

var G__32495 = cljs.core.next.call(null,seq__32474_32488__$1);
var G__32496 = null;
var G__32497 = (0);
var G__32498 = (0);
seq__32474_32478 = G__32495;
chunk__32475_32479 = G__32496;
count__32476_32480 = G__32497;
i__32477_32481 = G__32498;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit.call(null,ret);

if(cljs.core.truth_((function (){var and__8174__auto__ = statements;
if(cljs.core.truth_(and__8174__auto__)){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context);
} else {
return and__8174__auto__;
}
})())){
return cljs.compiler.emitln.call(null,"})()");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"try","try",1380742522),(function (p__32499){
var map__32500 = p__32499;
var map__32500__$1 = ((((!((map__32500 == null)))?((((map__32500.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32500.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32500):map__32500);
var env = cljs.core.get.call(null,map__32500__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var try$ = cljs.core.get.call(null,map__32500__$1,new cljs.core.Keyword(null,"try","try",1380742522));
var catch$ = cljs.core.get.call(null,map__32500__$1,new cljs.core.Keyword(null,"catch","catch",1038065524));
var name = cljs.core.get.call(null,map__32500__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var finally$ = cljs.core.get.call(null,map__32500__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__8186__auto__ = name;
if(cljs.core.truth_(or__8186__auto__)){
return or__8186__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

cljs.compiler.emits.call(null,"try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.call(null,"catch (",cljs.compiler.munge.call(null,name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"constant","constant",-379609303),new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(finally$))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :constant (:op finally))"].join('')));
}

cljs.compiler.emits.call(null,"finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.call(null,try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__32502,is_loop){
var map__32503 = p__32502;
var map__32503__$1 = ((((!((map__32503 == null)))?((((map__32503.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32503.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32503):map__32503);
var bindings = cljs.core.get.call(null,map__32503__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var expr = cljs.core.get.call(null,map__32503__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var env = cljs.core.get.call(null,map__32503__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

var _STAR_lexical_renames_STAR_32505_32514 = cljs.compiler._STAR_lexical_renames_STAR_;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.into.call(null,cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),context))?cljs.core.map.call(null,((function (_STAR_lexical_renames_STAR_32505_32514,context,map__32503,map__32503__$1,bindings,expr,env){
return (function (binding){
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope.call(null,binding),cljs.core.gensym.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
});})(_STAR_lexical_renames_STAR_32505_32514,context,map__32503,map__32503__$1,bindings,expr,env))
,bindings):null));

try{var seq__32506_32515 = cljs.core.seq.call(null,bindings);
var chunk__32507_32516 = null;
var count__32508_32517 = (0);
var i__32509_32518 = (0);
while(true){
if((i__32509_32518 < count__32508_32517)){
var map__32510_32519 = cljs.core._nth.call(null,chunk__32507_32516,i__32509_32518);
var map__32510_32520__$1 = ((((!((map__32510_32519 == null)))?((((map__32510_32519.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32510_32519.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32510_32519):map__32510_32519);
var binding_32521 = map__32510_32520__$1;
var init_32522 = cljs.core.get.call(null,map__32510_32520__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,binding_32521);

cljs.compiler.emitln.call(null," = ",init_32522,";");

var G__32523 = seq__32506_32515;
var G__32524 = chunk__32507_32516;
var G__32525 = count__32508_32517;
var G__32526 = (i__32509_32518 + (1));
seq__32506_32515 = G__32523;
chunk__32507_32516 = G__32524;
count__32508_32517 = G__32525;
i__32509_32518 = G__32526;
continue;
} else {
var temp__4657__auto___32527 = cljs.core.seq.call(null,seq__32506_32515);
if(temp__4657__auto___32527){
var seq__32506_32528__$1 = temp__4657__auto___32527;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32506_32528__$1)){
var c__9025__auto___32529 = cljs.core.chunk_first.call(null,seq__32506_32528__$1);
var G__32530 = cljs.core.chunk_rest.call(null,seq__32506_32528__$1);
var G__32531 = c__9025__auto___32529;
var G__32532 = cljs.core.count.call(null,c__9025__auto___32529);
var G__32533 = (0);
seq__32506_32515 = G__32530;
chunk__32507_32516 = G__32531;
count__32508_32517 = G__32532;
i__32509_32518 = G__32533;
continue;
} else {
var map__32512_32534 = cljs.core.first.call(null,seq__32506_32528__$1);
var map__32512_32535__$1 = ((((!((map__32512_32534 == null)))?((((map__32512_32534.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32512_32534.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32512_32534):map__32512_32534);
var binding_32536 = map__32512_32535__$1;
var init_32537 = cljs.core.get.call(null,map__32512_32535__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,binding_32536);

cljs.compiler.emitln.call(null," = ",init_32537,";");

var G__32538 = cljs.core.next.call(null,seq__32506_32528__$1);
var G__32539 = null;
var G__32540 = (0);
var G__32541 = (0);
seq__32506_32515 = G__32538;
chunk__32507_32516 = G__32539;
count__32508_32517 = G__32540;
i__32509_32518 = G__32541;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}
}finally {cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR_32505_32514;
}
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"let","let",-1282412701),(function (ast){
return cljs.compiler.emit_let.call(null,ast,false);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"loop","loop",-395552849),(function (ast){
return cljs.compiler.emit_let.call(null,ast,true);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"recur","recur",-437573268),(function (p__32542){
var map__32543 = p__32542;
var map__32543__$1 = ((((!((map__32543 == null)))?((((map__32543.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32543.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32543):map__32543);
var frame = cljs.core.get.call(null,map__32543__$1,new cljs.core.Keyword(null,"frame","frame",-1711082588));
var exprs = cljs.core.get.call(null,map__32543__$1,new cljs.core.Keyword(null,"exprs","exprs",1795829094));
var env = cljs.core.get.call(null,map__32543__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var temps = cljs.core.vec.call(null,cljs.core.take.call(null,cljs.core.count.call(null,exprs),cljs.core.repeatedly.call(null,cljs.core.gensym)));
var params = new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(frame);
var n__9133__auto___32545 = cljs.core.count.call(null,exprs);
var i_32546 = (0);
while(true){
if((i_32546 < n__9133__auto___32545)){
cljs.compiler.emitln.call(null,"var ",temps.call(null,i_32546)," = ",exprs.call(null,i_32546),";");

var G__32547 = (i_32546 + (1));
i_32546 = G__32547;
continue;
} else {
}
break;
}

var n__9133__auto___32548 = cljs.core.count.call(null,exprs);
var i_32549 = (0);
while(true){
if((i_32549 < n__9133__auto___32548)){
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,params.call(null,i_32549))," = ",temps.call(null,i_32549),";");

var G__32550 = (i_32549 + (1));
i_32549 = G__32550;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.call(null,"continue;");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"letfn","letfn",-2121022354),(function (p__32551){
var map__32552 = p__32551;
var map__32552__$1 = ((((!((map__32552 == null)))?((((map__32552.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32552.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32552):map__32552);
var bindings = cljs.core.get.call(null,map__32552__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var expr = cljs.core.get.call(null,map__32552__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var env = cljs.core.get.call(null,map__32552__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

var seq__32554_32562 = cljs.core.seq.call(null,bindings);
var chunk__32555_32563 = null;
var count__32556_32564 = (0);
var i__32557_32565 = (0);
while(true){
if((i__32557_32565 < count__32556_32564)){
var map__32558_32566 = cljs.core._nth.call(null,chunk__32555_32563,i__32557_32565);
var map__32558_32567__$1 = ((((!((map__32558_32566 == null)))?((((map__32558_32566.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32558_32566.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32558_32566):map__32558_32566);
var binding_32568 = map__32558_32567__$1;
var init_32569 = cljs.core.get.call(null,map__32558_32567__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.call(null,"var ",cljs.compiler.munge.call(null,binding_32568)," = ",init_32569,";");

var G__32570 = seq__32554_32562;
var G__32571 = chunk__32555_32563;
var G__32572 = count__32556_32564;
var G__32573 = (i__32557_32565 + (1));
seq__32554_32562 = G__32570;
chunk__32555_32563 = G__32571;
count__32556_32564 = G__32572;
i__32557_32565 = G__32573;
continue;
} else {
var temp__4657__auto___32574 = cljs.core.seq.call(null,seq__32554_32562);
if(temp__4657__auto___32574){
var seq__32554_32575__$1 = temp__4657__auto___32574;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32554_32575__$1)){
var c__9025__auto___32576 = cljs.core.chunk_first.call(null,seq__32554_32575__$1);
var G__32577 = cljs.core.chunk_rest.call(null,seq__32554_32575__$1);
var G__32578 = c__9025__auto___32576;
var G__32579 = cljs.core.count.call(null,c__9025__auto___32576);
var G__32580 = (0);
seq__32554_32562 = G__32577;
chunk__32555_32563 = G__32578;
count__32556_32564 = G__32579;
i__32557_32565 = G__32580;
continue;
} else {
var map__32560_32581 = cljs.core.first.call(null,seq__32554_32575__$1);
var map__32560_32582__$1 = ((((!((map__32560_32581 == null)))?((((map__32560_32581.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32560_32581.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32560_32581):map__32560_32581);
var binding_32583 = map__32560_32582__$1;
var init_32584 = cljs.core.get.call(null,map__32560_32582__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.call(null,"var ",cljs.compiler.munge.call(null,binding_32583)," = ",init_32584,";");

var G__32585 = cljs.core.next.call(null,seq__32554_32575__$1);
var G__32586 = null;
var G__32587 = (0);
var G__32588 = (0);
seq__32554_32562 = G__32585;
chunk__32555_32563 = G__32586;
count__32556_32564 = G__32587;
i__32557_32565 = G__32588;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.call(null,expr);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym)].join('').replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"invoke","invoke",1145927159),(function (p__32591){
var map__32592 = p__32591;
var map__32592__$1 = ((((!((map__32592 == null)))?((((map__32592.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32592.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32592):map__32592);
var expr = map__32592__$1;
var f = cljs.core.get.call(null,map__32592__$1,new cljs.core.Keyword(null,"f","f",-1597136552));
var args = cljs.core.get.call(null,map__32592__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__32592__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__8174__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(and__8174__auto__){
var and__8174__auto____$1 = cljs.core.not.call(null,new cljs.core.Keyword(null,"dynamic","dynamic",704819571).cljs$core$IFn$_invoke$arity$1(info));
if(and__8174__auto____$1){
return new cljs.core.Keyword(null,"fn-var","fn-var",1086204730).cljs$core$IFn$_invoke$arity$1(info);
} else {
return and__8174__auto____$1;
}
} else {
return and__8174__auto__;
}
})();
var protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag.call(null,env,cljs.core.first.call(null,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__8174__auto__ = protocol;
if(cljs.core.truth_(and__8174__auto__)){
var and__8174__auto____$1 = tag;
if(cljs.core.truth_(and__8174__auto____$1)){
var or__8186__auto__ = (function (){var and__8174__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(and__8174__auto____$2){
var and__8174__auto____$3 = protocol;
if(cljs.core.truth_(and__8174__auto____$3)){
return cljs.core._EQ_.call(null,tag,new cljs.core.Symbol(null,"not-native","not-native",-236392494,null));
} else {
return and__8174__auto____$3;
}
} else {
return and__8174__auto____$2;
}
})();
if(cljs.core.truth_(or__8186__auto__)){
return or__8186__auto__;
} else {
var and__8174__auto____$2 = (function (){var or__8186__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(or__8186__auto____$1){
return or__8186__auto____$1;
} else {
return new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556).cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__8174__auto____$2)){
var or__8186__auto____$1 = cljs.core._EQ_.call(null,protocol,tag);
if(or__8186__auto____$1){
return or__8186__auto____$1;
} else {
var and__8174__auto____$3 = !(cljs.core.set_QMARK_.call(null,tag));
if(and__8174__auto____$3){
var and__8174__auto____$4 = cljs.core.not.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Symbol(null,"clj","clj",980036099,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null,new cljs.core.Symbol(null,"object","object",-1179821820,null),null,new cljs.core.Symbol(null,"any","any",-948528346,null),null,new cljs.core.Symbol(null,"js","js",-886355190,null),null,new cljs.core.Symbol(null,"number","number",-1084057331,null),null,new cljs.core.Symbol(null,"clj-or-nil","clj-or-nil",-2008798668,null),null,new cljs.core.Symbol(null,"array","array",-440182315,null),null,new cljs.core.Symbol(null,"string","string",-349010059,null),null,new cljs.core.Symbol(null,"function","function",-486723946,null),null,new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),null], null), null).call(null,tag));
if(and__8174__auto____$4){
var temp__4657__auto__ = new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var.call(null,env,tag));
if(cljs.core.truth_(temp__4657__auto__)){
var ps = temp__4657__auto__;
return ps.call(null,protocol);
} else {
return null;
}
} else {
return and__8174__auto____$4;
}
} else {
return and__8174__auto____$3;
}
}
} else {
return and__8174__auto____$2;
}
}
} else {
return and__8174__auto____$1;
}
} else {
return and__8174__auto__;
}
})();
var opt_not_QMARK_ = (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null))) && (cljs.core._EQ_.call(null,cljs.analyzer.infer_tag.call(null,env,cljs.core.first.call(null,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr))),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null)));
var ns = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(info);
var js_QMARK_ = (cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"js","js",-886355190,null))) || (cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"Math","Math",2033287572,null)));
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__8186__auto__ = cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"goog","goog",-70603925,null));
if(or__8186__auto__){
return or__8186__auto__;
} else {
var or__8186__auto____$1 = (function (){var temp__4657__auto__ = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)].join('');
if(cljs.core.truth_(temp__4657__auto__)){
var ns_str = temp__4657__auto__;
return cljs.core._EQ_.call(null,cljs.core.get.call(null,clojure.string.split.call(null,ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__8186__auto____$1)){
return or__8186__auto____$1;
} else {
return !(cljs.core.contains_QMARK_.call(null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)),ns));
}
}
})():null);
var keyword_QMARK_ = (cljs.core._EQ_.call(null,new cljs.core.Symbol("cljs.core","Keyword","cljs.core/Keyword",-451434488,null),cljs.analyzer.infer_tag.call(null,env,f))) || ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f),new cljs.core.Keyword(null,"constant","constant",-379609303))) && ((new cljs.core.Keyword(null,"form","form",-1624062471).cljs$core$IFn$_invoke$arity$1(f) instanceof cljs.core.Keyword)));
var vec__32594 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count.call(null,args);
var variadic_QMARK_ = new cljs.core.Keyword(null,"variadic","variadic",882626057).cljs$core$IFn$_invoke$arity$1(info);
var mps = new cljs.core.Keyword(null,"method-params","method-params",-980792179).cljs$core$IFn$_invoke$arity$1(info);
var mfa = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(info);
if((cljs.core.not.call(null,variadic_QMARK_)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,mps),(1)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__8174__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__8174__auto__)){
return (arity > mfa);
} else {
return and__8174__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.call(null,f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),((function (arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__32592,map__32592__$1,expr,f,args,env){
return (function (info__$1){
return cljs.core.update_in.call(null,cljs.core.assoc.call(null,info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),((function (arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__32592,map__32592__$1,expr,f,args,env){
return (function (p1__32589_SHARP_){
return cljs.core.dissoc.call(null,cljs.core.dissoc.call(null,p1__32589_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
});})(arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__32592,map__32592__$1,expr,f,args,env))
);
});})(arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__32592,map__32592__$1,expr,f,args,env))
),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),mfa], null)], null);
} else {
var arities = cljs.core.map.call(null,cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.call(null,f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),((function (arities,arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__32592,map__32592__$1,expr,f,args,env){
return (function (info__$1){
return cljs.core.update_in.call(null,cljs.core.assoc.call(null,info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),((function (arities,arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__32592,map__32592__$1,expr,f,args,env){
return (function (p1__32590_SHARP_){
return cljs.core.dissoc.call(null,cljs.core.dissoc.call(null,p1__32590_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
});})(arities,arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__32592,map__32592__$1,expr,f,args,env))
);
});})(arities,arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__32592,map__32592__$1,expr,f,args,env))
),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.call(null,vec__32594,(0),null);
var variadic_invoke = cljs.core.nth.call(null,vec__32594,(1),null);
var env__31804__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__31804__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.call(null,"!(",cljs.core.first.call(null,args),")");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_32597 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,cljs.compiler.protocol_prefix.call(null,protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,cljs.core.name.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,args))].join('');
cljs.compiler.emits.call(null,cljs.core.first.call(null,args),".",pimpl_32597,"(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",cljs.core.rest.call(null,args))),")");
} else {
if(keyword_QMARK_){
cljs.compiler.emits.call(null,f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count.call(null,args),"(",cljs.compiler.comma_sep.call(null,args),")");
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_32598 = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.call(null,f__$1,"(",cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,mfa_32598,args)),(((mfa_32598 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.compiler.comma_sep.call(null,cljs.core.drop.call(null,mfa_32598,args)),"], 0))");
} else {
if(cljs.core.truth_((function (){var or__8186__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__8186__auto__)){
return or__8186__auto__;
} else {
var or__8186__auto____$1 = js_QMARK_;
if(or__8186__auto____$1){
return or__8186__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.call(null,f__$1,"(",cljs.compiler.comma_sep.call(null,args),")");
} else {
if((cljs.analyzer._STAR_cljs_static_fns_STAR_) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1),new cljs.core.Keyword(null,"var","var",-769682797)))){
var fprop_32599 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,args))].join('');
if(cljs.analyzer._STAR_fn_invoke_direct_STAR_){
cljs.compiler.emits.call(null,"(",f__$1,fprop_32599," ? ",f__$1,fprop_32599,"(",cljs.compiler.comma_sep.call(null,args),") : ",f__$1,"(",cljs.compiler.comma_sep.call(null,args),"))");
} else {
cljs.compiler.emits.call(null,"(",f__$1,fprop_32599," ? ",f__$1,fprop_32599,"(",cljs.compiler.comma_sep.call(null,args),") : ",f__$1,".call(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",args)),"))");
}
} else {
cljs.compiler.emits.call(null,f__$1,".call(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",args)),")");
}

}
}
}
}
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__31804__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"new","new",-2085437848),(function (p__32600){
var map__32601 = p__32600;
var map__32601__$1 = ((((!((map__32601 == null)))?((((map__32601.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32601.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32601):map__32601);
var ctor = cljs.core.get.call(null,map__32601__$1,new cljs.core.Keyword(null,"ctor","ctor",1750864802));
var args = cljs.core.get.call(null,map__32601__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__32601__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__31804__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__31804__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"(new ",ctor,"(",cljs.compiler.comma_sep.call(null,args),"))");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__31804__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"set!","set!",-1389817006),(function (p__32603){
var map__32604 = p__32603;
var map__32604__$1 = ((((!((map__32604 == null)))?((((map__32604.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32604.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32604):map__32604);
var target = cljs.core.get.call(null,map__32604__$1,new cljs.core.Keyword(null,"target","target",253001721));
var val = cljs.core.get.call(null,map__32604__$1,new cljs.core.Keyword(null,"val","val",128701612));
var env = cljs.core.get.call(null,map__32604__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__31804__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__31804__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,target," = ",val);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__31804__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__32606 = cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_);
var map__32606__$1 = ((((!((map__32606 == null)))?((((map__32606.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32606.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32606):map__32606);
var options = cljs.core.get.call(null,map__32606__$1,new cljs.core.Keyword(null,"options","options",99638489));
var js_dependency_index = cljs.core.get.call(null,map__32606__$1,new cljs.core.Keyword(null,"js-dependency-index","js-dependency-index",-1887042131));
var map__32607 = options;
var map__32607__$1 = ((((!((map__32607 == null)))?((((map__32607.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32607.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32607):map__32607);
var target = cljs.core.get.call(null,map__32607__$1,new cljs.core.Keyword(null,"target","target",253001721));
var optimizations = cljs.core.get.call(null,map__32607__$1,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854));
var loaded_libs = cljs.compiler.munge.call(null,new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null));
var loaded_libs_temp = cljs.compiler.munge.call(null,cljs.core.gensym.call(null,new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null)));
var vec__32608 = (function (){var libs__$1 = cljs.core.remove.call(null,cljs.core.set.call(null,cljs.core.vals.call(null,seen)),cljs.core.filter.call(null,cljs.core.set.call(null,cljs.core.vals.call(null,libs)),deps));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"nodejs","nodejs",321212524),target)){
var map__32614 = cljs.core.group_by.call(null,cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__32614__$1 = ((((!((map__32614 == null)))?((((map__32614.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32614.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32614):map__32614);
var node_libs = cljs.core.get.call(null,map__32614__$1,true);
var libs_to_load = cljs.core.get.call(null,map__32614__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.call(null,vec__32608,(0),null);
var libs_to_load = cljs.core.nth.call(null,vec__32608,(1),null);
var map__32611 = cljs.core.group_by.call(null,cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load);
var map__32611__$1 = ((((!((map__32611 == null)))?((((map__32611.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32611.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32611):map__32611);
var global_exports_libs = cljs.core.get.call(null,map__32611__$1,true);
var libs_to_load__$1 = cljs.core.get.call(null,map__32611__$1,false);
if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs)))){
cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__32617_32633 = cljs.core.seq.call(null,libs_to_load__$1);
var chunk__32618_32634 = null;
var count__32619_32635 = (0);
var i__32620_32636 = (0);
while(true){
if((i__32620_32636 < count__32619_32635)){
var lib_32637 = cljs.core._nth.call(null,chunk__32618_32634,i__32620_32636);
if((cljs.analyzer.foreign_dep_QMARK_.call(null,lib_32637)) && (!(cljs.core.keyword_identical_QMARK_.call(null,optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))){
} else {
if(cljs.core.truth_((function (){var or__8186__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__8186__auto__)){
return or__8186__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_32637),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_32637),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__8186__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__8186__auto__)){
return or__8186__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_32637),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_32637),"', 'reload-all');");
} else {
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_32637),"');");

}
}
}

var G__32638 = seq__32617_32633;
var G__32639 = chunk__32618_32634;
var G__32640 = count__32619_32635;
var G__32641 = (i__32620_32636 + (1));
seq__32617_32633 = G__32638;
chunk__32618_32634 = G__32639;
count__32619_32635 = G__32640;
i__32620_32636 = G__32641;
continue;
} else {
var temp__4657__auto___32642 = cljs.core.seq.call(null,seq__32617_32633);
if(temp__4657__auto___32642){
var seq__32617_32643__$1 = temp__4657__auto___32642;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32617_32643__$1)){
var c__9025__auto___32644 = cljs.core.chunk_first.call(null,seq__32617_32643__$1);
var G__32645 = cljs.core.chunk_rest.call(null,seq__32617_32643__$1);
var G__32646 = c__9025__auto___32644;
var G__32647 = cljs.core.count.call(null,c__9025__auto___32644);
var G__32648 = (0);
seq__32617_32633 = G__32645;
chunk__32618_32634 = G__32646;
count__32619_32635 = G__32647;
i__32620_32636 = G__32648;
continue;
} else {
var lib_32649 = cljs.core.first.call(null,seq__32617_32643__$1);
if((cljs.analyzer.foreign_dep_QMARK_.call(null,lib_32649)) && (!(cljs.core.keyword_identical_QMARK_.call(null,optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))){
} else {
if(cljs.core.truth_((function (){var or__8186__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__8186__auto__)){
return or__8186__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_32649),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_32649),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__8186__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__8186__auto__)){
return or__8186__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_32649),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_32649),"', 'reload-all');");
} else {
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_32649),"');");

}
}
}

var G__32650 = cljs.core.next.call(null,seq__32617_32643__$1);
var G__32651 = null;
var G__32652 = (0);
var G__32653 = (0);
seq__32617_32633 = G__32650;
chunk__32618_32634 = G__32651;
count__32619_32635 = G__32652;
i__32620_32636 = G__32653;
continue;
}
} else {
}
}
break;
}

var seq__32621_32654 = cljs.core.seq.call(null,node_libs);
var chunk__32622_32655 = null;
var count__32623_32656 = (0);
var i__32624_32657 = (0);
while(true){
if((i__32624_32657 < count__32623_32656)){
var lib_32658 = cljs.core._nth.call(null,chunk__32622_32655,i__32624_32657);
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_node_lib.call(null,lib_32658)," = require('",lib_32658,"');");

var G__32659 = seq__32621_32654;
var G__32660 = chunk__32622_32655;
var G__32661 = count__32623_32656;
var G__32662 = (i__32624_32657 + (1));
seq__32621_32654 = G__32659;
chunk__32622_32655 = G__32660;
count__32623_32656 = G__32661;
i__32624_32657 = G__32662;
continue;
} else {
var temp__4657__auto___32663 = cljs.core.seq.call(null,seq__32621_32654);
if(temp__4657__auto___32663){
var seq__32621_32664__$1 = temp__4657__auto___32663;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32621_32664__$1)){
var c__9025__auto___32665 = cljs.core.chunk_first.call(null,seq__32621_32664__$1);
var G__32666 = cljs.core.chunk_rest.call(null,seq__32621_32664__$1);
var G__32667 = c__9025__auto___32665;
var G__32668 = cljs.core.count.call(null,c__9025__auto___32665);
var G__32669 = (0);
seq__32621_32654 = G__32666;
chunk__32622_32655 = G__32667;
count__32623_32656 = G__32668;
i__32624_32657 = G__32669;
continue;
} else {
var lib_32670 = cljs.core.first.call(null,seq__32621_32664__$1);
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_node_lib.call(null,lib_32670)," = require('",lib_32670,"');");

var G__32671 = cljs.core.next.call(null,seq__32621_32664__$1);
var G__32672 = null;
var G__32673 = (0);
var G__32674 = (0);
seq__32621_32654 = G__32671;
chunk__32622_32655 = G__32672;
count__32623_32656 = G__32673;
i__32624_32657 = G__32674;
continue;
}
} else {
}
}
break;
}

var seq__32625_32675 = cljs.core.seq.call(null,global_exports_libs);
var chunk__32626_32676 = null;
var count__32627_32677 = (0);
var i__32628_32678 = (0);
while(true){
if((i__32628_32678 < count__32627_32677)){
var lib_32679 = cljs.core._nth.call(null,chunk__32626_32676,i__32628_32678);
var map__32629_32680 = cljs.core.get.call(null,js_dependency_index,cljs.core.name.call(null,lib_32679));
var map__32629_32681__$1 = ((((!((map__32629_32680 == null)))?((((map__32629_32680.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32629_32680.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32629_32680):map__32629_32680);
var global_exports_32682 = cljs.core.get.call(null,map__32629_32681__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_global_export.call(null,lib_32679)," = goog.global.",cljs.core.get.call(null,global_exports_32682,cljs.core.symbol.call(null,lib_32679)),";");

var G__32683 = seq__32625_32675;
var G__32684 = chunk__32626_32676;
var G__32685 = count__32627_32677;
var G__32686 = (i__32628_32678 + (1));
seq__32625_32675 = G__32683;
chunk__32626_32676 = G__32684;
count__32627_32677 = G__32685;
i__32628_32678 = G__32686;
continue;
} else {
var temp__4657__auto___32687 = cljs.core.seq.call(null,seq__32625_32675);
if(temp__4657__auto___32687){
var seq__32625_32688__$1 = temp__4657__auto___32687;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32625_32688__$1)){
var c__9025__auto___32689 = cljs.core.chunk_first.call(null,seq__32625_32688__$1);
var G__32690 = cljs.core.chunk_rest.call(null,seq__32625_32688__$1);
var G__32691 = c__9025__auto___32689;
var G__32692 = cljs.core.count.call(null,c__9025__auto___32689);
var G__32693 = (0);
seq__32625_32675 = G__32690;
chunk__32626_32676 = G__32691;
count__32627_32677 = G__32692;
i__32628_32678 = G__32693;
continue;
} else {
var lib_32694 = cljs.core.first.call(null,seq__32625_32688__$1);
var map__32631_32695 = cljs.core.get.call(null,js_dependency_index,cljs.core.name.call(null,lib_32694));
var map__32631_32696__$1 = ((((!((map__32631_32695 == null)))?((((map__32631_32695.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32631_32695.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32631_32695):map__32631_32695);
var global_exports_32697 = cljs.core.get.call(null,map__32631_32696__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_global_export.call(null,lib_32694)," = goog.global.",cljs.core.get.call(null,global_exports_32697,cljs.core.symbol.call(null,lib_32694)),";");

var G__32698 = cljs.core.next.call(null,seq__32625_32688__$1);
var G__32699 = null;
var G__32700 = (0);
var G__32701 = (0);
seq__32625_32675 = G__32698;
chunk__32626_32676 = G__32699;
count__32627_32677 = G__32700;
i__32628_32678 = G__32701;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs)))){
return cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",loaded_libs,");");
} else {
return null;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"ns*","ns*",200417856),(function (p__32702){
var map__32703 = p__32702;
var map__32703__$1 = ((((!((map__32703 == null)))?((((map__32703.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32703.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32703):map__32703);
var name = cljs.core.get.call(null,map__32703__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.call(null,map__32703__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.call(null,map__32703__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.call(null,map__32703__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.call(null,map__32703__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.call(null,map__32703__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.call(null,map__32703__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.load_libs.call(null,requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs.call(null,uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-env","repl-env",-1976503928).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.call(null,"null;");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"ns","ns",441598760),(function (p__32705){
var map__32706 = p__32705;
var map__32706__$1 = ((((!((map__32706 == null)))?((((map__32706.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32706.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32706):map__32706);
var name = cljs.core.get.call(null,map__32706__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.call(null,map__32706__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.call(null,map__32706__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.call(null,map__32706__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.call(null,map__32706__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.call(null,map__32706__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.call(null,map__32706__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.emitln.call(null,"goog.provide('",cljs.compiler.munge.call(null,name),"');");

if(cljs.core._EQ_.call(null,name,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null))){
} else {
cljs.compiler.emitln.call(null,"goog.require('cljs.core');");

if(cljs.core.truth_(new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs.call(null,requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs.call(null,uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"deftype*","deftype*",-677871637),(function (p__32708){
var map__32709 = p__32708;
var map__32709__$1 = ((((!((map__32709 == null)))?((((map__32709.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32709.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32709):map__32709);
var t = cljs.core.get.call(null,map__32709__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.call(null,map__32709__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.call(null,map__32709__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.call(null,map__32709__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.call(null,map__32709__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.map.call(null,cljs.compiler.munge,fields);
cljs.compiler.emitln.call(null,"");

cljs.compiler.emitln.call(null,"/**");

cljs.compiler.emitln.call(null,"* @constructor");

var seq__32711_32729 = cljs.core.seq.call(null,protocols);
var chunk__32712_32730 = null;
var count__32713_32731 = (0);
var i__32714_32732 = (0);
while(true){
if((i__32714_32732 < count__32713_32731)){
var protocol_32733 = cljs.core._nth.call(null,chunk__32712_32730,i__32714_32732);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_32733)].join('')),"}");

var G__32734 = seq__32711_32729;
var G__32735 = chunk__32712_32730;
var G__32736 = count__32713_32731;
var G__32737 = (i__32714_32732 + (1));
seq__32711_32729 = G__32734;
chunk__32712_32730 = G__32735;
count__32713_32731 = G__32736;
i__32714_32732 = G__32737;
continue;
} else {
var temp__4657__auto___32738 = cljs.core.seq.call(null,seq__32711_32729);
if(temp__4657__auto___32738){
var seq__32711_32739__$1 = temp__4657__auto___32738;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32711_32739__$1)){
var c__9025__auto___32740 = cljs.core.chunk_first.call(null,seq__32711_32739__$1);
var G__32741 = cljs.core.chunk_rest.call(null,seq__32711_32739__$1);
var G__32742 = c__9025__auto___32740;
var G__32743 = cljs.core.count.call(null,c__9025__auto___32740);
var G__32744 = (0);
seq__32711_32729 = G__32741;
chunk__32712_32730 = G__32742;
count__32713_32731 = G__32743;
i__32714_32732 = G__32744;
continue;
} else {
var protocol_32745 = cljs.core.first.call(null,seq__32711_32739__$1);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_32745)].join('')),"}");

var G__32746 = cljs.core.next.call(null,seq__32711_32739__$1);
var G__32747 = null;
var G__32748 = (0);
var G__32749 = (0);
seq__32711_32729 = G__32746;
chunk__32712_32730 = G__32747;
count__32713_32731 = G__32748;
i__32714_32732 = G__32749;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"*/");

cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,t)," = (function (",cljs.compiler.comma_sep.call(null,fields__$1),"){");

var seq__32715_32750 = cljs.core.seq.call(null,fields__$1);
var chunk__32716_32751 = null;
var count__32717_32752 = (0);
var i__32718_32753 = (0);
while(true){
if((i__32718_32753 < count__32717_32752)){
var fld_32754 = cljs.core._nth.call(null,chunk__32716_32751,i__32718_32753);
cljs.compiler.emitln.call(null,"this.",fld_32754," = ",fld_32754,";");

var G__32755 = seq__32715_32750;
var G__32756 = chunk__32716_32751;
var G__32757 = count__32717_32752;
var G__32758 = (i__32718_32753 + (1));
seq__32715_32750 = G__32755;
chunk__32716_32751 = G__32756;
count__32717_32752 = G__32757;
i__32718_32753 = G__32758;
continue;
} else {
var temp__4657__auto___32759 = cljs.core.seq.call(null,seq__32715_32750);
if(temp__4657__auto___32759){
var seq__32715_32760__$1 = temp__4657__auto___32759;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32715_32760__$1)){
var c__9025__auto___32761 = cljs.core.chunk_first.call(null,seq__32715_32760__$1);
var G__32762 = cljs.core.chunk_rest.call(null,seq__32715_32760__$1);
var G__32763 = c__9025__auto___32761;
var G__32764 = cljs.core.count.call(null,c__9025__auto___32761);
var G__32765 = (0);
seq__32715_32750 = G__32762;
chunk__32716_32751 = G__32763;
count__32717_32752 = G__32764;
i__32718_32753 = G__32765;
continue;
} else {
var fld_32766 = cljs.core.first.call(null,seq__32715_32760__$1);
cljs.compiler.emitln.call(null,"this.",fld_32766," = ",fld_32766,";");

var G__32767 = cljs.core.next.call(null,seq__32715_32760__$1);
var G__32768 = null;
var G__32769 = (0);
var G__32770 = (0);
seq__32715_32750 = G__32767;
chunk__32716_32751 = G__32768;
count__32717_32752 = G__32769;
i__32718_32753 = G__32770;
continue;
}
} else {
}
}
break;
}

var seq__32719_32771 = cljs.core.seq.call(null,pmasks);
var chunk__32720_32772 = null;
var count__32721_32773 = (0);
var i__32722_32774 = (0);
while(true){
if((i__32722_32774 < count__32721_32773)){
var vec__32723_32775 = cljs.core._nth.call(null,chunk__32720_32772,i__32722_32774);
var pno_32776 = cljs.core.nth.call(null,vec__32723_32775,(0),null);
var pmask_32777 = cljs.core.nth.call(null,vec__32723_32775,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_32776,"$ = ",pmask_32777,";");

var G__32778 = seq__32719_32771;
var G__32779 = chunk__32720_32772;
var G__32780 = count__32721_32773;
var G__32781 = (i__32722_32774 + (1));
seq__32719_32771 = G__32778;
chunk__32720_32772 = G__32779;
count__32721_32773 = G__32780;
i__32722_32774 = G__32781;
continue;
} else {
var temp__4657__auto___32782 = cljs.core.seq.call(null,seq__32719_32771);
if(temp__4657__auto___32782){
var seq__32719_32783__$1 = temp__4657__auto___32782;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32719_32783__$1)){
var c__9025__auto___32784 = cljs.core.chunk_first.call(null,seq__32719_32783__$1);
var G__32785 = cljs.core.chunk_rest.call(null,seq__32719_32783__$1);
var G__32786 = c__9025__auto___32784;
var G__32787 = cljs.core.count.call(null,c__9025__auto___32784);
var G__32788 = (0);
seq__32719_32771 = G__32785;
chunk__32720_32772 = G__32786;
count__32721_32773 = G__32787;
i__32722_32774 = G__32788;
continue;
} else {
var vec__32726_32789 = cljs.core.first.call(null,seq__32719_32783__$1);
var pno_32790 = cljs.core.nth.call(null,vec__32726_32789,(0),null);
var pmask_32791 = cljs.core.nth.call(null,vec__32726_32789,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_32790,"$ = ",pmask_32791,";");

var G__32792 = cljs.core.next.call(null,seq__32719_32783__$1);
var G__32793 = null;
var G__32794 = (0);
var G__32795 = (0);
seq__32719_32771 = G__32792;
chunk__32720_32772 = G__32793;
count__32721_32773 = G__32794;
i__32722_32774 = G__32795;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"});");

return cljs.compiler.emit.call(null,body);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"defrecord*","defrecord*",718069562),(function (p__32796){
var map__32797 = p__32796;
var map__32797__$1 = ((((!((map__32797 == null)))?((((map__32797.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32797.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32797):map__32797);
var t = cljs.core.get.call(null,map__32797__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.call(null,map__32797__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.call(null,map__32797__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.call(null,map__32797__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.call(null,map__32797__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.concat.call(null,cljs.core.map.call(null,cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null));
cljs.compiler.emitln.call(null,"");

cljs.compiler.emitln.call(null,"/**");

cljs.compiler.emitln.call(null,"* @constructor");

var seq__32799_32817 = cljs.core.seq.call(null,protocols);
var chunk__32800_32818 = null;
var count__32801_32819 = (0);
var i__32802_32820 = (0);
while(true){
if((i__32802_32820 < count__32801_32819)){
var protocol_32821 = cljs.core._nth.call(null,chunk__32800_32818,i__32802_32820);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_32821)].join('')),"}");

var G__32822 = seq__32799_32817;
var G__32823 = chunk__32800_32818;
var G__32824 = count__32801_32819;
var G__32825 = (i__32802_32820 + (1));
seq__32799_32817 = G__32822;
chunk__32800_32818 = G__32823;
count__32801_32819 = G__32824;
i__32802_32820 = G__32825;
continue;
} else {
var temp__4657__auto___32826 = cljs.core.seq.call(null,seq__32799_32817);
if(temp__4657__auto___32826){
var seq__32799_32827__$1 = temp__4657__auto___32826;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32799_32827__$1)){
var c__9025__auto___32828 = cljs.core.chunk_first.call(null,seq__32799_32827__$1);
var G__32829 = cljs.core.chunk_rest.call(null,seq__32799_32827__$1);
var G__32830 = c__9025__auto___32828;
var G__32831 = cljs.core.count.call(null,c__9025__auto___32828);
var G__32832 = (0);
seq__32799_32817 = G__32829;
chunk__32800_32818 = G__32830;
count__32801_32819 = G__32831;
i__32802_32820 = G__32832;
continue;
} else {
var protocol_32833 = cljs.core.first.call(null,seq__32799_32827__$1);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_32833)].join('')),"}");

var G__32834 = cljs.core.next.call(null,seq__32799_32827__$1);
var G__32835 = null;
var G__32836 = (0);
var G__32837 = (0);
seq__32799_32817 = G__32834;
chunk__32800_32818 = G__32835;
count__32801_32819 = G__32836;
i__32802_32820 = G__32837;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"*/");

cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,t)," = (function (",cljs.compiler.comma_sep.call(null,fields__$1),"){");

var seq__32803_32838 = cljs.core.seq.call(null,fields__$1);
var chunk__32804_32839 = null;
var count__32805_32840 = (0);
var i__32806_32841 = (0);
while(true){
if((i__32806_32841 < count__32805_32840)){
var fld_32842 = cljs.core._nth.call(null,chunk__32804_32839,i__32806_32841);
cljs.compiler.emitln.call(null,"this.",fld_32842," = ",fld_32842,";");

var G__32843 = seq__32803_32838;
var G__32844 = chunk__32804_32839;
var G__32845 = count__32805_32840;
var G__32846 = (i__32806_32841 + (1));
seq__32803_32838 = G__32843;
chunk__32804_32839 = G__32844;
count__32805_32840 = G__32845;
i__32806_32841 = G__32846;
continue;
} else {
var temp__4657__auto___32847 = cljs.core.seq.call(null,seq__32803_32838);
if(temp__4657__auto___32847){
var seq__32803_32848__$1 = temp__4657__auto___32847;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32803_32848__$1)){
var c__9025__auto___32849 = cljs.core.chunk_first.call(null,seq__32803_32848__$1);
var G__32850 = cljs.core.chunk_rest.call(null,seq__32803_32848__$1);
var G__32851 = c__9025__auto___32849;
var G__32852 = cljs.core.count.call(null,c__9025__auto___32849);
var G__32853 = (0);
seq__32803_32838 = G__32850;
chunk__32804_32839 = G__32851;
count__32805_32840 = G__32852;
i__32806_32841 = G__32853;
continue;
} else {
var fld_32854 = cljs.core.first.call(null,seq__32803_32848__$1);
cljs.compiler.emitln.call(null,"this.",fld_32854," = ",fld_32854,";");

var G__32855 = cljs.core.next.call(null,seq__32803_32848__$1);
var G__32856 = null;
var G__32857 = (0);
var G__32858 = (0);
seq__32803_32838 = G__32855;
chunk__32804_32839 = G__32856;
count__32805_32840 = G__32857;
i__32806_32841 = G__32858;
continue;
}
} else {
}
}
break;
}

var seq__32807_32859 = cljs.core.seq.call(null,pmasks);
var chunk__32808_32860 = null;
var count__32809_32861 = (0);
var i__32810_32862 = (0);
while(true){
if((i__32810_32862 < count__32809_32861)){
var vec__32811_32863 = cljs.core._nth.call(null,chunk__32808_32860,i__32810_32862);
var pno_32864 = cljs.core.nth.call(null,vec__32811_32863,(0),null);
var pmask_32865 = cljs.core.nth.call(null,vec__32811_32863,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_32864,"$ = ",pmask_32865,";");

var G__32866 = seq__32807_32859;
var G__32867 = chunk__32808_32860;
var G__32868 = count__32809_32861;
var G__32869 = (i__32810_32862 + (1));
seq__32807_32859 = G__32866;
chunk__32808_32860 = G__32867;
count__32809_32861 = G__32868;
i__32810_32862 = G__32869;
continue;
} else {
var temp__4657__auto___32870 = cljs.core.seq.call(null,seq__32807_32859);
if(temp__4657__auto___32870){
var seq__32807_32871__$1 = temp__4657__auto___32870;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32807_32871__$1)){
var c__9025__auto___32872 = cljs.core.chunk_first.call(null,seq__32807_32871__$1);
var G__32873 = cljs.core.chunk_rest.call(null,seq__32807_32871__$1);
var G__32874 = c__9025__auto___32872;
var G__32875 = cljs.core.count.call(null,c__9025__auto___32872);
var G__32876 = (0);
seq__32807_32859 = G__32873;
chunk__32808_32860 = G__32874;
count__32809_32861 = G__32875;
i__32810_32862 = G__32876;
continue;
} else {
var vec__32814_32877 = cljs.core.first.call(null,seq__32807_32871__$1);
var pno_32878 = cljs.core.nth.call(null,vec__32814_32877,(0),null);
var pmask_32879 = cljs.core.nth.call(null,vec__32814_32877,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_32878,"$ = ",pmask_32879,";");

var G__32880 = cljs.core.next.call(null,seq__32807_32871__$1);
var G__32881 = null;
var G__32882 = (0);
var G__32883 = (0);
seq__32807_32859 = G__32880;
chunk__32808_32860 = G__32881;
count__32809_32861 = G__32882;
i__32810_32862 = G__32883;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"});");

return cljs.compiler.emit.call(null,body);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"dot","dot",1442709401),(function (p__32884){
var map__32885 = p__32884;
var map__32885__$1 = ((((!((map__32885 == null)))?((((map__32885.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32885.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32885):map__32885);
var target = cljs.core.get.call(null,map__32885__$1,new cljs.core.Keyword(null,"target","target",253001721));
var field = cljs.core.get.call(null,map__32885__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var method = cljs.core.get.call(null,map__32885__$1,new cljs.core.Keyword(null,"method","method",55703592));
var args = cljs.core.get.call(null,map__32885__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__32885__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__31804__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__31804__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.call(null,target,".",cljs.compiler.munge.call(null,field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.call(null,target,".",cljs.compiler.munge.call(null,method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep.call(null,args),")");
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__31804__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js","js",1768080579),(function (p__32887){
var map__32888 = p__32887;
var map__32888__$1 = ((((!((map__32888 == null)))?((((map__32888.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32888.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32888):map__32888);
var op = cljs.core.get.call(null,map__32888__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var env = cljs.core.get.call(null,map__32888__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var code = cljs.core.get.call(null,map__32888__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var segs = cljs.core.get.call(null,map__32888__$1,new cljs.core.Keyword(null,"segs","segs",-1940299576));
var args = cljs.core.get.call(null,map__32888__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_((function (){var and__8174__auto__ = code;
if(cljs.core.truth_(and__8174__auto__)){
return goog.string.startsWith(clojure.string.trim.call(null,code),"/*");
} else {
return and__8174__auto__;
}
})())){
return cljs.compiler.emits.call(null,code);
} else {
var env__31804__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__31804__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.call(null,code);
} else {
cljs.compiler.emits.call(null,cljs.core.interleave.call(null,cljs.core.concat.call(null,segs,cljs.core.repeat.call(null,null)),cljs.core.concat.call(null,args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__31804__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}));
cljs.compiler.build_affecting_options = (function cljs$compiler$build_affecting_options(opts){
return cljs.core.select_keys.call(null,opts,new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"static-fns","static-fns",-501950748),new cljs.core.Keyword(null,"fn-invoke-direct","fn-invoke-direct",-1537311210),new cljs.core.Keyword(null,"optimize-constants","optimize-constants",232704518),new cljs.core.Keyword(null,"elide-asserts","elide-asserts",537063272),new cljs.core.Keyword(null,"target","target",253001721),new cljs.core.Keyword(null,"cache-key","cache-key",-565448732),new cljs.core.Keyword(null,"checked-arrays","checked-arrays",-139154445),new cljs.core.Keyword(null,"language-out","language-out",334619882)], null));
});
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.call(null,"goog.provide('",cljs.compiler.munge.call(null,cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.call(null,"goog.require('cljs.core');");

var seq__32893 = cljs.core.seq.call(null,table);
var chunk__32894 = null;
var count__32895 = (0);
var i__32896 = (0);
while(true){
if((i__32896 < count__32895)){
var vec__32897 = cljs.core._nth.call(null,chunk__32894,i__32896);
var sym = cljs.core.nth.call(null,vec__32897,(0),null);
var value = cljs.core.nth.call(null,vec__32897,(1),null);
var ns_32903 = cljs.core.namespace.call(null,sym);
var name_32904 = cljs.core.name.call(null,sym);
cljs.compiler.emits.call(null,"cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword.call(null,sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol.call(null,sym);
} else {
throw cljs.core.ex_info.call(null,["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type.call(null,sym))].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471)], null));

}
}

cljs.compiler.emits.call(null,";\n");

var G__32905 = seq__32893;
var G__32906 = chunk__32894;
var G__32907 = count__32895;
var G__32908 = (i__32896 + (1));
seq__32893 = G__32905;
chunk__32894 = G__32906;
count__32895 = G__32907;
i__32896 = G__32908;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__32893);
if(temp__4657__auto__){
var seq__32893__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32893__$1)){
var c__9025__auto__ = cljs.core.chunk_first.call(null,seq__32893__$1);
var G__32909 = cljs.core.chunk_rest.call(null,seq__32893__$1);
var G__32910 = c__9025__auto__;
var G__32911 = cljs.core.count.call(null,c__9025__auto__);
var G__32912 = (0);
seq__32893 = G__32909;
chunk__32894 = G__32910;
count__32895 = G__32911;
i__32896 = G__32912;
continue;
} else {
var vec__32900 = cljs.core.first.call(null,seq__32893__$1);
var sym = cljs.core.nth.call(null,vec__32900,(0),null);
var value = cljs.core.nth.call(null,vec__32900,(1),null);
var ns_32913 = cljs.core.namespace.call(null,sym);
var name_32914 = cljs.core.name.call(null,sym);
cljs.compiler.emits.call(null,"cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword.call(null,sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol.call(null,sym);
} else {
throw cljs.core.ex_info.call(null,["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type.call(null,sym))].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471)], null));

}
}

cljs.compiler.emits.call(null,";\n");

var G__32915 = cljs.core.next.call(null,seq__32893__$1);
var G__32916 = null;
var G__32917 = (0);
var G__32918 = (0);
seq__32893 = G__32915;
chunk__32894 = G__32916;
count__32895 = G__32917;
i__32896 = G__32918;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__32920 = arguments.length;
switch (G__32920) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.call(null,cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?new cljs.core.Keyword("cljs.analyzer","externs","cljs.analyzer/externs",893359239).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)):null));
});

cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq.call(null,cljs.core.keys.call(null,externs));
while(true){
if(ks){
var k_32925 = cljs.core.first.call(null,ks);
var vec__32921_32926 = cljs.core.conj.call(null,prefix,k_32925);
var top_32927 = cljs.core.nth.call(null,vec__32921_32926,(0),null);
var prefix_SINGLEQUOTE__32928 = vec__32921_32926;
if((cljs.core.not_EQ_.call(null,new cljs.core.Symbol(null,"prototype","prototype",519166522,null),k_32925)) && ((cljs.core.get_in.call(null,known_externs,prefix_SINGLEQUOTE__32928) == null))){
if(!((cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,top_level),top_32927)) || (cljs.core.contains_QMARK_.call(null,known_externs,top_32927)))){
cljs.compiler.emitln.call(null,"var ",clojure.string.join.call(null,".",cljs.core.map.call(null,cljs.compiler.munge,prefix_SINGLEQUOTE__32928)),";");

cljs.core.swap_BANG_.call(null,top_level,cljs.core.conj,top_32927);
} else {
cljs.compiler.emitln.call(null,clojure.string.join.call(null,".",cljs.core.map.call(null,cljs.compiler.munge,prefix_SINGLEQUOTE__32928)),";");
}
} else {
}

var m_32929 = cljs.core.get.call(null,externs,k_32925);
if(cljs.core.empty_QMARK_.call(null,m_32929)){
} else {
cljs.compiler.emit_externs.call(null,prefix_SINGLEQUOTE__32928,m_32929,top_level,known_externs);
}

var G__32930 = cljs.core.next.call(null,ks);
ks = G__32930;
continue;
} else {
return null;
}
break;
}
});

cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4;

