// Compiled by ClojureScript 1.9.946 {}
goog.provide('markdown.core');
goog.require('cljs.core');
goog.require('markdown.common');
goog.require('markdown.links');
goog.require('markdown.transformers');
markdown.core.init_transformer = (function markdown$core$init_transformer(p__31062){
var map__31063 = p__31062;
var map__31063__$1 = ((((!((map__31063 == null)))?((((map__31063.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31063.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31063):map__31063);
var replacement_transformers = cljs.core.get.call(null,map__31063__$1,new cljs.core.Keyword(null,"replacement-transformers","replacement-transformers",-2028552897));
var custom_transformers = cljs.core.get.call(null,map__31063__$1,new cljs.core.Keyword(null,"custom-transformers","custom-transformers",1440601790));
var inhibit_separator = cljs.core.get.call(null,map__31063__$1,new cljs.core.Keyword(null,"inhibit-separator","inhibit-separator",1268116222));
return ((function (map__31063,map__31063__$1,replacement_transformers,custom_transformers,inhibit_separator){
return (function (html,line,next_line,state){
var _STAR_inhibit_separator_STAR_31065 = markdown.common._STAR_inhibit_separator_STAR_;
markdown.common._STAR_inhibit_separator_STAR_ = inhibit_separator;

try{var vec__31066 = cljs.core.reduce.call(null,((function (_STAR_inhibit_separator_STAR_31065,map__31063,map__31063__$1,replacement_transformers,custom_transformers,inhibit_separator){
return (function (p__31069,transformer){
var vec__31070 = p__31069;
var text = cljs.core.nth.call(null,vec__31070,(0),null);
var state__$1 = cljs.core.nth.call(null,vec__31070,(1),null);
return transformer.call(null,text,cljs.core.assoc.call(null,state__$1,new cljs.core.Keyword(null,"next-line","next-line",-1187000287),next_line));
});})(_STAR_inhibit_separator_STAR_31065,map__31063,map__31063__$1,replacement_transformers,custom_transformers,inhibit_separator))
,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [line,state], null),(function (){var or__8186__auto__ = replacement_transformers;
if(cljs.core.truth_(or__8186__auto__)){
return or__8186__auto__;
} else {
return cljs.core.into.call(null,markdown.transformers.transformer_vector,custom_transformers);
}
})());
var text = cljs.core.nth.call(null,vec__31066,(0),null);
var new_state = cljs.core.nth.call(null,vec__31066,(1),null);
html.append(text);

return new_state;
}finally {markdown.common._STAR_inhibit_separator_STAR_ = _STAR_inhibit_separator_STAR_31065;
}});
;})(map__31063,map__31063__$1,replacement_transformers,custom_transformers,inhibit_separator))
});
/**
 * Removed from cljs.core 0.0-1885, Ref. http://goo.gl/su7Xkj
 */
markdown.core.format = (function markdown$core$format(var_args){
var args__9364__auto__ = [];
var len__9357__auto___31075 = arguments.length;
var i__9358__auto___31076 = (0);
while(true){
if((i__9358__auto___31076 < len__9357__auto___31075)){
args__9364__auto__.push((arguments[i__9358__auto___31076]));

var G__31077 = (i__9358__auto___31076 + (1));
i__9358__auto___31076 = G__31077;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((1) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((1)),(0),null)):null);
return markdown.core.format.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9365__auto__);
});

markdown.core.format.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,args){
return cljs.core.apply.call(null,goog.string.format,fmt,args);
});

markdown.core.format.cljs$lang$maxFixedArity = (1);

markdown.core.format.cljs$lang$applyTo = (function (seq31073){
var G__31074 = cljs.core.first.call(null,seq31073);
var seq31073__$1 = cljs.core.next.call(null,seq31073);
return markdown.core.format.cljs$core$IFn$_invoke$arity$variadic(G__31074,seq31073__$1);
});

markdown.core.parse_references = (function markdown$core$parse_references(lines){
var references = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var seq__31078_31082 = cljs.core.seq.call(null,lines);
var chunk__31079_31083 = null;
var count__31080_31084 = (0);
var i__31081_31085 = (0);
while(true){
if((i__31081_31085 < count__31080_31084)){
var line_31086 = cljs.core._nth.call(null,chunk__31079_31083,i__31081_31085);
markdown.links.parse_reference_link.call(null,line_31086,references);

var G__31087 = seq__31078_31082;
var G__31088 = chunk__31079_31083;
var G__31089 = count__31080_31084;
var G__31090 = (i__31081_31085 + (1));
seq__31078_31082 = G__31087;
chunk__31079_31083 = G__31088;
count__31080_31084 = G__31089;
i__31081_31085 = G__31090;
continue;
} else {
var temp__4657__auto___31091 = cljs.core.seq.call(null,seq__31078_31082);
if(temp__4657__auto___31091){
var seq__31078_31092__$1 = temp__4657__auto___31091;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31078_31092__$1)){
var c__9025__auto___31093 = cljs.core.chunk_first.call(null,seq__31078_31092__$1);
var G__31094 = cljs.core.chunk_rest.call(null,seq__31078_31092__$1);
var G__31095 = c__9025__auto___31093;
var G__31096 = cljs.core.count.call(null,c__9025__auto___31093);
var G__31097 = (0);
seq__31078_31082 = G__31094;
chunk__31079_31083 = G__31095;
count__31080_31084 = G__31096;
i__31081_31085 = G__31097;
continue;
} else {
var line_31098 = cljs.core.first.call(null,seq__31078_31092__$1);
markdown.links.parse_reference_link.call(null,line_31098,references);

var G__31099 = cljs.core.next.call(null,seq__31078_31092__$1);
var G__31100 = null;
var G__31101 = (0);
var G__31102 = (0);
seq__31078_31082 = G__31099;
chunk__31079_31083 = G__31100;
count__31080_31084 = G__31101;
i__31081_31085 = G__31102;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref.call(null,references);
});
markdown.core.parse_footnotes = (function markdown$core$parse_footnotes(lines){
var footnotes = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"next-fn-id","next-fn-id",738579636),(1),new cljs.core.Keyword(null,"processed","processed",800622264),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"unprocessed","unprocessed",766771972),cljs.core.PersistentArrayMap.EMPTY], null));
var seq__31103_31107 = cljs.core.seq.call(null,lines);
var chunk__31104_31108 = null;
var count__31105_31109 = (0);
var i__31106_31110 = (0);
while(true){
if((i__31106_31110 < count__31105_31109)){
var line_31111 = cljs.core._nth.call(null,chunk__31104_31108,i__31106_31110);
markdown.links.parse_footnote_link.call(null,line_31111,footnotes);

var G__31112 = seq__31103_31107;
var G__31113 = chunk__31104_31108;
var G__31114 = count__31105_31109;
var G__31115 = (i__31106_31110 + (1));
seq__31103_31107 = G__31112;
chunk__31104_31108 = G__31113;
count__31105_31109 = G__31114;
i__31106_31110 = G__31115;
continue;
} else {
var temp__4657__auto___31116 = cljs.core.seq.call(null,seq__31103_31107);
if(temp__4657__auto___31116){
var seq__31103_31117__$1 = temp__4657__auto___31116;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31103_31117__$1)){
var c__9025__auto___31118 = cljs.core.chunk_first.call(null,seq__31103_31117__$1);
var G__31119 = cljs.core.chunk_rest.call(null,seq__31103_31117__$1);
var G__31120 = c__9025__auto___31118;
var G__31121 = cljs.core.count.call(null,c__9025__auto___31118);
var G__31122 = (0);
seq__31103_31107 = G__31119;
chunk__31104_31108 = G__31120;
count__31105_31109 = G__31121;
i__31106_31110 = G__31122;
continue;
} else {
var line_31123 = cljs.core.first.call(null,seq__31103_31117__$1);
markdown.links.parse_footnote_link.call(null,line_31123,footnotes);

var G__31124 = cljs.core.next.call(null,seq__31103_31117__$1);
var G__31125 = null;
var G__31126 = (0);
var G__31127 = (0);
seq__31103_31107 = G__31124;
chunk__31104_31108 = G__31125;
count__31105_31109 = G__31126;
i__31106_31110 = G__31127;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref.call(null,footnotes);
});
markdown.core.parse_metadata = (function markdown$core$parse_metadata(lines){
var vec__31129 = cljs.core.split_with.call(null,(function (p1__31128_SHARP_){
return cljs.core.not_empty.call(null,p1__31128_SHARP_.trim());
}),lines);
var metadata = cljs.core.nth.call(null,vec__31129,(0),null);
var lines__$1 = cljs.core.nth.call(null,vec__31129,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [markdown.transformers.parse_metadata_headers.call(null,metadata),lines__$1], null);
});
/**
 * processes input text line by line and outputs an HTML string
 */
markdown.core.md_to_html_string_STAR_ = (function markdown$core$md_to_html_string_STAR_(text,params){
var _STAR_substring_STAR_31132 = markdown.common._STAR_substring_STAR_;
var _STAR_formatter_STAR_31133 = markdown.transformers._STAR_formatter_STAR_;
markdown.common._STAR_substring_STAR_ = ((function (_STAR_substring_STAR_31132,_STAR_formatter_STAR_31133){
return (function (s,n){
return cljs.core.apply.call(null,cljs.core.str,cljs.core.drop.call(null,n,s));
});})(_STAR_substring_STAR_31132,_STAR_formatter_STAR_31133))
;

markdown.transformers._STAR_formatter_STAR_ = markdown.core.format;

try{var params__$1 = (cljs.core.truth_(params)?cljs.core.apply.call(null,cljs.core.partial.call(null,cljs.core.assoc,cljs.core.PersistentArrayMap.EMPTY),params):null);
var lines = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text),"\n"].join('').split("\n");
var html = (new goog.string.StringBuffer(""));
var references = (cljs.core.truth_(new cljs.core.Keyword(null,"reference-links?","reference-links?",-2003778981).cljs$core$IFn$_invoke$arity$1(params__$1))?markdown.core.parse_references.call(null,lines):null);
var footnotes = (cljs.core.truth_(new cljs.core.Keyword(null,"footnotes?","footnotes?",-1590157845).cljs$core$IFn$_invoke$arity$1(params__$1))?markdown.core.parse_footnotes.call(null,lines):null);
var vec__31134 = (cljs.core.truth_(new cljs.core.Keyword(null,"parse-meta?","parse-meta?",-1938948742).cljs$core$IFn$_invoke$arity$1(params__$1))?markdown.core.parse_metadata.call(null,lines):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,lines], null));
var metadata = cljs.core.nth.call(null,vec__31134,(0),null);
var lines__$1 = cljs.core.nth.call(null,vec__31134,(1),null);
var transformer = markdown.core.init_transformer.call(null,params__$1);
var G__31140_31147 = lines__$1;
var vec__31141_31148 = G__31140_31147;
var seq__31142_31149 = cljs.core.seq.call(null,vec__31141_31148);
var first__31143_31150 = cljs.core.first.call(null,seq__31142_31149);
var seq__31142_31151__$1 = cljs.core.next.call(null,seq__31142_31149);
var line_31152 = first__31143_31150;
var more_31153 = seq__31142_31151__$1;
var state_31154 = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"clojurescript","clojurescript",-299769403),true,new cljs.core.Keyword(null,"references","references",882562509),references,new cljs.core.Keyword(null,"footnotes","footnotes",-1842778205),footnotes,new cljs.core.Keyword(null,"last-line-empty?","last-line-empty?",1279111527),true], null),params__$1);
var G__31140_31155__$1 = G__31140_31147;
var state_31156__$1 = state_31154;
while(true){
var vec__31144_31157 = G__31140_31155__$1;
var seq__31145_31158 = cljs.core.seq.call(null,vec__31144_31157);
var first__31146_31159 = cljs.core.first.call(null,seq__31145_31158);
var seq__31145_31160__$1 = cljs.core.next.call(null,seq__31145_31158);
var line_31161__$1 = first__31146_31159;
var more_31162__$1 = seq__31145_31160__$1;
var state_31163__$2 = state_31156__$1;
var line_31164__$2 = (cljs.core.truth_(new cljs.core.Keyword(null,"skip-next-line?","skip-next-line?",1683617749).cljs$core$IFn$_invoke$arity$1(state_31163__$2))?"":line_31161__$1);
var state_31165__$3 = (cljs.core.truth_(new cljs.core.Keyword(null,"buf","buf",-213913340).cljs$core$IFn$_invoke$arity$1(state_31163__$2))?transformer.call(null,html,new cljs.core.Keyword(null,"buf","buf",-213913340).cljs$core$IFn$_invoke$arity$1(state_31163__$2),new cljs.core.Keyword(null,"next-line","next-line",-1187000287).cljs$core$IFn$_invoke$arity$1(state_31163__$2),cljs.core.assoc.call(null,cljs.core.dissoc.call(null,state_31163__$2,new cljs.core.Keyword(null,"buf","buf",-213913340),new cljs.core.Keyword(null,"lists","lists",-884730684),new cljs.core.Keyword(null,"next-line","next-line",-1187000287)),new cljs.core.Keyword(null,"last-line-empty?","last-line-empty?",1279111527),true)):state_31163__$2);
if(cljs.core.truth_(cljs.core.not_empty.call(null,more_31162__$1))){
var G__31166 = more_31162__$1;
var G__31167 = cljs.core.assoc.call(null,transformer.call(null,html,line_31164__$2,cljs.core.first.call(null,more_31162__$1),cljs.core.dissoc.call(null,state_31165__$3,new cljs.core.Keyword(null,"skip-next-line?","skip-next-line?",1683617749))),new cljs.core.Keyword(null,"last-line-empty?","last-line-empty?",1279111527),cljs.core.empty_QMARK_.call(null,line_31164__$2));
G__31140_31155__$1 = G__31166;
state_31156__$1 = G__31167;
continue;
} else {
transformer.call(null,html.append(markdown.transformers.footer.call(null,new cljs.core.Keyword(null,"footnotes","footnotes",-1842778205).cljs$core$IFn$_invoke$arity$1(state_31165__$3))),line_31164__$2,"",cljs.core.assoc.call(null,state_31165__$3,new cljs.core.Keyword(null,"eof","eof",-489063237),true));
}
break;
}

return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"metadata","metadata",1799301597),metadata,new cljs.core.Keyword(null,"html","html",-998796897),html.toString()], null);
}finally {markdown.transformers._STAR_formatter_STAR_ = _STAR_formatter_STAR_31133;

markdown.common._STAR_substring_STAR_ = _STAR_substring_STAR_31132;
}});
markdown.core.md__GT_html = (function markdown$core$md__GT_html(var_args){
var args__9364__auto__ = [];
var len__9357__auto___31170 = arguments.length;
var i__9358__auto___31171 = (0);
while(true){
if((i__9358__auto___31171 < len__9357__auto___31170)){
args__9364__auto__.push((arguments[i__9358__auto___31171]));

var G__31172 = (i__9358__auto___31171 + (1));
i__9358__auto___31171 = G__31172;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((1) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((1)),(0),null)):null);
return markdown.core.md__GT_html.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9365__auto__);
});

markdown.core.md__GT_html.cljs$core$IFn$_invoke$arity$variadic = (function (text,params){
return new cljs.core.Keyword(null,"html","html",-998796897).cljs$core$IFn$_invoke$arity$1(markdown.core.md_to_html_string_STAR_.call(null,text,params));
});

markdown.core.md__GT_html.cljs$lang$maxFixedArity = (1);

markdown.core.md__GT_html.cljs$lang$applyTo = (function (seq31168){
var G__31169 = cljs.core.first.call(null,seq31168);
var seq31168__$1 = cljs.core.next.call(null,seq31168);
return markdown.core.md__GT_html.cljs$core$IFn$_invoke$arity$variadic(G__31169,seq31168__$1);
});

markdown.core.md__GT_html_with_meta = (function markdown$core$md__GT_html_with_meta(var_args){
var args__9364__auto__ = [];
var len__9357__auto___31175 = arguments.length;
var i__9358__auto___31176 = (0);
while(true){
if((i__9358__auto___31176 < len__9357__auto___31175)){
args__9364__auto__.push((arguments[i__9358__auto___31176]));

var G__31177 = (i__9358__auto___31176 + (1));
i__9358__auto___31176 = G__31177;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((1) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((1)),(0),null)):null);
return markdown.core.md__GT_html_with_meta.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9365__auto__);
});

markdown.core.md__GT_html_with_meta.cljs$core$IFn$_invoke$arity$variadic = (function (text,params){
return markdown.core.md_to_html_string_STAR_.call(null,text,cljs.core.into.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"parse-meta?","parse-meta?",-1938948742),true], null),params));
});

markdown.core.md__GT_html_with_meta.cljs$lang$maxFixedArity = (1);

markdown.core.md__GT_html_with_meta.cljs$lang$applyTo = (function (seq31173){
var G__31174 = cljs.core.first.call(null,seq31173);
var seq31173__$1 = cljs.core.next.call(null,seq31173);
return markdown.core.md__GT_html_with_meta.cljs$core$IFn$_invoke$arity$variadic(G__31174,seq31173__$1);
});

/**
 * Js accessible wrapper
 */
markdown.core.mdToHtml = (function markdown$core$mdToHtml(var_args){
var args__9364__auto__ = [];
var len__9357__auto___31179 = arguments.length;
var i__9358__auto___31180 = (0);
while(true){
if((i__9358__auto___31180 < len__9357__auto___31179)){
args__9364__auto__.push((arguments[i__9358__auto___31180]));

var G__31181 = (i__9358__auto___31180 + (1));
i__9358__auto___31180 = G__31181;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((0) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((0)),(0),null)):null);
return markdown.core.mdToHtml.cljs$core$IFn$_invoke$arity$variadic(argseq__9365__auto__);
});
goog.exportSymbol('markdown.core.mdToHtml', markdown.core.mdToHtml);

markdown.core.mdToHtml.cljs$core$IFn$_invoke$arity$variadic = (function (params){
return cljs.core.apply.call(null,markdown.core.md__GT_html,params);
});

markdown.core.mdToHtml.cljs$lang$maxFixedArity = (0);

markdown.core.mdToHtml.cljs$lang$applyTo = (function (seq31178){
return markdown.core.mdToHtml.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq31178));
});

/**
 * Js accessible wrapper
 */
markdown.core.mdToHtmlWithMeta = (function markdown$core$mdToHtmlWithMeta(var_args){
var args__9364__auto__ = [];
var len__9357__auto___31183 = arguments.length;
var i__9358__auto___31184 = (0);
while(true){
if((i__9358__auto___31184 < len__9357__auto___31183)){
args__9364__auto__.push((arguments[i__9358__auto___31184]));

var G__31185 = (i__9358__auto___31184 + (1));
i__9358__auto___31184 = G__31185;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((0) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((0)),(0),null)):null);
return markdown.core.mdToHtmlWithMeta.cljs$core$IFn$_invoke$arity$variadic(argseq__9365__auto__);
});
goog.exportSymbol('markdown.core.mdToHtmlWithMeta', markdown.core.mdToHtmlWithMeta);

markdown.core.mdToHtmlWithMeta.cljs$core$IFn$_invoke$arity$variadic = (function (params){
return cljs.core.apply.call(null,markdown.core.md__GT_html_with_meta,params);
});

markdown.core.mdToHtmlWithMeta.cljs$lang$maxFixedArity = (0);

markdown.core.mdToHtmlWithMeta.cljs$lang$applyTo = (function (seq31182){
return markdown.core.mdToHtmlWithMeta.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq31182));
});

