// Compiled by ClojureScript 1.9.946 {}
goog.provide('grapple.nav');
goog.require('cljs.core');
goog.require('clojure.zip');
goog.require('re_frame.core');
grapple.nav.goto$ = (function grapple$nav$goto(loc,pred){
var loc__$1 = loc;
while(true){
if(cljs.core.truth_(clojure.zip.end_QMARK_.call(null,loc__$1))){
return loc__$1;
} else {
if(cljs.core.truth_(pred.call(null,clojure.zip.node.call(null,loc__$1)))){
return loc__$1;
} else {
var G__32576 = clojure.zip.next.call(null,loc__$1);
loc__$1 = G__32576;
continue;
}
}
break;
}
});
grapple.nav.move_left = (function grapple$nav$move_left(loc){
return clojure.zip.insert_left.call(null,clojure.zip.remove.call(null,loc),clojure.zip.node.call(null,loc));
});
grapple.nav.move_right = (function grapple$nav$move_right(loc){
return clojure.zip.insert_right.call(null,clojure.zip.right.call(null,clojure.zip.remove.call(null,loc)),clojure.zip.node.call(null,loc));
});
grapple.nav.cursor_up = (function grapple$nav$cursor_up(id,cm){
var cursor = cm.getCursor();
if((cursor.line === (0))){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("blocks","focus-previous","blocks/focus-previous",-1222966353),id,new cljs.core.Keyword("line","default","line/default",-1991693044)], null));
} else {
return CodeMirror.Pass;
}
});
grapple.nav.cursor_down = (function grapple$nav$cursor_down(id,cm){
var cursor = cm.getCursor();
var last_line = (cm.lineCount() - (1));
if(cljs.core._EQ_.call(null,last_line,cursor.line)){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("blocks","focus-next","blocks/focus-next",-509011718),id,new cljs.core.Keyword("line","default","line/default",-1991693044)], null));
} else {
return CodeMirror.Pass;
}
});
grapple.nav.cursor_left = (function grapple$nav$cursor_left(id,cm){
var cursor = cm.getCursor();
if(((cursor.line === (0))) && ((cursor.ch === (0)))){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("blocks","focus-previous","blocks/focus-previous",-1222966353),id,new cljs.core.Keyword("line","end","line/end",-269025650)], null));
} else {
return CodeMirror.Pass;
}
});
grapple.nav.cursor_right = (function grapple$nav$cursor_right(id,cm){
var cursor = cm.getCursor();
var last_line = (cm.lineCount() - (1));
var last_ch = cm.getLine(last_line).length;
if((cljs.core._EQ_.call(null,last_line,cursor.line)) && (cljs.core._EQ_.call(null,last_ch,cursor.ch))){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("blocks","focus-next","blocks/focus-next",-509011718),id,new cljs.core.Keyword("line","start","line/start",-352280353)], null));
} else {
return CodeMirror.Pass;
}
});
grapple.nav.current_word = (function grapple$nav$current_word(cm){
var sel = cm.findWordAt(cm.getCursor());
return cm.getRange(sel.anchor,sel.head);
});
grapple.nav.node_or_nil = (function grapple$nav$node_or_nil(loc){
if(cljs.core.truth_(loc)){
return clojure.zip.node.call(null,loc);
} else {
return null;
}
});
grapple.nav.block_before = (function grapple$nav$block_before(db,id){
return cljs.core.get.call(null,new cljs.core.Keyword("page","blocks","page/blocks",-611190360).cljs$core$IFn$_invoke$arity$1(db),grapple.nav.node_or_nil.call(null,clojure.zip.left.call(null,grapple.nav.goto$.call(null,clojure.zip.vector_zip.call(null,new cljs.core.Keyword("page","block-order","page/block-order",496949686).cljs$core$IFn$_invoke$arity$1(db)),(function (p1__32577_SHARP_){
return cljs.core._EQ_.call(null,id,p1__32577_SHARP_);
})))));
});
grapple.nav.block_after = (function grapple$nav$block_after(db,id){
return cljs.core.get.call(null,new cljs.core.Keyword("page","blocks","page/blocks",-611190360).cljs$core$IFn$_invoke$arity$1(db),grapple.nav.node_or_nil.call(null,clojure.zip.right.call(null,grapple.nav.goto$.call(null,clojure.zip.vector_zip.call(null,new cljs.core.Keyword("page","block-order","page/block-order",496949686).cljs$core$IFn$_invoke$arity$1(db)),(function (p1__32578_SHARP_){
return cljs.core._EQ_.call(null,id,p1__32578_SHARP_);
})))));
});
grapple.nav.ensure_next_block = (function grapple$nav$ensure_next_block(db,id,new_block_template,new_uuid){
var temp__4655__auto__ = grapple.nav.block_after.call(null,db,id);
if(cljs.core.truth_(temp__4655__auto__)){
var next_block = temp__4655__auto__;
return db;
} else {
var new_block = cljs.core.assoc.call(null,new_block_template,new cljs.core.Keyword("block","id","block/id",-1461684825),new_uuid,new cljs.core.Keyword("block","active?","block/active?",-444944723),true);
return cljs.core.update.call(null,cljs.core.update.call(null,db,new cljs.core.Keyword("page","blocks","page/blocks",-611190360),cljs.core.assoc,new_uuid,new_block),new cljs.core.Keyword("page","block-order","page/block-order",496949686),cljs.core.conj,new_uuid);
}
});
grapple.nav.insert_new_block = (function grapple$nav$insert_new_block(new_block_template,f){
return (function (p__32579,p__32580){
var map__32581 = p__32579;
var map__32581__$1 = ((((!((map__32581 == null)))?((((map__32581.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32581.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32581):map__32581);
var generate_uuid = cljs.core.get.call(null,map__32581__$1,new cljs.core.Keyword("generator","uuid","generator/uuid",-1664546130));
var db = cljs.core.get.call(null,map__32581__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__32582 = p__32580;
var _ = cljs.core.nth.call(null,vec__32582,(0),null);
var id = cljs.core.nth.call(null,vec__32582,(1),null);
var new_uuid = generate_uuid.call(null);
var new_block = cljs.core.assoc.call(null,new_block_template,new cljs.core.Keyword("block","id","block/id",-1461684825),new_uuid,new cljs.core.Keyword("block","active?","block/active?",-444944723),true);
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"db","db",993250759),cljs.core.update.call(null,cljs.core.update.call(null,db,new cljs.core.Keyword("page","blocks","page/blocks",-611190360),cljs.core.assoc,new_uuid,new_block),new cljs.core.Keyword("page","block-order","page/block-order",496949686),f,id,new_uuid)], null);
});
});
grapple.nav.activate = (function grapple$nav$activate(db,id){
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,db,new cljs.core.Keyword("page","blocks","page/blocks",-611190360),(function (blocks){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (p__32586){
var vec__32587 = p__32586;
var k = cljs.core.nth.call(null,vec__32587,(0),null);
var v = cljs.core.nth.call(null,vec__32587,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,cljs.core.assoc.call(null,v,new cljs.core.Keyword("block","active?","block/active?",-444944723),false)], null);
})),blocks);
})),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("page","blocks","page/blocks",-611190360),id,new cljs.core.Keyword("block","active?","block/active?",-444944723)], null),true);
});
