// Compiled by ClojureScript 1.9.946 {}
goog.provide('ajax.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('ajax.url');
goog.require('ajax.json');
goog.require('ajax.transit');
goog.require('ajax.ring');
goog.require('ajax.formats');
goog.require('ajax.util');
goog.require('ajax.interceptors');
goog.require('ajax.simple');
goog.require('ajax.easy');
goog.require('ajax.protocols');
goog.require('ajax.xhrio');
goog.require('ajax.xml_http_request');
ajax.core.to_interceptor = ajax.interceptors.to_interceptor;
ajax.core.abort = (function ajax$core$abort(this$){

return ajax.protocols._abort.call(null,this$);
});
ajax.core.json_request_format = ajax.json.json_request_format;
ajax.core.json_response_format = ajax.json.json_response_format;
ajax.core.transit_request_format = ajax.transit.transit_request_format;
ajax.core.transit_response_format = ajax.transit.transit_response_format;
ajax.core.ring_response_format = ajax.ring.ring_response_format;
ajax.core.url_request_format = ajax.url.url_request_format;
ajax.core.text_request_format = ajax.formats.text_request_format;
ajax.core.text_response_format = ajax.formats.text_response_format;
ajax.core.raw_response_format = ajax.formats.raw_response_format;
ajax.core.default_interceptors = ajax.simple.default_interceptors;
ajax.core.ajax_request = ajax.simple.ajax_request;
ajax.core.default_formats = ajax.easy.default_formats;
ajax.core.detect_response_format = ajax.easy.detect_response_format;
/**
 * accepts the URI and an optional map of options, options include:
 *      :handler - the handler function for successful operation
 *                 should accept a single parameter which is the
 *                 deserialized response
 *      :progress-handler - the handler function for progress events.
 *                          this handler is only available when using the goog.net.XhrIo API
 *      :error-handler - the handler function for errors, should accept a
 *                       map with keys :status and :status-text
 *      :format - the format for the request
 *      :response-format - the format for the response
 *      :params - a map of parameters that will be sent with the request
 */
ajax.core.GET = (function ajax$core$GET(var_args){
var args__9364__auto__ = [];
var len__9357__auto___30780 = arguments.length;
var i__9358__auto___30781 = (0);
while(true){
if((i__9358__auto___30781 < len__9357__auto___30780)){
args__9364__auto__.push((arguments[i__9358__auto___30781]));

var G__30782 = (i__9358__auto___30781 + (1));
i__9358__auto___30781 = G__30782;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((1) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((1)),(0),null)):null);
return ajax.core.GET.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9365__auto__);
});

ajax.core.GET.cljs$core$IFn$_invoke$arity$variadic = (function (uri,opts){
var f__30368__auto__ = cljs.core.first.call(null,opts);
return ajax.easy.easy_ajax_request.call(null,uri,"GET",(((f__30368__auto__ instanceof cljs.core.Keyword))?cljs.core.apply.call(null,cljs.core.hash_map,opts):f__30368__auto__));
});

ajax.core.GET.cljs$lang$maxFixedArity = (1);

ajax.core.GET.cljs$lang$applyTo = (function (seq30778){
var G__30779 = cljs.core.first.call(null,seq30778);
var seq30778__$1 = cljs.core.next.call(null,seq30778);
return ajax.core.GET.cljs$core$IFn$_invoke$arity$variadic(G__30779,seq30778__$1);
});

/**
 * accepts the URI and an optional map of options, options include:
 *      :handler - the handler function for successful operation
 *                 should accept a single parameter which is the
 *                 deserialized response
 *      :progress-handler - the handler function for progress events.
 *                          this handler is only available when using the goog.net.XhrIo API
 *      :error-handler - the handler function for errors, should accept a
 *                       map with keys :status and :status-text
 *      :format - the format for the request
 *      :response-format - the format for the response
 *      :params - a map of parameters that will be sent with the request
 */
ajax.core.HEAD = (function ajax$core$HEAD(var_args){
var args__9364__auto__ = [];
var len__9357__auto___30785 = arguments.length;
var i__9358__auto___30786 = (0);
while(true){
if((i__9358__auto___30786 < len__9357__auto___30785)){
args__9364__auto__.push((arguments[i__9358__auto___30786]));

var G__30787 = (i__9358__auto___30786 + (1));
i__9358__auto___30786 = G__30787;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((1) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((1)),(0),null)):null);
return ajax.core.HEAD.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9365__auto__);
});

ajax.core.HEAD.cljs$core$IFn$_invoke$arity$variadic = (function (uri,opts){
var f__30368__auto__ = cljs.core.first.call(null,opts);
return ajax.easy.easy_ajax_request.call(null,uri,"HEAD",(((f__30368__auto__ instanceof cljs.core.Keyword))?cljs.core.apply.call(null,cljs.core.hash_map,opts):f__30368__auto__));
});

ajax.core.HEAD.cljs$lang$maxFixedArity = (1);

ajax.core.HEAD.cljs$lang$applyTo = (function (seq30783){
var G__30784 = cljs.core.first.call(null,seq30783);
var seq30783__$1 = cljs.core.next.call(null,seq30783);
return ajax.core.HEAD.cljs$core$IFn$_invoke$arity$variadic(G__30784,seq30783__$1);
});

/**
 * accepts the URI and an optional map of options, options include:
 *      :handler - the handler function for successful operation
 *                 should accept a single parameter which is the
 *                 deserialized response
 *      :progress-handler - the handler function for progress events.
 *                          this handler is only available when using the goog.net.XhrIo API
 *      :error-handler - the handler function for errors, should accept a
 *                       map with keys :status and :status-text
 *      :format - the format for the request
 *      :response-format - the format for the response
 *      :params - a map of parameters that will be sent with the request
 */
ajax.core.POST = (function ajax$core$POST(var_args){
var args__9364__auto__ = [];
var len__9357__auto___30790 = arguments.length;
var i__9358__auto___30791 = (0);
while(true){
if((i__9358__auto___30791 < len__9357__auto___30790)){
args__9364__auto__.push((arguments[i__9358__auto___30791]));

var G__30792 = (i__9358__auto___30791 + (1));
i__9358__auto___30791 = G__30792;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((1) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((1)),(0),null)):null);
return ajax.core.POST.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9365__auto__);
});

ajax.core.POST.cljs$core$IFn$_invoke$arity$variadic = (function (uri,opts){
var f__30368__auto__ = cljs.core.first.call(null,opts);
return ajax.easy.easy_ajax_request.call(null,uri,"POST",(((f__30368__auto__ instanceof cljs.core.Keyword))?cljs.core.apply.call(null,cljs.core.hash_map,opts):f__30368__auto__));
});

ajax.core.POST.cljs$lang$maxFixedArity = (1);

ajax.core.POST.cljs$lang$applyTo = (function (seq30788){
var G__30789 = cljs.core.first.call(null,seq30788);
var seq30788__$1 = cljs.core.next.call(null,seq30788);
return ajax.core.POST.cljs$core$IFn$_invoke$arity$variadic(G__30789,seq30788__$1);
});

/**
 * accepts the URI and an optional map of options, options include:
 *      :handler - the handler function for successful operation
 *                 should accept a single parameter which is the
 *                 deserialized response
 *      :progress-handler - the handler function for progress events.
 *                          this handler is only available when using the goog.net.XhrIo API
 *      :error-handler - the handler function for errors, should accept a
 *                       map with keys :status and :status-text
 *      :format - the format for the request
 *      :response-format - the format for the response
 *      :params - a map of parameters that will be sent with the request
 */
ajax.core.PUT = (function ajax$core$PUT(var_args){
var args__9364__auto__ = [];
var len__9357__auto___30795 = arguments.length;
var i__9358__auto___30796 = (0);
while(true){
if((i__9358__auto___30796 < len__9357__auto___30795)){
args__9364__auto__.push((arguments[i__9358__auto___30796]));

var G__30797 = (i__9358__auto___30796 + (1));
i__9358__auto___30796 = G__30797;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((1) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((1)),(0),null)):null);
return ajax.core.PUT.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9365__auto__);
});

ajax.core.PUT.cljs$core$IFn$_invoke$arity$variadic = (function (uri,opts){
var f__30368__auto__ = cljs.core.first.call(null,opts);
return ajax.easy.easy_ajax_request.call(null,uri,"PUT",(((f__30368__auto__ instanceof cljs.core.Keyword))?cljs.core.apply.call(null,cljs.core.hash_map,opts):f__30368__auto__));
});

ajax.core.PUT.cljs$lang$maxFixedArity = (1);

ajax.core.PUT.cljs$lang$applyTo = (function (seq30793){
var G__30794 = cljs.core.first.call(null,seq30793);
var seq30793__$1 = cljs.core.next.call(null,seq30793);
return ajax.core.PUT.cljs$core$IFn$_invoke$arity$variadic(G__30794,seq30793__$1);
});

/**
 * accepts the URI and an optional map of options, options include:
 *      :handler - the handler function for successful operation
 *                 should accept a single parameter which is the
 *                 deserialized response
 *      :progress-handler - the handler function for progress events.
 *                          this handler is only available when using the goog.net.XhrIo API
 *      :error-handler - the handler function for errors, should accept a
 *                       map with keys :status and :status-text
 *      :format - the format for the request
 *      :response-format - the format for the response
 *      :params - a map of parameters that will be sent with the request
 */
ajax.core.DELETE = (function ajax$core$DELETE(var_args){
var args__9364__auto__ = [];
var len__9357__auto___30800 = arguments.length;
var i__9358__auto___30801 = (0);
while(true){
if((i__9358__auto___30801 < len__9357__auto___30800)){
args__9364__auto__.push((arguments[i__9358__auto___30801]));

var G__30802 = (i__9358__auto___30801 + (1));
i__9358__auto___30801 = G__30802;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((1) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((1)),(0),null)):null);
return ajax.core.DELETE.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9365__auto__);
});

ajax.core.DELETE.cljs$core$IFn$_invoke$arity$variadic = (function (uri,opts){
var f__30368__auto__ = cljs.core.first.call(null,opts);
return ajax.easy.easy_ajax_request.call(null,uri,"DELETE",(((f__30368__auto__ instanceof cljs.core.Keyword))?cljs.core.apply.call(null,cljs.core.hash_map,opts):f__30368__auto__));
});

ajax.core.DELETE.cljs$lang$maxFixedArity = (1);

ajax.core.DELETE.cljs$lang$applyTo = (function (seq30798){
var G__30799 = cljs.core.first.call(null,seq30798);
var seq30798__$1 = cljs.core.next.call(null,seq30798);
return ajax.core.DELETE.cljs$core$IFn$_invoke$arity$variadic(G__30799,seq30798__$1);
});

/**
 * accepts the URI and an optional map of options, options include:
 *      :handler - the handler function for successful operation
 *                 should accept a single parameter which is the
 *                 deserialized response
 *      :progress-handler - the handler function for progress events.
 *                          this handler is only available when using the goog.net.XhrIo API
 *      :error-handler - the handler function for errors, should accept a
 *                       map with keys :status and :status-text
 *      :format - the format for the request
 *      :response-format - the format for the response
 *      :params - a map of parameters that will be sent with the request
 */
ajax.core.OPTIONS = (function ajax$core$OPTIONS(var_args){
var args__9364__auto__ = [];
var len__9357__auto___30805 = arguments.length;
var i__9358__auto___30806 = (0);
while(true){
if((i__9358__auto___30806 < len__9357__auto___30805)){
args__9364__auto__.push((arguments[i__9358__auto___30806]));

var G__30807 = (i__9358__auto___30806 + (1));
i__9358__auto___30806 = G__30807;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((1) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((1)),(0),null)):null);
return ajax.core.OPTIONS.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9365__auto__);
});

ajax.core.OPTIONS.cljs$core$IFn$_invoke$arity$variadic = (function (uri,opts){
var f__30368__auto__ = cljs.core.first.call(null,opts);
return ajax.easy.easy_ajax_request.call(null,uri,"OPTIONS",(((f__30368__auto__ instanceof cljs.core.Keyword))?cljs.core.apply.call(null,cljs.core.hash_map,opts):f__30368__auto__));
});

ajax.core.OPTIONS.cljs$lang$maxFixedArity = (1);

ajax.core.OPTIONS.cljs$lang$applyTo = (function (seq30803){
var G__30804 = cljs.core.first.call(null,seq30803);
var seq30803__$1 = cljs.core.next.call(null,seq30803);
return ajax.core.OPTIONS.cljs$core$IFn$_invoke$arity$variadic(G__30804,seq30803__$1);
});

/**
 * accepts the URI and an optional map of options, options include:
 *      :handler - the handler function for successful operation
 *                 should accept a single parameter which is the
 *                 deserialized response
 *      :progress-handler - the handler function for progress events.
 *                          this handler is only available when using the goog.net.XhrIo API
 *      :error-handler - the handler function for errors, should accept a
 *                       map with keys :status and :status-text
 *      :format - the format for the request
 *      :response-format - the format for the response
 *      :params - a map of parameters that will be sent with the request
 */
ajax.core.TRACE = (function ajax$core$TRACE(var_args){
var args__9364__auto__ = [];
var len__9357__auto___30810 = arguments.length;
var i__9358__auto___30811 = (0);
while(true){
if((i__9358__auto___30811 < len__9357__auto___30810)){
args__9364__auto__.push((arguments[i__9358__auto___30811]));

var G__30812 = (i__9358__auto___30811 + (1));
i__9358__auto___30811 = G__30812;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((1) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((1)),(0),null)):null);
return ajax.core.TRACE.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9365__auto__);
});

ajax.core.TRACE.cljs$core$IFn$_invoke$arity$variadic = (function (uri,opts){
var f__30368__auto__ = cljs.core.first.call(null,opts);
return ajax.easy.easy_ajax_request.call(null,uri,"TRACE",(((f__30368__auto__ instanceof cljs.core.Keyword))?cljs.core.apply.call(null,cljs.core.hash_map,opts):f__30368__auto__));
});

ajax.core.TRACE.cljs$lang$maxFixedArity = (1);

ajax.core.TRACE.cljs$lang$applyTo = (function (seq30808){
var G__30809 = cljs.core.first.call(null,seq30808);
var seq30808__$1 = cljs.core.next.call(null,seq30808);
return ajax.core.TRACE.cljs$core$IFn$_invoke$arity$variadic(G__30809,seq30808__$1);
});

/**
 * accepts the URI and an optional map of options, options include:
 *      :handler - the handler function for successful operation
 *                 should accept a single parameter which is the
 *                 deserialized response
 *      :progress-handler - the handler function for progress events.
 *                          this handler is only available when using the goog.net.XhrIo API
 *      :error-handler - the handler function for errors, should accept a
 *                       map with keys :status and :status-text
 *      :format - the format for the request
 *      :response-format - the format for the response
 *      :params - a map of parameters that will be sent with the request
 */
ajax.core.PATCH = (function ajax$core$PATCH(var_args){
var args__9364__auto__ = [];
var len__9357__auto___30815 = arguments.length;
var i__9358__auto___30816 = (0);
while(true){
if((i__9358__auto___30816 < len__9357__auto___30815)){
args__9364__auto__.push((arguments[i__9358__auto___30816]));

var G__30817 = (i__9358__auto___30816 + (1));
i__9358__auto___30816 = G__30817;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((1) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((1)),(0),null)):null);
return ajax.core.PATCH.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9365__auto__);
});

ajax.core.PATCH.cljs$core$IFn$_invoke$arity$variadic = (function (uri,opts){
var f__30368__auto__ = cljs.core.first.call(null,opts);
return ajax.easy.easy_ajax_request.call(null,uri,"PATCH",(((f__30368__auto__ instanceof cljs.core.Keyword))?cljs.core.apply.call(null,cljs.core.hash_map,opts):f__30368__auto__));
});

ajax.core.PATCH.cljs$lang$maxFixedArity = (1);

ajax.core.PATCH.cljs$lang$applyTo = (function (seq30813){
var G__30814 = cljs.core.first.call(null,seq30813);
var seq30813__$1 = cljs.core.next.call(null,seq30813);
return ajax.core.PATCH.cljs$core$IFn$_invoke$arity$variadic(G__30814,seq30813__$1);
});

/**
 * accepts the URI and an optional map of options, options include:
 *      :handler - the handler function for successful operation
 *                 should accept a single parameter which is the
 *                 deserialized response
 *      :progress-handler - the handler function for progress events.
 *                          this handler is only available when using the goog.net.XhrIo API
 *      :error-handler - the handler function for errors, should accept a
 *                       map with keys :status and :status-text
 *      :format - the format for the request
 *      :response-format - the format for the response
 *      :params - a map of parameters that will be sent with the request
 */
ajax.core.PURGE = (function ajax$core$PURGE(var_args){
var args__9364__auto__ = [];
var len__9357__auto___30820 = arguments.length;
var i__9358__auto___30821 = (0);
while(true){
if((i__9358__auto___30821 < len__9357__auto___30820)){
args__9364__auto__.push((arguments[i__9358__auto___30821]));

var G__30822 = (i__9358__auto___30821 + (1));
i__9358__auto___30821 = G__30822;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((1) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((1)),(0),null)):null);
return ajax.core.PURGE.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9365__auto__);
});

ajax.core.PURGE.cljs$core$IFn$_invoke$arity$variadic = (function (uri,opts){
var f__30368__auto__ = cljs.core.first.call(null,opts);
return ajax.easy.easy_ajax_request.call(null,uri,"PURGE",(((f__30368__auto__ instanceof cljs.core.Keyword))?cljs.core.apply.call(null,cljs.core.hash_map,opts):f__30368__auto__));
});

ajax.core.PURGE.cljs$lang$maxFixedArity = (1);

ajax.core.PURGE.cljs$lang$applyTo = (function (seq30818){
var G__30819 = cljs.core.first.call(null,seq30818);
var seq30818__$1 = cljs.core.next.call(null,seq30818);
return ajax.core.PURGE.cljs$core$IFn$_invoke$arity$variadic(G__30819,seq30818__$1);
});

