(ns astrometrics.time)

(defn zero-time [d]
  (doto (js/Date.)
    (.setTime (.getTime d))
    (.setHours 0)
    (.setMinutes 0)
    (.setSeconds 0)
    (.setMilliseconds 0)))

(defn today []
  (zero-time (js/Date.)))

(defn seconds-after [d n]
  (let [d' (js/Date.)]
    (.setTime d' (+ (.getTime d) (* n 1000)))
    d'))

(defn date-range
  ([start stop] (date-range start stop 1))
  ([start stop step]
   (let [stop (zero-time stop)]
     (loop [d (zero-time start)
            ds []]
       (if (< (.getTime d) (.getTime stop))
         (let [d' (js/Date.)]
           (.setTime d' (.getTime d))
           (.setDate d' (+ step (.getDate d')))
           (recur d' (conj ds d')))
         ds)))))

(defn orbit-dates [d period]
  (let [n 60
        step (/ period n)]
    (->> d
      (iterate #(seconds-after % (- step)))
      (take (inc n)))))

(defn days->seconds [d]
  (* d 24 60 60))

(defn seconds->days-hours-minutes [s]
  (let [days (/ s 60 60 24)
        days' (int days)
        hours (* 24 (- days days'))
        hours' (int hours)
        minutes (* 60 (- hours hours'))]
    [days' hours' (math/round minutes)]))

(defn epoch
  ([y m d] (epoch y m d 12))
  ([y m d h]
   (js/Date. y (dec m) d h 0 0)))

(def J2000 (epoch 2000 1 1 12))
