(ns astrometrics.matrix)

(defn dot-product [a b]
  (reduce + (map * a b)))

(defn matrix-transform [m v]
  (map #(dot-product % v) m))

(defn rotate-x [θ]
  [[1 0       0]
   [0 (math/cos θ) (- (math/sin θ))]
   [0 (math/sin θ) (math/cos θ)]])

(defn rotate-y [θ]
  [[(math/cos θ)     0 (math/sin θ)]
   [0           1 0]
   [(- (math/sin θ)) 0 (math/cos θ)]])

(defn rotate-z [θ]
  [[(math/cos θ) (- (math/sin θ)) 0]
   [(math/sin θ) (math/cos θ)     0]
   [0       0           1]])
