(ns astrometrics.core
  (:require #?(:clj [clojure.edn :as edn] :cljs [cljs.reader :as edn])
            [math.core :as math]
            [astrometrics.conversion :as c]
            [astrometrics.time :as t]))

(def speed-of-light 2.998e8) ; m/s
(def gravitational-constant 6.6740831e-11)

(def reader-opts
  {:eof :eof
   :readers {'kg identity
             'm identity
             'deg c/deg->rad
             'days c/days->seconds
             'au c/au->meters
             'years c/years->seconds
             'epoch t/epoch}})

#?(:clj
   (defn read-forms [s]
     (with-open [in (java.io.PushbackReader. (java.io.StringReader. s))]
       (doall
         (take-while
           (complement #{:eof})
           (repeatedly (partial edn/read reader-opts in))))))
   :cljs
   (defn read-forms [s]
     (doall
       (take-while
         (complement #{:eof})
         (repeatedly (partial edn/read-string reader-opts s))))))
