(ns org.euandreh.misc.utils.config
  "Function utilities for handling configuration files.")

(defn read-config
  "Read the config edn file under `file-path`."
  [file-path]
  ((comp clojure.edn/read-string slurp clojure.java.io/resource) file-path))

(def default-config-path
  "The default config edn file path."
  "config.edn")

(defn assoc-config
  ([path val]
   (assoc-config default-config-path path val))
  ([config-path path val]
   (as-> config-path <>
     (clojure.java.io/resource <>)
     (slurp <>)
     (clojure.edn/read-string <>)
     (assoc-in <> path val)
     (spit (clojure.java.io/resource config-path) <>))))

(defn config [config-map env]
  (merge (:base config-map)
         (env config-map)))

(defn default-config-reader []
  (partial config (read-config default-config-path)))

(defmacro make-default-config [sym]
  (let [fn-name (with-meta sym {:arglists ''([environment-keyword])})]
    `(def ~fn-name
       "Return the custom config under `environment-keyword` value and merges it with the `:base` config in the file."
       (default-config-reader))))
