(ns org.euandreh.misc.edn.urx
  "edn readers and custom printers for `lambdaisland.uri.URI` and `cemerick.url.URL`."
  (:require lambdaisland.uri
            cemerick.url
            [clojure.spec.alpha :as s])
  (:import lambdaisland.uri.URI
           cemerick.url.URL))


;; URI

(def string->uri
  "Builds and `lambdaisland.uri.URI` instance from a given string.

   Used for custom edn tags, placed inside `data_readers.clj` file."
  lambdaisland.uri/parse)

(defmethod print-method URI [uri ^java.io.Writer writer]
  (.write writer "#uri ")
  (print-method (str uri) writer))

(defmethod print-dup URI [uri ^java.io.Writer writer]
  (.write writer "#uri ")
  (print-method (str uri) writer))


;; URL

(defmethod print-method URL [url ^java.io.Writer writer]
  (.write writer "#url ")
  (print-method (str url) writer))

(defmethod print-dup URL [url ^java.io.Writer writer]
  (.write writer "#url ")
  (print-method (str url) writer))

(s/fdef url?
  :args (s/cat :url any?)
  :ret boolean?)

(defn url?
  "Checks if the given input is a valid `cemerick.url.URL`."
  [x]
  (try
    (boolean (cemerick.url/url (str x)))
    (catch java.net.MalformedURLException e false)))

(s/fdef string->url
  :args (s/cat :url string?)
  :ret url?)

(def string->url
  "Builds and `cemerick.url.URL` instance from a given string.

   Used for custom edn tags, placed inside `data_readers.clj` file."
  cemerick.url/url)
