(defproject org.euandreh/http "0.1.5-SNAPSHOT"
  :description "Server-side common code and boilerplate."
  :url "https://gitlab.com/EuAndreh/org.euandreh.http"
  :license {:name         "GNU Affero General Public License"
            :url          "https://www.gnu.org/licenses/agpl-3.0.html"
            :distribution :repo}
  :min-lein-version "2.4.2"

  :plugins [[funcool/codeina "0.4.0"]
            [lein-cloverage "1.0.9"]
            [lein-kibit "0.1.5"]
            [lein-cljfmt "0.5.7"]
            [lein-ancient "0.6.15"]]

  :codeina {:sources        ["src"]
            :target         "public/api"
            :src-uri        "https://gitlab.com/EuAndreh/org.euandreh.http/blob/master/"
            :src-uri-prefix "#L"}

  :cljfmt {:indents {fdef         [[:block 1]]
                     for-all      [[:block 1]]
                     without-logs [[:block 0]]}}

  :dependencies [[org.clojure/clojure "1.9.0"]
                 [org.euandreh/misc "0.1.4"]
                 [org.clojure/test.check "0.9.0"]

                 ;; Pedestal
                 [io.pedestal/pedestal.service "0.5.4"]
                 [io.pedestal/pedestal.jetty "0.5.4"]
                 [ch.qos.logback/logback-classic "1.2.3"]

                 ;; Components
                 [com.stuartsierra/component "0.3.2"]
                 [tea-time "1.0.0"]

                 ;; Auth
                 [buddy "2.0.0"]]

  :profiles {:dev {:aliases      {"lint" ["do" "cljfmt" "check," "kibit"]
                                  "docs" ["do" "doc," "cloverage" "-o" "public/coverage"]}
                   :dependencies [[io.pedestal/pedestal.service-tools "0.5.4"]
                                  [expound "0.7.1"]
                                  [orchestra "2018.08.19-1"]]
                   :source-paths ["config"]
                   :repl-options {:init-ns user}}}

  :deploy-repositories [["releases" :clojars]])
