(ns org.euandreh.http.components.edn-file
  (:require [clojure.edn :as edn]
            [com.stuartsierra.component :as component]
            [org.euandreh.http.protocols.edn-file :as protocols.edn-file]))

(def default-ttl
  "5 minutes as the default TTL of the edn file cache."
  (* 1000 60 5))

(defrecord EdnFileImpl [config-file-path config-ttl-path config edn-file-fn]
  protocols.edn-file/IEdnFile
  (cached-content [this]
    ((deref (:memo-fn-atom this))))
  (refresh [this]
    (swap! (:memo-fn-atom this) (constantly (clojure.core.memoize/ttl (:edn-file-fn this) :ttl/threshold (:ttl this))))
    nil)
  component/Lifecycle
  (start [this]
    (let [ttl         (if config-ttl-path
                        (get-in config config-ttl-path default-ttl)
                        default-ttl)
          file        (get-in config config-file-path)
          lock        (Object.)
          edn-file-fn (fn []
                        (locking lock
                          (-> file slurp clojure.edn/read-string)))]
      (assoc this
             :edn-file-fn edn-file-fn
             :memo-fn-atom (atom (clojure.core.memoize/ttl edn-file-fn :ttl/threshold ttl))
             :ttl ttl)))
  (stop [this]
    (assoc this
           :edn-file-fn nil
           :memo-fn-atom nil
           :ttl nil)))
