(ns org.euandreh.http.components.datomic
  (:require [com.stuartsierra.component :as component]
            [datomic.api :as d]
            [org.euandreh.http.protocols.datomic :as protocols.datomic]))

(defrecord DatomicImpl [config config-path conn schemas]
  protocols.datomic/IDatomic
  (db [this]
    (d/db (:conn this)))
  (transactor [this]
    (:conn this))
  component/Lifecycle
  (start [this]
    (let [uri           (get-in config [:datomic-uri])
          new-database? (d/create-database uri)
          conn          (d/connect uri)]
      (when new-database?
        @(d/transact conn schemas))
      (assoc this :conn conn)))
  (stop [this]
    (when conn (d/release conn))
    (assoc this :conn nil)))
