(ns org.euandreh.http.components.crypto
  (:require [buddy.auth.backends :as auth.backends]
            [com.stuartsierra.component :as component]
            [org.euandreh.http.protocols.crypto :as protocols.crypto]))

(defn- epoch-seconds->date [n]
  (java.util.Date. (* 1000 n)))

(defn- jws-backend [public-key]
  (auth.backends/jws {:secret     public-key
                      :token-name "Bearer"
                      :options    {:alg :rs256}
                      :authfn     (fn [{:keys [exp iat scopes jti sub] :as claims}]
                                    (merge claims
                                           {:expires-at (epoch-seconds->date exp)
                                            :issued-at  (epoch-seconds->date iat)}))}))

(defrecord JWSCryptoImpl [config jwt-backend]
  protocols.crypto/ICrypto
  (backend [this]
    (:jws-backend this))
  component/Lifecycle
  (start [this]
    (let [public-key (-> config
                         (get-in [:auth-certificate-file])
                         clojure.java.io/resource
                         buddy.core.keys/public-key)]
      (assoc this :jws-backend (jws-backend public-key))))
  (stop [this]
    (assoc this :jws-backend nil)))
