(ns org.euandreh.http.components.edn-database
  (:require [com.stuartsierra.component :as component]
            [org.euandreh.http.protocols.edn-database :as protocols.edn-database]
            [org.euandreh.http.protocols.webapp-component :as protocols.webapp-component]))

(defrecord EdnDatabaseImpl [config-path config]
  protocols.edn-database/IEdnDatabase
  (read! [this]
    (let [path (protocols.edn-database/path this)]
      (if (.exists (clojure.java.io/as-file path))
        (-> path slurp clojure.edn/read-string)
        {})))
  (write! [this new-database]
    ;; Simple lock to synchronize writing to the file.
    (locking (:database-lock this)
      (spit (protocols.edn-database/path this) new-database)
      (swap! (:database-atom this) (constantly new-database)))

    (protocols.edn-database/db this))
  (path [_]
    (get-in config config-path))
  (db [this]
    @(:database-atom this))

  component/Lifecycle
  (start [this]
    (let [database-atom (atom (protocols.edn-database/read! this))]
      (.mkdirs (.getParentFile (clojure.java.io/as-file (protocols.edn-database/path this))))
      (assoc this
             :database-atom database-atom
             :database-lock (Object.))))
  (stop [this]
    (protocols.edn-database/write! this (protocols.edn-database/db this))
    (assoc this :database-atom nil))

  protocols.webapp-component/IWebAppComponent
  (webapp-component [this]))
