(ns org.euandre.om-auth.interceptors
  (:require [io.pedestal.interceptor :as i]
            [io.pedestal.interceptor.chain :as i.chain]
            [datomic.api :as d]
            [io.pedestal.http.body-params :as body-params]
            [clojure.spec.alpha :as s]
            [buddy.auth.middleware :as auth.middleware]
            [org.euandre.om-auth.components :as c]
            [org.euandre.om-auth.logic.auth :as logic.auth]
            [org.euandre.misc.exception :as exception]))

(def authentication-interceptor
  "Port of buddy-auth's wrap-authentication middleware."
  (io.pedestal.interceptor/interceptor
   {:name  ::authenticate
    :enter (fn [context]
             (let [jws-backend (get-in context [:request ::c/components :crypto :jws-backend])]
               (update context :request auth.middleware/authentication-request jws-backend)))}))

(def assert-valid-token
  (i/interceptor
   {:name  ::assert-valid-token
    :enter (fn [{{{:keys [db]} ::c/components :keys [identity]} :request :as context}]
             (when identity
               (logic.auth/assert-not-blacklisted! identity db))
             context)}))
