(defproject org.euandre/om-auth "1.0.0-SNAPSHOT"
  :description "Auth readers and mutations for Om.Next on top of Datomic."
  :url "https://gitlab.com/EuAndreh/org.euandre.om-auth"
  :license {:name         "GNU Affero General Public License"
            :url          "https://www.gnu.org/licenses/agpl-3.0.html"
            :distribution :repo}
  :min-lein-version "2.4.2"

  :plugins [[funcool/codeina "0.4.0"]
            [lein-cloverage "1.0.9"]
            [lein-kibit "0.1.5"]
            [lein-cljfmt "0.5.7"]
            [lein-ancient "0.6.15"]]

  :codeina {:sources        ["src"]
            :target         "public/api"
            :src-uri        "https://gitlab.com/EuAndreh/org.euandre.om-auth/blob/master/"
            :src-uri-prefix "#L"}

  :dependencies [[org.clojure/clojure "1.9.0"]

                 ;; Om.Next, Fulcro and Pathom
                 [org.omcljs/om "1.0.0-beta1"]
                 [org.clojure/clojurescript "1.9.946"]
                 [fulcrologic/fulcro "2.2.1"]
                 [com.wsscode/pathom "1.0.0-beta8-SNAPSHOT"]]

  :profiles {:dev {:aliases {"lint" ["do" "cljfmt" "check," "kibit"]}}}

  :deploy-repositories [["releases" :clojars]])
