(ns org.euandre.misc.spec
  (:require [clojure.spec.alpha :as s]))

(defn conform!
  "Same as s/conform, but throws when s/conform returns ::s/invalid"
  [spec x]
  (let [conformed (s/conform spec x)]
    (if (= conformed ::s/invalid)
      (throw (ex-info "Error conforming to spec "
                      {:explain-str  (with-out-str (s/explain spec x))
                       :explain-data (s/explain-data spec x)}))
      conformed)))
