(defproject org.euandre/misc "1.0.0"
  :description "Misc Clojure functions and utilities."
  :url "https://gitlab.com/EuAndreh/org.euandre.misc"
  :license {:name         "GNU Affero General Public License"
            :url          "https://www.gnu.org/licenses/agpl-3.0.html"
            :distribution :repo}
  :min-lein-version "2.4.2"

  :repositories [["clojars" {:url "https://clojars.org/repo/"
                             :username          [:gpg :env/clojars_username]
                             :password          [:gpg :env/clojars_password]
                              }]]

  :plugins [[funcool/codeina "0.5.0"]
            [lein-cloverage "1.0.9"]]

  :codeina {:sources        ["src"]
            :target         "public/api"
            :src-uri        "https://gitlab.com/EuAndreh/org.euandre.misc/blob/master/"
            :src-uri-prefix "#L"}

  :dependencies [[org.clojure/clojure "1.9.0-beta1"]
                 [lambdaisland/uri "1.1.0"]
                 [com.cemerick/url "0.1.1"]
                 [org.clojure/test.check "0.9.0"]]

  :deploy-repositories [["releases" :clojars]])
