(ns org.euandre.misc.edn.urx
  "edn readers and custom printers for `lambdaisland.uri.URI` and `cemerick.url.URL`."
  (:require lambdaisland.uri
            cemerick.url)
  (:import lambdaisland.uri.URI
           cemerick.url.URL))


;; URI

(def string->uri lambdaisland.uri/parse)

(defmethod print-method URI [uri ^java.io.Writer writer]
  (.write writer "#uri ")
  (print-method (str uri) writer))

(defmethod print-dup URI [uri ^java.io.Writer writer]
  (.write writer "#uri ")
  (print-method (str uri) writer))


;; URL

(def string->url cemerick.url/url)

(defmethod print-method URL [url ^java.io.Writer writer]
  (.write writer "#url ")
  (print-method (str url) writer))

(defmethod print-dup URL [url ^java.io.Writer writer]
  (.write writer "#url ")
  (print-method (str url) writer))

(defn url? [x]
  (try
    (cemerick.url/url (str x))
    (catch java.net.MalformedURLException e false)))

(defn url->java-uri [url]
  (java.net.URI. (str url)))
